/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;

public class CoreVersionPinner {
    IWorkerContext context;

    public CoreVersionPinner(IWorkerContext context) {
        this.context = context;
    }

    public void pinCoreVersions(List<CodeSystem> cslist, List<ValueSet> vslist, List<StructureDefinition> sdList) {
        for (CodeSystem cs : cslist) {
            this.pinCoreVersionVS(cs.getValueSetElement());
            this.pinCoreVersionCS(cs.getSupplementsElement());
        }
        for (ValueSet vs : vslist) {
            for (ValueSet.ConceptSetComponent vsi : vs.getCompose().getInclude()) {
                this.pinCoreVersions(vsi);
            }
            for (ValueSet.ConceptSetComponent vsi : vs.getCompose().getExclude()) {
                this.pinCoreVersions(vsi);
            }
        }
        for (StructureDefinition sd : sdList) {
            this.pinCoreVersionSD(sd.getBaseDefinitionElement());
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                this.pinCoreVersions(ed);
            }
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                this.pinCoreVersions(ed);
            }
        }
    }

    private void pinCoreVersions(ElementDefinition ed) {
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            for (CanonicalType ct : tr.getProfile()) {
                this.pinCoreVersionSD(ct);
            }
            for (CanonicalType ct : tr.getTargetProfile()) {
                this.pinCoreVersionSD(ct);
            }
        }
        for (CanonicalType ct : ed.getValueAlternatives()) {
            this.pinCoreVersionSD(ct);
        }
        if (ed.hasBinding()) {
            this.pinCoreVersionVS(ed.getBinding().getValueSetElement());
            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent adb : ed.getBinding().getAdditional()) {
                this.pinCoreVersionVS(adb.getValueSetElement());
            }
        }
    }

    private void pinCoreVersions(ValueSet.ConceptSetComponent vsi) {
        CodeSystem cs;
        for (CanonicalType ct : vsi.getValueSet()) {
            this.pinCoreVersionVS(ct);
        }
        if (vsi.hasSystem() && !vsi.hasVersion() && (cs = this.context.fetchResource(CodeSystem.class, vsi.getSystem())) != null && cs.hasVersion() && !vsi.getSystem().contains("terminology.hl7.org")) {
            vsi.setVersion(cs.getVersion());
            vsi.getVersionElement().setUserData("VERSION_PINNED_ON_LOAD", true);
        }
    }

    private void pinCoreVersionCS(CanonicalType ct) {
        CodeSystem cs;
        if (ct.hasValue() && !((String)ct.getValue()).contains("|") && !((String)ct.getValue()).contains("terminology.hl7.org") && (cs = this.context.fetchResource(CodeSystem.class, (String)ct.getValue())) != null && cs.hasVersion()) {
            ct.setValue((String)ct.getValue() + "|" + cs.getVersion());
            ct.setUserData("VERSION_PINNED_ON_LOAD", true);
        }
    }

    private void pinCoreVersionVS(CanonicalType ct) {
        ValueSet vs;
        if (ct.hasValue() && !((String)ct.getValue()).contains("|") && !((String)ct.getValue()).contains("terminology.hl7.org") && (vs = this.context.fetchResource(ValueSet.class, (String)ct.getValue())) != null && vs.hasVersion()) {
            ct.setValue((String)ct.getValue() + "|" + vs.getVersion());
            ct.setUserData("VERSION_PINNED_ON_LOAD", true);
        }
    }

    private void pinCoreVersionSD(CanonicalType ct) {
        StructureDefinition sd;
        if (ct.hasValue() && !((String)ct.getValue()).contains("|") && (sd = this.context.fetchResource(StructureDefinition.class, (String)ct.getValue())) != null && sd.hasVersion()) {
            ct.setValue((String)ct.getValue() + "|" + sd.getVersion());
            ct.setUserData("VERSION_PINNED_ON_LOAD", true);
        }
    }
}

