/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import ca.uhn.fhir.parser.DataFormatException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.BaseWorkerContext;
import org.hl7.fhir.r5.context.CanonicalResourceManager;
import org.hl7.fhir.r5.context.HTMLClientLogger;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.Slf4JLoggingService;
import org.hl7.fhir.r5.context.TextClientLogger;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.terminologies.JurisdictionUtilities;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientR5;
import org.hl7.fhir.r5.utils.R5Hacker;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.r5.utils.xver.XVerExtensionManager;
import org.hl7.fhir.r5.utils.xver.XVerExtensionManagerFactory;
import org.hl7.fhir.utilities.ByteProvider;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MagicResources;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.CSFileInputStream;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public class SimpleWorkerContext
extends BaseWorkerContext
implements IWorkerContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleWorkerContext.class);
    private Questionnaire questionnaire;
    private String revision;
    private String date;
    private IValidatorFactory validatorFactory;
    private boolean progress;
    private final List<String> loadedPackages = new ArrayList<String>();
    private boolean canNoTS;
    private XVerExtensionManager xverManager;
    private boolean allowLazyLoading = true;

    private SimpleWorkerContext() throws IOException, FHIRException {
    }

    private SimpleWorkerContext(Locale locale) throws IOException, FHIRException {
        super(locale);
    }

    public SimpleWorkerContext(SimpleWorkerContext other) throws IOException, FHIRException {
        this.copy(other);
    }

    private SimpleWorkerContext(SimpleWorkerContext other, Locale locale) throws IOException, FHIRException {
        super(locale);
        this.copy(other);
    }

    protected void copy(SimpleWorkerContext other) {
        super.copy(other);
        this.binaries.putAll(other.binaries);
        this.version = other.version;
        this.revision = other.revision;
        this.date = other.date;
        this.validatorFactory = other.validatorFactory;
        this.progress = other.progress;
        this.loadedPackages.addAll(other.loadedPackages);
        this.canNoTS = other.canNoTS;
        this.xverManager = other.xverManager;
        this.allowLazyLoading = other.allowLazyLoading;
        this.questionnaire = other.questionnaire;
    }

    public List<String> getLoadedPackages() {
        return this.loadedPackages;
    }

    private Resource loadDefinitionItem(String name, InputStream stream, IContextResourceLoader loader, ILoadFilter filter, PackageInformation pi) throws IOException, FHIRException {
        if (name.endsWith(".xml")) {
            return this.loadFromFile(stream, name, loader, filter);
        }
        if (name.endsWith(".json")) {
            return this.loadFromFileJson(stream, name, loader, filter, pi);
        }
        if (name.equals("version.info")) {
            this.readVersionInfo(stream);
        } else {
            this.binaries.put(name, new BaseWorkerContext.BytesProvider(FileUtilities.streamToBytesNoClose((InputStream)stream)));
        }
        return null;
    }

    public void connectToTSServer(TerminologyClientManager.ITerminologyClientFactory factory, ITerminologyClient client, boolean useEcosystem) {
        this.terminologyClientManager.setFactory(factory);
        if (this.txLog == null) {
            this.txLog = client.getLogger();
        }
        try {
            this.terminologyClientManager.setMasterClient(client, useEcosystem);
            this.txLog("Connect to " + client.getAddress());
        }
        catch (Exception e) {
            if (this.canRunWithoutTerminology) {
                this.noTerminologyServer = true;
                this.logger.logMessage("==============!! Running without terminology server !! ==============");
                if (this.terminologyClientManager.getMasterClient() != null) {
                    this.logger.logMessage("txServer = " + this.terminologyClientManager.getMasterClient().getId());
                    this.logger.logMessage("Error = " + e.getMessage());
                }
                this.logger.logMessage("=====================================================================");
            }
            e.printStackTrace();
            throw new TerminologyServiceException((Throwable)e);
        }
    }

    public void connectToTSServer(TerminologyClientManager.ITerminologyClientFactory factory, String address, String software, String log, boolean useEcosystem) {
        try {
            this.terminologyClientManager.setFactory(factory);
            if (log != null) {
                if (log.endsWith(".htm") || log.endsWith(".html")) {
                    this.txLog = new HTMLClientLogger(log);
                } else if (log.endsWith(".txt") || log.endsWith(".log")) {
                    this.txLog = new TextClientLogger(log);
                } else {
                    throw new IllegalArgumentException("Unknown extension for text file logging: \"" + log + "\" expected: .html, .htm, .txt or .log");
                }
            }
            ITerminologyClient client = factory.makeClient("tx-server", ManagedWebAccess.makeSecureRef((String)address), software, this.txLog);
            this.connectToTSServer(factory, client, useEcosystem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FHIRException(this.formatMessage(this.canNoTS ? "Unable_to_connect_to_terminology_server_Use_parameter_tx_na_tun_run_without_using_terminology_services_to_validate_LOINC_SNOMED_ICDX_etc_Error__" : "Unable_to_connect_to_terminology_server", new Object[]{e.getMessage(), address}), (Throwable)e);
        }
    }

    public void loadFromFile(InputStream stream, String name, IContextResourceLoader loader) throws FHIRException {
        this.loadFromFile(stream, name, loader, null);
    }

    public Resource loadFromFile(InputStream stream, String name, IContextResourceLoader loader, ILoadFilter filter) throws FHIRException {
        Resource f;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, false);
            } else {
                XmlParser xml = new XmlParser();
                f = xml.parse(stream);
            }
        }
        catch (DataFormatException e1) {
            throw new FHIRFormatError(this.formatMessage("Error_parsing_", new Object[]{name, e1.getMessage()}), (Throwable)e1);
        }
        catch (Exception e1) {
            throw new FHIRFormatError(this.formatMessage("Error_parsing_", new Object[]{name, e1.getMessage()}), (Throwable)e1);
        }
        if (f instanceof Bundle) {
            Resource bnd = f;
            for (Bundle.BundleEntryComponent e : ((Bundle)bnd).getEntry()) {
                String path;
                if (e.getFullUrl() == null) {
                    this.logger.logDebugMessage(ILoggingService.LogCategory.CONTEXT, "unidentified resource in " + name + " (no fullUrl)");
                }
                if (filter != null && !filter.isOkToLoad(e.getResource())) continue;
                String string = path = loader != null ? loader.getResourcePath(e.getResource()) : null;
                if (path != null) {
                    e.getResource().setWebPath(path);
                }
                this.cacheResource(e.getResource());
            }
        } else if (f instanceof CanonicalResource && (filter == null || filter.isOkToLoad(f))) {
            String path;
            String string = path = loader != null ? loader.getResourcePath(f) : null;
            if (path != null) {
                f.setWebPath(path);
            }
            this.cacheResource(f);
        }
        return f;
    }

    private Resource loadFromFileJson(InputStream stream, String name, IContextResourceLoader loader, ILoadFilter filter, PackageInformation pi) throws IOException, FHIRException {
        Bundle f = null;
        try {
            if (loader != null) {
                f = loader.loadBundle(stream, true);
            } else {
                JsonParser json = new JsonParser();
                Resource r = json.parse(stream);
                if (r instanceof Bundle) {
                    f = (Bundle)r;
                } else if (filter == null || filter.isOkToLoad(f)) {
                    this.cacheResourceFromPackage(r, pi);
                }
            }
        }
        catch (FHIRFormatError e1) {
            throw new FHIRFormatError(e1.getMessage(), (Throwable)e1);
        }
        if (f != null) {
            for (Bundle.BundleEntryComponent e : f.getEntry()) {
                String path;
                if (filter != null && !filter.isOkToLoad(e.getResource())) continue;
                String string = path = loader != null ? loader.getResourcePath(e.getResource()) : null;
                if (path != null) {
                    e.getResource().setWebPath(path);
                }
                this.cacheResourceFromPackage(e.getResource(), pi);
            }
        }
        return f;
    }

    private void loadFromPack(String path, IContextResourceLoader loader) throws IOException, FHIRException {
        this.loadFromStream((InputStream)new CSFileInputStream(path), loader);
    }

    @Override
    public int loadFromPackage(NpmPackage pi, IContextResourceLoader loader) throws IOException, FHIRException {
        return this.loadFromPackageInt(pi, loader, loader == null ? SimpleWorkerContext.defaultTypesToLoad() : loader.getTypes());
    }

    public static Set<String> defaultTypesToLoad() {
        return Utilities.stringSet((String[])new String[]{"CodeSystem", "ValueSet", "ConceptMap", "NamingSystem", "StructureDefinition", "StructureMap", "SearchParameter", "OperationDefinition", "CapabilityStatement", "Conformance", "Questionnaire", "ImplementationGuide", "Measure"});
    }

    @Override
    public int loadFromPackageAndDependencies(NpmPackage pi, IContextResourceLoader loader, BasePackageCacheManager pcm) throws IOException, FHIRException {
        return this.loadFromPackageAndDependenciesInt(pi, loader, pcm, pi.name() + "#" + pi.version());
    }

    public int loadFromPackageAndDependenciesInt(NpmPackage pi, IContextResourceLoader loader, BasePackageCacheManager pcm, String path) throws IOException, FHIRException {
        int t = 0;
        for (String e : pi.dependencies()) {
            if (this.loadedPackages.contains(e) || VersionUtilities.isCorePackage((String)e)) continue;
            NpmPackage npm = pcm.loadPackage(e);
            if (!VersionUtilities.versionMatches((String)this.version, (String)npm.fhirVersion())) {
                log.info(this.formatMessage("PACKAGE_VERSION_MISMATCH", new Object[]{e, this.version, npm.fhirVersion(), path}));
            }
            t += this.loadFromPackageAndDependenciesInt(npm, loader.getNewLoader(npm), pcm, path + " -> " + npm.name() + "#" + npm.version());
        }
        return t += this.loadFromPackageInt(pi, loader, loader.getTypes());
    }

    public int loadFromPackageInt(NpmPackage pi, IContextResourceLoader loader, Set<String> types) throws IOException, FHIRException {
        String of;
        int t = 0;
        if (this.progress) {
            log.info("Load Package " + pi.name() + "#" + pi.version());
        }
        if (this.loadedPackages.contains(pi.id() + "#" + pi.version())) {
            return 0;
        }
        this.loadedPackages.add(pi.id() + "#" + pi.version());
        if (this.packageTracker != null) {
            this.packageTracker.packageLoaded(pi.id(), pi.version());
        }
        if ((of = ((NpmPackage.NpmPackageFolder)pi.getFolders().get("package")).getFolderPath()) != null) {
            this.oidSources.add(new BaseWorkerContext.OIDSource(of, pi.vid()));
        }
        if ((types == null || types.size() == 0) && loader != null) {
            types = loader.getTypes();
        }
        boolean hasIG = false;
        PackageInformation pii = new PackageInformation(pi);
        if (VersionUtilities.isR2Ver((String)pi.fhirVersion()) || !pi.canLazyLoad() || !this.allowLazyLoading) {
            if (types == null || types.size() == 0) {
                types = Utilities.stringSet((String[])new String[]{"ImplementationGuide", "StructureDefinition", "ValueSet", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem"});
            }
            for (String s : pi.listResources(types)) {
                try {
                    Resource r = this.loadDefinitionItem(s, pi.load("package", s), loader, null, pii);
                    if (r != null) {
                        hasIG = "ImplementationGuide".equals(r.fhirType()) || hasIG;
                    }
                    ++t;
                }
                catch (Exception e) {
                    throw new FHIRException(this.formatMessage("Error_reading__from_package__", new Object[]{s, pi.name(), pi.version(), e.getMessage()}), (Throwable)e);
                }
            }
        } else {
            if (types == null || types.size() == 0) {
                types = Utilities.stringSet((String[])new String[]{"ImplementationGuide", "StructureDefinition", "ValueSet", "CodeSystem", "SearchParameter", "OperationDefinition", "Questionnaire", "ConceptMap", "StructureMap", "NamingSystem", "Measure"});
            }
            types.add((String)"ImplementationGuide");
            if (loader != null) {
                types = loader.reviewActualTypes(types);
            }
            for (NpmPackage.PackageResourceInformation pri : pi.listIndexedResources(types)) {
                if (pri.getFilename().contains("ig-r4") || loader != null && !loader.wantLoad(pi, pri)) continue;
                try {
                    boolean bl = hasIG = "ImplementationGuide".equals(pri.getResourceType()) || hasIG;
                    if (!pri.hasId()) {
                        this.loadDefinitionItem(pri.getFilename(), ManagedFileAccess.inStream((String)pri.getFilename()), loader, null, pii);
                    } else {
                        PackageResourceLoader pl = new PackageResourceLoader(pri, loader, pii);
                        if (loader != null) {
                            pl = loader.editInfo(pl);
                        }
                        if (pl != null) {
                            this.registerResourceFromPackage(pl, pii);
                        }
                    }
                    ++t;
                }
                catch (FHIRException e) {
                    throw new FHIRException(this.formatMessage("Error_reading__from_package__", new Object[]{pri.getFilename(), pi.name(), pi.version(), e.getMessage()}), (Throwable)e);
                }
            }
        }
        if (!hasIG && !pi.isCore()) {
            try {
                this.registerResourceFromPackage(this.makeIgResource(pi), pii);
            }
            catch (Exception e) {
                log.error("Problem constructing IG for " + pi.vid() + ": " + e.getMessage());
            }
        }
        for (String s : pi.list("other")) {
            this.binaries.put(s, new BaseWorkerContext.BytesFromPackageProvider(pi, s));
        }
        if (this.version == null) {
            this.version = pi.version();
            if (this.version.equals("current")) {
                this.version = "5.0.0";
            }
        }
        if (loader != null && this.terminologyClientManager.getFactory() == null) {
            this.terminologyClientManager.setFactory(loader.txFactory());
        }
        return t;
    }

    private CanonicalResourceManager.CanonicalResourceProxy makeIgResource(NpmPackage pi) {
        ImplementationGuide ig = new ImplementationGuide();
        ig.setId(pi.name());
        ig.setVersion(pi.version());
        ig.setUrl(this.makeIgUrl(pi));
        ig.setUserData("IG_FAKE", true);
        InternalCanonicalResourceProxy res = new InternalCanonicalResourceProxy(ig.fhirType(), ig.getId(), ig.getUrl(), ig.getVersion());
        res.setResource(ig);
        return res;
    }

    private String makeIgUrl(NpmPackage pi) {
        switch (pi.name()) {
            case "hl7.fhir.pubpack": {
                return "http://hl7.org/fhir/pubpack/ImplementationGuide/hl7.fhir.pubpack";
            }
            case "hl7.fhir.xver-extensions": {
                return "http://hl7.org/fhir/xver-extensions/ImplementationGuide/hl7.fhir.xver-extensions";
            }
            case "us.nlm.vsac": {
                return "http://fhir.org/packages/us.nlm.vsac/ImplementationGuide/us.nlm.vsac";
            }
            case "us.cdc.phinvads": {
                return "https://phinvads.cdc.gov/vads/fhir/ImplementationGuide/us.cdc.phinvads";
            }
            case "hl7.fhir.us.core.v610": {
                return "http://hl7.org/fhir/us/core/v610/ImplementationGuide/hl7.fhir.us.core.v610";
            }
            case "hl7.fhir.us.core.v311": {
                return "http://hl7.org/fhir/us/core/v311/ImplementationGuide/hl7.fhir.us.core.v311";
            }
            case "fhir.dicom": {
                return "http://fhir.org/packages/fhir.dicom/ImplementationGuide/fhir.dicom";
            }
        }
        if (pi.name() != null && pi.canonical() != null) {
            return Utilities.pathURL((String[])new String[]{pi.canonical(), "ImplementationGuide", pi.name()});
        }
        throw new FHIRException("No IG canonical can be determined for package: " + pi.name() + "#" + pi.version());
    }

    public void loadFromFile(String file, IContextResourceLoader loader) throws IOException, FHIRException {
        this.loadDefinitionItem(file, (InputStream)new CSFileInputStream(file), loader, null, null);
    }

    private void loadFromStream(InputStream stream, IContextResourceLoader loader) throws IOException, FHIRException {
        ZipEntry zipEntry;
        ZipInputStream zip = new ZipInputStream(stream);
        while ((zipEntry = zip.getNextEntry()) != null) {
            String entryName = zipEntry.getName();
            if (entryName.contains("..")) {
                throw new RuntimeException("Entry with an illegal path: " + entryName);
            }
            this.loadDefinitionItem(entryName, zip, loader, null, null);
            zip.closeEntry();
        }
        zip.close();
    }

    private void readVersionInfo(InputStream stream) throws IOException, DefinitionException {
        String[] vi;
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        this.binaries.put("version.info", new BaseWorkerContext.BytesProvider(bytes));
        for (String s : vi = new String(bytes).split("\\r?\\n")) {
            if (s.startsWith("version=")) {
                if (this.version == null) {
                    this.version = s.substring(8);
                } else if (!this.version.equals(s.substring(8))) {
                    throw new DefinitionException(this.formatMessage("Version_mismatch_The_context_has_version__loaded_and_the_new_content_being_loaded_is_version_", new Object[]{this.version, s.substring(8)}));
                }
            }
            if (s.startsWith("revision=")) {
                this.revision = s.substring(9);
            }
            if (!s.startsWith("date=")) continue;
            this.date = s.substring(5);
        }
    }

    @Override
    public IResourceValidator newValidator() throws FHIRException {
        if (this.validatorFactory == null) {
            throw new Error(this.formatMessage("No_validator_configured", new Object[0]));
        }
        return this.validatorFactory.makeValidator(this, this.xverManager, null).setJurisdiction(JurisdictionUtilities.getJurisdictionCodingFromLocale(Locale.getDefault().getCountry()));
    }

    @Override
    public List<String> getResourceNames() {
        HashSet<String> result = new HashSet<String>();
        for (StructureDefinition sd : this.listStructures()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.hasUserData("old.load.mode")) continue;
            result.add(sd.getName());
        }
        return Utilities.sorted(result);
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    public void loadBinariesFromFolder(String folder) throws IOException {
        for (String n : ManagedFileAccess.file((String)folder).list()) {
            this.binaries.put(n, new BaseWorkerContext.BytesFromFileProvider(Utilities.path((String[])new String[]{folder, n})));
        }
    }

    public void loadBinariesFromFolder(NpmPackage pi) throws IOException {
        for (String n : pi.list("other")) {
            this.binaries.put(n, new BaseWorkerContext.BytesFromPackageProvider(pi, n));
        }
    }

    public void loadFromFolder(String folder) throws IOException {
        for (String n : ManagedFileAccess.file((String)folder).list()) {
            if (n.endsWith(".json")) {
                this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new JsonParser());
                continue;
            }
            if (!n.endsWith(".xml")) continue;
            this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new XmlParser());
        }
    }

    private void loadFromFile(String filename, IParser p) {
        try {
            Resource r = p.parse(ManagedFileAccess.inStream((String)filename));
            if (r.getResourceType() == ResourceType.Bundle) {
                for (Bundle.BundleEntryComponent e : ((Bundle)r).getEntry()) {
                    this.cacheResource(e.getResource());
                }
            } else {
                this.cacheResource(r);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public List<StructureMap> findTransformsforSource(String url) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        for (StructureMap map : this.fetchResourcesByType(StructureMap.class)) {
            boolean match = false;
            boolean ok = true;
            for (StructureMap.StructureMapStructureComponent t : map.getStructure()) {
                if (t.getMode() != StructureMap.StructureMapModelMode.SOURCE) continue;
                match = match || t.getUrl().equals(url);
                ok = ok && t.getUrl().equals(url);
            }
            if (!match || !ok) continue;
            res.add(map);
        }
        return res;
    }

    public IValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(IValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        T r = super.fetchResource(class_, uri);
        if (r instanceof StructureDefinition) {
            StructureDefinition p = (StructureDefinition)r;
            try {
                this.cutils.generateSnapshot(p);
            }
            catch (Exception e) {
                log.error("Unable to generate snapshot @3 for " + uri + ": " + e.getMessage());
                this.logger.logDebugMessage(ILoggingService.LogCategory.GENERATE, ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return r;
    }

    @Override
    public <T extends Resource> T fetchResourceRaw(Class<T> class_, String uri) {
        T r = super.fetchResource(class_, uri);
        return r;
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri, Resource source) {
        T resource = super.fetchResource(class_, uri, source);
        if (resource instanceof StructureDefinition) {
            StructureDefinition structureDefinition = (StructureDefinition)resource;
            this.generateSnapshot(structureDefinition, "4");
        }
        return resource;
    }

    public String listMapUrls() {
        return Utilities.listCanonicalUrls(this.transforms.keys());
    }

    public boolean isProgress() {
        return this.progress;
    }

    public void setProgress(boolean progress) {
        this.progress = progress;
    }

    public void setClock(TimeTracker tt) {
        this.clock = tt;
    }

    public boolean isCanNoTS() {
        return this.canNoTS;
    }

    public void setCanNoTS(boolean canNoTS) {
        this.canNoTS = canNoTS;
    }

    public XVerExtensionManager getXVer() {
        if (this.xverManager == null) {
            this.xverManager = XVerExtensionManagerFactory.createExtensionManager(this);
        }
        return this.xverManager;
    }

    @Override
    public void cachePackage(PackageInformation packageInfo) {
    }

    @Override
    public boolean hasPackage(String id, String ver) {
        if (ver == null) {
            for (String p : this.loadedPackages) {
                if (!p.startsWith(id + "#")) continue;
                return true;
            }
            return false;
        }
        return this.loadedPackages.contains(id + "#" + ver);
    }

    public boolean hasPackage(String idAndver) {
        if (this.loadedPackages.contains(idAndver)) {
            return true;
        }
        if (idAndver.startsWith("hl7.fhir.uv.extensions")) {
            String v = idAndver.substring(idAndver.lastIndexOf("#") + 1);
            for (String s : this.loadedPackages) {
                String v2 = s.substring(s.lastIndexOf("#") + 1);
                if (!s.startsWith("hl7.fhir.uv.extensions.") || !VersionUtilities.versionMatches((String)v, (String)v2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasPackage(PackageInformation pack) {
        return false;
    }

    @Override
    public PackageInformation getPackage(String id, String ver) {
        return null;
    }

    public boolean isAllowLazyLoading() {
        return this.allowLazyLoading;
    }

    public void setAllowLazyLoading(boolean allowLazyLoading) {
        this.allowLazyLoading = allowLazyLoading;
    }

    public String loadedPackageSummary() {
        return this.loadedPackages.toString();
    }

    @Override
    public String getSpecUrl() {
        return VersionUtilities.getSpecUrl((String)this.getVersion()) + "/";
    }

    public void setXVerManager(XVerExtensionManager value) {
        this.xverManager = value;
    }

    public static interface IValidatorFactory {
        public IResourceValidator makeValidator(IWorkerContext var1, ValidatorSession var2) throws FHIRException;

        public IResourceValidator makeValidator(IWorkerContext var1, XVerExtensionManager var2, ValidatorSession var3) throws FHIRException;
    }

    public static interface ILoadFilter {
        public boolean isOkToLoad(Resource var1);

        public boolean isOkToLoad(String var1);
    }

    public static class PackageResourceLoader
    extends CanonicalResourceManager.CanonicalResourceProxy {
        private final String filename;
        private final IContextResourceLoader loader;
        private final PackageInformation packageInformation;

        public PackageResourceLoader(NpmPackage.PackageResourceInformation pri, IContextResourceLoader loader, PackageInformation pi) {
            super(pri.getResourceType(), pri.getId(), loader == null ? pri.getUrl() : loader.patchUrl(pri.getUrl(), pri.getResourceType()), pri.getVersion(), pri.getSupplements(), pri.getDerivation(), pri.getContent());
            this.filename = pri.getFilename();
            this.loader = loader;
            this.packageInformation = pi;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CanonicalResource loadResource() {
            try (FileInputStream f = ManagedFileAccess.inStream((String)this.filename);){
                if (this.loader != null) {
                    CanonicalResource canonicalResource = this.setPi(R5Hacker.fixR5BrokenResource((CanonicalResource)this.loader.loadResource(f, true)));
                    return canonicalResource;
                }
                CanonicalResource canonicalResource = this.setPi(R5Hacker.fixR5BrokenResource((CanonicalResource)new JsonParser().parse(f)));
                return canonicalResource;
            }
            catch (Exception e) {
                throw new FHIRException("Error loading " + this.filename + ": " + e.getMessage(), (Throwable)e);
            }
        }

        private CanonicalResource setPi(CanonicalResource cr) {
            cr.setSourcePackage(this.packageInformation);
            return cr;
        }

        public InputStream getStream() throws IOException {
            return ManagedFileAccess.inStream((String)this.filename);
        }
    }

    public class InternalCanonicalResourceProxy
    extends CanonicalResourceManager.CanonicalResourceProxy {
        public InternalCanonicalResourceProxy(String type, String id, String url, String version) {
            super(type, id, url, version, null, null, null);
        }

        @Override
        public CanonicalResource loadResource() throws FHIRException {
            throw new Error("not done yet");
        }
    }

    public static class SimpleWorkerContextBuilder {
        private final String terminologyCachePath;
        private final boolean cacheTerminologyClientErrors;
        private final boolean alwaysUseTerminologyServer;
        private final boolean readOnlyCache;
        private final Locale locale;
        private final String userAgent;
        private final boolean allowLoadingDuplicates;
        private final ILoggingService loggingService;
        private boolean defaultExpParams;

        public SimpleWorkerContextBuilder() {
            this.cacheTerminologyClientErrors = false;
            this.alwaysUseTerminologyServer = false;
            this.readOnlyCache = false;
            this.terminologyCachePath = null;
            this.locale = null;
            this.userAgent = null;
            this.allowLoadingDuplicates = false;
            this.loggingService = new Slf4JLoggingService(log);
        }

        private SimpleWorkerContext getSimpleWorkerContextInstance() throws IOException {
            if (this.locale != null) {
                return new SimpleWorkerContext(this.locale);
            }
            return new SimpleWorkerContext();
        }

        public SimpleWorkerContext build() throws IOException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            return this.build(context);
        }

        private SimpleWorkerContext build(SimpleWorkerContext context) throws IOException {
            if (VersionUtilities.isR2Ver((String)context.getVersion()) || VersionUtilities.isR2Ver((String)context.getVersion())) {
                log.warn("As of end 2024, FHIR R2 (version " + context.getVersion() + ") is no longer officially supported.");
            }
            context.initTxCache(this.terminologyCachePath);
            context.setUserAgent(this.userAgent);
            context.setLogger(this.loggingService);
            context.cacheResource(new JsonParser().parse(MagicResources.spdxCodesAsData()));
            if (this.defaultExpParams) {
                context.setExpansionParameters(this.makeExpProfile());
            }
            return context;
        }

        public SimpleWorkerContext fromPackage(NpmPackage pi) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.setAllowLoadingDuplicates(this.allowLoadingDuplicates);
            context.terminologyClientManager.setFactory(TerminologyClientR5.factory());
            context.loadFromPackage(pi, null);
            return this.build(context);
        }

        private Parameters makeExpProfile() {
            Parameters ep = new Parameters();
            ep.addParameter("cache-id", UUID.randomUUID().toString().toLowerCase());
            return ep;
        }

        public SimpleWorkerContext fromPackage(NpmPackage pi, IContextResourceLoader loader, boolean genSnapshots) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.setAllowLoadingDuplicates(this.allowLoadingDuplicates);
            context.version = pi.fhirVersion();
            context.terminologyClientManager.setFactory(loader.txFactory());
            context.loadFromPackage(pi, loader);
            context.finishLoading(genSnapshots);
            if (this.defaultExpParams) {
                context.setExpansionParameters(this.makeExpProfile());
            }
            return this.build(context);
        }

        public SimpleWorkerContext fromPack(String path) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.setAllowLoadingDuplicates(this.allowLoadingDuplicates);
            context.loadFromPack(path, null);
            return this.build(context);
        }

        public SimpleWorkerContext fromPack(String path, IContextResourceLoader loader) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.loadFromPack(path, loader);
            return this.build(context);
        }

        public SimpleWorkerContext fromClassPath() throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            context.loadFromStream(SimpleWorkerContext.class.getResourceAsStream("validation.json.zip"), null);
            return this.build(context);
        }

        public SimpleWorkerContext fromClassPath(String name) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            InputStream s = SimpleWorkerContext.class.getResourceAsStream("/" + name);
            context.setAllowLoadingDuplicates(this.allowLoadingDuplicates);
            context.loadFromStream(s, null);
            return this.build(context);
        }

        public SimpleWorkerContext fromDefinitions(Map<String, ByteProvider> source, IContextResourceLoader loader, PackageInformation pi) throws IOException, FHIRException {
            SimpleWorkerContext context = this.getSimpleWorkerContextInstance();
            for (String name : source.keySet()) {
                try {
                    context.loadDefinitionItem(name, new ByteArrayInputStream(source.get(name).getBytes()), loader, null, pi);
                }
                catch (Exception e) {
                    log.error("Error loading " + name + ": " + e.getMessage());
                    throw new FHIRException("Error loading " + name + ": " + e.getMessage(), (Throwable)e);
                }
            }
            return this.build(context);
        }

        public SimpleWorkerContext fromNothing() throws FHIRException, IOException {
            return this.build();
        }

        public SimpleWorkerContextBuilder withDefaultParams() {
            this.defaultExpParams = true;
            return this;
        }

        @Generated
        private SimpleWorkerContextBuilder(String terminologyCachePath, boolean cacheTerminologyClientErrors, boolean alwaysUseTerminologyServer, boolean readOnlyCache, Locale locale, String userAgent, boolean allowLoadingDuplicates, ILoggingService loggingService, boolean defaultExpParams) {
            this.terminologyCachePath = terminologyCachePath;
            this.cacheTerminologyClientErrors = cacheTerminologyClientErrors;
            this.alwaysUseTerminologyServer = alwaysUseTerminologyServer;
            this.readOnlyCache = readOnlyCache;
            this.locale = locale;
            this.userAgent = userAgent;
            this.allowLoadingDuplicates = allowLoadingDuplicates;
            this.loggingService = loggingService;
            this.defaultExpParams = defaultExpParams;
        }

        @Generated
        public SimpleWorkerContextBuilder withTerminologyCachePath(String terminologyCachePath) {
            return this.terminologyCachePath == terminologyCachePath ? this : new SimpleWorkerContextBuilder(terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService, this.defaultExpParams);
        }

        @Generated
        public SimpleWorkerContextBuilder withCacheTerminologyClientErrors(boolean cacheTerminologyClientErrors) {
            return this.cacheTerminologyClientErrors == cacheTerminologyClientErrors ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService, this.defaultExpParams);
        }

        @Generated
        public SimpleWorkerContextBuilder withAlwaysUseTerminologyServer(boolean alwaysUseTerminologyServer) {
            return this.alwaysUseTerminologyServer == alwaysUseTerminologyServer ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService, this.defaultExpParams);
        }

        @Generated
        public SimpleWorkerContextBuilder withReadOnlyCache(boolean readOnlyCache) {
            return this.readOnlyCache == readOnlyCache ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService, this.defaultExpParams);
        }

        @Generated
        public SimpleWorkerContextBuilder withLocale(Locale locale) {
            return this.locale == locale ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, locale, this.userAgent, this.allowLoadingDuplicates, this.loggingService, this.defaultExpParams);
        }

        @Generated
        public SimpleWorkerContextBuilder withUserAgent(String userAgent) {
            return this.userAgent == userAgent ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, userAgent, this.allowLoadingDuplicates, this.loggingService, this.defaultExpParams);
        }

        @Generated
        public SimpleWorkerContextBuilder withAllowLoadingDuplicates(boolean allowLoadingDuplicates) {
            return this.allowLoadingDuplicates == allowLoadingDuplicates ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, allowLoadingDuplicates, this.loggingService, this.defaultExpParams);
        }

        @Generated
        public SimpleWorkerContextBuilder withLoggingService(ILoggingService loggingService) {
            return this.loggingService == loggingService ? this : new SimpleWorkerContextBuilder(this.terminologyCachePath, this.cacheTerminologyClientErrors, this.alwaysUseTerminologyServer, this.readOnlyCache, this.locale, this.userAgent, this.allowLoadingDuplicates, loggingService, this.defaultExpParams);
        }
    }
}

