/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import org.hl7.fhir.r5.elementmodel.Element;

public class ElementVisitor {
    private IElementVisitor visitor;

    public ElementVisitor(IElementVisitor visitor) {
        this.visitor = visitor;
    }

    private void visitElement(Object context, Element e) {
        for (Element c : e.getChildren()) {
            this.visit(context, c);
        }
    }

    public void visit(Object context, Element e) {
        ElementVisitorInstruction c = this.visitor.visit(context, e);
        if (c == ElementVisitorInstruction.VISIT_CHILDREN) {
            this.visitElement(context, e);
        }
    }

    public static interface IElementVisitor {
        public ElementVisitorInstruction visit(Object var1, Element var2);
    }

    public static enum ElementVisitorInstruction {
        VISIT_CHILDREN,
        NO_VISIT_CHILDREN;

    }
}

