/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Factory;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.NamedItemList;

@MarkedToMoveToAdjunctPackage
public class ObjectConverter {
    private IWorkerContext context;
    private ProfileUtilities profileUtilities;

    public ObjectConverter(IWorkerContext context) {
        this.context = context;
        this.profileUtilities = new ProfileUtilities(context, null, null);
    }

    public Element convert(Resource ig) throws IOException, FHIRException {
        if (ig == null) {
            return null;
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        org.hl7.fhir.r5.formats.JsonParser jp = new org.hl7.fhir.r5.formats.JsonParser();
        jp.compose(bs, ig);
        ByteArrayInputStream bi = new ByteArrayInputStream(bs.toByteArray());
        List<ValidatedFragment> list = new JsonParser(this.context).parse(bi);
        if (list.size() != 1) {
            throw new FHIRException("Unable to convert because the source contains multiple resources");
        }
        return list.get(0).getElement();
    }

    public Element convert(Property property, DataType type) throws FHIRException {
        return this.convertElement(property, type);
    }

    private Element convertElement(Property property, Base base) throws FHIRException {
        if (base == null) {
            return null;
        }
        String tn = base.fhirType();
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(tn, null));
        if (sd == null) {
            throw new FHIRException("Unable to find definition for type " + tn);
        }
        Element res = new Element(property.getName(), property);
        if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
            res.setValue(((PrimitiveType)base).asStringValue());
        }
        ProfileUtilities.SourcedChildDefinitions children = this.profileUtilities.getChildMap(sd, sd.getSnapshot().getElementFirstRep(), true);
        for (ElementDefinition child : children.getList()) {
            Base[] values;
            String n = this.tail(child.getPath());
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE && "value".equals(n) || (values = base.getProperty(n.hashCode(), n, false)) == null) continue;
            for (Base value : values) {
                res.getChildren().add((NamedItemList.NamedItem)this.convertElement(new Property(this.context, child, sd), value));
            }
        }
        return res;
    }

    private String tail(String path) {
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(46) + 1);
        }
        return path;
    }

    public DataType convertToType(Element element) throws FHIRException {
        DataType b = new Factory().create(element.fhirType());
        if (b instanceof PrimitiveType) {
            ((PrimitiveType)b).setValueAsString(element.primitiveValue());
        } else {
            for (Element child : element.getChildren()) {
                b.setProperty(child.getName(), this.convertToType(child));
            }
        }
        return b;
    }

    public Resource convert(Element element) throws FHIRException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            new JsonParser(this.context).compose(element, bo, IParser.OutputStyle.NORMAL, null);
            return new org.hl7.fhir.r5.formats.JsonParser().parse(bo.toByteArray());
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
    }

    public static CodeableConcept readAsCodeableConcept(Element element) {
        if (element == null) {
            return null;
        }
        CodeableConcept cc = new CodeableConcept();
        ArrayList<Element> list = new ArrayList<Element>();
        element.getNamedChildren("coding", list);
        for (Element item : list) {
            cc.addCoding(ObjectConverter.readAsCoding(item));
        }
        cc.setText(element.getNamedChildValue("text"));
        return cc;
    }

    public static Coding readAsCoding(Element item) {
        Coding c = new Coding();
        c.setSystem(item.getNamedChildValue("system"));
        c.setVersion(item.getNamedChildValue("version"));
        c.setCode(item.getNamedChildValue("code"));
        c.setDisplay(item.getNamedChildValue("display"));
        return c;
    }

    public static Quantity readAsQuantity(Element item) {
        String comparator;
        if (item == null || !item.fhirType().equals("Quantity")) {
            return null;
        }
        Quantity q = new Quantity();
        String value = item.getNamedChildValue("value");
        if (value != null) {
            q.setValue(new BigDecimal(value));
        }
        if ((comparator = item.getNamedChildValue("comparator")) != null && Enumerations.QuantityComparator.isValidCode(comparator)) {
            q.setComparator(Enumerations.QuantityComparator.fromCode(comparator));
        }
        q.setSystem(item.getNamedChildValue("system"));
        q.setCode(item.getNamedChildValue("code"));
        q.setUnit(item.getNamedChildValue("unit"));
        return q;
    }

    public static Identifier readAsIdentifier(Element item) {
        Identifier r = new Identifier();
        r.setSystem(item.getNamedChildValue("system"));
        r.setValue(item.getNamedChildValue("value"));
        return r;
    }

    public static Reference readAsReference(Element item) {
        List<Element> identifier;
        Element ext;
        Reference r = new Reference();
        r.setDisplay(item.getNamedChildValue("display"));
        r.setReference(item.getNamedChildValue("reference"));
        r.setType(item.getNamedChildValue("type"));
        if (!r.hasType() && (ext = item.getExtension("http://hl7.org/fhir/4.0/StructureDefinition/extension-Reference.type")) != null) {
            r.setType(ext.getChildValue("valueUri"));
        }
        if (!(identifier = item.getChildrenByName("identifier")).isEmpty()) {
            r.setIdentifier(ObjectConverter.readAsIdentifier(identifier.get(0)));
        }
        return r;
    }
}

