/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonElementType;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.validation.ValidationMessage;

@MarkedToMoveToAdjunctPackage
public class SHCParser
extends ParserBase {
    private JsonParser jsonParser;
    private List<String> types = new ArrayList<String>();
    private static final int BUFFER_SIZE = 1024;
    public static final String CURRENT_PACKAGE = "hl7.fhir.uv.shc-vaccination#0.6.2";
    private static final int MAX_ALLOWED_SHC_LENGTH = 1195;

    public SHCParser(IWorkerContext context) {
        super(context);
        this.jsonParser = new JsonParser(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<ValidatedFragment> parse(InputStream inStream) throws IOException, FHIRFormatError, DefinitionException, FHIRException {
        byte[] content = FileUtilities.streamToBytes((InputStream)inStream);
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        ArrayList<ValidatedFragment> res = new ArrayList<ValidatedFragment>();
        ValidatedFragment shc = new ValidatedFragment("shc", "txt", content, false);
        res.add(shc);
        String src = FileUtilities.streamToString((InputStream)stream).trim();
        ArrayList<String> list = new ArrayList<String>();
        String pfx = null;
        if (src.startsWith("{")) {
            JsonObject json = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((String)src);
            if (!this.checkProperty(shc.getErrors(), json, "$", "verifiableCredential", true, "Array")) return res;
            pfx = "verifiableCredential";
            JsonArray arr = json.getJsonArray("verifiableCredential");
            int i = 0;
            for (JsonElement e : arr) {
                if (!(e instanceof JsonPrimitive)) {
                    this.logError(shc.getErrors(), ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), "$.verifiableCredential[" + i + "]", ValidationMessage.IssueType.STRUCTURE, "Wrong Property verifiableCredential in JSON Payload. Expected : String but found " + e.type().toName(), ValidationMessage.IssueSeverity.ERROR);
                } else {
                    list.add(e.asString());
                }
                ++i;
            }
        } else {
            list.add(src);
        }
        int c = 0;
        for (String ssrc : list) {
            String prefix = pfx == null ? "" : pfx + "[" + Integer.toString(c) + "].";
            ++c;
            JWT jwt = null;
            try {
                jwt = this.decodeJWT(shc.getErrors(), ssrc);
            }
            catch (Exception e) {
                this.logError(shc.getErrors(), ValidationMessage.NO_RULE_DATE, 1, 1, prefix + "JWT", ValidationMessage.IssueType.INVALID, "Unable to decode JWT token", ValidationMessage.IssueSeverity.ERROR);
                return res;
            }
            ValidatedFragment bnd = new ValidatedFragment("payload", "json", jwt.payloadSrc, true);
            res.add(bnd);
            this.checkNamedProperties(shc.getErrors(), jwt.getPayload(), prefix + "payload", "iss", "nbf", "vc");
            this.checkProperty(shc.getErrors(), jwt.getPayload(), prefix + "payload", "iss", true, "String");
            this.checkProperty(shc.getErrors(), jwt.getPayload(), prefix + "payload", "nbf", true, "Number");
            JsonObject vc = jwt.getPayload().getJsonObject("vc");
            if (vc == null) {
                this.logError(shc.getErrors(), ValidationMessage.NO_RULE_DATE, 1, 1, "JWT", ValidationMessage.IssueType.STRUCTURE, "Unable to find property 'vc' in the payload", ValidationMessage.IssueSeverity.ERROR);
                return res;
            }
            String path = prefix + "payload.vc";
            this.checkNamedProperties(shc.getErrors(), vc, path, "type", "credentialSubject");
            if (!this.checkProperty(shc.getErrors(), vc, path, "type", true, "Array")) {
                return res;
            }
            JsonArray type = vc.getJsonArray("type");
            int i = 0;
            for (JsonElement e : type) {
                if (e.type() != JsonElementType.STRING) {
                    this.logError(shc.getErrors(), ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), path + ".type[" + i + "]", ValidationMessage.IssueType.STRUCTURE, "Wrong Property Type in JSON Payload. Expected : String but found " + e.type().toName(), ValidationMessage.IssueSeverity.ERROR);
                } else {
                    this.types.add(e.asString());
                }
                ++i;
            }
            if (!this.types.contains("https://smarthealth.cards#health-card")) {
                this.logError(shc.getErrors(), ValidationMessage.NO_RULE_DATE, this.line((JsonElement)vc), this.col((JsonElement)vc), path, ValidationMessage.IssueType.STRUCTURE, "Card does not claim to be of type https://smarthealth.cards#health-card, cannot validate", ValidationMessage.IssueSeverity.ERROR);
                return res;
            }
            if (!this.checkProperty(shc.getErrors(), vc, path, "credentialSubject", true, "Object")) {
                return res;
            }
            JsonObject cs = vc.getJsonObject("credentialSubject");
            path = path + ".credentialSubject";
            if (!this.checkProperty(shc.getErrors(), cs, path, "fhirVersion", true, "String")) {
                return res;
            }
            JsonElement fv = cs.get("fhirVersion");
            if (!VersionUtilities.versionMatches((String)this.context.getVersion(), (String)fv.asString())) {
                this.logError(shc.getErrors(), ValidationMessage.NO_RULE_DATE, this.line(fv), this.col(fv), path + ".fhirVersion", ValidationMessage.IssueType.STRUCTURE, "Card claims to be of version " + fv.asString() + ", cannot be validated against version " + this.context.getVersion(), ValidationMessage.IssueSeverity.ERROR);
                return res;
            }
            if (!this.checkProperty(shc.getErrors(), cs, path, "fhirBundle", true, "Object")) {
                return res;
            }
            bnd.setElement(this.jsonParser.parse(bnd.getErrors(), cs.getJsonObject("fhirBundle"), path));
            bnd.setElementPath(path);
        }
        return res;
    }

    @Override
    public String getImpliedProfile() {
        if (this.types.contains("https://smarthealth.cards#covid19") && this.types.contains("https://smarthealth.cards#immunization")) {
            return "http://hl7.org/fhir/uv/shc-vaccination/StructureDefinition/shc-vaccination-bundle-dm";
        }
        if (this.types.contains("https://smarthealth.cards#covid19") && this.types.contains("https://smarthealth.cards#laboratory")) {
            return "http://hl7.org/fhir/uv/shc-vaccination/StructureDefinition/shc-covid19-laboratory-bundle-dm";
        }
        if (this.types.contains("https://smarthealth.cards#laboratory")) {
            return "http://hl7.org/fhir/uv/shc-vaccination/StructureDefinition/shc-infectious-disease-laboratory-bundle-dm";
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkProperty(List<ValidationMessage> errors, JsonObject obj, String path, String name, boolean required, String type) {
        JsonElement e = obj.get(name);
        if (e != null) {
            String t = e.type().toName();
            if (type.equals(t)) return true;
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e), this.col(e), path + "." + name, ValidationMessage.IssueType.STRUCTURE, "Wrong Property Type in JSON Payload. Expected : " + type + " but found " + t, ValidationMessage.IssueSeverity.ERROR);
            return false;
        } else {
            if (!required) return true;
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line((JsonElement)obj), this.col((JsonElement)obj), path, ValidationMessage.IssueType.STRUCTURE, "Missing Property in JSON Payload: " + name, ValidationMessage.IssueSeverity.ERROR);
        }
        return false;
    }

    private void checkNamedProperties(List<ValidationMessage> errors, JsonObject obj, String path, String ... names) {
        for (JsonProperty e : obj.getProperties()) {
            if (Utilities.existsInList((String)e.getName(), (String[])names)) continue;
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(e.getValue()), this.col(e.getValue()), path + "." + e.getName(), ValidationMessage.IssueType.STRUCTURE, "Unknown Property in JSON Payload", ValidationMessage.IssueSeverity.WARNING);
        }
    }

    private int line(JsonElement e) {
        return e.getStart().getLine();
    }

    private int col(JsonElement e) {
        return e.getStart().getCol();
    }

    @Override
    public void compose(Element e, OutputStream destination, IParser.OutputStyle style, String base) throws FHIRException, IOException {
        throw new FHIRFormatError("Writing resources is not supported for the SHC format");
    }

    public static String decodeQRCode(String src) {
        StringBuilder b = new StringBuilder();
        if (!src.startsWith("shc:/")) {
            throw new FHIRException("Unable to process smart health card (didn't start with shc:/)");
        }
        for (int i = 5; i < src.length(); i += 2) {
            String s = src.substring(i, i + 2);
            byte v = Byte.parseByte(s);
            char c = (char)(45 + v);
            b.append(c);
        }
        return b.toString();
    }

    public JWT decodeJWT(List<ValidationMessage> errors, String jwt) throws IOException, DataFormatException {
        byte[] payloadJson;
        byte[] headerJson;
        if (jwt.startsWith("shc:/")) {
            jwt = SHCParser.decodeQRCode(jwt);
        }
        if (jwt.length() > 1195) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, -1, -1, "jwt", ValidationMessage.IssueType.TOOLONG, "JWT Payload limit length is 1195 bytes for a single image - this has " + jwt.length() + " bytes", ValidationMessage.IssueSeverity.ERROR);
        }
        String[] parts = SHCParser.splitToken(jwt);
        try {
            headerJson = Base64.getUrlDecoder().decode(parts[0]);
            payloadJson = Base64.getUrlDecoder().decode(parts[1]);
        }
        catch (NullPointerException e) {
            throw new FHIRException("The UTF-8 Charset isn't initialized.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new FHIRException("The input is not a valid base 64 encoded string.", (Throwable)e);
        }
        JWT res = new JWT();
        res.setHeaderSrc(headerJson);
        res.header = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((byte[])headerJson);
        if ("DEF".equals(res.header.asString("zip"))) {
            payloadJson = SHCParser.inflate(payloadJson);
        }
        res.setPayloadSrc(payloadJson);
        res.payload = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((String)FileUtilities.bytesToString((byte[])payloadJson), (boolean)true);
        this.checkSignature(jwt, res, errors, "jwt", org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)res.payload));
        return res;
    }

    private void checkSignature(String jwt, JWT res, List<ValidationMessage> errors, String name, String jsonPayload) {
        String iss = res.payload.asString("iss");
        if (iss != null) {
            if (!iss.startsWith("https://")) {
                this.logError(errors, "2023-09-08", 1, 1, name, ValidationMessage.IssueType.NOTFOUND, "JWT iss '" + iss + "' must start with https://", ValidationMessage.IssueSeverity.ERROR);
            }
            if (iss.endsWith("/")) {
                this.logError(errors, "2023-09-08", 1, 1, name, ValidationMessage.IssueType.NOTFOUND, "JWT iss '" + iss + "' must not have trailing /", ValidationMessage.IssueSeverity.ERROR);
                iss = iss.substring(0, iss.length() - 1);
            }
            String url = Utilities.pathURL((String[])new String[]{iss, "/.well-known/jwks.json"});
            JsonObject jwks = null;
            try {
                jwks = this.signatureServices != null ? this.signatureServices.fetchJWKS(url) : org.hl7.fhir.utilities.json.parser.JsonParser.parseObjectFromUrl((String)url);
            }
            catch (Exception e) {
                this.logError(errors, "2023-09-08", 1, 1, name, ValidationMessage.IssueType.NOTFOUND, "Unable to verify the signature, because unable to retrieve JWKS from " + url + ": " + e.getMessage().replace("Connection refused (Connection refused)", "Connection refused"), ValidationMessage.IssueSeverity.ERROR);
            }
            if (jwks != null) {
                this.verifySignature(jwt, errors, name, iss, url, org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)jwks));
            }
        }
    }

    private void verifySignature(String jwt, List<ValidationMessage> errors, String name, String iss, String url, String jwks) {
        try {
            JWSObject jwsObject = JWSObject.parse((String)jwt);
            JWSHeader header = jwsObject.getHeader();
            SHCParser.validateHeader(header);
            byte[] decodedPayload = jwsObject.getPayload().toBytes();
            String decompressedPayload = SHCParser.decompress(decodedPayload);
            JsonObject rootNode = org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((String)decompressedPayload);
            String issuer = rootNode.asString("iss");
            JWKSet jwkSet = JWKSet.parse((String)jwks);
            JWK publicKey = jwkSet.getKeyByKeyId(header.getKeyID());
            ECDSAVerifier verifier = new ECDSAVerifier((ECKey)publicKey);
            if (jwsObject.verify((JWSVerifier)verifier)) {
                String vciName = this.getVCIIssuer(errors, issuer);
                if (vciName == null) {
                    this.logError(errors, "2023-09-08", 1, 1, name, ValidationMessage.IssueType.BUSINESSRULE, "The signature is valid, but the issuer " + issuer + " is not a trusted issuer", ValidationMessage.IssueSeverity.WARNING);
                } else {
                    this.logError(errors, "2023-09-08", 1, 1, name, ValidationMessage.IssueType.INFORMATIONAL, "The signature is valid, signed by the trusted issuer '" + vciName + "' (" + issuer + ")", ValidationMessage.IssueSeverity.INFORMATION);
                }
            } else {
                this.logError(errors, "2023-09-08", 1, 1, name, ValidationMessage.IssueType.BUSINESSRULE, "The signature is not valid", ValidationMessage.IssueSeverity.ERROR);
            }
        }
        catch (Exception e) {
            this.logError(errors, "2023-09-08", 1, 1, name, ValidationMessage.IssueType.NOTFOUND, "Error validating signature: " + e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private static void validateHeader(JWSHeader header) {
        if (!"ES256".equals(header.getAlgorithm().getName())) {
            throw new IllegalArgumentException("Invalid alg in JWS header. Expected ES256.");
        }
        if (!header.getCustomParam("zip").equals("DEF")) {
            throw new IllegalArgumentException("Invalid zip in JWS header. Expected DEF.");
        }
    }

    private static String decompress(byte[] compressed) throws Exception {
        Inflater inflater = new Inflater(true);
        inflater.setInput(compressed);
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(compressed.length);){
            while (!inflater.finished()) {
                int length = inflater.inflate(buffer);
                outputStream.write(buffer, 0, length);
            }
            String string = outputStream.toString(StandardCharsets.UTF_8.name());
            return string;
        }
    }

    private String getVCIIssuer(List<ValidationMessage> errors, String issuer) {
        try {
            JsonObject vci = org.hl7.fhir.utilities.json.parser.JsonParser.parseObjectFromUrl((String)"https://raw.githubusercontent.com/the-commons-project/vci-directory/main/vci-issuers.json");
            for (JsonObject j : vci.getJsonObjects("participating_issuers")) {
                if (!issuer.equals(j.asString("iss"))) continue;
                return j.asString("name");
            }
        }
        catch (Exception e) {
            this.logError(errors, "2023-09-08", 1, 1, "vci", ValidationMessage.IssueType.NOTFOUND, "Unable to retrieve/read VCI Trusted Issuer list: " + e.getMessage(), ValidationMessage.IssueSeverity.WARNING);
        }
        return null;
    }

    static String[] splitToken(String token) {
        String[] parts = token.split("\\.");
        if (parts.length == 2 && token.endsWith(".")) {
            parts = new String[]{parts[0], parts[1], ""};
        }
        if (parts.length != 3) {
            throw new FHIRException(String.format("The token was expected to have 3 parts, but got %s.", parts.length));
        }
        return parts;
    }

    public static final byte[] inflate(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = new Inflater(true);
        inflater.setInput(data);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static class JWT {
        private JsonObject header;
        private JsonObject payload;
        private byte[] headerSrc;
        private byte[] payloadSrc;

        public JsonObject getHeader() {
            return this.header;
        }

        public void setHeader(JsonObject header) {
            this.header = header;
        }

        public JsonObject getPayload() {
            return this.payload;
        }

        public void setPayload(JsonObject payload) {
            this.payload = payload;
        }

        public byte[] getHeaderSrc() {
            return this.headerSrc;
        }

        public void setHeaderSrc(byte[] headerSrc) {
            this.headerSrc = headerSrc;
        }

        public byte[] getPayloadSrc() {
            return this.payloadSrc;
        }

        public void setPayloadSrc(byte[] payloadSrc) {
            this.payloadSrc = payloadSrc;
        }
    }

    public class SHCSignedJWT
    extends SignedJWT {
        private static final long serialVersionUID = 1L;
        private JWTClaimsSet claimsSet;

        public SHCSignedJWT(SignedJWT jwtO, String jsonPayload) throws ParseException {
            super(jwtO.getParsedParts()[0], jwtO.getParsedParts()[1], jwtO.getParsedParts()[2]);
            Map json = JSONObjectUtils.parse((String)jsonPayload);
            this.claimsSet = JWTClaimsSet.parse((Map)json);
        }

        public JWTClaimsSet getJWTClaimsSet() {
            return this.claimsSet;
        }
    }
}

