/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.formats.XmlLocationAnnotator;
import org.hl7.fhir.r5.utils.formats.XmlLocationData;
import org.hl7.fhir.utilities.ElementDecoration;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.NamedItemList;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.CDANarrativeFormat;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.IXMLWriter;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@MarkedToMoveToAdjunctPackage
public class XmlParser
extends ParserBase {
    private boolean allowXsiLocation;
    private String version;
    private boolean elideElements;
    private String schemaPath;
    private boolean markedXhtml;

    public XmlParser(IWorkerContext context) {
        super(context);
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public void setSchemaPath(String schemaPath) {
        this.schemaPath = schemaPath;
    }

    public boolean isAllowXsiLocation() {
        return this.allowXsiLocation;
    }

    public void setAllowXsiLocation(boolean allowXsiLocation) {
        this.allowXsiLocation = allowXsiLocation;
    }

    @Override
    public List<ValidatedFragment> parse(InputStream inStream) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        byte[] content = FileUtilities.streamToBytes((InputStream)inStream);
        ValidatedFragment focusFragment = new ValidatedFragment("focus", "xml", content, false);
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        Document doc = null;
        try {
            DocumentBuilderFactory factory = XMLUtil.newXXEProtectedDocumentBuilderFactory();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setNamespaceAware(true);
            if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                stream.mark(1024);
                this.version = this.checkHeader(focusFragment.getErrors(), stream);
                stream.reset();
                TransformerFactory transformerFactory = XMLUtil.newXXEProtectedTransformerFactory();
                Transformer nullTransformer = transformerFactory.newTransformer();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                doc = docBuilder.newDocument();
                DOMResult domResult = new DOMResult(doc);
                SAXParserFactory spf = XMLUtil.newXXEProtectedSaxParserFactory();
                spf.setNamespaceAware(true);
                spf.setValidating(false);
                XMLReader xmlReader = XMLUtil.getXXEProtectedXMLReader((SAXParserFactory)spf);
                XmlLocationAnnotator locationAnnotator = new XmlLocationAnnotator(xmlReader, doc);
                InputSource inputSource = new InputSource(stream);
                SAXSource saxSource = new SAXSource(locationAnnotator, inputSource);
                nullTransformer.transform(saxSource, domResult);
            } else {
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setErrorHandler(new NullErrorHandler());
                doc = builder.parse(stream);
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("lineNumber:") && e.getMessage().contains("columnNumber:")) {
                int line = Utilities.parseInt((String)this.extractVal(e.getMessage(), "lineNumber"), (int)0);
                int col = Utilities.parseInt((String)this.extractVal(e.getMessage(), "columnNumber"), (int)0);
                this.logError(focusFragment.getErrors(), ValidationMessage.NO_RULE_DATE, line, col, "(xml)", ValidationMessage.IssueType.INVALID, e.getMessage().substring(e.getMessage().lastIndexOf(";") + 1).trim(), ValidationMessage.IssueSeverity.FATAL);
            } else {
                this.logError(focusFragment.getErrors(), ValidationMessage.NO_RULE_DATE, 0, 0, "(xml)", ValidationMessage.IssueType.INVALID, e.getMessage(), ValidationMessage.IssueSeverity.FATAL);
            }
            doc = null;
        }
        if (doc != null) {
            focusFragment.setElement(this.parse(focusFragment.getErrors(), doc));
        }
        ArrayList<ValidatedFragment> res = new ArrayList<ValidatedFragment>();
        res.add(focusFragment);
        return res;
    }

    private String extractVal(String src, String name) {
        src = src.substring(src.indexOf(name) + name.length() + 1);
        src = src.substring(0, src.indexOf(";")).trim();
        return src;
    }

    private void checkForProcessingInstruction(List<ValidationMessage> errors, Document document) throws FHIRFormatError {
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING && "http://hl7.org/fhir".equals(document.getDocumentElement().getNamespaceURI())) {
            for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 7) continue;
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(document, false), this.col(document, false), "(document)", ValidationMessage.IssueType.INVALID, this.context.formatMessage("No_processing_instructions_allowed_in_resources", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
        }
    }

    private int line(Node node, boolean end) {
        XmlLocationData loc;
        XmlLocationData xmlLocationData = loc = node == null ? null : (XmlLocationData)node.getUserData("locationDataKey");
        return loc == null ? 0 : (end ? loc.getEndLine() : loc.getStartLine());
    }

    private int col(Node node, boolean end) {
        XmlLocationData loc;
        XmlLocationData xmlLocationData = loc = node == null ? null : (XmlLocationData)node.getUserData("locationDataKey");
        return loc == null ? 0 : (end ? loc.getEndColumn() : loc.getStartColumn());
    }

    public Element parse(List<ValidationMessage> errors, Document doc) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        this.checkForProcessingInstruction(errors, doc);
        org.w3c.dom.Element element = doc.getDocumentElement();
        return this.parse(errors, element);
    }

    public Element parse(List<ValidationMessage> errors, org.w3c.dom.Element element) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        String ns = element.getNamespaceURI();
        String name = element.getLocalName();
        String path = "/" + this.pathPrefix(ns) + name;
        StructureDefinition sd = this.getDefinition(errors, this.line(element, false), this.col(element, false), ns == null ? "noNamespace" : ns, name);
        if (sd == null) {
            return null;
        }
        Element result = new Element(element.getLocalName(), new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.getProfileUtilities(), this.getContextUtilities())).setFormat(Manager.FhirFormat.XML);
        result.setPath(element.getLocalName());
        this.checkElement(errors, element, result, path, result.getProperty(), false);
        result.markLocation(this.line(element, false), this.col(element, false));
        result.setType(element.getLocalName());
        this.parseChildren(errors, path, element, result);
        result.numberChildren();
        return result;
    }

    private String pathPrefix(String ns) {
        if (Utilities.noString((String)ns)) {
            return "";
        }
        if (ns.equals("http://hl7.org/fhir")) {
            return "f:";
        }
        if (ns.equals("http://www.w3.org/1999/xhtml")) {
            return "h:";
        }
        if (ns.equals("urn:hl7-org:v3")) {
            return "v3:";
        }
        if (ns.equals("urn:hl7-org:sdtc")) {
            return "sdtc:";
        }
        if (ns.equals("urn:ihe:pharm")) {
            return "pharm:";
        }
        if (ns.equals("http://ns.electronichealth.net.au/Ci/Cda/Extensions/3.0")) {
            return "ext:";
        }
        return "?:";
    }

    private boolean empty(org.w3c.dom.Element element) {
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            String n = element.getAttributes().item(i).getNodeName();
            if (n.equals("xmlns") || n.startsWith("xmlns:")) continue;
            return false;
        }
        if (!Utilities.noString((String)element.getTextContent().trim())) {
            return false;
        }
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    private void checkElement(List<ValidationMessage> errors, org.w3c.dom.Element element, Element e, String path, Property prop, boolean xsiTypeChecked) throws FHIRFormatError {
        if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
            String xsiType;
            if (this.empty(element) && "http://hl7.org/fhir".equals(element.getNamespaceURI())) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(element, false), this.col(element, false), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Element_must_have_some_content", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
            }
            String ns = prop.getXmlNamespace();
            String elementNs = element.getNamespaceURI();
            if (elementNs == null) {
                elementNs = "noNamespace";
            }
            if (!elementNs.equals(ns)) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(element, false), this.col(element, false), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("Wrong_namespace__expected_", ns), ValidationMessage.IssueSeverity.ERROR);
            }
            if (!xsiTypeChecked && !Utilities.noString((String)(xsiType = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")))) {
                String actualType = prop.getXmlTypeName();
                if (xsiType.equals(actualType)) {
                    this.logError(errors, "2023-10-12", this.line(element, false), this.col(element, false), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("XSI_TYPE_UNNECESSARY", new Object[0]), ValidationMessage.IssueSeverity.INFORMATION);
                } else {
                    StructureDefinition sd = this.findLegalConstraint(xsiType, actualType);
                    if (sd != null) {
                        e.setType(sd.getType());
                        e.setExplicitType(xsiType);
                    } else {
                        this.logError(errors, "2023-10-12", this.line(element, false), this.col(element, false), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage("XSI_TYPE_WRONG", xsiType, actualType), ValidationMessage.IssueSeverity.ERROR);
                    }
                }
            }
        }
    }

    private StructureDefinition findLegalConstraint(String xsiType, String actualType) {
        StructureDefinition sdA = this.context.fetchTypeDefinition(actualType);
        StructureDefinition sd = this.context.fetchTypeDefinition(xsiType);
        while (sd != null) {
            if (sd == sdA) {
                return sd;
            }
            sd = this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        }
        return null;
    }

    public Element parse(List<ValidationMessage> errors, org.w3c.dom.Element base, String type) throws Exception {
        StructureDefinition sd = this.getDefinition(errors, 0, 0, "http://hl7.org/fhir", type);
        Element result = new Element(base.getLocalName(), new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.getProfileUtilities(), this.getContextUtilities())).setFormat(Manager.FhirFormat.XML).setNativeObject(base);
        result.setPath(base.getLocalName());
        String path = "/" + this.pathPrefix(base.getNamespaceURI()) + base.getLocalName();
        this.checkElement(errors, base, result, path, result.getProperty(), false);
        result.setType(base.getLocalName());
        this.parseChildren(errors, path, base, result);
        result.numberChildren();
        return result;
    }

    private void parseChildren(List<ValidationMessage> errors, String path, org.w3c.dom.Element node, Element element) throws FHIRFormatError, FHIRException, IOException, DefinitionException {
        this.reapComments(node, element);
        List<Property> properties = element.getProperty().getChildProperties(element.getName(), XMLUtil.getXsiType((org.w3c.dom.Element)node));
        Property cgProp = this.getChoiceGroupProp(properties);
        Property mtProp = cgProp == null ? null : this.getTextProp(cgProp.getChildProperties(null, null));
        String text = mtProp == null ? XMLUtil.getDirectText((org.w3c.dom.Element)node).trim() : null;
        int line = this.line(node, false);
        int col = this.col(node, false);
        if (!Utilities.noString((String)text)) {
            Property property = this.getTextProp(properties);
            if (property != null) {
                if ("ED.data[x]".equals(property.getDefinition().getId()) || property.getDefinition() != null && property.getDefinition().getBase() != null && "ED.data[x]".equals(property.getDefinition().getBase().getPath())) {
                    if ("B64".equals(node.getAttribute("representation"))) {
                        n = new Element("dataBase64Binary", property, "base64Binary", text).markLocation(line, col).setFormat(Manager.FhirFormat.XML);
                        ((Element)n).setPath(element.getPath() + "." + property.getName());
                        element.getChildren().add((NamedItemList.NamedItem)n);
                    } else {
                        n = new Element("dataString", property, "string", text).markLocation(line, col).setFormat(Manager.FhirFormat.XML);
                        ((Element)n).setPath(element.getPath() + "." + property.getName());
                        element.getChildren().add((NamedItemList.NamedItem)n);
                    }
                } else {
                    n = new Element(property.getName(), property, property.getType(), text).markLocation(line, col).setFormat(Manager.FhirFormat.XML);
                    ((Element)n).setPath(element.getPath() + "." + property.getName());
                    element.getChildren().add((NamedItemList.NamedItem)n);
                }
            } else {
                for (n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                    if (n.getNodeType() != 3 || Utilities.noString((String)n.getTextContent().trim())) continue;
                    Node nt = n;
                    boolean end = false;
                    while (nt.getPreviousSibling() != null && nt.getNodeType() != 1) {
                        nt = nt.getPreviousSibling();
                        end = true;
                    }
                    while (nt.getNextSibling() != null && nt.getNodeType() != 1) {
                        nt = nt.getNextSibling();
                        end = false;
                    }
                    line = this.line(nt, end);
                    col = this.col(nt, end);
                    this.logError(errors, ValidationMessage.NO_RULE_DATE, line, col, path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Text_should_not_be_present", Utilities.makeSingleLine((String)n.getTextContent().trim())), ValidationMessage.IssueSeverity.ERROR);
                }
            }
        }
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node attr = node.getAttributes().item(i);
            String value = attr.getNodeValue();
            if (!this.validAttrValue(value)) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, line, col, path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("xml_attr_value_invalid", attr.getNodeName()), ValidationMessage.IssueSeverity.ERROR);
            }
            if (attr.getNodeName().equals("xmlns") || attr.getNodeName().startsWith("xmlns:")) continue;
            Property property = this.getAttrProp(properties, attr.getLocalName(), attr.getNamespaceURI());
            if (property != null) {
                String av = attr.getNodeValue();
                if (ExtensionUtilities.hasExtension(property.getDefinition(), "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format")) {
                    av = this.convertForDateFormatFromExternal(ExtensionUtilities.readStringExtension((org.hl7.fhir.r5.model.Element)property.getDefinition(), "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format"), av);
                }
                if (property.getName().equals("value") && element.isPrimitive()) {
                    element.setValue(av);
                    continue;
                }
                String[] vl = new String[]{av};
                if (property.isList() && av.contains(" ")) {
                    vl = av.split(" ");
                }
                for (String v : vl) {
                    Element n = new Element(property.getName(), property, property.getType(), v).markLocation(line, col).setFormat(Manager.FhirFormat.XML);
                    n.setPath(element.getPath() + "." + property.getName());
                    element.getChildren().add((NamedItemList.NamedItem)n);
                }
                continue;
            }
            boolean ok = false;
            if ("http://hl7.org/fhir".equals(node.getNamespaceURI())) {
                if (attr.getLocalName().equals("schemaLocation") && "http://www.w3.org/2001/XMLSchema-instance".equals(attr.getNamespaceURI())) {
                    ok = ok || this.allowXsiLocation;
                }
            } else {
                ok = ok || attr.getLocalName().equals("schemaLocation");
            }
            boolean bl = ok = ok || this.hasTypeAttr(element) && attr.getLocalName().equals("type") && "http://www.w3.org/2001/XMLSchema-instance".equals(attr.getNamespaceURI());
            if (ok) continue;
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(node, false), this.col(node, false), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Undefined_attribute__on__for_type__properties__", attr.getNodeName(), node.getNodeName(), element.fhirType(), properties), ValidationMessage.IssueSeverity.ERROR);
        }
        String lastName = null;
        int repeatCount = 0;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element n;
            if (child.getNodeType() == 1) {
                String name;
                String npath;
                Property property = this.getElementProp(properties, child.getLocalName(), child.getNamespaceURI());
                if (property != null) {
                    if (property.getName().equals(lastName)) {
                        ++repeatCount;
                    } else {
                        lastName = property.getName();
                        repeatCount = 0;
                    }
                    if (!property.isChoice() && "xhtml".equals(property.getType())) {
                        XhtmlNode xhtml;
                        if (property.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.CDATEXT)) {
                            xhtml = new CDANarrativeFormat().convert((org.w3c.dom.Element)child);
                        } else {
                            XhtmlParser xp = new XhtmlParser();
                            xhtml = xp.parseHtmlNode((org.w3c.dom.Element)child);
                            if (this.policy == ParserBase.ValidationPolicy.EVERYTHING) {
                                for (StringPair s : xp.getValidationIssues()) {
                                    this.logError(errors, "2022-11-17", this.line(child, false), this.col(child, false), path, ValidationMessage.IssueType.INVALID, this.context.formatMessage(s.getName(), s.getValue()), ValidationMessage.IssueSeverity.ERROR);
                                }
                            }
                        }
                        Element n2 = new Element(property.getName(), property, "xhtml", new XhtmlComposer(true, false).compose(xhtml)).setXhtml(xhtml).markLocation(this.line(child, false), this.col(child, false)).setFormat(Manager.FhirFormat.XML).setNativeObject(child);
                        n2.setPath(element.getPath() + "." + property.getName());
                        element.getChildren().add((NamedItemList.NamedItem)n2);
                        continue;
                    }
                    npath = path + "/" + this.pathPrefix(child.getNamespaceURI()) + child.getLocalName();
                    name = child.getLocalName();
                    if (!property.isChoice() && !name.equals(property.getName())) {
                        name = property.getName();
                    }
                    n = new Element(name, property).markLocation(this.line(child, false), this.col(child, false)).setFormat(Manager.FhirFormat.XML).setNativeObject(child);
                    if (property.isList()) {
                        n.setPath(element.getPath() + "." + property.getName() + "[" + repeatCount + "]");
                    } else {
                        n.setPath(element.getPath() + "." + property.getName());
                    }
                    boolean xsiTypeChecked = false;
                    boolean ok = true;
                    if (property.isChoice()) {
                        if (property.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
                            String xsiType = ((org.w3c.dom.Element)child).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                            if (Utilities.noString((String)xsiType)) {
                                if (ExtensionUtilities.hasExtension(property.getDefinition(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype")) {
                                    xsiType = ExtensionUtilities.readStringExtension((org.hl7.fhir.r5.model.Element)property.getDefinition(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype");
                                    n.setType(xsiType);
                                } else {
                                    this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(child, false), this.col(child, false), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("No_type_found_on_", child.getLocalName()), ValidationMessage.IssueSeverity.ERROR);
                                    ok = false;
                                }
                            } else {
                                if (xsiType.contains(":")) {
                                    xsiType = xsiType.substring(xsiType.indexOf(":") + 1);
                                }
                                n.setType(xsiType);
                                n.setExplicitType(xsiType);
                            }
                            xsiTypeChecked = true;
                        } else {
                            n.setType(n.getType());
                        }
                    }
                    this.checkElement(errors, (org.w3c.dom.Element)child, n, npath, n.getProperty(), xsiTypeChecked);
                    element.getChildren().add((NamedItemList.NamedItem)n);
                    if (!ok) continue;
                    if (property.isResource()) {
                        this.parseResource(errors, npath, (org.w3c.dom.Element)child, n, property);
                        continue;
                    }
                    this.parseChildren(errors, npath, (org.w3c.dom.Element)child, n);
                    continue;
                }
                if (cgProp != null && (property = this.getElementProp(cgProp.getChildProperties(null, null), child.getLocalName(), child.getNamespaceURI())) != null) {
                    if (cgProp.getName().equals(lastName)) {
                        ++repeatCount;
                    } else {
                        lastName = cgProp.getName();
                        repeatCount = 0;
                    }
                    npath = path + "/" + this.pathPrefix(cgProp.getXmlNamespace()) + cgProp.getName();
                    name = cgProp.getName();
                    Element cgn = new Element(cgProp.getName(), cgProp).setFormat(Manager.FhirFormat.XML);
                    cgn.setPath(element.getPath() + "." + cgProp.getName() + "[" + repeatCount + "]");
                    element.getChildren().add((NamedItemList.NamedItem)cgn);
                    npath = npath + "/" + this.pathPrefix(child.getNamespaceURI()) + child.getLocalName();
                    name = child.getLocalName();
                    Element n3 = new Element(name, property).markLocation(this.line(child, false), this.col(child, false)).setFormat(Manager.FhirFormat.XML).setNativeObject(child);
                    cgn.getChildren().add((NamedItemList.NamedItem)n3);
                    n3.setPath(element.getPath() + "." + property.getName());
                    this.checkElement(errors, (org.w3c.dom.Element)child, n3, npath, n3.getProperty(), false);
                    this.parseChildren(errors, npath, (org.w3c.dom.Element)child, n3);
                }
                if (property != null) continue;
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(child, false), this.col(child, false), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Undefined_element_", child.getLocalName(), path), ValidationMessage.IssueSeverity.ERROR);
                continue;
            }
            if (child.getNodeType() == 3 && !Utilities.noString((String)child.getTextContent().trim()) && mtProp != null) {
                if (cgProp.getName().equals(lastName)) {
                    ++repeatCount;
                } else {
                    lastName = cgProp.getName();
                    repeatCount = 0;
                }
                String npath = path + "/" + this.pathPrefix(cgProp.getXmlNamespace()) + cgProp.getName();
                String name = cgProp.getName();
                Element cgn = new Element(cgProp.getName(), cgProp).setFormat(Manager.FhirFormat.XML);
                cgn.setPath(element.getPath() + "." + cgProp.getName() + "[" + repeatCount + "]");
                element.getChildren().add((NamedItemList.NamedItem)cgn);
                npath = npath + "/text()";
                name = mtProp.getName();
                n = new Element(name, mtProp, mtProp.getType(), child.getTextContent().trim()).markLocation(this.line(child, false), this.col(child, false)).setFormat(Manager.FhirFormat.XML).setNativeObject(child);
                cgn.getChildren().add((NamedItemList.NamedItem)n);
                n.setPath(element.getPath() + "." + mtProp.getName());
                continue;
            }
            if (child.getNodeType() == 4) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(child, false), this.col(child, false), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("CDATA_is_not_allowed", new Object[0]), ValidationMessage.IssueSeverity.ERROR);
                continue;
            }
            if (Utilities.existsInList((int)child.getNodeType(), (int[])new int[]{3, 8})) continue;
            this.logError(errors, ValidationMessage.NO_RULE_DATE, this.line(child, false), this.col(child, false), path, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("Node_type__is_not_allowed", Integer.toString(child.getNodeType())), ValidationMessage.IssueSeverity.ERROR);
        }
    }

    private Property getChoiceGroupProp(List<Property> properties) {
        for (Property p : properties) {
            if (!p.getDefinition().hasExtension("http://hl7.org/fhir/tools/StructureDefinition/xml-choice-group")) continue;
            return p;
        }
        return null;
    }

    private boolean validAttrValue(String value) {
        if (this.version == null) {
            return true;
        }
        if (this.version.equals("1.0")) {
            boolean ok = true;
            for (char ch : value.toCharArray()) {
                if (ch > '\u001f' || Utilities.existsInList((int)ch, (int[])new int[]{13, 10, 9})) continue;
                ok = false;
            }
            return ok;
        }
        return true;
    }

    private Property getElementProp(List<Property> properties, String nodeName, String namespace) {
        ArrayList<Property> propsSortedByLongestFirst = new ArrayList<Property>(properties);
        Collections.sort(propsSortedByLongestFirst, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return o2.getName().length() - o1.getName().length();
            }
        });
        for (Property p : propsSortedByLongestFirst) {
            if (p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR) || p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT) || !p.getXmlName().equals(nodeName) || !p.getXmlNamespace().equals(namespace)) continue;
            return p;
        }
        for (Property p : propsSortedByLongestFirst) {
            if (p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR) || p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT)) continue;
            if (p.getXmlName().equals(nodeName)) {
                return p;
            }
            if (!p.getName().endsWith("[x]") || nodeName.length() <= p.getName().length() - 3 || !p.getName().substring(0, p.getName().length() - 3).equals(nodeName.substring(0, p.getName().length() - 3))) continue;
            return p;
        }
        return null;
    }

    private Property getAttrProp(List<Property> properties, String nodeName, String namespace) {
        for (Property p : properties) {
            if (!p.getXmlName().equals(nodeName) || !p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR) || !p.getXmlNamespace().equals(namespace)) continue;
            return p;
        }
        if (namespace == null) {
            for (Property p : properties) {
                if (!p.getXmlName().equals(nodeName) || !p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLATTR)) continue;
                return p;
            }
        }
        return null;
    }

    private Property getTextProp(List<Property> properties) {
        for (Property p : properties) {
            if (!p.getDefinition().hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT)) continue;
            return p;
        }
        return null;
    }

    private String convertForDateFormatFromExternal(String fmt, String av) throws FHIRException {
        if ("v3".equals(fmt) || "YYYYMMDDHHMMSS.UUUU[+|-ZZzz]".equals(fmt)) {
            try {
                DateTimeType d = DateTimeType.parseV3(av);
                return d.asStringValue();
            }
            catch (Exception e) {
                return av;
            }
        }
        throw new FHIRException(this.context.formatMessage("Unknown_Data_format_", fmt));
    }

    private String convertForDateFormatToExternal(String fmt, String av) throws FHIRException {
        if ("v3".equals(fmt) || "YYYYMMDDHHMMSS.UUUU[+|-ZZzz]".equals(fmt)) {
            DateTimeType d = new DateTimeType(av);
            return d.getAsV3();
        }
        throw new FHIRException(this.context.formatMessage("Unknown_Date_format_", fmt));
    }

    private void parseResource(List<ValidationMessage> errors, String string, org.w3c.dom.Element container, Element parent, Property elementProperty) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        org.w3c.dom.Element res = XMLUtil.getFirstChild((org.w3c.dom.Element)container);
        String name = res.getLocalName();
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(name, null));
        if (sd == null) {
            throw new FHIRFormatError(this.context.formatMessage("Contained_resource_does_not_appear_to_be_a_FHIR_resource_unknown_name_", res.getLocalName()));
        }
        parent.updateProperty(new Property(this.context, sd.getSnapshot().getElement().get(0), sd, this.getProfileUtilities(), this.getContextUtilities()), Element.SpecialElement.fromProperty(parent.getProperty()), elementProperty);
        parent.setType(name);
        this.parseChildren(errors, res.getLocalName(), res, parent);
    }

    private void reapComments(org.w3c.dom.Element element, Element context) {
        Node node;
        for (node = element.getPreviousSibling(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 8) continue;
            context.getComments().add(0, node.getTextContent());
        }
        for (node = element.getLastChild(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
        }
        while (node != null) {
            if (node.getNodeType() == 8) {
                context.getComments().add(node.getTextContent());
            }
            node = node.getNextSibling();
        }
    }

    private boolean isAttr(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLATTR) continue;
            return true;
        }
        return false;
    }

    private boolean isCdaText(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.CDATEXT) continue;
            return true;
        }
        return false;
    }

    private boolean isTypeAttr(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.TYPEATTR) continue;
            return true;
        }
        return false;
    }

    private boolean isText(Property property) {
        for (Enumeration<ElementDefinition.PropertyRepresentation> r : property.getDefinition().getRepresentation()) {
            if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLTEXT) continue;
            return true;
        }
        return false;
    }

    @Override
    public void compose(Element e, OutputStream stream, IParser.OutputStyle style, String base) throws IOException, FHIRException {
        String ns;
        this.markedXhtml = false;
        XMLWriter xml = new XMLWriter(stream, "UTF-8");
        xml.setPretty(style == IParser.OutputStyle.PRETTY);
        if (style == IParser.OutputStyle.CANONICAL) {
            xml.setXmlHeader(false);
            xml.setIgnoreComments(true);
            xml.setCanonical(true);
        } else {
            xml.setCanonical(false);
        }
        xml.start();
        if (e.getPath() == null) {
            e.populatePaths(null);
        }
        if ((ns = e.getProperty().getXmlNamespace()) != null && !"noNamespace".equals(ns)) {
            xml.setDefaultNamespace(ns);
        }
        if (this.hasTypeAttr(e)) {
            xml.namespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        }
        if (Utilities.isAbsoluteUrl((String)e.getType())) {
            xml.namespace(this.urlRoot(e.getType()), "et");
        }
        this.addNamespaces((IXMLWriter)xml, e);
        this.composeElement((IXMLWriter)xml, e, e.getType(), true);
        xml.end();
    }

    private void addNamespaces(IXMLWriter xml, Element e) throws IOException {
        String ns = e.getProperty().getXmlNamespace();
        if (ns != null && xml.getDefaultNamespace() != null && !xml.getDefaultNamespace().equals(ns) && !xml.namespaceDefined(ns)) {
            String prefix = this.pathPrefix(ns);
            if (prefix.endsWith(":")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            if ("?".equals(prefix)) {
                xml.namespace(ns);
            } else {
                xml.namespace(ns, prefix);
            }
        }
        for (Element c : e.getChildren()) {
            this.addNamespaces(xml, c);
        }
    }

    private boolean hasTypeAttr(Element e) {
        if (this.isTypeAttr(e.getProperty())) {
            return true;
        }
        for (Element c : e.getChildren()) {
            if (!this.hasTypeAttr(c)) continue;
            return true;
        }
        return e.getType() != null && e.getType().startsWith("http://hl7.org/cda/stds/core");
    }

    private void setXsiTypeIfIsTypeAttr(IXMLWriter xml, Element element) throws IOException, FHIRException {
        if (this.isTypeAttr(element.getProperty()) && !Utilities.noString((String)element.getType())) {
            String type = element.getType();
            if (Utilities.isAbsoluteUrl((String)type)) {
                type = type.substring(type.lastIndexOf("/") + 1);
            }
            xml.attribute("xsi:type", type);
        }
    }

    public void compose(Element e, IXMLWriter xml) throws Exception {
        if (e.getPath() == null) {
            e.populatePaths(null);
        }
        this.markedXhtml = false;
        xml.start();
        xml.setDefaultNamespace(e.getProperty().getXmlNamespace());
        if (Utilities.isAbsoluteUrl((String)e.getType())) {
            xml.namespace(this.urlRoot(e.getType()), "et");
        }
        if (this.schemaPath != null) {
            xml.setSchemaLocation("http://hl7.org/fhir", Utilities.pathURL((String[])new String[]{this.schemaPath, e.fhirType() + ".xsd"}));
        }
        this.composeElement(xml, e, e.getType(), true);
        xml.end();
    }

    private void composeElement(IXMLWriter xml, Element element, String elementName, boolean root) throws IOException, FHIRException {
        if (this.canonicalFilter.contains(element.getPath())) {
            return;
        }
        if (!this.isElideElements() || !element.isElided()) {
            Object decorations;
            if (this.showDecorations && (decorations = (List)element.getUserData("fhir_decorations")) != null) {
                Iterator iterator = decorations.iterator();
                while (iterator.hasNext()) {
                    ElementDecoration d = (ElementDecoration)iterator.next();
                    xml.decorate(d);
                }
            }
            for (String s : element.getComments()) {
                xml.comment(s, true);
            }
        }
        if (this.isText(element.getProperty())) {
            if (this.isElideElements() && element.isElided() && xml.canElide()) {
                xml.elide();
            } else {
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                }
                xml.enter(element.getProperty().getXmlNamespace(), elementName);
                if (this.linkResolver != null && element.getProperty().isReference() && (ref = this.linkResolver.resolveReference(this.getReferenceForElement(element))) != null) {
                    xml.externalLink((String)ref);
                }
                xml.text(element.getValue());
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                }
                xml.exit(element.getProperty().getXmlNamespace(), elementName);
            }
        } else if (!(element.hasChildren() || element.hasValue() || element.hasXhtml())) {
            if (this.isElideElements() && element.isElided() && xml.canElide()) {
                xml.elide();
            } else {
                if (element.getExplicitType() != null) {
                    xml.attribute("xsi:type", element.getExplicitType());
                }
                xml.element(elementName);
            }
        } else if (element.isPrimitive() || element.hasType() && this.isPrimitive(element.getType())) {
            if (element.getType().equals("xhtml")) {
                if (this.isElideElements() && element.isElided() && xml.canElide()) {
                    xml.elide();
                } else {
                    Object xhtml;
                    if (element.getXhtml() == null && element.getValue() != null) {
                        xhtml = new XhtmlParser();
                        element.setXhtml(xhtml.setXmlMode(true).parse(element.getValue(), null).getDocumentElement());
                    }
                    if (this.isCdaText(element.getProperty())) {
                        new CDANarrativeFormat().convert(xml, element.getXhtml());
                    } else {
                        xhtml = new XhtmlComposer(true, false).setCanonical(xml.isCanonical()).compose(element.getXhtml());
                        xml.escapedText((String)xhtml);
                        if (!this.markedXhtml) {
                            xml.anchor("end-xhtml");
                            this.markedXhtml = true;
                        }
                    }
                }
            } else if (this.isText(element.getProperty())) {
                if (this.isElideElements() && element.isElided() && xml.canElide()) {
                    xml.elide();
                } else {
                    if (this.linkResolver != null) {
                        xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                    }
                    xml.text(element.getValue());
                }
            } else if (this.isElideElements() && element.isElided()) {
                xml.attributeElide();
            } else {
                this.setXsiTypeIfIsTypeAttr(xml, element);
                if (element.hasValue()) {
                    if (this.linkResolver != null) {
                        xml.link(this.linkResolver.resolveType(element.getType()));
                    }
                    xml.attribute("value", element.getValue());
                }
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                }
                if (element.hasChildren()) {
                    xml.enter(element.getProperty().getXmlNamespace(), elementName);
                    if (this.linkResolver != null && element.getProperty().isReference() && (ref = this.linkResolver.resolveReference(this.getReferenceForElement(element))) != null) {
                        xml.externalLink((String)ref);
                    }
                    for (Object child : element.getChildren()) {
                        this.composeElement(xml, (Element)child, ((Element)child).getName(), false);
                    }
                    if (this.linkResolver != null) {
                        xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                    }
                    xml.exit(element.getProperty().getXmlNamespace(), elementName);
                } else {
                    xml.element(elementName);
                }
            }
        } else {
            if (this.isElideElements() && element.isElided() && xml.canElide()) {
                xml.elide();
            } else {
                this.setXsiTypeIfIsTypeAttr(xml, element);
                HashSet<String> handled = new HashSet<String>();
                for (Element child : element.getChildren()) {
                    if (handled.contains(child.getName()) || !this.isAttr(child.getProperty()) || !this.wantCompose(element.getPath(), child)) continue;
                    handled.add(child.getName());
                    if (this.isElideElements() && child.isElided()) {
                        xml.attributeElide();
                        continue;
                    }
                    Object av = child.getValue();
                    if (child.getProperty().isList()) {
                        for (Element c2 : element.getChildren()) {
                            if (c2 == child || !c2.getName().equals(child.getName())) continue;
                            if (c2.isElided()) {
                                av = (String)av + " ...";
                                continue;
                            }
                            av = (String)av + " " + c2.getValue();
                        }
                    }
                    if (this.linkResolver != null) {
                        xml.link(this.linkResolver.resolveType(child.getType()));
                    }
                    if (ExtensionUtilities.hasExtension(child.getProperty().getDefinition(), "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format")) {
                        av = this.convertForDateFormatToExternal(ExtensionUtilities.readStringExtension((org.hl7.fhir.r5.model.Element)child.getProperty().getDefinition(), "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format"), (String)av);
                    }
                    xml.attribute(child.getProperty().getXmlNamespace(), child.getProperty().getXmlName(), (String)av);
                }
            }
            if (!element.getProperty().getDefinition().hasExtension("http://hl7.org/fhir/tools/StructureDefinition/xml-choice-group")) {
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                }
                if (!xml.namespaceDefined(element.getProperty().getXmlNamespace())) {
                    String abbrev = this.makeNamespaceAbbrev(element.getProperty(), xml);
                    xml.namespace(element.getProperty().getXmlNamespace(), abbrev);
                }
                if (Utilities.isAbsoluteUrl((String)elementName)) {
                    xml.enter(this.urlRoot(elementName), this.urlTail(elementName));
                } else {
                    xml.enter(element.getProperty().getXmlNamespace(), elementName);
                }
            }
            if (!root && element.getSpecial() != null) {
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                }
                xml.enter(element.getProperty().getXmlNamespace(), element.getType());
            }
            if (this.linkResolver != null && element.getProperty().isReference() && (ref = this.linkResolver.resolveReference(this.getReferenceForElement(element))) != null) {
                xml.externalLink((String)ref);
            }
            for (Object child : element.getChildren()) {
                if (!this.wantCompose(element.getPath(), (Element)child)) continue;
                if (this.isElideElements() && ((Element)child).isElided() && xml.canElide()) {
                    xml.elide();
                    continue;
                }
                if (this.isText(((Element)child).getProperty())) {
                    if (this.linkResolver != null) {
                        xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                    }
                    xml.text(((Element)child).getValue());
                    continue;
                }
                if (this.isAttr(((Element)child).getProperty())) continue;
                this.composeElement(xml, (Element)child, ((Element)child).getName(), false);
            }
            if (!element.getProperty().getDefinition().hasExtension("http://hl7.org/fhir/tools/StructureDefinition/xml-choice-group")) {
                if (this.linkResolver != null) {
                    xml.link(this.linkResolver.resolveProperty(element.getProperty()));
                }
                if (!root && element.getSpecial() != null) {
                    xml.exit(element.getProperty().getXmlNamespace(), element.getType());
                }
                if (Utilities.isAbsoluteUrl((String)elementName)) {
                    xml.exit(this.urlRoot(elementName), this.urlTail(elementName));
                } else {
                    xml.exit(element.getProperty().getXmlNamespace(), elementName);
                }
            }
        }
    }

    private String urlRoot(String elementName) {
        return elementName.substring(0, elementName.lastIndexOf("/"));
    }

    private String makeNamespaceAbbrev(Property property, IXMLWriter xml) {
        int i;
        ElementDefinition ed = property.getDefinition();
        String ns = property.getXmlNamespace();
        String n = property.getXmlName();
        String diff = property.getName().toLowerCase().replace(n.toLowerCase(), "");
        if (!Utilities.noString((String)diff) && diff.length() <= 5 && Utilities.isToken((String)diff) && !xml.abbreviationDefined(diff)) {
            return diff;
        }
        for (i = ns.length() - 1; i > 0 && (Character.isAlphabetic(ns.charAt(i)) || Character.isDigit(ns.charAt(i))); --i) {
        }
        String tail = ns.substring(i + 1);
        if (!Utilities.noString((String)tail) && tail.length() <= 5 && Utilities.isToken((String)tail) && !xml.abbreviationDefined(tail)) {
            return tail;
        }
        i = 0;
        while (xml.abbreviationDefined("ns" + i)) {
            ++i;
        }
        return "ns" + i;
    }

    private String checkHeader(List<ValidationMessage> errors, InputStream stream) throws IOException {
        try {
            int i0 = stream.read();
            int i1 = stream.read();
            int i2 = stream.read();
            StringBuilder b = new StringBuilder();
            if (i0 != 239 || i1 != 187 || i2 != 191) {
                if (i0 == 60 && i1 == 63 && i2 == 120) {
                    b.append((char)i0);
                    b.append((char)i1);
                    b.append((char)i2);
                } else {
                    if (i0 == 60) {
                        return "1.0";
                    }
                    throw new Exception(this.context.formatMessage("xml_encoding_invalid", new Object[0]));
                }
            }
            int i = stream.read();
            do {
                b.append((char)i);
            } while ((i = stream.read()) != 62);
            String header = b.toString();
            String e = null;
            i = header.indexOf("encoding=\"");
            if (i > -1) {
                e = header.substring(i + 10, i + 15);
            } else {
                i = header.indexOf("encoding='");
                if (i > -1) {
                    e = header.substring(i + 10, i + 15);
                }
            }
            if (e != null && !"UTF-8".equalsIgnoreCase(e)) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, 0, 0, "XML", ValidationMessage.IssueType.INVALID, this.context.formatMessage("xml_encoding_invalid", e), ValidationMessage.IssueSeverity.ERROR);
            }
            if ((i = header.indexOf("version=\"")) > -1) {
                return header.substring(i + 9, i + 12);
            }
            i = header.indexOf("version='");
            if (i > -1) {
                return header.substring(i + 9, i + 12);
            }
            return "?xml-p1?";
        }
        catch (Exception e) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, 0, 0, "XML", ValidationMessage.IssueType.INVALID, e.getMessage(), ValidationMessage.IssueSeverity.ERROR);
            return "?xml-p2?";
        }
    }

    public boolean isElideElements() {
        return this.elideElements;
    }

    public void setElideElements(boolean elideElements) {
        this.elideElements = elideElements;
    }

    class NullErrorHandler
    implements ErrorHandler {
        NullErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException e) {
        }

        @Override
        public void error(SAXParseException e) {
        }

        @Override
        public void warning(SAXParseException e) {
        }
    }
}

