/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.extensions;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.Factory;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ExtensionUtilities {
    private static Set<String> cachedConsts;

    public static Extension makeIssueSource(ValidationMessage.Source source) {
        Extension ex = new Extension();
        ex.setUrl("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
        StringType c = new StringType();
        c.setValue(source.toString());
        ex.setValue(c);
        return ex;
    }

    public static Extension makeIssueMessageId(String msgId) {
        Extension ex = new Extension();
        ex.setUrl("http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id");
        CodeType c = new CodeType();
        c.setValue(msgId);
        ex.setValue(c);
        return ex;
    }

    public static boolean hasExtension(DomainResource de, String url) {
        return ExtensionUtilities.getExtension(de, url) != null;
    }

    public static boolean hasExtension(Element e, String url) {
        return ExtensionUtilities.getExtension(e, url) != null;
    }

    public static void addMarkdownExtension(DomainResource dr, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ExtensionUtilities.getExtension(dr, url);
            if (ex != null) {
                ex.setValue(new StringType(content));
            } else {
                dr.getExtension().add(Factory.newExtension(url, new MarkdownType(content), true));
            }
        }
    }

    public static void addStringExtension(Element e, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ExtensionUtilities.getExtension(e, url);
            if (ex != null) {
                ex.setValue(new StringType(content));
            } else {
                e.getExtension().add(Factory.newExtension(url, new StringType(content), true));
            }
        }
    }

    public static void addCodeExtension(Element e, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ExtensionUtilities.getExtension(e, url);
            if (ex != null) {
                ex.setValue(new CodeType(content));
            } else {
                e.getExtension().add(Factory.newExtension(url, new CodeType(content), true));
            }
        }
    }

    public static void addStringExtension(DomainResource e, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ExtensionUtilities.getExtension(e, url);
            if (ex != null) {
                ex.setValue(new StringType(content));
            } else {
                e.getExtension().add(Factory.newExtension(url, new StringType(content), true));
            }
        }
    }

    public static void addBooleanExtension(Element e, String url, boolean content) {
        Extension ex = ExtensionUtilities.getExtension(e, url);
        if (ex != null) {
            ex.setValue(new BooleanType(content));
        } else {
            e.getExtension().add(Factory.newExtension(url, new BooleanType(content), true));
        }
    }

    public static void addBooleanExtension(DomainResource e, String url, boolean content) {
        Extension ex = ExtensionUtilities.getExtension(e, url);
        if (ex != null) {
            ex.setValue(new BooleanType(content));
        } else {
            e.getExtension().add(Factory.newExtension(url, new BooleanType(content), true));
        }
    }

    public static void addIntegerExtension(DomainResource dr, String url, int value) {
        Extension ex = ExtensionUtilities.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new IntegerType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new IntegerType(value), true));
        }
    }

    public static void addCodeExtension(DomainResource dr, String url, String value) {
        Extension ex = ExtensionUtilities.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new CodeType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new CodeType(value), true));
        }
    }

    public static void addVSComment(ValueSet.ConceptSetComponent nc, String comment) {
        if (!StringUtils.isBlank((CharSequence)comment)) {
            nc.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/valueset-concept-comments", Factory.newString_(comment), true));
        }
    }

    public static void addVSComment(ValueSet.ConceptReferenceComponent nc, String comment) {
        if (!StringUtils.isBlank((CharSequence)comment)) {
            nc.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/valueset-concept-comments", Factory.newString_(comment), true));
        }
    }

    public static void addDefinition(Element nc, String definition) {
        if (!StringUtils.isBlank((CharSequence)definition)) {
            nc.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/valueset-concept-definition", Factory.newString_(definition), true));
        }
    }

    public static void addDisplayHint(Element def, String hint) {
        if (!StringUtils.isBlank((CharSequence)hint)) {
            def.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-display-hint", Factory.newString_(hint), true));
        }
    }

    public static String getDisplayHint(Element def) {
        return ExtensionUtilities.readStringExtension(def, "http://hl7.org/fhir/StructureDefinition/structuredefinition-display-hint");
    }

    public static String readStringExtension(Element c, String ... uris) {
        for (String uri : uris) {
            if (!ExtensionUtilities.hasExtension(c, uri)) continue;
            return ExtensionUtilities.readStringExtension(c, uri);
        }
        return null;
    }

    public static String readStringFromExtension(Extension ext) {
        if (ext.hasValue() && ext.getValue().isPrimitive()) {
            return ext.getValue().primitiveValue();
        }
        return null;
    }

    public static String readStringExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (ex.getValue() instanceof UriType) {
            return (String)((UriType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof CanonicalType) {
            return (String)((CanonicalType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof CodeType) {
            return (String)((CodeType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof IntegerType) {
            return ((IntegerType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof Integer64Type) {
            return ((Integer64Type)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof DecimalType) {
            return ((DecimalType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof MarkdownType) {
            return (String)((MarkdownType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof PrimitiveType) {
            return ((PrimitiveType)ex.getValue()).primitiveValue();
        }
        if (!(ex.getValue() instanceof StringType)) {
            return null;
        }
        return (String)((StringType)ex.getValue()).getValue();
    }

    public static List<String> readStringExtensions(Element c, String uri) {
        ArrayList<String> res = new ArrayList<String>();
        List<Extension> list = ExtensionHelper.getExtensionList(c, uri);
        for (Extension ex : list) {
            if (ex == null) continue;
            if (ex.getValue() instanceof UriType) {
                res.add((String)((UriType)ex.getValue()).getValue());
            }
            if (ex.getValue() instanceof CanonicalType) {
                res.add((String)((CanonicalType)ex.getValue()).getValue());
            }
            if (ex.getValue() instanceof CodeType) {
                res.add((String)((CodeType)ex.getValue()).getValue());
            }
            if (ex.getValue() instanceof IntegerType) {
                res.add(((IntegerType)ex.getValue()).asStringValue());
            }
            if (ex.getValue() instanceof Integer64Type) {
                res.add(((Integer64Type)ex.getValue()).asStringValue());
            }
            if (ex.getValue() instanceof DecimalType) {
                res.add(((DecimalType)ex.getValue()).asStringValue());
            }
            if (ex.getValue() instanceof MarkdownType) {
                res.add((String)((MarkdownType)ex.getValue()).getValue());
            }
            if (ex.getValue() instanceof PrimitiveType) {
                res.add(((PrimitiveType)ex.getValue()).primitiveValue());
            }
            if (!(ex.getValue() instanceof StringType)) continue;
            res.add((String)((StringType)ex.getValue()).getValue());
        }
        return res;
    }

    public static String readStringExtension(DomainResource c, String ... uris) {
        for (String uri : uris) {
            if (!ExtensionUtilities.hasExtension(c, uri)) continue;
            return ExtensionUtilities.readStringExtension(c, uri);
        }
        return null;
    }

    public static String readStringExtension(DomainResource c, String uri) {
        Extension ex = ExtensionUtilities.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (ex.getValue() instanceof StringType) {
            return (String)((StringType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof UriType) {
            return (String)((UriType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof CodeType) {
            return (String)((CodeType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof IntegerType) {
            return ((IntegerType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof Integer64Type) {
            return ((Integer64Type)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof DecimalType) {
            return ((DecimalType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof MarkdownType) {
            return (String)((MarkdownType)ex.getValue()).getValue();
        }
        return null;
    }

    public static String readStringSubExtension(DomainResource c, String uri, String name) {
        Extension ex = ExtensionUtilities.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if ((ex = ExtensionUtilities.getExtension(ex, name)) == null) {
            return null;
        }
        if (ex.getValue() instanceof StringType) {
            return (String)((StringType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof UriType) {
            return (String)((UriType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof CodeType) {
            return (String)((CodeType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof IntegerType) {
            return ((IntegerType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof Integer64Type) {
            return ((Integer64Type)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof DecimalType) {
            return ((DecimalType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof MarkdownType) {
            return (String)((MarkdownType)ex.getValue()).getValue();
        }
        return null;
    }

    public static PrimitiveType<DataType> readPrimitiveExtension(DomainResource c, String uri) {
        Extension ex = ExtensionUtilities.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        return (PrimitiveType)ex.getValue();
    }

    public static boolean findStringExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        if (!(ex.getValue() instanceof StringType)) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)((CharSequence)((StringType)ex.getValue()).getValue()));
    }

    public static Boolean readBooleanExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return null;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean findBooleanExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        return ex.getValue() instanceof BooleanType;
    }

    public static Boolean readBooleanExtension(DomainResource c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return null;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean readBoolExtension(DomainResource c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return false;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean readBoolExtension(DomainResource c, String ... uris) {
        String uri;
        Extension ex = null;
        String[] stringArray = uris;
        int n = stringArray.length;
        for (int i = 0; i < n && (ex = ExtensionHelper.getExtension(c, uri = stringArray[i])) == null; ++i) {
        }
        if (ex == null) {
            return false;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return false;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean readBoolExtension(Element e, String uri) {
        Extension ex = ExtensionHelper.getExtension(e, uri);
        if (ex == null) {
            return false;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return false;
        }
        if (!ex.getValue().hasPrimitiveValue()) {
            return false;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean findBooleanExtension(DomainResource c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        return ex.getValue() instanceof BooleanType;
    }

    public static void addFlyOver(Questionnaire.QuestionnaireItemComponent item, String text, String linkId) {
        if (!StringUtils.isBlank((CharSequence)text)) {
            Questionnaire.QuestionnaireItemComponent display = item.addItem();
            display.setType(Questionnaire.QuestionnaireItemType.DISPLAY);
            display.setText(text);
            display.setLinkId(linkId);
            display.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl", Factory.newCodeableConcept("flyover", "http://hl7.org/fhir/questionnaire-item-control", "Fly-over"), true));
        }
    }

    public static void addMin(Questionnaire.QuestionnaireItemComponent item, int min) {
        item.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-minOccurs", Factory.newInteger(min), true));
    }

    public static void addMax(Questionnaire.QuestionnaireItemComponent item, int max) {
        item.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs", Factory.newInteger(max), true));
    }

    public static void addFhirType(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-fhirType", Factory.newString_(value), true));
    }

    public static void addControl(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl", Factory.newCodeableConcept(value, "http://hl7.org/fhir/questionnaire-item-control", value), true));
    }

    public static void addAllowedResource(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-referenceResource", Factory.newCode(value), true));
    }

    public static void addReferenceFilter(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-referenceFilter", Factory.newString_(value), true));
    }

    public static Extension getExtension(DomainResource resource, String name) {
        if (resource == null || name == null) {
            return null;
        }
        if (!resource.hasExtension()) {
            return null;
        }
        for (Extension e : resource.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return e;
        }
        return null;
    }

    public static Extension getExtension(Element el, String name) {
        if (name == null) {
            return null;
        }
        if (!el.hasExtension()) {
            return null;
        }
        for (Extension e : el.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return e;
        }
        return null;
    }

    public static void setStringExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new StringType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new StringType(value)));
        }
    }

    public static void setStringExtension(Element resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new StringType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new StringType(value)));
        }
    }

    public static void setUriExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UriType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new UriType(value)));
        }
    }

    public static void setUriExtension(Element resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UriType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new UriType(value)));
        }
    }

    public static void setCanonicalExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UriType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new CanonicalType(value)));
        }
    }

    public static void setCanonicalExtension(Element resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UriType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new CanonicalType(value)));
        }
    }

    public static void setUrlExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UrlType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new UrlType(value)));
        }
    }

    public static void setUrlExtension(Element resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UrlType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new UrlType(value)));
        }
    }

    public static void setCodeExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new CodeType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new CodeType(value)));
        }
    }

    public static void setCodeExtensionMod(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new CodeType(value));
        } else {
            resource.getModifierExtension().add(new Extension(uri).setValue(new CodeType(value)));
        }
    }

    public static void setCodeExtensionMod(BackboneElement resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new CodeType(value));
        } else {
            resource.getModifierExtension().add(new Extension(uri).setValue(new CodeType(value)));
        }
    }

    public static void setCodeExtension(Element element, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(element, uri);
        if (ext != null) {
            ext.setValue(new CodeType(value));
        } else {
            element.getExtension().add(new Extension(uri).setValue(new CodeType(value)));
        }
    }

    public static void setMarkdownExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new MarkdownType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new MarkdownType(value)));
        }
    }

    public static void setIntegerExtension(DomainResource resource, String uri, int value) {
        Extension ext = ExtensionUtilities.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new IntegerType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new IntegerType(value)));
        }
    }

    public static boolean hasLanguageTranslations(Element element) {
        for (Extension e : element.getExtension()) {
            if (!e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/translation")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLanguageTranslation(Element element, String lang) {
        for (Extension e : element.getExtension()) {
            Extension e1;
            if (!e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/translation") || (e1 = ExtensionHelper.getExtension(e, "lang")) == null || !(e1.getValue() instanceof CodeType) || !((String)((CodeType)e.getValue()).getValue()).equals(lang)) continue;
            return true;
        }
        return false;
    }

    public static String getLanguageTranslation(Element element, String lang) {
        for (Extension e : element.getExtension()) {
            Extension e1;
            if (!e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/translation") || (e1 = ExtensionHelper.getExtension(e, "lang")) == null || e1.getValue() == null || !(e1.getValue() instanceof CodeType) || !((String)((CodeType)e1.getValue()).getValue()).equals(lang) || (e1 = ExtensionHelper.getExtension(e, "content")) == null || !e1.hasValue()) continue;
            return e1.getValue().primitiveValue();
        }
        return null;
    }

    public static StringType getLanguageTranslationElement(Element element, String lang) {
        for (Extension e : element.getExtension()) {
            Extension e1;
            if (!e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/translation") || (e1 = ExtensionHelper.getExtension(e, "lang")) == null || e1.getValue() == null || !(e1.getValue() instanceof CodeType) || !((String)((CodeType)e1.getValue()).getValue()).equals(lang)) continue;
            e1 = ExtensionHelper.getExtension(e, "content");
            return (StringType)e1.getValue();
        }
        return null;
    }

    public static void addLanguageTranslation(Element element, String lang, String value) {
        if (Utilities.noString((String)lang) || Utilities.noString((String)value)) {
            return;
        }
        Extension extension = new Extension().setUrl("http://hl7.org/fhir/StructureDefinition/translation");
        extension.addExtension().setUrl("lang").setValue(new CodeType(lang));
        extension.addExtension().setUrl("content").setValue(new StringType(value));
        element.getExtension().add(extension);
    }

    public static void setLanguageTranslation(Element element, String lang, String value) {
        if (Utilities.noString((String)lang) || Utilities.noString((String)value)) {
            return;
        }
        for (Extension extension : element.getExtension()) {
            String l;
            if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(extension.getUrl()) || !lang.equals(l = extension.getExtensionString("lang"))) continue;
            ExtensionUtilities.setStringExtension(extension, "content", value);
            return;
        }
        Extension extension = new Extension().setUrl("http://hl7.org/fhir/StructureDefinition/translation");
        extension.addExtension().setUrl("lang").setValue(new CodeType(lang));
        extension.addExtension().setUrl("content").setValue(new StringType(value));
        element.getExtension().add(extension);
    }

    public static boolean hasAllowedUnits(ElementDefinition eld) {
        for (Extension e : eld.getExtension()) {
            if (!e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits")) continue;
            return true;
        }
        return false;
    }

    public static DataType getAllowedUnits(ElementDefinition eld) {
        for (Extension e : eld.getExtension()) {
            if (!e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits")) continue;
            return e.getValue();
        }
        return null;
    }

    public static void setAllowableUnits(ElementDefinition eld, CodeableConcept cc) {
        for (Extension e : eld.getExtension()) {
            if (!e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits")) continue;
            e.setValue(cc);
            return;
        }
        eld.getExtension().add(new Extension().setUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits").setValue(cc));
    }

    public static List<Extension> getExtensions(Element element, String url) {
        ArrayList<Extension> results = new ArrayList<Extension>();
        for (Extension ex : element.getExtension()) {
            if (!ex.getUrl().equals(url)) continue;
            results.add(ex);
        }
        return results;
    }

    public static List<Extension> getExtensions(DomainResource resource, String url) {
        ArrayList<Extension> results = new ArrayList<Extension>();
        for (Extension ex : resource.getExtension()) {
            if (!ex.getUrl().equals(url)) continue;
            results.add(ex);
        }
        return results;
    }

    public static void setExtension(Element focus, String url, Coding c) {
        for (Extension e : focus.getExtension()) {
            if (!e.getUrl().equals(url)) continue;
            e.setValue(c);
            return;
        }
        focus.getExtension().add(new Extension().setUrl(url).setValue(c));
    }

    public static void removeExtension(DomainResource focus, String url) {
        Iterator<Extension> i = focus.getExtension().iterator();
        while (i.hasNext()) {
            Extension e = i.next();
            if (!url.equals(e.getUrl())) continue;
            i.remove();
        }
    }

    public static void removeExtension(Element focus, String url) {
        Iterator<Extension> i = focus.getExtension().iterator();
        while (i.hasNext()) {
            Extension e = i.next();
            if (!e.getUrl().equals(url)) continue;
            i.remove();
        }
    }

    public static int readIntegerExtension(DomainResource dr, String uri, int defaultValue) {
        Extension ex = ExtensionHelper.getExtension(dr, uri);
        if (ex == null) {
            return defaultValue;
        }
        if (ex.getValue() instanceof IntegerType) {
            return (Integer)((IntegerType)ex.getValue()).getValue();
        }
        throw new Error("Unable to read extension " + uri + " as an integer");
    }

    public static int readIntegerExtension(Element e, String uri, int defaultValue) {
        Extension ex = ExtensionHelper.getExtension(e, uri);
        if (ex == null) {
            return defaultValue;
        }
        if (ex.getValue() instanceof IntegerType) {
            return (Integer)((IntegerType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof DecimalType) {
            return ((BigDecimal)((DecimalType)ex.getValue()).getValue()).intValue();
        }
        throw new Error("Unable to read extension " + uri + " as an integer");
    }

    public static Map<String, String> getLanguageTranslations(Element e) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Extension ext : e.getExtension()) {
            if (!ext.getUrl().equals("http://hl7.org/fhir/StructureDefinition/translation")) continue;
            String lang = ExtensionUtilities.readStringExtension((Element)ext, "lang");
            String value = ExtensionUtilities.readStringExtension((Element)ext, "content");
            res.put(lang, value);
        }
        return res;
    }

    public static StandardsStatus getStandardsStatus(DomainResource dr) throws FHIRException {
        return StandardsStatus.fromCode((String)ExtensionUtilities.readStringExtension(dr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"));
    }

    public static StandardsStatus getStandardsStatus(Element e) throws FHIRException {
        return StandardsStatus.fromCode((String)ExtensionUtilities.readStringExtension(e, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"));
    }

    public static void setStandardsStatus(DomainResource dr, StandardsStatus status, String normativeVersion) {
        if (status == null) {
            ExtensionUtilities.removeExtension(dr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status");
        } else {
            ExtensionUtilities.setCodeExtension(dr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status", status.toCode());
        }
        if (normativeVersion == null) {
            ExtensionUtilities.removeExtension(dr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version");
        } else {
            ExtensionUtilities.setCodeExtension(dr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version", normativeVersion);
        }
    }

    public static void setStandardsStatus(Element dr, StandardsStatus status, String normativeVersion) {
        if (status == null) {
            ExtensionUtilities.removeExtension(dr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status");
        } else {
            ExtensionUtilities.setCodeExtension(dr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status", status.toCode());
        }
        if (normativeVersion == null) {
            ExtensionUtilities.removeExtension(dr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version");
        } else {
            ExtensionUtilities.setCodeExtension(dr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version", normativeVersion);
        }
    }

    public static ValidationMessage readValidationMessage(OperationOutcome.OperationOutcomeIssueComponent issue, ValidationMessage.Source source) {
        ValidationMessage vm = new ValidationMessage();
        vm.setSource(source);
        vm.setLevel(ExtensionUtilities.mapSeverity(issue.getSeverity()));
        vm.setType(ExtensionUtilities.mapType(issue.getCode()));
        if (issue.hasExtension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line")) {
            vm.setLine(ExtensionUtilities.readIntegerExtension(issue, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line", 0));
        }
        if (issue.hasExtension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col")) {
            vm.setCol(ExtensionUtilities.readIntegerExtension(issue, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col", 0));
        }
        if (issue.hasExpression()) {
            vm.setLocation(issue.getExpression().get(0).asStringValue());
        }
        vm.setMessage(issue.getDetails().getText());
        if (issue.hasExtension("http://hl7.org/fhir/StructureDefinition/rendering-xhtml")) {
            vm.setHtml(ExtensionUtilities.readStringExtension((Element)issue, "http://hl7.org/fhir/StructureDefinition/rendering-xhtml"));
        }
        return vm;
    }

    private static ValidationMessage.IssueType mapType(OperationOutcome.IssueType code) {
        if (code == null) {
            return null;
        }
        switch (code) {
            case BUSINESSRULE: {
                return ValidationMessage.IssueType.BUSINESSRULE;
            }
            case CODEINVALID: {
                return ValidationMessage.IssueType.CODEINVALID;
            }
            case CONFLICT: {
                return ValidationMessage.IssueType.CONFLICT;
            }
            case DELETED: {
                return ValidationMessage.IssueType.DELETED;
            }
            case DUPLICATE: {
                return ValidationMessage.IssueType.DUPLICATE;
            }
            case EXCEPTION: {
                return ValidationMessage.IssueType.EXCEPTION;
            }
            case EXPIRED: {
                return ValidationMessage.IssueType.EXPIRED;
            }
            case EXTENSION: {
                return ValidationMessage.IssueType.EXTENSION;
            }
            case FORBIDDEN: {
                return ValidationMessage.IssueType.FORBIDDEN;
            }
            case INCOMPLETE: {
                return ValidationMessage.IssueType.INCOMPLETE;
            }
            case INFORMATIONAL: {
                return ValidationMessage.IssueType.INFORMATIONAL;
            }
            case INVALID: {
                return ValidationMessage.IssueType.INVALID;
            }
            case INVARIANT: {
                return ValidationMessage.IssueType.INVARIANT;
            }
            case LOCKERROR: {
                return ValidationMessage.IssueType.LOCKERROR;
            }
            case LOGIN: {
                return ValidationMessage.IssueType.LOGIN;
            }
            case MULTIPLEMATCHES: {
                return ValidationMessage.IssueType.MULTIPLEMATCHES;
            }
            case NOSTORE: {
                return ValidationMessage.IssueType.NOSTORE;
            }
            case NOTFOUND: {
                return ValidationMessage.IssueType.NOTFOUND;
            }
            case NOTSUPPORTED: {
                return ValidationMessage.IssueType.NOTSUPPORTED;
            }
            case NULL: {
                return ValidationMessage.IssueType.NULL;
            }
            case PROCESSING: {
                return ValidationMessage.IssueType.PROCESSING;
            }
            case REQUIRED: {
                return ValidationMessage.IssueType.REQUIRED;
            }
            case SECURITY: {
                return ValidationMessage.IssueType.SECURITY;
            }
            case STRUCTURE: {
                return ValidationMessage.IssueType.STRUCTURE;
            }
            case SUPPRESSED: {
                return ValidationMessage.IssueType.SUPPRESSED;
            }
            case THROTTLED: {
                return ValidationMessage.IssueType.THROTTLED;
            }
            case TIMEOUT: {
                return ValidationMessage.IssueType.TIMEOUT;
            }
            case TOOCOSTLY: {
                return ValidationMessage.IssueType.TOOCOSTLY;
            }
            case TOOLONG: {
                return ValidationMessage.IssueType.TOOLONG;
            }
            case TRANSIENT: {
                return ValidationMessage.IssueType.TRANSIENT;
            }
            case UNKNOWN: {
                return ValidationMessage.IssueType.UNKNOWN;
            }
            case VALUE: {
                return ValidationMessage.IssueType.VALUE;
            }
        }
        return null;
    }

    private static ValidationMessage.IssueSeverity mapSeverity(OperationOutcome.IssueSeverity severity) {
        if (severity == null) {
            return null;
        }
        switch (severity) {
            case ERROR: {
                return ValidationMessage.IssueSeverity.ERROR;
            }
            case FATAL: {
                return ValidationMessage.IssueSeverity.FATAL;
            }
            case INFORMATION: {
                return ValidationMessage.IssueSeverity.INFORMATION;
            }
            case WARNING: {
                return ValidationMessage.IssueSeverity.WARNING;
            }
        }
        return null;
    }

    public static String getPresentation(PrimitiveType<?> type) {
        if (type.hasExtension("http://hl7.org/fhir/StructureDefinition/rendered-value")) {
            return ExtensionUtilities.readStringExtension(type, "http://hl7.org/fhir/StructureDefinition/rendered-value");
        }
        return type.primitiveValue();
    }

    public static String getPresentation(Element holder, PrimitiveType<?> type) {
        if (holder.hasExtension("http://hl7.org/fhir/StructureDefinition/rendered-value")) {
            return ExtensionUtilities.readStringExtension(holder, "http://hl7.org/fhir/StructureDefinition/rendered-value");
        }
        if (type.hasExtension("http://hl7.org/fhir/StructureDefinition/rendered-value")) {
            return ExtensionUtilities.readStringExtension(type, "http://hl7.org/fhir/StructureDefinition/rendered-value");
        }
        return type.primitiveValue();
    }

    public static void addUrlExtension(Element e, String url, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        Extension ex = ExtensionUtilities.getExtension(e, url);
        if (ex != null) {
            ex.setValue(new UrlType(value));
        } else {
            e.getExtension().add(Factory.newExtension(url, new UrlType(value), true));
        }
    }

    public static void addUrlExtension(DomainResource dr, String url, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        Extension ex = ExtensionUtilities.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new UrlType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new UrlType(value), true));
        }
    }

    public static void addUriExtension(Element e, String url, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        Extension ex = ExtensionUtilities.getExtension(e, url);
        if (ex != null) {
            ex.setValue(new UriType(value));
        } else {
            e.getExtension().add(Factory.newExtension(url, new UriType(value), true));
        }
    }

    public static void addUriExtension(DomainResource dr, String url, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        Extension ex = ExtensionUtilities.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new UriType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new UriType(value), true));
        }
    }

    public static void addCanonicalExtension(Element e, String url, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        Extension ex = ExtensionUtilities.getExtension(e, url);
        if (ex != null) {
            ex.setValue(new CanonicalType(value));
        } else {
            e.getExtension().add(Factory.newExtension(url, new CanonicalType(value), true));
        }
    }

    public static void addCanonicalExtension(DomainResource dr, String url, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        Extension ex = ExtensionUtilities.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new CanonicalType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new CanonicalType(value), true));
        }
    }

    public static boolean usesExtension(String url, Base base) {
        if ("Extension".equals(base.fhirType())) {
            Property p = base.getNamedProperty("url");
            for (Base b : p.getValues()) {
                if (!url.equals(b.primitiveValue())) continue;
                return true;
            }
        }
        for (Property p : base.children()) {
            for (Base v : p.getValues()) {
                if (!ExtensionUtilities.usesExtension(url, v)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> allConsts() {
        if (cachedConsts == null) {
            HashSet<String> list = new HashSet<String>();
            for (Field field : ExtensionUtilities.class.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                try {
                    list.add(field.get(field.getType()).toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cachedConsts = list;
        }
        return cachedConsts;
    }

    public static boolean hasAnyOfExtensions(Element d, String ... urls) {
        for (String url : urls) {
            if (!d.hasExtension(url)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnyOfExtensions(DomainResource dr, String ... urls) {
        for (String url : urls) {
            if (!dr.hasExtension(url)) continue;
            return true;
        }
        return false;
    }

    public static int countExtensions(ElementDefinition d, String ... urls) {
        int res = 0;
        for (String url : urls) {
            if (!d.hasExtension(url)) continue;
            ++res;
        }
        return res;
    }

    public static boolean hasExtensionValue(StructureDefinition src, String url, String value) {
        for (Extension ext : src.getExtension()) {
            if (!url.equals(ext.getUrl()) || !ext.hasValue() || !value.equals(ext.getValue().primitiveValue())) continue;
            return true;
        }
        return false;
    }

    private static Extension setExtensionE(Element context, String url, DataType value) {
        for (Extension ext : context.getExtension()) {
            if (!ext.getUrl().equals(url)) continue;
            return ext.setValue(value);
        }
        return context.addExtension().setUrl(url).setValue(value);
    }

    private static Extension setExtensionBE(BackboneElement context, boolean mod, String url, DataType value) {
        if (mod) {
            for (Extension ext : context.getModifierExtension()) {
                if (!ext.getUrl().equals(url)) continue;
                return ext.setValue(value);
            }
            return context.addModifierExtension().setUrl(url).setValue(value);
        }
        return ExtensionUtilities.setExtensionE(context, url, value);
    }

    private static Extension setExtensionBT(BackboneType context, boolean mod, String url, DataType value) {
        if (mod) {
            for (Extension ext : context.getModifierExtension()) {
                if (!ext.getUrl().equals(url)) continue;
                return ext.setValue(value);
            }
            return context.addModifierExtension().setUrl(url).setValue(value);
        }
        return ExtensionUtilities.setExtensionE(context, url, value);
    }

    private static Extension setExtensionR(DomainResource context, boolean mod, String url, DataType value) {
        if (mod) {
            for (Extension ext : context.getModifierExtension()) {
                if (!ext.getUrl().equals(url)) continue;
                return ext.setValue(value);
            }
            return context.addModifierExtension().setUrl(url).setValue(value);
        }
        for (Extension ext : context.getExtension()) {
            if (!ext.getUrl().equals(url)) continue;
            return ext.setValue(value);
        }
        return context.addExtension().setUrl(url).setValue(value);
    }

    public static Extension setExtension(Base context, String url, DataType value) {
        boolean mod = ExtensionUtilities.isModifier(url);
        if (context instanceof BackboneElement) {
            return ExtensionUtilities.setExtensionBE((BackboneElement)context, mod, url, value);
        }
        if (mod && context instanceof BackboneType) {
            return ExtensionUtilities.setExtensionBT((BackboneType)context, mod, url, value);
        }
        if (context instanceof Element) {
            if (mod) {
                throw new FHIRException("Can't use a modifier extension on " + context.getClass().getName());
            }
            return ExtensionUtilities.setExtensionE((Element)context, url, value);
        }
        if (context instanceof DomainResource) {
            return ExtensionUtilities.setExtensionR((DomainResource)context, mod, url, value);
        }
        throw new FHIRException("Can't use an extension on " + context.getClass().getName());
    }

    private static Extension addExtensionE(Element context, String url, DataType value) {
        return context.addExtension().setValue(value);
    }

    private static Extension addExtensionBE(BackboneElement context, boolean mod, String url, DataType value) {
        if (mod) {
            return context.addModifierExtension().setValue(value);
        }
        return ExtensionUtilities.setExtensionE(context, url, value);
    }

    private static Extension addExtensionBT(BackboneType context, boolean mod, String url, DataType value) {
        if (mod) {
            return context.addModifierExtension().setUrl(url).setValue(value);
        }
        return ExtensionUtilities.setExtensionE(context, url, value);
    }

    private static Extension addExtensionR(DomainResource context, boolean mod, String url, DataType value) {
        if (mod) {
            return context.addModifierExtension().setUrl(url).setValue(value);
        }
        return context.addExtension().setUrl(url).setValue(value);
    }

    public static Extension addExtension(Base context, String url, DataType value) {
        boolean mod = ExtensionUtilities.isModifier(url);
        if (context instanceof BackboneElement) {
            return ExtensionUtilities.addExtensionBE((BackboneElement)context, mod, url, value);
        }
        if (mod && context instanceof BackboneType) {
            return ExtensionUtilities.addExtensionBT((BackboneType)context, mod, url, value);
        }
        if (context instanceof Element) {
            if (mod) {
                throw new FHIRException("Can't use a modifier extension on " + context.getClass().getName());
            }
            return ExtensionUtilities.addExtensionE((Element)context, url, value);
        }
        if (context instanceof DomainResource) {
            return ExtensionUtilities.addExtensionR((DomainResource)context, mod, url, value);
        }
        throw new FHIRException("Can't use an extension on " + context.getClass().getName());
    }

    private static List<Extension> getAllExtensions(Base context, String url) {
        ArrayList<Extension> list = new ArrayList<Extension>();
        boolean mod = ExtensionUtilities.isModifier(url);
        if (mod) {
            if (context instanceof BackboneElement) {
                list.addAll(((BackboneElement)context).getModifierExtension());
            }
            if (context instanceof BackboneType) {
                list.addAll(((BackboneElement)context).getModifierExtension());
            }
            if (context instanceof DomainResource) {
                list.addAll(((DomainResource)context).getModifierExtension());
            }
        } else {
            if (context instanceof Element) {
                list.addAll(((Element)context).getExtension());
            }
            if (context instanceof DomainResource) {
                list.addAll(((DomainResource)context).getExtension());
            }
        }
        return list;
    }

    public static <T extends DataType> T getExtension(Class<T> class_, Base context, String url) {
        boolean found = false;
        DataType result = null;
        for (Extension ext : ExtensionUtilities.getAllExtensions(context, url)) {
            if (!ext.hasUrl() || !ext.getUrl().equals(url)) continue;
            if (found) {
                throw new FHIRException("Multiple Extensions for " + url);
            }
            if (!ext.hasValue() || !class_.isInstance(ext.getValue())) continue;
            found = true;
            result = ext.getValue();
        }
        return (T)result;
    }

    public static <T extends DataType> List<T> getExtensionList(Class<T> class_, Base context, String url) {
        ArrayList<DataType> result = new ArrayList<DataType>();
        for (Extension ext : ExtensionUtilities.getAllExtensions(context, url)) {
            if (!ext.hasUrl() || !ext.getUrl().equals(url) || !ext.hasValue() || !class_.isInstance(ext.getValue())) continue;
            result.add(ext.getValue());
        }
        return result;
    }

    public static String getExtensionString(Base context, String url) {
        boolean found = false;
        String result = null;
        for (Extension ext : ExtensionUtilities.getAllExtensions(context, url)) {
            if (!ext.hasUrl() || !ext.getUrl().equals(url)) continue;
            if (found) {
                throw new FHIRException("Multiple Extensions for " + url);
            }
            if (!ext.hasValue() || !ext.getValue().isPrimitive()) continue;
            found = true;
            result = ext.getValue().primitiveValue();
        }
        return result;
    }

    public static Boolean getExtensionBoolean(Base context, String url) {
        boolean found = false;
        Boolean result = null;
        for (Extension ext : ExtensionUtilities.getAllExtensions(context, url)) {
            if (!ext.hasUrl() || !ext.getUrl().equals(url)) continue;
            if (found) {
                throw new FHIRException("Multiple Extensions for " + url);
            }
            if (!ext.hasValueBooleanType()) continue;
            found = true;
            result = (Boolean)ext.getValueBooleanType().getValue();
        }
        return result;
    }

    public static Integer getExtensionInt(Base context, String url) {
        boolean found = false;
        Integer result = null;
        for (Extension ext : ExtensionUtilities.getAllExtensions(context, url)) {
            if (!ext.hasUrl() || !ext.getUrl().equals(url)) continue;
            if (found) {
                throw new FHIRException("Multiple Extensions for " + url);
            }
            if (!ext.hasValueIntegerType()) continue;
            found = true;
            result = (Integer)ext.getValueIntegerType().getValue();
        }
        return result;
    }

    public static BigDecimal getExtensionFloat(Base context, String url) {
        boolean found = false;
        BigDecimal result = null;
        for (Extension ext : ExtensionUtilities.getAllExtensions(context, url)) {
            if (!ext.hasUrl() || !ext.getUrl().equals(url)) continue;
            if (found) {
                throw new FHIRException("Multiple Extensions for " + url);
            }
            if (!ext.hasValueIntegerType()) continue;
            found = true;
            result = (BigDecimal)ext.getValueDecimalType().getValue();
        }
        return result;
    }

    public static List<String> getExtensionStringList(Base context, String url) {
        ArrayList<String> result = new ArrayList<String>();
        for (Extension ext : ExtensionUtilities.getAllExtensions(context, url)) {
            if (!ext.hasUrl() || !ext.getUrl().equals(url) || !ext.hasValue() || !ext.getValue().isPrimitive()) continue;
            result.add(ext.getValue().primitiveValue());
        }
        return result;
    }

    public static List<Boolean> getExtensionBooleanList(Base context, String url) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Extension ext : ExtensionUtilities.getAllExtensions(context, url)) {
            if (!ext.hasUrl() || !ext.getUrl().equals(url) || !ext.hasValue() || !ext.getValue().isPrimitive()) continue;
            result.add(Boolean.valueOf(ext.getValue().primitiveValue()));
        }
        return result;
    }

    public static List<Integer> getExtensionIntList(Base context, String url) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Extension ext : ExtensionUtilities.getAllExtensions(context, url)) {
            if (!ext.hasUrl() || !ext.getUrl().equals(url) || !ext.hasValueIntegerType()) continue;
            result.add((Integer)ext.getValueIntegerType().getValue());
        }
        return result;
    }

    public static boolean stripExtensions(Element element, String ... exceptions) {
        return ExtensionUtilities.stripExtensions(element, (List<String>)Utilities.strings((String[])exceptions));
    }

    public static boolean stripExtensions(Element element, List<String> exceptions) {
        boolean res = element.getExtension().removeIf(ex -> !exceptions.contains(ex.getUrl()));
        if (element instanceof BackboneElement) {
            boolean bl = res = ((BackboneElement)element).getModifierExtension().removeIf(ex -> !exceptions.contains(ex.getUrl())) || res;
        }
        if (element instanceof BackboneElement) {
            res = ((BackboneElement)element).getModifierExtension().removeIf(ex -> !exceptions.contains(ex.getUrl())) || res;
        }
        for (Property p : element.children()) {
            for (Base v : p.getValues()) {
                if (v instanceof Element) {
                    res = ExtensionUtilities.stripExtensions((Element)v, exceptions) || res;
                    continue;
                }
                if (!(v instanceof Element)) continue;
                res = ExtensionUtilities.stripExtensions((Resource)v, exceptions) || res;
            }
        }
        return res;
    }

    public static boolean stripExtensions(Resource resource, String ... exceptions) {
        return ExtensionUtilities.stripExtensions(resource, (List<String>)Utilities.strings((String[])exceptions));
    }

    public static boolean stripExtensions(Resource resource, List<String> exceptions) {
        boolean res = false;
        if (resource instanceof DomainResource) {
            res = ((DomainResource)resource).getExtension().removeIf(ex -> !exceptions.contains(ex.getUrl())) || ((DomainResource)resource).getModifierExtension().removeIf(ex -> !exceptions.contains(ex.getUrl()));
        }
        for (Property p : resource.children()) {
            for (Base v : p.getValues()) {
                if (v instanceof Element) {
                    res = ExtensionUtilities.stripExtensions((Element)v, exceptions) || res;
                    continue;
                }
                if (!(v instanceof Element)) continue;
                res = ExtensionUtilities.stripExtensions((Resource)v, exceptions) || res;
            }
        }
        return res;
    }

    public static void copyExtensions(List<Extension> source, List<Extension> dest, String ... urls) {
        if (source != null && dest != null) {
            for (Extension ex : source) {
                if (!Utilities.existsInList((String)ex.getUrl(), (String[])urls)) continue;
                dest.add(ex.copy());
            }
        }
    }

    public static DataType getExtensionValue(List<Extension> extensions, String url) {
        for (Extension ex : extensions) {
            if (!ex.getUrl().equals(url)) continue;
            return ex.getValue();
        }
        return null;
    }

    public static String getExtensionString(List<Extension> extensions, String url) {
        for (Extension ex : extensions) {
            if (!ex.getUrl().equals(url)) continue;
            return ex.getValue().primitiveValue();
        }
        return null;
    }

    public static Integer getExtensionInteger(List<Extension> extensions, String url) {
        for (Extension ex : extensions) {
            if (!ex.getUrl().equals(url) || !ex.hasValueIntegerType()) continue;
            return (Integer)ex.getValueIntegerType().getValue();
        }
        return null;
    }

    public static boolean hasExtension(List<Extension> extensions, String url) {
        if (extensions == null) {
            return false;
        }
        for (Extension ex : extensions) {
            if (!ex.getUrl().equals(url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModifier(String url) {
        return Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/StructureDefinition/artifact-status", "http://hl7.org/fhir/StructureDefinition/capabilitystatement-prohibited", "http://hl7.org/fhir/StructureDefinition/request-doNotPerform"});
    }
}

