/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.fhirpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathFunctionDefinition;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.IHostApplicationServices;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.terminologies.TerminologyFunctions;
import org.hl7.fhir.utilities.fhirpath.FHIRPathConstantEvaluationMode;

public abstract class BaseHostServices
implements IHostApplicationServices {
    protected IWorkerContext context;
    protected Map<String, FHIRPathFunctionDefinition> functions = new HashMap<String, FHIRPathFunctionDefinition>();

    public BaseHostServices(IWorkerContext context) {
        this.context = context;
    }

    @Override
    public FHIRPathUtilityClasses.FunctionDetails resolveFunction(FHIRPathEngine engine, String functionName) {
        FHIRPathFunctionDefinition fd = this.functions.get(functionName);
        return fd == null ? null : fd.details();
    }

    @Override
    public TypeDetails checkFunction(FHIRPathEngine engine, Object appContext, String functionName, TypeDetails focus, List<TypeDetails> parameters) throws PathEngineException {
        FHIRPathFunctionDefinition fd = this.functions.get(functionName);
        return fd == null ? null : fd.check(engine, appContext, focus, parameters);
    }

    @Override
    public List<Base> executeFunction(FHIRPathEngine engine, Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
        FHIRPathFunctionDefinition fd = this.functions.get(functionName);
        return fd == null ? null : fd.execute(engine, appContext, focus, parameters);
    }

    public BaseHostServices registerFunction(FHIRPathFunctionDefinition function) {
        this.functions.put(function.name(), function);
        return this;
    }

    @Override
    public TypeDetails resolveConstantType(FHIRPathEngine engine, Object appContext, String name, FHIRPathConstantEvaluationMode mode) throws PathEngineException {
        if (mode == FHIRPathConstantEvaluationMode.EXPLICIT && name.equals("terminologies")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "TerminologyServices");
        }
        throw this.makeException("FHIRPATH_UNKNOWN_CONSTANT", name);
    }

    protected FHIRException makeException(String constName, Object ... args) {
        String fmt = this.context.formatMessage(constName, args);
        return new PathEngineException(fmt, constName);
    }

    @Override
    public List<Base> resolveConstant(FHIRPathEngine engine, Object appContext, String name, FHIRPathConstantEvaluationMode mode) throws PathEngineException {
        if (mode == FHIRPathConstantEvaluationMode.EXPLICIT && name.equals("terminologies")) {
            ArrayList<Base> res = new ArrayList<Base>();
            res.add(new TerminologyFunctions.TerminologiesObject());
            return res;
        }
        throw this.makeException("FHIRPATH_UNKNOWN_CONSTANT", name);
    }
}

