/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.formats;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.hl7.fhir.r5.formats.JsonCreator;
import org.hl7.fhir.r5.formats.JsonCreatorDirect;
import org.hl7.fhir.r5.formats.JsonNumberCanonicalizer;

public class JsonCreatorCanonical
implements JsonCreator {
    Stack<JsonCanObject> stack = new Stack();
    JsonCanObject root;
    JsonCreatorDirect jj;
    String name;

    private String canonicaliseDecimal(String v) {
        return JsonNumberCanonicalizer.toCanonicalJson(v);
    }

    public JsonCreatorCanonical(OutputStreamWriter osw) {
        this.jj = new JsonCreatorDirect(osw, false, false);
        this.name = null;
    }

    private String takeName() {
        String res = this.name;
        this.name = null;
        return res;
    }

    @Override
    public void beginObject() throws IOException {
        JsonCanObject obj = new JsonCanObject(this.takeName(), false);
        if (this.stack.isEmpty()) {
            this.root = obj;
        } else {
            this.stack.peek().addProp(obj);
        }
        this.stack.push(obj);
    }

    @Override
    public void endObject() throws IOException {
        this.stack.pop();
    }

    @Override
    public void nullValue() throws IOException {
        this.stack.peek().addProp(new JsonCanNullValue(this.takeName()));
    }

    @Override
    public void name(String name) throws IOException {
        this.name = name;
    }

    @Override
    public void value(String value) throws IOException {
        this.stack.peek().addProp(new JsonCanStringValue(this.takeName(), value));
    }

    @Override
    public void value(Boolean value) throws IOException {
        this.stack.peek().addProp(new JsonCanBooleanValue(this.takeName(), value));
    }

    @Override
    public void value(BigDecimal value) throws IOException {
        this.stack.peek().addProp(new JsonCanNumberValue(this.takeName(), value));
    }

    @Override
    public void valueNum(String value) throws IOException {
        this.stack.peek().addProp(new JsonCanPresentedNumberValue(this.takeName(), value));
    }

    @Override
    public void value(Integer value) throws IOException {
        this.stack.peek().addProp(new JsonCanIntegerValue(this.takeName(), value));
    }

    @Override
    public void beginArray() throws IOException {
        JsonCanObject obj = new JsonCanObject(this.takeName(), true);
        if (!this.stack.isEmpty()) {
            this.stack.peek().addProp(obj);
        }
        this.stack.push(obj);
    }

    @Override
    public void endArray() throws IOException {
        this.stack.pop();
    }

    @Override
    public void finish() throws IOException {
        this.writeObject(this.root);
    }

    private void writeObject(JsonCanObject obj) throws IOException {
        this.jj.beginObject();
        ArrayList<String> names = new ArrayList<String>();
        for (JsonCanValue v : obj.children) {
            names.add(v.name);
        }
        Collections.sort(names);
        for (String n : names) {
            this.jj.name(n);
            JsonCanValue v = this.getPropForName(n, obj.children);
            if (v instanceof JsonCanNumberValue) {
                this.jj.valueNum(((JsonCanNumberValue)v).value);
                continue;
            }
            if (v instanceof JsonCanPresentedNumberValue) {
                this.jj.valueNum(((JsonCanPresentedNumberValue)v).value);
                continue;
            }
            if (v instanceof JsonCanIntegerValue) {
                this.jj.value(((JsonCanIntegerValue)v).value);
                continue;
            }
            if (v instanceof JsonCanBooleanValue) {
                this.jj.value(((JsonCanBooleanValue)v).value);
                continue;
            }
            if (v instanceof JsonCanStringValue) {
                this.jj.value(((JsonCanStringValue)v).value);
                continue;
            }
            if (v instanceof JsonCanNullValue) {
                this.jj.nullValue();
                continue;
            }
            if (v instanceof JsonCanObject) {
                JsonCanObject o = (JsonCanObject)v;
                if (o.array) {
                    this.writeArray(o);
                    continue;
                }
                this.writeObject(o);
                continue;
            }
            throw new Error("not possible");
        }
        this.jj.endObject();
    }

    private JsonCanValue getPropForName(String name, List<JsonCanValue> children) {
        for (JsonCanValue child : children) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        return null;
    }

    private void writeArray(JsonCanObject arr) throws IOException {
        this.jj.beginArray();
        for (JsonCanValue v : arr.children) {
            if (v instanceof JsonCanNumberValue) {
                this.jj.valueNum(((JsonCanNumberValue)v).value);
                continue;
            }
            if (v instanceof JsonCanPresentedNumberValue) {
                this.jj.valueNum(((JsonCanPresentedNumberValue)v).value);
                continue;
            }
            if (v instanceof JsonCanIntegerValue) {
                this.jj.value(((JsonCanIntegerValue)v).value);
                continue;
            }
            if (v instanceof JsonCanBooleanValue) {
                this.jj.value(((JsonCanBooleanValue)v).value);
                continue;
            }
            if (v instanceof JsonCanStringValue) {
                this.jj.value(((JsonCanStringValue)v).value);
                continue;
            }
            if (v instanceof JsonCanNullValue) {
                this.jj.nullValue();
                continue;
            }
            if (v instanceof JsonCanObject) {
                JsonCanObject o = (JsonCanObject)v;
                if (o.array) {
                    this.writeArray(o);
                    continue;
                }
                this.writeObject(o);
                continue;
            }
            throw new Error("not possible");
        }
        this.jj.endArray();
    }

    @Override
    public void comment(String content) {
    }

    @Override
    public void link(String href) {
    }

    @Override
    public void anchor(String name) {
    }

    @Override
    public void externalLink(String string) {
    }

    @Override
    public boolean canElide() {
        return false;
    }

    @Override
    public void elide() {
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public class JsonCanObject
    extends JsonCanValue {
        boolean array;
        List<JsonCanValue> children;

        public JsonCanObject(String name, boolean array) {
            super(name);
            this.children = new ArrayList<JsonCanValue>();
            this.array = array;
        }

        public void addProp(JsonCanValue obj) {
            this.children.add(obj);
        }
    }

    public class JsonCanValue {
        String name;

        private JsonCanValue(String name) {
            this.name = name;
        }
    }

    private class JsonCanNullValue
    extends JsonCanValue {
        private JsonCanNullValue(String name) {
            super(name);
        }
    }

    private class JsonCanStringValue
    extends JsonCanValue {
        private String value;

        private JsonCanStringValue(String name, String value) {
            super(name);
            this.value = value;
        }
    }

    private class JsonCanBooleanValue
    extends JsonCanValue {
        private Boolean value;

        private JsonCanBooleanValue(String name, Boolean value) {
            super(name);
            this.value = value;
        }
    }

    private class JsonCanNumberValue
    extends JsonCanValue {
        private String value;

        private JsonCanNumberValue(String name, BigDecimal value) {
            super(name);
            this.value = JsonCreatorCanonical.this.canonicaliseDecimal(value.toPlainString());
        }
    }

    private class JsonCanPresentedNumberValue
    extends JsonCanValue {
        private String value;

        private JsonCanPresentedNumberValue(String name, String value) {
            super(name);
            this.value = JsonCreatorCanonical.this.canonicaliseDecimal(value);
        }
    }

    private class JsonCanIntegerValue
    extends JsonCanValue {
        private Integer value;

        private JsonCanIntegerValue(String name, Integer value) {
            super(name);
            this.value = value;
        }
    }
}

