/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.liquid;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathFunctionDefinition;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.testfactory.TestDataFactory;
import org.hl7.fhir.r5.testfactory.dataprovider.TableDataProvider;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class BaseTableWrapper
extends Base {
    private static final long serialVersionUID = 1L;
    private List<String> columns;
    private List<String> values;
    private List<List<String>> rows;
    private String value;
    private Map<String, TestDataFactory.DataTable> tables;

    private BaseTableWrapper() {
    }

    public static BaseTableWrapper forRows(List<String> columns, List<List<String>> rows) {
        BaseTableWrapper self = new BaseTableWrapper();
        self.columns = columns;
        self.rows = rows;
        return self;
    }

    public static BaseTableWrapper forRow(List<String> columns, List<String> values) {
        BaseTableWrapper self = new BaseTableWrapper();
        self.columns = columns;
        self.values = values;
        return self;
    }

    public static BaseTableWrapper forCell(String value) {
        BaseTableWrapper self = new BaseTableWrapper();
        self.value = value;
        return self;
    }

    public static BaseTableWrapper forTable(TableDataProvider dt) {
        BaseTableWrapper self = new BaseTableWrapper();
        self.columns = dt.columns();
        self.rows = new ArrayList<List<String>>();
        dt.reset();
        while (dt.nextRow()) {
            self.rows.add(dt.cells());
        }
        return self;
    }

    public static BaseTableWrapper forTable(TestDataFactory.DataTable dt) {
        BaseTableWrapper self = new BaseTableWrapper();
        self.columns = dt.getColumns();
        self.rows = dt.getRows();
        return self;
    }

    public Map<String, TestDataFactory.DataTable> getTables() {
        return this.tables;
    }

    public BaseTableWrapper setTables(Map<String, TestDataFactory.DataTable> tables) {
        this.tables = tables;
        return this;
    }

    @Override
    public String fhirType() {
        if (this.values != null || this.rows != null) {
            return "Object";
        }
        if (Utilities.existsInList((String)this.value, (String[])new String[]{"true", "false"})) {
            return "boolean";
        }
        if (Utilities.isInteger((String)this.value)) {
            return "integer";
        }
        if (Utilities.isDecimal((String)this.value, (boolean)true)) {
            return "decimal";
        }
        if (Utilities.isAbsoluteUrl((String)this.value)) {
            return "url";
        }
        return "string";
    }

    @Override
    public String getIdBase() {
        if (this.columns == null) {
            return null;
        }
        int i = this.columns.indexOf("id");
        if (i > -1) {
            return this.values.get(i);
        }
        return null;
    }

    @Override
    public void setIdBase(String value) {
        throw new Error("BaseTableWrapper is read only");
    }

    @Override
    public Base copy() {
        throw new Error("BaseTableWrapper is read only");
    }

    @Override
    public FhirPublication getFHIRPublicationVersion() {
        return FhirPublication.R5;
    }

    public String cell(String name) {
        int i;
        if (this.values != null && (i = this.columns.indexOf(name)) > -1) {
            return this.values.get(i);
        }
        return null;
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        int i;
        if (this.rows != null && "rows".equals(name)) {
            Base[] l = new Base[this.rows.size()];
            for (int i2 = 0; i2 < this.rows.size(); ++i2) {
                l[i2] = BaseTableWrapper.forRow(this.columns, this.rows.get(i2));
            }
            return l;
        }
        if (this.values != null && (i = this.columns.indexOf(name)) > -1) {
            Base[] l = new Base[]{BaseTableWrapper.forCell(this.values.get(i))};
            return l;
        }
        if ("row".equals(name) && this.values != null) {
            Base[] l = new Base[]{this};
            return l;
        }
        if (this.tables != null && this.tables.containsKey(name)) {
            Base[] l = new Base[]{BaseTableWrapper.forTable(this.tables.get(name)).setTables(this.tables)};
            return l;
        }
        return super.getProperty(hash, name, checkValid);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public boolean isPrimitive() {
        return this.value != null;
    }

    @Override
    public String primitiveValue() {
        return this.value;
    }

    public static class TableDateColumnFunction
    extends FHIRPathFunctionDefinition {
        @Override
        public String name() {
            return "dateColumn";
        }

        @Override
        public FHIRPathUtilityClasses.FunctionDetails details() {
            return new FHIRPathUtilityClasses.FunctionDetails("read a date(/time) column with the specified format", 2, 2);
        }

        @Override
        public TypeDetails check(FHIRPathEngine engine, Object appContext, TypeDetails focus, List<TypeDetails> parameters) {
            if (focus.hasType("Table")) {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
            return null;
        }

        @Override
        public List<Base> execute(FHIRPathEngine engine, Object appContext, List<Base> focus, List<List<Base>> parameters) {
            ArrayList<Base> list = new ArrayList<Base>();
            if (focus.size() == 1 && focus.get(0) instanceof BaseTableWrapper && parameters.size() == 2 && parameters.get(0).size() == 1 && parameters.get(1).size() == 1) {
                String cell;
                BaseTableWrapper tbl = (BaseTableWrapper)focus.get(0);
                String name = parameters.get(0).get(0).primitiveValue();
                String format = parameters.get(1).get(0).primitiveValue();
                if (tbl.columns.contains(name) && !Utilities.noString((String)(cell = tbl.cell(name)))) {
                    if ("excel.date".equals(format)) {
                        list.add(new StringType(cell.substring(0, 10)));
                    } else {
                        try {
                            list.add(new StringType(TableDateColumnFunction.convertToFhirDateTime(cell, format)));
                        }
                        catch (DateTimeParseException e) {
                            throw new IllegalArgumentException("Invalid date-time format: " + cell + " for format " + format, e);
                        }
                    }
                }
            }
            return list;
        }

        public static String convertToFhirDateTime(String dateTime, String inputFormat) {
            DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern(inputFormat, Locale.ENGLISH);
            DateTimeFormatter outputFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            if (inputFormat.contains("Z") || inputFormat.contains("x") || inputFormat.contains("X")) {
                ZonedDateTime parsedDateTime = ZonedDateTime.parse(dateTime, inputFormatter);
                return parsedDateTime.format(outputFormatter);
            }
            if (inputFormat.contains("h")) {
                LocalDateTime parsedDateTime = LocalDateTime.parse(dateTime, inputFormatter);
                return parsedDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            LocalDate parsedDate = LocalDate.parse(dateTime, inputFormatter);
            return parsedDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
    }

    public static class TableColumnFunction
    extends FHIRPathFunctionDefinition {
        @Override
        public String name() {
            return "column";
        }

        @Override
        public FHIRPathUtilityClasses.FunctionDetails details() {
            return new FHIRPathUtilityClasses.FunctionDetails("Look up a column by name", 1, 1);
        }

        @Override
        public TypeDetails check(FHIRPathEngine engine, Object appContext, TypeDetails focus, List<TypeDetails> parameters) {
            if (focus.hasType("Table")) {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "string");
            }
            return null;
        }

        @Override
        public List<Base> execute(FHIRPathEngine engine, Object appContext, List<Base> focus, List<List<Base>> parameters) {
            ArrayList<Base> list = new ArrayList<Base>();
            if (focus.size() == 1 && focus.get(0) instanceof BaseTableWrapper && parameters.size() == 1 && parameters.get(0).size() == 1) {
                BaseTableWrapper tbl = (BaseTableWrapper)focus.get(0);
                String name = parameters.get(0).get(0).primitiveValue();
                if (tbl.columns.contains(name)) {
                    list.add(new StringType(tbl.cell(name)));
                }
            }
            return list;
        }
    }
}

