/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.net.URI;
import org.hl7.fhir.r5.model.UriType;

@DatatypeDef(name="canonical", profileOf=UriType.class)
public class CanonicalType
extends UriType {
    private static final long serialVersionUID = 4L;

    public CanonicalType() {
    }

    public CanonicalType(String theValue) {
        super(theValue);
    }

    public CanonicalType(URI theValue) {
        super(theValue);
    }

    public static boolean matches(String canonical, String url, String version) {
        String v;
        String u = canonical.contains("|") ? canonical.substring(0, canonical.indexOf("|")) : canonical;
        String string = v = canonical.contains("|") ? canonical.substring(canonical.indexOf("|") + 1) : null;
        if (version == null) {
            return u.equals(url);
        }
        return u.equals(url) && (v == null || v.equals(version));
    }

    @Override
    public CanonicalType copy() {
        CanonicalType ret = new CanonicalType((String)this.getValue());
        this.copyValues(ret);
        return ret;
    }

    @Override
    public String fhirType() {
        return "canonical";
    }

    public String baseUrl() {
        String s = this.primitiveValue();
        return s == null || !s.contains("|") ? s : s.substring(0, s.indexOf("|"));
    }

    public String version() {
        String s = this.primitiveValue();
        return s == null || !s.contains("|") ? null : s.substring(s.indexOf("|") + 1);
    }

    public String getCanonical() {
        if (this.hasPrimitiveValue()) {
            return this.primitiveValue();
        }
        if (this.hasExtension("http://hl7.org/fhir/StructureDefinition/alternate-canonical")) {
            return this.getExtensionString("http://hl7.org/fhir/StructureDefinition/alternate-canonical");
        }
        return null;
    }

    public boolean hasVersion() {
        return this.getValue() != null && ((String)this.getValue()).contains("|");
    }

    public void addVersion(String version) {
        if (version != null) {
            this.setValue((String)this.getValue() + "|" + version);
        }
    }

    public static String urlWithVersion(String system, String version) {
        return system + (String)(version == null ? "" : "|" + version);
    }

    public boolean matches(String system, String version) {
        if (version == null) {
            return this.primitiveValue().equals(system) || this.primitiveValue().startsWith(system + "|");
        }
        return this.primitiveValue().equals(CanonicalType.urlWithVersion(system, version));
    }
}

