/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BiologicallyDerivedProductDispense;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceAssociation;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EncounterHistory;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestPlan;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ConceptMap", profile="http://hl7.org/fhir/StructureDefinition/ConceptMap")
public class ConceptMap
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this concept map, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this concept map is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the concept map is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the concept map", formalDefinition="A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the concept map", formalDefinition="The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="versionAlgorithm", type={StringType.class, Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How to compare versions", formalDefinition="Indicates the mechanism used to compare versions to determine which ConceptMap is more current.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/version-algorithm")
    protected DataType versionAlgorithm;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this concept map (computer friendly)", formalDefinition="A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this concept map (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the concept map.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this concept map. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the concept map was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher/steward (organization or individual)", formalDefinition="The name of the organization or individual responsible for the release and ongoing maintenance of the concept map.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the concept map", formalDefinition="A free text natural language description of the concept map from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate concept map instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for concept map (if applicable)", formalDefinition="A legal or geographic region in which the concept map is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this concept map is defined", formalDefinition="Explanation of why this concept map is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.")
    protected MarkdownType copyright;
    @Child(name="copyrightLabel", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Copyright holder and year(s)", formalDefinition="A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').")
    protected StringType copyrightLabel;
    @Child(name="approvalDate", type={DateType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the ConceptMap was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the ConceptMap was last reviewed by the publisher", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the ConceptMap is expected to be used", formalDefinition="The period during which the ConceptMap content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. Education, Treatment, Assessment, etc", formalDefinition="Descriptions related to the content of the ConceptMap. Topics provide a high-level categorization as well as keywords for the ConceptMap that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="author", type={ContactDetail.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the ConceptMap", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the ConceptMap.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the ConceptMap", formalDefinition="An individual or organization primarily responsible for internal coherence of the ConceptMap.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the ConceptMap", formalDefinition="An individual or organization asserted by the publisher to be primarily responsible for review of some aspect of the ConceptMap.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the ConceptMap", formalDefinition="An individual or organization asserted by the publisher to be responsible for officially endorsing the ConceptMap for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc", formalDefinition="Related artifacts such as additional documentation, justification, dependencies, bibliographic references, and predecessor and successor artifacts.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="property", type={}, order=26, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional properties of the mapping", formalDefinition="A property defines a slot through which additional information can be provided about a map from source -> target.")
    protected List<PropertyComponent> property;
    @Child(name="additionalAttribute", type={}, order=27, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Definition of an additional attribute to act as a data source or target", formalDefinition="An additionalAttribute defines an additional data element found in the source or target data model where the data will come from or be mapped to. Some mappings are based on data in addition to the source data element, where codes in multiple fields are combined to a single field (or vice versa).")
    protected List<AdditionalAttributeComponent> additionalAttribute;
    @Child(name="sourceScope", type={UriType.class, CanonicalType.class}, order=28, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source value set that contains the concepts that are being mapped", formalDefinition="Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.  Limits the scope of the map to source codes (ConceptMap.group.element code or valueSet) that are members of this value set.")
    protected DataType sourceScope;
    @Child(name="targetScope", type={UriType.class, CanonicalType.class}, order=29, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The target value set which provides context for the mappings", formalDefinition="Identifier for the target value set that provides important context about how the mapping choices are made.  Limits the scope of the map to target codes (ConceptMap.group.element.target code or valueSet) that are members of this value set.")
    protected DataType targetScope;
    @Child(name="group", type={}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Same source and target systems", formalDefinition="A group of mappings that all have the same source and target system.")
    protected List<ConceptMapGroupComponent> group;
    private static final long serialVersionUID = 1990005194L;
    @SearchParamDefinition(name="context-quantity", path="(ActivityDefinition.useContext.value.ofType(Quantity)) | (ActivityDefinition.useContext.value.ofType(Range)) | (ActorDefinition.useContext.value.ofType(Quantity)) | (ActorDefinition.useContext.value.ofType(Range)) | (CapabilityStatement.useContext.value.ofType(Quantity)) | (CapabilityStatement.useContext.value.ofType(Range)) | (ChargeItemDefinition.useContext.value.ofType(Quantity)) | (ChargeItemDefinition.useContext.value.ofType(Range)) | (Citation.useContext.value.ofType(Quantity)) | (Citation.useContext.value.ofType(Range)) | (CodeSystem.useContext.value.ofType(Quantity)) | (CodeSystem.useContext.value.ofType(Range)) | (CompartmentDefinition.useContext.value.ofType(Quantity)) | (CompartmentDefinition.useContext.value.ofType(Range)) | (ConceptMap.useContext.value.ofType(Quantity)) | (ConceptMap.useContext.value.ofType(Range)) | (ConditionDefinition.useContext.value.ofType(Quantity)) | (ConditionDefinition.useContext.value.ofType(Range)) | (EventDefinition.useContext.value.ofType(Quantity)) | (EventDefinition.useContext.value.ofType(Range)) | (Evidence.useContext.value.ofType(Quantity)) | (Evidence.useContext.value.ofType(Range)) | (EvidenceReport.useContext.value.ofType(Quantity)) | (EvidenceReport.useContext.value.ofType(Range)) | (EvidenceVariable.useContext.value.ofType(Quantity)) | (EvidenceVariable.useContext.value.ofType(Range)) | (ExampleScenario.useContext.value.ofType(Quantity)) | (ExampleScenario.useContext.value.ofType(Range)) | (GraphDefinition.useContext.value.ofType(Quantity)) | (GraphDefinition.useContext.value.ofType(Range)) | (ImplementationGuide.useContext.value.ofType(Quantity)) | (ImplementationGuide.useContext.value.ofType(Range)) | (Library.useContext.value.ofType(Quantity)) | (Library.useContext.value.ofType(Range)) | (Measure.useContext.value.ofType(Quantity)) | (Measure.useContext.value.ofType(Range)) | (MessageDefinition.useContext.value.ofType(Quantity)) | (MessageDefinition.useContext.value.ofType(Range)) | (NamingSystem.useContext.value.ofType(Quantity)) | (NamingSystem.useContext.value.ofType(Range)) | (OperationDefinition.useContext.value.ofType(Quantity)) | (OperationDefinition.useContext.value.ofType(Range)) | (PlanDefinition.useContext.value.ofType(Quantity)) | (PlanDefinition.useContext.value.ofType(Range)) | (Questionnaire.useContext.value.ofType(Quantity)) | (Questionnaire.useContext.value.ofType(Range)) | (Requirements.useContext.value.ofType(Quantity)) | (Requirements.useContext.value.ofType(Range)) | (SearchParameter.useContext.value.ofType(Quantity)) | (SearchParameter.useContext.value.ofType(Range)) | (StructureDefinition.useContext.value.ofType(Quantity)) | (StructureDefinition.useContext.value.ofType(Range)) | (StructureMap.useContext.value.ofType(Quantity)) | (StructureMap.useContext.value.ofType(Range)) | (TerminologyCapabilities.useContext.value.ofType(Quantity)) | (TerminologyCapabilities.useContext.value.ofType(Range)) | (TestScript.useContext.value.ofType(Quantity)) | (TestScript.useContext.value.ofType(Range)) | (ValueSet.useContext.value.ofType(Quantity)) | (ValueSet.useContext.value.ofType(Range))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A quantity- or range-valued use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A quantity- or range-valued use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A quantity- or range-valued use context assigned to the charge item definition\r\n* [Citation](citation.html): A quantity- or range-valued use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A quantity- or range-valued use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A quantity- or range-valued use context assigned to the event definition\r\n* [Evidence](evidence.html): A quantity- or range-valued use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A quantity- or range-valued use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A quantity- or range-valued use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A quantity- or range-valued use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [Library](library.html): A quantity- or range-valued use context assigned to the library\r\n* [Measure](measure.html): A quantity- or range-valued use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A quantity- or range-valued use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A quantity- or range-valued use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A quantity- or range-valued use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A quantity- or range-valued use context assigned to the test script\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and quantity- or range-based value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and quantity- or range-based value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and quantity- or range-based value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and quantity- or range-based value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and quantity- or range-based value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and quantity- or range-based value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and quantity- or range-based value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and quantity- or range-based value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and quantity- or range-based value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and quantity- or range-based value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [Library](library.html): A use context type and quantity- or range-based value assigned to the library\r\n* [Measure](measure.html): A use context type and quantity- or range-based value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and quantity- or range-based value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and quantity- or range-based value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and quantity- or range-based value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and quantity- or range-based value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [Library](library.html): A use context type and value assigned to the library\r\n* [Measure](measure.html): A use context type and value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ActivityDefinition.useContext.code | ActorDefinition.useContext.code | CapabilityStatement.useContext.code | ChargeItemDefinition.useContext.code | Citation.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | ConditionDefinition.useContext.code | EventDefinition.useContext.code | Evidence.useContext.code | EvidenceReport.useContext.code | EvidenceVariable.useContext.code | ExampleScenario.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | Library.useContext.code | Measure.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | PlanDefinition.useContext.code | Questionnaire.useContext.code | Requirements.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | TestScript.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A type of use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A type of use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A type of use context assigned to the charge item definition\r\n* [Citation](citation.html): A type of use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A type of use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A type of use context assigned to the event definition\r\n* [Evidence](evidence.html): A type of use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A type of use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A type of use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A type of use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [Library](library.html): A type of use context assigned to the library\r\n* [Measure](measure.html): A type of use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A type of use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A type of use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A type of use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A type of use context assigned to the test script\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ActivityDefinition.useContext.value.ofType(CodeableConcept)) | (ActorDefinition.useContext.value.ofType(CodeableConcept)) | (CapabilityStatement.useContext.value.ofType(CodeableConcept)) | (ChargeItemDefinition.useContext.value.ofType(CodeableConcept)) | (Citation.useContext.value.ofType(CodeableConcept)) | (CodeSystem.useContext.value.ofType(CodeableConcept)) | (CompartmentDefinition.useContext.value.ofType(CodeableConcept)) | (ConceptMap.useContext.value.ofType(CodeableConcept)) | (ConditionDefinition.useContext.value.ofType(CodeableConcept)) | (EventDefinition.useContext.value.ofType(CodeableConcept)) | (Evidence.useContext.value.ofType(CodeableConcept)) | (EvidenceReport.useContext.value.ofType(CodeableConcept)) | (EvidenceVariable.useContext.value.ofType(CodeableConcept)) | (ExampleScenario.useContext.value.ofType(CodeableConcept)) | (GraphDefinition.useContext.value.ofType(CodeableConcept)) | (ImplementationGuide.useContext.value.ofType(CodeableConcept)) | (Library.useContext.value.ofType(CodeableConcept)) | (Measure.useContext.value.ofType(CodeableConcept)) | (MessageDefinition.useContext.value.ofType(CodeableConcept)) | (NamingSystem.useContext.value.ofType(CodeableConcept)) | (OperationDefinition.useContext.value.ofType(CodeableConcept)) | (PlanDefinition.useContext.value.ofType(CodeableConcept)) | (Questionnaire.useContext.value.ofType(CodeableConcept)) | (Requirements.useContext.value.ofType(CodeableConcept)) | (SearchParameter.useContext.value.ofType(CodeableConcept)) | (StructureDefinition.useContext.value.ofType(CodeableConcept)) | (StructureMap.useContext.value.ofType(CodeableConcept)) | (TerminologyCapabilities.useContext.value.ofType(CodeableConcept)) | (TestScript.useContext.value.ofType(CodeableConcept)) | (ValueSet.useContext.value.ofType(CodeableConcept))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context assigned to the charge item definition\r\n* [Citation](citation.html): A use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context assigned to the event definition\r\n* [Evidence](evidence.html): A use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [Library](library.html): A use context assigned to the library\r\n* [Measure](measure.html): A use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context assigned to the test script\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ActivityDefinition.date | ActorDefinition.date | CapabilityStatement.date | ChargeItemDefinition.date | Citation.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | ConditionDefinition.date | EventDefinition.date | Evidence.date | EvidenceVariable.date | ExampleScenario.date | GraphDefinition.date | ImplementationGuide.date | Library.date | Measure.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | PlanDefinition.date | Questionnaire.date | Requirements.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | SubscriptionTopic.date | TerminologyCapabilities.date | TestScript.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The activity definition publication date\r\n* [ActorDefinition](actordefinition.html): The Actor Definition publication date\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The charge item definition publication date\r\n* [Citation](citation.html): The citation publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [ConditionDefinition](conditiondefinition.html): The condition definition publication date\r\n* [EventDefinition](eventdefinition.html): The event definition publication date\r\n* [Evidence](evidence.html): The evidence publication date\r\n* [EvidenceVariable](evidencevariable.html): The evidence variable publication date\r\n* [ExampleScenario](examplescenario.html): The example scenario publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [Library](library.html): The library publication date\r\n* [Measure](measure.html): The measure publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [PlanDefinition](plandefinition.html): The plan definition publication date\r\n* [Questionnaire](questionnaire.html): The questionnaire publication date\r\n* [Requirements](requirements.html): The requirements publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [SubscriptionTopic](subscriptiontopic.html): Date status first applied\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [TestScript](testscript.html): The test script publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="ActivityDefinition.description | ActorDefinition.description | CapabilityStatement.description | ChargeItemDefinition.description | Citation.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | ConditionDefinition.description | EventDefinition.description | Evidence.description | EvidenceVariable.description | GraphDefinition.description | ImplementationGuide.description | Library.description | Measure.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | PlanDefinition.description | Questionnaire.description | Requirements.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | TestScript.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The description of the activity definition\r\n* [ActorDefinition](actordefinition.html): The description of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The description of the charge item definition\r\n* [Citation](citation.html): The description of the citation\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The description of the condition definition\r\n* [EventDefinition](eventdefinition.html): The description of the event definition\r\n* [Evidence](evidence.html): The description of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The description of the evidence variable\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [Library](library.html): The description of the library\r\n* [Measure](measure.html): The description of the measure\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [PlanDefinition](plandefinition.html): The description of the plan definition\r\n* [Questionnaire](questionnaire.html): The description of the questionnaire\r\n* [Requirements](requirements.html): The description of the requirements\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [TestScript](testscript.html): The description of the test script\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier | ActorDefinition.identifier | CapabilityStatement.identifier | ChargeItemDefinition.identifier | Citation.identifier | CodeSystem.identifier | ConceptMap.identifier | ConditionDefinition.identifier | EventDefinition.identifier | Evidence.identifier | EvidenceReport.identifier | EvidenceVariable.identifier | ExampleScenario.identifier | GraphDefinition.identifier | ImplementationGuide.identifier | Library.identifier | Measure.identifier | MedicationKnowledge.identifier | MessageDefinition.identifier | NamingSystem.identifier | ObservationDefinition.identifier | OperationDefinition.identifier | PlanDefinition.identifier | Questionnaire.identifier | Requirements.identifier | SearchParameter.identifier | SpecimenDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | SubscriptionTopic.identifier | TerminologyCapabilities.identifier | TestPlan.identifier | TestScript.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): External identifier for the activity definition\r\n* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition\r\n* [Citation](citation.html): External identifier for the citation\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition\r\n* [EventDefinition](eventdefinition.html): External identifier for the event definition\r\n* [Evidence](evidence.html): External identifier for the evidence\r\n* [EvidenceReport](evidencereport.html): External identifier for the evidence report\r\n* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable\r\n* [ExampleScenario](examplescenario.html): External identifier for the example scenario\r\n* [GraphDefinition](graphdefinition.html): External identifier for the graph definition\r\n* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide\r\n* [Library](library.html): External identifier for the library\r\n* [Measure](measure.html): External identifier for the measure\r\n* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [NamingSystem](namingsystem.html): External identifier for the naming system\r\n* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition\r\n* [OperationDefinition](operationdefinition.html): External identifier for the search parameter\r\n* [PlanDefinition](plandefinition.html): External identifier for the plan definition\r\n* [Questionnaire](questionnaire.html): External identifier for the questionnaire\r\n* [Requirements](requirements.html): External identifier for the requirements\r\n* [SearchParameter](searchparameter.html): External identifier for the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [TestPlan](testplan.html): An identifier for the test plan\r\n* [TestScript](testscript.html): External identifier for the test script\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ActivityDefinition.jurisdiction | ActorDefinition.jurisdiction | CapabilityStatement.jurisdiction | ChargeItemDefinition.jurisdiction | Citation.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | ConditionDefinition.jurisdiction | EventDefinition.jurisdiction | ExampleScenario.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | Library.jurisdiction | Measure.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | PlanDefinition.jurisdiction | Questionnaire.jurisdiction | Requirements.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | TestScript.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Intended jurisdiction for the activity definition\r\n* [ActorDefinition](actordefinition.html): Intended jurisdiction for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Intended jurisdiction for the charge item definition\r\n* [Citation](citation.html): Intended jurisdiction for the citation\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Intended jurisdiction for the condition definition\r\n* [EventDefinition](eventdefinition.html): Intended jurisdiction for the event definition\r\n* [ExampleScenario](examplescenario.html): Intended jurisdiction for the example scenario\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [Library](library.html): Intended jurisdiction for the library\r\n* [Measure](measure.html): Intended jurisdiction for the measure\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [PlanDefinition](plandefinition.html): Intended jurisdiction for the plan definition\r\n* [Questionnaire](questionnaire.html): Intended jurisdiction for the questionnaire\r\n* [Requirements](requirements.html): Intended jurisdiction for the requirements\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [TestScript](testscript.html): Intended jurisdiction for the test script\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ActivityDefinition.name | CapabilityStatement.name | Citation.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | ConditionDefinition.name | EventDefinition.name | EvidenceVariable.name | ExampleScenario.name | GraphDefinition.name | ImplementationGuide.name | Library.name | Measure.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | PlanDefinition.name | Questionnaire.name | Requirements.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | TestScript.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Computationally friendly name of the activity definition\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [Citation](citation.html): Computationally friendly name of the citation\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Computationally friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): Computationally friendly name of the event definition\r\n* [EvidenceVariable](evidencevariable.html): Computationally friendly name of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Computationally friendly name of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [Library](library.html): Computationally friendly name of the library\r\n* [Measure](measure.html): Computationally friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): Computationally friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): Computationally friendly name of the questionnaire\r\n* [Requirements](requirements.html): Computationally friendly name of the requirements\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): Computationally friendly name of the test script\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ActivityDefinition.publisher | ActorDefinition.publisher | CapabilityStatement.publisher | ChargeItemDefinition.publisher | Citation.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | ConditionDefinition.publisher | EventDefinition.publisher | Evidence.publisher | EvidenceReport.publisher | EvidenceVariable.publisher | ExampleScenario.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | Library.publisher | Measure.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | PlanDefinition.publisher | Questionnaire.publisher | Requirements.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | TestScript.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Name of the publisher of the activity definition\r\n* [ActorDefinition](actordefinition.html): Name of the publisher of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Name of the publisher of the charge item definition\r\n* [Citation](citation.html): Name of the publisher of the citation\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Name of the publisher of the condition definition\r\n* [EventDefinition](eventdefinition.html): Name of the publisher of the event definition\r\n* [Evidence](evidence.html): Name of the publisher of the evidence\r\n* [EvidenceReport](evidencereport.html): Name of the publisher of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): Name of the publisher of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Name of the publisher of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [Library](library.html): Name of the publisher of the library\r\n* [Measure](measure.html): Name of the publisher of the measure\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [PlanDefinition](plandefinition.html): Name of the publisher of the plan definition\r\n* [Questionnaire](questionnaire.html): Name of the publisher of the questionnaire\r\n* [Requirements](requirements.html): Name of the publisher of the requirements\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [TestScript](testscript.html): Name of the publisher of the test script\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestPlan.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestPlan](testplan.html): The current status of the test plan\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ActivityDefinition.title | ActorDefinition.title | CapabilityStatement.title | ChargeItemDefinition.title | Citation.title | CodeSystem.title | ConceptMap.title | ConditionDefinition.title | EventDefinition.title | Evidence.title | EvidenceVariable.title | ImplementationGuide.title | Library.title | Measure.title | MessageDefinition.title | ObservationDefinition.title | OperationDefinition.title | PlanDefinition.title | Questionnaire.title | Requirements.title | SpecimenDefinition.title | StructureDefinition.title | StructureMap.title | SubscriptionTopic.title | TerminologyCapabilities.title | TestScript.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The human-friendly name of the activity definition\r\n* [ActorDefinition](actordefinition.html): The human-friendly name of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The human-friendly name of the charge item definition\r\n* [Citation](citation.html): The human-friendly name of the citation\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The human-friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): The human-friendly name of the event definition\r\n* [Evidence](evidence.html): The human-friendly name of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The human-friendly name of the evidence variable\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [Library](library.html): The human-friendly name of the library\r\n* [Measure](measure.html): The human-friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [ObservationDefinition](observationdefinition.html): Human-friendly name of the ObservationDefinition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): The human-friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): The human-friendly name of the questionnaire\r\n* [Requirements](requirements.html): The human-friendly name of the requirements\r\n* [SpecimenDefinition](specimendefinition.html): Human-friendly name of the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Name for this SubscriptionTopic (Human friendly)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): The human-friendly name of the test script\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestPlan.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestPlan](testplan.html): The uri that identifies the test plan\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ActivityDefinition.version | ActorDefinition.version | CapabilityStatement.version | ChargeItemDefinition.version | Citation.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | ConditionDefinition.version | EventDefinition.version | Evidence.version | EvidenceVariable.version | ExampleScenario.version | GraphDefinition.version | ImplementationGuide.version | Library.version | Measure.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | PlanDefinition.version | Questionnaire.version | Requirements.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | SubscriptionTopic.version | TerminologyCapabilities.version | TestScript.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The business version of the activity definition\r\n* [ActorDefinition](actordefinition.html): The business version of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The business version of the charge item definition\r\n* [Citation](citation.html): The business version of the citation\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The business version of the condition definition\r\n* [EventDefinition](eventdefinition.html): The business version of the event definition\r\n* [Evidence](evidence.html): The business version of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The business version of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The business version of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [Library](library.html): The business version of the library\r\n* [Measure](measure.html): The business version of the measure\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [PlanDefinition](plandefinition.html): The business version of the plan definition\r\n* [Questionnaire](questionnaire.html): The business version of the questionnaire\r\n* [Requirements](requirements.html): The business version of the requirements\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business version of the SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [TestScript](testscript.html): The business version of the test script\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="mapping-property", path="ConceptMap.property.uri", description="Other properties required for this mapping", type="uri")
    public static final String SP_MAPPING_PROPERTY = "mapping-property";
    public static final UriClientParam MAPPING_PROPERTY = new UriClientParam("mapping-property");
    @SearchParamDefinition(name="other-map", path="ConceptMap.group.unmapped.otherMap", description="canonical reference to an additional ConceptMap to use for mapping if the source concept is unmapped", type="reference", target={ConceptMap.class})
    public static final String SP_OTHER_MAP = "other-map";
    public static final ReferenceClientParam OTHER_MAP = new ReferenceClientParam("other-map");
    public static final Include INCLUDE_OTHER_MAP = new Include("ConceptMap:other-map").toLocked();
    @SearchParamDefinition(name="source-code", path="ConceptMap.group.element.code", description="Identifies elements being mapped", type="token")
    public static final String SP_SOURCE_CODE = "source-code";
    public static final TokenClientParam SOURCE_CODE = new TokenClientParam("source-code");
    @SearchParamDefinition(name="source-group-system", path="ConceptMap.group.source", description="Source system where concepts to be mapped are defined", type="reference", target={CodeSystem.class})
    public static final String SP_SOURCE_GROUP_SYSTEM = "source-group-system";
    public static final ReferenceClientParam SOURCE_GROUP_SYSTEM = new ReferenceClientParam("source-group-system");
    public static final Include INCLUDE_SOURCE_GROUP_SYSTEM = new Include("ConceptMap:source-group-system").toLocked();
    @SearchParamDefinition(name="source-scope-uri", path="(ConceptMap.sourceScope as uri)", description="The URI for the source value set that contains the concepts being mapped", type="uri")
    public static final String SP_SOURCE_SCOPE_URI = "source-scope-uri";
    public static final UriClientParam SOURCE_SCOPE_URI = new UriClientParam("source-scope-uri");
    @SearchParamDefinition(name="source-scope", path="(ConceptMap.sourceScope as canonical)", description="The source value set that contains the concepts that are being mapped", type="reference", target={ValueSet.class})
    public static final String SP_SOURCE_SCOPE = "source-scope";
    public static final ReferenceClientParam SOURCE_SCOPE = new ReferenceClientParam("source-scope");
    public static final Include INCLUDE_SOURCE_SCOPE = new Include("ConceptMap:source-scope").toLocked();
    @SearchParamDefinition(name="target-code", path="ConceptMap.group.element.target.code", description="Code that identifies the target element", type="token")
    public static final String SP_TARGET_CODE = "target-code";
    public static final TokenClientParam TARGET_CODE = new TokenClientParam("target-code");
    @SearchParamDefinition(name="target-group-system", path="ConceptMap.group.target", description="Target system that the concepts are to be mapped to", type="reference", target={CodeSystem.class})
    public static final String SP_TARGET_GROUP_SYSTEM = "target-group-system";
    public static final ReferenceClientParam TARGET_GROUP_SYSTEM = new ReferenceClientParam("target-group-system");
    public static final Include INCLUDE_TARGET_GROUP_SYSTEM = new Include("ConceptMap:target-group-system").toLocked();
    @SearchParamDefinition(name="target-scope-uri", path="(ConceptMap.targetScope as uri)", description="The URI for the target value set that contains the concepts being mapped.", type="uri")
    public static final String SP_TARGET_SCOPE_URI = "target-scope-uri";
    public static final UriClientParam TARGET_SCOPE_URI = new UriClientParam("target-scope-uri");
    @SearchParamDefinition(name="target-scope", path="(ConceptMap.targetScope as canonical)", description="The target value set which provides context for the mappings", type="reference", target={ValueSet.class})
    public static final String SP_TARGET_SCOPE = "target-scope";
    public static final ReferenceClientParam TARGET_SCOPE = new ReferenceClientParam("target-scope");
    public static final Include INCLUDE_TARGET_SCOPE = new Include("ConceptMap:target-scope").toLocked();
    @SearchParamDefinition(name="derived-from", path="ActivityDefinition.relatedArtifact.where(type='derived-from').resource | CodeSystem.relatedArtifact.where(type='derived-from').resource | ConceptMap.relatedArtifact.where(type='derived-from').resource | EventDefinition.relatedArtifact.where(type='derived-from').resource | EvidenceVariable.relatedArtifact.where(type='derived-from').resource | Library.relatedArtifact.where(type='derived-from').resource | Measure.relatedArtifact.where(type='derived-from').resource | NamingSystem.relatedArtifact.where(type='derived-from').resource | PlanDefinition.relatedArtifact.where(type='derived-from').resource | ValueSet.relatedArtifact.where(type='derived-from').resource", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): What resource is being referenced\r\n* [CodeSystem](codesystem.html): A resource that the CodeSystem is derived from\r\n* [ConceptMap](conceptmap.html): A resource that the ConceptMap is derived from\r\n* [EventDefinition](eventdefinition.html): What resource is being referenced\r\n* [EvidenceVariable](evidencevariable.html): What resource is being referenced\r\n* [Library](library.html): What resource is being referenced\r\n* [Measure](measure.html): What resource is being referenced\r\n* [NamingSystem](namingsystem.html): A resource that the NamingSystem is derived from\r\n* [PlanDefinition](plandefinition.html): What resource is being referenced\r\n* [ValueSet](valueset.html): A resource that the ValueSet is derived from\r\n", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("ConceptMap:derived-from").toLocked();
    @SearchParamDefinition(name="effective", path="ActivityDefinition.effectivePeriod | ChargeItemDefinition.applicability.effectivePeriod | Citation.effectivePeriod | CodeSystem.effectivePeriod | ConceptMap.effectivePeriod | EventDefinition.effectivePeriod | Library.effectivePeriod | Measure.effectivePeriod | NamingSystem.effectivePeriod | PlanDefinition.effectivePeriod | Questionnaire.effectivePeriod | ValueSet.effectivePeriod", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The time during which the activity definition is intended to be in use\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The time during which the charge item definition is intended to be in use\r\n* [Citation](citation.html): The time during which the citation is intended to be in use\r\n* [CodeSystem](codesystem.html): The time during which the CodeSystem is intended to be in use\r\n* [ConceptMap](conceptmap.html): The time during which the ConceptMap is intended to be in use\r\n* [EventDefinition](eventdefinition.html): The time during which the event definition is intended to be in use\r\n* [Library](library.html): The time during which the library is intended to be in use\r\n* [Measure](measure.html): The time during which the measure is intended to be in use\r\n* [NamingSystem](namingsystem.html): The time during which the NamingSystem is intended to be in use\r\n* [PlanDefinition](plandefinition.html): The time during which the plan definition is intended to be in use\r\n* [Questionnaire](questionnaire.html): The time during which the questionnaire is intended to be in use\r\n* [ValueSet](valueset.html): The time during which the ValueSet is intended to be in use\r\n", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="predecessor", path="ActivityDefinition.relatedArtifact.where(type='predecessor').resource | CodeSystem.relatedArtifact.where(type='predecessor').resource | ConceptMap.relatedArtifact.where(type='predecessor').resource | EventDefinition.relatedArtifact.where(type='predecessor').resource | EvidenceVariable.relatedArtifact.where(type='predecessor').resource | Library.relatedArtifact.where(type='predecessor').resource | Measure.relatedArtifact.where(type='predecessor').resource | NamingSystem.relatedArtifact.where(type='predecessor').resource | PlanDefinition.relatedArtifact.where(type='predecessor').resource | ValueSet.relatedArtifact.where(type='predecessor').resource", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): What resource is being referenced\r\n* [CodeSystem](codesystem.html): The predecessor of the CodeSystem\r\n* [ConceptMap](conceptmap.html): The predecessor of the ConceptMap\r\n* [EventDefinition](eventdefinition.html): What resource is being referenced\r\n* [EvidenceVariable](evidencevariable.html): What resource is being referenced\r\n* [Library](library.html): What resource is being referenced\r\n* [Measure](measure.html): What resource is being referenced\r\n* [NamingSystem](namingsystem.html): The predecessor of the NamingSystem\r\n* [PlanDefinition](plandefinition.html): What resource is being referenced\r\n* [ValueSet](valueset.html): The predecessor of the ValueSet\r\n", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BiologicallyDerivedProductDispense.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceAssociation.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentReference.class, Encounter.class, EncounterHistory.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryItem.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationStatement.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Parameters.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestPlan.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("ConceptMap:predecessor").toLocked();
    @SearchParamDefinition(name="topic", path="ActivityDefinition.topic | CodeSystem.topic | ConceptMap.topic | EventDefinition.topic | Library.topic | Measure.topic | NamingSystem.topic | PlanDefinition.topic | ValueSet.topic", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Topics associated with the module\r\n* [CodeSystem](codesystem.html): Topics associated with the CodeSystem\r\n* [ConceptMap](conceptmap.html): Topics associated with the ConceptMap\r\n* [EventDefinition](eventdefinition.html): Topics associated with the module\r\n* [EvidenceVariable](evidencevariable.html): Topics associated with the EvidenceVariable\r\n* [Library](library.html): Topics associated with the module\r\n* [Measure](measure.html): Topics associated with the measure\r\n* [NamingSystem](namingsystem.html): Topics associated with the NamingSystem\r\n* [PlanDefinition](plandefinition.html): Topics associated with the module\r\n* [ValueSet](valueset.html): Topics associated with the ValueSet\r\n", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");

    public ConceptMap() {
    }

    public ConceptMap(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ConceptMap setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ConceptMap setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public ConceptMap setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public ConceptMap addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ConceptMap setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ConceptMap setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public DataType getVersionAlgorithm() {
        return this.versionAlgorithm;
    }

    @Override
    public StringType getVersionAlgorithmStringType() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new StringType();
        }
        if (!(this.versionAlgorithm instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (StringType)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return this.versionAlgorithm instanceof StringType;
    }

    @Override
    public Coding getVersionAlgorithmCoding() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new Coding();
        }
        if (!(this.versionAlgorithm instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (Coding)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return this.versionAlgorithm instanceof Coding;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return this.versionAlgorithm != null && !this.versionAlgorithm.isEmpty();
    }

    @Override
    public ConceptMap setVersionAlgorithm(DataType value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Coding)) {
            throw new FHIRException("Not the right type for ConceptMap.versionAlgorithm[x]: " + value.fhirType());
        }
        this.versionAlgorithm = value;
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ConceptMap setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ConceptMap setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ConceptMap setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ConceptMap setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ConceptMap setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ConceptMap setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ConceptMap setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ConceptMap setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ConceptMap setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ConceptMap setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ConceptMap setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ConceptMap setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ConceptMap setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ConceptMap addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ConceptMap setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ConceptMap setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ConceptMap setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ConceptMap addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ConceptMap setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ConceptMap addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public ConceptMap setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public ConceptMap setPurpose(String value) {
        if (Utilities.noString((String)value)) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public ConceptMap setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public ConceptMap setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        if (this.copyrightLabel == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.copyrightLabel");
            }
            if (Configuration.doAutoCreate()) {
                this.copyrightLabel = new StringType();
            }
        }
        return this.copyrightLabel;
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public boolean hasCopyrightLabel() {
        return this.copyrightLabel != null && !this.copyrightLabel.isEmpty();
    }

    @Override
    public ConceptMap setCopyrightLabelElement(StringType value) {
        this.copyrightLabel = value;
        return this;
    }

    @Override
    public String getCopyrightLabel() {
        return this.copyrightLabel == null ? null : (String)this.copyrightLabel.getValue();
    }

    @Override
    public ConceptMap setCopyrightLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.copyrightLabel = null;
        } else {
            if (this.copyrightLabel == null) {
                this.copyrightLabel = new StringType();
            }
            this.copyrightLabel.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    @Override
    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    @Override
    public ConceptMap setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    @Override
    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    @Override
    public ConceptMap setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    @Override
    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    @Override
    public ConceptMap setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    @Override
    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    @Override
    public ConceptMap setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    @Override
    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    @Override
    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    @Override
    public ConceptMap setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    @Override
    public ConceptMap setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    @Override
    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    @Override
    public ConceptMap addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    @Override
    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    @Override
    public ConceptMap setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    @Override
    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    @Override
    public ConceptMap addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Override
    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    @Override
    public ConceptMap setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    @Override
    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    @Override
    public ConceptMap addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    @Override
    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    @Override
    public ConceptMap setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    @Override
    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    @Override
    public ConceptMap addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    @Override
    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    @Override
    public ConceptMap setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    @Override
    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    @Override
    public ConceptMap addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    @Override
    public ConceptMap setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    @Override
    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    @Override
    public ConceptMap addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<PropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<PropertyComponent>();
        }
        return this.property;
    }

    public ConceptMap setProperty(List<PropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (PropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PropertyComponent addProperty() {
        PropertyComponent t = new PropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<PropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public ConceptMap addProperty(PropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<PropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public PropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public List<AdditionalAttributeComponent> getAdditionalAttribute() {
        if (this.additionalAttribute == null) {
            this.additionalAttribute = new ArrayList<AdditionalAttributeComponent>();
        }
        return this.additionalAttribute;
    }

    public ConceptMap setAdditionalAttribute(List<AdditionalAttributeComponent> theAdditionalAttribute) {
        this.additionalAttribute = theAdditionalAttribute;
        return this;
    }

    public boolean hasAdditionalAttribute() {
        if (this.additionalAttribute == null) {
            return false;
        }
        for (AdditionalAttributeComponent item : this.additionalAttribute) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AdditionalAttributeComponent addAdditionalAttribute() {
        AdditionalAttributeComponent t = new AdditionalAttributeComponent();
        if (this.additionalAttribute == null) {
            this.additionalAttribute = new ArrayList<AdditionalAttributeComponent>();
        }
        this.additionalAttribute.add(t);
        return t;
    }

    public ConceptMap addAdditionalAttribute(AdditionalAttributeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.additionalAttribute == null) {
            this.additionalAttribute = new ArrayList<AdditionalAttributeComponent>();
        }
        this.additionalAttribute.add(t);
        return this;
    }

    public AdditionalAttributeComponent getAdditionalAttributeFirstRep() {
        if (this.getAdditionalAttribute().isEmpty()) {
            this.addAdditionalAttribute();
        }
        return this.getAdditionalAttribute().get(0);
    }

    public DataType getSourceScope() {
        return this.sourceScope;
    }

    public UriType getSourceScopeUriType() throws FHIRException {
        if (this.sourceScope == null) {
            this.sourceScope = new UriType();
        }
        if (!(this.sourceScope instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.sourceScope.getClass().getName() + " was encountered");
        }
        return (UriType)this.sourceScope;
    }

    public boolean hasSourceScopeUriType() {
        return this.sourceScope instanceof UriType;
    }

    public CanonicalType getSourceScopeCanonicalType() throws FHIRException {
        if (this.sourceScope == null) {
            this.sourceScope = new CanonicalType();
        }
        if (!(this.sourceScope instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.sourceScope.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.sourceScope;
    }

    public boolean hasSourceScopeCanonicalType() {
        return this.sourceScope instanceof CanonicalType;
    }

    public boolean hasSourceScope() {
        return this.sourceScope != null && !this.sourceScope.isEmpty();
    }

    public ConceptMap setSourceScope(DataType value) {
        if (value != null && !(value instanceof UriType) && !(value instanceof CanonicalType)) {
            throw new FHIRException("Not the right type for ConceptMap.sourceScope[x]: " + value.fhirType());
        }
        this.sourceScope = value;
        return this;
    }

    public DataType getTargetScope() {
        return this.targetScope;
    }

    public UriType getTargetScopeUriType() throws FHIRException {
        if (this.targetScope == null) {
            this.targetScope = new UriType();
        }
        if (!(this.targetScope instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.targetScope.getClass().getName() + " was encountered");
        }
        return (UriType)this.targetScope;
    }

    public boolean hasTargetScopeUriType() {
        return this.targetScope instanceof UriType;
    }

    public CanonicalType getTargetScopeCanonicalType() throws FHIRException {
        if (this.targetScope == null) {
            this.targetScope = new CanonicalType();
        }
        if (!(this.targetScope instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.targetScope.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.targetScope;
    }

    public boolean hasTargetScopeCanonicalType() {
        return this.targetScope instanceof CanonicalType;
    }

    public boolean hasTargetScope() {
        return this.targetScope != null && !this.targetScope.isEmpty();
    }

    public ConceptMap setTargetScope(DataType value) {
        if (value != null && !(value instanceof UriType) && !(value instanceof CanonicalType)) {
            throw new FHIRException("Not the right type for ConceptMap.targetScope[x]: " + value.fhirType());
        }
        this.targetScope = value;
        return this;
    }

    public List<ConceptMapGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<ConceptMapGroupComponent>();
        }
        return this.group;
    }

    public ConceptMap setGroup(List<ConceptMapGroupComponent> theGroup) {
        this.group = theGroup;
        return this;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (ConceptMapGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConceptMapGroupComponent addGroup() {
        ConceptMapGroupComponent t = new ConceptMapGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<ConceptMapGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public ConceptMap addGroup(ConceptMapGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<ConceptMapGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public ConceptMapGroupComponent getGroupFirstRep() {
        if (this.getGroup().isEmpty()) {
            this.addGroup();
        }
        return this.getGroup().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this concept map is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the concept map is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which ConceptMap is more current.", 0, 1, this.versionAlgorithm));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the concept map.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this concept map. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the concept map was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the concept map.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the concept map from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate concept map instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the concept map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this concept map is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.", 0, 1, this.copyright));
        children.add(new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the ConceptMap content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptions related to the content of the ConceptMap. Topics provide a high-level categorization as well as keywords for the ConceptMap that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the ConceptMap.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the ConceptMap.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization asserted by the publisher to be primarily responsible for review of some aspect of the ConceptMap.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization asserted by the publisher to be responsible for officially endorsing the ConceptMap for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, dependencies, bibliographic references, and predecessor and successor artifacts.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("property", "", "A property defines a slot through which additional information can be provided about a map from source -> target.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("additionalAttribute", "", "An additionalAttribute defines an additional data element found in the source or target data model where the data will come from or be mapped to. Some mappings are based on data in addition to the source data element, where codes in multiple fields are combined to a single field (or vice versa).", 0, Integer.MAX_VALUE, this.additionalAttribute));
        children.add(new Property("sourceScope[x]", "uri|canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.  Limits the scope of the map to source codes (ConceptMap.group.element code or valueSet) that are members of this value set.", 0, 1, this.sourceScope));
        children.add(new Property("targetScope[x]", "uri|canonical(ValueSet)", "Identifier for the target value set that provides important context about how the mapping choices are made.  Limits the scope of the map to target codes (ConceptMap.group.element.target code or valueSet) that are members of this value set.", 0, 1, this.targetScope));
        children.add(new Property("group", "", "A group of mappings that all have the same source and target system.", 0, Integer.MAX_VALUE, this.group));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this concept map when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this concept map is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the concept map is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the concept map author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -115699031: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which ConceptMap is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1508158071: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which ConceptMap is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1836908904: {
                return new Property("versionAlgorithm[x]", "string", "Indicates the mechanism used to compare versions to determine which ConceptMap is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1373807809: {
                return new Property("versionAlgorithm[x]", "Coding", "Indicates the mechanism used to compare versions to determine which ConceptMap is more current.", 0, 1, this.versionAlgorithm);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the concept map. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the concept map.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this concept map. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this concept map is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the concept map was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the concept map.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the concept map from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate concept map instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the concept map is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this concept map is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the concept map and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the concept map.", 0, 1, this.copyright);
            }
            case 765157229: {
                return new Property("copyrightLabel", "string", "A short string (<50 characters), suitable for inclusion in a page footer that identifies the copyright holder, effective period, and optionally whether rights are resctricted. (e.g. 'All rights reserved', 'Some rights reserved').", 0, 1, this.copyrightLabel);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the ConceptMap content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptions related to the content of the ConceptMap. Topics provide a high-level categorization as well as keywords for the ConceptMap that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the ConceptMap.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the ConceptMap.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization asserted by the publisher to be primarily responsible for review of some aspect of the ConceptMap.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization asserted by the publisher to be responsible for officially endorsing the ConceptMap for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, dependencies, bibliographic references, and predecessor and successor artifacts.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case -993141291: {
                return new Property("property", "", "A property defines a slot through which additional information can be provided about a map from source -> target.", 0, Integer.MAX_VALUE, this.property);
            }
            case -1004532171: {
                return new Property("additionalAttribute", "", "An additionalAttribute defines an additional data element found in the source or target data model where the data will come from or be mapped to. Some mappings are based on data in addition to the source data element, where codes in multiple fields are combined to a single field (or vice versa).", 0, Integer.MAX_VALUE, this.additionalAttribute);
            }
            case -1850861849: {
                return new Property("sourceScope[x]", "uri|canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.  Limits the scope of the map to source codes (ConceptMap.group.element code or valueSet) that are members of this value set.", 0, 1, this.sourceScope);
            }
            case -96223495: {
                return new Property("sourceScope[x]", "uri|canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.  Limits the scope of the map to source codes (ConceptMap.group.element code or valueSet) that are members of this value set.", 0, 1, this.sourceScope);
            }
            case -1850867789: {
                return new Property("sourceScope[x]", "uri", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.  Limits the scope of the map to source codes (ConceptMap.group.element code or valueSet) that are members of this value set.", 0, 1, this.sourceScope);
            }
            case -1487745541: {
                return new Property("sourceScope[x]", "canonical(ValueSet)", "Identifier for the source value set that contains the concepts that are being mapped and provides context for the mappings.  Limits the scope of the map to source codes (ConceptMap.group.element code or valueSet) that are members of this value set.", 0, 1, this.sourceScope);
            }
            case -2079438243: {
                return new Property("targetScope[x]", "uri|canonical(ValueSet)", "Identifier for the target value set that provides important context about how the mapping choices are made.  Limits the scope of the map to target codes (ConceptMap.group.element.target code or valueSet) that are members of this value set.", 0, 1, this.targetScope);
            }
            case -2096156861: {
                return new Property("targetScope[x]", "uri|canonical(ValueSet)", "Identifier for the target value set that provides important context about how the mapping choices are made.  Limits the scope of the map to target codes (ConceptMap.group.element.target code or valueSet) that are members of this value set.", 0, 1, this.targetScope);
            }
            case -2079444183: {
                return new Property("targetScope[x]", "uri", "Identifier for the target value set that provides important context about how the mapping choices are made.  Limits the scope of the map to target codes (ConceptMap.group.element.target code or valueSet) that are members of this value set.", 0, 1, this.targetScope);
            }
            case -1851780879: {
                return new Property("targetScope[x]", "canonical(ValueSet)", "Identifier for the target value set that provides important context about how the mapping choices are made.  Limits the scope of the map to target codes (ConceptMap.group.element.target code or valueSet) that are members of this value set.", 0, 1, this.targetScope);
            }
            case 98629247: {
                return new Property("group", "", "A group of mappings that all have the same source and target system.", 0, Integer.MAX_VALUE, this.group);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 1508158071: {
                Base[] baseArray;
                if (this.versionAlgorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.versionAlgorithm;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case 765157229: {
                Base[] baseArray;
                if (this.copyrightLabel == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.copyrightLabel;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case -1004532171: {
                return this.additionalAttribute == null ? new Base[]{} : this.additionalAttribute.toArray(new Base[this.additionalAttribute.size()]);
            }
            case -96223495: {
                Base[] baseArray;
                if (this.sourceScope == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.sourceScope;
                }
                return baseArray;
            }
            case -2096156861: {
                Base[] baseArray;
                if (this.targetScope == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.targetScope;
                }
                return baseArray;
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 1508158071: {
                this.versionAlgorithm = TypeConvertor.castToType(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 765157229: {
                this.copyrightLabel = TypeConvertor.castToString(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 110546223: {
                this.getTopic().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case -993141291: {
                this.getProperty().add((PropertyComponent)((Object)value));
                return value;
            }
            case -1004532171: {
                this.getAdditionalAttribute().add((AdditionalAttributeComponent)((Object)value));
                return value;
            }
            case -96223495: {
                this.sourceScope = TypeConvertor.castToType(value);
                return value;
            }
            case -2096156861: {
                this.targetScope = TypeConvertor.castToType(value);
                return value;
            }
            case 98629247: {
                this.getGroup().add((ConceptMapGroupComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = TypeConvertor.castToType(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = TypeConvertor.castToString(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("property")) {
            this.getProperty().add((PropertyComponent)((Object)value));
        } else if (name.equals("additionalAttribute")) {
            this.getAdditionalAttribute().add((AdditionalAttributeComponent)((Object)value));
        } else if (name.equals("sourceScope[x]")) {
            this.sourceScope = TypeConvertor.castToType(value);
        } else if (name.equals("targetScope[x]")) {
            this.targetScope = TypeConvertor.castToType(value);
        } else if (name.equals("group")) {
            this.getGroup().add((ConceptMapGroupComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("purpose")) {
            this.purpose = null;
        } else if (name.equals("copyright")) {
            this.copyright = null;
        } else if (name.equals("copyrightLabel")) {
            this.copyrightLabel = null;
        } else if (name.equals("approvalDate")) {
            this.approvalDate = null;
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = null;
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = null;
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().remove(value);
        } else if (name.equals("author")) {
            this.getAuthor().remove(value);
        } else if (name.equals("editor")) {
            this.getEditor().remove(value);
        } else if (name.equals("reviewer")) {
            this.getReviewer().remove(value);
        } else if (name.equals("endorser")) {
            this.getEndorser().remove(value);
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().remove(value);
        } else if (name.equals("property")) {
            this.getProperty().remove((PropertyComponent)((Object)value));
        } else if (name.equals("additionalAttribute")) {
            this.getAdditionalAttribute().remove((AdditionalAttributeComponent)((Object)value));
        } else if (name.equals("sourceScope[x]")) {
            this.sourceScope = null;
        } else if (name.equals("targetScope[x]")) {
            this.targetScope = null;
        } else if (name.equals("group")) {
            this.getGroup().remove((ConceptMapGroupComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -115699031: {
                return this.getVersionAlgorithm();
            }
            case 1508158071: {
                return this.getVersionAlgorithm();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 765157229: {
                return this.getCopyrightLabelElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case -993141291: {
                return this.addProperty();
            }
            case -1004532171: {
                return this.addAdditionalAttribute();
            }
            case -1850861849: {
                return this.getSourceScope();
            }
            case -96223495: {
                return this.getSourceScope();
            }
            case -2079438243: {
                return this.getTargetScope();
            }
            case -2096156861: {
                return this.getTargetScope();
            }
            case 98629247: {
                return this.addGroup();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 1508158071: {
                return new String[]{"string", "Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 765157229: {
                return new String[]{"string"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case -993141291: {
                return new String[0];
            }
            case -1004532171: {
                return new String[0];
            }
            case -96223495: {
                return new String[]{"uri", "canonical"};
            }
            case -2096156861: {
                return new String[]{"uri", "canonical"};
            }
            case 98629247: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.version");
        }
        if (name.equals("versionAlgorithmString")) {
            this.versionAlgorithm = new StringType();
            return this.versionAlgorithm;
        }
        if (name.equals("versionAlgorithmCoding")) {
            this.versionAlgorithm = new Coding();
            return this.versionAlgorithm;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.copyright");
        }
        if (name.equals("copyrightLabel")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.copyrightLabel");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("additionalAttribute")) {
            return this.addAdditionalAttribute();
        }
        if (name.equals("sourceScopeUri")) {
            this.sourceScope = new UriType();
            return this.sourceScope;
        }
        if (name.equals("sourceScopeCanonical")) {
            this.sourceScope = new CanonicalType();
            return this.sourceScope;
        }
        if (name.equals("targetScopeUri")) {
            this.targetScope = new UriType();
            return this.targetScope;
        }
        if (name.equals("targetScopeCanonical")) {
            this.targetScope = new CanonicalType();
            return this.targetScope;
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ConceptMap";
    }

    @Override
    public ConceptMap copy() {
        ConceptMap dst = new ConceptMap();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ConceptMap dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.versionAlgorithm = this.versionAlgorithm == null ? null : this.versionAlgorithm.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.copyrightLabel = this.copyrightLabel == null ? null : this.copyrightLabel.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<PropertyComponent>();
            for (PropertyComponent propertyComponent : this.property) {
                dst.property.add(propertyComponent.copy());
            }
        }
        if (this.additionalAttribute != null) {
            dst.additionalAttribute = new ArrayList<AdditionalAttributeComponent>();
            for (AdditionalAttributeComponent additionalAttributeComponent : this.additionalAttribute) {
                dst.additionalAttribute.add(additionalAttributeComponent.copy());
            }
        }
        dst.sourceScope = this.sourceScope == null ? null : this.sourceScope.copy();
        DataType dataType = dst.targetScope = this.targetScope == null ? null : this.targetScope.copy();
        if (this.group != null) {
            dst.group = new ArrayList<ConceptMapGroupComponent>();
            for (ConceptMapGroupComponent conceptMapGroupComponent : this.group) {
                dst.group.add(conceptMapGroupComponent.copy());
            }
        }
    }

    protected ConceptMap typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ConceptMap)) {
            return false;
        }
        ConceptMap o = (ConceptMap)other_;
        return ConceptMap.compareDeep(this.url, o.url, true) && ConceptMap.compareDeep(this.identifier, o.identifier, true) && ConceptMap.compareDeep(this.version, o.version, true) && ConceptMap.compareDeep(this.versionAlgorithm, o.versionAlgorithm, true) && ConceptMap.compareDeep(this.name, o.name, true) && ConceptMap.compareDeep(this.title, o.title, true) && ConceptMap.compareDeep(this.status, o.status, true) && ConceptMap.compareDeep(this.experimental, o.experimental, true) && ConceptMap.compareDeep(this.date, o.date, true) && ConceptMap.compareDeep(this.publisher, o.publisher, true) && ConceptMap.compareDeep(this.contact, o.contact, true) && ConceptMap.compareDeep(this.description, o.description, true) && ConceptMap.compareDeep(this.useContext, o.useContext, true) && ConceptMap.compareDeep(this.jurisdiction, o.jurisdiction, true) && ConceptMap.compareDeep(this.purpose, o.purpose, true) && ConceptMap.compareDeep(this.copyright, o.copyright, true) && ConceptMap.compareDeep(this.copyrightLabel, o.copyrightLabel, true) && ConceptMap.compareDeep(this.approvalDate, o.approvalDate, true) && ConceptMap.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ConceptMap.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && ConceptMap.compareDeep(this.topic, o.topic, true) && ConceptMap.compareDeep(this.author, o.author, true) && ConceptMap.compareDeep(this.editor, o.editor, true) && ConceptMap.compareDeep(this.reviewer, o.reviewer, true) && ConceptMap.compareDeep(this.endorser, o.endorser, true) && ConceptMap.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && ConceptMap.compareDeep(this.property, o.property, true) && ConceptMap.compareDeep(this.additionalAttribute, o.additionalAttribute, true) && ConceptMap.compareDeep(this.sourceScope, o.sourceScope, true) && ConceptMap.compareDeep(this.targetScope, o.targetScope, true) && ConceptMap.compareDeep(this.group, o.group, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ConceptMap)) {
            return false;
        }
        ConceptMap o = (ConceptMap)other_;
        return ConceptMap.compareValues(this.url, o.url, true) && ConceptMap.compareValues(this.version, o.version, true) && ConceptMap.compareValues(this.name, o.name, true) && ConceptMap.compareValues(this.title, o.title, true) && ConceptMap.compareValues(this.status, o.status, true) && ConceptMap.compareValues(this.experimental, o.experimental, true) && ConceptMap.compareValues(this.date, o.date, true) && ConceptMap.compareValues(this.publisher, o.publisher, true) && ConceptMap.compareValues(this.description, o.description, true) && ConceptMap.compareValues(this.purpose, o.purpose, true) && ConceptMap.compareValues(this.copyright, o.copyright, true) && ConceptMap.compareValues(this.copyrightLabel, o.copyrightLabel, true) && ConceptMap.compareValues(this.approvalDate, o.approvalDate, true) && ConceptMap.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.versionAlgorithm, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.copyrightLabel, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.property, this.additionalAttribute, this.sourceScope, this.targetScope, this.group});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ConceptMap;
    }

    public String getAttributeUri(String code) {
        if (code == null) {
            return null;
        }
        for (AdditionalAttributeComponent aa : this.getAdditionalAttribute()) {
            if (!code.equals(aa.getCode())) continue;
            return aa.hasUri() ? aa.getUri() : code;
        }
        return code;
    }

    public String registerAttribute(String uri) {
        if (uri == null) {
            return null;
        }
        String t = this.tail(uri).replace("-", "");
        if (Utilities.noString((String)t)) {
            t = "code";
        }
        Object code = t;
        int i = 0;
        while (this.alreadyExistsAsCode((String)code)) {
            code = t + ++i;
        }
        for (AdditionalAttributeComponent aa : this.getAdditionalAttribute()) {
            if (!uri.equals(aa.getUri())) continue;
            if (!aa.hasCode()) {
                aa.setCode((String)code);
            }
            return aa.getCode();
        }
        this.addAdditionalAttribute().setUri(uri).setCode((String)code);
        return code;
    }

    private boolean alreadyExistsAsCode(String code) {
        for (PropertyComponent propertyComponent : this.getProperty()) {
            if (!code.equals(propertyComponent.getCode())) continue;
            return true;
        }
        for (AdditionalAttributeComponent additionalAttributeComponent : this.getAdditionalAttribute()) {
            if (!code.equals(additionalAttributeComponent.getCode())) continue;
            return true;
        }
        return false;
    }

    private String tail(String uri) {
        return uri.contains("/") ? uri.substring(uri.lastIndexOf("/") + 1) : uri;
    }

    public ConceptMapGroupComponent getGroup(String su, String tu) {
        for (ConceptMapGroupComponent g : this.getGroup()) {
            if (!su.equals(g.getSource()) || !tu.equals(g.getTarget())) continue;
            return g;
        }
        return null;
    }

    public ConceptMapGroupComponent forceGroup(String su, String tu) {
        for (ConceptMapGroupComponent g : this.getGroup()) {
            if (!su.equals(g.getSource()) || !tu.equals(g.getTarget())) continue;
            return g;
        }
        ConceptMapGroupComponent g = this.addGroup();
        g.setSource(su);
        g.setTarget(tu);
        return g;
    }

    public List<ConceptMapGroupComponent> getGroups(String su) {
        ArrayList<ConceptMapGroupComponent> res = new ArrayList<ConceptMapGroupComponent>();
        for (ConceptMapGroupComponent g : this.getGroup()) {
            if (!su.equals(g.getSource())) continue;
            res.add(g);
        }
        return res;
    }

    @Block
    public static class PropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifies the property on the mappings, and when referred to in the $translate operation", formalDefinition="A code that is used to identify the property. The code is used internally (in ConceptMap.group.element.target.property.code) and also in the $translate operation.")
        protected CodeType code;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Formal identifier for the property", formalDefinition="Reference to the formal meaning of the property.")
        protected UriType uri;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Why the property is defined, and/or what it conveys", formalDefinition="A description of the property - why it is defined, and how its value might be used.")
        protected StringType description;
        @Child(name="type", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Coding | string | integer | boolean | dateTime | decimal | code", formalDefinition="The type of the property value.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/conceptmap-property-type")
        protected Enumeration<ConceptMapPropertyType> type;
        @Child(name="system", type={CanonicalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The CodeSystem from which code values come", formalDefinition="The CodeSystem that defines the codes from which values of type ```code``` in property values.")
        protected CanonicalType system;
        private static final long serialVersionUID = 1693472150L;

        public PropertyComponent() {
        }

        public PropertyComponent(String code, ConceptMapPropertyType type) {
            this.setCode(code);
            this.setType(type);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public PropertyComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public PropertyComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PropertyComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public PropertyComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public PropertyComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PropertyComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public PropertyComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public PropertyComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<ConceptMapPropertyType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ConceptMapPropertyType>(new ConceptMapPropertyTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PropertyComponent setTypeElement(Enumeration<ConceptMapPropertyType> value) {
            this.type = value;
            return this;
        }

        public ConceptMapPropertyType getType() {
            return this.type == null ? null : (ConceptMapPropertyType)((Object)this.type.getValue());
        }

        public PropertyComponent setType(ConceptMapPropertyType value) {
            if (this.type == null) {
                this.type = new Enumeration<ConceptMapPropertyType>(new ConceptMapPropertyTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CanonicalType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PropertyComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new CanonicalType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public PropertyComponent setSystemElement(CanonicalType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public PropertyComponent setSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new CanonicalType();
                }
                this.system.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "A code that is used to identify the property. The code is used internally (in ConceptMap.group.element.target.property.code) and also in the $translate operation.", 0, 1, this.code));
            children.add(new Property("uri", "uri", "Reference to the formal meaning of the property.", 0, 1, this.uri));
            children.add(new Property(ConceptMap.SP_DESCRIPTION, "string", "A description of the property - why it is defined, and how its value might be used.", 0, 1, this.description));
            children.add(new Property("type", "code", "The type of the property value.", 0, 1, this.type));
            children.add(new Property("system", "canonical(CodeSystem)", "The CodeSystem that defines the codes from which values of type ```code``` in property values.", 0, 1, this.system));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "A code that is used to identify the property. The code is used internally (in ConceptMap.group.element.target.property.code) and also in the $translate operation.", 0, 1, this.code);
                }
                case 116076: {
                    return new Property("uri", "uri", "Reference to the formal meaning of the property.", 0, 1, this.uri);
                }
                case -1724546052: {
                    return new Property(ConceptMap.SP_DESCRIPTION, "string", "A description of the property - why it is defined, and how its value might be used.", 0, 1, this.description);
                }
                case 3575610: {
                    return new Property("type", "code", "The type of the property value.", 0, 1, this.type);
                }
                case -887328209: {
                    return new Property("system", "canonical(CodeSystem)", "The CodeSystem that defines the codes from which values of type ```code``` in property values.", 0, 1, this.system);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.type;
                    }
                    return baseArray;
                }
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.system;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 116076: {
                    this.uri = TypeConvertor.castToUri(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new ConceptMapPropertyTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -887328209: {
                    this.system = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("uri")) {
                this.uri = TypeConvertor.castToUri(value);
            } else if (name.equals(ConceptMap.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                value = new ConceptMapPropertyTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("system")) {
                this.system = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("uri")) {
                this.uri = null;
            } else if (name.equals(ConceptMap.SP_DESCRIPTION)) {
                this.description = null;
            } else if (name.equals("type")) {
                value = new ConceptMapPropertyTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("system")) {
                this.system = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case -887328209: {
                    return this.getSystemElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case -887328209: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.property.code");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.property.uri");
            }
            if (name.equals(ConceptMap.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.property.description");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.property.type");
            }
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.property.system");
            }
            return super.addChild(name);
        }

        @Override
        public PropertyComponent copy() {
            PropertyComponent dst = new PropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PropertyComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.system = this.system == null ? null : this.system.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PropertyComponent)) {
                return false;
            }
            PropertyComponent o = (PropertyComponent)other_;
            return PropertyComponent.compareDeep(this.code, o.code, true) && PropertyComponent.compareDeep(this.uri, o.uri, true) && PropertyComponent.compareDeep(this.description, o.description, true) && PropertyComponent.compareDeep(this.type, o.type, true) && PropertyComponent.compareDeep(this.system, o.system, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PropertyComponent)) {
                return false;
            }
            PropertyComponent o = (PropertyComponent)other_;
            return PropertyComponent.compareValues(this.code, o.code, true) && PropertyComponent.compareValues(this.uri, o.uri, true) && PropertyComponent.compareValues(this.description, o.description, true) && PropertyComponent.compareValues(this.type, o.type, true) && PropertyComponent.compareValues(this.system, o.system, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.uri, this.description, this.type, this.system});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.property";
        }
    }

    @Block
    public static class AdditionalAttributeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifies this additional attribute through this resource", formalDefinition="A code that is used to identify this additional data attribute. The code is used internally in ConceptMap.group.element.target.dependsOn.attribute and ConceptMap.group.element.target.product.attribute.")
        protected CodeType code;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Formal identifier for the data element referred to in this attribte", formalDefinition="Reference to the formal definition of the source/target data element. For elements defined by the FHIR specification, or using a FHIR logical model, the correct format is {canonical-url}#{element-id}.")
        protected UriType uri;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Why the additional attribute is defined, and/or what the data element it refers to is", formalDefinition="A description of the additional attribute and/or the data element it refers to - why it is defined, and how the value might be used in mappings, and a discussion of issues associated with the use of the data element.")
        protected StringType description;
        @Child(name="type", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="code | Coding | string | boolean | Quantity", formalDefinition="The type of the source data contained in this concept map for this data element.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/conceptmap-attribute-type")
        protected Enumeration<ConceptMapAttributeType> type;
        private static final long serialVersionUID = -1930701116L;

        public AdditionalAttributeComponent() {
        }

        public AdditionalAttributeComponent(String code, ConceptMapAttributeType type) {
            this.setCode(code);
            this.setType(type);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdditionalAttributeComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public AdditionalAttributeComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public AdditionalAttributeComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdditionalAttributeComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public AdditionalAttributeComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public AdditionalAttributeComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdditionalAttributeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public AdditionalAttributeComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public AdditionalAttributeComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<ConceptMapAttributeType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AdditionalAttributeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ConceptMapAttributeType>(new ConceptMapAttributeTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AdditionalAttributeComponent setTypeElement(Enumeration<ConceptMapAttributeType> value) {
            this.type = value;
            return this;
        }

        public ConceptMapAttributeType getType() {
            return this.type == null ? null : (ConceptMapAttributeType)((Object)this.type.getValue());
        }

        public AdditionalAttributeComponent setType(ConceptMapAttributeType value) {
            if (this.type == null) {
                this.type = new Enumeration<ConceptMapAttributeType>(new ConceptMapAttributeTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "A code that is used to identify this additional data attribute. The code is used internally in ConceptMap.group.element.target.dependsOn.attribute and ConceptMap.group.element.target.product.attribute.", 0, 1, this.code));
            children.add(new Property("uri", "uri", "Reference to the formal definition of the source/target data element. For elements defined by the FHIR specification, or using a FHIR logical model, the correct format is {canonical-url}#{element-id}.", 0, 1, this.uri));
            children.add(new Property(ConceptMap.SP_DESCRIPTION, "string", "A description of the additional attribute and/or the data element it refers to - why it is defined, and how the value might be used in mappings, and a discussion of issues associated with the use of the data element.", 0, 1, this.description));
            children.add(new Property("type", "code", "The type of the source data contained in this concept map for this data element.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "A code that is used to identify this additional data attribute. The code is used internally in ConceptMap.group.element.target.dependsOn.attribute and ConceptMap.group.element.target.product.attribute.", 0, 1, this.code);
                }
                case 116076: {
                    return new Property("uri", "uri", "Reference to the formal definition of the source/target data element. For elements defined by the FHIR specification, or using a FHIR logical model, the correct format is {canonical-url}#{element-id}.", 0, 1, this.uri);
                }
                case -1724546052: {
                    return new Property(ConceptMap.SP_DESCRIPTION, "string", "A description of the additional attribute and/or the data element it refers to - why it is defined, and how the value might be used in mappings, and a discussion of issues associated with the use of the data element.", 0, 1, this.description);
                }
                case 3575610: {
                    return new Property("type", "code", "The type of the source data contained in this concept map for this data element.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 116076: {
                    this.uri = TypeConvertor.castToUri(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new ConceptMapAttributeTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("uri")) {
                this.uri = TypeConvertor.castToUri(value);
            } else if (name.equals(ConceptMap.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                value = new ConceptMapAttributeTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("uri")) {
                this.uri = null;
            } else if (name.equals(ConceptMap.SP_DESCRIPTION)) {
                this.description = null;
            } else if (name.equals("type")) {
                value = new ConceptMapAttributeTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.additionalAttribute.code");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.additionalAttribute.uri");
            }
            if (name.equals(ConceptMap.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.additionalAttribute.description");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.additionalAttribute.type");
            }
            return super.addChild(name);
        }

        @Override
        public AdditionalAttributeComponent copy() {
            AdditionalAttributeComponent dst = new AdditionalAttributeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AdditionalAttributeComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AdditionalAttributeComponent)) {
                return false;
            }
            AdditionalAttributeComponent o = (AdditionalAttributeComponent)other_;
            return AdditionalAttributeComponent.compareDeep(this.code, o.code, true) && AdditionalAttributeComponent.compareDeep(this.uri, o.uri, true) && AdditionalAttributeComponent.compareDeep(this.description, o.description, true) && AdditionalAttributeComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AdditionalAttributeComponent)) {
                return false;
            }
            AdditionalAttributeComponent o = (AdditionalAttributeComponent)other_;
            return AdditionalAttributeComponent.compareValues(this.code, o.code, true) && AdditionalAttributeComponent.compareValues(this.uri, o.uri, true) && AdditionalAttributeComponent.compareValues(this.description, o.description, true) && AdditionalAttributeComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.uri, this.description, this.type});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.additionalAttribute";
        }
    }

    @Block
    public static class ConceptMapGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="source", type={CanonicalType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source system where concepts to be mapped are defined", formalDefinition="An absolute URI that identifies the source system where the concepts to be mapped are defined.")
        protected CanonicalType source;
        @Child(name="target", type={CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Target system that the concepts are to be mapped to", formalDefinition="An absolute URI that identifies the target system that the concepts will be mapped to.")
        protected CanonicalType target;
        @Child(name="element", type={}, order=3, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Mappings for a concept from the source set", formalDefinition="Mappings for an individual concept in the source to one or more concepts in the target.")
        protected List<SourceElementComponent> element;
        @Child(name="unmapped", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What to do when there is no mapping target for the source concept and ConceptMap.group.element.noMap is not true", formalDefinition="What to do when there is no mapping to a target concept from the source concept and ConceptMap.group.element.noMap is not true. This provides the \"default\" to be applied when there is no target concept mapping specified or the expansion of ConceptMap.group.element.target.valueSet is empty.")
        protected ConceptMapGroupUnmappedComponent unmapped;
        private static final long serialVersionUID = 1307192416L;

        public ConceptMapGroupComponent() {
        }

        public ConceptMapGroupComponent(SourceElementComponent element) {
            this.addElement(element);
        }

        public CanonicalType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new CanonicalType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ConceptMapGroupComponent setSourceElement(CanonicalType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public ConceptMapGroupComponent setSource(String value) {
            if (Utilities.noString((String)value)) {
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new CanonicalType();
                }
                this.source.setValue(value);
            }
            return this;
        }

        public CanonicalType getTargetElement() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new CanonicalType();
                }
            }
            return this.target;
        }

        public boolean hasTargetElement() {
            return this.target != null && !this.target.isEmpty();
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public ConceptMapGroupComponent setTargetElement(CanonicalType value) {
            this.target = value;
            return this;
        }

        public String getTarget() {
            return this.target == null ? null : (String)this.target.getValue();
        }

        public ConceptMapGroupComponent setTarget(String value) {
            if (Utilities.noString((String)value)) {
                this.target = null;
            } else {
                if (this.target == null) {
                    this.target = new CanonicalType();
                }
                this.target.setValue(value);
            }
            return this;
        }

        public List<SourceElementComponent> getElement() {
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            return this.element;
        }

        public ConceptMapGroupComponent setElement(List<SourceElementComponent> theElement) {
            this.element = theElement;
            return this;
        }

        public boolean hasElement() {
            if (this.element == null) {
                return false;
            }
            for (SourceElementComponent item : this.element) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SourceElementComponent addElement() {
            SourceElementComponent t = new SourceElementComponent();
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            this.element.add(t);
            return t;
        }

        public ConceptMapGroupComponent addElement(SourceElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.element == null) {
                this.element = new ArrayList<SourceElementComponent>();
            }
            this.element.add(t);
            return this;
        }

        public SourceElementComponent getElementFirstRep() {
            if (this.getElement().isEmpty()) {
                this.addElement();
            }
            return this.getElement().get(0);
        }

        public ConceptMapGroupUnmappedComponent getUnmapped() {
            if (this.unmapped == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupComponent.unmapped");
                }
                if (Configuration.doAutoCreate()) {
                    this.unmapped = new ConceptMapGroupUnmappedComponent();
                }
            }
            return this.unmapped;
        }

        public boolean hasUnmapped() {
            return this.unmapped != null && !this.unmapped.isEmpty();
        }

        public ConceptMapGroupComponent setUnmapped(ConceptMapGroupUnmappedComponent value) {
            this.unmapped = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("source", "canonical(CodeSystem)", "An absolute URI that identifies the source system where the concepts to be mapped are defined.", 0, 1, this.source));
            children.add(new Property("target", "canonical(CodeSystem)", "An absolute URI that identifies the target system that the concepts will be mapped to.", 0, 1, this.target));
            children.add(new Property("element", "", "Mappings for an individual concept in the source to one or more concepts in the target.", 0, Integer.MAX_VALUE, this.element));
            children.add(new Property("unmapped", "", "What to do when there is no mapping to a target concept from the source concept and ConceptMap.group.element.noMap is not true. This provides the \"default\" to be applied when there is no target concept mapping specified or the expansion of ConceptMap.group.element.target.valueSet is empty.", 0, 1, this.unmapped));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -896505829: {
                    return new Property("source", "canonical(CodeSystem)", "An absolute URI that identifies the source system where the concepts to be mapped are defined.", 0, 1, this.source);
                }
                case -880905839: {
                    return new Property("target", "canonical(CodeSystem)", "An absolute URI that identifies the target system that the concepts will be mapped to.", 0, 1, this.target);
                }
                case -1662836996: {
                    return new Property("element", "", "Mappings for an individual concept in the source to one or more concepts in the target.", 0, Integer.MAX_VALUE, this.element);
                }
                case -194857460: {
                    return new Property("unmapped", "", "What to do when there is no mapping to a target concept from the source concept and ConceptMap.group.element.noMap is not true. This provides the \"default\" to be applied when there is no target concept mapping specified or the expansion of ConceptMap.group.element.target.valueSet is empty.", 0, 1, this.unmapped);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.source;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.target;
                    }
                    return baseArray;
                }
                case -1662836996: {
                    return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
                }
                case -194857460: {
                    Base[] baseArray;
                    if (this.unmapped == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.unmapped;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    this.source = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -1662836996: {
                    this.getElement().add((SourceElementComponent)value);
                    return value;
                }
                case -194857460: {
                    this.unmapped = (ConceptMapGroupUnmappedComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("source")) {
                this.source = TypeConvertor.castToCanonical(value);
            } else if (name.equals("target")) {
                this.target = TypeConvertor.castToCanonical(value);
            } else if (name.equals("element")) {
                this.getElement().add((SourceElementComponent)value);
            } else if (name.equals("unmapped")) {
                this.unmapped = (ConceptMapGroupUnmappedComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("source")) {
                this.source = null;
            } else if (name.equals("target")) {
                this.target = null;
            } else if (name.equals("element")) {
                this.getElement().remove((SourceElementComponent)value);
            } else if (name.equals("unmapped")) {
                this.unmapped = (ConceptMapGroupUnmappedComponent)value;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return this.getSourceElement();
                }
                case -880905839: {
                    return this.getTargetElement();
                }
                case -1662836996: {
                    return this.addElement();
                }
                case -194857460: {
                    return this.getUnmapped();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return new String[]{"canonical"};
                }
                case -880905839: {
                    return new String[]{"canonical"};
                }
                case -1662836996: {
                    return new String[0];
                }
                case -194857460: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.source");
            }
            if (name.equals("target")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.target");
            }
            if (name.equals("element")) {
                return this.addElement();
            }
            if (name.equals("unmapped")) {
                this.unmapped = new ConceptMapGroupUnmappedComponent();
                return this.unmapped;
            }
            return super.addChild(name);
        }

        @Override
        public ConceptMapGroupComponent copy() {
            ConceptMapGroupComponent dst = new ConceptMapGroupComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptMapGroupComponent dst) {
            super.copyValues(dst);
            dst.source = this.source == null ? null : this.source.copy();
            CanonicalType canonicalType = dst.target = this.target == null ? null : this.target.copy();
            if (this.element != null) {
                dst.element = new ArrayList<SourceElementComponent>();
                for (SourceElementComponent i : this.element) {
                    dst.element.add(i.copy());
                }
            }
            dst.unmapped = this.unmapped == null ? null : this.unmapped.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupComponent)) {
                return false;
            }
            ConceptMapGroupComponent o = (ConceptMapGroupComponent)other_;
            return ConceptMapGroupComponent.compareDeep(this.source, o.source, true) && ConceptMapGroupComponent.compareDeep(this.target, o.target, true) && ConceptMapGroupComponent.compareDeep(this.element, o.element, true) && ConceptMapGroupComponent.compareDeep(this.unmapped, o.unmapped, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupComponent)) {
                return false;
            }
            ConceptMapGroupComponent o = (ConceptMapGroupComponent)other_;
            return ConceptMapGroupComponent.compareValues(this.source, o.source, true) && ConceptMapGroupComponent.compareValues(this.target, o.target, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.source, this.target, this.element, this.unmapped});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group";
        }

        public SourceElementComponent getOrAddElement(String code) {
            for (SourceElementComponent e : this.getElement()) {
                if (!code.equals(e.getCode())) continue;
                return e;
            }
            return this.addElement().setCode(code);
        }
    }

    @Block
    public static class ConceptMapGroupUnmappedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="use-source-code | fixed | other-map", formalDefinition="Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped source code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/conceptmap-unmapped-mode")
        protected Enumeration<ConceptMapGroupUnmappedMode> mode;
        @Child(name="code", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixed code when mode = fixed", formalDefinition="The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="valueSet", type={CanonicalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fixed code set when mode = fixed", formalDefinition="The set of fixed codes to use when the mode = 'fixed'  - all unmapped codes are mapped to each of the fixed codes.")
        protected CanonicalType valueSet;
        @Child(name="relationship", type={CodeType.class}, order=5, min=0, max=1, modifier=true, summary=false)
        @Description(shortDefinition="related-to | equivalent | source-is-narrower-than-target | source-is-broader-than-target | not-related-to", formalDefinition="The default relationship value to apply between the source and target concepts when the source code is unmapped and the mode is 'fixed' or 'use-source-code'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/concept-map-relationship")
        protected Enumeration<Enumerations.ConceptMapRelationship> relationship;
        @Child(name="otherMap", type={CanonicalType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="canonical reference to an additional ConceptMap to use for mapping if the source concept is unmapped", formalDefinition="The canonical reference to an additional ConceptMap resource instance to use for mapping if this ConceptMap resource contains no matching mapping for the source concept.")
        protected CanonicalType otherMap;
        private static final long serialVersionUID = 449945387L;

        public ConceptMapGroupUnmappedComponent() {
        }

        public ConceptMapGroupUnmappedComponent(ConceptMapGroupUnmappedMode mode) {
            this.setMode(mode);
        }

        public Enumeration<ConceptMapGroupUnmappedMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<ConceptMapGroupUnmappedMode>(new ConceptMapGroupUnmappedModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setModeElement(Enumeration<ConceptMapGroupUnmappedMode> value) {
            this.mode = value;
            return this;
        }

        public ConceptMapGroupUnmappedMode getMode() {
            return this.mode == null ? null : (ConceptMapGroupUnmappedMode)((Object)this.mode.getValue());
        }

        public ConceptMapGroupUnmappedComponent setMode(ConceptMapGroupUnmappedMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<ConceptMapGroupUnmappedMode>(new ConceptMapGroupUnmappedModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptMapGroupUnmappedComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptMapGroupUnmappedComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public ConceptMapGroupUnmappedComponent setValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.valueSet = null;
            } else {
                if (this.valueSet == null) {
                    this.valueSet = new CanonicalType();
                }
                this.valueSet.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.ConceptMapRelationship> getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setRelationshipElement(Enumeration<Enumerations.ConceptMapRelationship> value) {
            this.relationship = value;
            return this;
        }

        public Enumerations.ConceptMapRelationship getRelationship() {
            return this.relationship == null ? null : (Enumerations.ConceptMapRelationship)((Object)this.relationship.getValue());
        }

        public ConceptMapGroupUnmappedComponent setRelationship(Enumerations.ConceptMapRelationship value) {
            if (value == null) {
                this.relationship = null;
            } else {
                if (this.relationship == null) {
                    this.relationship = new Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
                }
                this.relationship.setValue((Object)value);
            }
            return this;
        }

        public CanonicalType getOtherMapElement() {
            if (this.otherMap == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapGroupUnmappedComponent.otherMap");
                }
                if (Configuration.doAutoCreate()) {
                    this.otherMap = new CanonicalType();
                }
            }
            return this.otherMap;
        }

        public boolean hasOtherMapElement() {
            return this.otherMap != null && !this.otherMap.isEmpty();
        }

        public boolean hasOtherMap() {
            return this.otherMap != null && !this.otherMap.isEmpty();
        }

        public ConceptMapGroupUnmappedComponent setOtherMapElement(CanonicalType value) {
            this.otherMap = value;
            return this;
        }

        public String getOtherMap() {
            return this.otherMap == null ? null : (String)this.otherMap.getValue();
        }

        public ConceptMapGroupUnmappedComponent setOtherMap(String value) {
            if (Utilities.noString((String)value)) {
                this.otherMap = null;
            } else {
                if (this.otherMap == null) {
                    this.otherMap = new CanonicalType();
                }
                this.otherMap.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "code", "Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped source code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).", 0, 1, this.mode));
            children.add(new Property("code", "code", "The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property("valueSet", "canonical(ValueSet)", "The set of fixed codes to use when the mode = 'fixed'  - all unmapped codes are mapped to each of the fixed codes.", 0, 1, this.valueSet));
            children.add(new Property("relationship", "code", "The default relationship value to apply between the source and target concepts when the source code is unmapped and the mode is 'fixed' or 'use-source-code'.", 0, 1, this.relationship));
            children.add(new Property("otherMap", "canonical(ConceptMap)", "The canonical reference to an additional ConceptMap resource instance to use for mapping if this ConceptMap resource contains no matching mapping for the source concept.", 0, 1, this.otherMap));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "code", "Defines which action to take if there is no match for the source concept in the target system designated for the group. One of 3 actions are possible: use the unmapped source code (this is useful when doing a mapping between versions, and only a few codes have changed), use a fixed code (a default code), or alternatively, a reference to a different concept map can be provided (by canonical URL).", 0, 1, this.mode);
                }
                case 3059181: {
                    return new Property("code", "code", "The fixed code to use when the mode = 'fixed'  - all unmapped codes are mapped to a single fixed code.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "The set of fixed codes to use when the mode = 'fixed'  - all unmapped codes are mapped to each of the fixed codes.", 0, 1, this.valueSet);
                }
                case -261851592: {
                    return new Property("relationship", "code", "The default relationship value to apply between the source and target concepts when the source code is unmapped and the mode is 'fixed' or 'use-source-code'.", 0, 1, this.relationship);
                }
                case -1171155924: {
                    return new Property("otherMap", "canonical(ConceptMap)", "The canonical reference to an additional ConceptMap resource instance to use for mapping if this ConceptMap resource contains no matching mapping for the source concept.", 0, 1, this.otherMap);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.display;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -1171155924: {
                    Base[] baseArray;
                    if (this.otherMap == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.otherMap;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new ConceptMapGroupUnmappedModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -261851592: {
                    value = new Enumerations.ConceptMapRelationshipEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.relationship = value;
                    return value;
                }
                case -1171155924: {
                    this.otherMap = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                value = new ConceptMapGroupUnmappedModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("valueSet")) {
                this.valueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("relationship")) {
                value = new Enumerations.ConceptMapRelationshipEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.relationship = value;
            } else if (name.equals("otherMap")) {
                this.otherMap = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                value = new ConceptMapGroupUnmappedModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else if (name.equals("valueSet")) {
                this.valueSet = null;
            } else if (name.equals("relationship")) {
                value = new Enumerations.ConceptMapRelationshipEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.relationship = value;
            } else if (name.equals("otherMap")) {
                this.otherMap = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
                case -261851592: {
                    return this.getRelationshipElement();
                }
                case -1171155924: {
                    return this.getOtherMapElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
                case -261851592: {
                    return new String[]{"code"};
                }
                case -1171155924: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.mode");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.display");
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.valueSet");
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.relationship");
            }
            if (name.equals("otherMap")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.unmapped.otherMap");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptMapGroupUnmappedComponent copy() {
            ConceptMapGroupUnmappedComponent dst = new ConceptMapGroupUnmappedComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConceptMapGroupUnmappedComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.otherMap = this.otherMap == null ? null : this.otherMap.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupUnmappedComponent)) {
                return false;
            }
            ConceptMapGroupUnmappedComponent o = (ConceptMapGroupUnmappedComponent)other_;
            return ConceptMapGroupUnmappedComponent.compareDeep(this.mode, o.mode, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.code, o.code, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.display, o.display, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.valueSet, o.valueSet, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.relationship, o.relationship, true) && ConceptMapGroupUnmappedComponent.compareDeep(this.otherMap, o.otherMap, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptMapGroupUnmappedComponent)) {
                return false;
            }
            ConceptMapGroupUnmappedComponent o = (ConceptMapGroupUnmappedComponent)other_;
            return ConceptMapGroupUnmappedComponent.compareValues(this.mode, o.mode, true) && ConceptMapGroupUnmappedComponent.compareValues(this.code, o.code, true) && ConceptMapGroupUnmappedComponent.compareValues(this.display, o.display, true) && ConceptMapGroupUnmappedComponent.compareValues(this.valueSet, o.valueSet, true) && ConceptMapGroupUnmappedComponent.compareValues(this.relationship, o.relationship, true) && ConceptMapGroupUnmappedComponent.compareValues(this.otherMap, o.otherMap, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.code, this.display, this.valueSet, this.relationship, this.otherMap});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.unmapped";
        }
    }

    @Block
    public static class OtherElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="attribute", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A reference to a mapping attribute defined in ConceptMap.additionalAttribute", formalDefinition="A reference to the additional attribute that holds a value the map depends on.")
        protected CodeType attribute;
        @Child(name="value", type={CodeType.class, Coding.class, StringType.class, BooleanType.class, Quantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the referenced data element", formalDefinition="Data element value that the map depends on / produces.")
        protected DataType value;
        @Child(name="valueSet", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The mapping depends on a data element with a value from this value set", formalDefinition="This mapping applies if the data element value is a code from this value set.")
        protected CanonicalType valueSet;
        private static final long serialVersionUID = 2103818133L;

        public OtherElementComponent() {
        }

        public OtherElementComponent(String attribute) {
            this.setAttribute(attribute);
        }

        public CodeType getAttributeElement() {
            if (this.attribute == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.attribute");
                }
                if (Configuration.doAutoCreate()) {
                    this.attribute = new CodeType();
                }
            }
            return this.attribute;
        }

        public boolean hasAttributeElement() {
            return this.attribute != null && !this.attribute.isEmpty();
        }

        public boolean hasAttribute() {
            return this.attribute != null && !this.attribute.isEmpty();
        }

        public OtherElementComponent setAttributeElement(CodeType value) {
            this.attribute = value;
            return this;
        }

        public String getAttribute() {
            return this.attribute == null ? null : (String)this.attribute.getValue();
        }

        public OtherElementComponent setAttribute(String value) {
            if (this.attribute == null) {
                this.attribute = new CodeType();
            }
            this.attribute.setValue(value);
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this.value instanceof CodeType;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this.value instanceof Coding;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public OtherElementComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeType || value instanceof Coding || value instanceof StringType || value instanceof BooleanType || value instanceof Quantity)) {
                throw new FHIRException("Not the right type for ConceptMap.group.element.target.dependsOn.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public OtherElementComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public OtherElementComponent setValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.valueSet = null;
            } else {
                if (this.valueSet == null) {
                    this.valueSet = new CanonicalType();
                }
                this.valueSet.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("attribute", "code", "A reference to the additional attribute that holds a value the map depends on.", 0, 1, this.attribute));
            children.add(new Property("value[x]", "code|Coding|string|boolean|Quantity", "Data element value that the map depends on / produces.", 0, 1, this.value));
            children.add(new Property("valueSet", "canonical(ValueSet)", "This mapping applies if the data element value is a code from this value set.", 0, 1, this.valueSet));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 13085340: {
                    return new Property("attribute", "code", "A reference to the additional attribute that holds a value the map depends on.", 0, 1, this.attribute);
                }
                case -1410166417: {
                    return new Property("value[x]", "code|Coding|string|boolean|Quantity", "Data element value that the map depends on / produces.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "code|Coding|string|boolean|Quantity", "Data element value that the map depends on / produces.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "code", "Data element value that the map depends on / produces.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "Data element value that the map depends on / produces.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "Data element value that the map depends on / produces.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "Data element value that the map depends on / produces.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Data element value that the map depends on / produces.", 0, 1, this.value);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "This mapping applies if the data element value is a code from this value set.", 0, 1, this.valueSet);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 13085340: {
                    Base[] baseArray;
                    if (this.attribute == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.attribute;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.valueSet;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 13085340: {
                    this.attribute = TypeConvertor.castToCode(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("attribute")) {
                this.attribute = TypeConvertor.castToCode(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("valueSet")) {
                this.valueSet = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("attribute")) {
                this.attribute = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else if (name.equals("valueSet")) {
                this.valueSet = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 13085340: {
                    return this.getAttributeElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 13085340: {
                    return new String[]{"code"};
                }
                case 111972721: {
                    return new String[]{"code", "Coding", "string", "boolean", "Quantity"};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("attribute")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.dependsOn.attribute");
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.dependsOn.valueSet");
            }
            return super.addChild(name);
        }

        @Override
        public OtherElementComponent copy() {
            OtherElementComponent dst = new OtherElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(OtherElementComponent dst) {
            super.copyValues(dst);
            dst.attribute = this.attribute == null ? null : this.attribute.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other_;
            return OtherElementComponent.compareDeep(this.attribute, o.attribute, true) && OtherElementComponent.compareDeep(this.value, o.value, true) && OtherElementComponent.compareDeep(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other_;
            return OtherElementComponent.compareValues(this.attribute, o.attribute, true) && OtherElementComponent.compareValues(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.attribute, this.value, this.valueSet});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element.target.dependsOn";
        }
    }

    @Block
    public static class MappingPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to ConceptMap.property.code", formalDefinition="A reference to a mapping property defined in ConceptMap.property.")
        protected CodeType code;
        @Child(name="value", type={Coding.class, StringType.class, IntegerType.class, BooleanType.class, DateTimeType.class, DecimalType.class, CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the property for this concept", formalDefinition="The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.")
        protected DataType value;
        private static final long serialVersionUID = -422546419L;

        public MappingPropertyComponent() {
        }

        public MappingPropertyComponent(String code, DataType value) {
            this.setCode(code);
            this.setValue(value);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MappingPropertyComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MappingPropertyComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public MappingPropertyComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this.value instanceof Coding;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this.value instanceof IntegerType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this.value instanceof DecimalType;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this.value instanceof CodeType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MappingPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof Coding || value instanceof StringType || value instanceof IntegerType || value instanceof BooleanType || value instanceof DateTimeType || value instanceof DecimalType || value instanceof CodeType)) {
                throw new FHIRException("Not the right type for ConceptMap.group.element.target.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "A reference to a mapping property defined in ConceptMap.property.", 0, 1, this.code));
            children.add(new Property("value[x]", "Coding|string|integer|boolean|dateTime|decimal|code", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "A reference to a mapping property defined in ConceptMap.property.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "Coding|string|integer|boolean|dateTime|decimal|code", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Coding|string|integer|boolean|dateTime|decimal|code", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "code", "The value of this property. If the type chosen for this element is 'code', then the property SHALL be defined in a ConceptMap.property element.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 111972721: {
                    return new String[]{"Coding", "string", "integer", "boolean", "dateTime", "decimal", "code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.property.code");
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public MappingPropertyComponent copy() {
            MappingPropertyComponent dst = new MappingPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(MappingPropertyComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MappingPropertyComponent)) {
                return false;
            }
            MappingPropertyComponent o = (MappingPropertyComponent)other_;
            return MappingPropertyComponent.compareDeep(this.code, o.code, true) && MappingPropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MappingPropertyComponent)) {
                return false;
            }
            MappingPropertyComponent o = (MappingPropertyComponent)other_;
            return MappingPropertyComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element.target.property";
        }
    }

    @Block
    public static class TargetElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that identifies the target element", formalDefinition="Identity (code or path) or the element/item that the map refers to.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="valueSet", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies the set of target concepts", formalDefinition="The set of concepts from the ConceptMap.group.target code system which are all being mapped to as part of this mapping rule. The effect of using this data element is the same as having multiple ConceptMap.group.element.target elements with one for each concept in the ConceptMap.group.element.target.valueSet value set.")
        protected CanonicalType valueSet;
        @Child(name="relationship", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="related-to | equivalent | source-is-narrower-than-target | source-is-broader-than-target | not-related-to", formalDefinition="The relationship between the source and target concepts. The relationship is read from source to target (e.g. source-is-narrower-than-target).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/concept-map-relationship")
        protected Enumeration<Enumerations.ConceptMapRelationship> relationship;
        @Child(name="comment", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of status/issues in mapping", formalDefinition="A description of status/issues in mapping that conveys additional information not represented in  the structured data.")
        protected StringType comment;
        @Child(name="property", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Property value for the source -> target mapping", formalDefinition="A property value for this source -> target mapping.")
        protected List<MappingPropertyComponent> property;
        @Child(name="dependsOn", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other properties required for this mapping", formalDefinition="A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified data attribute can be resolved, and it has the specified value.")
        protected List<OtherElementComponent> dependsOn;
        @Child(name="product", type={OtherElementComponent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other data elements that this mapping also produces", formalDefinition="Product is the output of a ConceptMap that provides additional values that go in other attributes / data elemnts of the target data.")
        protected List<OtherElementComponent> product;
        private static final long serialVersionUID = 792559555L;

        public String toString() {
            return "TargetElementComponent [code=" + String.valueOf(this.code) + ", relationship=" + String.valueOf(this.relationship) + "]";
        }

        public TargetElementComponent() {
        }

        public TargetElementComponent(Enumerations.ConceptMapRelationship relationship) {
            this.setRelationship(relationship);
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TargetElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TargetElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public TargetElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public TargetElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public TargetElementComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public TargetElementComponent setValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.valueSet = null;
            } else {
                if (this.valueSet == null) {
                    this.valueSet = new CanonicalType();
                }
                this.valueSet.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.ConceptMapRelationship> getRelationshipElement() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
                }
            }
            return this.relationship;
        }

        public boolean hasRelationshipElement() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public TargetElementComponent setRelationshipElement(Enumeration<Enumerations.ConceptMapRelationship> value) {
            this.relationship = value;
            return this;
        }

        public Enumerations.ConceptMapRelationship getRelationship() {
            return this.relationship == null ? null : (Enumerations.ConceptMapRelationship)((Object)this.relationship.getValue());
        }

        public TargetElementComponent setRelationship(Enumerations.ConceptMapRelationship value) {
            if (this.relationship == null) {
                this.relationship = new Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
            }
            this.relationship.setValue((Object)value);
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public TargetElementComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public TargetElementComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public List<MappingPropertyComponent> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<MappingPropertyComponent>();
            }
            return this.property;
        }

        public TargetElementComponent setProperty(List<MappingPropertyComponent> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (MappingPropertyComponent item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MappingPropertyComponent addProperty() {
            MappingPropertyComponent t = new MappingPropertyComponent();
            if (this.property == null) {
                this.property = new ArrayList<MappingPropertyComponent>();
            }
            this.property.add(t);
            return t;
        }

        public TargetElementComponent addProperty(MappingPropertyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.property == null) {
                this.property = new ArrayList<MappingPropertyComponent>();
            }
            this.property.add(t);
            return this;
        }

        public MappingPropertyComponent getPropertyFirstRep() {
            if (this.getProperty().isEmpty()) {
                this.addProperty();
            }
            return this.getProperty().get(0);
        }

        public List<OtherElementComponent> getDependsOn() {
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            return this.dependsOn;
        }

        public TargetElementComponent setDependsOn(List<OtherElementComponent> theDependsOn) {
            this.dependsOn = theDependsOn;
            return this;
        }

        public boolean hasDependsOn() {
            if (this.dependsOn == null) {
                return false;
            }
            for (OtherElementComponent item : this.dependsOn) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addDependsOn() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return t;
        }

        public TargetElementComponent addDependsOn(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return this;
        }

        public OtherElementComponent getDependsOnFirstRep() {
            if (this.getDependsOn().isEmpty()) {
                this.addDependsOn();
            }
            return this.getDependsOn().get(0);
        }

        public List<OtherElementComponent> getProduct() {
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            return this.product;
        }

        public TargetElementComponent setProduct(List<OtherElementComponent> theProduct) {
            this.product = theProduct;
            return this;
        }

        public boolean hasProduct() {
            if (this.product == null) {
                return false;
            }
            for (OtherElementComponent item : this.product) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addProduct() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return t;
        }

        public TargetElementComponent addProduct(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return this;
        }

        public OtherElementComponent getProductFirstRep() {
            if (this.getProduct().isEmpty()) {
                this.addProduct();
            }
            return this.getProduct().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Identity (code or path) or the element/item that the map refers to.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property("valueSet", "canonical(ValueSet)", "The set of concepts from the ConceptMap.group.target code system which are all being mapped to as part of this mapping rule. The effect of using this data element is the same as having multiple ConceptMap.group.element.target elements with one for each concept in the ConceptMap.group.element.target.valueSet value set.", 0, 1, this.valueSet));
            children.add(new Property("relationship", "code", "The relationship between the source and target concepts. The relationship is read from source to target (e.g. source-is-narrower-than-target).", 0, 1, this.relationship));
            children.add(new Property("comment", "string", "A description of status/issues in mapping that conveys additional information not represented in  the structured data.", 0, 1, this.comment));
            children.add(new Property("property", "", "A property value for this source -> target mapping.", 0, Integer.MAX_VALUE, this.property));
            children.add(new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified data attribute can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn));
            children.add(new Property("product", "@ConceptMap.group.element.target.dependsOn", "Product is the output of a ConceptMap that provides additional values that go in other attributes / data elemnts of the target data.", 0, Integer.MAX_VALUE, this.product));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Identity (code or path) or the element/item that the map refers to.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "The set of concepts from the ConceptMap.group.target code system which are all being mapped to as part of this mapping rule. The effect of using this data element is the same as having multiple ConceptMap.group.element.target elements with one for each concept in the ConceptMap.group.element.target.valueSet value set.", 0, 1, this.valueSet);
                }
                case -261851592: {
                    return new Property("relationship", "code", "The relationship between the source and target concepts. The relationship is read from source to target (e.g. source-is-narrower-than-target).", 0, 1, this.relationship);
                }
                case 950398559: {
                    return new Property("comment", "string", "A description of status/issues in mapping that conveys additional information not represented in  the structured data.", 0, 1, this.comment);
                }
                case -993141291: {
                    return new Property("property", "", "A property value for this source -> target mapping.", 0, Integer.MAX_VALUE, this.property);
                }
                case -1109214266: {
                    return new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified data attribute can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn);
                }
                case -309474065: {
                    return new Property("product", "@ConceptMap.group.element.target.dependsOn", "Product is the output of a ConceptMap that provides additional values that go in other attributes / data elemnts of the target data.", 0, Integer.MAX_VALUE, this.product);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.relationship;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.comment;
                    }
                    return baseArray;
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
                case -1109214266: {
                    return this.dependsOn == null ? new Base[]{} : this.dependsOn.toArray(new Base[this.dependsOn.size()]);
                }
                case -309474065: {
                    return this.product == null ? new Base[]{} : this.product.toArray(new Base[this.product.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -261851592: {
                    value = new Enumerations.ConceptMapRelationshipEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.relationship = value;
                    return value;
                }
                case 950398559: {
                    this.comment = TypeConvertor.castToString(value);
                    return value;
                }
                case -993141291: {
                    this.getProperty().add((MappingPropertyComponent)((Object)value));
                    return value;
                }
                case -1109214266: {
                    this.getDependsOn().add((OtherElementComponent)((Object)value));
                    return value;
                }
                case -309474065: {
                    this.getProduct().add((OtherElementComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("valueSet")) {
                this.valueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("relationship")) {
                value = new Enumerations.ConceptMapRelationshipEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.relationship = value;
            } else if (name.equals("comment")) {
                this.comment = TypeConvertor.castToString(value);
            } else if (name.equals("property")) {
                this.getProperty().add((MappingPropertyComponent)((Object)value));
            } else if (name.equals("dependsOn")) {
                this.getDependsOn().add((OtherElementComponent)((Object)value));
            } else if (name.equals("product")) {
                this.getProduct().add((OtherElementComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else if (name.equals("valueSet")) {
                this.valueSet = null;
            } else if (name.equals("relationship")) {
                value = new Enumerations.ConceptMapRelationshipEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.relationship = value;
            } else if (name.equals("comment")) {
                this.comment = null;
            } else if (name.equals("property")) {
                this.getProperty().remove((MappingPropertyComponent)((Object)value));
            } else if (name.equals("dependsOn")) {
                this.getDependsOn().remove((OtherElementComponent)((Object)value));
            } else if (name.equals("product")) {
                this.getProduct().remove((OtherElementComponent)((Object)value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
                case -261851592: {
                    return this.getRelationshipElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
                case -993141291: {
                    return this.addProperty();
                }
                case -1109214266: {
                    return this.addDependsOn();
                }
                case -309474065: {
                    return this.addProduct();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
                case -261851592: {
                    return new String[]{"code"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
                case -993141291: {
                    return new String[0];
                }
                case -1109214266: {
                    return new String[0];
                }
                case -309474065: {
                    return new String[]{"@ConceptMap.group.element.target.dependsOn"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.display");
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.valueSet");
            }
            if (name.equals("relationship")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.relationship");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.target.comment");
            }
            if (name.equals("property")) {
                return this.addProperty();
            }
            if (name.equals("dependsOn")) {
                return this.addDependsOn();
            }
            if (name.equals("product")) {
                return this.addProduct();
            }
            return super.addChild(name);
        }

        @Override
        public TargetElementComponent copy() {
            TargetElementComponent dst = new TargetElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TargetElementComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            StringType stringType = dst.comment = this.comment == null ? null : this.comment.copy();
            if (this.property != null) {
                dst.property = new ArrayList<MappingPropertyComponent>();
                for (MappingPropertyComponent mappingPropertyComponent : this.property) {
                    dst.property.add(mappingPropertyComponent.copy());
                }
            }
            if (this.dependsOn != null) {
                dst.dependsOn = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent otherElementComponent : this.dependsOn) {
                    dst.dependsOn.add(otherElementComponent.copy());
                }
            }
            if (this.product != null) {
                dst.product = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent otherElementComponent : this.product) {
                    dst.product.add(otherElementComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other_;
            return TargetElementComponent.compareDeep(this.code, o.code, true) && TargetElementComponent.compareDeep(this.display, o.display, true) && TargetElementComponent.compareDeep(this.valueSet, o.valueSet, true) && TargetElementComponent.compareDeep(this.relationship, o.relationship, true) && TargetElementComponent.compareDeep(this.comment, o.comment, true) && TargetElementComponent.compareDeep(this.property, o.property, true) && TargetElementComponent.compareDeep(this.dependsOn, o.dependsOn, true) && TargetElementComponent.compareDeep(this.product, o.product, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other_;
            return TargetElementComponent.compareValues(this.code, o.code, true) && TargetElementComponent.compareValues(this.display, o.display, true) && TargetElementComponent.compareValues(this.valueSet, o.valueSet, true) && TargetElementComponent.compareValues(this.relationship, o.relationship, true) && TargetElementComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.valueSet, this.relationship, this.comment, this.property, this.dependsOn, this.product});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element.target";
        }
    }

    @Block
    public static class SourceElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies element being mapped", formalDefinition="Identity (code or path) or the element/item being mapped.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Display for the code", formalDefinition="The display for the code. The display is only provided to help editors when editing the concept map.")
        protected StringType display;
        @Child(name="valueSet", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies the set of concepts being mapped", formalDefinition="The set of concepts from the ConceptMap.group.source code system which are all being mapped to the target as part of this mapping rule.")
        protected CanonicalType valueSet;
        @Child(name="noMap", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="No mapping to a target concept for this source concept", formalDefinition="If noMap = true this indicates that no mapping to a target concept exists for this source concept.")
        protected BooleanType noMap;
        @Child(name="target", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Concept in target system for element", formalDefinition="A concept from the target value set that this concept maps to.")
        protected List<TargetElementComponent> target;
        private static final long serialVersionUID = 1485743554L;

        public String toString() {
            return "SourceElementComponent [code=" + String.valueOf(this.code) + ", display=" + String.valueOf(this.display) + ", noMap=" + String.valueOf(this.noMap) + "]";
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SourceElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public SourceElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public SourceElementComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public SourceElementComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public CanonicalType getValueSetElement() {
            if (this.valueSet == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.valueSet");
                }
                if (Configuration.doAutoCreate()) {
                    this.valueSet = new CanonicalType();
                }
            }
            return this.valueSet;
        }

        public boolean hasValueSetElement() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public SourceElementComponent setValueSetElement(CanonicalType value) {
            this.valueSet = value;
            return this;
        }

        public String getValueSet() {
            return this.valueSet == null ? null : (String)this.valueSet.getValue();
        }

        public SourceElementComponent setValueSet(String value) {
            if (Utilities.noString((String)value)) {
                this.valueSet = null;
            } else {
                if (this.valueSet == null) {
                    this.valueSet = new CanonicalType();
                }
                this.valueSet.setValue(value);
            }
            return this;
        }

        public BooleanType getNoMapElement() {
            if (this.noMap == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.noMap");
                }
                if (Configuration.doAutoCreate()) {
                    this.noMap = new BooleanType();
                }
            }
            return this.noMap;
        }

        public boolean hasNoMapElement() {
            return this.noMap != null && !this.noMap.isEmpty();
        }

        public boolean hasNoMap() {
            return this.noMap != null && !this.noMap.isEmpty();
        }

        public SourceElementComponent setNoMapElement(BooleanType value) {
            this.noMap = value;
            return this;
        }

        public boolean getNoMap() {
            return this.noMap == null || this.noMap.isEmpty() ? false : (Boolean)this.noMap.getValue();
        }

        public SourceElementComponent setNoMap(boolean value) {
            if (this.noMap == null) {
                this.noMap = new BooleanType();
            }
            this.noMap.setValue((Object)value);
            return this;
        }

        public List<TargetElementComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            return this.target;
        }

        public SourceElementComponent setTarget(List<TargetElementComponent> theTarget) {
            this.target = theTarget;
            return this;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (TargetElementComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TargetElementComponent addTarget() {
            TargetElementComponent t = new TargetElementComponent();
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return t;
        }

        public SourceElementComponent addTarget(TargetElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return this;
        }

        public TargetElementComponent getTargetFirstRep() {
            if (this.getTarget().isEmpty()) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Identity (code or path) or the element/item being mapped.", 0, 1, this.code));
            children.add(new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display));
            children.add(new Property("valueSet", "canonical(ValueSet)", "The set of concepts from the ConceptMap.group.source code system which are all being mapped to the target as part of this mapping rule.", 0, 1, this.valueSet));
            children.add(new Property("noMap", "boolean", "If noMap = true this indicates that no mapping to a target concept exists for this source concept.", 0, 1, this.noMap));
            children.add(new Property("target", "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Identity (code or path) or the element/item being mapped.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The display for the code. The display is only provided to help editors when editing the concept map.", 0, 1, this.display);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "The set of concepts from the ConceptMap.group.source code system which are all being mapped to the target as part of this mapping rule.", 0, 1, this.valueSet);
                }
                case 104971227: {
                    return new Property("noMap", "boolean", "If noMap = true this indicates that no mapping to a target concept exists for this source concept.", 0, 1, this.noMap);
                }
                case -880905839: {
                    return new Property("target", "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case 104971227: {
                    Base[] baseArray;
                    if (this.noMap == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.noMap;
                    }
                    return baseArray;
                }
                case -880905839: {
                    return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = TypeConvertor.castToString(value);
                    return value;
                }
                case -1410174671: {
                    this.valueSet = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 104971227: {
                    this.noMap = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -880905839: {
                    this.getTarget().add((TargetElementComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCode(value);
            } else if (name.equals("display")) {
                this.display = TypeConvertor.castToString(value);
            } else if (name.equals("valueSet")) {
                this.valueSet = TypeConvertor.castToCanonical(value);
            } else if (name.equals("noMap")) {
                this.noMap = TypeConvertor.castToBoolean(value);
            } else if (name.equals("target")) {
                this.getTarget().add((TargetElementComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("display")) {
                this.display = null;
            } else if (name.equals("valueSet")) {
                this.valueSet = null;
            } else if (name.equals("noMap")) {
                this.noMap = null;
            } else if (name.equals("target")) {
                this.getTarget().remove((TargetElementComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -1410174671: {
                    return this.getValueSetElement();
                }
                case 104971227: {
                    return this.getNoMapElement();
                }
                case -880905839: {
                    return this.addTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
                case 104971227: {
                    return new String[]{"boolean"};
                }
                case -880905839: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.display");
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.valueSet");
            }
            if (name.equals("noMap")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.group.element.noMap");
            }
            if (name.equals("target")) {
                return this.addTarget();
            }
            return super.addChild(name);
        }

        @Override
        public SourceElementComponent copy() {
            SourceElementComponent dst = new SourceElementComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SourceElementComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.display = this.display == null ? null : this.display.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            BooleanType booleanType = dst.noMap = this.noMap == null ? null : this.noMap.copy();
            if (this.target != null) {
                dst.target = new ArrayList<TargetElementComponent>();
                for (TargetElementComponent i : this.target) {
                    dst.target.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other_;
            return SourceElementComponent.compareDeep(this.code, o.code, true) && SourceElementComponent.compareDeep(this.display, o.display, true) && SourceElementComponent.compareDeep(this.valueSet, o.valueSet, true) && SourceElementComponent.compareDeep(this.noMap, o.noMap, true) && SourceElementComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other_;
            return SourceElementComponent.compareValues(this.code, o.code, true) && SourceElementComponent.compareValues(this.display, o.display, true) && SourceElementComponent.compareValues(this.valueSet, o.valueSet, true) && SourceElementComponent.compareValues(this.noMap, o.noMap, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.valueSet, this.noMap, this.target});
        }

        @Override
        public String fhirType() {
            return "ConceptMap.group.element";
        }

        public boolean hasTargetCode(String code) {
            for (TargetElementComponent tgt : this.getTarget()) {
                if (!code.equals(tgt.getCode())) continue;
                return true;
            }
            return false;
        }

        public TargetElementComponent addTarget(String code, Enumerations.ConceptMapRelationship relationship) {
            TargetElementComponent tgt = this.addTarget();
            tgt.setCode(code);
            tgt.setRelationship(relationship);
            return tgt;
        }
    }

    public static class ConceptMapPropertyTypeEnumFactory
    implements EnumFactory<ConceptMapPropertyType> {
        @Override
        public ConceptMapPropertyType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Coding".equals(codeString)) {
                return ConceptMapPropertyType.CODING;
            }
            if ("string".equals(codeString)) {
                return ConceptMapPropertyType.STRING;
            }
            if ("integer".equals(codeString)) {
                return ConceptMapPropertyType.INTEGER;
            }
            if ("boolean".equals(codeString)) {
                return ConceptMapPropertyType.BOOLEAN;
            }
            if ("dateTime".equals(codeString)) {
                return ConceptMapPropertyType.DATETIME;
            }
            if ("decimal".equals(codeString)) {
                return ConceptMapPropertyType.DECIMAL;
            }
            if ("code".equals(codeString)) {
                return ConceptMapPropertyType.CODE;
            }
            throw new IllegalArgumentException("Unknown ConceptMapPropertyType code '" + codeString + "'");
        }

        public Enumeration<ConceptMapPropertyType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConceptMapPropertyType>(this, ConceptMapPropertyType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConceptMapPropertyType>(this, ConceptMapPropertyType.NULL, code);
            }
            if ("Coding".equals(codeString)) {
                return new Enumeration<ConceptMapPropertyType>(this, ConceptMapPropertyType.CODING, code);
            }
            if ("string".equals(codeString)) {
                return new Enumeration<ConceptMapPropertyType>(this, ConceptMapPropertyType.STRING, code);
            }
            if ("integer".equals(codeString)) {
                return new Enumeration<ConceptMapPropertyType>(this, ConceptMapPropertyType.INTEGER, code);
            }
            if ("boolean".equals(codeString)) {
                return new Enumeration<ConceptMapPropertyType>(this, ConceptMapPropertyType.BOOLEAN, code);
            }
            if ("dateTime".equals(codeString)) {
                return new Enumeration<ConceptMapPropertyType>(this, ConceptMapPropertyType.DATETIME, code);
            }
            if ("decimal".equals(codeString)) {
                return new Enumeration<ConceptMapPropertyType>(this, ConceptMapPropertyType.DECIMAL, code);
            }
            if ("code".equals(codeString)) {
                return new Enumeration<ConceptMapPropertyType>(this, ConceptMapPropertyType.CODE, code);
            }
            throw new FHIRException("Unknown ConceptMapPropertyType code '" + codeString + "'");
        }

        @Override
        public String toCode(ConceptMapPropertyType code) {
            if (code == ConceptMapPropertyType.NULL) {
                return null;
            }
            if (code == ConceptMapPropertyType.CODING) {
                return "Coding";
            }
            if (code == ConceptMapPropertyType.STRING) {
                return "string";
            }
            if (code == ConceptMapPropertyType.INTEGER) {
                return "integer";
            }
            if (code == ConceptMapPropertyType.BOOLEAN) {
                return "boolean";
            }
            if (code == ConceptMapPropertyType.DATETIME) {
                return "dateTime";
            }
            if (code == ConceptMapPropertyType.DECIMAL) {
                return "decimal";
            }
            if (code == ConceptMapPropertyType.CODE) {
                return "code";
            }
            return "?";
        }

        @Override
        public String toSystem(ConceptMapPropertyType code) {
            return code.getSystem();
        }
    }

    public static enum ConceptMapPropertyType {
        CODING,
        STRING,
        INTEGER,
        BOOLEAN,
        DATETIME,
        DECIMAL,
        CODE,
        NULL;


        public static ConceptMapPropertyType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Coding".equals(codeString)) {
                return CODING;
            }
            if ("string".equals(codeString)) {
                return STRING;
            }
            if ("integer".equals(codeString)) {
                return INTEGER;
            }
            if ("boolean".equals(codeString)) {
                return BOOLEAN;
            }
            if ("dateTime".equals(codeString)) {
                return DATETIME;
            }
            if ("decimal".equals(codeString)) {
                return DECIMAL;
            }
            if ("code".equals(codeString)) {
                return CODE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConceptMapPropertyType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CODING: {
                    return "Coding";
                }
                case STRING: {
                    return "string";
                }
                case INTEGER: {
                    return "integer";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case DATETIME: {
                    return "dateTime";
                }
                case DECIMAL: {
                    return "decimal";
                }
                case CODE: {
                    return "code";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CODING: {
                    return "http://hl7.org/fhir/conceptmap-property-type";
                }
                case STRING: {
                    return "http://hl7.org/fhir/conceptmap-property-type";
                }
                case INTEGER: {
                    return "http://hl7.org/fhir/conceptmap-property-type";
                }
                case BOOLEAN: {
                    return "http://hl7.org/fhir/conceptmap-property-type";
                }
                case DATETIME: {
                    return "http://hl7.org/fhir/conceptmap-property-type";
                }
                case DECIMAL: {
                    return "http://hl7.org/fhir/conceptmap-property-type";
                }
                case CODE: {
                    return "http://hl7.org/fhir/conceptmap-property-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CODING: {
                    return "The property  value is a code defined in an external code system. This may be used for translations, but is not the intent.";
                }
                case STRING: {
                    return "The property value is a string.";
                }
                case INTEGER: {
                    return "The property value is an integer (often used to assign ranking values to concepts for supporting score assessments).";
                }
                case BOOLEAN: {
                    return "The property value is a boolean true | false.";
                }
                case DATETIME: {
                    return "The property is a date or a date + time.";
                }
                case DECIMAL: {
                    return "The property value is a decimal number.";
                }
                case CODE: {
                    return "The property value is a code as defined in the CodeSystem in ConceptMap.property.system.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CODING: {
                    return "Coding (external reference)";
                }
                case STRING: {
                    return "string";
                }
                case INTEGER: {
                    return "integer";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case DATETIME: {
                    return "dateTime";
                }
                case DECIMAL: {
                    return "decimal";
                }
                case CODE: {
                    return "code";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ConceptMapGroupUnmappedModeEnumFactory
    implements EnumFactory<ConceptMapGroupUnmappedMode> {
        @Override
        public ConceptMapGroupUnmappedMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("use-source-code".equals(codeString)) {
                return ConceptMapGroupUnmappedMode.USESOURCECODE;
            }
            if ("fixed".equals(codeString)) {
                return ConceptMapGroupUnmappedMode.FIXED;
            }
            if (ConceptMap.SP_OTHER_MAP.equals(codeString)) {
                return ConceptMapGroupUnmappedMode.OTHERMAP;
            }
            throw new IllegalArgumentException("Unknown ConceptMapGroupUnmappedMode code '" + codeString + "'");
        }

        public Enumeration<ConceptMapGroupUnmappedMode> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.NULL, code);
            }
            if ("use-source-code".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.USESOURCECODE, code);
            }
            if ("fixed".equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.FIXED, code);
            }
            if (ConceptMap.SP_OTHER_MAP.equals(codeString)) {
                return new Enumeration<ConceptMapGroupUnmappedMode>(this, ConceptMapGroupUnmappedMode.OTHERMAP, code);
            }
            throw new FHIRException("Unknown ConceptMapGroupUnmappedMode code '" + codeString + "'");
        }

        @Override
        public String toCode(ConceptMapGroupUnmappedMode code) {
            if (code == ConceptMapGroupUnmappedMode.NULL) {
                return null;
            }
            if (code == ConceptMapGroupUnmappedMode.USESOURCECODE) {
                return "use-source-code";
            }
            if (code == ConceptMapGroupUnmappedMode.FIXED) {
                return "fixed";
            }
            if (code == ConceptMapGroupUnmappedMode.OTHERMAP) {
                return ConceptMap.SP_OTHER_MAP;
            }
            return "?";
        }

        @Override
        public String toSystem(ConceptMapGroupUnmappedMode code) {
            return code.getSystem();
        }
    }

    public static enum ConceptMapGroupUnmappedMode {
        USESOURCECODE,
        FIXED,
        OTHERMAP,
        NULL;


        public static ConceptMapGroupUnmappedMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("use-source-code".equals(codeString)) {
                return USESOURCECODE;
            }
            if ("fixed".equals(codeString)) {
                return FIXED;
            }
            if (ConceptMap.SP_OTHER_MAP.equals(codeString)) {
                return OTHERMAP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConceptMapGroupUnmappedMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case USESOURCECODE: {
                    return "use-source-code";
                }
                case FIXED: {
                    return "fixed";
                }
                case OTHERMAP: {
                    return ConceptMap.SP_OTHER_MAP;
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case USESOURCECODE: {
                    return "http://hl7.org/fhir/conceptmap-unmapped-mode";
                }
                case FIXED: {
                    return "http://hl7.org/fhir/conceptmap-unmapped-mode";
                }
                case OTHERMAP: {
                    return "http://hl7.org/fhir/conceptmap-unmapped-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case USESOURCECODE: {
                    return "Use the code as provided in the $translate request in one of the following input parameters: sourceCode, sourceCoding, sourceCodeableConcept.";
                }
                case FIXED: {
                    return "Use the code(s) explicitly provided in the group.unmapped 'code' or 'valueSet' element.";
                }
                case OTHERMAP: {
                    return "Use the map identified by the canonical URL in the url element.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case USESOURCECODE: {
                    return "Use Provided Source Code";
                }
                case FIXED: {
                    return "Fixed Code";
                }
                case OTHERMAP: {
                    return "Other Map";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ConceptMapAttributeTypeEnumFactory
    implements EnumFactory<ConceptMapAttributeType> {
        @Override
        public ConceptMapAttributeType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("code".equals(codeString)) {
                return ConceptMapAttributeType.CODE;
            }
            if ("Coding".equals(codeString)) {
                return ConceptMapAttributeType.CODING;
            }
            if ("string".equals(codeString)) {
                return ConceptMapAttributeType.STRING;
            }
            if ("boolean".equals(codeString)) {
                return ConceptMapAttributeType.BOOLEAN;
            }
            if ("Quantity".equals(codeString)) {
                return ConceptMapAttributeType.QUANTITY;
            }
            throw new IllegalArgumentException("Unknown ConceptMapAttributeType code '" + codeString + "'");
        }

        public Enumeration<ConceptMapAttributeType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConceptMapAttributeType>(this, ConceptMapAttributeType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConceptMapAttributeType>(this, ConceptMapAttributeType.NULL, code);
            }
            if ("code".equals(codeString)) {
                return new Enumeration<ConceptMapAttributeType>(this, ConceptMapAttributeType.CODE, code);
            }
            if ("Coding".equals(codeString)) {
                return new Enumeration<ConceptMapAttributeType>(this, ConceptMapAttributeType.CODING, code);
            }
            if ("string".equals(codeString)) {
                return new Enumeration<ConceptMapAttributeType>(this, ConceptMapAttributeType.STRING, code);
            }
            if ("boolean".equals(codeString)) {
                return new Enumeration<ConceptMapAttributeType>(this, ConceptMapAttributeType.BOOLEAN, code);
            }
            if ("Quantity".equals(codeString)) {
                return new Enumeration<ConceptMapAttributeType>(this, ConceptMapAttributeType.QUANTITY, code);
            }
            throw new FHIRException("Unknown ConceptMapAttributeType code '" + codeString + "'");
        }

        @Override
        public String toCode(ConceptMapAttributeType code) {
            if (code == ConceptMapAttributeType.NULL) {
                return null;
            }
            if (code == ConceptMapAttributeType.CODE) {
                return "code";
            }
            if (code == ConceptMapAttributeType.CODING) {
                return "Coding";
            }
            if (code == ConceptMapAttributeType.STRING) {
                return "string";
            }
            if (code == ConceptMapAttributeType.BOOLEAN) {
                return "boolean";
            }
            if (code == ConceptMapAttributeType.QUANTITY) {
                return "Quantity";
            }
            return "?";
        }

        @Override
        public String toSystem(ConceptMapAttributeType code) {
            return code.getSystem();
        }
    }

    public static enum ConceptMapAttributeType {
        CODE,
        CODING,
        STRING,
        BOOLEAN,
        QUANTITY,
        NULL;


        public static ConceptMapAttributeType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("code".equals(codeString)) {
                return CODE;
            }
            if ("Coding".equals(codeString)) {
                return CODING;
            }
            if ("string".equals(codeString)) {
                return STRING;
            }
            if ("boolean".equals(codeString)) {
                return BOOLEAN;
            }
            if ("Quantity".equals(codeString)) {
                return QUANTITY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConceptMapAttributeType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CODE: {
                    return "code";
                }
                case CODING: {
                    return "Coding";
                }
                case STRING: {
                    return "string";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case QUANTITY: {
                    return "Quantity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CODE: {
                    return "http://hl7.org/fhir/conceptmap-attribute-type";
                }
                case CODING: {
                    return "http://hl7.org/fhir/conceptmap-attribute-type";
                }
                case STRING: {
                    return "http://hl7.org/fhir/conceptmap-attribute-type";
                }
                case BOOLEAN: {
                    return "http://hl7.org/fhir/conceptmap-attribute-type";
                }
                case QUANTITY: {
                    return "http://hl7.org/fhir/conceptmap-attribute-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CODE: {
                    return "The attribute value is a code defined in the code system in context.";
                }
                case CODING: {
                    return "The attribute value is a code defined in a code system.";
                }
                case STRING: {
                    return "The attribute value is a string.";
                }
                case BOOLEAN: {
                    return "The attribute value is a boolean true | false.";
                }
                case QUANTITY: {
                    return "The attribute is a Quantity (may represent an integer or a decimal with no units).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CODE: {
                    return "code";
                }
                case CODING: {
                    return "Coding";
                }
                case STRING: {
                    return "string";
                }
                case BOOLEAN: {
                    return "boolean";
                }
                case QUANTITY: {
                    return "Quantity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

