/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ConditionDefinition", profile="http://hl7.org/fhir/StructureDefinition/ConditionDefinition")
public class ConditionDefinition
extends MetadataResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this condition definition, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this condition definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this condition definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the condition definition is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the condition definition", formalDefinition="A formal identifier that is used to identify this condition definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the condition definition", formalDefinition="The identifier that is used to identify this version of the condition definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the condition definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="versionAlgorithm", type={StringType.class, Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How to compare versions", formalDefinition="Indicates the mechanism used to compare versions to determine which is more current.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/version-algorithm")
    protected DataType versionAlgorithm;
    @Child(name="name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this condition definition (computer friendly)", formalDefinition="A natural language name identifying the condition definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this condition definition (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the condition definition.")
    protected StringType title;
    @Child(name="subtitle", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subordinate title of the event definition", formalDefinition="An explanatory or alternate title for the event definition giving additional information about its content.")
    protected StringType subtitle;
    @Child(name="status", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this condition definition. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this condition definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the condition definition was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the condition definition changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher/steward (organization or individual)", formalDefinition="The name of the organization or individual responsible for the release and ongoing maintenance of the condition definition.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the condition definition", formalDefinition="A free text natural language description of the condition definition from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate condition definition instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for condition definition (if applicable)", formalDefinition="A legal or geographic region in which the condition definition is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="code", type={CodeableConcept.class}, order=15, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identification of the condition, problem or diagnosis", formalDefinition="Identification of the condition, problem or diagnosis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    protected CodeableConcept code;
    @Child(name="severity", type={CodeableConcept.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Subjective severity of condition", formalDefinition="A subjective assessment of the severity of the condition as evaluated by the clinician.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-severity")
    protected CodeableConcept severity;
    @Child(name="bodySite", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Anatomical location, if relevant", formalDefinition="The anatomical location where this condition manifests itself.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableConcept bodySite;
    @Child(name="stage", type={CodeableConcept.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Stage/grade, usually assessed formally", formalDefinition="Clinical stage or grade of a condition. May include formal severity assessments.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-stage")
    protected CodeableConcept stage;
    @Child(name="hasSeverity", type={BooleanType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether Severity is appropriate", formalDefinition="Whether Severity is appropriate to collect for this condition.")
    protected BooleanType hasSeverity;
    @Child(name="hasBodySite", type={BooleanType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether bodySite is appropriate", formalDefinition="Whether bodySite is appropriate to collect for this condition.")
    protected BooleanType hasBodySite;
    @Child(name="hasStage", type={BooleanType.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether stage is appropriate", formalDefinition="Whether stage is appropriate to collect for this condition.")
    protected BooleanType hasStage;
    @Child(name="definition", type={UriType.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Formal Definition for the condition", formalDefinition="Formal definitions of the condition. These may be references to ontologies, published clinical protocols or research papers.")
    protected List<UriType> definition;
    @Child(name="observation", type={}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Observations particularly relevant to this condition", formalDefinition="Observations particularly relevant to this condition.")
    protected List<ConditionDefinitionObservationComponent> observation;
    @Child(name="medication", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Medications particularly relevant for this condition", formalDefinition="Medications particularly relevant for this condition.")
    protected List<ConditionDefinitionMedicationComponent> medication;
    @Child(name="precondition", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Observation that suggets this condition", formalDefinition="An observation that suggests that this condition applies.")
    protected List<ConditionDefinitionPreconditionComponent> precondition;
    @Child(name="team", type={CareTeam.class}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Appropriate team for this condition", formalDefinition="Appropriate team for this condition.")
    protected List<Reference> team;
    @Child(name="questionnaire", type={}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Questionnaire for this condition", formalDefinition="Questionnaire for this condition.")
    protected List<ConditionDefinitionQuestionnaireComponent> questionnaire;
    @Child(name="plan", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Plan that is appropriate", formalDefinition="Plan that is appropriate.")
    protected List<ConditionDefinitionPlanComponent> plan;
    private static final long serialVersionUID = 1055220331L;
    @SearchParamDefinition(name="context-quantity", path="(ActivityDefinition.useContext.value.ofType(Quantity)) | (ActivityDefinition.useContext.value.ofType(Range)) | (ActorDefinition.useContext.value.ofType(Quantity)) | (ActorDefinition.useContext.value.ofType(Range)) | (CapabilityStatement.useContext.value.ofType(Quantity)) | (CapabilityStatement.useContext.value.ofType(Range)) | (ChargeItemDefinition.useContext.value.ofType(Quantity)) | (ChargeItemDefinition.useContext.value.ofType(Range)) | (Citation.useContext.value.ofType(Quantity)) | (Citation.useContext.value.ofType(Range)) | (CodeSystem.useContext.value.ofType(Quantity)) | (CodeSystem.useContext.value.ofType(Range)) | (CompartmentDefinition.useContext.value.ofType(Quantity)) | (CompartmentDefinition.useContext.value.ofType(Range)) | (ConceptMap.useContext.value.ofType(Quantity)) | (ConceptMap.useContext.value.ofType(Range)) | (ConditionDefinition.useContext.value.ofType(Quantity)) | (ConditionDefinition.useContext.value.ofType(Range)) | (EventDefinition.useContext.value.ofType(Quantity)) | (EventDefinition.useContext.value.ofType(Range)) | (Evidence.useContext.value.ofType(Quantity)) | (Evidence.useContext.value.ofType(Range)) | (EvidenceReport.useContext.value.ofType(Quantity)) | (EvidenceReport.useContext.value.ofType(Range)) | (EvidenceVariable.useContext.value.ofType(Quantity)) | (EvidenceVariable.useContext.value.ofType(Range)) | (ExampleScenario.useContext.value.ofType(Quantity)) | (ExampleScenario.useContext.value.ofType(Range)) | (GraphDefinition.useContext.value.ofType(Quantity)) | (GraphDefinition.useContext.value.ofType(Range)) | (ImplementationGuide.useContext.value.ofType(Quantity)) | (ImplementationGuide.useContext.value.ofType(Range)) | (Library.useContext.value.ofType(Quantity)) | (Library.useContext.value.ofType(Range)) | (Measure.useContext.value.ofType(Quantity)) | (Measure.useContext.value.ofType(Range)) | (MessageDefinition.useContext.value.ofType(Quantity)) | (MessageDefinition.useContext.value.ofType(Range)) | (NamingSystem.useContext.value.ofType(Quantity)) | (NamingSystem.useContext.value.ofType(Range)) | (OperationDefinition.useContext.value.ofType(Quantity)) | (OperationDefinition.useContext.value.ofType(Range)) | (PlanDefinition.useContext.value.ofType(Quantity)) | (PlanDefinition.useContext.value.ofType(Range)) | (Questionnaire.useContext.value.ofType(Quantity)) | (Questionnaire.useContext.value.ofType(Range)) | (Requirements.useContext.value.ofType(Quantity)) | (Requirements.useContext.value.ofType(Range)) | (SearchParameter.useContext.value.ofType(Quantity)) | (SearchParameter.useContext.value.ofType(Range)) | (StructureDefinition.useContext.value.ofType(Quantity)) | (StructureDefinition.useContext.value.ofType(Range)) | (StructureMap.useContext.value.ofType(Quantity)) | (StructureMap.useContext.value.ofType(Range)) | (TerminologyCapabilities.useContext.value.ofType(Quantity)) | (TerminologyCapabilities.useContext.value.ofType(Range)) | (TestScript.useContext.value.ofType(Quantity)) | (TestScript.useContext.value.ofType(Range)) | (ValueSet.useContext.value.ofType(Quantity)) | (ValueSet.useContext.value.ofType(Range))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A quantity- or range-valued use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A quantity- or range-valued use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A quantity- or range-valued use context assigned to the charge item definition\r\n* [Citation](citation.html): A quantity- or range-valued use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A quantity- or range-valued use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A quantity- or range-valued use context assigned to the event definition\r\n* [Evidence](evidence.html): A quantity- or range-valued use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A quantity- or range-valued use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A quantity- or range-valued use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A quantity- or range-valued use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [Library](library.html): A quantity- or range-valued use context assigned to the library\r\n* [Measure](measure.html): A quantity- or range-valued use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A quantity- or range-valued use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A quantity- or range-valued use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A quantity- or range-valued use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A quantity- or range-valued use context assigned to the test script\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and quantity- or range-based value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and quantity- or range-based value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and quantity- or range-based value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and quantity- or range-based value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and quantity- or range-based value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and quantity- or range-based value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and quantity- or range-based value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and quantity- or range-based value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and quantity- or range-based value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and quantity- or range-based value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [Library](library.html): A use context type and quantity- or range-based value assigned to the library\r\n* [Measure](measure.html): A use context type and quantity- or range-based value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and quantity- or range-based value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and quantity- or range-based value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and quantity- or range-based value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and quantity- or range-based value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [Library](library.html): A use context type and value assigned to the library\r\n* [Measure](measure.html): A use context type and value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ActivityDefinition.useContext.code | ActorDefinition.useContext.code | CapabilityStatement.useContext.code | ChargeItemDefinition.useContext.code | Citation.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | ConditionDefinition.useContext.code | EventDefinition.useContext.code | Evidence.useContext.code | EvidenceReport.useContext.code | EvidenceVariable.useContext.code | ExampleScenario.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | Library.useContext.code | Measure.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | PlanDefinition.useContext.code | Questionnaire.useContext.code | Requirements.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | TestScript.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A type of use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A type of use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A type of use context assigned to the charge item definition\r\n* [Citation](citation.html): A type of use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A type of use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A type of use context assigned to the event definition\r\n* [Evidence](evidence.html): A type of use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A type of use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A type of use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A type of use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [Library](library.html): A type of use context assigned to the library\r\n* [Measure](measure.html): A type of use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A type of use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A type of use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A type of use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A type of use context assigned to the test script\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ActivityDefinition.useContext.value.ofType(CodeableConcept)) | (ActorDefinition.useContext.value.ofType(CodeableConcept)) | (CapabilityStatement.useContext.value.ofType(CodeableConcept)) | (ChargeItemDefinition.useContext.value.ofType(CodeableConcept)) | (Citation.useContext.value.ofType(CodeableConcept)) | (CodeSystem.useContext.value.ofType(CodeableConcept)) | (CompartmentDefinition.useContext.value.ofType(CodeableConcept)) | (ConceptMap.useContext.value.ofType(CodeableConcept)) | (ConditionDefinition.useContext.value.ofType(CodeableConcept)) | (EventDefinition.useContext.value.ofType(CodeableConcept)) | (Evidence.useContext.value.ofType(CodeableConcept)) | (EvidenceReport.useContext.value.ofType(CodeableConcept)) | (EvidenceVariable.useContext.value.ofType(CodeableConcept)) | (ExampleScenario.useContext.value.ofType(CodeableConcept)) | (GraphDefinition.useContext.value.ofType(CodeableConcept)) | (ImplementationGuide.useContext.value.ofType(CodeableConcept)) | (Library.useContext.value.ofType(CodeableConcept)) | (Measure.useContext.value.ofType(CodeableConcept)) | (MessageDefinition.useContext.value.ofType(CodeableConcept)) | (NamingSystem.useContext.value.ofType(CodeableConcept)) | (OperationDefinition.useContext.value.ofType(CodeableConcept)) | (PlanDefinition.useContext.value.ofType(CodeableConcept)) | (Questionnaire.useContext.value.ofType(CodeableConcept)) | (Requirements.useContext.value.ofType(CodeableConcept)) | (SearchParameter.useContext.value.ofType(CodeableConcept)) | (StructureDefinition.useContext.value.ofType(CodeableConcept)) | (StructureMap.useContext.value.ofType(CodeableConcept)) | (TerminologyCapabilities.useContext.value.ofType(CodeableConcept)) | (TestScript.useContext.value.ofType(CodeableConcept)) | (ValueSet.useContext.value.ofType(CodeableConcept))", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context assigned to the charge item definition\r\n* [Citation](citation.html): A use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context assigned to the event definition\r\n* [Evidence](evidence.html): A use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [Library](library.html): A use context assigned to the library\r\n* [Measure](measure.html): A use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context assigned to the test script\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ActivityDefinition.date | ActorDefinition.date | CapabilityStatement.date | ChargeItemDefinition.date | Citation.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | ConditionDefinition.date | EventDefinition.date | Evidence.date | EvidenceVariable.date | ExampleScenario.date | GraphDefinition.date | ImplementationGuide.date | Library.date | Measure.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | PlanDefinition.date | Questionnaire.date | Requirements.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | SubscriptionTopic.date | TerminologyCapabilities.date | TestScript.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The activity definition publication date\r\n* [ActorDefinition](actordefinition.html): The Actor Definition publication date\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The charge item definition publication date\r\n* [Citation](citation.html): The citation publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [ConditionDefinition](conditiondefinition.html): The condition definition publication date\r\n* [EventDefinition](eventdefinition.html): The event definition publication date\r\n* [Evidence](evidence.html): The evidence publication date\r\n* [EvidenceVariable](evidencevariable.html): The evidence variable publication date\r\n* [ExampleScenario](examplescenario.html): The example scenario publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [Library](library.html): The library publication date\r\n* [Measure](measure.html): The measure publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [PlanDefinition](plandefinition.html): The plan definition publication date\r\n* [Questionnaire](questionnaire.html): The questionnaire publication date\r\n* [Requirements](requirements.html): The requirements publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [SubscriptionTopic](subscriptiontopic.html): Date status first applied\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [TestScript](testscript.html): The test script publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="ActivityDefinition.description | ActorDefinition.description | CapabilityStatement.description | ChargeItemDefinition.description | Citation.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | ConditionDefinition.description | EventDefinition.description | Evidence.description | EvidenceVariable.description | GraphDefinition.description | ImplementationGuide.description | Library.description | Measure.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | PlanDefinition.description | Questionnaire.description | Requirements.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | TestScript.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The description of the activity definition\r\n* [ActorDefinition](actordefinition.html): The description of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The description of the charge item definition\r\n* [Citation](citation.html): The description of the citation\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The description of the condition definition\r\n* [EventDefinition](eventdefinition.html): The description of the event definition\r\n* [Evidence](evidence.html): The description of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The description of the evidence variable\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [Library](library.html): The description of the library\r\n* [Measure](measure.html): The description of the measure\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [PlanDefinition](plandefinition.html): The description of the plan definition\r\n* [Questionnaire](questionnaire.html): The description of the questionnaire\r\n* [Requirements](requirements.html): The description of the requirements\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [TestScript](testscript.html): The description of the test script\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier | ActorDefinition.identifier | CapabilityStatement.identifier | ChargeItemDefinition.identifier | Citation.identifier | CodeSystem.identifier | ConceptMap.identifier | ConditionDefinition.identifier | EventDefinition.identifier | Evidence.identifier | EvidenceReport.identifier | EvidenceVariable.identifier | ExampleScenario.identifier | GraphDefinition.identifier | ImplementationGuide.identifier | Library.identifier | Measure.identifier | MedicationKnowledge.identifier | MessageDefinition.identifier | NamingSystem.identifier | ObservationDefinition.identifier | OperationDefinition.identifier | PlanDefinition.identifier | Questionnaire.identifier | Requirements.identifier | SearchParameter.identifier | SpecimenDefinition.identifier | StructureDefinition.identifier | StructureMap.identifier | SubscriptionTopic.identifier | TerminologyCapabilities.identifier | TestPlan.identifier | TestScript.identifier | ValueSet.identifier", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): External identifier for the activity definition\r\n* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition\r\n* [Citation](citation.html): External identifier for the citation\r\n* [CodeSystem](codesystem.html): External identifier for the code system\r\n* [ConceptMap](conceptmap.html): External identifier for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition\r\n* [EventDefinition](eventdefinition.html): External identifier for the event definition\r\n* [Evidence](evidence.html): External identifier for the evidence\r\n* [EvidenceReport](evidencereport.html): External identifier for the evidence report\r\n* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable\r\n* [ExampleScenario](examplescenario.html): External identifier for the example scenario\r\n* [GraphDefinition](graphdefinition.html): External identifier for the graph definition\r\n* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide\r\n* [Library](library.html): External identifier for the library\r\n* [Measure](measure.html): External identifier for the measure\r\n* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication\r\n* [MessageDefinition](messagedefinition.html): External identifier for the message definition\r\n* [NamingSystem](namingsystem.html): External identifier for the naming system\r\n* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition\r\n* [OperationDefinition](operationdefinition.html): External identifier for the search parameter\r\n* [PlanDefinition](plandefinition.html): External identifier for the plan definition\r\n* [Questionnaire](questionnaire.html): External identifier for the questionnaire\r\n* [Requirements](requirements.html): External identifier for the requirements\r\n* [SearchParameter](searchparameter.html): External identifier for the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): External identifier for the structure definition\r\n* [StructureMap](structuremap.html): External identifier for the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities\r\n* [TestPlan](testplan.html): An identifier for the test plan\r\n* [TestScript](testscript.html): External identifier for the test script\r\n* [ValueSet](valueset.html): External identifier for the value set\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="jurisdiction", path="ActivityDefinition.jurisdiction | ActorDefinition.jurisdiction | CapabilityStatement.jurisdiction | ChargeItemDefinition.jurisdiction | Citation.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | ConditionDefinition.jurisdiction | EventDefinition.jurisdiction | ExampleScenario.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | Library.jurisdiction | Measure.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | PlanDefinition.jurisdiction | Questionnaire.jurisdiction | Requirements.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | TestScript.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Intended jurisdiction for the activity definition\r\n* [ActorDefinition](actordefinition.html): Intended jurisdiction for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Intended jurisdiction for the charge item definition\r\n* [Citation](citation.html): Intended jurisdiction for the citation\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Intended jurisdiction for the condition definition\r\n* [EventDefinition](eventdefinition.html): Intended jurisdiction for the event definition\r\n* [ExampleScenario](examplescenario.html): Intended jurisdiction for the example scenario\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [Library](library.html): Intended jurisdiction for the library\r\n* [Measure](measure.html): Intended jurisdiction for the measure\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [PlanDefinition](plandefinition.html): Intended jurisdiction for the plan definition\r\n* [Questionnaire](questionnaire.html): Intended jurisdiction for the questionnaire\r\n* [Requirements](requirements.html): Intended jurisdiction for the requirements\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [TestScript](testscript.html): Intended jurisdiction for the test script\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ActivityDefinition.name | CapabilityStatement.name | Citation.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | ConditionDefinition.name | EventDefinition.name | EvidenceVariable.name | ExampleScenario.name | GraphDefinition.name | ImplementationGuide.name | Library.name | Measure.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | PlanDefinition.name | Questionnaire.name | Requirements.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | TestScript.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Computationally friendly name of the activity definition\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [Citation](citation.html): Computationally friendly name of the citation\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Computationally friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): Computationally friendly name of the event definition\r\n* [EvidenceVariable](evidencevariable.html): Computationally friendly name of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Computationally friendly name of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [Library](library.html): Computationally friendly name of the library\r\n* [Measure](measure.html): Computationally friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): Computationally friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): Computationally friendly name of the questionnaire\r\n* [Requirements](requirements.html): Computationally friendly name of the requirements\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): Computationally friendly name of the test script\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ActivityDefinition.publisher | ActorDefinition.publisher | CapabilityStatement.publisher | ChargeItemDefinition.publisher | Citation.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | ConditionDefinition.publisher | EventDefinition.publisher | Evidence.publisher | EvidenceReport.publisher | EvidenceVariable.publisher | ExampleScenario.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | Library.publisher | Measure.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | PlanDefinition.publisher | Questionnaire.publisher | Requirements.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | TestScript.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Name of the publisher of the activity definition\r\n* [ActorDefinition](actordefinition.html): Name of the publisher of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Name of the publisher of the charge item definition\r\n* [Citation](citation.html): Name of the publisher of the citation\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Name of the publisher of the condition definition\r\n* [EventDefinition](eventdefinition.html): Name of the publisher of the event definition\r\n* [Evidence](evidence.html): Name of the publisher of the evidence\r\n* [EvidenceReport](evidencereport.html): Name of the publisher of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): Name of the publisher of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Name of the publisher of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [Library](library.html): Name of the publisher of the library\r\n* [Measure](measure.html): Name of the publisher of the measure\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [PlanDefinition](plandefinition.html): Name of the publisher of the plan definition\r\n* [Questionnaire](questionnaire.html): Name of the publisher of the questionnaire\r\n* [Requirements](requirements.html): Name of the publisher of the requirements\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [TestScript](testscript.html): Name of the publisher of the test script\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestPlan.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestPlan](testplan.html): The current status of the test plan\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="ActivityDefinition.title | ActorDefinition.title | CapabilityStatement.title | ChargeItemDefinition.title | Citation.title | CodeSystem.title | ConceptMap.title | ConditionDefinition.title | EventDefinition.title | Evidence.title | EvidenceVariable.title | ImplementationGuide.title | Library.title | Measure.title | MessageDefinition.title | ObservationDefinition.title | OperationDefinition.title | PlanDefinition.title | Questionnaire.title | Requirements.title | SpecimenDefinition.title | StructureDefinition.title | StructureMap.title | SubscriptionTopic.title | TerminologyCapabilities.title | TestScript.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The human-friendly name of the activity definition\r\n* [ActorDefinition](actordefinition.html): The human-friendly name of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The human-friendly name of the charge item definition\r\n* [Citation](citation.html): The human-friendly name of the citation\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The human-friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): The human-friendly name of the event definition\r\n* [Evidence](evidence.html): The human-friendly name of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The human-friendly name of the evidence variable\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [Library](library.html): The human-friendly name of the library\r\n* [Measure](measure.html): The human-friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [ObservationDefinition](observationdefinition.html): Human-friendly name of the ObservationDefinition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): The human-friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): The human-friendly name of the questionnaire\r\n* [Requirements](requirements.html): The human-friendly name of the requirements\r\n* [SpecimenDefinition](specimendefinition.html): Human-friendly name of the SpecimenDefinition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Name for this SubscriptionTopic (Human friendly)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): The human-friendly name of the test script\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestPlan.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestPlan](testplan.html): The uri that identifies the test plan\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ActivityDefinition.version | ActorDefinition.version | CapabilityStatement.version | ChargeItemDefinition.version | Citation.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | ConditionDefinition.version | EventDefinition.version | Evidence.version | EvidenceVariable.version | ExampleScenario.version | GraphDefinition.version | ImplementationGuide.version | Library.version | Measure.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | PlanDefinition.version | Questionnaire.version | Requirements.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | SubscriptionTopic.version | TerminologyCapabilities.version | TestScript.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The business version of the activity definition\r\n* [ActorDefinition](actordefinition.html): The business version of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The business version of the charge item definition\r\n* [Citation](citation.html): The business version of the citation\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The business version of the condition definition\r\n* [EventDefinition](eventdefinition.html): The business version of the event definition\r\n* [Evidence](evidence.html): The business version of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The business version of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The business version of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [Library](library.html): The business version of the library\r\n* [Measure](measure.html): The business version of the measure\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [PlanDefinition](plandefinition.html): The business version of the plan definition\r\n* [Questionnaire](questionnaire.html): The business version of the questionnaire\r\n* [Requirements](requirements.html): The business version of the requirements\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business version of the SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [TestScript](testscript.html): The business version of the test script\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public ConditionDefinition() {
    }

    public ConditionDefinition(Enumerations.PublicationStatus status, CodeableConcept code) {
        this.setStatus(status);
        this.setCode(code);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ConditionDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ConditionDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    @Override
    public ConditionDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    @Override
    public ConditionDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ConditionDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ConditionDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public DataType getVersionAlgorithm() {
        return this.versionAlgorithm;
    }

    @Override
    public StringType getVersionAlgorithmStringType() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new StringType();
        }
        if (!(this.versionAlgorithm instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (StringType)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return this.versionAlgorithm instanceof StringType;
    }

    @Override
    public Coding getVersionAlgorithmCoding() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new Coding();
        }
        if (!(this.versionAlgorithm instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (Coding)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return this.versionAlgorithm instanceof Coding;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return this.versionAlgorithm != null && !this.versionAlgorithm.isEmpty();
    }

    @Override
    public ConditionDefinition setVersionAlgorithm(DataType value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Coding)) {
            throw new FHIRException("Not the right type for ConditionDefinition.versionAlgorithm[x]: " + value.fhirType());
        }
        this.versionAlgorithm = value;
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ConditionDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ConditionDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ConditionDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ConditionDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getSubtitleElement() {
        if (this.subtitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.subtitle");
            }
            if (Configuration.doAutoCreate()) {
                this.subtitle = new StringType();
            }
        }
        return this.subtitle;
    }

    public boolean hasSubtitleElement() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public ConditionDefinition setSubtitleElement(StringType value) {
        this.subtitle = value;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle == null ? null : (String)this.subtitle.getValue();
    }

    public ConditionDefinition setSubtitle(String value) {
        if (Utilities.noString((String)value)) {
            this.subtitle = null;
        } else {
            if (this.subtitle == null) {
                this.subtitle = new StringType();
            }
            this.subtitle.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ConditionDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ConditionDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ConditionDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ConditionDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ConditionDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ConditionDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ConditionDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ConditionDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public ConditionDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ConditionDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ConditionDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ConditionDefinition setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public ConditionDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ConditionDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public ConditionDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ConditionDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ConditionDefinition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public CodeableConcept getSeverity() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new CodeableConcept();
            }
        }
        return this.severity;
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public ConditionDefinition setSeverity(CodeableConcept value) {
        this.severity = value;
        return this;
    }

    public CodeableConcept getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableConcept();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public ConditionDefinition setBodySite(CodeableConcept value) {
        this.bodySite = value;
        return this;
    }

    public CodeableConcept getStage() {
        if (this.stage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.stage");
            }
            if (Configuration.doAutoCreate()) {
                this.stage = new CodeableConcept();
            }
        }
        return this.stage;
    }

    public boolean hasStage() {
        return this.stage != null && !this.stage.isEmpty();
    }

    public ConditionDefinition setStage(CodeableConcept value) {
        this.stage = value;
        return this;
    }

    public BooleanType getHasSeverityElement() {
        if (this.hasSeverity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.hasSeverity");
            }
            if (Configuration.doAutoCreate()) {
                this.hasSeverity = new BooleanType();
            }
        }
        return this.hasSeverity;
    }

    public boolean hasHasSeverityElement() {
        return this.hasSeverity != null && !this.hasSeverity.isEmpty();
    }

    public boolean hasHasSeverity() {
        return this.hasSeverity != null && !this.hasSeverity.isEmpty();
    }

    public ConditionDefinition setHasSeverityElement(BooleanType value) {
        this.hasSeverity = value;
        return this;
    }

    public boolean getHasSeverity() {
        return this.hasSeverity == null || this.hasSeverity.isEmpty() ? false : (Boolean)this.hasSeverity.getValue();
    }

    public ConditionDefinition setHasSeverity(boolean value) {
        if (this.hasSeverity == null) {
            this.hasSeverity = new BooleanType();
        }
        this.hasSeverity.setValue((Object)value);
        return this;
    }

    public BooleanType getHasBodySiteElement() {
        if (this.hasBodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.hasBodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.hasBodySite = new BooleanType();
            }
        }
        return this.hasBodySite;
    }

    public boolean hasHasBodySiteElement() {
        return this.hasBodySite != null && !this.hasBodySite.isEmpty();
    }

    public boolean hasHasBodySite() {
        return this.hasBodySite != null && !this.hasBodySite.isEmpty();
    }

    public ConditionDefinition setHasBodySiteElement(BooleanType value) {
        this.hasBodySite = value;
        return this;
    }

    public boolean getHasBodySite() {
        return this.hasBodySite == null || this.hasBodySite.isEmpty() ? false : (Boolean)this.hasBodySite.getValue();
    }

    public ConditionDefinition setHasBodySite(boolean value) {
        if (this.hasBodySite == null) {
            this.hasBodySite = new BooleanType();
        }
        this.hasBodySite.setValue((Object)value);
        return this;
    }

    public BooleanType getHasStageElement() {
        if (this.hasStage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConditionDefinition.hasStage");
            }
            if (Configuration.doAutoCreate()) {
                this.hasStage = new BooleanType();
            }
        }
        return this.hasStage;
    }

    public boolean hasHasStageElement() {
        return this.hasStage != null && !this.hasStage.isEmpty();
    }

    public boolean hasHasStage() {
        return this.hasStage != null && !this.hasStage.isEmpty();
    }

    public ConditionDefinition setHasStageElement(BooleanType value) {
        this.hasStage = value;
        return this;
    }

    public boolean getHasStage() {
        return this.hasStage == null || this.hasStage.isEmpty() ? false : (Boolean)this.hasStage.getValue();
    }

    public ConditionDefinition setHasStage(boolean value) {
        if (this.hasStage == null) {
            this.hasStage = new BooleanType();
        }
        this.hasStage.setValue((Object)value);
        return this;
    }

    public List<UriType> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<UriType>();
        }
        return this.definition;
    }

    public ConditionDefinition setDefinition(List<UriType> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (UriType item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addDefinitionElement() {
        UriType t = new UriType();
        if (this.definition == null) {
            this.definition = new ArrayList<UriType>();
        }
        this.definition.add(t);
        return t;
    }

    public ConditionDefinition addDefinition(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.definition == null) {
            this.definition = new ArrayList<UriType>();
        }
        this.definition.add(t);
        return this;
    }

    public boolean hasDefinition(String value) {
        if (this.definition == null) {
            return false;
        }
        for (UriType v : this.definition) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<ConditionDefinitionObservationComponent> getObservation() {
        if (this.observation == null) {
            this.observation = new ArrayList<ConditionDefinitionObservationComponent>();
        }
        return this.observation;
    }

    public ConditionDefinition setObservation(List<ConditionDefinitionObservationComponent> theObservation) {
        this.observation = theObservation;
        return this;
    }

    public boolean hasObservation() {
        if (this.observation == null) {
            return false;
        }
        for (ConditionDefinitionObservationComponent item : this.observation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionObservationComponent addObservation() {
        ConditionDefinitionObservationComponent t = new ConditionDefinitionObservationComponent();
        if (this.observation == null) {
            this.observation = new ArrayList<ConditionDefinitionObservationComponent>();
        }
        this.observation.add(t);
        return t;
    }

    public ConditionDefinition addObservation(ConditionDefinitionObservationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.observation == null) {
            this.observation = new ArrayList<ConditionDefinitionObservationComponent>();
        }
        this.observation.add(t);
        return this;
    }

    public ConditionDefinitionObservationComponent getObservationFirstRep() {
        if (this.getObservation().isEmpty()) {
            this.addObservation();
        }
        return this.getObservation().get(0);
    }

    public List<ConditionDefinitionMedicationComponent> getMedication() {
        if (this.medication == null) {
            this.medication = new ArrayList<ConditionDefinitionMedicationComponent>();
        }
        return this.medication;
    }

    public ConditionDefinition setMedication(List<ConditionDefinitionMedicationComponent> theMedication) {
        this.medication = theMedication;
        return this;
    }

    public boolean hasMedication() {
        if (this.medication == null) {
            return false;
        }
        for (ConditionDefinitionMedicationComponent item : this.medication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionMedicationComponent addMedication() {
        ConditionDefinitionMedicationComponent t = new ConditionDefinitionMedicationComponent();
        if (this.medication == null) {
            this.medication = new ArrayList<ConditionDefinitionMedicationComponent>();
        }
        this.medication.add(t);
        return t;
    }

    public ConditionDefinition addMedication(ConditionDefinitionMedicationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.medication == null) {
            this.medication = new ArrayList<ConditionDefinitionMedicationComponent>();
        }
        this.medication.add(t);
        return this;
    }

    public ConditionDefinitionMedicationComponent getMedicationFirstRep() {
        if (this.getMedication().isEmpty()) {
            this.addMedication();
        }
        return this.getMedication().get(0);
    }

    public List<ConditionDefinitionPreconditionComponent> getPrecondition() {
        if (this.precondition == null) {
            this.precondition = new ArrayList<ConditionDefinitionPreconditionComponent>();
        }
        return this.precondition;
    }

    public ConditionDefinition setPrecondition(List<ConditionDefinitionPreconditionComponent> thePrecondition) {
        this.precondition = thePrecondition;
        return this;
    }

    public boolean hasPrecondition() {
        if (this.precondition == null) {
            return false;
        }
        for (ConditionDefinitionPreconditionComponent item : this.precondition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionPreconditionComponent addPrecondition() {
        ConditionDefinitionPreconditionComponent t = new ConditionDefinitionPreconditionComponent();
        if (this.precondition == null) {
            this.precondition = new ArrayList<ConditionDefinitionPreconditionComponent>();
        }
        this.precondition.add(t);
        return t;
    }

    public ConditionDefinition addPrecondition(ConditionDefinitionPreconditionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.precondition == null) {
            this.precondition = new ArrayList<ConditionDefinitionPreconditionComponent>();
        }
        this.precondition.add(t);
        return this;
    }

    public ConditionDefinitionPreconditionComponent getPreconditionFirstRep() {
        if (this.getPrecondition().isEmpty()) {
            this.addPrecondition();
        }
        return this.getPrecondition().get(0);
    }

    public List<Reference> getTeam() {
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        return this.team;
    }

    public ConditionDefinition setTeam(List<Reference> theTeam) {
        this.team = theTeam;
        return this;
    }

    public boolean hasTeam() {
        if (this.team == null) {
            return false;
        }
        for (Reference item : this.team) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTeam() {
        Reference t = new Reference();
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        this.team.add(t);
        return t;
    }

    public ConditionDefinition addTeam(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.team == null) {
            this.team = new ArrayList<Reference>();
        }
        this.team.add(t);
        return this;
    }

    public Reference getTeamFirstRep() {
        if (this.getTeam().isEmpty()) {
            this.addTeam();
        }
        return this.getTeam().get(0);
    }

    public List<ConditionDefinitionQuestionnaireComponent> getQuestionnaire() {
        if (this.questionnaire == null) {
            this.questionnaire = new ArrayList<ConditionDefinitionQuestionnaireComponent>();
        }
        return this.questionnaire;
    }

    public ConditionDefinition setQuestionnaire(List<ConditionDefinitionQuestionnaireComponent> theQuestionnaire) {
        this.questionnaire = theQuestionnaire;
        return this;
    }

    public boolean hasQuestionnaire() {
        if (this.questionnaire == null) {
            return false;
        }
        for (ConditionDefinitionQuestionnaireComponent item : this.questionnaire) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionQuestionnaireComponent addQuestionnaire() {
        ConditionDefinitionQuestionnaireComponent t = new ConditionDefinitionQuestionnaireComponent();
        if (this.questionnaire == null) {
            this.questionnaire = new ArrayList<ConditionDefinitionQuestionnaireComponent>();
        }
        this.questionnaire.add(t);
        return t;
    }

    public ConditionDefinition addQuestionnaire(ConditionDefinitionQuestionnaireComponent t) {
        if (t == null) {
            return this;
        }
        if (this.questionnaire == null) {
            this.questionnaire = new ArrayList<ConditionDefinitionQuestionnaireComponent>();
        }
        this.questionnaire.add(t);
        return this;
    }

    public ConditionDefinitionQuestionnaireComponent getQuestionnaireFirstRep() {
        if (this.getQuestionnaire().isEmpty()) {
            this.addQuestionnaire();
        }
        return this.getQuestionnaire().get(0);
    }

    public List<ConditionDefinitionPlanComponent> getPlan() {
        if (this.plan == null) {
            this.plan = new ArrayList<ConditionDefinitionPlanComponent>();
        }
        return this.plan;
    }

    public ConditionDefinition setPlan(List<ConditionDefinitionPlanComponent> thePlan) {
        this.plan = thePlan;
        return this;
    }

    public boolean hasPlan() {
        if (this.plan == null) {
            return false;
        }
        for (ConditionDefinitionPlanComponent item : this.plan) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConditionDefinitionPlanComponent addPlan() {
        ConditionDefinitionPlanComponent t = new ConditionDefinitionPlanComponent();
        if (this.plan == null) {
            this.plan = new ArrayList<ConditionDefinitionPlanComponent>();
        }
        this.plan.add(t);
        return t;
    }

    public ConditionDefinition addPlan(ConditionDefinitionPlanComponent t) {
        if (t == null) {
            return this;
        }
        if (this.plan == null) {
            this.plan = new ArrayList<ConditionDefinitionPlanComponent>();
        }
        this.plan.add(t);
        return this;
    }

    public ConditionDefinitionPlanComponent getPlanFirstRep() {
        if (this.getPlan().isEmpty()) {
            this.addPlan();
        }
        return this.getPlan().get(0);
    }

    @Override
    public int getPurposeMax() {
        return 0;
    }

    @Override
    public MarkdownType getPurposeElement() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"purpose\"");
    }

    @Override
    public boolean hasPurposeElement() {
        return false;
    }

    @Override
    public boolean hasPurpose() {
        return false;
    }

    @Override
    public ConditionDefinition setPurposeElement(MarkdownType value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"purpose\"");
    }

    @Override
    public String getPurpose() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"purpose\"");
    }

    @Override
    public ConditionDefinition setPurpose(String value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"purpose\"");
    }

    @Override
    public int getCopyrightMax() {
        return 0;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public boolean hasCopyrightElement() {
        return false;
    }

    @Override
    public boolean hasCopyright() {
        return false;
    }

    @Override
    public ConditionDefinition setCopyrightElement(MarkdownType value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public String getCopyright() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public ConditionDefinition setCopyright(String value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public int getCopyrightLabelMax() {
        return 0;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return false;
    }

    @Override
    public boolean hasCopyrightLabel() {
        return false;
    }

    @Override
    public ConditionDefinition setCopyrightLabelElement(StringType value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public String getCopyrightLabel() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public ConditionDefinition setCopyrightLabel(String value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public int getApprovalDateMax() {
        return 0;
    }

    @Override
    public DateType getApprovalDateElement() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"approvalDate\"");
    }

    @Override
    public boolean hasApprovalDateElement() {
        return false;
    }

    @Override
    public boolean hasApprovalDate() {
        return false;
    }

    @Override
    public ConditionDefinition setApprovalDateElement(DateType value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"approvalDate\"");
    }

    @Override
    public Date getApprovalDate() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"approvalDate\"");
    }

    @Override
    public ConditionDefinition setApprovalDate(Date value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"approvalDate\"");
    }

    @Override
    public int getLastReviewDateMax() {
        return 0;
    }

    @Override
    public DateType getLastReviewDateElement() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public boolean hasLastReviewDateElement() {
        return false;
    }

    @Override
    public boolean hasLastReviewDate() {
        return false;
    }

    @Override
    public ConditionDefinition setLastReviewDateElement(DateType value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public Date getLastReviewDate() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public ConditionDefinition setLastReviewDate(Date value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"lastReviewDate\"");
    }

    @Override
    public int getEffectivePeriodMax() {
        return 0;
    }

    @Override
    public Period getEffectivePeriod() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public boolean hasEffectivePeriod() {
        return false;
    }

    @Override
    public ConditionDefinition setEffectivePeriod(Period value) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"effectivePeriod\"");
    }

    @Override
    public int getTopicMax() {
        return 0;
    }

    @Override
    public List<CodeableConcept> getTopic() {
        return new ArrayList<CodeableConcept>();
    }

    @Override
    public ConditionDefinition setTopic(List<CodeableConcept> theTopic) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"topic\"");
    }

    @Override
    public boolean hasTopic() {
        return false;
    }

    @Override
    public CodeableConcept addTopic() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"topic\"");
    }

    @Override
    public ConditionDefinition addTopic(CodeableConcept t) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"topic\"");
    }

    @Override
    public CodeableConcept getTopicFirstRep() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"topic\"");
    }

    @Override
    public int getAuthorMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getAuthor() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public ConditionDefinition setAuthor(List<ContactDetail> theAuthor) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"author\"");
    }

    @Override
    public boolean hasAuthor() {
        return false;
    }

    @Override
    public ContactDetail addAuthor() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"author\"");
    }

    @Override
    public ConditionDefinition addAuthor(ContactDetail t) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"author\"");
    }

    @Override
    public ContactDetail getAuthorFirstRep() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"author\"");
    }

    @Override
    public int getEditorMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getEditor() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public ConditionDefinition setEditor(List<ContactDetail> theEditor) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"editor\"");
    }

    @Override
    public boolean hasEditor() {
        return false;
    }

    @Override
    public ContactDetail addEditor() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"editor\"");
    }

    @Override
    public ConditionDefinition addEditor(ContactDetail t) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"editor\"");
    }

    @Override
    public ContactDetail getEditorFirstRep() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"editor\"");
    }

    @Override
    public int getReviewerMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getReviewer() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public ConditionDefinition setReviewer(List<ContactDetail> theReviewer) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"reviewer\"");
    }

    @Override
    public boolean hasReviewer() {
        return false;
    }

    @Override
    public ContactDetail addReviewer() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"reviewer\"");
    }

    @Override
    public ConditionDefinition addReviewer(ContactDetail t) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"reviewer\"");
    }

    @Override
    public ContactDetail getReviewerFirstRep() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"reviewer\"");
    }

    @Override
    public int getEndorserMax() {
        return 0;
    }

    @Override
    public List<ContactDetail> getEndorser() {
        return new ArrayList<ContactDetail>();
    }

    @Override
    public ConditionDefinition setEndorser(List<ContactDetail> theEndorser) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"endorser\"");
    }

    @Override
    public boolean hasEndorser() {
        return false;
    }

    @Override
    public ContactDetail addEndorser() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"endorser\"");
    }

    @Override
    public ConditionDefinition addEndorser(ContactDetail t) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"endorser\"");
    }

    @Override
    public ContactDetail getEndorserFirstRep() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"endorser\"");
    }

    @Override
    public int getRelatedArtifactMax() {
        return 0;
    }

    @Override
    public List<RelatedArtifact> getRelatedArtifact() {
        return new ArrayList<RelatedArtifact>();
    }

    @Override
    public ConditionDefinition setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    public boolean hasRelatedArtifact() {
        return false;
    }

    @Override
    public RelatedArtifact addRelatedArtifact() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    public ConditionDefinition addRelatedArtifact(RelatedArtifact t) {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    public RelatedArtifact getRelatedArtifactFirstRep() {
        throw new Error("The resource type \"ConditionDefinition\" does not implement the property \"relatedArtifact\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this condition definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this condition definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the condition definition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this condition definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the condition definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the condition definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the condition definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the condition definition.", 0, 1, this.title));
        children.add(new Property("subtitle", "string", "An explanatory or alternate title for the event definition giving additional information about its content.", 0, 1, this.subtitle));
        children.add(new Property(SP_STATUS, "code", "The status of this condition definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this condition definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the condition definition was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the condition definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the condition definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the condition definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate condition definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the condition definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("code", "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, 1, this.code));
        children.add(new Property("severity", "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, 1, this.severity));
        children.add(new Property("bodySite", "CodeableConcept", "The anatomical location where this condition manifests itself.", 0, 1, this.bodySite));
        children.add(new Property("stage", "CodeableConcept", "Clinical stage or grade of a condition. May include formal severity assessments.", 0, 1, this.stage));
        children.add(new Property("hasSeverity", "boolean", "Whether Severity is appropriate to collect for this condition.", 0, 1, this.hasSeverity));
        children.add(new Property("hasBodySite", "boolean", "Whether bodySite is appropriate to collect for this condition.", 0, 1, this.hasBodySite));
        children.add(new Property("hasStage", "boolean", "Whether stage is appropriate to collect for this condition.", 0, 1, this.hasStage));
        children.add(new Property("definition", "uri", "Formal definitions of the condition. These may be references to ontologies, published clinical protocols or research papers.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("observation", "", "Observations particularly relevant to this condition.", 0, Integer.MAX_VALUE, this.observation));
        children.add(new Property("medication", "", "Medications particularly relevant for this condition.", 0, Integer.MAX_VALUE, this.medication));
        children.add(new Property("precondition", "", "An observation that suggests that this condition applies.", 0, Integer.MAX_VALUE, this.precondition));
        children.add(new Property("team", "Reference(CareTeam)", "Appropriate team for this condition.", 0, Integer.MAX_VALUE, this.team));
        children.add(new Property("questionnaire", "", "Questionnaire for this condition.", 0, Integer.MAX_VALUE, this.questionnaire));
        children.add(new Property("plan", "", "Plan that is appropriate.", 0, Integer.MAX_VALUE, this.plan));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this condition definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this condition definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the condition definition is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this condition definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the condition definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the condition definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -115699031: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1508158071: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1836908904: {
                return new Property("versionAlgorithm[x]", "string", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1373807809: {
                return new Property("versionAlgorithm[x]", "Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the condition definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the condition definition.", 0, 1, this.title);
            }
            case -2060497896: {
                return new Property("subtitle", "string", "An explanatory or alternate title for the event definition giving additional information about its content.", 0, 1, this.subtitle);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this condition definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this condition definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the condition definition was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the condition definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the condition definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the condition definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate condition definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the condition definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Identification of the condition, problem or diagnosis.", 0, 1, this.code);
            }
            case 1478300413: {
                return new Property("severity", "CodeableConcept", "A subjective assessment of the severity of the condition as evaluated by the clinician.", 0, 1, this.severity);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "The anatomical location where this condition manifests itself.", 0, 1, this.bodySite);
            }
            case 109757182: {
                return new Property("stage", "CodeableConcept", "Clinical stage or grade of a condition. May include formal severity assessments.", 0, 1, this.stage);
            }
            case 57790391: {
                return new Property("hasSeverity", "boolean", "Whether Severity is appropriate to collect for this condition.", 0, 1, this.hasSeverity);
            }
            case 282110147: {
                return new Property("hasBodySite", "boolean", "Whether bodySite is appropriate to collect for this condition.", 0, 1, this.hasBodySite);
            }
            case 129749124: {
                return new Property("hasStage", "boolean", "Whether stage is appropriate to collect for this condition.", 0, 1, this.hasStage);
            }
            case -1014418093: {
                return new Property("definition", "uri", "Formal definitions of the condition. These may be references to ontologies, published clinical protocols or research papers.", 0, Integer.MAX_VALUE, this.definition);
            }
            case 122345516: {
                return new Property("observation", "", "Observations particularly relevant to this condition.", 0, Integer.MAX_VALUE, this.observation);
            }
            case 1998965455: {
                return new Property("medication", "", "Medications particularly relevant for this condition.", 0, Integer.MAX_VALUE, this.medication);
            }
            case -650968616: {
                return new Property("precondition", "", "An observation that suggests that this condition applies.", 0, Integer.MAX_VALUE, this.precondition);
            }
            case 3555933: {
                return new Property("team", "Reference(CareTeam)", "Appropriate team for this condition.", 0, Integer.MAX_VALUE, this.team);
            }
            case -1017049693: {
                return new Property("questionnaire", "", "Questionnaire for this condition.", 0, Integer.MAX_VALUE, this.questionnaire);
            }
            case 3443497: {
                return new Property("plan", "", "Plan that is appropriate.", 0, Integer.MAX_VALUE, this.plan);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 1508158071: {
                Base[] baseArray;
                if (this.versionAlgorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.versionAlgorithm;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -2060497896: {
                Base[] baseArray;
                if (this.subtitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subtitle;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.code;
                }
                return baseArray;
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.severity;
                }
                return baseArray;
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.bodySite;
                }
                return baseArray;
            }
            case 109757182: {
                Base[] baseArray;
                if (this.stage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.stage;
                }
                return baseArray;
            }
            case 57790391: {
                Base[] baseArray;
                if (this.hasSeverity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.hasSeverity;
                }
                return baseArray;
            }
            case 282110147: {
                Base[] baseArray;
                if (this.hasBodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.hasBodySite;
                }
                return baseArray;
            }
            case 129749124: {
                Base[] baseArray;
                if (this.hasStage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.hasStage;
                }
                return baseArray;
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case 122345516: {
                return this.observation == null ? new Base[]{} : this.observation.toArray(new Base[this.observation.size()]);
            }
            case 1998965455: {
                return this.medication == null ? new Base[]{} : this.medication.toArray(new Base[this.medication.size()]);
            }
            case -650968616: {
                return this.precondition == null ? new Base[]{} : this.precondition.toArray(new Base[this.precondition.size()]);
            }
            case 3555933: {
                return this.team == null ? new Base[]{} : this.team.toArray(new Base[this.team.size()]);
            }
            case -1017049693: {
                return this.questionnaire == null ? new Base[]{} : this.questionnaire.toArray(new Base[this.questionnaire.size()]);
            }
            case 3443497: {
                return this.plan == null ? new Base[]{} : this.plan.toArray(new Base[this.plan.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 1508158071: {
                this.versionAlgorithm = TypeConvertor.castToType(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -2060497896: {
                this.subtitle = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1478300413: {
                this.severity = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1702620169: {
                this.bodySite = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 109757182: {
                this.stage = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 57790391: {
                this.hasSeverity = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 282110147: {
                this.hasBodySite = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 129749124: {
                this.hasStage = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(TypeConvertor.castToUri(value));
                return value;
            }
            case 122345516: {
                this.getObservation().add((ConditionDefinitionObservationComponent)((Object)value));
                return value;
            }
            case 1998965455: {
                this.getMedication().add((ConditionDefinitionMedicationComponent)((Object)value));
                return value;
            }
            case -650968616: {
                this.getPrecondition().add((ConditionDefinitionPreconditionComponent)((Object)value));
                return value;
            }
            case 3555933: {
                this.getTeam().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1017049693: {
                this.getQuestionnaire().add((ConditionDefinitionQuestionnaireComponent)((Object)value));
                return value;
            }
            case 3443497: {
                this.getPlan().add((ConditionDefinitionPlanComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = TypeConvertor.castToType(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("subtitle")) {
            this.subtitle = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("code")) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("severity")) {
            this.severity = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("bodySite")) {
            this.bodySite = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("stage")) {
            this.stage = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("hasSeverity")) {
            this.hasSeverity = TypeConvertor.castToBoolean(value);
        } else if (name.equals("hasBodySite")) {
            this.hasBodySite = TypeConvertor.castToBoolean(value);
        } else if (name.equals("hasStage")) {
            this.hasStage = TypeConvertor.castToBoolean(value);
        } else if (name.equals("definition")) {
            this.getDefinition().add(TypeConvertor.castToUri(value));
        } else if (name.equals("observation")) {
            this.getObservation().add((ConditionDefinitionObservationComponent)((Object)value));
        } else if (name.equals("medication")) {
            this.getMedication().add((ConditionDefinitionMedicationComponent)((Object)value));
        } else if (name.equals("precondition")) {
            this.getPrecondition().add((ConditionDefinitionPreconditionComponent)((Object)value));
        } else if (name.equals("team")) {
            this.getTeam().add(TypeConvertor.castToReference(value));
        } else if (name.equals("questionnaire")) {
            this.getQuestionnaire().add((ConditionDefinitionQuestionnaireComponent)((Object)value));
        } else if (name.equals("plan")) {
            this.getPlan().add((ConditionDefinitionPlanComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = null;
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = null;
        } else if (name.equals(SP_NAME)) {
            this.name = null;
        } else if (name.equals(SP_TITLE)) {
            this.title = null;
        } else if (name.equals("subtitle")) {
            this.subtitle = null;
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = null;
        } else if (name.equals(SP_DATE)) {
            this.date = null;
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = null;
        } else if (name.equals("contact")) {
            this.getContact().remove(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = null;
        } else if (name.equals("useContext")) {
            this.getUseContext().remove(value);
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().remove(value);
        } else if (name.equals("code")) {
            this.code = null;
        } else if (name.equals("severity")) {
            this.severity = null;
        } else if (name.equals("bodySite")) {
            this.bodySite = null;
        } else if (name.equals("stage")) {
            this.stage = null;
        } else if (name.equals("hasSeverity")) {
            this.hasSeverity = null;
        } else if (name.equals("hasBodySite")) {
            this.hasBodySite = null;
        } else if (name.equals("hasStage")) {
            this.hasStage = null;
        } else if (name.equals("definition")) {
            this.getDefinition().remove(value);
        } else if (name.equals("observation")) {
            this.getObservation().remove((ConditionDefinitionObservationComponent)((Object)value));
        } else if (name.equals("medication")) {
            this.getMedication().remove((ConditionDefinitionMedicationComponent)((Object)value));
        } else if (name.equals("precondition")) {
            this.getPrecondition().remove((ConditionDefinitionPreconditionComponent)((Object)value));
        } else if (name.equals("team")) {
            this.getTeam().remove(value);
        } else if (name.equals("questionnaire")) {
            this.getQuestionnaire().remove((ConditionDefinitionQuestionnaireComponent)((Object)value));
        } else if (name.equals("plan")) {
            this.getPlan().remove((ConditionDefinitionPlanComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -115699031: {
                return this.getVersionAlgorithm();
            }
            case 1508158071: {
                return this.getVersionAlgorithm();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -2060497896: {
                return this.getSubtitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 3059181: {
                return this.getCode();
            }
            case 1478300413: {
                return this.getSeverity();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case 109757182: {
                return this.getStage();
            }
            case 57790391: {
                return this.getHasSeverityElement();
            }
            case 282110147: {
                return this.getHasBodySiteElement();
            }
            case 129749124: {
                return this.getHasStageElement();
            }
            case -1014418093: {
                return this.addDefinitionElement();
            }
            case 122345516: {
                return this.addObservation();
            }
            case 1998965455: {
                return this.addMedication();
            }
            case -650968616: {
                return this.addPrecondition();
            }
            case 3555933: {
                return this.addTeam();
            }
            case -1017049693: {
                return this.addQuestionnaire();
            }
            case 3443497: {
                return this.addPlan();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 1508158071: {
                return new String[]{"string", "Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -2060497896: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case 1478300413: {
                return new String[]{"CodeableConcept"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case 109757182: {
                return new String[]{"CodeableConcept"};
            }
            case 57790391: {
                return new String[]{"boolean"};
            }
            case 282110147: {
                return new String[]{"boolean"};
            }
            case 129749124: {
                return new String[]{"boolean"};
            }
            case -1014418093: {
                return new String[]{"uri"};
            }
            case 122345516: {
                return new String[0];
            }
            case 1998965455: {
                return new String[0];
            }
            case -650968616: {
                return new String[0];
            }
            case 3555933: {
                return new String[]{"Reference"};
            }
            case -1017049693: {
                return new String[0];
            }
            case 3443497: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.version");
        }
        if (name.equals("versionAlgorithmString")) {
            this.versionAlgorithm = new StringType();
            return this.versionAlgorithm;
        }
        if (name.equals("versionAlgorithmCoding")) {
            this.versionAlgorithm = new Coding();
            return this.versionAlgorithm;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.title");
        }
        if (name.equals("subtitle")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.subtitle");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("severity")) {
            this.severity = new CodeableConcept();
            return this.severity;
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals("stage")) {
            this.stage = new CodeableConcept();
            return this.stage;
        }
        if (name.equals("hasSeverity")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.hasSeverity");
        }
        if (name.equals("hasBodySite")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.hasBodySite");
        }
        if (name.equals("hasStage")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.hasStage");
        }
        if (name.equals("definition")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.definition");
        }
        if (name.equals("observation")) {
            return this.addObservation();
        }
        if (name.equals("medication")) {
            return this.addMedication();
        }
        if (name.equals("precondition")) {
            return this.addPrecondition();
        }
        if (name.equals("team")) {
            return this.addTeam();
        }
        if (name.equals("questionnaire")) {
            return this.addQuestionnaire();
        }
        if (name.equals("plan")) {
            return this.addPlan();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ConditionDefinition";
    }

    @Override
    public ConditionDefinition copy() {
        ConditionDefinition dst = new ConditionDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ConditionDefinition dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.versionAlgorithm = this.versionAlgorithm == null ? null : this.versionAlgorithm.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.subtitle = this.subtitle == null ? null : this.subtitle.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.severity = this.severity == null ? null : this.severity.copy();
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        dst.stage = this.stage == null ? null : this.stage.copy();
        dst.hasSeverity = this.hasSeverity == null ? null : this.hasSeverity.copy();
        dst.hasBodySite = this.hasBodySite == null ? null : this.hasBodySite.copy();
        BooleanType booleanType = dst.hasStage = this.hasStage == null ? null : this.hasStage.copy();
        if (this.definition != null) {
            dst.definition = new ArrayList<UriType>();
            for (UriType uriType2 : this.definition) {
                dst.definition.add(uriType2.copy());
            }
        }
        if (this.observation != null) {
            dst.observation = new ArrayList<ConditionDefinitionObservationComponent>();
            for (ConditionDefinitionObservationComponent conditionDefinitionObservationComponent : this.observation) {
                dst.observation.add(conditionDefinitionObservationComponent.copy());
            }
        }
        if (this.medication != null) {
            dst.medication = new ArrayList<ConditionDefinitionMedicationComponent>();
            for (ConditionDefinitionMedicationComponent conditionDefinitionMedicationComponent : this.medication) {
                dst.medication.add(conditionDefinitionMedicationComponent.copy());
            }
        }
        if (this.precondition != null) {
            dst.precondition = new ArrayList<ConditionDefinitionPreconditionComponent>();
            for (ConditionDefinitionPreconditionComponent conditionDefinitionPreconditionComponent : this.precondition) {
                dst.precondition.add(conditionDefinitionPreconditionComponent.copy());
            }
        }
        if (this.team != null) {
            dst.team = new ArrayList<Reference>();
            for (Reference reference : this.team) {
                dst.team.add(reference.copy());
            }
        }
        if (this.questionnaire != null) {
            dst.questionnaire = new ArrayList<ConditionDefinitionQuestionnaireComponent>();
            for (ConditionDefinitionQuestionnaireComponent conditionDefinitionQuestionnaireComponent : this.questionnaire) {
                dst.questionnaire.add(conditionDefinitionQuestionnaireComponent.copy());
            }
        }
        if (this.plan != null) {
            dst.plan = new ArrayList<ConditionDefinitionPlanComponent>();
            for (ConditionDefinitionPlanComponent conditionDefinitionPlanComponent : this.plan) {
                dst.plan.add(conditionDefinitionPlanComponent.copy());
            }
        }
    }

    protected ConditionDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ConditionDefinition)) {
            return false;
        }
        ConditionDefinition o = (ConditionDefinition)other_;
        return ConditionDefinition.compareDeep(this.url, o.url, true) && ConditionDefinition.compareDeep(this.identifier, o.identifier, true) && ConditionDefinition.compareDeep(this.version, o.version, true) && ConditionDefinition.compareDeep(this.versionAlgorithm, o.versionAlgorithm, true) && ConditionDefinition.compareDeep(this.name, o.name, true) && ConditionDefinition.compareDeep(this.title, o.title, true) && ConditionDefinition.compareDeep(this.subtitle, o.subtitle, true) && ConditionDefinition.compareDeep(this.status, o.status, true) && ConditionDefinition.compareDeep(this.experimental, o.experimental, true) && ConditionDefinition.compareDeep(this.date, o.date, true) && ConditionDefinition.compareDeep(this.publisher, o.publisher, true) && ConditionDefinition.compareDeep(this.contact, o.contact, true) && ConditionDefinition.compareDeep(this.description, o.description, true) && ConditionDefinition.compareDeep(this.useContext, o.useContext, true) && ConditionDefinition.compareDeep(this.jurisdiction, o.jurisdiction, true) && ConditionDefinition.compareDeep(this.code, o.code, true) && ConditionDefinition.compareDeep(this.severity, o.severity, true) && ConditionDefinition.compareDeep(this.bodySite, o.bodySite, true) && ConditionDefinition.compareDeep(this.stage, o.stage, true) && ConditionDefinition.compareDeep(this.hasSeverity, o.hasSeverity, true) && ConditionDefinition.compareDeep(this.hasBodySite, o.hasBodySite, true) && ConditionDefinition.compareDeep(this.hasStage, o.hasStage, true) && ConditionDefinition.compareDeep(this.definition, o.definition, true) && ConditionDefinition.compareDeep(this.observation, o.observation, true) && ConditionDefinition.compareDeep(this.medication, o.medication, true) && ConditionDefinition.compareDeep(this.precondition, o.precondition, true) && ConditionDefinition.compareDeep(this.team, o.team, true) && ConditionDefinition.compareDeep(this.questionnaire, o.questionnaire, true) && ConditionDefinition.compareDeep(this.plan, o.plan, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ConditionDefinition)) {
            return false;
        }
        ConditionDefinition o = (ConditionDefinition)other_;
        return ConditionDefinition.compareValues(this.url, o.url, true) && ConditionDefinition.compareValues(this.version, o.version, true) && ConditionDefinition.compareValues(this.name, o.name, true) && ConditionDefinition.compareValues(this.title, o.title, true) && ConditionDefinition.compareValues(this.subtitle, o.subtitle, true) && ConditionDefinition.compareValues(this.status, o.status, true) && ConditionDefinition.compareValues(this.experimental, o.experimental, true) && ConditionDefinition.compareValues(this.date, o.date, true) && ConditionDefinition.compareValues(this.publisher, o.publisher, true) && ConditionDefinition.compareValues(this.description, o.description, true) && ConditionDefinition.compareValues(this.hasSeverity, o.hasSeverity, true) && ConditionDefinition.compareValues(this.hasBodySite, o.hasBodySite, true) && ConditionDefinition.compareValues(this.hasStage, o.hasStage, true) && ConditionDefinition.compareValues(this.definition, o.definition, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.versionAlgorithm, this.name, this.title, this.subtitle, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.code, this.severity, this.bodySite, this.stage, this.hasSeverity, this.hasBodySite, this.hasStage, this.definition, this.observation, this.medication, this.precondition, this.team, this.questionnaire, this.plan});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ConditionDefinition;
    }

    @Block
    public static class ConditionDefinitionObservationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category that is relevant", formalDefinition="Category that is relevant.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-category")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code for relevant Observation", formalDefinition="Code for relevant Observation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept code;
        private static final long serialVersionUID = -1433986479L;

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionObservationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ConditionDefinitionObservationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionObservationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConditionDefinitionObservationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Category that is relevant.", 0, 1, this.category));
            children.add(new Property("code", "CodeableConcept", "Code for relevant Observation.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Category that is relevant.", 0, 1, this.category);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Code for relevant Observation.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("code")) {
                this.code = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionObservationComponent copy() {
            ConditionDefinitionObservationComponent dst = new ConditionDefinitionObservationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionObservationComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionObservationComponent)) {
                return false;
            }
            ConditionDefinitionObservationComponent o = (ConditionDefinitionObservationComponent)other_;
            return ConditionDefinitionObservationComponent.compareDeep(this.category, o.category, true) && ConditionDefinitionObservationComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionObservationComponent)) {
                return false;
            }
            ConditionDefinitionObservationComponent o = (ConditionDefinitionObservationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.code});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.observation";
        }
    }

    @Block
    public static class ConditionDefinitionMedicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category that is relevant", formalDefinition="Category that is relevant.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/medicationrequest-category")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code for relevant Medication", formalDefinition="Code for relevant Medication.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
        protected CodeableConcept code;
        private static final long serialVersionUID = -1433986479L;

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionMedicationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ConditionDefinitionMedicationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionMedicationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConditionDefinitionMedicationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "Category that is relevant.", 0, 1, this.category));
            children.add(new Property("code", "CodeableConcept", "Code for relevant Medication.", 0, 1, this.code));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Category that is relevant.", 0, 1, this.category);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Code for relevant Medication.", 0, 1, this.code);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("code")) {
                this.code = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionMedicationComponent copy() {
            ConditionDefinitionMedicationComponent dst = new ConditionDefinitionMedicationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionMedicationComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionMedicationComponent)) {
                return false;
            }
            ConditionDefinitionMedicationComponent o = (ConditionDefinitionMedicationComponent)other_;
            return ConditionDefinitionMedicationComponent.compareDeep(this.category, o.category, true) && ConditionDefinitionMedicationComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionMedicationComponent)) {
                return false;
            }
            ConditionDefinitionMedicationComponent o = (ConditionDefinitionMedicationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.code});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.medication";
        }
    }

    @Block
    public static class ConditionDefinitionPreconditionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="sensitive | specific", formalDefinition="Kind of pre-condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-precondition-type")
        protected Enumeration<ConditionPreconditionType> type;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code for relevant Observation", formalDefinition="Code for relevant Observation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        protected CodeableConcept code;
        @Child(name="value", type={CodeableConcept.class, Quantity.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of Observation", formalDefinition="Value of Observation.")
        protected DataType value;
        private static final long serialVersionUID = -1210333235L;

        public ConditionDefinitionPreconditionComponent() {
        }

        public ConditionDefinitionPreconditionComponent(ConditionPreconditionType type, CodeableConcept code) {
            this.setType(type);
            this.setCode(code);
        }

        public Enumeration<ConditionPreconditionType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionPreconditionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ConditionPreconditionType>(new ConditionPreconditionTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ConditionDefinitionPreconditionComponent setTypeElement(Enumeration<ConditionPreconditionType> value) {
            this.type = value;
            return this;
        }

        public ConditionPreconditionType getType() {
            return this.type == null ? null : (ConditionPreconditionType)((Object)this.type.getValue());
        }

        public ConditionDefinitionPreconditionComponent setType(ConditionPreconditionType value) {
            if (this.type == null) {
                this.type = new Enumeration<ConditionPreconditionType>(new ConditionPreconditionTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionPreconditionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConditionDefinitionPreconditionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConditionDefinitionPreconditionComponent setValue(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Quantity)) {
                throw new FHIRException("Not the right type for ConditionDefinition.precondition.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "Kind of pre-condition.", 0, 1, this.type));
            children.add(new Property("code", "CodeableConcept", "Code for relevant Observation.", 0, 1, this.code));
            children.add(new Property("value[x]", "CodeableConcept|Quantity", "Value of Observation.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "Kind of pre-condition.", 0, 1, this.type);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Code for relevant Observation.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "Value of Observation.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity", "Value of Observation.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Value of Observation.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Value of Observation.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ConditionPreconditionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ConditionPreconditionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ConditionPreconditionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.precondition.type");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionPreconditionComponent copy() {
            ConditionDefinitionPreconditionComponent dst = new ConditionDefinitionPreconditionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionPreconditionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionPreconditionComponent)) {
                return false;
            }
            ConditionDefinitionPreconditionComponent o = (ConditionDefinitionPreconditionComponent)other_;
            return ConditionDefinitionPreconditionComponent.compareDeep(this.type, o.type, true) && ConditionDefinitionPreconditionComponent.compareDeep(this.code, o.code, true) && ConditionDefinitionPreconditionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionPreconditionComponent)) {
                return false;
            }
            ConditionDefinitionPreconditionComponent o = (ConditionDefinitionPreconditionComponent)other_;
            return ConditionDefinitionPreconditionComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.code, this.value});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.precondition";
        }
    }

    @Block
    public static class ConditionDefinitionQuestionnaireComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="purpose", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="preadmit | diff-diagnosis | outcome", formalDefinition="Use of the questionnaire.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-questionnaire-purpose")
        protected Enumeration<ConditionQuestionnairePurpose> purpose;
        @Child(name="reference", type={Questionnaire.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific Questionnaire", formalDefinition="Specific Questionnaire.")
        protected Reference reference;
        private static final long serialVersionUID = -1791379681L;

        public ConditionDefinitionQuestionnaireComponent() {
        }

        public ConditionDefinitionQuestionnaireComponent(ConditionQuestionnairePurpose purpose, Reference reference) {
            this.setPurpose(purpose);
            this.setReference(reference);
        }

        public Enumeration<ConditionQuestionnairePurpose> getPurposeElement() {
            if (this.purpose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionQuestionnaireComponent.purpose");
                }
                if (Configuration.doAutoCreate()) {
                    this.purpose = new Enumeration<ConditionQuestionnairePurpose>(new ConditionQuestionnairePurposeEnumFactory());
                }
            }
            return this.purpose;
        }

        public boolean hasPurposeElement() {
            return this.purpose != null && !this.purpose.isEmpty();
        }

        public boolean hasPurpose() {
            return this.purpose != null && !this.purpose.isEmpty();
        }

        public ConditionDefinitionQuestionnaireComponent setPurposeElement(Enumeration<ConditionQuestionnairePurpose> value) {
            this.purpose = value;
            return this;
        }

        public ConditionQuestionnairePurpose getPurpose() {
            return this.purpose == null ? null : (ConditionQuestionnairePurpose)((Object)this.purpose.getValue());
        }

        public ConditionDefinitionQuestionnaireComponent setPurpose(ConditionQuestionnairePurpose value) {
            if (this.purpose == null) {
                this.purpose = new Enumeration<ConditionQuestionnairePurpose>(new ConditionQuestionnairePurposeEnumFactory());
            }
            this.purpose.setValue((Object)value);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionQuestionnaireComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ConditionDefinitionQuestionnaireComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("purpose", "code", "Use of the questionnaire.", 0, 1, this.purpose));
            children.add(new Property("reference", "Reference(Questionnaire)", "Specific Questionnaire.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -220463842: {
                    return new Property("purpose", "code", "Use of the questionnaire.", 0, 1, this.purpose);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Questionnaire)", "Specific Questionnaire.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    Base[] baseArray;
                    if (this.purpose == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.purpose;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    value = new ConditionQuestionnairePurposeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.purpose = value;
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("purpose")) {
                value = new ConditionQuestionnairePurposeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.purpose = value;
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("purpose")) {
                value = new ConditionQuestionnairePurposeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.purpose = value;
            } else if (name.equals("reference")) {
                this.reference = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return this.getPurposeElement();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -220463842: {
                    return new String[]{"code"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("purpose")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConditionDefinition.questionnaire.purpose");
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionQuestionnaireComponent copy() {
            ConditionDefinitionQuestionnaireComponent dst = new ConditionDefinitionQuestionnaireComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionQuestionnaireComponent dst) {
            super.copyValues(dst);
            dst.purpose = this.purpose == null ? null : this.purpose.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionQuestionnaireComponent)) {
                return false;
            }
            ConditionDefinitionQuestionnaireComponent o = (ConditionDefinitionQuestionnaireComponent)other_;
            return ConditionDefinitionQuestionnaireComponent.compareDeep(this.purpose, o.purpose, true) && ConditionDefinitionQuestionnaireComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionQuestionnaireComponent)) {
                return false;
            }
            ConditionDefinitionQuestionnaireComponent o = (ConditionDefinitionQuestionnaireComponent)other_;
            return ConditionDefinitionQuestionnaireComponent.compareValues(this.purpose, o.purpose, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.purpose, this.reference});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.questionnaire";
        }
    }

    @Block
    public static class ConditionDefinitionPlanComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Use for the plan", formalDefinition="Use for the plan.")
        protected CodeableConcept role;
        @Child(name="reference", type={PlanDefinition.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The actual plan", formalDefinition="The actual plan.")
        protected Reference reference;
        private static final long serialVersionUID = -1992921787L;

        public ConditionDefinitionPlanComponent() {
        }

        public ConditionDefinitionPlanComponent(Reference reference) {
            this.setReference(reference);
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionPlanComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ConditionDefinitionPlanComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConditionDefinitionPlanComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ConditionDefinitionPlanComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "Use for the plan.", 0, 1, this.role));
            children.add(new Property("reference", "Reference(PlanDefinition)", "The actual plan.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Use for the plan.", 0, 1, this.role);
                }
                case -925155509: {
                    return new Property("reference", "Reference(PlanDefinition)", "The actual plan.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = null;
            } else if (name.equals("reference")) {
                this.reference = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ConditionDefinitionPlanComponent copy() {
            ConditionDefinitionPlanComponent dst = new ConditionDefinitionPlanComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConditionDefinitionPlanComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionPlanComponent)) {
                return false;
            }
            ConditionDefinitionPlanComponent o = (ConditionDefinitionPlanComponent)other_;
            return ConditionDefinitionPlanComponent.compareDeep(this.role, o.role, true) && ConditionDefinitionPlanComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConditionDefinitionPlanComponent)) {
                return false;
            }
            ConditionDefinitionPlanComponent o = (ConditionDefinitionPlanComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.reference});
        }

        @Override
        public String fhirType() {
            return "ConditionDefinition.plan";
        }
    }

    public static class ConditionQuestionnairePurposeEnumFactory
    implements EnumFactory<ConditionQuestionnairePurpose> {
        @Override
        public ConditionQuestionnairePurpose fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preadmit".equals(codeString)) {
                return ConditionQuestionnairePurpose.PREADMIT;
            }
            if ("diff-diagnosis".equals(codeString)) {
                return ConditionQuestionnairePurpose.DIFFDIAGNOSIS;
            }
            if ("outcome".equals(codeString)) {
                return ConditionQuestionnairePurpose.OUTCOME;
            }
            throw new IllegalArgumentException("Unknown ConditionQuestionnairePurpose code '" + codeString + "'");
        }

        public Enumeration<ConditionQuestionnairePurpose> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConditionQuestionnairePurpose>(this, ConditionQuestionnairePurpose.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConditionQuestionnairePurpose>(this, ConditionQuestionnairePurpose.NULL, code);
            }
            if ("preadmit".equals(codeString)) {
                return new Enumeration<ConditionQuestionnairePurpose>(this, ConditionQuestionnairePurpose.PREADMIT, code);
            }
            if ("diff-diagnosis".equals(codeString)) {
                return new Enumeration<ConditionQuestionnairePurpose>(this, ConditionQuestionnairePurpose.DIFFDIAGNOSIS, code);
            }
            if ("outcome".equals(codeString)) {
                return new Enumeration<ConditionQuestionnairePurpose>(this, ConditionQuestionnairePurpose.OUTCOME, code);
            }
            throw new FHIRException("Unknown ConditionQuestionnairePurpose code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionQuestionnairePurpose code) {
            if (code == ConditionQuestionnairePurpose.NULL) {
                return null;
            }
            if (code == ConditionQuestionnairePurpose.PREADMIT) {
                return "preadmit";
            }
            if (code == ConditionQuestionnairePurpose.DIFFDIAGNOSIS) {
                return "diff-diagnosis";
            }
            if (code == ConditionQuestionnairePurpose.OUTCOME) {
                return "outcome";
            }
            return "?";
        }

        @Override
        public String toSystem(ConditionQuestionnairePurpose code) {
            return code.getSystem();
        }
    }

    public static enum ConditionQuestionnairePurpose {
        PREADMIT,
        DIFFDIAGNOSIS,
        OUTCOME,
        NULL;


        public static ConditionQuestionnairePurpose fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preadmit".equals(codeString)) {
                return PREADMIT;
            }
            if ("diff-diagnosis".equals(codeString)) {
                return DIFFDIAGNOSIS;
            }
            if ("outcome".equals(codeString)) {
                return OUTCOME;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConditionQuestionnairePurpose code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREADMIT: {
                    return "preadmit";
                }
                case DIFFDIAGNOSIS: {
                    return "diff-diagnosis";
                }
                case OUTCOME: {
                    return "outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREADMIT: {
                    return "http://hl7.org/fhir/condition-questionnaire-purpose";
                }
                case DIFFDIAGNOSIS: {
                    return "http://hl7.org/fhir/condition-questionnaire-purpose";
                }
                case OUTCOME: {
                    return "http://hl7.org/fhir/condition-questionnaire-purpose";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREADMIT: {
                    return "A pre-admit questionnaire.";
                }
                case DIFFDIAGNOSIS: {
                    return "A questionnaire that helps with diferential diagnosis.";
                }
                case OUTCOME: {
                    return "A questionnaire to check on outcomes for the patient.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREADMIT: {
                    return "Pre-admit";
                }
                case DIFFDIAGNOSIS: {
                    return "Diff Diagnosis";
                }
                case OUTCOME: {
                    return "Outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ConditionPreconditionTypeEnumFactory
    implements EnumFactory<ConditionPreconditionType> {
        @Override
        public ConditionPreconditionType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("sensitive".equals(codeString)) {
                return ConditionPreconditionType.SENSITIVE;
            }
            if ("specific".equals(codeString)) {
                return ConditionPreconditionType.SPECIFIC;
            }
            throw new IllegalArgumentException("Unknown ConditionPreconditionType code '" + codeString + "'");
        }

        public Enumeration<ConditionPreconditionType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConditionPreconditionType>(this, ConditionPreconditionType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConditionPreconditionType>(this, ConditionPreconditionType.NULL, code);
            }
            if ("sensitive".equals(codeString)) {
                return new Enumeration<ConditionPreconditionType>(this, ConditionPreconditionType.SENSITIVE, code);
            }
            if ("specific".equals(codeString)) {
                return new Enumeration<ConditionPreconditionType>(this, ConditionPreconditionType.SPECIFIC, code);
            }
            throw new FHIRException("Unknown ConditionPreconditionType code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionPreconditionType code) {
            if (code == ConditionPreconditionType.NULL) {
                return null;
            }
            if (code == ConditionPreconditionType.SENSITIVE) {
                return "sensitive";
            }
            if (code == ConditionPreconditionType.SPECIFIC) {
                return "specific";
            }
            return "?";
        }

        @Override
        public String toSystem(ConditionPreconditionType code) {
            return code.getSystem();
        }
    }

    public static enum ConditionPreconditionType {
        SENSITIVE,
        SPECIFIC,
        NULL;


        public static ConditionPreconditionType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sensitive".equals(codeString)) {
                return SENSITIVE;
            }
            if ("specific".equals(codeString)) {
                return SPECIFIC;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConditionPreconditionType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SENSITIVE: {
                    return "sensitive";
                }
                case SPECIFIC: {
                    return "specific";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SENSITIVE: {
                    return "http://hl7.org/fhir/condition-precondition-type";
                }
                case SPECIFIC: {
                    return "http://hl7.org/fhir/condition-precondition-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SENSITIVE: {
                    return "The observation is very sensitive for the condition, but may also indicate other conditions.";
                }
                case SPECIFIC: {
                    return "The observation is very specific for this condition, but not particularly sensitive.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SENSITIVE: {
                    return "Sensitive";
                }
                case SPECIFIC: {
                    return "Specific";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

