/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.VirtualServiceDetail;

@ResourceDef(name="Encounter", profile="http://hl7.org/fhir/StructureDefinition/Encounter")
public class Encounter
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier(s) by which this encounter is known", formalDefinition="Identifier(s) by which this encounter is known.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | in-progress | on-hold | discharged | completed | cancelled | discontinued | entered-in-error | unknown", formalDefinition="The current state of the encounter (not the state of the patient within the encounter - that is subjectState).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-status")
    protected Enumeration<Enumerations.EncounterStatus> status;
    @Child(name="class", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of patient encounter context - e.g. Inpatient, outpatient", formalDefinition="Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/encounter-class")
    protected List<CodeableConcept> class_;
    @Child(name="priority", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates the urgency of the encounter", formalDefinition="Indicates the urgency of the encounter.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActPriority")
    protected CodeableConcept priority;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of encounter (e.g. e-mail consultation, surgical day-care, ...)", formalDefinition="Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-type")
    protected List<CodeableConcept> type;
    @Child(name="serviceType", type={CodeableReference.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of service", formalDefinition="Broad categorization of the service that is to be provided (e.g. cardiology).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-type")
    protected List<CodeableReference> serviceType;
    @Child(name="subject", type={Patient.class, Group.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient or group related to this encounter", formalDefinition="The patient or group related to this encounter. In some use-cases the patient MAY not be present, such as a case meeting about a patient between several practitioners or a careteam.")
    protected Reference subject;
    @Child(name="subjectStatus", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The current status of the subject in relation to the Encounter", formalDefinition="The subjectStatus value can be used to track the patient's status within the encounter. It details whether the patient has arrived or departed, has been triaged or is currently in a waiting status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-subject-status")
    protected CodeableConcept subjectStatus;
    @Child(name="episodeOfCare", type={EpisodeOfCare.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Episode(s) of care that this encounter should be recorded against", formalDefinition="Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).")
    protected List<Reference> episodeOfCare;
    @Child(name="basedOn", type={CarePlan.class, DeviceRequest.class, MedicationRequest.class, ServiceRequest.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The request that initiated this encounter", formalDefinition="The request this encounter satisfies (e.g. incoming referral or procedure request).")
    protected List<Reference> basedOn;
    @Child(name="careTeam", type={CareTeam.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The group(s) that are allocated to participate in this encounter", formalDefinition="The group(s) of individuals, organizations that are allocated to participate in this encounter. The participants backbone will record the actuals of when these individuals participated during the encounter.")
    protected List<Reference> careTeam;
    @Child(name="partOf", type={Encounter.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Another Encounter this encounter is part of", formalDefinition="Another Encounter of which this encounter is a part of (administratively or in time).")
    protected Reference partOf;
    @Child(name="serviceProvider", type={Organization.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The organization (facility) responsible for this encounter", formalDefinition="The organization that is primarily responsible for this Encounter's services. This MAY be the same as the organization on the Patient record, however it could be different, such as if the actor performing the services was from an external organization (which may be billed seperately) for an external consultation.  Refer to the colonoscopy example on the Encounter examples tab.")
    protected Reference serviceProvider;
    @Child(name="participant", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="List of participants involved in the encounter", formalDefinition="The list of people responsible for providing the service.")
    protected List<EncounterParticipantComponent> participant;
    @Child(name="appointment", type={Appointment.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The appointment that scheduled this encounter", formalDefinition="The appointment that scheduled this encounter.")
    protected List<Reference> appointment;
    @Child(name="virtualService", type={VirtualServiceDetail.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Connection details of a virtual service (e.g. conference call)", formalDefinition="Connection details of a virtual service (e.g. conference call).")
    protected List<VirtualServiceDetail> virtualService;
    @Child(name="actualPeriod", type={Period.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The actual start and end time of the encounter", formalDefinition="The actual start and end time of the encounter.")
    protected Period actualPeriod;
    @Child(name="plannedStartDate", type={DateTimeType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The planned start date/time (or admission date) of the encounter", formalDefinition="The planned start date/time (or admission date) of the encounter.")
    protected DateTimeType plannedStartDate;
    @Child(name="plannedEndDate", type={DateTimeType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The planned end date/time (or discharge date) of the encounter", formalDefinition="The planned end date/time (or discharge date) of the encounter.")
    protected DateTimeType plannedEndDate;
    @Child(name="length", type={Duration.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Actual quantity of time the encounter lasted (less time absent)", formalDefinition="Actual quantity of time the encounter lasted. This excludes the time during leaves of absence.\r\rWhen missing it is the time in between the start and end values.")
    protected Duration length;
    @Child(name="reason", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The list of medical reasons that are expected to be addressed during the episode of care", formalDefinition="The list of medical reasons that are expected to be addressed during the episode of care.")
    protected List<ReasonComponent> reason;
    @Child(name="diagnosis", type={}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The list of diagnosis relevant to this encounter", formalDefinition="The list of diagnosis relevant to this encounter.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="account", type={Account.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The set of accounts that may be used for billing for this Encounter", formalDefinition="The set of accounts that may be used for billing for this Encounter.")
    protected List<Reference> account;
    @Child(name="dietPreference", type={CodeableConcept.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Diet preferences reported by the patient", formalDefinition="Diet preferences reported by the patient.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-diet")
    protected List<CodeableConcept> dietPreference;
    @Child(name="specialArrangement", type={CodeableConcept.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Wheelchair, translator, stretcher, etc", formalDefinition="Any special requests that have been made for this encounter, such as the provision of specific equipment or other things.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-special-arrangements")
    protected List<CodeableConcept> specialArrangement;
    @Child(name="specialCourtesy", type={CodeableConcept.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Special courtesies (VIP, board member)", formalDefinition="Special courtesies that may be provided to the patient during the encounter (VIP, board member, professional courtesy).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-special-courtesy")
    protected List<CodeableConcept> specialCourtesy;
    @Child(name="admission", type={}, order=26, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about the admission to a healthcare service", formalDefinition="Details about the stay during which a healthcare service is provided.\r\rThis does not describe the event of admitting the patient, but rather any information that is relevant from the time of admittance until the time of discharge.")
    protected EncounterAdmissionComponent admission;
    @Child(name="location", type={}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of locations where the patient has been", formalDefinition="List of locations where  the patient has been during this encounter.")
    protected List<EncounterLocationComponent> location;
    private static final long serialVersionUID = -1336316477L;
    @SearchParamDefinition(name="account", path="Encounter.account", description="The set of accounts that may be used for billing for this Encounter", type="reference", target={Account.class})
    public static final String SP_ACCOUNT = "account";
    public static final ReferenceClientParam ACCOUNT = new ReferenceClientParam("account");
    public static final Include INCLUDE_ACCOUNT = new Include("Encounter:account").toLocked();
    @SearchParamDefinition(name="appointment", path="Encounter.appointment", description="The appointment that scheduled this encounter", type="reference", target={Appointment.class})
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    public static final Include INCLUDE_APPOINTMENT = new Include("Encounter:appointment").toLocked();
    @SearchParamDefinition(name="based-on", path="Encounter.basedOn", description="The ServiceRequest that initiated this encounter", type="reference", target={CarePlan.class, DeviceRequest.class, MedicationRequest.class, ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Encounter:based-on").toLocked();
    @SearchParamDefinition(name="careteam", path="Encounter.careTeam", description="Careteam allocated to participate in the encounter", type="reference", target={CareTeam.class})
    public static final String SP_CARETEAM = "careteam";
    public static final ReferenceClientParam CARETEAM = new ReferenceClientParam("careteam");
    public static final Include INCLUDE_CARETEAM = new Include("Encounter:careteam").toLocked();
    @SearchParamDefinition(name="class", path="Encounter.class", description="Classification of patient encounter", type="token")
    public static final String SP_CLASS = "class";
    public static final TokenClientParam CLASS = new TokenClientParam("class");
    @SearchParamDefinition(name="date-start", path="Encounter.actualPeriod.start", description="The actual start date of the Encounter", type="date")
    public static final String SP_DATE_START = "date-start";
    public static final DateClientParam DATE_START = new DateClientParam("date-start");
    @SearchParamDefinition(name="diagnosis-code", path="Encounter.diagnosis.condition.concept", description="The diagnosis or procedure relevant to the encounter (coded)", type="token")
    public static final String SP_DIAGNOSIS_CODE = "diagnosis-code";
    public static final TokenClientParam DIAGNOSIS_CODE = new TokenClientParam("diagnosis-code");
    @SearchParamDefinition(name="diagnosis-reference", path="Encounter.diagnosis.condition.reference", description="The diagnosis or procedure relevant to the encounter (resource reference)", type="reference", target={Condition.class})
    public static final String SP_DIAGNOSIS_REFERENCE = "diagnosis-reference";
    public static final ReferenceClientParam DIAGNOSIS_REFERENCE = new ReferenceClientParam("diagnosis-reference");
    public static final Include INCLUDE_DIAGNOSIS_REFERENCE = new Include("Encounter:diagnosis-reference").toLocked();
    @SearchParamDefinition(name="end-date", path="Encounter.actualPeriod.end", description="The actual end date of the Encounter", type="date")
    public static final String SP_END_DATE = "end-date";
    public static final DateClientParam END_DATE = new DateClientParam("end-date");
    @SearchParamDefinition(name="episode-of-care", path="Encounter.episodeOfCare", description="Episode(s) of care that this encounter should be recorded against", type="reference", target={EpisodeOfCare.class})
    public static final String SP_EPISODE_OF_CARE = "episode-of-care";
    public static final ReferenceClientParam EPISODE_OF_CARE = new ReferenceClientParam("episode-of-care");
    public static final Include INCLUDE_EPISODE_OF_CARE = new Include("Encounter:episode-of-care").toLocked();
    @SearchParamDefinition(name="length", path="Encounter.length", description="Length of encounter in days", type="quantity")
    public static final String SP_LENGTH = "length";
    public static final QuantityClientParam LENGTH = new QuantityClientParam("length");
    @SearchParamDefinition(name="location", path="Encounter.location.location", description="Location the encounter takes place", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Encounter:location").toLocked();
    @SearchParamDefinition(name="part-of", path="Encounter.partOf", description="Another Encounter this encounter is part of", type="reference", target={Encounter.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Encounter:part-of").toLocked();
    @SearchParamDefinition(name="participant-type", path="Encounter.participant.type", description="Role of participant in encounter", type="token")
    public static final String SP_PARTICIPANT_TYPE = "participant-type";
    public static final TokenClientParam PARTICIPANT_TYPE = new TokenClientParam("participant-type");
    @SearchParamDefinition(name="participant", path="Encounter.participant.actor", description="Persons involved in the encounter other than the patient", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Device.class, Group.class, HealthcareService.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("Encounter:participant").toLocked();
    @SearchParamDefinition(name="practitioner", path="Encounter.participant.actor.where(resolve() is Practitioner)", description="Persons involved in the encounter other than the patient", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class})
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("Encounter:practitioner").toLocked();
    @SearchParamDefinition(name="reason-code", path="Encounter.reason.value.concept", description="Reference to a concept (coded)", type="token")
    public static final String SP_REASON_CODE = "reason-code";
    public static final TokenClientParam REASON_CODE = new TokenClientParam("reason-code");
    @SearchParamDefinition(name="reason-reference", path="Encounter.reason.value.reference", description="Reference to a resource (resource reference)", type="reference", target={Condition.class, DiagnosticReport.class, ImmunizationRecommendation.class, Observation.class, Procedure.class})
    public static final String SP_REASON_REFERENCE = "reason-reference";
    public static final ReferenceClientParam REASON_REFERENCE = new ReferenceClientParam("reason-reference");
    public static final Include INCLUDE_REASON_REFERENCE = new Include("Encounter:reason-reference").toLocked();
    @SearchParamDefinition(name="service-provider", path="Encounter.serviceProvider", description="The organization (facility) responsible for this encounter", type="reference", target={Organization.class})
    public static final String SP_SERVICE_PROVIDER = "service-provider";
    public static final ReferenceClientParam SERVICE_PROVIDER = new ReferenceClientParam("service-provider");
    public static final Include INCLUDE_SERVICE_PROVIDER = new Include("Encounter:service-provider").toLocked();
    @SearchParamDefinition(name="special-arrangement", path="Encounter.specialArrangement", description="Wheelchair, translator, stretcher, etc.", type="token")
    public static final String SP_SPECIAL_ARRANGEMENT = "special-arrangement";
    public static final TokenClientParam SPECIAL_ARRANGEMENT = new TokenClientParam("special-arrangement");
    @SearchParamDefinition(name="status", path="Encounter.status", description="planned | in-progress | on-hold | completed | cancelled | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject-status", path="Encounter.subjectStatus", description="The current status of the subject in relation to the Encounter", type="token")
    public static final String SP_SUBJECT_STATUS = "subject-status";
    public static final TokenClientParam SUBJECT_STATUS = new TokenClientParam("subject-status");
    @SearchParamDefinition(name="subject", path="Encounter.subject", description="The patient or group present at the encounter", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Encounter:subject").toLocked();
    @SearchParamDefinition(name="date", path="AdverseEvent.occurrence.ofType(dateTime) | AdverseEvent.occurrence.ofType(Period) | AdverseEvent.occurrence.ofType(Timing) | AllergyIntolerance.recordedDate | (start | requestedPeriod.start).first() | AuditEvent.recorded | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.ofType(dateTime) | DiagnosticReport.effective.ofType(Period) | DocumentReference.date | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence.ofType(dateTime)) | ImmunizationEvaluation.date | ImmunizationRecommendation.date | Invoice.date | List.date | MeasureReport.date | NutritionIntake.occurrence.ofType(dateTime) | NutritionIntake.occurrence.ofType(Period) | Observation.effective.ofType(dateTime) | Observation.effective.ofType(Period) | Observation.effective.ofType(Timing) | Observation.effective.ofType(instant) | Procedure.occurrence.ofType(dateTime) | Procedure.occurrence.ofType(Period) | Procedure.occurrence.ofType(Timing) | ResearchSubject.period | (RiskAssessment.occurrence.ofType(dateTime)) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AdverseEvent](adverseevent.html): When the event occurred\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [Appointment](appointment.html): Appointment date/time.\r\n* [AuditEvent](auditevent.html): Time when the event was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [DocumentReference](documentreference.html): When this document reference was created\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created\r\n* [Invoice](invoice.html): Invoice date / posting date\r\n* [List](list.html): When the list was prepared\r\n* [MeasureReport](measurereport.html): The date of the measure report\r\n* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication\r\n* [Observation](observation.html): Clinically relevant time/time-period for observation\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [ResearchSubject](researchsubject.html): Start and end of participation\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Encounter:patient").toLocked();
    @SearchParamDefinition(name="type", path="Account.type | AllergyIntolerance.type | Composition.type | Coverage.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type | Invoice.type | MedicationDispense.type | MolecularSequence.type | Specimen.type", description="Multiple Resources: \r\n\r\n* [Account](account.html): E.g. patient, expense, depreciation\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [Coverage](coverage.html): The kind of coverage (health plan, auto, Workers Compensation)\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n* [Invoice](invoice.html): Type of Invoice\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of a specific type\r\n* [MolecularSequence](molecularsequence.html): Amino Acid Sequence/ DNA Sequence / RNA Sequence\r\n* [Specimen](specimen.html): The specimen type\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Encounter() {
    }

    public Encounter(Enumerations.EncounterStatus status) {
        this.setStatus(status);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Encounter setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Encounter addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<Enumerations.EncounterStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.EncounterStatus>(new Enumerations.EncounterStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Encounter setStatusElement(Enumeration<Enumerations.EncounterStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.EncounterStatus getStatus() {
        return this.status == null ? null : (Enumerations.EncounterStatus)((Object)this.status.getValue());
    }

    public Encounter setStatus(Enumerations.EncounterStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.EncounterStatus>(new Enumerations.EncounterStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getClass_() {
        if (this.class_ == null) {
            this.class_ = new ArrayList<CodeableConcept>();
        }
        return this.class_;
    }

    public Encounter setClass_(List<CodeableConcept> theClass_) {
        this.class_ = theClass_;
        return this;
    }

    public boolean hasClass_() {
        if (this.class_ == null) {
            return false;
        }
        for (CodeableConcept item : this.class_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addClass_() {
        CodeableConcept t = new CodeableConcept();
        if (this.class_ == null) {
            this.class_ = new ArrayList<CodeableConcept>();
        }
        this.class_.add(t);
        return t;
    }

    public Encounter addClass_(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.class_ == null) {
            this.class_ = new ArrayList<CodeableConcept>();
        }
        this.class_.add(t);
        return this;
    }

    public CodeableConcept getClass_FirstRep() {
        if (this.getClass_().isEmpty()) {
            this.addClass_();
        }
        return this.getClass_().get(0);
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Encounter setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public Encounter setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Encounter addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public List<CodeableReference> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableReference>();
        }
        return this.serviceType;
    }

    public Encounter setServiceType(List<CodeableReference> theServiceType) {
        this.serviceType = theServiceType;
        return this;
    }

    public boolean hasServiceType() {
        if (this.serviceType == null) {
            return false;
        }
        for (CodeableReference item : this.serviceType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addServiceType() {
        CodeableReference t = new CodeableReference();
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableReference>();
        }
        this.serviceType.add(t);
        return t;
    }

    public Encounter addServiceType(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableReference>();
        }
        this.serviceType.add(t);
        return this;
    }

    public CodeableReference getServiceTypeFirstRep() {
        if (this.getServiceType().isEmpty()) {
            this.addServiceType();
        }
        return this.getServiceType().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Encounter setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public CodeableConcept getSubjectStatus() {
        if (this.subjectStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.subjectStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.subjectStatus = new CodeableConcept();
            }
        }
        return this.subjectStatus;
    }

    public boolean hasSubjectStatus() {
        return this.subjectStatus != null && !this.subjectStatus.isEmpty();
    }

    public Encounter setSubjectStatus(CodeableConcept value) {
        this.subjectStatus = value;
        return this;
    }

    public List<Reference> getEpisodeOfCare() {
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        return this.episodeOfCare;
    }

    public Encounter setEpisodeOfCare(List<Reference> theEpisodeOfCare) {
        this.episodeOfCare = theEpisodeOfCare;
        return this;
    }

    public boolean hasEpisodeOfCare() {
        if (this.episodeOfCare == null) {
            return false;
        }
        for (Reference item : this.episodeOfCare) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEpisodeOfCare() {
        Reference t = new Reference();
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        this.episodeOfCare.add(t);
        return t;
    }

    public Encounter addEpisodeOfCare(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        this.episodeOfCare.add(t);
        return this;
    }

    public Reference getEpisodeOfCareFirstRep() {
        if (this.getEpisodeOfCare().isEmpty()) {
            this.addEpisodeOfCare();
        }
        return this.getEpisodeOfCare().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Encounter setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Encounter addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<Reference> getCareTeam() {
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        return this.careTeam;
    }

    public Encounter setCareTeam(List<Reference> theCareTeam) {
        this.careTeam = theCareTeam;
        return this;
    }

    public boolean hasCareTeam() {
        if (this.careTeam == null) {
            return false;
        }
        for (Reference item : this.careTeam) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCareTeam() {
        Reference t = new Reference();
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        this.careTeam.add(t);
        return t;
    }

    public Encounter addCareTeam(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        this.careTeam.add(t);
        return this;
    }

    public Reference getCareTeamFirstRep() {
        if (this.getCareTeam().isEmpty()) {
            this.addCareTeam();
        }
        return this.getCareTeam().get(0);
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Encounter setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    public Reference getServiceProvider() {
        if (this.serviceProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.serviceProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceProvider = new Reference();
            }
        }
        return this.serviceProvider;
    }

    public boolean hasServiceProvider() {
        return this.serviceProvider != null && !this.serviceProvider.isEmpty();
    }

    public Encounter setServiceProvider(Reference value) {
        this.serviceProvider = value;
        return this;
    }

    public List<EncounterParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        return this.participant;
    }

    public Encounter setParticipant(List<EncounterParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (EncounterParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterParticipantComponent addParticipant() {
        EncounterParticipantComponent t = new EncounterParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Encounter addParticipant(EncounterParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public EncounterParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public List<Reference> getAppointment() {
        if (this.appointment == null) {
            this.appointment = new ArrayList<Reference>();
        }
        return this.appointment;
    }

    public Encounter setAppointment(List<Reference> theAppointment) {
        this.appointment = theAppointment;
        return this;
    }

    public boolean hasAppointment() {
        if (this.appointment == null) {
            return false;
        }
        for (Reference item : this.appointment) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAppointment() {
        Reference t = new Reference();
        if (this.appointment == null) {
            this.appointment = new ArrayList<Reference>();
        }
        this.appointment.add(t);
        return t;
    }

    public Encounter addAppointment(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.appointment == null) {
            this.appointment = new ArrayList<Reference>();
        }
        this.appointment.add(t);
        return this;
    }

    public Reference getAppointmentFirstRep() {
        if (this.getAppointment().isEmpty()) {
            this.addAppointment();
        }
        return this.getAppointment().get(0);
    }

    public List<VirtualServiceDetail> getVirtualService() {
        if (this.virtualService == null) {
            this.virtualService = new ArrayList<VirtualServiceDetail>();
        }
        return this.virtualService;
    }

    public Encounter setVirtualService(List<VirtualServiceDetail> theVirtualService) {
        this.virtualService = theVirtualService;
        return this;
    }

    public boolean hasVirtualService() {
        if (this.virtualService == null) {
            return false;
        }
        for (VirtualServiceDetail item : this.virtualService) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public VirtualServiceDetail addVirtualService() {
        VirtualServiceDetail t = new VirtualServiceDetail();
        if (this.virtualService == null) {
            this.virtualService = new ArrayList<VirtualServiceDetail>();
        }
        this.virtualService.add(t);
        return t;
    }

    public Encounter addVirtualService(VirtualServiceDetail t) {
        if (t == null) {
            return this;
        }
        if (this.virtualService == null) {
            this.virtualService = new ArrayList<VirtualServiceDetail>();
        }
        this.virtualService.add(t);
        return this;
    }

    public VirtualServiceDetail getVirtualServiceFirstRep() {
        if (this.getVirtualService().isEmpty()) {
            this.addVirtualService();
        }
        return this.getVirtualService().get(0);
    }

    public Period getActualPeriod() {
        if (this.actualPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.actualPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.actualPeriod = new Period();
            }
        }
        return this.actualPeriod;
    }

    public boolean hasActualPeriod() {
        return this.actualPeriod != null && !this.actualPeriod.isEmpty();
    }

    public Encounter setActualPeriod(Period value) {
        this.actualPeriod = value;
        return this;
    }

    public DateTimeType getPlannedStartDateElement() {
        if (this.plannedStartDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.plannedStartDate");
            }
            if (Configuration.doAutoCreate()) {
                this.plannedStartDate = new DateTimeType();
            }
        }
        return this.plannedStartDate;
    }

    public boolean hasPlannedStartDateElement() {
        return this.plannedStartDate != null && !this.plannedStartDate.isEmpty();
    }

    public boolean hasPlannedStartDate() {
        return this.plannedStartDate != null && !this.plannedStartDate.isEmpty();
    }

    public Encounter setPlannedStartDateElement(DateTimeType value) {
        this.plannedStartDate = value;
        return this;
    }

    public Date getPlannedStartDate() {
        return this.plannedStartDate == null ? null : (Date)this.plannedStartDate.getValue();
    }

    public Encounter setPlannedStartDate(Date value) {
        if (value == null) {
            this.plannedStartDate = null;
        } else {
            if (this.plannedStartDate == null) {
                this.plannedStartDate = new DateTimeType();
            }
            this.plannedStartDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getPlannedEndDateElement() {
        if (this.plannedEndDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.plannedEndDate");
            }
            if (Configuration.doAutoCreate()) {
                this.plannedEndDate = new DateTimeType();
            }
        }
        return this.plannedEndDate;
    }

    public boolean hasPlannedEndDateElement() {
        return this.plannedEndDate != null && !this.plannedEndDate.isEmpty();
    }

    public boolean hasPlannedEndDate() {
        return this.plannedEndDate != null && !this.plannedEndDate.isEmpty();
    }

    public Encounter setPlannedEndDateElement(DateTimeType value) {
        this.plannedEndDate = value;
        return this;
    }

    public Date getPlannedEndDate() {
        return this.plannedEndDate == null ? null : (Date)this.plannedEndDate.getValue();
    }

    public Encounter setPlannedEndDate(Date value) {
        if (value == null) {
            this.plannedEndDate = null;
        } else {
            if (this.plannedEndDate == null) {
                this.plannedEndDate = new DateTimeType();
            }
            this.plannedEndDate.setValue(value);
        }
        return this;
    }

    public Duration getLength() {
        if (this.length == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.length");
            }
            if (Configuration.doAutoCreate()) {
                this.length = new Duration();
            }
        }
        return this.length;
    }

    public boolean hasLength() {
        return this.length != null && !this.length.isEmpty();
    }

    public Encounter setLength(Duration value) {
        this.length = value;
        return this;
    }

    public List<ReasonComponent> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<ReasonComponent>();
        }
        return this.reason;
    }

    public Encounter setReason(List<ReasonComponent> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (ReasonComponent item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ReasonComponent addReason() {
        ReasonComponent t = new ReasonComponent();
        if (this.reason == null) {
            this.reason = new ArrayList<ReasonComponent>();
        }
        this.reason.add(t);
        return t;
    }

    public Encounter addReason(ReasonComponent t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<ReasonComponent>();
        }
        this.reason.add(t);
        return this;
    }

    public ReasonComponent getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public Encounter setDiagnosis(List<DiagnosisComponent> theDiagnosis) {
        this.diagnosis = theDiagnosis;
        return this;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public Encounter addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public DiagnosisComponent getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public List<Reference> getAccount() {
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        return this.account;
    }

    public Encounter setAccount(List<Reference> theAccount) {
        this.account = theAccount;
        return this;
    }

    public boolean hasAccount() {
        if (this.account == null) {
            return false;
        }
        for (Reference item : this.account) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAccount() {
        Reference t = new Reference();
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return t;
    }

    public Encounter addAccount(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return this;
    }

    public Reference getAccountFirstRep() {
        if (this.getAccount().isEmpty()) {
            this.addAccount();
        }
        return this.getAccount().get(0);
    }

    public List<CodeableConcept> getDietPreference() {
        if (this.dietPreference == null) {
            this.dietPreference = new ArrayList<CodeableConcept>();
        }
        return this.dietPreference;
    }

    public Encounter setDietPreference(List<CodeableConcept> theDietPreference) {
        this.dietPreference = theDietPreference;
        return this;
    }

    public boolean hasDietPreference() {
        if (this.dietPreference == null) {
            return false;
        }
        for (CodeableConcept item : this.dietPreference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addDietPreference() {
        CodeableConcept t = new CodeableConcept();
        if (this.dietPreference == null) {
            this.dietPreference = new ArrayList<CodeableConcept>();
        }
        this.dietPreference.add(t);
        return t;
    }

    public Encounter addDietPreference(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.dietPreference == null) {
            this.dietPreference = new ArrayList<CodeableConcept>();
        }
        this.dietPreference.add(t);
        return this;
    }

    public CodeableConcept getDietPreferenceFirstRep() {
        if (this.getDietPreference().isEmpty()) {
            this.addDietPreference();
        }
        return this.getDietPreference().get(0);
    }

    public List<CodeableConcept> getSpecialArrangement() {
        if (this.specialArrangement == null) {
            this.specialArrangement = new ArrayList<CodeableConcept>();
        }
        return this.specialArrangement;
    }

    public Encounter setSpecialArrangement(List<CodeableConcept> theSpecialArrangement) {
        this.specialArrangement = theSpecialArrangement;
        return this;
    }

    public boolean hasSpecialArrangement() {
        if (this.specialArrangement == null) {
            return false;
        }
        for (CodeableConcept item : this.specialArrangement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialArrangement() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialArrangement == null) {
            this.specialArrangement = new ArrayList<CodeableConcept>();
        }
        this.specialArrangement.add(t);
        return t;
    }

    public Encounter addSpecialArrangement(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialArrangement == null) {
            this.specialArrangement = new ArrayList<CodeableConcept>();
        }
        this.specialArrangement.add(t);
        return this;
    }

    public CodeableConcept getSpecialArrangementFirstRep() {
        if (this.getSpecialArrangement().isEmpty()) {
            this.addSpecialArrangement();
        }
        return this.getSpecialArrangement().get(0);
    }

    public List<CodeableConcept> getSpecialCourtesy() {
        if (this.specialCourtesy == null) {
            this.specialCourtesy = new ArrayList<CodeableConcept>();
        }
        return this.specialCourtesy;
    }

    public Encounter setSpecialCourtesy(List<CodeableConcept> theSpecialCourtesy) {
        this.specialCourtesy = theSpecialCourtesy;
        return this;
    }

    public boolean hasSpecialCourtesy() {
        if (this.specialCourtesy == null) {
            return false;
        }
        for (CodeableConcept item : this.specialCourtesy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialCourtesy() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialCourtesy == null) {
            this.specialCourtesy = new ArrayList<CodeableConcept>();
        }
        this.specialCourtesy.add(t);
        return t;
    }

    public Encounter addSpecialCourtesy(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialCourtesy == null) {
            this.specialCourtesy = new ArrayList<CodeableConcept>();
        }
        this.specialCourtesy.add(t);
        return this;
    }

    public CodeableConcept getSpecialCourtesyFirstRep() {
        if (this.getSpecialCourtesy().isEmpty()) {
            this.addSpecialCourtesy();
        }
        return this.getSpecialCourtesy().get(0);
    }

    public EncounterAdmissionComponent getAdmission() {
        if (this.admission == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.admission");
            }
            if (Configuration.doAutoCreate()) {
                this.admission = new EncounterAdmissionComponent();
            }
        }
        return this.admission;
    }

    public boolean hasAdmission() {
        return this.admission != null && !this.admission.isEmpty();
    }

    public Encounter setAdmission(EncounterAdmissionComponent value) {
        this.admission = value;
        return this;
    }

    public List<EncounterLocationComponent> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        return this.location;
    }

    public Encounter setLocation(List<EncounterLocationComponent> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (EncounterLocationComponent item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterLocationComponent addLocation() {
        EncounterLocationComponent t = new EncounterLocationComponent();
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        this.location.add(t);
        return t;
    }

    public Encounter addLocation(EncounterLocationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        this.location.add(t);
        return this;
    }

    public EncounterLocationComponent getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The current state of the encounter (not the state of the patient within the encounter - that is subjectState).", 0, 1, this.status));
        children.add(new Property(SP_CLASS, "CodeableConcept", "Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.", 0, Integer.MAX_VALUE, this.class_));
        children.add(new Property("priority", "CodeableConcept", "Indicates the urgency of the encounter.", 0, 1, this.priority));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("serviceType", "CodeableReference(HealthcareService)", "Broad categorization of the service that is to be provided (e.g. cardiology).", 0, Integer.MAX_VALUE, this.serviceType));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group related to this encounter. In some use-cases the patient MAY not be present, such as a case meeting about a patient between several practitioners or a careteam.", 0, 1, this.subject));
        children.add(new Property("subjectStatus", "CodeableConcept", "The subjectStatus value can be used to track the patient's status within the encounter. It details whether the patient has arrived or departed, has been triaged or is currently in a waiting status.", 0, 1, this.subjectStatus));
        children.add(new Property("episodeOfCare", "Reference(EpisodeOfCare)", "Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).", 0, Integer.MAX_VALUE, this.episodeOfCare));
        children.add(new Property("basedOn", "Reference(CarePlan|DeviceRequest|MedicationRequest|ServiceRequest)", "The request this encounter satisfies (e.g. incoming referral or procedure request).", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("careTeam", "Reference(CareTeam)", "The group(s) of individuals, organizations that are allocated to participate in this encounter. The participants backbone will record the actuals of when these individuals participated during the encounter.", 0, Integer.MAX_VALUE, this.careTeam));
        children.add(new Property("partOf", "Reference(Encounter)", "Another Encounter of which this encounter is a part of (administratively or in time).", 0, 1, this.partOf));
        children.add(new Property("serviceProvider", "Reference(Organization)", "The organization that is primarily responsible for this Encounter's services. This MAY be the same as the organization on the Patient record, however it could be different, such as if the actor performing the services was from an external organization (which may be billed seperately) for an external consultation.  Refer to the colonoscopy example on the Encounter examples tab.", 0, 1, this.serviceProvider));
        children.add(new Property(SP_PARTICIPANT, "", "The list of people responsible for providing the service.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property(SP_APPOINTMENT, "Reference(Appointment)", "The appointment that scheduled this encounter.", 0, Integer.MAX_VALUE, this.appointment));
        children.add(new Property("virtualService", "VirtualServiceDetail", "Connection details of a virtual service (e.g. conference call).", 0, Integer.MAX_VALUE, this.virtualService));
        children.add(new Property("actualPeriod", "Period", "The actual start and end time of the encounter.", 0, 1, this.actualPeriod));
        children.add(new Property("plannedStartDate", "dateTime", "The planned start date/time (or admission date) of the encounter.", 0, 1, this.plannedStartDate));
        children.add(new Property("plannedEndDate", "dateTime", "The planned end date/time (or discharge date) of the encounter.", 0, 1, this.plannedEndDate));
        children.add(new Property(SP_LENGTH, "Duration", "Actual quantity of time the encounter lasted. This excludes the time during leaves of absence.\r\rWhen missing it is the time in between the start and end values.", 0, 1, this.length));
        children.add(new Property("reason", "", "The list of medical reasons that are expected to be addressed during the episode of care.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("diagnosis", "", "The list of diagnosis relevant to this encounter.", 0, Integer.MAX_VALUE, this.diagnosis));
        children.add(new Property(SP_ACCOUNT, "Reference(Account)", "The set of accounts that may be used for billing for this Encounter.", 0, Integer.MAX_VALUE, this.account));
        children.add(new Property("dietPreference", "CodeableConcept", "Diet preferences reported by the patient.", 0, Integer.MAX_VALUE, this.dietPreference));
        children.add(new Property("specialArrangement", "CodeableConcept", "Any special requests that have been made for this encounter, such as the provision of specific equipment or other things.", 0, Integer.MAX_VALUE, this.specialArrangement));
        children.add(new Property("specialCourtesy", "CodeableConcept", "Special courtesies that may be provided to the patient during the encounter (VIP, board member, professional courtesy).", 0, Integer.MAX_VALUE, this.specialCourtesy));
        children.add(new Property("admission", "", "Details about the stay during which a healthcare service is provided.\r\rThis does not describe the event of admitting the patient, but rather any information that is relevant from the time of admittance until the time of discharge.", 0, 1, this.admission));
        children.add(new Property(SP_LOCATION, "", "List of locations where  the patient has been during this encounter.", 0, Integer.MAX_VALUE, this.location));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the encounter (not the state of the patient within the encounter - that is subjectState).", 0, 1, this.status);
            }
            case 94742904: {
                return new Property(SP_CLASS, "CodeableConcept", "Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.", 0, Integer.MAX_VALUE, this.class_);
            }
            case -1165461084: {
                return new Property("priority", "CodeableConcept", "Indicates the urgency of the encounter.", 0, 1, this.priority);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type);
            }
            case -1928370289: {
                return new Property("serviceType", "CodeableReference(HealthcareService)", "Broad categorization of the service that is to be provided (e.g. cardiology).", 0, Integer.MAX_VALUE, this.serviceType);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group related to this encounter. In some use-cases the patient MAY not be present, such as a case meeting about a patient between several practitioners or a careteam.", 0, 1, this.subject);
            }
            case 110854206: {
                return new Property("subjectStatus", "CodeableConcept", "The subjectStatus value can be used to track the patient's status within the encounter. It details whether the patient has arrived or departed, has been triaged or is currently in a waiting status.", 0, 1, this.subjectStatus);
            }
            case -1892140189: {
                return new Property("episodeOfCare", "Reference(EpisodeOfCare)", "Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).", 0, Integer.MAX_VALUE, this.episodeOfCare);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|DeviceRequest|MedicationRequest|ServiceRequest)", "The request this encounter satisfies (e.g. incoming referral or procedure request).", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -7323378: {
                return new Property("careTeam", "Reference(CareTeam)", "The group(s) of individuals, organizations that are allocated to participate in this encounter. The participants backbone will record the actuals of when these individuals participated during the encounter.", 0, Integer.MAX_VALUE, this.careTeam);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Encounter)", "Another Encounter of which this encounter is a part of (administratively or in time).", 0, 1, this.partOf);
            }
            case 243182534: {
                return new Property("serviceProvider", "Reference(Organization)", "The organization that is primarily responsible for this Encounter's services. This MAY be the same as the organization on the Patient record, however it could be different, such as if the actor performing the services was from an external organization (which may be billed seperately) for an external consultation.  Refer to the colonoscopy example on the Encounter examples tab.", 0, 1, this.serviceProvider);
            }
            case 767422259: {
                return new Property(SP_PARTICIPANT, "", "The list of people responsible for providing the service.", 0, Integer.MAX_VALUE, this.participant);
            }
            case -1474995297: {
                return new Property(SP_APPOINTMENT, "Reference(Appointment)", "The appointment that scheduled this encounter.", 0, Integer.MAX_VALUE, this.appointment);
            }
            case 1420774698: {
                return new Property("virtualService", "VirtualServiceDetail", "Connection details of a virtual service (e.g. conference call).", 0, Integer.MAX_VALUE, this.virtualService);
            }
            case 789194991: {
                return new Property("actualPeriod", "Period", "The actual start and end time of the encounter.", 0, 1, this.actualPeriod);
            }
            case 460857804: {
                return new Property("plannedStartDate", "dateTime", "The planned start date/time (or admission date) of the encounter.", 0, 1, this.plannedStartDate);
            }
            case 1657534661: {
                return new Property("plannedEndDate", "dateTime", "The planned end date/time (or discharge date) of the encounter.", 0, 1, this.plannedEndDate);
            }
            case -1106363674: {
                return new Property(SP_LENGTH, "Duration", "Actual quantity of time the encounter lasted. This excludes the time during leaves of absence.\r\rWhen missing it is the time in between the start and end values.", 0, 1, this.length);
            }
            case -934964668: {
                return new Property("reason", "", "The list of medical reasons that are expected to be addressed during the episode of care.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1196993265: {
                return new Property("diagnosis", "", "The list of diagnosis relevant to this encounter.", 0, Integer.MAX_VALUE, this.diagnosis);
            }
            case -1177318867: {
                return new Property(SP_ACCOUNT, "Reference(Account)", "The set of accounts that may be used for billing for this Encounter.", 0, Integer.MAX_VALUE, this.account);
            }
            case -1360641041: {
                return new Property("dietPreference", "CodeableConcept", "Diet preferences reported by the patient.", 0, Integer.MAX_VALUE, this.dietPreference);
            }
            case 47410321: {
                return new Property("specialArrangement", "CodeableConcept", "Any special requests that have been made for this encounter, such as the provision of specific equipment or other things.", 0, Integer.MAX_VALUE, this.specialArrangement);
            }
            case 1583588345: {
                return new Property("specialCourtesy", "CodeableConcept", "Special courtesies that may be provided to the patient during the encounter (VIP, board member, professional courtesy).", 0, Integer.MAX_VALUE, this.specialCourtesy);
            }
            case 27400201: {
                return new Property("admission", "", "Details about the stay during which a healthcare service is provided.\r\rThis does not describe the event of admitting the patient, but rather any information that is relevant from the time of admittance until the time of discharge.", 0, 1, this.admission);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "", "List of locations where  the patient has been during this encounter.", 0, Integer.MAX_VALUE, this.location);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 94742904: {
                return this.class_ == null ? new Base[]{} : this.class_.toArray(new Base[this.class_.size()]);
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.priority;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -1928370289: {
                return this.serviceType == null ? new Base[]{} : this.serviceType.toArray(new Base[this.serviceType.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 110854206: {
                Base[] baseArray;
                if (this.subjectStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subjectStatus;
                }
                return baseArray;
            }
            case -1892140189: {
                return this.episodeOfCare == null ? new Base[]{} : this.episodeOfCare.toArray(new Base[this.episodeOfCare.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -7323378: {
                return this.careTeam == null ? new Base[]{} : this.careTeam.toArray(new Base[this.careTeam.size()]);
            }
            case -995410646: {
                Base[] baseArray;
                if (this.partOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.partOf;
                }
                return baseArray;
            }
            case 243182534: {
                Base[] baseArray;
                if (this.serviceProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.serviceProvider;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -1474995297: {
                return this.appointment == null ? new Base[]{} : this.appointment.toArray(new Base[this.appointment.size()]);
            }
            case 1420774698: {
                return this.virtualService == null ? new Base[]{} : this.virtualService.toArray(new Base[this.virtualService.size()]);
            }
            case 789194991: {
                Base[] baseArray;
                if (this.actualPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.actualPeriod;
                }
                return baseArray;
            }
            case 460857804: {
                Base[] baseArray;
                if (this.plannedStartDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.plannedStartDate;
                }
                return baseArray;
            }
            case 1657534661: {
                Base[] baseArray;
                if (this.plannedEndDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.plannedEndDate;
                }
                return baseArray;
            }
            case -1106363674: {
                Base[] baseArray;
                if (this.length == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.length;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -1177318867: {
                return this.account == null ? new Base[]{} : this.account.toArray(new Base[this.account.size()]);
            }
            case -1360641041: {
                return this.dietPreference == null ? new Base[]{} : this.dietPreference.toArray(new Base[this.dietPreference.size()]);
            }
            case 47410321: {
                return this.specialArrangement == null ? new Base[]{} : this.specialArrangement.toArray(new Base[this.specialArrangement.size()]);
            }
            case 1583588345: {
                return this.specialCourtesy == null ? new Base[]{} : this.specialCourtesy.toArray(new Base[this.specialCourtesy.size()]);
            }
            case 27400201: {
                Base[] baseArray;
                if (this.admission == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.admission;
                }
                return baseArray;
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.EncounterStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 94742904: {
                this.getClass_().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1165461084: {
                this.priority = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1928370289: {
                this.getServiceType().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 110854206: {
                this.subjectStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1892140189: {
                this.getEpisodeOfCare().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -7323378: {
                this.getCareTeam().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -995410646: {
                this.partOf = TypeConvertor.castToReference(value);
                return value;
            }
            case 243182534: {
                this.serviceProvider = TypeConvertor.castToReference(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((EncounterParticipantComponent)((Object)value));
                return value;
            }
            case -1474995297: {
                this.getAppointment().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1420774698: {
                this.getVirtualService().add(TypeConvertor.castToVirtualServiceDetail(value));
                return value;
            }
            case 789194991: {
                this.actualPeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 460857804: {
                this.plannedStartDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1657534661: {
                this.plannedEndDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1106363674: {
                this.length = TypeConvertor.castToDuration(value);
                return value;
            }
            case -934964668: {
                this.getReason().add((ReasonComponent)((Object)value));
                return value;
            }
            case 1196993265: {
                this.getDiagnosis().add((DiagnosisComponent)((Object)value));
                return value;
            }
            case -1177318867: {
                this.getAccount().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1360641041: {
                this.getDietPreference().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 47410321: {
                this.getSpecialArrangement().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1583588345: {
                this.getSpecialCourtesy().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 27400201: {
                this.admission = (EncounterAdmissionComponent)((Object)value);
                return value;
            }
            case 1901043637: {
                this.getLocation().add((EncounterLocationComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.EncounterStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CLASS)) {
            this.getClass_().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("priority")) {
            this.priority = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("serviceType")) {
            this.getServiceType().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("subjectStatus")) {
            this.subjectStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("episodeOfCare")) {
            this.getEpisodeOfCare().add(TypeConvertor.castToReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("careTeam")) {
            this.getCareTeam().add(TypeConvertor.castToReference(value));
        } else if (name.equals("partOf")) {
            this.partOf = TypeConvertor.castToReference(value);
        } else if (name.equals("serviceProvider")) {
            this.serviceProvider = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((EncounterParticipantComponent)((Object)value));
        } else if (name.equals(SP_APPOINTMENT)) {
            this.getAppointment().add(TypeConvertor.castToReference(value));
        } else if (name.equals("virtualService")) {
            this.getVirtualService().add(TypeConvertor.castToVirtualServiceDetail(value));
        } else if (name.equals("actualPeriod")) {
            this.actualPeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("plannedStartDate")) {
            this.plannedStartDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("plannedEndDate")) {
            this.plannedEndDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_LENGTH)) {
            this.length = TypeConvertor.castToDuration(value);
        } else if (name.equals("reason")) {
            this.getReason().add((ReasonComponent)((Object)value));
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().add((DiagnosisComponent)((Object)value));
        } else if (name.equals(SP_ACCOUNT)) {
            this.getAccount().add(TypeConvertor.castToReference(value));
        } else if (name.equals("dietPreference")) {
            this.getDietPreference().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("specialArrangement")) {
            this.getSpecialArrangement().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("specialCourtesy")) {
            this.getSpecialCourtesy().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("admission")) {
            this.admission = (EncounterAdmissionComponent)((Object)value);
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add((EncounterLocationComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.EncounterStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CLASS)) {
            this.getClass_().remove(value);
        } else if (name.equals("priority")) {
            this.priority = null;
        } else if (name.equals(SP_TYPE)) {
            this.getType().remove(value);
        } else if (name.equals("serviceType")) {
            this.getServiceType().remove(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals("subjectStatus")) {
            this.subjectStatus = null;
        } else if (name.equals("episodeOfCare")) {
            this.getEpisodeOfCare().remove(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().remove(value);
        } else if (name.equals("careTeam")) {
            this.getCareTeam().remove(value);
        } else if (name.equals("partOf")) {
            this.partOf = null;
        } else if (name.equals("serviceProvider")) {
            this.serviceProvider = null;
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().remove((EncounterParticipantComponent)((Object)value));
        } else if (name.equals(SP_APPOINTMENT)) {
            this.getAppointment().remove(value);
        } else if (name.equals("virtualService")) {
            this.getVirtualService().remove(value);
        } else if (name.equals("actualPeriod")) {
            this.actualPeriod = null;
        } else if (name.equals("plannedStartDate")) {
            this.plannedStartDate = null;
        } else if (name.equals("plannedEndDate")) {
            this.plannedEndDate = null;
        } else if (name.equals(SP_LENGTH)) {
            this.length = null;
        } else if (name.equals("reason")) {
            this.getReason().remove((ReasonComponent)((Object)value));
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().remove((DiagnosisComponent)((Object)value));
        } else if (name.equals(SP_ACCOUNT)) {
            this.getAccount().remove(value);
        } else if (name.equals("dietPreference")) {
            this.getDietPreference().remove(value);
        } else if (name.equals("specialArrangement")) {
            this.getSpecialArrangement().remove(value);
        } else if (name.equals("specialCourtesy")) {
            this.getSpecialCourtesy().remove(value);
        } else if (name.equals("admission")) {
            this.admission = (EncounterAdmissionComponent)((Object)value);
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().remove((EncounterLocationComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 94742904: {
                return this.addClass_();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case 3575610: {
                return this.addType();
            }
            case -1928370289: {
                return this.addServiceType();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 110854206: {
                return this.getSubjectStatus();
            }
            case -1892140189: {
                return this.addEpisodeOfCare();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -7323378: {
                return this.addCareTeam();
            }
            case -995410646: {
                return this.getPartOf();
            }
            case 243182534: {
                return this.getServiceProvider();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case -1474995297: {
                return this.addAppointment();
            }
            case 1420774698: {
                return this.addVirtualService();
            }
            case 789194991: {
                return this.getActualPeriod();
            }
            case 460857804: {
                return this.getPlannedStartDateElement();
            }
            case 1657534661: {
                return this.getPlannedEndDateElement();
            }
            case -1106363674: {
                return this.getLength();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -1177318867: {
                return this.addAccount();
            }
            case -1360641041: {
                return this.addDietPreference();
            }
            case 47410321: {
                return this.addSpecialArrangement();
            }
            case 1583588345: {
                return this.addSpecialCourtesy();
            }
            case 27400201: {
                return this.getAdmission();
            }
            case 1901043637: {
                return this.addLocation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 94742904: {
                return new String[]{"CodeableConcept"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1928370289: {
                return new String[]{"CodeableReference"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 110854206: {
                return new String[]{"CodeableConcept"};
            }
            case -1892140189: {
                return new String[]{"Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -7323378: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case 243182534: {
                return new String[]{"Reference"};
            }
            case 767422259: {
                return new String[0];
            }
            case -1474995297: {
                return new String[]{"Reference"};
            }
            case 1420774698: {
                return new String[]{"VirtualServiceDetail"};
            }
            case 789194991: {
                return new String[]{"Period"};
            }
            case 460857804: {
                return new String[]{"dateTime"};
            }
            case 1657534661: {
                return new String[]{"dateTime"};
            }
            case -1106363674: {
                return new String[]{"Duration"};
            }
            case -934964668: {
                return new String[0];
            }
            case 1196993265: {
                return new String[0];
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
            case -1360641041: {
                return new String[]{"CodeableConcept"};
            }
            case 47410321: {
                return new String[]{"CodeableConcept"};
            }
            case 1583588345: {
                return new String[]{"CodeableConcept"};
            }
            case 27400201: {
                return new String[0];
            }
            case 1901043637: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Encounter.status");
        }
        if (name.equals(SP_CLASS)) {
            return this.addClass_();
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals("serviceType")) {
            return this.addServiceType();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("subjectStatus")) {
            this.subjectStatus = new CodeableConcept();
            return this.subjectStatus;
        }
        if (name.equals("episodeOfCare")) {
            return this.addEpisodeOfCare();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("careTeam")) {
            return this.addCareTeam();
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        if (name.equals("serviceProvider")) {
            this.serviceProvider = new Reference();
            return this.serviceProvider;
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals(SP_APPOINTMENT)) {
            return this.addAppointment();
        }
        if (name.equals("virtualService")) {
            return this.addVirtualService();
        }
        if (name.equals("actualPeriod")) {
            this.actualPeriod = new Period();
            return this.actualPeriod;
        }
        if (name.equals("plannedStartDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Encounter.plannedStartDate");
        }
        if (name.equals("plannedEndDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Encounter.plannedEndDate");
        }
        if (name.equals(SP_LENGTH)) {
            this.length = new Duration();
            return this.length;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("diagnosis")) {
            return this.addDiagnosis();
        }
        if (name.equals(SP_ACCOUNT)) {
            return this.addAccount();
        }
        if (name.equals("dietPreference")) {
            return this.addDietPreference();
        }
        if (name.equals("specialArrangement")) {
            return this.addSpecialArrangement();
        }
        if (name.equals("specialCourtesy")) {
            return this.addSpecialCourtesy();
        }
        if (name.equals("admission")) {
            this.admission = new EncounterAdmissionComponent();
            return this.admission;
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Encounter";
    }

    @Override
    public Encounter copy() {
        Encounter dst = new Encounter();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Encounter dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<Enumerations.EncounterStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.class_ != null) {
            dst.class_ = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.class_) {
                dst.class_.add(codeableConcept.copy());
            }
        }
        CodeableConcept codeableConcept = dst.priority = this.priority == null ? null : this.priority.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.type) {
                dst.type.add(codeableConcept2.copy());
            }
        }
        if (this.serviceType != null) {
            dst.serviceType = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.serviceType) {
                dst.serviceType.add(codeableReference.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        CodeableConcept codeableConcept3 = dst.subjectStatus = this.subjectStatus == null ? null : this.subjectStatus.copy();
        if (this.episodeOfCare != null) {
            dst.episodeOfCare = new ArrayList<Reference>();
            for (Reference reference : this.episodeOfCare) {
                dst.episodeOfCare.add(reference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.careTeam != null) {
            dst.careTeam = new ArrayList<Reference>();
            for (Reference reference : this.careTeam) {
                dst.careTeam.add(reference.copy());
            }
        }
        dst.partOf = this.partOf == null ? null : this.partOf.copy();
        Reference reference = dst.serviceProvider = this.serviceProvider == null ? null : this.serviceProvider.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<EncounterParticipantComponent>();
            for (EncounterParticipantComponent encounterParticipantComponent : this.participant) {
                dst.participant.add(encounterParticipantComponent.copy());
            }
        }
        if (this.appointment != null) {
            dst.appointment = new ArrayList<Reference>();
            for (Reference reference2 : this.appointment) {
                dst.appointment.add(reference2.copy());
            }
        }
        if (this.virtualService != null) {
            dst.virtualService = new ArrayList<VirtualServiceDetail>();
            for (VirtualServiceDetail virtualServiceDetail : this.virtualService) {
                dst.virtualService.add(virtualServiceDetail.copy());
            }
        }
        dst.actualPeriod = this.actualPeriod == null ? null : this.actualPeriod.copy();
        dst.plannedStartDate = this.plannedStartDate == null ? null : this.plannedStartDate.copy();
        dst.plannedEndDate = this.plannedEndDate == null ? null : this.plannedEndDate.copy();
        Duration duration = dst.length = this.length == null ? null : this.length.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<ReasonComponent>();
            for (ReasonComponent reasonComponent : this.reason) {
                dst.reason.add(reasonComponent.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        if (this.account != null) {
            dst.account = new ArrayList<Reference>();
            for (Reference reference3 : this.account) {
                dst.account.add(reference3.copy());
            }
        }
        if (this.dietPreference != null) {
            dst.dietPreference = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.dietPreference) {
                dst.dietPreference.add(codeableConcept4.copy());
            }
        }
        if (this.specialArrangement != null) {
            dst.specialArrangement = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept5 : this.specialArrangement) {
                dst.specialArrangement.add(codeableConcept5.copy());
            }
        }
        if (this.specialCourtesy != null) {
            dst.specialCourtesy = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept6 : this.specialCourtesy) {
                dst.specialCourtesy.add(codeableConcept6.copy());
            }
        }
        EncounterAdmissionComponent encounterAdmissionComponent = dst.admission = this.admission == null ? null : this.admission.copy();
        if (this.location != null) {
            dst.location = new ArrayList<EncounterLocationComponent>();
            for (EncounterLocationComponent encounterLocationComponent : this.location) {
                dst.location.add(encounterLocationComponent.copy());
            }
        }
    }

    protected Encounter typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Encounter)) {
            return false;
        }
        Encounter o = (Encounter)other_;
        return Encounter.compareDeep(this.identifier, o.identifier, true) && Encounter.compareDeep(this.status, o.status, true) && Encounter.compareDeep(this.class_, o.class_, true) && Encounter.compareDeep(this.priority, o.priority, true) && Encounter.compareDeep(this.type, o.type, true) && Encounter.compareDeep(this.serviceType, o.serviceType, true) && Encounter.compareDeep(this.subject, o.subject, true) && Encounter.compareDeep(this.subjectStatus, o.subjectStatus, true) && Encounter.compareDeep(this.episodeOfCare, o.episodeOfCare, true) && Encounter.compareDeep(this.basedOn, o.basedOn, true) && Encounter.compareDeep(this.careTeam, o.careTeam, true) && Encounter.compareDeep(this.partOf, o.partOf, true) && Encounter.compareDeep(this.serviceProvider, o.serviceProvider, true) && Encounter.compareDeep(this.participant, o.participant, true) && Encounter.compareDeep(this.appointment, o.appointment, true) && Encounter.compareDeep(this.virtualService, o.virtualService, true) && Encounter.compareDeep(this.actualPeriod, o.actualPeriod, true) && Encounter.compareDeep(this.plannedStartDate, o.plannedStartDate, true) && Encounter.compareDeep(this.plannedEndDate, o.plannedEndDate, true) && Encounter.compareDeep(this.length, o.length, true) && Encounter.compareDeep(this.reason, o.reason, true) && Encounter.compareDeep(this.diagnosis, o.diagnosis, true) && Encounter.compareDeep(this.account, o.account, true) && Encounter.compareDeep(this.dietPreference, o.dietPreference, true) && Encounter.compareDeep(this.specialArrangement, o.specialArrangement, true) && Encounter.compareDeep(this.specialCourtesy, o.specialCourtesy, true) && Encounter.compareDeep(this.admission, o.admission, true) && Encounter.compareDeep(this.location, o.location, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Encounter)) {
            return false;
        }
        Encounter o = (Encounter)other_;
        return Encounter.compareValues(this.status, o.status, true) && Encounter.compareValues(this.plannedStartDate, o.plannedStartDate, true) && Encounter.compareValues(this.plannedEndDate, o.plannedEndDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.class_, this.priority, this.type, this.serviceType, this.subject, this.subjectStatus, this.episodeOfCare, this.basedOn, this.careTeam, this.partOf, this.serviceProvider, this.participant, this.appointment, this.virtualService, this.actualPeriod, this.plannedStartDate, this.plannedEndDate, this.length, this.reason, this.diagnosis, this.account, this.dietPreference, this.specialArrangement, this.specialCourtesy, this.admission, this.location});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Encounter;
    }

    @Block
    public static class EncounterParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Role of participant in encounter", formalDefinition="Role of participant in encounter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
        protected List<CodeableConcept> type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period of time during the encounter that the participant participated", formalDefinition="The period of time that the specified participant participated in the encounter. These can overlap or be sub-sets of the overall encounter's period.")
        protected Period period;
        @Child(name="actor", type={Patient.class, Group.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Device.class, HealthcareService.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The individual, device, or service participating in the encounter", formalDefinition="Person involved in the encounter, the patient/group is also included here to indicate that the patient was actually participating in the encounter. Not including the patient here covers use cases such as a case meeting between practitioners about a patient - non contact times.")
        protected Reference actor;
        private static final long serialVersionUID = 1982623707L;

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public EncounterParticipantComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public EncounterParticipantComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterParticipantComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EncounterParticipantComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public EncounterParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_TYPE, "CodeableConcept", "Role of participant in encounter.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("period", "Period", "The period of time that the specified participant participated in the encounter. These can overlap or be sub-sets of the overall encounter's period.", 0, 1, this.period));
            children.add(new Property("actor", "Reference(Patient|Group|RelatedPerson|Practitioner|PractitionerRole|Device|HealthcareService)", "Person involved in the encounter, the patient/group is also included here to indicate that the patient was actually participating in the encounter. Not including the patient here covers use cases such as a case meeting between practitioners about a patient - non contact times.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Encounter.SP_TYPE, "CodeableConcept", "Role of participant in encounter.", 0, Integer.MAX_VALUE, this.type);
                }
                case -991726143: {
                    return new Property("period", "Period", "The period of time that the specified participant participated in the encounter. These can overlap or be sub-sets of the overall encounter's period.", 0, 1, this.period);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Patient|Group|RelatedPerson|Practitioner|PractitionerRole|Device|HealthcareService)", "Person involved in the encounter, the patient/group is also included here to indicate that the patient was actually participating in the encounter. Not including the patient here covers use cases such as a case meeting between practitioners about a patient - non contact times.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.period;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_TYPE)) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_TYPE)) {
                this.getType().remove(value);
            } else if (name.equals("period")) {
                this.period = null;
            } else if (name.equals("actor")) {
                this.actor = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_TYPE)) {
                return this.addType();
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterParticipantComponent copy() {
            EncounterParticipantComponent dst = new EncounterParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EncounterParticipantComponent dst) {
            super.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.period = this.period == null ? null : this.period.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterParticipantComponent)) {
                return false;
            }
            EncounterParticipantComponent o = (EncounterParticipantComponent)other_;
            return EncounterParticipantComponent.compareDeep(this.type, o.type, true) && EncounterParticipantComponent.compareDeep(this.period, o.period, true) && EncounterParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterParticipantComponent)) {
                return false;
            }
            EncounterParticipantComponent o = (EncounterParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.period, this.actor});
        }

        @Override
        public String fhirType() {
            return "Encounter.participant";
        }
    }

    @Block
    public static class ReasonComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="use", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="What the reason value should be used for/as", formalDefinition="What the reason value should be used as e.g. Chief Complaint, Health Concern, Health Maintenance (including screening).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-reason-use")
        protected List<CodeableConcept> use;
        @Child(name="value", type={CodeableReference.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Reason the encounter takes place (core or reference)", formalDefinition="Reason the encounter takes place, expressed as a code or a reference to another resource. For admissions, this can be used for a coded admission diagnosis.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-reason")
        protected List<CodeableReference> value;
        private static final long serialVersionUID = 1305979913L;

        public List<CodeableConcept> getUse() {
            if (this.use == null) {
                this.use = new ArrayList<CodeableConcept>();
            }
            return this.use;
        }

        public ReasonComponent setUse(List<CodeableConcept> theUse) {
            this.use = theUse;
            return this;
        }

        public boolean hasUse() {
            if (this.use == null) {
                return false;
            }
            for (CodeableConcept item : this.use) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addUse() {
            CodeableConcept t = new CodeableConcept();
            if (this.use == null) {
                this.use = new ArrayList<CodeableConcept>();
            }
            this.use.add(t);
            return t;
        }

        public ReasonComponent addUse(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.use == null) {
                this.use = new ArrayList<CodeableConcept>();
            }
            this.use.add(t);
            return this;
        }

        public CodeableConcept getUseFirstRep() {
            if (this.getUse().isEmpty()) {
                this.addUse();
            }
            return this.getUse().get(0);
        }

        public List<CodeableReference> getValue() {
            if (this.value == null) {
                this.value = new ArrayList<CodeableReference>();
            }
            return this.value;
        }

        public ReasonComponent setValue(List<CodeableReference> theValue) {
            this.value = theValue;
            return this;
        }

        public boolean hasValue() {
            if (this.value == null) {
                return false;
            }
            for (CodeableReference item : this.value) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addValue() {
            CodeableReference t = new CodeableReference();
            if (this.value == null) {
                this.value = new ArrayList<CodeableReference>();
            }
            this.value.add(t);
            return t;
        }

        public ReasonComponent addValue(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.value == null) {
                this.value = new ArrayList<CodeableReference>();
            }
            this.value.add(t);
            return this;
        }

        public CodeableReference getValueFirstRep() {
            if (this.getValue().isEmpty()) {
                this.addValue();
            }
            return this.getValue().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("use", "CodeableConcept", "What the reason value should be used as e.g. Chief Complaint, Health Concern, Health Maintenance (including screening).", 0, Integer.MAX_VALUE, this.use));
            children.add(new Property("value", "CodeableReference(Condition|DiagnosticReport|Observation|ImmunizationRecommendation|Procedure)", "Reason the encounter takes place, expressed as a code or a reference to another resource. For admissions, this can be used for a coded admission diagnosis.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 116103: {
                    return new Property("use", "CodeableConcept", "What the reason value should be used as e.g. Chief Complaint, Health Concern, Health Maintenance (including screening).", 0, Integer.MAX_VALUE, this.use);
                }
                case 111972721: {
                    return new Property("value", "CodeableReference(Condition|DiagnosticReport|Observation|ImmunizationRecommendation|Procedure)", "Reason the encounter takes place, expressed as a code or a reference to another resource. For admissions, this can be used for a coded admission diagnosis.", 0, Integer.MAX_VALUE, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116103: {
                    return this.use == null ? new Base[]{} : this.use.toArray(new Base[this.use.size()]);
                }
                case 111972721: {
                    return this.value == null ? new Base[]{} : this.value.toArray(new Base[this.value.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116103: {
                    this.getUse().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 111972721: {
                    this.getValue().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("use")) {
                this.getUse().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("value")) {
                this.getValue().add(TypeConvertor.castToCodeableReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("use")) {
                this.getUse().remove(value);
            } else if (name.equals("value")) {
                this.getValue().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116103: {
                    return this.addUse();
                }
                case 111972721: {
                    return this.addValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116103: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableReference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("use")) {
                return this.addUse();
            }
            if (name.equals("value")) {
                return this.addValue();
            }
            return super.addChild(name);
        }

        @Override
        public ReasonComponent copy() {
            ReasonComponent dst = new ReasonComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ReasonComponent dst) {
            super.copyValues(dst);
            if (this.use != null) {
                dst.use = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.use) {
                    dst.use.add(codeableConcept.copy());
                }
            }
            if (this.value != null) {
                dst.value = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.value) {
                    dst.value.add(codeableReference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ReasonComponent)) {
                return false;
            }
            ReasonComponent o = (ReasonComponent)other_;
            return ReasonComponent.compareDeep(this.use, o.use, true) && ReasonComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ReasonComponent)) {
                return false;
            }
            ReasonComponent o = (ReasonComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.use, this.value});
        }

        @Override
        public String fhirType() {
            return "Encounter.reason";
        }
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="condition", type={CodeableReference.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The diagnosis relevant to the encounter", formalDefinition="The coded diagnosis or a reference to a Condition (with other resources referenced in the evidence.detail), the use property will indicate the purpose of this specific diagnosis.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/condition-code")
        protected List<CodeableReference> condition;
        @Child(name="use", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026)", formalDefinition="Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-diagnosis-use")
        protected List<CodeableConcept> use;
        private static final long serialVersionUID = 1029565663L;

        public List<CodeableReference> getCondition() {
            if (this.condition == null) {
                this.condition = new ArrayList<CodeableReference>();
            }
            return this.condition;
        }

        public DiagnosisComponent setCondition(List<CodeableReference> theCondition) {
            this.condition = theCondition;
            return this;
        }

        public boolean hasCondition() {
            if (this.condition == null) {
                return false;
            }
            for (CodeableReference item : this.condition) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addCondition() {
            CodeableReference t = new CodeableReference();
            if (this.condition == null) {
                this.condition = new ArrayList<CodeableReference>();
            }
            this.condition.add(t);
            return t;
        }

        public DiagnosisComponent addCondition(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.condition == null) {
                this.condition = new ArrayList<CodeableReference>();
            }
            this.condition.add(t);
            return this;
        }

        public CodeableReference getConditionFirstRep() {
            if (this.getCondition().isEmpty()) {
                this.addCondition();
            }
            return this.getCondition().get(0);
        }

        public List<CodeableConcept> getUse() {
            if (this.use == null) {
                this.use = new ArrayList<CodeableConcept>();
            }
            return this.use;
        }

        public DiagnosisComponent setUse(List<CodeableConcept> theUse) {
            this.use = theUse;
            return this;
        }

        public boolean hasUse() {
            if (this.use == null) {
                return false;
            }
            for (CodeableConcept item : this.use) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addUse() {
            CodeableConcept t = new CodeableConcept();
            if (this.use == null) {
                this.use = new ArrayList<CodeableConcept>();
            }
            this.use.add(t);
            return t;
        }

        public DiagnosisComponent addUse(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.use == null) {
                this.use = new ArrayList<CodeableConcept>();
            }
            this.use.add(t);
            return this;
        }

        public CodeableConcept getUseFirstRep() {
            if (this.getUse().isEmpty()) {
                this.addUse();
            }
            return this.getUse().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("condition", "CodeableReference(Condition)", "The coded diagnosis or a reference to a Condition (with other resources referenced in the evidence.detail), the use property will indicate the purpose of this specific diagnosis.", 0, Integer.MAX_VALUE, this.condition));
            children.add(new Property("use", "CodeableConcept", "Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026).", 0, Integer.MAX_VALUE, this.use));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -861311717: {
                    return new Property("condition", "CodeableReference(Condition)", "The coded diagnosis or a reference to a Condition (with other resources referenced in the evidence.detail), the use property will indicate the purpose of this specific diagnosis.", 0, Integer.MAX_VALUE, this.condition);
                }
                case 116103: {
                    return new Property("use", "CodeableConcept", "Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026).", 0, Integer.MAX_VALUE, this.use);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return this.condition == null ? new Base[]{} : this.condition.toArray(new Base[this.condition.size()]);
                }
                case 116103: {
                    return this.use == null ? new Base[]{} : this.use.toArray(new Base[this.use.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    this.getCondition().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case 116103: {
                    this.getUse().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("condition")) {
                this.getCondition().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("use")) {
                this.getUse().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("condition")) {
                this.getCondition().remove(value);
            } else if (name.equals("use")) {
                this.getUse().remove(value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return this.addCondition();
                }
                case 116103: {
                    return this.addUse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return new String[]{"CodeableReference"};
                }
                case 116103: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("condition")) {
                return this.addCondition();
            }
            if (name.equals("use")) {
                return this.addUse();
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DiagnosisComponent dst) {
            super.copyValues(dst);
            if (this.condition != null) {
                dst.condition = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.condition) {
                    dst.condition.add(codeableReference.copy());
                }
            }
            if (this.use != null) {
                dst.use = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.use) {
                    dst.use.add(codeableConcept.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareDeep(this.condition, o.condition, true) && DiagnosisComponent.compareDeep(this.use, o.use, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.condition, this.use});
        }

        @Override
        public String fhirType() {
            return "Encounter.diagnosis";
        }
    }

    @Block
    public static class EncounterAdmissionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="preAdmissionIdentifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pre-admission identifier", formalDefinition="Pre-admission identifier.")
        protected Identifier preAdmissionIdentifier;
        @Child(name="origin", type={Location.class, Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The location/organization from which the patient came before admission", formalDefinition="The location/organization from which the patient came before admission.")
        protected Reference origin;
        @Child(name="admitSource", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="From where patient was admitted (physician referral, transfer)", formalDefinition="From where patient was admitted (physician referral, transfer).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-admit-source")
        protected CodeableConcept admitSource;
        @Child(name="reAdmission", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates that the patient is being re-admitted", formalDefinition="Indicates that this encounter is directly related to a prior admission, often because the conditions addressed in the prior admission were not fully addressed.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0092")
        protected CodeableConcept reAdmission;
        @Child(name="destination", type={Location.class, Organization.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location/organization to which the patient is discharged", formalDefinition="Location/organization to which the patient is discharged.")
        protected Reference destination;
        @Child(name="dischargeDisposition", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category or kind of location after discharge", formalDefinition="Category or kind of location after discharge.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-discharge-disposition")
        protected CodeableConcept dischargeDisposition;
        private static final long serialVersionUID = -1702856594L;

        public Identifier getPreAdmissionIdentifier() {
            if (this.preAdmissionIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterAdmissionComponent.preAdmissionIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.preAdmissionIdentifier = new Identifier();
                }
            }
            return this.preAdmissionIdentifier;
        }

        public boolean hasPreAdmissionIdentifier() {
            return this.preAdmissionIdentifier != null && !this.preAdmissionIdentifier.isEmpty();
        }

        public EncounterAdmissionComponent setPreAdmissionIdentifier(Identifier value) {
            this.preAdmissionIdentifier = value;
            return this;
        }

        public Reference getOrigin() {
            if (this.origin == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterAdmissionComponent.origin");
                }
                if (Configuration.doAutoCreate()) {
                    this.origin = new Reference();
                }
            }
            return this.origin;
        }

        public boolean hasOrigin() {
            return this.origin != null && !this.origin.isEmpty();
        }

        public EncounterAdmissionComponent setOrigin(Reference value) {
            this.origin = value;
            return this;
        }

        public CodeableConcept getAdmitSource() {
            if (this.admitSource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterAdmissionComponent.admitSource");
                }
                if (Configuration.doAutoCreate()) {
                    this.admitSource = new CodeableConcept();
                }
            }
            return this.admitSource;
        }

        public boolean hasAdmitSource() {
            return this.admitSource != null && !this.admitSource.isEmpty();
        }

        public EncounterAdmissionComponent setAdmitSource(CodeableConcept value) {
            this.admitSource = value;
            return this;
        }

        public CodeableConcept getReAdmission() {
            if (this.reAdmission == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterAdmissionComponent.reAdmission");
                }
                if (Configuration.doAutoCreate()) {
                    this.reAdmission = new CodeableConcept();
                }
            }
            return this.reAdmission;
        }

        public boolean hasReAdmission() {
            return this.reAdmission != null && !this.reAdmission.isEmpty();
        }

        public EncounterAdmissionComponent setReAdmission(CodeableConcept value) {
            this.reAdmission = value;
            return this;
        }

        public Reference getDestination() {
            if (this.destination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterAdmissionComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destination = new Reference();
                }
            }
            return this.destination;
        }

        public boolean hasDestination() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public EncounterAdmissionComponent setDestination(Reference value) {
            this.destination = value;
            return this;
        }

        public CodeableConcept getDischargeDisposition() {
            if (this.dischargeDisposition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterAdmissionComponent.dischargeDisposition");
                }
                if (Configuration.doAutoCreate()) {
                    this.dischargeDisposition = new CodeableConcept();
                }
            }
            return this.dischargeDisposition;
        }

        public boolean hasDischargeDisposition() {
            return this.dischargeDisposition != null && !this.dischargeDisposition.isEmpty();
        }

        public EncounterAdmissionComponent setDischargeDisposition(CodeableConcept value) {
            this.dischargeDisposition = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("preAdmissionIdentifier", "Identifier", "Pre-admission identifier.", 0, 1, this.preAdmissionIdentifier));
            children.add(new Property("origin", "Reference(Location|Organization)", "The location/organization from which the patient came before admission.", 0, 1, this.origin));
            children.add(new Property("admitSource", "CodeableConcept", "From where patient was admitted (physician referral, transfer).", 0, 1, this.admitSource));
            children.add(new Property("reAdmission", "CodeableConcept", "Indicates that this encounter is directly related to a prior admission, often because the conditions addressed in the prior admission were not fully addressed.", 0, 1, this.reAdmission));
            children.add(new Property("destination", "Reference(Location|Organization)", "Location/organization to which the patient is discharged.", 0, 1, this.destination));
            children.add(new Property("dischargeDisposition", "CodeableConcept", "Category or kind of location after discharge.", 0, 1, this.dischargeDisposition));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -965394961: {
                    return new Property("preAdmissionIdentifier", "Identifier", "Pre-admission identifier.", 0, 1, this.preAdmissionIdentifier);
                }
                case -1008619738: {
                    return new Property("origin", "Reference(Location|Organization)", "The location/organization from which the patient came before admission.", 0, 1, this.origin);
                }
                case 538887120: {
                    return new Property("admitSource", "CodeableConcept", "From where patient was admitted (physician referral, transfer).", 0, 1, this.admitSource);
                }
                case 669348630: {
                    return new Property("reAdmission", "CodeableConcept", "Indicates that this encounter is directly related to a prior admission, often because the conditions addressed in the prior admission were not fully addressed.", 0, 1, this.reAdmission);
                }
                case -1429847026: {
                    return new Property("destination", "Reference(Location|Organization)", "Location/organization to which the patient is discharged.", 0, 1, this.destination);
                }
                case 528065941: {
                    return new Property("dischargeDisposition", "CodeableConcept", "Category or kind of location after discharge.", 0, 1, this.dischargeDisposition);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    Base[] baseArray;
                    if (this.preAdmissionIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.preAdmissionIdentifier;
                    }
                    return baseArray;
                }
                case -1008619738: {
                    Base[] baseArray;
                    if (this.origin == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.origin;
                    }
                    return baseArray;
                }
                case 538887120: {
                    Base[] baseArray;
                    if (this.admitSource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.admitSource;
                    }
                    return baseArray;
                }
                case 669348630: {
                    Base[] baseArray;
                    if (this.reAdmission == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.reAdmission;
                    }
                    return baseArray;
                }
                case -1429847026: {
                    Base[] baseArray;
                    if (this.destination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.destination;
                    }
                    return baseArray;
                }
                case 528065941: {
                    Base[] baseArray;
                    if (this.dischargeDisposition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.dischargeDisposition;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    this.preAdmissionIdentifier = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case -1008619738: {
                    this.origin = TypeConvertor.castToReference(value);
                    return value;
                }
                case 538887120: {
                    this.admitSource = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 669348630: {
                    this.reAdmission = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1429847026: {
                    this.destination = TypeConvertor.castToReference(value);
                    return value;
                }
                case 528065941: {
                    this.dischargeDisposition = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("preAdmissionIdentifier")) {
                this.preAdmissionIdentifier = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("origin")) {
                this.origin = TypeConvertor.castToReference(value);
            } else if (name.equals("admitSource")) {
                this.admitSource = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reAdmission")) {
                this.reAdmission = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("destination")) {
                this.destination = TypeConvertor.castToReference(value);
            } else if (name.equals("dischargeDisposition")) {
                this.dischargeDisposition = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("preAdmissionIdentifier")) {
                this.preAdmissionIdentifier = null;
            } else if (name.equals("origin")) {
                this.origin = null;
            } else if (name.equals("admitSource")) {
                this.admitSource = null;
            } else if (name.equals("reAdmission")) {
                this.reAdmission = null;
            } else if (name.equals("destination")) {
                this.destination = null;
            } else if (name.equals("dischargeDisposition")) {
                this.dischargeDisposition = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    return this.getPreAdmissionIdentifier();
                }
                case -1008619738: {
                    return this.getOrigin();
                }
                case 538887120: {
                    return this.getAdmitSource();
                }
                case 669348630: {
                    return this.getReAdmission();
                }
                case -1429847026: {
                    return this.getDestination();
                }
                case 528065941: {
                    return this.getDischargeDisposition();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    return new String[]{"Identifier"};
                }
                case -1008619738: {
                    return new String[]{"Reference"};
                }
                case 538887120: {
                    return new String[]{"CodeableConcept"};
                }
                case 669348630: {
                    return new String[]{"CodeableConcept"};
                }
                case -1429847026: {
                    return new String[]{"Reference"};
                }
                case 528065941: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("preAdmissionIdentifier")) {
                this.preAdmissionIdentifier = new Identifier();
                return this.preAdmissionIdentifier;
            }
            if (name.equals("origin")) {
                this.origin = new Reference();
                return this.origin;
            }
            if (name.equals("admitSource")) {
                this.admitSource = new CodeableConcept();
                return this.admitSource;
            }
            if (name.equals("reAdmission")) {
                this.reAdmission = new CodeableConcept();
                return this.reAdmission;
            }
            if (name.equals("destination")) {
                this.destination = new Reference();
                return this.destination;
            }
            if (name.equals("dischargeDisposition")) {
                this.dischargeDisposition = new CodeableConcept();
                return this.dischargeDisposition;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterAdmissionComponent copy() {
            EncounterAdmissionComponent dst = new EncounterAdmissionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EncounterAdmissionComponent dst) {
            super.copyValues(dst);
            dst.preAdmissionIdentifier = this.preAdmissionIdentifier == null ? null : this.preAdmissionIdentifier.copy();
            dst.origin = this.origin == null ? null : this.origin.copy();
            dst.admitSource = this.admitSource == null ? null : this.admitSource.copy();
            dst.reAdmission = this.reAdmission == null ? null : this.reAdmission.copy();
            dst.destination = this.destination == null ? null : this.destination.copy();
            dst.dischargeDisposition = this.dischargeDisposition == null ? null : this.dischargeDisposition.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterAdmissionComponent)) {
                return false;
            }
            EncounterAdmissionComponent o = (EncounterAdmissionComponent)other_;
            return EncounterAdmissionComponent.compareDeep(this.preAdmissionIdentifier, o.preAdmissionIdentifier, true) && EncounterAdmissionComponent.compareDeep(this.origin, o.origin, true) && EncounterAdmissionComponent.compareDeep(this.admitSource, o.admitSource, true) && EncounterAdmissionComponent.compareDeep(this.reAdmission, o.reAdmission, true) && EncounterAdmissionComponent.compareDeep(this.destination, o.destination, true) && EncounterAdmissionComponent.compareDeep(this.dischargeDisposition, o.dischargeDisposition, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterAdmissionComponent)) {
                return false;
            }
            EncounterAdmissionComponent o = (EncounterAdmissionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.preAdmissionIdentifier, this.origin, this.admitSource, this.reAdmission, this.destination, this.dischargeDisposition});
        }

        @Override
        public String fhirType() {
            return "Encounter.admission";
        }
    }

    @Block
    public static class EncounterLocationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="location", type={Location.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location the encounter takes place", formalDefinition="The location where the encounter takes place.")
        protected Reference location;
        @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | active | reserved | completed", formalDefinition="The status of the participants' presence at the specified location during the period specified. If the participant is no longer at the location, then the period will have an end date/time.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-location-status")
        protected Enumeration<EncounterLocationStatus> status;
        @Child(name="form", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The physical type of the location (usually the level in the location hierarchy - bed, room, ward, virtual etc.)", formalDefinition="This will be used to specify the required levels (bed/ward/room/etc.) desired to be recorded to simplify either messaging or query.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/location-form")
        protected CodeableConcept form;
        @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time period during which the patient was present at the location", formalDefinition="Time period during which the patient was present at the location.")
        protected Period period;
        private static final long serialVersionUID = -1665957440L;

        public EncounterLocationComponent() {
        }

        public EncounterLocationComponent(Reference location) {
            this.setLocation(location);
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public EncounterLocationComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Enumeration<EncounterLocationStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EncounterLocationStatus>(new EncounterLocationStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public EncounterLocationComponent setStatusElement(Enumeration<EncounterLocationStatus> value) {
            this.status = value;
            return this;
        }

        public EncounterLocationStatus getStatus() {
            return this.status == null ? null : (EncounterLocationStatus)((Object)this.status.getValue());
        }

        public EncounterLocationComponent setStatus(EncounterLocationStatus value) {
            if (value == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration<EncounterLocationStatus>(new EncounterLocationStatusEnumFactory());
                }
                this.status.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getForm() {
            if (this.form == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.form");
                }
                if (Configuration.doAutoCreate()) {
                    this.form = new CodeableConcept();
                }
            }
            return this.form;
        }

        public boolean hasForm() {
            return this.form != null && !this.form.isEmpty();
        }

        public EncounterLocationComponent setForm(CodeableConcept value) {
            this.form = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EncounterLocationComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_LOCATION, "Reference(Location)", "The location where the encounter takes place.", 0, 1, this.location));
            children.add(new Property(Encounter.SP_STATUS, "code", "The status of the participants' presence at the specified location during the period specified. If the participant is no longer at the location, then the period will have an end date/time.", 0, 1, this.status));
            children.add(new Property("form", "CodeableConcept", "This will be used to specify the required levels (bed/ward/room/etc.) desired to be recorded to simplify either messaging or query.", 0, 1, this.form));
            children.add(new Property("period", "Period", "Time period during which the patient was present at the location.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1901043637: {
                    return new Property(Encounter.SP_LOCATION, "Reference(Location)", "The location where the encounter takes place.", 0, 1, this.location);
                }
                case -892481550: {
                    return new Property(Encounter.SP_STATUS, "code", "The status of the participants' presence at the specified location during the period specified. If the participant is no longer at the location, then the period will have an end date/time.", 0, 1, this.status);
                }
                case 3148996: {
                    return new Property("form", "CodeableConcept", "This will be used to specify the required levels (bed/ward/room/etc.) desired to be recorded to simplify either messaging or query.", 0, 1, this.form);
                }
                case -991726143: {
                    return new Property("period", "Period", "Time period during which the patient was present at the location.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.location;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case 3148996: {
                    Base[] baseArray;
                    if (this.form == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.form;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    this.location = TypeConvertor.castToReference(value);
                    return value;
                }
                case -892481550: {
                    value = new EncounterLocationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.status = value;
                    return value;
                }
                case 3148996: {
                    this.form = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_LOCATION)) {
                this.location = TypeConvertor.castToReference(value);
            } else if (name.equals(Encounter.SP_STATUS)) {
                value = new EncounterLocationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else if (name.equals("form")) {
                this.form = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_LOCATION)) {
                this.location = null;
            } else if (name.equals(Encounter.SP_STATUS)) {
                value = new EncounterLocationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else if (name.equals("form")) {
                this.form = null;
            } else if (name.equals("period")) {
                this.period = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return this.getLocation();
                }
                case -892481550: {
                    return this.getStatusElement();
                }
                case 3148996: {
                    return this.getForm();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case -892481550: {
                    return new String[]{"code"};
                }
                case 3148996: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_LOCATION)) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals(Encounter.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a singleton property Encounter.location.status");
            }
            if (name.equals("form")) {
                this.form = new CodeableConcept();
                return this.form;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterLocationComponent copy() {
            EncounterLocationComponent dst = new EncounterLocationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EncounterLocationComponent dst) {
            super.copyValues(dst);
            dst.location = this.location == null ? null : this.location.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.form = this.form == null ? null : this.form.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterLocationComponent)) {
                return false;
            }
            EncounterLocationComponent o = (EncounterLocationComponent)other_;
            return EncounterLocationComponent.compareDeep(this.location, o.location, true) && EncounterLocationComponent.compareDeep(this.status, o.status, true) && EncounterLocationComponent.compareDeep(this.form, o.form, true) && EncounterLocationComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterLocationComponent)) {
                return false;
            }
            EncounterLocationComponent o = (EncounterLocationComponent)other_;
            return EncounterLocationComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.location, this.status, this.form, this.period});
        }

        @Override
        public String fhirType() {
            return "Encounter.location";
        }
    }

    public static class EncounterLocationStatusEnumFactory
    implements EnumFactory<EncounterLocationStatus> {
        @Override
        public EncounterLocationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EncounterLocationStatus.PLANNED;
            }
            if ("active".equals(codeString)) {
                return EncounterLocationStatus.ACTIVE;
            }
            if ("reserved".equals(codeString)) {
                return EncounterLocationStatus.RESERVED;
            }
            if ("completed".equals(codeString)) {
                return EncounterLocationStatus.COMPLETED;
            }
            throw new IllegalArgumentException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        public Enumeration<EncounterLocationStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.NULL, code);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.PLANNED, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.ACTIVE, code);
            }
            if ("reserved".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.RESERVED, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.COMPLETED, code);
            }
            throw new FHIRException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EncounterLocationStatus code) {
            if (code == EncounterLocationStatus.NULL) {
                return null;
            }
            if (code == EncounterLocationStatus.PLANNED) {
                return "planned";
            }
            if (code == EncounterLocationStatus.ACTIVE) {
                return "active";
            }
            if (code == EncounterLocationStatus.RESERVED) {
                return "reserved";
            }
            if (code == EncounterLocationStatus.COMPLETED) {
                return "completed";
            }
            return "?";
        }

        @Override
        public String toSystem(EncounterLocationStatus code) {
            return code.getSystem();
        }
    }

    public static enum EncounterLocationStatus {
        PLANNED,
        ACTIVE,
        RESERVED,
        COMPLETED,
        NULL;


        public static EncounterLocationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("reserved".equals(codeString)) {
                return RESERVED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case ACTIVE: {
                    return "active";
                }
                case RESERVED: {
                    return "reserved";
                }
                case COMPLETED: {
                    return "completed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case RESERVED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "The patient is planned to be moved to this location at some point in the future.";
                }
                case ACTIVE: {
                    return "The patient is currently at this location, or was between the period specified.\r\rA system may update these records when the patient leaves the location to either reserved, or completed.";
                }
                case RESERVED: {
                    return "This location is held empty for this patient.";
                }
                case COMPLETED: {
                    return "The patient was at this location during the period specified.\r\rNot to be used when the patient is currently at the location.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case ACTIVE: {
                    return "Active";
                }
                case RESERVED: {
                    return "Reserved";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

