/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="ProductShelfLife")
public class ProductShelfLife
extends BackboneType
implements ICompositeType {
    @Child(name="type", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="This describes the shelf life, taking into account various scenarios such as shelf life of the packaged Medicinal Product itself, shelf life after transformation where necessary and shelf life after the first opening of a bottle, etc. The shelf life type shall be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified", formalDefinition="This describes the shelf life, taking into account various scenarios such as shelf life of the packaged Medicinal Product itself, shelf life after transformation where necessary and shelf life after the first opening of a bottle, etc. The shelf life type shall be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.")
    protected CodeableConcept type;
    @Child(name="period", type={Duration.class, StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used", formalDefinition="The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.")
    protected DataType period;
    @Child(name="specialPrecautionsForStorage", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Special precautions for storage, if any, can be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified", formalDefinition="Special precautions for storage, if any, can be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.")
    protected List<CodeableConcept> specialPrecautionsForStorage;
    private static final long serialVersionUID = 675017411L;

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProductShelfLife.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ProductShelfLife setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public DataType getPeriod() {
        return this.period;
    }

    public Duration getPeriodDuration() throws FHIRException {
        if (this.period == null) {
            this.period = new Duration();
        }
        if (!(this.period instanceof Duration)) {
            throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.period.getClass().getName() + " was encountered");
        }
        return (Duration)this.period;
    }

    public boolean hasPeriodDuration() {
        return this.period instanceof Duration;
    }

    public StringType getPeriodStringType() throws FHIRException {
        if (this.period == null) {
            this.period = new StringType();
        }
        if (!(this.period instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.period.getClass().getName() + " was encountered");
        }
        return (StringType)this.period;
    }

    public boolean hasPeriodStringType() {
        return this.period instanceof StringType;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ProductShelfLife setPeriod(DataType value) {
        if (value != null && !(value instanceof Duration) && !(value instanceof StringType)) {
            throw new FHIRException("Not the right type for ProductShelfLife.period[x]: " + value.fhirType());
        }
        this.period = value;
        return this;
    }

    public List<CodeableConcept> getSpecialPrecautionsForStorage() {
        if (this.specialPrecautionsForStorage == null) {
            this.specialPrecautionsForStorage = new ArrayList<CodeableConcept>();
        }
        return this.specialPrecautionsForStorage;
    }

    public ProductShelfLife setSpecialPrecautionsForStorage(List<CodeableConcept> theSpecialPrecautionsForStorage) {
        this.specialPrecautionsForStorage = theSpecialPrecautionsForStorage;
        return this;
    }

    public boolean hasSpecialPrecautionsForStorage() {
        if (this.specialPrecautionsForStorage == null) {
            return false;
        }
        for (CodeableConcept item : this.specialPrecautionsForStorage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialPrecautionsForStorage() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialPrecautionsForStorage == null) {
            this.specialPrecautionsForStorage = new ArrayList<CodeableConcept>();
        }
        this.specialPrecautionsForStorage.add(t);
        return t;
    }

    public ProductShelfLife addSpecialPrecautionsForStorage(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialPrecautionsForStorage == null) {
            this.specialPrecautionsForStorage = new ArrayList<CodeableConcept>();
        }
        this.specialPrecautionsForStorage.add(t);
        return this;
    }

    public CodeableConcept getSpecialPrecautionsForStorageFirstRep() {
        if (this.getSpecialPrecautionsForStorage().isEmpty()) {
            this.addSpecialPrecautionsForStorage();
        }
        return this.getSpecialPrecautionsForStorage().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "CodeableConcept", "This describes the shelf life, taking into account various scenarios such as shelf life of the packaged Medicinal Product itself, shelf life after transformation where necessary and shelf life after the first opening of a bottle, etc. The shelf life type shall be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.", 0, 1, this.type));
        children.add(new Property("period[x]", "Duration|string", "The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.period));
        children.add(new Property("specialPrecautionsForStorage", "CodeableConcept", "Special precautions for storage, if any, can be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.", 0, Integer.MAX_VALUE, this.specialPrecautionsForStorage));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "CodeableConcept", "This describes the shelf life, taking into account various scenarios such as shelf life of the packaged Medicinal Product itself, shelf life after transformation where necessary and shelf life after the first opening of a bottle, etc. The shelf life type shall be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.", 0, 1, this.type);
            }
            case 566594335: {
                return new Property("period[x]", "Duration|string", "The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.period);
            }
            case -991726143: {
                return new Property("period[x]", "Duration|string", "The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.period);
            }
            case -850078091: {
                return new Property("period[x]", "Duration", "The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.period);
            }
            case -41636558: {
                return new Property("period[x]", "string", "The shelf life time period can be specified using a numerical value for the period of time and its unit of time measurement The unit of measurement shall be specified in accordance with ISO 11240 and the resulting terminology The symbol and the symbol identifier shall be used.", 0, 1, this.period);
            }
            case 2103459492: {
                return new Property("specialPrecautionsForStorage", "CodeableConcept", "Special precautions for storage, if any, can be specified using an appropriate controlled vocabulary The controlled term and the controlled term identifier shall be specified.", 0, Integer.MAX_VALUE, this.specialPrecautionsForStorage);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.period;
                }
                return baseArray;
            }
            case 2103459492: {
                return this.specialPrecautionsForStorage == null ? new Base[]{} : this.specialPrecautionsForStorage.toArray(new Base[this.specialPrecautionsForStorage.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToType(value);
                return value;
            }
            case 2103459492: {
                this.getSpecialPrecautionsForStorage().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("period[x]")) {
            this.period = TypeConvertor.castToType(value);
        } else if (name.equals("specialPrecautionsForStorage")) {
            this.getSpecialPrecautionsForStorage().add(TypeConvertor.castToCodeableConcept(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            this.type = null;
        } else if (name.equals("period[x]")) {
            this.period = null;
        } else if (name.equals("specialPrecautionsForStorage")) {
            this.getSpecialPrecautionsForStorage().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getType();
            }
            case 566594335: {
                return this.getPeriod();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 2103459492: {
                return this.addSpecialPrecautionsForStorage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -991726143: {
                return new String[]{"Duration", "string"};
            }
            case 2103459492: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("periodDuration")) {
            this.period = new Duration();
            return this.period;
        }
        if (name.equals("periodString")) {
            this.period = new StringType();
            return this.period;
        }
        if (name.equals("specialPrecautionsForStorage")) {
            return this.addSpecialPrecautionsForStorage();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ProductShelfLife";
    }

    @Override
    public ProductShelfLife copy() {
        ProductShelfLife dst = new ProductShelfLife();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ProductShelfLife dst) {
        super.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        DataType dataType = dst.period = this.period == null ? null : this.period.copy();
        if (this.specialPrecautionsForStorage != null) {
            dst.specialPrecautionsForStorage = new ArrayList<CodeableConcept>();
            for (CodeableConcept i : this.specialPrecautionsForStorage) {
                dst.specialPrecautionsForStorage.add(i.copy());
            }
        }
    }

    protected ProductShelfLife typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ProductShelfLife)) {
            return false;
        }
        ProductShelfLife o = (ProductShelfLife)other_;
        return ProductShelfLife.compareDeep(this.type, o.type, true) && ProductShelfLife.compareDeep(this.period, o.period, true) && ProductShelfLife.compareDeep(this.specialPrecautionsForStorage, o.specialPrecautionsForStorage, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ProductShelfLife)) {
            return false;
        }
        ProductShelfLife o = (ProductShelfLife)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.period, this.specialPrecautionsForStorage});
    }
}

