/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.parser.DataFormatException;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="time")
public class TimeType
extends PrimitiveType<String> {
    private static final long serialVersionUID = 3L;

    public TimeType() {
    }

    public TimeType(String theValue) {
        this.setValue(theValue);
    }

    @Override
    protected String parse(String theValue) {
        return theValue;
    }

    @Override
    protected String encode(String theValue) {
        return theValue;
    }

    @Override
    public TimeType copy() {
        TimeType ret = new TimeType((String)this.getValue());
        this.copyValues(ret);
        return ret;
    }

    @Override
    public String fhirType() {
        return "time";
    }

    public int getHour() {
        String v = (String)this.getValue();
        if (v.length() < 2) {
            return 0;
        }
        if (!Utilities.isInteger((String)(v = v.substring(0, 2)))) {
            return 0;
        }
        return Integer.parseInt(v);
    }

    public int getMinute() {
        String v = (String)this.getValue();
        if (v.length() < 5) {
            return 0;
        }
        if (!Utilities.isInteger((String)(v = v.substring(3, 5)))) {
            return 0;
        }
        return Integer.parseInt(v);
    }

    public float getSecond() {
        String v = (String)this.getValue();
        if (v.length() < 8) {
            return 0.0f;
        }
        if (!Utilities.isDecimal((String)(v = v.substring(6)), (boolean)false, (boolean)true)) {
            return 0.0f;
        }
        return Float.parseFloat(v);
    }

    public TemporalPrecisionEnum getPrecision() {
        String v = (String)this.getValue();
        if (v.length() == 5) {
            return TemporalPrecisionEnum.MINUTE;
        }
        if (v.length() == 8) {
            return TemporalPrecisionEnum.SECOND;
        }
        if (v.length() > 9) {
            return TemporalPrecisionEnum.MILLI;
        }
        return null;
    }

    public void setPrecision(TemporalPrecisionEnum temp) {
        if (temp == TemporalPrecisionEnum.MINUTE) {
            this.setValue(((String)this.getValue()).substring(0, 5));
        }
        if (temp == TemporalPrecisionEnum.SECOND) {
            this.setValue(((String)this.getValue()).substring(0, 8));
        }
    }

    public void add(int theField, int theValue) {
        int hours = this.getHour();
        int minutes = this.getMinute();
        float seconds = this.getSecond();
        boolean hasMillis = this.getPrecision() == TemporalPrecisionEnum.MILLI;
        switch (theField) {
            case 10: {
                hours += theValue;
                break;
            }
            case 12: {
                minutes += theValue;
                break;
            }
            case 13: {
                seconds += (float)theValue;
                break;
            }
            case 14: {
                seconds += (float)theValue / 1000.0f;
                hasMillis = true;
                break;
            }
            default: {
                throw new DataFormatException("Unknown field constant: " + theField);
            }
        }
        if (seconds >= 60.0f) {
            minutes += (int)seconds / 60;
            seconds %= 60.0f;
        } else if (seconds < 0.0f) {
            minutes += (int)seconds / 60 - 1;
            seconds = 60.0f + seconds % 60.0f;
        }
        if (minutes >= 60) {
            hours += minutes / 60;
            minutes %= 60;
        } else if (minutes < 0) {
            hours += minutes / 60 - 1;
            minutes = 60 + minutes % 60;
        }
        if (hours >= 24) {
            hours %= 24;
        } else if (hours < 0) {
            hours = 24 + hours % 24;
        }
        if (hasMillis) {
            this.setValue(String.format("%02d:%02d:%06.3f", hours, minutes, Float.valueOf(seconds)));
        } else {
            this.setValue(String.format("%02d:%02d:%02d", hours, minutes, (int)seconds));
        }
    }

    @Override
    public String fpValue() {
        return "@T" + this.primitiveValue();
    }
}

