/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_TEXT;
import org.hl7.fhir.r5.openehr.PARTY;
import org.hl7.fhir.r5.openehr.PARTY_REF;

@DatatypeDef(name="ACTOR")
public abstract class ACTOR
extends PARTY
implements ICompositeType {
    @Child(name="languages", type={DV_TEXT.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Languages which can be used to communicate with this actor, in preferred order of use (if known, else order irrelevant)", formalDefinition="Languages which can be used to communicate with this actor, in preferred order of use (if known, else order irrelevant).")
    protected List<DV_TEXT> languagesList;
    @Child(name="roles", type={PARTY_REF.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Identifiers of the Version container for each Role played by this Party", formalDefinition="Identifiers of the Version container for each Role played by this Party.")
    protected List<PARTY_REF> rolesList;
    private static final long serialVersionUID = 635583100L;

    public List<DV_TEXT> getLanguagesList() {
        if (this.languagesList == null) {
            this.languagesList = new ArrayList<DV_TEXT>();
        }
        return this.languagesList;
    }

    public ACTOR setLanguagesList(List<DV_TEXT> theLanguages) {
        this.languagesList = theLanguages;
        return this;
    }

    public boolean hasLanguages() {
        if (this.languagesList == null) {
            return false;
        }
        for (DV_TEXT item : this.languagesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DV_TEXT addLanguages() {
        DV_TEXT t = new DV_TEXT();
        if (this.languagesList == null) {
            this.languagesList = new ArrayList<DV_TEXT>();
        }
        this.languagesList.add(t);
        return t;
    }

    public ACTOR addLanguages(DV_TEXT t) {
        if (t == null) {
            return this;
        }
        if (this.languagesList == null) {
            this.languagesList = new ArrayList<DV_TEXT>();
        }
        this.languagesList.add(t);
        return this;
    }

    public DV_TEXT getLanguagesFirstRep() {
        if (this.getLanguagesList().isEmpty()) {
            this.addLanguages();
        }
        return this.getLanguagesList().get(0);
    }

    public List<PARTY_REF> getRolesList() {
        if (this.rolesList == null) {
            this.rolesList = new ArrayList<PARTY_REF>();
        }
        return this.rolesList;
    }

    public ACTOR setRolesList(List<PARTY_REF> theRoles) {
        this.rolesList = theRoles;
        return this;
    }

    public boolean hasRoles() {
        if (this.rolesList == null) {
            return false;
        }
        for (PARTY_REF item : this.rolesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PARTY_REF addRoles() {
        PARTY_REF t = new PARTY_REF();
        if (this.rolesList == null) {
            this.rolesList = new ArrayList<PARTY_REF>();
        }
        this.rolesList.add(t);
        return t;
    }

    public ACTOR addRoles(PARTY_REF t) {
        if (t == null) {
            return this;
        }
        if (this.rolesList == null) {
            this.rolesList = new ArrayList<PARTY_REF>();
        }
        this.rolesList.add(t);
        return this;
    }

    public PARTY_REF getRolesFirstRep() {
        if (this.getRolesList().isEmpty()) {
            this.addRoles();
        }
        return this.getRolesList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("languages", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Languages which can be used to communicate with this actor, in preferred order of use (if known, else order irrelevant).", 0, Integer.MAX_VALUE, this.languagesList));
        children.add(new Property("roles", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Identifiers of the Version container for each Role played by this Party.", 0, Integer.MAX_VALUE, this.rolesList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1518327835: {
                return new Property("languages", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Languages which can be used to communicate with this actor, in preferred order of use (if known, else order irrelevant).", 0, Integer.MAX_VALUE, this.languagesList);
            }
            case 108695229: {
                return new Property("roles", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Identifiers of the Version container for each Role played by this Party.", 0, Integer.MAX_VALUE, this.rolesList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1518327835: {
                return this.languagesList == null ? new Base[]{} : this.languagesList.toArray(new Base[this.languagesList.size()]);
            }
            case 108695229: {
                return this.rolesList == null ? new Base[]{} : this.rolesList.toArray(new Base[this.rolesList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1518327835: {
                this.getLanguagesList().add((DV_TEXT)value);
                return value;
            }
            case 108695229: {
                this.getRolesList().add((PARTY_REF)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("languages")) {
            this.getLanguagesList().add((DV_TEXT)value);
        } else if (name.equals("roles")) {
            this.getRolesList().add((PARTY_REF)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1518327835: {
                return this.addLanguages();
            }
            case 108695229: {
                return this.addRoles();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1518327835: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
            case 108695229: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-REF"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("languages")) {
            return this.addLanguages();
        }
        if (name.equals("roles")) {
            return this.addRoles();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ACTOR";
    }

    @Override
    public abstract ACTOR copy();

    public void copyValues(ACTOR dst) {
        super.copyValues(dst);
        if (this.languagesList != null) {
            dst.languagesList = new ArrayList<DV_TEXT>();
            for (DV_TEXT dV_TEXT : this.languagesList) {
                dst.languagesList.add(dV_TEXT.copy());
            }
        }
        if (this.rolesList != null) {
            dst.rolesList = new ArrayList<PARTY_REF>();
            for (PARTY_REF pARTY_REF : this.rolesList) {
                dst.rolesList.add(pARTY_REF.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ACTOR)) {
            return false;
        }
        ACTOR o = (ACTOR)other_;
        return ACTOR.compareDeep(this.languagesList, o.languagesList, true) && ACTOR.compareDeep(this.rolesList, o.rolesList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ACTOR)) {
            return false;
        }
        ACTOR o = (ACTOR)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.languagesList, this.rolesList});
    }
}

