/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.DV_TEXT;
import org.hl7.fhir.r5.openehr.PARTY_PROXY;

@DatatypeDef(name="AUDIT_DETAILS")
public class AUDIT_DETAILS
extends LogicalBase
implements ICompositeType {
    @Child(name="system_id", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identifier of the logical EHR system where the change was committed", formalDefinition="Identifier of the logical EHR system where the change was committed. This is almost always owned by the organisation legally responsible for the EHR, and is distinct from any application, or any hosting infrastructure.")
    protected StringType system_id;
    @Child(name="time_committed", type={DV_DATE_TIME.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time of committal of the item", formalDefinition="Time of committal of the item.")
    protected DV_DATE_TIME time_committed;
    @Child(name="change_type", type={DV_CODED_TEXT.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of change", formalDefinition="Type of change. Coded using the openEHR Terminology audit change type group.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-audit_change_type")
    protected DV_CODED_TEXT change_type;
    @Child(name="description", type={DV_TEXT.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for committal. This may be used to qualify the value in the change_type field", formalDefinition="Reason for committal. This may be used to qualify the value in the change_type field. For example, if the change affects only the EHR directory, this field might be used to indicate 'Folder `episode 2018-02-16` added' or similar.")
    protected DV_TEXT description;
    @Child(name="committer", type={PARTY_PROXY.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identity and optional reference into identity management service, of user who committed the item", formalDefinition="Identity and optional reference into identity management service, of user who committed the item.")
    protected PARTY_PROXY committer;
    private static final long serialVersionUID = -1398858817L;

    public AUDIT_DETAILS() {
    }

    public AUDIT_DETAILS(String system_id, DV_DATE_TIME time_committed, DV_CODED_TEXT change_type, PARTY_PROXY committer) {
        this.setSystem_id(system_id);
        this.setTime_committed(time_committed);
        this.setChange_type(change_type);
        this.setCommitter(committer);
    }

    public StringType getSystem_idElement() {
        if (this.system_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AUDIT_DETAILS.system_id");
            }
            if (Configuration.doAutoCreate()) {
                this.system_id = new StringType();
            }
        }
        return this.system_id;
    }

    public boolean hasSystem_idElement() {
        return this.system_id != null && !this.system_id.isEmpty();
    }

    public boolean hasSystem_id() {
        return this.system_id != null && !this.system_id.isEmpty();
    }

    public AUDIT_DETAILS setSystem_idElement(StringType value) {
        this.system_id = value;
        return this;
    }

    public String getSystem_id() {
        return this.system_id == null ? null : (String)this.system_id.getValue();
    }

    public AUDIT_DETAILS setSystem_id(String value) {
        if (this.system_id == null) {
            this.system_id = new StringType();
        }
        this.system_id.setValue(value);
        return this;
    }

    public DV_DATE_TIME getTime_committed() {
        if (this.time_committed == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AUDIT_DETAILS.time_committed");
            }
            if (Configuration.doAutoCreate()) {
                this.time_committed = new DV_DATE_TIME();
            }
        }
        return this.time_committed;
    }

    public boolean hasTime_committed() {
        return this.time_committed != null && !this.time_committed.isEmpty();
    }

    public AUDIT_DETAILS setTime_committed(DV_DATE_TIME value) {
        this.time_committed = value;
        return this;
    }

    public DV_CODED_TEXT getChange_type() {
        if (this.change_type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AUDIT_DETAILS.change_type");
            }
            if (Configuration.doAutoCreate()) {
                this.change_type = new DV_CODED_TEXT();
            }
        }
        return this.change_type;
    }

    public boolean hasChange_type() {
        return this.change_type != null && !this.change_type.isEmpty();
    }

    public AUDIT_DETAILS setChange_type(DV_CODED_TEXT value) {
        this.change_type = value;
        return this;
    }

    public DV_TEXT getDescription() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AUDIT_DETAILS.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new DV_TEXT();
            }
        }
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public AUDIT_DETAILS setDescription(DV_TEXT value) {
        this.description = value;
        return this;
    }

    public PARTY_PROXY getCommitter() {
        return this.committer;
    }

    public boolean hasCommitter() {
        return this.committer != null && !this.committer.isEmpty();
    }

    public AUDIT_DETAILS setCommitter(PARTY_PROXY value) {
        this.committer = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("system_id", "string", "Identifier of the logical EHR system where the change was committed. This is almost always owned by the organisation legally responsible for the EHR, and is distinct from any application, or any hosting infrastructure.", 0, 1, this.system_id));
        children.add(new Property("time_committed", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of committal of the item.", 0, 1, this.time_committed));
        children.add(new Property("change_type", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Type of change. Coded using the openEHR Terminology audit change type group.", 0, 1, this.change_type));
        children.add(new Property("description", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Reason for committal. This may be used to qualify the value in the change_type field. For example, if the change affects only the EHR directory, this field might be used to indicate 'Folder `episode 2018-02-16` added' or similar.", 0, 1, this.description));
        children.add(new Property("committer", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Identity and optional reference into identity management service, of user who committed the item.", 0, 1, this.committer));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1129127211: {
                return new Property("system_id", "string", "Identifier of the logical EHR system where the change was committed. This is almost always owned by the organisation legally responsible for the EHR, and is distinct from any application, or any hosting infrastructure.", 0, 1, this.system_id);
            }
            case 2138761354: {
                return new Property("time_committed", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of committal of the item.", 0, 1, this.time_committed);
            }
            case -1654455703: {
                return new Property("change_type", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Type of change. Coded using the openEHR Terminology audit change type group.", 0, 1, this.change_type);
            }
            case -1724546052: {
                return new Property("description", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Reason for committal. This may be used to qualify the value in the change_type field. For example, if the change affects only the EHR directory, this field might be used to indicate 'Folder `episode 2018-02-16` added' or similar.", 0, 1, this.description);
            }
            case -1491142774: {
                return new Property("committer", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Identity and optional reference into identity management service, of user who committed the item.", 0, 1, this.committer);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                Base[] baseArray;
                if (this.system_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.system_id;
                }
                return baseArray;
            }
            case 2138761354: {
                Base[] baseArray;
                if (this.time_committed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.time_committed;
                }
                return baseArray;
            }
            case -1654455703: {
                Base[] baseArray;
                if (this.change_type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.change_type;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case -1491142774: {
                Base[] baseArray;
                if (this.committer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.committer;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                this.system_id = TypeConvertor.castToString(value);
                return value;
            }
            case 2138761354: {
                this.time_committed = (DV_DATE_TIME)value;
                return value;
            }
            case -1654455703: {
                this.change_type = (DV_CODED_TEXT)value;
                return value;
            }
            case -1724546052: {
                this.description = (DV_TEXT)value;
                return value;
            }
            case -1491142774: {
                this.committer = (PARTY_PROXY)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("system_id")) {
            this.system_id = TypeConvertor.castToString(value);
        } else if (name.equals("time_committed")) {
            this.time_committed = (DV_DATE_TIME)value;
        } else if (name.equals("change_type")) {
            this.change_type = (DV_CODED_TEXT)value;
        } else if (name.equals("description")) {
            this.description = (DV_TEXT)value;
        } else if (name.equals("committer")) {
            this.committer = (PARTY_PROXY)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                return this.getSystem_idElement();
            }
            case 2138761354: {
                return this.getTime_committed();
            }
            case -1654455703: {
                return this.getChange_type();
            }
            case -1724546052: {
                return this.getDescription();
            }
            case -1491142774: {
                throw new Error("Unable to make an instance of the abstract property 'committer'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                return new String[]{"string"};
            }
            case 2138761354: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
            case -1654455703: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case -1724546052: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
            case -1491142774: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-PROXY"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("system_id")) {
            throw new FHIRException("Cannot call addChild on a singleton property AUDIT_DETAILS.system_id");
        }
        if (name.equals("time_committed")) {
            this.time_committed = new DV_DATE_TIME();
            return this.time_committed;
        }
        if (name.equals("change_type")) {
            this.change_type = new DV_CODED_TEXT();
            return this.change_type;
        }
        if (name.equals("description")) {
            this.description = new DV_TEXT();
            return this.description;
        }
        if (name.equals("committer")) {
            throw new FHIRException("Cannot call addChild on an abstract type AUDIT_DETAILS.committer");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AUDIT_DETAILS";
    }

    @Override
    public AUDIT_DETAILS copy() {
        AUDIT_DETAILS dst = new AUDIT_DETAILS();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(AUDIT_DETAILS dst) {
        super.copyValues(dst);
        dst.system_id = this.system_id == null ? null : this.system_id.copy();
        dst.time_committed = this.time_committed == null ? null : this.time_committed.copy();
        dst.change_type = this.change_type == null ? null : this.change_type.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.committer = this.committer == null ? null : this.committer.copy();
    }

    protected AUDIT_DETAILS typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AUDIT_DETAILS)) {
            return false;
        }
        AUDIT_DETAILS o = (AUDIT_DETAILS)other_;
        return AUDIT_DETAILS.compareDeep(this.system_id, o.system_id, true) && AUDIT_DETAILS.compareDeep(this.time_committed, o.time_committed, true) && AUDIT_DETAILS.compareDeep(this.change_type, o.change_type, true) && AUDIT_DETAILS.compareDeep(this.description, o.description, true) && AUDIT_DETAILS.compareDeep(this.committer, o.committer, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AUDIT_DETAILS)) {
            return false;
        }
        AUDIT_DETAILS o = (AUDIT_DETAILS)other_;
        return AUDIT_DETAILS.compareValues(this.system_id, o.system_id, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.system_id, this.time_committed, this.change_type, this.description, this.committer});
    }
}

