/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.CONTENT_ITEM;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.EVENT_CONTEXT;
import org.hl7.fhir.r5.openehr.LOCATABLE;
import org.hl7.fhir.r5.openehr.PARTY_PROXY;

@DatatypeDef(name="COMPOSITION")
public class COMPOSITION
extends LOCATABLE
implements ICompositeType {
    @Child(name="language", type={CODE_PHRASE.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Mandatory indicator of the localised language in which this Composition is written. Coded from openEHR Code Set languages", formalDefinition="Mandatory indicator of the localised language in which this Composition is written. Coded from openEHR Code Set languages. The language of an Entry if different from the Composition is indicated in ENTRY.language.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-languages")
    protected CODE_PHRASE language;
    @Child(name="territory", type={CODE_PHRASE.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of territory in which this Composition was written. Coded from the ISO 3166 standard", formalDefinition="Name of territory in which this Composition was written. Coded from openEHR countries code set, which is an expression of the ISO 3166 standard.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-territories")
    protected CODE_PHRASE territory;
    @Child(name="category", type={DV_CODED_TEXT.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Temporal category of this Composition, e.g. * 431|persistent|, 451|episodic|, or 433|event|", formalDefinition="Temporal category of this Composition, i.e.\r\n\r\n* 431|persistent| - of potential life-time validity;* 451|episodic| - valid over the life of a care episode;* 433|event| - valid at the time of recording (long-term validity requires subsequent clinical assessment).\r\n\r\nor any other code defined in the openEHR terminology group 'category'.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-composition_category")
    protected DV_CODED_TEXT category;
    @Child(name="context", type={EVENT_CONTEXT.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The clinical session context of this Composition, i.e. the contextual attributes of the clinical session", formalDefinition="The clinical session context of this Composition, i.e. the contextual attributes of the clinical session.")
    protected EVENT_CONTEXT context;
    @Child(name="composer", type={PARTY_PROXY.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The person primarily responsible for the content of the Composition. This is the identifier which should appear on the screen", formalDefinition="The person primarily responsible for the content of the Composition (but not necessarily its committal into the EHR system). This is the identifier which should appear on the screen. It may or may not be the person who entered the data. When it is the patient, the special self instance of PARTY_PROXY will be used.")
    protected PARTY_PROXY composer;
    @Child(name="content", type={CONTENT_ITEM.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The content of this Composition", formalDefinition="The content of this Composition.")
    protected List<CONTENT_ITEM> contentList;
    private static final long serialVersionUID = -520355958L;

    public COMPOSITION() {
    }

    public COMPOSITION(CODE_PHRASE language, CODE_PHRASE territory, DV_CODED_TEXT category, PARTY_PROXY composer) {
        this.setLanguage(language);
        this.setTerritory(territory);
        this.setCategory(category);
        this.setComposer(composer);
    }

    public CODE_PHRASE getLanguage() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create COMPOSITION.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CODE_PHRASE();
            }
        }
        return this.language;
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public COMPOSITION setLanguage(CODE_PHRASE value) {
        this.language = value;
        return this;
    }

    public CODE_PHRASE getTerritory() {
        if (this.territory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create COMPOSITION.territory");
            }
            if (Configuration.doAutoCreate()) {
                this.territory = new CODE_PHRASE();
            }
        }
        return this.territory;
    }

    public boolean hasTerritory() {
        return this.territory != null && !this.territory.isEmpty();
    }

    public COMPOSITION setTerritory(CODE_PHRASE value) {
        this.territory = value;
        return this;
    }

    public DV_CODED_TEXT getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create COMPOSITION.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new DV_CODED_TEXT();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public COMPOSITION setCategory(DV_CODED_TEXT value) {
        this.category = value;
        return this;
    }

    public EVENT_CONTEXT getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create COMPOSITION.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new EVENT_CONTEXT();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public COMPOSITION setContext(EVENT_CONTEXT value) {
        this.context = value;
        return this;
    }

    public PARTY_PROXY getComposer() {
        return this.composer;
    }

    public boolean hasComposer() {
        return this.composer != null && !this.composer.isEmpty();
    }

    public COMPOSITION setComposer(PARTY_PROXY value) {
        this.composer = value;
        return this;
    }

    public List<CONTENT_ITEM> getContentList() {
        if (this.contentList == null) {
            this.contentList = new ArrayList<CONTENT_ITEM>();
        }
        return this.contentList;
    }

    public COMPOSITION setContentList(List<CONTENT_ITEM> theContent) {
        this.contentList = theContent;
        return this;
    }

    public boolean hasContent() {
        if (this.contentList == null) {
            return false;
        }
        for (CONTENT_ITEM item : this.contentList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public COMPOSITION addContent(CONTENT_ITEM t) {
        if (t == null) {
            return this;
        }
        if (this.contentList == null) {
            this.contentList = new ArrayList<CONTENT_ITEM>();
        }
        this.contentList.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Mandatory indicator of the localised language in which this Composition is written. Coded from openEHR Code Set languages. The language of an Entry if different from the Composition is indicated in ENTRY.language.", 0, 1, this.language));
        children.add(new Property("territory", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Name of territory in which this Composition was written. Coded from openEHR countries code set, which is an expression of the ISO 3166 standard.", 0, 1, this.territory));
        children.add(new Property("category", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Temporal category of this Composition, i.e.\r\n\r\n* 431|persistent| - of potential life-time validity;* 451|episodic| - valid over the life of a care episode;* 433|event| - valid at the time of recording (long-term validity requires subsequent clinical assessment).\r\n\r\nor any other code defined in the openEHR terminology group 'category'.", 0, 1, this.category));
        children.add(new Property("context", "http://openehr.org/fhir/StructureDefinition/EVENT-CONTEXT", "The clinical session context of this Composition, i.e. the contextual attributes of the clinical session.", 0, 1, this.context));
        children.add(new Property("composer", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "The person primarily responsible for the content of the Composition (but not necessarily its committal into the EHR system). This is the identifier which should appear on the screen. It may or may not be the person who entered the data. When it is the patient, the special self instance of PARTY_PROXY will be used.", 0, 1, this.composer));
        children.add(new Property("content", "http://openehr.org/fhir/StructureDefinition/CONTENT-ITEM", "The content of this Composition.", 0, Integer.MAX_VALUE, this.contentList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1613589672: {
                return new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Mandatory indicator of the localised language in which this Composition is written. Coded from openEHR Code Set languages. The language of an Entry if different from the Composition is indicated in ENTRY.language.", 0, 1, this.language);
            }
            case -2115639270: {
                return new Property("territory", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Name of territory in which this Composition was written. Coded from openEHR countries code set, which is an expression of the ISO 3166 standard.", 0, 1, this.territory);
            }
            case 50511102: {
                return new Property("category", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Temporal category of this Composition, i.e.\r\n\r\n* 431|persistent| - of potential life-time validity;* 451|episodic| - valid over the life of a care episode;* 433|event| - valid at the time of recording (long-term validity requires subsequent clinical assessment).\r\n\r\nor any other code defined in the openEHR terminology group 'category'.", 0, 1, this.category);
            }
            case 951530927: {
                return new Property("context", "http://openehr.org/fhir/StructureDefinition/EVENT-CONTEXT", "The clinical session context of this Composition, i.e. the contextual attributes of the clinical session.", 0, 1, this.context);
            }
            case -599342816: {
                return new Property("composer", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "The person primarily responsible for the content of the Composition (but not necessarily its committal into the EHR system). This is the identifier which should appear on the screen. It may or may not be the person who entered the data. When it is the patient, the special self instance of PARTY_PROXY will be used.", 0, 1, this.composer);
            }
            case 951530617: {
                return new Property("content", "http://openehr.org/fhir/StructureDefinition/CONTENT-ITEM", "The content of this Composition.", 0, Integer.MAX_VALUE, this.contentList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.language;
                }
                return baseArray;
            }
            case -2115639270: {
                Base[] baseArray;
                if (this.territory == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.territory;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.context;
                }
                return baseArray;
            }
            case -599342816: {
                Base[] baseArray;
                if (this.composer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.composer;
                }
                return baseArray;
            }
            case 951530617: {
                return this.contentList == null ? new Base[]{} : this.contentList.toArray(new Base[this.contentList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                this.language = (CODE_PHRASE)value;
                return value;
            }
            case -2115639270: {
                this.territory = (CODE_PHRASE)value;
                return value;
            }
            case 50511102: {
                this.category = (DV_CODED_TEXT)value;
                return value;
            }
            case 951530927: {
                this.context = (EVENT_CONTEXT)value;
                return value;
            }
            case -599342816: {
                this.composer = (PARTY_PROXY)value;
                return value;
            }
            case 951530617: {
                this.getContentList().add((CONTENT_ITEM)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("language")) {
            this.language = (CODE_PHRASE)value;
        } else if (name.equals("territory")) {
            this.territory = (CODE_PHRASE)value;
        } else if (name.equals("category")) {
            this.category = (DV_CODED_TEXT)value;
        } else if (name.equals("context")) {
            this.context = (EVENT_CONTEXT)value;
        } else if (name.equals("composer")) {
            this.composer = (PARTY_PROXY)value;
        } else if (name.equals("content")) {
            this.getContentList().add((CONTENT_ITEM)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return this.getLanguage();
            }
            case -2115639270: {
                return this.getTerritory();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 951530927: {
                return this.getContext();
            }
            case -599342816: {
                throw new Error("Unable to make an instance of the abstract property 'composer'");
            }
            case 951530617: {
                throw new Error("Unable to make an instance of the abstract property 'content'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case -2115639270: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case 50511102: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case 951530927: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/EVENT-CONTEXT"};
            }
            case -599342816: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-PROXY"};
            }
            case 951530617: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CONTENT-ITEM"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("language")) {
            this.language = new CODE_PHRASE();
            return this.language;
        }
        if (name.equals("territory")) {
            this.territory = new CODE_PHRASE();
            return this.territory;
        }
        if (name.equals("category")) {
            this.category = new DV_CODED_TEXT();
            return this.category;
        }
        if (name.equals("context")) {
            this.context = new EVENT_CONTEXT();
            return this.context;
        }
        if (name.equals("composer")) {
            throw new FHIRException("Cannot call addChild on an abstract type COMPOSITION.composer");
        }
        if (name.equals("content")) {
            throw new FHIRException("Cannot call addChild on an abstract type COMPOSITION.content");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "COMPOSITION";
    }

    @Override
    public COMPOSITION copy() {
        COMPOSITION dst = new COMPOSITION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(COMPOSITION dst) {
        super.copyValues(dst);
        dst.language = this.language == null ? null : this.language.copy();
        dst.territory = this.territory == null ? null : this.territory.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.context = this.context == null ? null : this.context.copy();
        PARTY_PROXY pARTY_PROXY = dst.composer = this.composer == null ? null : this.composer.copy();
        if (this.contentList != null) {
            dst.contentList = new ArrayList<CONTENT_ITEM>();
            for (CONTENT_ITEM i : this.contentList) {
                dst.contentList.add(i.copy());
            }
        }
    }

    protected COMPOSITION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof COMPOSITION)) {
            return false;
        }
        COMPOSITION o = (COMPOSITION)other_;
        return COMPOSITION.compareDeep(this.language, o.language, true) && COMPOSITION.compareDeep(this.territory, o.territory, true) && COMPOSITION.compareDeep(this.category, o.category, true) && COMPOSITION.compareDeep(this.context, o.context, true) && COMPOSITION.compareDeep(this.composer, o.composer, true) && COMPOSITION.compareDeep(this.contentList, o.contentList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof COMPOSITION)) {
            return false;
        }
        COMPOSITION o = (COMPOSITION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.language, this.territory, this.category, this.context, this.composer, this.contentList});
    }
}

