/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.r5.openehr.DV_AMOUNT;

@DatatypeDef(name="DV_ENCAPSULATED")
public abstract class DV_ENCAPSULATED
extends DV_AMOUNT
implements ICompositeType {
    @Child(name="charset", type={CODE_PHRASE.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of character encoding scheme in which this value is encoded. Coded from openEHR Code Set character sets", formalDefinition="Name of character encoding scheme in which this value is encoded. Coded from openEHR Code Set character sets . Unicode is the default assumption in openEHR, with UTF-8 being the assumed encoding. This attribute allows for variations from these assumptions.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-character_sets")
    protected CODE_PHRASE charset;
    @Child(name="language", type={CODE_PHRASE.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional indicator of the localised language in which the data is written, if relevant", formalDefinition="Optional indicator of the localised language in which the data is written, if relevant. Coded from openEHR Code Set languages.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-languages")
    protected CODE_PHRASE language;
    private static final long serialVersionUID = 379442662L;

    public CODE_PHRASE getCharset() {
        if (this.charset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_ENCAPSULATED.charset");
            }
            if (Configuration.doAutoCreate()) {
                this.charset = new CODE_PHRASE();
            }
        }
        return this.charset;
    }

    public boolean hasCharset() {
        return this.charset != null && !this.charset.isEmpty();
    }

    public DV_ENCAPSULATED setCharset(CODE_PHRASE value) {
        this.charset = value;
        return this;
    }

    public CODE_PHRASE getLanguage() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_ENCAPSULATED.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CODE_PHRASE();
            }
        }
        return this.language;
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public DV_ENCAPSULATED setLanguage(CODE_PHRASE value) {
        this.language = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("charset", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Name of character encoding scheme in which this value is encoded. Coded from openEHR Code Set character sets . Unicode is the default assumption in openEHR, with UTF-8 being the assumed encoding. This attribute allows for variations from these assumptions.", 0, 1, this.charset));
        children.add(new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Optional indicator of the localised language in which the data is written, if relevant. Coded from openEHR Code Set languages.", 0, 1, this.language));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 739074380: {
                return new Property("charset", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Name of character encoding scheme in which this value is encoded. Coded from openEHR Code Set character sets . Unicode is the default assumption in openEHR, with UTF-8 being the assumed encoding. This attribute allows for variations from these assumptions.", 0, 1, this.charset);
            }
            case -1613589672: {
                return new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Optional indicator of the localised language in which the data is written, if relevant. Coded from openEHR Code Set languages.", 0, 1, this.language);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 739074380: {
                Base[] baseArray;
                if (this.charset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.charset;
                }
                return baseArray;
            }
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.language;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 739074380: {
                this.charset = (CODE_PHRASE)value;
                return value;
            }
            case -1613589672: {
                this.language = (CODE_PHRASE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("charset")) {
            this.charset = (CODE_PHRASE)value;
        } else if (name.equals("language")) {
            this.language = (CODE_PHRASE)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 739074380: {
                return this.getCharset();
            }
            case -1613589672: {
                return this.getLanguage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 739074380: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case -1613589672: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("charset")) {
            this.charset = new CODE_PHRASE();
            return this.charset;
        }
        if (name.equals("language")) {
            this.language = new CODE_PHRASE();
            return this.language;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_ENCAPSULATED";
    }

    @Override
    public abstract DV_ENCAPSULATED copy();

    public void copyValues(DV_ENCAPSULATED dst) {
        super.copyValues(dst);
        dst.charset = this.charset == null ? null : this.charset.copy();
        dst.language = this.language == null ? null : this.language.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_ENCAPSULATED)) {
            return false;
        }
        DV_ENCAPSULATED o = (DV_ENCAPSULATED)other_;
        return DV_ENCAPSULATED.compareDeep(this.charset, o.charset, true) && DV_ENCAPSULATED.compareDeep(this.language, o.language, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_ENCAPSULATED)) {
            return false;
        }
        DV_ENCAPSULATED o = (DV_ENCAPSULATED)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.charset, this.language});
    }
}

