/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_AMOUNT;

@DatatypeDef(name="DV_PROPORTION")
public class DV_PROPORTION
extends DV_AMOUNT
implements ICompositeType {
    @Child(name="numerator", type={DecimalType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Numerator of ratio", formalDefinition="Numerator of ratio.")
    protected DecimalType numerator;
    @Child(name="denominator", type={DecimalType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Denominator of ratio", formalDefinition="Denominator of ratio.")
    protected DecimalType denominator;
    @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates semantic type of proportion, including percent, unitary etc", formalDefinition="Indicates semantic type of proportion, including percent, unitary etc.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-proportion_kind")
    protected CodeType type;
    @Child(name="precision", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Precision to which the numerator and denominator values of the proportion are expressed, in terms of number of decimal places", formalDefinition="Precision to which the numerator and denominator values of the proportion are expressed, in terms of number of decimal places. The value 0 implies an integral quantity. The value -1 implies no limit, i.e. any number of decimal places.")
    protected IntegerType precision;
    private static final long serialVersionUID = 398780922L;

    public DV_PROPORTION() {
    }

    public DV_PROPORTION(BigDecimal numerator, BigDecimal denominator, String type) {
        this.setNumerator(numerator);
        this.setDenominator(denominator);
        this.setType(type);
    }

    public DecimalType getNumeratorElement() {
        if (this.numerator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_PROPORTION.numerator");
            }
            if (Configuration.doAutoCreate()) {
                this.numerator = new DecimalType();
            }
        }
        return this.numerator;
    }

    public boolean hasNumeratorElement() {
        return this.numerator != null && !this.numerator.isEmpty();
    }

    public boolean hasNumerator() {
        return this.numerator != null && !this.numerator.isEmpty();
    }

    public DV_PROPORTION setNumeratorElement(DecimalType value) {
        this.numerator = value;
        return this;
    }

    public BigDecimal getNumerator() {
        return this.numerator == null ? null : (BigDecimal)this.numerator.getValue();
    }

    public DV_PROPORTION setNumerator(BigDecimal value) {
        if (this.numerator == null) {
            this.numerator = new DecimalType();
        }
        this.numerator.setValue(value);
        return this;
    }

    public DV_PROPORTION setNumerator(long value) {
        this.numerator = new DecimalType();
        this.numerator.setValue(value);
        return this;
    }

    public DV_PROPORTION setNumerator(double value) {
        this.numerator = new DecimalType();
        this.numerator.setValue(value);
        return this;
    }

    public DecimalType getDenominatorElement() {
        if (this.denominator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_PROPORTION.denominator");
            }
            if (Configuration.doAutoCreate()) {
                this.denominator = new DecimalType();
            }
        }
        return this.denominator;
    }

    public boolean hasDenominatorElement() {
        return this.denominator != null && !this.denominator.isEmpty();
    }

    public boolean hasDenominator() {
        return this.denominator != null && !this.denominator.isEmpty();
    }

    public DV_PROPORTION setDenominatorElement(DecimalType value) {
        this.denominator = value;
        return this;
    }

    public BigDecimal getDenominator() {
        return this.denominator == null ? null : (BigDecimal)this.denominator.getValue();
    }

    public DV_PROPORTION setDenominator(BigDecimal value) {
        if (this.denominator == null) {
            this.denominator = new DecimalType();
        }
        this.denominator.setValue(value);
        return this;
    }

    public DV_PROPORTION setDenominator(long value) {
        this.denominator = new DecimalType();
        this.denominator.setValue(value);
        return this;
    }

    public DV_PROPORTION setDenominator(double value) {
        this.denominator = new DecimalType();
        this.denominator.setValue(value);
        return this;
    }

    public CodeType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_PROPORTION.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DV_PROPORTION setTypeElement(CodeType value) {
        this.type = value;
        return this;
    }

    public String getType() {
        return this.type == null ? null : (String)this.type.getValue();
    }

    public DV_PROPORTION setType(String value) {
        if (this.type == null) {
            this.type = new CodeType();
        }
        this.type.setValue(value);
        return this;
    }

    public IntegerType getPrecisionElement() {
        if (this.precision == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_PROPORTION.precision");
            }
            if (Configuration.doAutoCreate()) {
                this.precision = new IntegerType();
            }
        }
        return this.precision;
    }

    public boolean hasPrecisionElement() {
        return this.precision != null && !this.precision.isEmpty();
    }

    public boolean hasPrecision() {
        return this.precision != null && !this.precision.isEmpty();
    }

    public DV_PROPORTION setPrecisionElement(IntegerType value) {
        this.precision = value;
        return this;
    }

    public int getPrecision() {
        return this.precision == null || this.precision.isEmpty() ? 0 : (Integer)this.precision.getValue();
    }

    public DV_PROPORTION setPrecision(int value) {
        if (this.precision == null) {
            this.precision = new IntegerType();
        }
        this.precision.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("numerator", "decimal", "Numerator of ratio.", 0, 1, this.numerator));
        children.add(new Property("denominator", "decimal", "Denominator of ratio.", 0, 1, this.denominator));
        children.add(new Property("type", "code", "Indicates semantic type of proportion, including percent, unitary etc.", 0, 1, this.type));
        children.add(new Property("precision", "integer", "Precision to which the numerator and denominator values of the proportion are expressed, in terms of number of decimal places. The value 0 implies an integral quantity. The value -1 implies no limit, i.e. any number of decimal places.", 0, 1, this.precision));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1747334793: {
                return new Property("numerator", "decimal", "Numerator of ratio.", 0, 1, this.numerator);
            }
            case -1983274394: {
                return new Property("denominator", "decimal", "Denominator of ratio.", 0, 1, this.denominator);
            }
            case 3575610: {
                return new Property("type", "code", "Indicates semantic type of proportion, including percent, unitary etc.", 0, 1, this.type);
            }
            case -1376177026: {
                return new Property("precision", "integer", "Precision to which the numerator and denominator values of the proportion are expressed, in terms of number of decimal places. The value 0 implies an integral quantity. The value -1 implies no limit, i.e. any number of decimal places.", 0, 1, this.precision);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1747334793: {
                Base[] baseArray;
                if (this.numerator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.numerator;
                }
                return baseArray;
            }
            case -1983274394: {
                Base[] baseArray;
                if (this.denominator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.denominator;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case -1376177026: {
                Base[] baseArray;
                if (this.precision == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.precision;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1747334793: {
                this.numerator = TypeConvertor.castToDecimal(value);
                return value;
            }
            case -1983274394: {
                this.denominator = TypeConvertor.castToDecimal(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCode(value);
                return value;
            }
            case -1376177026: {
                this.precision = TypeConvertor.castToInteger(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("numerator")) {
            this.numerator = TypeConvertor.castToDecimal(value);
        } else if (name.equals("denominator")) {
            this.denominator = TypeConvertor.castToDecimal(value);
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCode(value);
        } else if (name.equals("precision")) {
            this.precision = TypeConvertor.castToInteger(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1747334793: {
                return this.getNumeratorElement();
            }
            case -1983274394: {
                return this.getDenominatorElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -1376177026: {
                return this.getPrecisionElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1747334793: {
                return new String[]{"decimal"};
            }
            case -1983274394: {
                return new String[]{"decimal"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case -1376177026: {
                return new String[]{"integer"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("numerator")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_PROPORTION.numerator");
        }
        if (name.equals("denominator")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_PROPORTION.denominator");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_PROPORTION.type");
        }
        if (name.equals("precision")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_PROPORTION.precision");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_PROPORTION";
    }

    @Override
    public DV_PROPORTION copy() {
        DV_PROPORTION dst = new DV_PROPORTION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_PROPORTION dst) {
        super.copyValues(dst);
        dst.numerator = this.numerator == null ? null : this.numerator.copy();
        dst.denominator = this.denominator == null ? null : this.denominator.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.precision = this.precision == null ? null : this.precision.copy();
    }

    protected DV_PROPORTION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_PROPORTION)) {
            return false;
        }
        DV_PROPORTION o = (DV_PROPORTION)other_;
        return DV_PROPORTION.compareDeep(this.numerator, o.numerator, true) && DV_PROPORTION.compareDeep(this.denominator, o.denominator, true) && DV_PROPORTION.compareDeep(this.type, o.type, true) && DV_PROPORTION.compareDeep(this.precision, o.precision, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_PROPORTION)) {
            return false;
        }
        DV_PROPORTION o = (DV_PROPORTION)other_;
        return DV_PROPORTION.compareValues(this.numerator, o.numerator, true) && DV_PROPORTION.compareValues(this.denominator, o.denominator, true) && DV_PROPORTION.compareValues(this.type, o.type, true) && DV_PROPORTION.compareValues(this.precision, o.precision, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.numerator, this.denominator, this.type, this.precision});
    }
}

