/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_ORDERED;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="DV_QUANTIFIED")
public abstract class DV_QUANTIFIED
extends DV_ORDERED
implements ICompositeType {
    @Child(name="magnitude_status", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional status of magnitude: =, <, >, <=, >=, ~", formalDefinition="Optional status of magnitude with values:\r\n* '=' : magnitude is a point value\r\n* '<' : value is < magnitude\r\n* '>' : value is > magnitude\r\n* '<=' : value is <= magnitude\r\n* '>=' : value is >= magnitude\r\n* '~' : value is approximately magnitude\r\n\r\nIf not present, assumed meaning is '=' .")
    protected StringType magnitude_status;
    @Child(name="accuracy", type={Base.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Accuracy of measurement. Exact form of expression determined in descendants", formalDefinition="Accuracy of measurement. Exact form of expression determined in descendants.")
    protected Base accuracy;
    private static final long serialVersionUID = 1989595286L;

    public StringType getMagnitude_statusElement() {
        if (this.magnitude_status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_QUANTIFIED.magnitude_status");
            }
            if (Configuration.doAutoCreate()) {
                this.magnitude_status = new StringType();
            }
        }
        return this.magnitude_status;
    }

    public boolean hasMagnitude_statusElement() {
        return this.magnitude_status != null && !this.magnitude_status.isEmpty();
    }

    public boolean hasMagnitude_status() {
        return this.magnitude_status != null && !this.magnitude_status.isEmpty();
    }

    public DV_QUANTIFIED setMagnitude_statusElement(StringType value) {
        this.magnitude_status = value;
        return this;
    }

    public String getMagnitude_status() {
        return this.magnitude_status == null ? null : (String)this.magnitude_status.getValue();
    }

    public DV_QUANTIFIED setMagnitude_status(String value) {
        if (Utilities.noString((String)value)) {
            this.magnitude_status = null;
        } else {
            if (this.magnitude_status == null) {
                this.magnitude_status = new StringType();
            }
            this.magnitude_status.setValue(value);
        }
        return this;
    }

    public Base getAccuracy() {
        return this.accuracy;
    }

    public boolean hasAccuracy() {
        return this.accuracy != null && !this.accuracy.isEmpty();
    }

    public DV_QUANTIFIED setAccuracy(Base value) {
        this.accuracy = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("magnitude_status", "string", "Optional status of magnitude with values:\r\n* '=' : magnitude is a point value\r\n* '<' : value is < magnitude\r\n* '>' : value is > magnitude\r\n* '<=' : value is <= magnitude\r\n* '>=' : value is >= magnitude\r\n* '~' : value is approximately magnitude\r\n\r\nIf not present, assumed meaning is '=' .", 0, 1, this.magnitude_status));
        children.add(new Property("accuracy", "Base", "Accuracy of measurement. Exact form of expression determined in descendants.", 0, 1, this.accuracy));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 195430657: {
                return new Property("magnitude_status", "string", "Optional status of magnitude with values:\r\n* '=' : magnitude is a point value\r\n* '<' : value is < magnitude\r\n* '>' : value is > magnitude\r\n* '<=' : value is <= magnitude\r\n* '>=' : value is >= magnitude\r\n* '~' : value is approximately magnitude\r\n\r\nIf not present, assumed meaning is '=' .", 0, 1, this.magnitude_status);
            }
            case -2131707655: {
                return new Property("accuracy", "Base", "Accuracy of measurement. Exact form of expression determined in descendants.", 0, 1, this.accuracy);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 195430657: {
                Base[] baseArray;
                if (this.magnitude_status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.magnitude_status;
                }
                return baseArray;
            }
            case -2131707655: {
                Base[] baseArray;
                if (this.accuracy == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.accuracy;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 195430657: {
                this.magnitude_status = TypeConvertor.castToString(value);
                return value;
            }
            case -2131707655: {
                this.accuracy = value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("magnitude_status")) {
            this.magnitude_status = TypeConvertor.castToString(value);
        } else if (name.equals("accuracy")) {
            this.accuracy = value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 195430657: {
                return this.getMagnitude_statusElement();
            }
            case -2131707655: {
                throw new Error("Unable to make an instance of the abstract property 'accuracy'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 195430657: {
                return new String[]{"string"};
            }
            case -2131707655: {
                return new String[]{"Base"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("magnitude_status")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_QUANTIFIED.magnitude_status");
        }
        if (name.equals("accuracy")) {
            throw new FHIRException("Cannot call addChild on an abstract type DV_QUANTIFIED.accuracy");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_QUANTIFIED";
    }

    @Override
    public abstract DV_QUANTIFIED copy();

    public void copyValues(DV_QUANTIFIED dst) {
        super.copyValues(dst);
        dst.magnitude_status = this.magnitude_status == null ? null : this.magnitude_status.copy();
        dst.accuracy = this.accuracy == null ? null : this.accuracy.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_QUANTIFIED)) {
            return false;
        }
        DV_QUANTIFIED o = (DV_QUANTIFIED)other_;
        return DV_QUANTIFIED.compareDeep(this.magnitude_status, o.magnitude_status, true) && DV_QUANTIFIED.compareDeep(this.accuracy, o.accuracy, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_QUANTIFIED)) {
            return false;
        }
        DV_QUANTIFIED o = (DV_QUANTIFIED)other_;
        return DV_QUANTIFIED.compareValues(this.magnitude_status, o.magnitude_status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.magnitude_status, this.accuracy});
    }
}

