/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_AMOUNT;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="DV_QUANTITY")
public class DV_QUANTITY
extends DV_AMOUNT
implements ICompositeType {
    @Child(name="magnitude", type={DecimalType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Numeric magnitude of the quantity", formalDefinition="Numeric magnitude of the quantity.")
    protected DecimalType magnitude;
    @Child(name="precision", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Precision to which the value of the quantity is expressed, in terms of number of decimal places. The value 0 implies an integral quantity. The value -1 implies no limit, i.e. any number of decimal places", formalDefinition="Precision to which the value of the quantity is expressed, in terms of number of decimal places. The value 0 implies an integral quantity. The value -1 implies no limit, i.e. any number of decimal places")
    protected IntegerType precision;
    @Child(name="units", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Quantity units, expressed as a code or syntax string from either UCUM (the default) or the units system specified in units_system, when set", formalDefinition="Quantity units, expressed as a code or syntax string from either UCUM (the default) or the units system specified in units_system, when set.\r\n\r\nIn either case, the value is the code or syntax - normally formed of standard ASCII - which is in principal not the same as the display string, although in simple cases such as 'm' (for meters) it will be.\r\n\r\nIf the units_display_name field is set, this may be used for display. If not, the implementations must effect the resolution of the units value to a display form locally, e.g. by lookup of reference tables, request to a terminology service etc.\r\n\r\n\r\nExample values from UCUM: 'kg/m^2', 'mm[Hg]', 'ms-1', 'km/h'")
    protected StringType units;
    @Child(name="units_system", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="URI identifying a terminology containing units concepts (from the FHIR terminologies list). UCUM is default", formalDefinition="Optional field used to specify a units system from which codes in units are defined. Value is a URI identifying a terminology containing units concepts from the (HL7 FHIR terminologies list).\r\n\r\nIf not set, the UCUM standard (case-sensitive codes) is assumed as the units system.")
    protected StringType units_system;
    @Child(name="units_display_name", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional field containing the displayable form of the units field, e.g. '\u00b0C'", formalDefinition="Optional field containing the displayable form of the units field, e.g. '\u00b0C'.\r\n\r\nIf not set, the application environment needs to determine the displayable form.")
    protected StringType units_display_name;
    private static final long serialVersionUID = -290777252L;

    public DV_QUANTITY() {
    }

    public DV_QUANTITY(BigDecimal magnitude, String units) {
        this.setMagnitude(magnitude);
        this.setUnits(units);
    }

    public DecimalType getMagnitudeElement() {
        if (this.magnitude == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_QUANTITY.magnitude");
            }
            if (Configuration.doAutoCreate()) {
                this.magnitude = new DecimalType();
            }
        }
        return this.magnitude;
    }

    public boolean hasMagnitudeElement() {
        return this.magnitude != null && !this.magnitude.isEmpty();
    }

    public boolean hasMagnitude() {
        return this.magnitude != null && !this.magnitude.isEmpty();
    }

    public DV_QUANTITY setMagnitudeElement(DecimalType value) {
        this.magnitude = value;
        return this;
    }

    public BigDecimal getMagnitude() {
        return this.magnitude == null ? null : (BigDecimal)this.magnitude.getValue();
    }

    public DV_QUANTITY setMagnitude(BigDecimal value) {
        if (this.magnitude == null) {
            this.magnitude = new DecimalType();
        }
        this.magnitude.setValue(value);
        return this;
    }

    public DV_QUANTITY setMagnitude(long value) {
        this.magnitude = new DecimalType();
        this.magnitude.setValue(value);
        return this;
    }

    public DV_QUANTITY setMagnitude(double value) {
        this.magnitude = new DecimalType();
        this.magnitude.setValue(value);
        return this;
    }

    public IntegerType getPrecisionElement() {
        if (this.precision == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_QUANTITY.precision");
            }
            if (Configuration.doAutoCreate()) {
                this.precision = new IntegerType();
            }
        }
        return this.precision;
    }

    public boolean hasPrecisionElement() {
        return this.precision != null && !this.precision.isEmpty();
    }

    public boolean hasPrecision() {
        return this.precision != null && !this.precision.isEmpty();
    }

    public DV_QUANTITY setPrecisionElement(IntegerType value) {
        this.precision = value;
        return this;
    }

    public int getPrecision() {
        return this.precision == null || this.precision.isEmpty() ? 0 : (Integer)this.precision.getValue();
    }

    public DV_QUANTITY setPrecision(int value) {
        if (this.precision == null) {
            this.precision = new IntegerType();
        }
        this.precision.setValue((Object)value);
        return this;
    }

    public StringType getUnitsElement() {
        if (this.units == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_QUANTITY.units");
            }
            if (Configuration.doAutoCreate()) {
                this.units = new StringType();
            }
        }
        return this.units;
    }

    public boolean hasUnitsElement() {
        return this.units != null && !this.units.isEmpty();
    }

    public boolean hasUnits() {
        return this.units != null && !this.units.isEmpty();
    }

    public DV_QUANTITY setUnitsElement(StringType value) {
        this.units = value;
        return this;
    }

    public String getUnits() {
        return this.units == null ? null : (String)this.units.getValue();
    }

    public DV_QUANTITY setUnits(String value) {
        if (this.units == null) {
            this.units = new StringType();
        }
        this.units.setValue(value);
        return this;
    }

    public StringType getUnits_systemElement() {
        if (this.units_system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_QUANTITY.units_system");
            }
            if (Configuration.doAutoCreate()) {
                this.units_system = new StringType();
            }
        }
        return this.units_system;
    }

    public boolean hasUnits_systemElement() {
        return this.units_system != null && !this.units_system.isEmpty();
    }

    public boolean hasUnits_system() {
        return this.units_system != null && !this.units_system.isEmpty();
    }

    public DV_QUANTITY setUnits_systemElement(StringType value) {
        this.units_system = value;
        return this;
    }

    public String getUnits_system() {
        return this.units_system == null ? null : (String)this.units_system.getValue();
    }

    public DV_QUANTITY setUnits_system(String value) {
        if (Utilities.noString((String)value)) {
            this.units_system = null;
        } else {
            if (this.units_system == null) {
                this.units_system = new StringType();
            }
            this.units_system.setValue(value);
        }
        return this;
    }

    public StringType getUnits_display_nameElement() {
        if (this.units_display_name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_QUANTITY.units_display_name");
            }
            if (Configuration.doAutoCreate()) {
                this.units_display_name = new StringType();
            }
        }
        return this.units_display_name;
    }

    public boolean hasUnits_display_nameElement() {
        return this.units_display_name != null && !this.units_display_name.isEmpty();
    }

    public boolean hasUnits_display_name() {
        return this.units_display_name != null && !this.units_display_name.isEmpty();
    }

    public DV_QUANTITY setUnits_display_nameElement(StringType value) {
        this.units_display_name = value;
        return this;
    }

    public String getUnits_display_name() {
        return this.units_display_name == null ? null : (String)this.units_display_name.getValue();
    }

    public DV_QUANTITY setUnits_display_name(String value) {
        if (Utilities.noString((String)value)) {
            this.units_display_name = null;
        } else {
            if (this.units_display_name == null) {
                this.units_display_name = new StringType();
            }
            this.units_display_name.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("magnitude", "decimal", "Numeric magnitude of the quantity.", 0, 1, this.magnitude));
        children.add(new Property("precision", "integer", "Precision to which the value of the quantity is expressed, in terms of number of decimal places. The value 0 implies an integral quantity. The value -1 implies no limit, i.e. any number of decimal places", 0, 1, this.precision));
        children.add(new Property("units", "string", "Quantity units, expressed as a code or syntax string from either UCUM (the default) or the units system specified in units_system, when set.\r\n\r\nIn either case, the value is the code or syntax - normally formed of standard ASCII - which is in principal not the same as the display string, although in simple cases such as 'm' (for meters) it will be.\r\n\r\nIf the units_display_name field is set, this may be used for display. If not, the implementations must effect the resolution of the units value to a display form locally, e.g. by lookup of reference tables, request to a terminology service etc.\r\n\r\n\r\nExample values from UCUM: 'kg/m^2', 'mm[Hg]', 'ms-1', 'km/h'", 0, 1, this.units));
        children.add(new Property("units_system", "string", "Optional field used to specify a units system from which codes in units are defined. Value is a URI identifying a terminology containing units concepts from the (HL7 FHIR terminologies list).\r\n\r\nIf not set, the UCUM standard (case-sensitive codes) is assumed as the units system.", 0, 1, this.units_system));
        children.add(new Property("units_display_name", "string", "Optional field containing the displayable form of the units field, e.g. '\u00b0C'.\r\n\r\nIf not set, the application environment needs to determine the displayable form.", 0, 1, this.units_display_name));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -2016783856: {
                return new Property("magnitude", "decimal", "Numeric magnitude of the quantity.", 0, 1, this.magnitude);
            }
            case -1376177026: {
                return new Property("precision", "integer", "Precision to which the value of the quantity is expressed, in terms of number of decimal places. The value 0 implies an integral quantity. The value -1 implies no limit, i.e. any number of decimal places", 0, 1, this.precision);
            }
            case 111433583: {
                return new Property("units", "string", "Quantity units, expressed as a code or syntax string from either UCUM (the default) or the units system specified in units_system, when set.\r\n\r\nIn either case, the value is the code or syntax - normally formed of standard ASCII - which is in principal not the same as the display string, although in simple cases such as 'm' (for meters) it will be.\r\n\r\nIf the units_display_name field is set, this may be used for display. If not, the implementations must effect the resolution of the units value to a display form locally, e.g. by lookup of reference tables, request to a terminology service etc.\r\n\r\n\r\nExample values from UCUM: 'kg/m^2', 'mm[Hg]', 'ms-1', 'km/h'", 0, 1, this.units);
            }
            case -162878209: {
                return new Property("units_system", "string", "Optional field used to specify a units system from which codes in units are defined. Value is a URI identifying a terminology containing units concepts from the (HL7 FHIR terminologies list).\r\n\r\nIf not set, the UCUM standard (case-sensitive codes) is assumed as the units system.", 0, 1, this.units_system);
            }
            case 359604920: {
                return new Property("units_display_name", "string", "Optional field containing the displayable form of the units field, e.g. '\u00b0C'.\r\n\r\nIf not set, the application environment needs to determine the displayable form.", 0, 1, this.units_display_name);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -2016783856: {
                Base[] baseArray;
                if (this.magnitude == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.magnitude;
                }
                return baseArray;
            }
            case -1376177026: {
                Base[] baseArray;
                if (this.precision == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.precision;
                }
                return baseArray;
            }
            case 111433583: {
                Base[] baseArray;
                if (this.units == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.units;
                }
                return baseArray;
            }
            case -162878209: {
                Base[] baseArray;
                if (this.units_system == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.units_system;
                }
                return baseArray;
            }
            case 359604920: {
                Base[] baseArray;
                if (this.units_display_name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.units_display_name;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -2016783856: {
                this.magnitude = TypeConvertor.castToDecimal(value);
                return value;
            }
            case -1376177026: {
                this.precision = TypeConvertor.castToInteger(value);
                return value;
            }
            case 111433583: {
                this.units = TypeConvertor.castToString(value);
                return value;
            }
            case -162878209: {
                this.units_system = TypeConvertor.castToString(value);
                return value;
            }
            case 359604920: {
                this.units_display_name = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("magnitude")) {
            this.magnitude = TypeConvertor.castToDecimal(value);
        } else if (name.equals("precision")) {
            this.precision = TypeConvertor.castToInteger(value);
        } else if (name.equals("units")) {
            this.units = TypeConvertor.castToString(value);
        } else if (name.equals("units_system")) {
            this.units_system = TypeConvertor.castToString(value);
        } else if (name.equals("units_display_name")) {
            this.units_display_name = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -2016783856: {
                return this.getMagnitudeElement();
            }
            case -1376177026: {
                return this.getPrecisionElement();
            }
            case 111433583: {
                return this.getUnitsElement();
            }
            case -162878209: {
                return this.getUnits_systemElement();
            }
            case 359604920: {
                return this.getUnits_display_nameElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -2016783856: {
                return new String[]{"decimal"};
            }
            case -1376177026: {
                return new String[]{"integer"};
            }
            case 111433583: {
                return new String[]{"string"};
            }
            case -162878209: {
                return new String[]{"string"};
            }
            case 359604920: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("magnitude")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_QUANTITY.magnitude");
        }
        if (name.equals("precision")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_QUANTITY.precision");
        }
        if (name.equals("units")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_QUANTITY.units");
        }
        if (name.equals("units_system")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_QUANTITY.units_system");
        }
        if (name.equals("units_display_name")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_QUANTITY.units_display_name");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_QUANTITY";
    }

    @Override
    public DV_QUANTITY copy() {
        DV_QUANTITY dst = new DV_QUANTITY();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_QUANTITY dst) {
        super.copyValues(dst);
        dst.magnitude = this.magnitude == null ? null : this.magnitude.copy();
        dst.precision = this.precision == null ? null : this.precision.copy();
        dst.units = this.units == null ? null : this.units.copy();
        dst.units_system = this.units_system == null ? null : this.units_system.copy();
        dst.units_display_name = this.units_display_name == null ? null : this.units_display_name.copy();
    }

    protected DV_QUANTITY typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_QUANTITY)) {
            return false;
        }
        DV_QUANTITY o = (DV_QUANTITY)other_;
        return DV_QUANTITY.compareDeep(this.magnitude, o.magnitude, true) && DV_QUANTITY.compareDeep(this.precision, o.precision, true) && DV_QUANTITY.compareDeep(this.units, o.units, true) && DV_QUANTITY.compareDeep(this.units_system, o.units_system, true) && DV_QUANTITY.compareDeep(this.units_display_name, o.units_display_name, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_QUANTITY)) {
            return false;
        }
        DV_QUANTITY o = (DV_QUANTITY)other_;
        return DV_QUANTITY.compareValues(this.magnitude, o.magnitude, true) && DV_QUANTITY.compareValues(this.precision, o.precision, true) && DV_QUANTITY.compareValues(this.units, o.units, true) && DV_QUANTITY.compareValues(this.units_system, o.units_system, true) && DV_QUANTITY.compareValues(this.units_display_name, o.units_display_name, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.magnitude, this.precision, this.units, this.units_system, this.units_display_name});
    }
}

