/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_ORDERED;

@DatatypeDef(name="DV_SCALE")
public class DV_SCALE
extends DV_ORDERED
implements ICompositeType {
    @Child(name="symbol", type={DV_CODED_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Coded textual representation of this value in the scale range, which may be strings made from symbols or other enumerations of terms", formalDefinition="Coded textual representation of this value in the scale range, which may be strings made from symbols or other enumerations of terms such as no breathlessness, very very slight, slight breathlessness. Codes come from archetypes.\r\n\r\nIn some cases, a scale may include values that have no code/symbol. In this case, the symbol will be a DV-CODED-TEXT including the terminology_id and a blank String value for code_string.")
    protected DV_CODED_TEXT symbol;
    @Child(name="value", type={DecimalType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Real number value of Scale item", formalDefinition="Real number value of Scale item.")
    protected DecimalType value;
    private static final long serialVersionUID = -1085111458L;

    public DV_SCALE() {
    }

    public DV_SCALE(DV_CODED_TEXT symbol, BigDecimal value) {
        this.setSymbol(symbol);
        this.setValue(value);
    }

    public DV_CODED_TEXT getSymbol() {
        if (this.symbol == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_SCALE.symbol");
            }
            if (Configuration.doAutoCreate()) {
                this.symbol = new DV_CODED_TEXT();
            }
        }
        return this.symbol;
    }

    public boolean hasSymbol() {
        return this.symbol != null && !this.symbol.isEmpty();
    }

    public DV_SCALE setSymbol(DV_CODED_TEXT value) {
        this.symbol = value;
        return this;
    }

    public DecimalType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_SCALE.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new DecimalType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public DV_SCALE setValueElement(DecimalType value) {
        this.value = value;
        return this;
    }

    public BigDecimal getValue() {
        return this.value == null ? null : (BigDecimal)this.value.getValue();
    }

    public DV_SCALE setValue(BigDecimal value) {
        if (this.value == null) {
            this.value = new DecimalType();
        }
        this.value.setValue(value);
        return this;
    }

    public DV_SCALE setValue(long value) {
        this.value = new DecimalType();
        this.value.setValue(value);
        return this;
    }

    public DV_SCALE setValue(double value) {
        this.value = new DecimalType();
        this.value.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("symbol", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Coded textual representation of this value in the scale range, which may be strings made from symbols or other enumerations of terms such as no breathlessness, very very slight, slight breathlessness. Codes come from archetypes.\r\n\r\nIn some cases, a scale may include values that have no code/symbol. In this case, the symbol will be a DV-CODED-TEXT including the terminology_id and a blank String value for code_string.", 0, 1, this.symbol));
        children.add(new Property("value", "decimal", "Real number value of Scale item.", 0, 1, this.value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -887523944: {
                return new Property("symbol", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Coded textual representation of this value in the scale range, which may be strings made from symbols or other enumerations of terms such as no breathlessness, very very slight, slight breathlessness. Codes come from archetypes.\r\n\r\nIn some cases, a scale may include values that have no code/symbol. In this case, the symbol will be a DV-CODED-TEXT including the terminology_id and a blank String value for code_string.", 0, 1, this.symbol);
            }
            case 111972721: {
                return new Property("value", "decimal", "Real number value of Scale item.", 0, 1, this.value);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -887523944: {
                Base[] baseArray;
                if (this.symbol == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.symbol;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -887523944: {
                this.symbol = (DV_CODED_TEXT)value;
                return value;
            }
            case 111972721: {
                this.value = TypeConvertor.castToDecimal(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("symbol")) {
            this.symbol = (DV_CODED_TEXT)value;
        } else if (name.equals("value")) {
            this.value = TypeConvertor.castToDecimal(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -887523944: {
                return this.getSymbol();
            }
            case 111972721: {
                return this.getValueElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -887523944: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case 111972721: {
                return new String[]{"decimal"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("symbol")) {
            this.symbol = new DV_CODED_TEXT();
            return this.symbol;
        }
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_SCALE.value");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_SCALE";
    }

    @Override
    public DV_SCALE copy() {
        DV_SCALE dst = new DV_SCALE();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_SCALE dst) {
        super.copyValues(dst);
        dst.symbol = this.symbol == null ? null : this.symbol.copy();
        dst.value = this.value == null ? null : this.value.copy();
    }

    protected DV_SCALE typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_SCALE)) {
            return false;
        }
        DV_SCALE o = (DV_SCALE)other_;
        return DV_SCALE.compareDeep(this.symbol, o.symbol, true) && DV_SCALE.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_SCALE)) {
            return false;
        }
        DV_SCALE o = (DV_SCALE)other_;
        return DV_SCALE.compareValues(this.value, o.value, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.symbol, this.value});
    }
}

