/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.ACCESS_CONTROL_SETTINGS;
import org.hl7.fhir.r5.openehr.LOCATABLE;

@DatatypeDef(name="EHR_ACCESS")
public class EHR_ACCESS
extends LOCATABLE
implements ICompositeType {
    @Child(name="settings", type={ACCESS_CONTROL_SETTINGS.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Access control settings for the EHR. Instance is a subtype of the type ACCESS_CONTROL_SETTINGS, allowing for the use of different access control schemes", formalDefinition="Access control settings for the EHR. Instance is a subtype of the type ACCESS_CONTROL_SETTINGS, allowing for the use of different access control schemes.")
    protected ACCESS_CONTROL_SETTINGS settings;
    private static final long serialVersionUID = 708478691L;

    public ACCESS_CONTROL_SETTINGS getSettings() {
        return this.settings;
    }

    public boolean hasSettings() {
        return this.settings != null && !this.settings.isEmpty();
    }

    public EHR_ACCESS setSettings(ACCESS_CONTROL_SETTINGS value) {
        this.settings = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("settings", "http://openehr.org/fhir/StructureDefinition/ACCESS-CONTROL-SETTINGS", "Access control settings for the EHR. Instance is a subtype of the type ACCESS_CONTROL_SETTINGS, allowing for the use of different access control schemes.", 0, 1, this.settings));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1434631203: {
                return new Property("settings", "http://openehr.org/fhir/StructureDefinition/ACCESS-CONTROL-SETTINGS", "Access control settings for the EHR. Instance is a subtype of the type ACCESS_CONTROL_SETTINGS, allowing for the use of different access control schemes.", 0, 1, this.settings);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1434631203: {
                Base[] baseArray;
                if (this.settings == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.settings;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1434631203: {
                this.settings = (ACCESS_CONTROL_SETTINGS)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("settings")) {
            return super.setProperty(name, value);
        }
        this.settings = (ACCESS_CONTROL_SETTINGS)value;
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1434631203: {
                throw new Error("Unable to make an instance of the abstract property 'settings'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1434631203: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ACCESS-CONTROL-SETTINGS"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("settings")) {
            throw new FHIRException("Cannot call addChild on an abstract type EHR_ACCESS.settings");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EHR_ACCESS";
    }

    @Override
    public EHR_ACCESS copy() {
        EHR_ACCESS dst = new EHR_ACCESS();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EHR_ACCESS dst) {
        super.copyValues(dst);
        dst.settings = this.settings == null ? null : this.settings.copy();
    }

    protected EHR_ACCESS typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EHR_ACCESS)) {
            return false;
        }
        EHR_ACCESS o = (EHR_ACCESS)other_;
        return EHR_ACCESS.compareDeep(this.settings, o.settings, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EHR_ACCESS)) {
            return false;
        }
        EHR_ACCESS o = (EHR_ACCESS)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.settings});
    }
}

