/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.PARTY_IDENTIFIED;
import org.hl7.fhir.r5.openehr.PARTY_PROXY;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="FEEDER_AUDIT_DETAILS")
public class FEEDER_AUDIT_DETAILS
extends LogicalBase
implements ICompositeType {
    @Child(name="system_id", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identifier of the system which handled the information item", formalDefinition="Identifier of the system which handled the information item. This is the IT system owned by the organisation legally responsible for handling the data, and at which the data were previously created or passed by an earlier system.")
    protected StringType system_id;
    @Child(name="location", type={PARTY_IDENTIFIED.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identifier of the particular site/facility within an organisation which handled the item", formalDefinition="Identifier of the particular site/facility within an organisation which handled the item. For computability, this identifier needs to be e.g. a PKI identifier which can be included in the identifier list of the PARTY_IDENTIFIED object.")
    protected PARTY_IDENTIFIED location;
    @Child(name="subject", type={PARTY_PROXY.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identifiers for subject of the received information item", formalDefinition="Identifiers for subject of the received information item.")
    protected PARTY_PROXY subject;
    @Child(name="provider", type={PARTY_IDENTIFIED.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional provider(s) who created, committed, forwarded or otherwise handled the item", formalDefinition="Optional provider(s) who created, committed, forwarded or otherwise handled the item.")
    protected PARTY_IDENTIFIED provider;
    @Child(name="time", type={DV_DATE_TIME.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time of handling the item", formalDefinition="Time of handling the item. For an originating system, this will be time of creation, for an intermediate feeder system, this will be a time of accession or other time of handling, where available.")
    protected DV_DATE_TIME time;
    @Child(name="version_id", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Any identifier used in the system such as `interim` , `final` , or numeric versions if available", formalDefinition="Any identifier used in the system such as `interim` , `final` , or numeric versions if available.")
    protected StringType version_id;
    @Child(name="other_details", type={ITEM_STRUCTURE.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional attribute to carry any custom meta-data", formalDefinition="Optional attribute to carry any custom meta-data. May be archetyped.")
    protected ITEM_STRUCTURE other_details;
    private static final long serialVersionUID = -31539140L;

    public FEEDER_AUDIT_DETAILS() {
    }

    public FEEDER_AUDIT_DETAILS(String system_id) {
        this.setSystem_id(system_id);
    }

    public StringType getSystem_idElement() {
        if (this.system_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FEEDER_AUDIT_DETAILS.system_id");
            }
            if (Configuration.doAutoCreate()) {
                this.system_id = new StringType();
            }
        }
        return this.system_id;
    }

    public boolean hasSystem_idElement() {
        return this.system_id != null && !this.system_id.isEmpty();
    }

    public boolean hasSystem_id() {
        return this.system_id != null && !this.system_id.isEmpty();
    }

    public FEEDER_AUDIT_DETAILS setSystem_idElement(StringType value) {
        this.system_id = value;
        return this;
    }

    public String getSystem_id() {
        return this.system_id == null ? null : (String)this.system_id.getValue();
    }

    public FEEDER_AUDIT_DETAILS setSystem_id(String value) {
        if (this.system_id == null) {
            this.system_id = new StringType();
        }
        this.system_id.setValue(value);
        return this;
    }

    public PARTY_IDENTIFIED getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FEEDER_AUDIT_DETAILS.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new PARTY_IDENTIFIED();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public FEEDER_AUDIT_DETAILS setLocation(PARTY_IDENTIFIED value) {
        this.location = value;
        return this;
    }

    public PARTY_PROXY getSubject() {
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public FEEDER_AUDIT_DETAILS setSubject(PARTY_PROXY value) {
        this.subject = value;
        return this;
    }

    public PARTY_IDENTIFIED getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FEEDER_AUDIT_DETAILS.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new PARTY_IDENTIFIED();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public FEEDER_AUDIT_DETAILS setProvider(PARTY_IDENTIFIED value) {
        this.provider = value;
        return this;
    }

    public DV_DATE_TIME getTime() {
        if (this.time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FEEDER_AUDIT_DETAILS.time");
            }
            if (Configuration.doAutoCreate()) {
                this.time = new DV_DATE_TIME();
            }
        }
        return this.time;
    }

    public boolean hasTime() {
        return this.time != null && !this.time.isEmpty();
    }

    public FEEDER_AUDIT_DETAILS setTime(DV_DATE_TIME value) {
        this.time = value;
        return this;
    }

    public StringType getVersion_idElement() {
        if (this.version_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create FEEDER_AUDIT_DETAILS.version_id");
            }
            if (Configuration.doAutoCreate()) {
                this.version_id = new StringType();
            }
        }
        return this.version_id;
    }

    public boolean hasVersion_idElement() {
        return this.version_id != null && !this.version_id.isEmpty();
    }

    public boolean hasVersion_id() {
        return this.version_id != null && !this.version_id.isEmpty();
    }

    public FEEDER_AUDIT_DETAILS setVersion_idElement(StringType value) {
        this.version_id = value;
        return this;
    }

    public String getVersion_id() {
        return this.version_id == null ? null : (String)this.version_id.getValue();
    }

    public FEEDER_AUDIT_DETAILS setVersion_id(String value) {
        if (Utilities.noString((String)value)) {
            this.version_id = null;
        } else {
            if (this.version_id == null) {
                this.version_id = new StringType();
            }
            this.version_id.setValue(value);
        }
        return this;
    }

    public ITEM_STRUCTURE getOther_details() {
        return this.other_details;
    }

    public boolean hasOther_details() {
        return this.other_details != null && !this.other_details.isEmpty();
    }

    public FEEDER_AUDIT_DETAILS setOther_details(ITEM_STRUCTURE value) {
        this.other_details = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("system_id", "string", "Identifier of the system which handled the information item. This is the IT system owned by the organisation legally responsible for handling the data, and at which the data were previously created or passed by an earlier system.", 0, 1, this.system_id));
        children.add(new Property("location", "http://openehr.org/fhir/StructureDefinition/PARTY-IDENTIFIED", "Identifier of the particular site/facility within an organisation which handled the item. For computability, this identifier needs to be e.g. a PKI identifier which can be included in the identifier list of the PARTY_IDENTIFIED object.", 0, 1, this.location));
        children.add(new Property("subject", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Identifiers for subject of the received information item.", 0, 1, this.subject));
        children.add(new Property("provider", "http://openehr.org/fhir/StructureDefinition/PARTY-IDENTIFIED", "Optional provider(s) who created, committed, forwarded or otherwise handled the item.", 0, 1, this.provider));
        children.add(new Property("time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of handling the item. For an originating system, this will be time of creation, for an intermediate feeder system, this will be a time of accession or other time of handling, where available.", 0, 1, this.time));
        children.add(new Property("version_id", "string", "Any identifier used in the system such as `interim` , `final` , or numeric versions if available.", 0, 1, this.version_id));
        children.add(new Property("other_details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Optional attribute to carry any custom meta-data. May be archetyped.", 0, 1, this.other_details));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1129127211: {
                return new Property("system_id", "string", "Identifier of the system which handled the information item. This is the IT system owned by the organisation legally responsible for handling the data, and at which the data were previously created or passed by an earlier system.", 0, 1, this.system_id);
            }
            case 1901043637: {
                return new Property("location", "http://openehr.org/fhir/StructureDefinition/PARTY-IDENTIFIED", "Identifier of the particular site/facility within an organisation which handled the item. For computability, this identifier needs to be e.g. a PKI identifier which can be included in the identifier list of the PARTY_IDENTIFIED object.", 0, 1, this.location);
            }
            case -1867885268: {
                return new Property("subject", "http://openehr.org/fhir/StructureDefinition/PARTY-PROXY", "Identifiers for subject of the received information item.", 0, 1, this.subject);
            }
            case -987494927: {
                return new Property("provider", "http://openehr.org/fhir/StructureDefinition/PARTY-IDENTIFIED", "Optional provider(s) who created, committed, forwarded or otherwise handled the item.", 0, 1, this.provider);
            }
            case 3560141: {
                return new Property("time", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of handling the item. For an originating system, this will be time of creation, for an intermediate feeder system, this will be a time of accession or other time of handling, where available.", 0, 1, this.time);
            }
            case -670497310: {
                return new Property("version_id", "string", "Any identifier used in the system such as `interim` , `final` , or numeric versions if available.", 0, 1, this.version_id);
            }
            case -1257043949: {
                return new Property("other_details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Optional attribute to carry any custom meta-data. May be archetyped.", 0, 1, this.other_details);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                Base[] baseArray;
                if (this.system_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.system_id;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.location;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.provider;
                }
                return baseArray;
            }
            case 3560141: {
                Base[] baseArray;
                if (this.time == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.time;
                }
                return baseArray;
            }
            case -670497310: {
                Base[] baseArray;
                if (this.version_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.version_id;
                }
                return baseArray;
            }
            case -1257043949: {
                Base[] baseArray;
                if (this.other_details == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.other_details;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                this.system_id = TypeConvertor.castToString(value);
                return value;
            }
            case 1901043637: {
                this.location = (PARTY_IDENTIFIED)value;
                return value;
            }
            case -1867885268: {
                this.subject = (PARTY_PROXY)value;
                return value;
            }
            case -987494927: {
                this.provider = (PARTY_IDENTIFIED)value;
                return value;
            }
            case 3560141: {
                this.time = (DV_DATE_TIME)value;
                return value;
            }
            case -670497310: {
                this.version_id = TypeConvertor.castToString(value);
                return value;
            }
            case -1257043949: {
                this.other_details = (ITEM_STRUCTURE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("system_id")) {
            this.system_id = TypeConvertor.castToString(value);
        } else if (name.equals("location")) {
            this.location = (PARTY_IDENTIFIED)value;
        } else if (name.equals("subject")) {
            this.subject = (PARTY_PROXY)value;
        } else if (name.equals("provider")) {
            this.provider = (PARTY_IDENTIFIED)value;
        } else if (name.equals("time")) {
            this.time = (DV_DATE_TIME)value;
        } else if (name.equals("version_id")) {
            this.version_id = TypeConvertor.castToString(value);
        } else if (name.equals("other_details")) {
            this.other_details = (ITEM_STRUCTURE)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                return this.getSystem_idElement();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1867885268: {
                throw new Error("Unable to make an instance of the abstract property 'subject'");
            }
            case -987494927: {
                return this.getProvider();
            }
            case 3560141: {
                return this.getTime();
            }
            case -670497310: {
                return this.getVersion_idElement();
            }
            case -1257043949: {
                throw new Error("Unable to make an instance of the abstract property 'other_details'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1129127211: {
                return new String[]{"string"};
            }
            case 1901043637: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-IDENTIFIED"};
            }
            case -1867885268: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-PROXY"};
            }
            case -987494927: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-IDENTIFIED"};
            }
            case 3560141: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
            case -670497310: {
                return new String[]{"string"};
            }
            case -1257043949: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("system_id")) {
            throw new FHIRException("Cannot call addChild on a singleton property FEEDER_AUDIT_DETAILS.system_id");
        }
        if (name.equals("location")) {
            this.location = new PARTY_IDENTIFIED();
            return this.location;
        }
        if (name.equals("subject")) {
            throw new FHIRException("Cannot call addChild on an abstract type FEEDER_AUDIT_DETAILS.subject");
        }
        if (name.equals("provider")) {
            this.provider = new PARTY_IDENTIFIED();
            return this.provider;
        }
        if (name.equals("time")) {
            this.time = new DV_DATE_TIME();
            return this.time;
        }
        if (name.equals("version_id")) {
            throw new FHIRException("Cannot call addChild on a singleton property FEEDER_AUDIT_DETAILS.version_id");
        }
        if (name.equals("other_details")) {
            throw new FHIRException("Cannot call addChild on an abstract type FEEDER_AUDIT_DETAILS.other_details");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "FEEDER_AUDIT_DETAILS";
    }

    @Override
    public FEEDER_AUDIT_DETAILS copy() {
        FEEDER_AUDIT_DETAILS dst = new FEEDER_AUDIT_DETAILS();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(FEEDER_AUDIT_DETAILS dst) {
        super.copyValues(dst);
        dst.system_id = this.system_id == null ? null : this.system_id.copy();
        dst.location = this.location == null ? null : this.location.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.time = this.time == null ? null : this.time.copy();
        dst.version_id = this.version_id == null ? null : this.version_id.copy();
        dst.other_details = this.other_details == null ? null : this.other_details.copy();
    }

    protected FEEDER_AUDIT_DETAILS typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof FEEDER_AUDIT_DETAILS)) {
            return false;
        }
        FEEDER_AUDIT_DETAILS o = (FEEDER_AUDIT_DETAILS)other_;
        return FEEDER_AUDIT_DETAILS.compareDeep(this.system_id, o.system_id, true) && FEEDER_AUDIT_DETAILS.compareDeep(this.location, o.location, true) && FEEDER_AUDIT_DETAILS.compareDeep(this.subject, o.subject, true) && FEEDER_AUDIT_DETAILS.compareDeep(this.provider, o.provider, true) && FEEDER_AUDIT_DETAILS.compareDeep(this.time, o.time, true) && FEEDER_AUDIT_DETAILS.compareDeep(this.version_id, o.version_id, true) && FEEDER_AUDIT_DETAILS.compareDeep(this.other_details, o.other_details, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof FEEDER_AUDIT_DETAILS)) {
            return false;
        }
        FEEDER_AUDIT_DETAILS o = (FEEDER_AUDIT_DETAILS)other_;
        return FEEDER_AUDIT_DETAILS.compareValues(this.system_id, o.system_id, true) && FEEDER_AUDIT_DETAILS.compareValues(this.version_id, o.version_id, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.system_id, this.location, this.subject, this.provider, this.time, this.version_id, this.other_details});
    }
}

