/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.LOCATABLE;
import org.hl7.fhir.r5.openehr.OBJECT_REF;

@DatatypeDef(name="FOLDER")
public class FOLDER
extends LOCATABLE
implements ICompositeType {
    @Child(name="items", type={OBJECT_REF.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="References to other (usually) versioned objects logically in this folder", formalDefinition="The list of references to other (usually) versioned objects logically in this folder.")
    protected List<OBJECT_REF> itemsList;
    @Child(name="folders", type={FOLDER.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Sub-folders of this FOLDER", formalDefinition="Sub-folders of this FOLDER.")
    protected List<FOLDER> foldersList;
    @Child(name="details", type={ITEM_STRUCTURE.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Archetypable meta-data for FOLDER", formalDefinition="Archetypable meta-data for FOLDER.")
    protected ITEM_STRUCTURE details;
    private static final long serialVersionUID = -979395577L;

    public List<OBJECT_REF> getItemsList() {
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<OBJECT_REF>();
        }
        return this.itemsList;
    }

    public FOLDER setItemsList(List<OBJECT_REF> theItems) {
        this.itemsList = theItems;
        return this;
    }

    public boolean hasItems() {
        if (this.itemsList == null) {
            return false;
        }
        for (OBJECT_REF item : this.itemsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OBJECT_REF addItems() {
        OBJECT_REF t = new OBJECT_REF();
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<OBJECT_REF>();
        }
        this.itemsList.add(t);
        return t;
    }

    public FOLDER addItems(OBJECT_REF t) {
        if (t == null) {
            return this;
        }
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<OBJECT_REF>();
        }
        this.itemsList.add(t);
        return this;
    }

    public OBJECT_REF getItemsFirstRep() {
        if (this.getItemsList().isEmpty()) {
            this.addItems();
        }
        return this.getItemsList().get(0);
    }

    public List<FOLDER> getFoldersList() {
        if (this.foldersList == null) {
            this.foldersList = new ArrayList<FOLDER>();
        }
        return this.foldersList;
    }

    public FOLDER setFoldersList(List<FOLDER> theFolders) {
        this.foldersList = theFolders;
        return this;
    }

    public boolean hasFolders() {
        if (this.foldersList == null) {
            return false;
        }
        for (FOLDER item : this.foldersList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FOLDER addFolders() {
        FOLDER t = new FOLDER();
        if (this.foldersList == null) {
            this.foldersList = new ArrayList<FOLDER>();
        }
        this.foldersList.add(t);
        return t;
    }

    public FOLDER addFolders(FOLDER t) {
        if (t == null) {
            return this;
        }
        if (this.foldersList == null) {
            this.foldersList = new ArrayList<FOLDER>();
        }
        this.foldersList.add(t);
        return this;
    }

    public FOLDER getFoldersFirstRep() {
        if (this.getFoldersList().isEmpty()) {
            this.addFolders();
        }
        return this.getFoldersList().get(0);
    }

    public ITEM_STRUCTURE getDetails() {
        return this.details;
    }

    public boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    public FOLDER setDetails(ITEM_STRUCTURE value) {
        this.details = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("items", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "The list of references to other (usually) versioned objects logically in this folder.", 0, Integer.MAX_VALUE, this.itemsList));
        children.add(new Property("folders", "http://openehr.org/fhir/StructureDefinition/FOLDER", "Sub-folders of this FOLDER.", 0, Integer.MAX_VALUE, this.foldersList));
        children.add(new Property("details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Archetypable meta-data for FOLDER.", 0, 1, this.details));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 100526016: {
                return new Property("items", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "The list of references to other (usually) versioned objects logically in this folder.", 0, Integer.MAX_VALUE, this.itemsList);
            }
            case -683249211: {
                return new Property("folders", "http://openehr.org/fhir/StructureDefinition/FOLDER", "Sub-folders of this FOLDER.", 0, Integer.MAX_VALUE, this.foldersList);
            }
            case 1557721666: {
                return new Property("details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Archetypable meta-data for FOLDER.", 0, 1, this.details);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return this.itemsList == null ? new Base[]{} : this.itemsList.toArray(new Base[this.itemsList.size()]);
            }
            case -683249211: {
                return this.foldersList == null ? new Base[]{} : this.foldersList.toArray(new Base[this.foldersList.size()]);
            }
            case 1557721666: {
                Base[] baseArray;
                if (this.details == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.details;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 100526016: {
                this.getItemsList().add((OBJECT_REF)value);
                return value;
            }
            case -683249211: {
                this.getFoldersList().add((FOLDER)value);
                return value;
            }
            case 1557721666: {
                this.details = (ITEM_STRUCTURE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("items")) {
            this.getItemsList().add((OBJECT_REF)value);
        } else if (name.equals("folders")) {
            this.getFoldersList().add((FOLDER)value);
        } else if (name.equals("details")) {
            this.details = (ITEM_STRUCTURE)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return this.addItems();
            }
            case -683249211: {
                return this.addFolders();
            }
            case 1557721666: {
                throw new Error("Unable to make an instance of the abstract property 'details'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case -683249211: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/FOLDER"};
            }
            case 1557721666: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("items")) {
            return this.addItems();
        }
        if (name.equals("folders")) {
            return this.addFolders();
        }
        if (name.equals("details")) {
            throw new FHIRException("Cannot call addChild on an abstract type FOLDER.details");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "FOLDER";
    }

    @Override
    public FOLDER copy() {
        FOLDER dst = new FOLDER();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(FOLDER dst) {
        super.copyValues(dst);
        if (this.itemsList != null) {
            dst.itemsList = new ArrayList<OBJECT_REF>();
            for (OBJECT_REF oBJECT_REF : this.itemsList) {
                dst.itemsList.add(oBJECT_REF.copy());
            }
        }
        if (this.foldersList != null) {
            dst.foldersList = new ArrayList<FOLDER>();
            for (FOLDER fOLDER : this.foldersList) {
                dst.foldersList.add(fOLDER.copy());
            }
        }
        dst.details = this.details == null ? null : this.details.copy();
    }

    protected FOLDER typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof FOLDER)) {
            return false;
        }
        FOLDER o = (FOLDER)other_;
        return FOLDER.compareDeep(this.itemsList, o.itemsList, true) && FOLDER.compareDeep(this.foldersList, o.foldersList, true) && FOLDER.compareDeep(this.details, o.details, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof FOLDER)) {
            return false;
        }
        FOLDER o = (FOLDER)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.itemsList, this.foldersList, this.details});
    }
}

