/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_DURATION;
import org.hl7.fhir.r5.openehr.EVENT;

@DatatypeDef(name="INTERVAL_EVENT")
public class INTERVAL_EVENT
extends EVENT
implements ICompositeType {
    @Child(name="width", type={DV_DURATION.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Duration of the time interval during which the values recorded under data are true", formalDefinition="Duration of the time interval during which the values recorded under data are true and, if set, the values recorded under state are true. Void if an instantaneous event.")
    protected DV_DURATION width;
    @Child(name="sample_count", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional count of original samples to which this event corresponds", formalDefinition="Optional count of original samples to which this event corresponds.")
    protected IntegerType sample_count;
    @Child(name="math_function", type={DV_CODED_TEXT.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Mathematical function of the data of this event", formalDefinition="Mathematical function of the data of this event, e.g. maximum, mean etc. Coded using openEHR vocabulary event math function. Default value 640|actual|, meaning 'actual value'.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-event_math_function")
    protected DV_CODED_TEXT math_function;
    private static final long serialVersionUID = 1763307354L;

    public INTERVAL_EVENT() {
    }

    public INTERVAL_EVENT(DV_DURATION width, DV_CODED_TEXT math_function) {
        this.setWidth(width);
        this.setMath_function(math_function);
    }

    public DV_DURATION getWidth() {
        if (this.width == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create INTERVAL_EVENT.width");
            }
            if (Configuration.doAutoCreate()) {
                this.width = new DV_DURATION();
            }
        }
        return this.width;
    }

    public boolean hasWidth() {
        return this.width != null && !this.width.isEmpty();
    }

    public INTERVAL_EVENT setWidth(DV_DURATION value) {
        this.width = value;
        return this;
    }

    public IntegerType getSample_countElement() {
        if (this.sample_count == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create INTERVAL_EVENT.sample_count");
            }
            if (Configuration.doAutoCreate()) {
                this.sample_count = new IntegerType();
            }
        }
        return this.sample_count;
    }

    public boolean hasSample_countElement() {
        return this.sample_count != null && !this.sample_count.isEmpty();
    }

    public boolean hasSample_count() {
        return this.sample_count != null && !this.sample_count.isEmpty();
    }

    public INTERVAL_EVENT setSample_countElement(IntegerType value) {
        this.sample_count = value;
        return this;
    }

    public int getSample_count() {
        return this.sample_count == null || this.sample_count.isEmpty() ? 0 : (Integer)this.sample_count.getValue();
    }

    public INTERVAL_EVENT setSample_count(int value) {
        if (this.sample_count == null) {
            this.sample_count = new IntegerType();
        }
        this.sample_count.setValue((Object)value);
        return this;
    }

    public DV_CODED_TEXT getMath_function() {
        if (this.math_function == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create INTERVAL_EVENT.math_function");
            }
            if (Configuration.doAutoCreate()) {
                this.math_function = new DV_CODED_TEXT();
            }
        }
        return this.math_function;
    }

    public boolean hasMath_function() {
        return this.math_function != null && !this.math_function.isEmpty();
    }

    public INTERVAL_EVENT setMath_function(DV_CODED_TEXT value) {
        this.math_function = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("width", "http://openehr.org/fhir/StructureDefinition/DV-DURATION", "Duration of the time interval during which the values recorded under data are true and, if set, the values recorded under state are true. Void if an instantaneous event.", 0, 1, this.width));
        children.add(new Property("sample_count", "integer", "Optional count of original samples to which this event corresponds.", 0, 1, this.sample_count));
        children.add(new Property("math_function", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Mathematical function of the data of this event, e.g. maximum, mean etc. Coded using openEHR vocabulary event math function. Default value 640|actual|, meaning 'actual value'.", 0, 1, this.math_function));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 113126854: {
                return new Property("width", "http://openehr.org/fhir/StructureDefinition/DV-DURATION", "Duration of the time interval during which the values recorded under data are true and, if set, the values recorded under state are true. Void if an instantaneous event.", 0, 1, this.width);
            }
            case 440582714: {
                return new Property("sample_count", "integer", "Optional count of original samples to which this event corresponds.", 0, 1, this.sample_count);
            }
            case -2059073745: {
                return new Property("math_function", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Mathematical function of the data of this event, e.g. maximum, mean etc. Coded using openEHR vocabulary event math function. Default value 640|actual|, meaning 'actual value'.", 0, 1, this.math_function);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 113126854: {
                Base[] baseArray;
                if (this.width == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.width;
                }
                return baseArray;
            }
            case 440582714: {
                Base[] baseArray;
                if (this.sample_count == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.sample_count;
                }
                return baseArray;
            }
            case -2059073745: {
                Base[] baseArray;
                if (this.math_function == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.math_function;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 113126854: {
                this.width = (DV_DURATION)value;
                return value;
            }
            case 440582714: {
                this.sample_count = TypeConvertor.castToInteger(value);
                return value;
            }
            case -2059073745: {
                this.math_function = (DV_CODED_TEXT)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("width")) {
            this.width = (DV_DURATION)value;
        } else if (name.equals("sample_count")) {
            this.sample_count = TypeConvertor.castToInteger(value);
        } else if (name.equals("math_function")) {
            this.math_function = (DV_CODED_TEXT)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 113126854: {
                return this.getWidth();
            }
            case 440582714: {
                return this.getSample_countElement();
            }
            case -2059073745: {
                return this.getMath_function();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 113126854: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DURATION"};
            }
            case 440582714: {
                return new String[]{"integer"};
            }
            case -2059073745: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("width")) {
            this.width = new DV_DURATION();
            return this.width;
        }
        if (name.equals("sample_count")) {
            throw new FHIRException("Cannot call addChild on a singleton property INTERVAL_EVENT.sample_count");
        }
        if (name.equals("math_function")) {
            this.math_function = new DV_CODED_TEXT();
            return this.math_function;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "INTERVAL_EVENT";
    }

    @Override
    public INTERVAL_EVENT copy() {
        INTERVAL_EVENT dst = new INTERVAL_EVENT();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(INTERVAL_EVENT dst) {
        super.copyValues(dst);
        dst.width = this.width == null ? null : this.width.copy();
        dst.sample_count = this.sample_count == null ? null : this.sample_count.copy();
        dst.math_function = this.math_function == null ? null : this.math_function.copy();
    }

    protected INTERVAL_EVENT typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof INTERVAL_EVENT)) {
            return false;
        }
        INTERVAL_EVENT o = (INTERVAL_EVENT)other_;
        return INTERVAL_EVENT.compareDeep(this.width, o.width, true) && INTERVAL_EVENT.compareDeep(this.sample_count, o.sample_count, true) && INTERVAL_EVENT.compareDeep(this.math_function, o.math_function, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof INTERVAL_EVENT)) {
            return false;
        }
        INTERVAL_EVENT o = (INTERVAL_EVENT)other_;
        return INTERVAL_EVENT.compareValues(this.sample_count, o.sample_count, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.width, this.sample_count, this.math_function});
    }
}

