/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_TEXT;
import org.hl7.fhir.r5.openehr.PATHABLE;

@DatatypeDef(name="ISM_TRANSITION")
public class ISM_TRANSITION
extends PATHABLE
implements ICompositeType {
    @Child(name="current_state", type={DV_CODED_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The ISM current state. Coded by openEHR terminology group Instruction states", formalDefinition="The ISM current state. Coded by openEHR terminology group Instruction states.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-instruction_states")
    protected DV_CODED_TEXT current_state;
    @Child(name="transition", type={DV_CODED_TEXT.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The ISM transition which occurred to arrive in the current_state", formalDefinition="The ISM transition which occurred to arrive in the current_state. Coded by openEHR terminology group Instruction transitions.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-instruction_transitions")
    protected DV_CODED_TEXT transition;
    @Child(name="careflow_step", type={DV_CODED_TEXT.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The step in the careflow process which occurred as part of generating this action", formalDefinition="The step in the careflow process which occurred as part of generating this action, e.g. dispense , start_administration. This attribute represents the clinical label for the activity, as opposed to current_state which represents the state machine (ISM) computable form. Defined in archetype.")
    protected DV_CODED_TEXT careflow_step;
    @Child(name="reason", type={DV_TEXT.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Optional possibility of adding one or more reasons for this careflow step having been taken", formalDefinition="Optional possibility of adding one or more reasons for this careflow step having been taken. Multiple reasons may occur in medication management for example.")
    protected List<DV_TEXT> reasonList;
    private static final long serialVersionUID = 2077167668L;

    public ISM_TRANSITION() {
    }

    public ISM_TRANSITION(DV_CODED_TEXT current_state) {
        this.setCurrent_state(current_state);
    }

    public DV_CODED_TEXT getCurrent_state() {
        if (this.current_state == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ISM_TRANSITION.current_state");
            }
            if (Configuration.doAutoCreate()) {
                this.current_state = new DV_CODED_TEXT();
            }
        }
        return this.current_state;
    }

    public boolean hasCurrent_state() {
        return this.current_state != null && !this.current_state.isEmpty();
    }

    public ISM_TRANSITION setCurrent_state(DV_CODED_TEXT value) {
        this.current_state = value;
        return this;
    }

    public DV_CODED_TEXT getTransition() {
        if (this.transition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ISM_TRANSITION.transition");
            }
            if (Configuration.doAutoCreate()) {
                this.transition = new DV_CODED_TEXT();
            }
        }
        return this.transition;
    }

    public boolean hasTransition() {
        return this.transition != null && !this.transition.isEmpty();
    }

    public ISM_TRANSITION setTransition(DV_CODED_TEXT value) {
        this.transition = value;
        return this;
    }

    public DV_CODED_TEXT getCareflow_step() {
        if (this.careflow_step == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ISM_TRANSITION.careflow_step");
            }
            if (Configuration.doAutoCreate()) {
                this.careflow_step = new DV_CODED_TEXT();
            }
        }
        return this.careflow_step;
    }

    public boolean hasCareflow_step() {
        return this.careflow_step != null && !this.careflow_step.isEmpty();
    }

    public ISM_TRANSITION setCareflow_step(DV_CODED_TEXT value) {
        this.careflow_step = value;
        return this;
    }

    public List<DV_TEXT> getReasonList() {
        if (this.reasonList == null) {
            this.reasonList = new ArrayList<DV_TEXT>();
        }
        return this.reasonList;
    }

    public ISM_TRANSITION setReasonList(List<DV_TEXT> theReason) {
        this.reasonList = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reasonList == null) {
            return false;
        }
        for (DV_TEXT item : this.reasonList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DV_TEXT addReason() {
        DV_TEXT t = new DV_TEXT();
        if (this.reasonList == null) {
            this.reasonList = new ArrayList<DV_TEXT>();
        }
        this.reasonList.add(t);
        return t;
    }

    public ISM_TRANSITION addReason(DV_TEXT t) {
        if (t == null) {
            return this;
        }
        if (this.reasonList == null) {
            this.reasonList = new ArrayList<DV_TEXT>();
        }
        this.reasonList.add(t);
        return this;
    }

    public DV_TEXT getReasonFirstRep() {
        if (this.getReasonList().isEmpty()) {
            this.addReason();
        }
        return this.getReasonList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("current_state", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The ISM current state. Coded by openEHR terminology group Instruction states.", 0, 1, this.current_state));
        children.add(new Property("transition", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The ISM transition which occurred to arrive in the current_state. Coded by openEHR terminology group Instruction transitions.", 0, 1, this.transition));
        children.add(new Property("careflow_step", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The step in the careflow process which occurred as part of generating this action, e.g. dispense , start_administration. This attribute represents the clinical label for the activity, as opposed to current_state which represents the state machine (ISM) computable form. Defined in archetype.", 0, 1, this.careflow_step));
        children.add(new Property("reason", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Optional possibility of adding one or more reasons for this careflow step having been taken. Multiple reasons may occur in medication management for example.", 0, Integer.MAX_VALUE, this.reasonList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1708972469: {
                return new Property("current_state", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The ISM current state. Coded by openEHR terminology group Instruction states.", 0, 1, this.current_state);
            }
            case -1724158635: {
                return new Property("transition", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The ISM transition which occurred to arrive in the current_state. Coded by openEHR terminology group Instruction transitions.", 0, 1, this.transition);
            }
            case 2086974284: {
                return new Property("careflow_step", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The step in the careflow process which occurred as part of generating this action, e.g. dispense , start_administration. This attribute represents the clinical label for the activity, as opposed to current_state which represents the state machine (ISM) computable form. Defined in archetype.", 0, 1, this.careflow_step);
            }
            case -934964668: {
                return new Property("reason", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Optional possibility of adding one or more reasons for this careflow step having been taken. Multiple reasons may occur in medication management for example.", 0, Integer.MAX_VALUE, this.reasonList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1708972469: {
                Base[] baseArray;
                if (this.current_state == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.current_state;
                }
                return baseArray;
            }
            case -1724158635: {
                Base[] baseArray;
                if (this.transition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.transition;
                }
                return baseArray;
            }
            case 2086974284: {
                Base[] baseArray;
                if (this.careflow_step == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.careflow_step;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reasonList == null ? new Base[]{} : this.reasonList.toArray(new Base[this.reasonList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1708972469: {
                this.current_state = (DV_CODED_TEXT)value;
                return value;
            }
            case -1724158635: {
                this.transition = (DV_CODED_TEXT)value;
                return value;
            }
            case 2086974284: {
                this.careflow_step = (DV_CODED_TEXT)value;
                return value;
            }
            case -934964668: {
                this.getReasonList().add((DV_TEXT)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("current_state")) {
            this.current_state = (DV_CODED_TEXT)value;
        } else if (name.equals("transition")) {
            this.transition = (DV_CODED_TEXT)value;
        } else if (name.equals("careflow_step")) {
            this.careflow_step = (DV_CODED_TEXT)value;
        } else if (name.equals("reason")) {
            this.getReasonList().add((DV_TEXT)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1708972469: {
                return this.getCurrent_state();
            }
            case -1724158635: {
                return this.getTransition();
            }
            case 2086974284: {
                return this.getCareflow_step();
            }
            case -934964668: {
                return this.addReason();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1708972469: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case -1724158635: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case 2086974284: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case -934964668: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("current_state")) {
            this.current_state = new DV_CODED_TEXT();
            return this.current_state;
        }
        if (name.equals("transition")) {
            this.transition = new DV_CODED_TEXT();
            return this.transition;
        }
        if (name.equals("careflow_step")) {
            this.careflow_step = new DV_CODED_TEXT();
            return this.careflow_step;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ISM_TRANSITION";
    }

    @Override
    public ISM_TRANSITION copy() {
        ISM_TRANSITION dst = new ISM_TRANSITION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ISM_TRANSITION dst) {
        super.copyValues(dst);
        dst.current_state = this.current_state == null ? null : this.current_state.copy();
        dst.transition = this.transition == null ? null : this.transition.copy();
        DV_CODED_TEXT dV_CODED_TEXT = dst.careflow_step = this.careflow_step == null ? null : this.careflow_step.copy();
        if (this.reasonList != null) {
            dst.reasonList = new ArrayList<DV_TEXT>();
            for (DV_TEXT i : this.reasonList) {
                dst.reasonList.add(i.copy());
            }
        }
    }

    protected ISM_TRANSITION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ISM_TRANSITION)) {
            return false;
        }
        ISM_TRANSITION o = (ISM_TRANSITION)other_;
        return ISM_TRANSITION.compareDeep(this.current_state, o.current_state, true) && ISM_TRANSITION.compareDeep(this.transition, o.transition, true) && ISM_TRANSITION.compareDeep(this.careflow_step, o.careflow_step, true) && ISM_TRANSITION.compareDeep(this.reasonList, o.reasonList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ISM_TRANSITION)) {
            return false;
        }
        ISM_TRANSITION o = (ISM_TRANSITION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.current_state, this.transition, this.careflow_step, this.reasonList});
    }
}

