/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.openehr.ATTESTATION;
import org.hl7.fhir.r5.openehr.Any;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.OBJECT_VERSION_ID;
import org.hl7.fhir.r5.openehr.VERSION;

@DatatypeDef(name="ORIGINAL_VERSION")
public class ORIGINAL_VERSION
extends VERSION
implements ICompositeType {
    @Child(name="uid", type={OBJECT_VERSION_ID.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Stored version of inheritance precursor", formalDefinition="Stored version of inheritance precursor.")
    protected OBJECT_VERSION_ID uid;
    @Child(name="preceding_version_uid", type={OBJECT_VERSION_ID.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Stored version of inheritance precursor", formalDefinition="Stored version of inheritance precursor.")
    protected OBJECT_VERSION_ID preceding_version_uid;
    @Child(name="other_input_version_uids", type={OBJECT_VERSION_ID.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Identifiers of other versions whose content was merged into this version, if any", formalDefinition="Identifiers of other versions whose content was merged into this version, if any.")
    protected List<OBJECT_VERSION_ID> other_input_version_uidsList;
    @Child(name="lifecycle_state", type={DV_CODED_TEXT.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Lifecycle state of the content item in this version", formalDefinition="Lifecycle state of the content item in this version; coded by openEHR vocabulary version lifecycle state.")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-version_lifecycle_state")
    protected DV_CODED_TEXT lifecycle_state;
    @Child(name="attestations", type={ATTESTATION.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Set of attestations relating to this version", formalDefinition="Set of attestations relating to this version.")
    protected List<ATTESTATION> attestationsList;
    @Child(name="data", type={Reference.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Data content of this Version", formalDefinition="Data content of this Version.")
    protected Any data;
    private static final long serialVersionUID = 622601284L;

    public ORIGINAL_VERSION() {
    }

    public ORIGINAL_VERSION(OBJECT_VERSION_ID uid, OBJECT_VERSION_ID preceding_version_uid, DV_CODED_TEXT lifecycle_state) {
        this.setUid(uid);
        this.setPreceding_version_uid(preceding_version_uid);
        this.setLifecycle_state(lifecycle_state);
    }

    public OBJECT_VERSION_ID getUid() {
        if (this.uid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ORIGINAL_VERSION.uid");
            }
            if (Configuration.doAutoCreate()) {
                this.uid = new OBJECT_VERSION_ID();
            }
        }
        return this.uid;
    }

    public boolean hasUid() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public ORIGINAL_VERSION setUid(OBJECT_VERSION_ID value) {
        this.uid = value;
        return this;
    }

    public OBJECT_VERSION_ID getPreceding_version_uid() {
        if (this.preceding_version_uid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ORIGINAL_VERSION.preceding_version_uid");
            }
            if (Configuration.doAutoCreate()) {
                this.preceding_version_uid = new OBJECT_VERSION_ID();
            }
        }
        return this.preceding_version_uid;
    }

    public boolean hasPreceding_version_uid() {
        return this.preceding_version_uid != null && !this.preceding_version_uid.isEmpty();
    }

    public ORIGINAL_VERSION setPreceding_version_uid(OBJECT_VERSION_ID value) {
        this.preceding_version_uid = value;
        return this;
    }

    public List<OBJECT_VERSION_ID> getOther_input_version_uidsList() {
        if (this.other_input_version_uidsList == null) {
            this.other_input_version_uidsList = new ArrayList<OBJECT_VERSION_ID>();
        }
        return this.other_input_version_uidsList;
    }

    public ORIGINAL_VERSION setOther_input_version_uidsList(List<OBJECT_VERSION_ID> theOther_input_version_uids) {
        this.other_input_version_uidsList = theOther_input_version_uids;
        return this;
    }

    public boolean hasOther_input_version_uids() {
        if (this.other_input_version_uidsList == null) {
            return false;
        }
        for (OBJECT_VERSION_ID item : this.other_input_version_uidsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OBJECT_VERSION_ID addOther_input_version_uids() {
        OBJECT_VERSION_ID t = new OBJECT_VERSION_ID();
        if (this.other_input_version_uidsList == null) {
            this.other_input_version_uidsList = new ArrayList<OBJECT_VERSION_ID>();
        }
        this.other_input_version_uidsList.add(t);
        return t;
    }

    public ORIGINAL_VERSION addOther_input_version_uids(OBJECT_VERSION_ID t) {
        if (t == null) {
            return this;
        }
        if (this.other_input_version_uidsList == null) {
            this.other_input_version_uidsList = new ArrayList<OBJECT_VERSION_ID>();
        }
        this.other_input_version_uidsList.add(t);
        return this;
    }

    public OBJECT_VERSION_ID getOther_input_version_uidsFirstRep() {
        if (this.getOther_input_version_uidsList().isEmpty()) {
            this.addOther_input_version_uids();
        }
        return this.getOther_input_version_uidsList().get(0);
    }

    public DV_CODED_TEXT getLifecycle_state() {
        if (this.lifecycle_state == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ORIGINAL_VERSION.lifecycle_state");
            }
            if (Configuration.doAutoCreate()) {
                this.lifecycle_state = new DV_CODED_TEXT();
            }
        }
        return this.lifecycle_state;
    }

    public boolean hasLifecycle_state() {
        return this.lifecycle_state != null && !this.lifecycle_state.isEmpty();
    }

    public ORIGINAL_VERSION setLifecycle_state(DV_CODED_TEXT value) {
        this.lifecycle_state = value;
        return this;
    }

    public List<ATTESTATION> getAttestationsList() {
        if (this.attestationsList == null) {
            this.attestationsList = new ArrayList<ATTESTATION>();
        }
        return this.attestationsList;
    }

    public ORIGINAL_VERSION setAttestationsList(List<ATTESTATION> theAttestations) {
        this.attestationsList = theAttestations;
        return this;
    }

    public boolean hasAttestations() {
        if (this.attestationsList == null) {
            return false;
        }
        for (ATTESTATION item : this.attestationsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ATTESTATION addAttestations() {
        ATTESTATION t = new ATTESTATION();
        if (this.attestationsList == null) {
            this.attestationsList = new ArrayList<ATTESTATION>();
        }
        this.attestationsList.add(t);
        return t;
    }

    public ORIGINAL_VERSION addAttestations(ATTESTATION t) {
        if (t == null) {
            return this;
        }
        if (this.attestationsList == null) {
            this.attestationsList = new ArrayList<ATTESTATION>();
        }
        this.attestationsList.add(t);
        return this;
    }

    public ATTESTATION getAttestationsFirstRep() {
        if (this.getAttestationsList().isEmpty()) {
            this.addAttestations();
        }
        return this.getAttestationsList().get(0);
    }

    public Any getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public ORIGINAL_VERSION setData(Any value) {
        this.data = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("uid", "http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID", "Stored version of inheritance precursor.", 0, 1, this.uid));
        children.add(new Property("preceding_version_uid", "http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID", "Stored version of inheritance precursor.", 0, 1, this.preceding_version_uid));
        children.add(new Property("other_input_version_uids", "http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID", "Identifiers of other versions whose content was merged into this version, if any.", 0, Integer.MAX_VALUE, this.other_input_version_uidsList));
        children.add(new Property("lifecycle_state", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Lifecycle state of the content item in this version; coded by openEHR vocabulary version lifecycle state.", 0, 1, this.lifecycle_state));
        children.add(new Property("attestations", "http://openehr.org/fhir/StructureDefinition/ATTESTATION", "Set of attestations relating to this version.", 0, Integer.MAX_VALUE, this.attestationsList));
        children.add(new Property("data", "http://openehr.org/fhir/StructureDefinition/Any", "Data content of this Version.", 0, 1, this.data));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 115792: {
                return new Property("uid", "http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID", "Stored version of inheritance precursor.", 0, 1, this.uid);
            }
            case -1532609811: {
                return new Property("preceding_version_uid", "http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID", "Stored version of inheritance precursor.", 0, 1, this.preceding_version_uid);
            }
            case -653393650: {
                return new Property("other_input_version_uids", "http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID", "Identifiers of other versions whose content was merged into this version, if any.", 0, Integer.MAX_VALUE, this.other_input_version_uidsList);
            }
            case 1508726652: {
                return new Property("lifecycle_state", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Lifecycle state of the content item in this version; coded by openEHR vocabulary version lifecycle state.", 0, 1, this.lifecycle_state);
            }
            case -523510877: {
                return new Property("attestations", "http://openehr.org/fhir/StructureDefinition/ATTESTATION", "Set of attestations relating to this version.", 0, Integer.MAX_VALUE, this.attestationsList);
            }
            case 3076010: {
                return new Property("data", "http://openehr.org/fhir/StructureDefinition/Any", "Data content of this Version.", 0, 1, this.data);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 115792: {
                Base[] baseArray;
                if (this.uid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.uid;
                }
                return baseArray;
            }
            case -1532609811: {
                Base[] baseArray;
                if (this.preceding_version_uid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.preceding_version_uid;
                }
                return baseArray;
            }
            case -653393650: {
                return this.other_input_version_uidsList == null ? new Base[]{} : this.other_input_version_uidsList.toArray(new Base[this.other_input_version_uidsList.size()]);
            }
            case 1508726652: {
                Base[] baseArray;
                if (this.lifecycle_state == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.lifecycle_state;
                }
                return baseArray;
            }
            case -523510877: {
                return this.attestationsList == null ? new Base[]{} : this.attestationsList.toArray(new Base[this.attestationsList.size()]);
            }
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.data;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 115792: {
                this.uid = (OBJECT_VERSION_ID)value;
                return value;
            }
            case -1532609811: {
                this.preceding_version_uid = (OBJECT_VERSION_ID)value;
                return value;
            }
            case -653393650: {
                this.getOther_input_version_uidsList().add((OBJECT_VERSION_ID)value);
                return value;
            }
            case 1508726652: {
                this.lifecycle_state = (DV_CODED_TEXT)value;
                return value;
            }
            case -523510877: {
                this.getAttestationsList().add((ATTESTATION)value);
                return value;
            }
            case 3076010: {
                this.data = (Any)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("uid")) {
            this.uid = (OBJECT_VERSION_ID)value;
        } else if (name.equals("preceding_version_uid")) {
            this.preceding_version_uid = (OBJECT_VERSION_ID)value;
        } else if (name.equals("other_input_version_uids")) {
            this.getOther_input_version_uidsList().add((OBJECT_VERSION_ID)value);
        } else if (name.equals("lifecycle_state")) {
            this.lifecycle_state = (DV_CODED_TEXT)value;
        } else if (name.equals("attestations")) {
            this.getAttestationsList().add((ATTESTATION)value);
        } else if (name.equals("data")) {
            this.data = (Any)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                return this.getUid();
            }
            case -1532609811: {
                return this.getPreceding_version_uid();
            }
            case -653393650: {
                return this.addOther_input_version_uids();
            }
            case 1508726652: {
                return this.getLifecycle_state();
            }
            case -523510877: {
                return this.addAttestations();
            }
            case 3076010: {
                throw new Error("Unable to make an instance of the abstract property 'data'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID"};
            }
            case -1532609811: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID"};
            }
            case -653393650: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID"};
            }
            case 1508726652: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case -523510877: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ATTESTATION"};
            }
            case 3076010: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/Any"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("uid")) {
            this.uid = new OBJECT_VERSION_ID();
            return this.uid;
        }
        if (name.equals("preceding_version_uid")) {
            this.preceding_version_uid = new OBJECT_VERSION_ID();
            return this.preceding_version_uid;
        }
        if (name.equals("other_input_version_uids")) {
            return this.addOther_input_version_uids();
        }
        if (name.equals("lifecycle_state")) {
            this.lifecycle_state = new DV_CODED_TEXT();
            return this.lifecycle_state;
        }
        if (name.equals("attestations")) {
            return this.addAttestations();
        }
        if (name.equals("data")) {
            throw new FHIRException("Cannot call addChild on an abstract type ORIGINAL_VERSION.data");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ORIGINAL_VERSION";
    }

    @Override
    public ORIGINAL_VERSION copy() {
        ORIGINAL_VERSION dst = new ORIGINAL_VERSION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ORIGINAL_VERSION dst) {
        super.copyValues(dst);
        dst.uid = this.uid == null ? null : this.uid.copy();
        OBJECT_VERSION_ID oBJECT_VERSION_ID = dst.preceding_version_uid = this.preceding_version_uid == null ? null : this.preceding_version_uid.copy();
        if (this.other_input_version_uidsList != null) {
            dst.other_input_version_uidsList = new ArrayList<OBJECT_VERSION_ID>();
            for (OBJECT_VERSION_ID oBJECT_VERSION_ID2 : this.other_input_version_uidsList) {
                dst.other_input_version_uidsList.add(oBJECT_VERSION_ID2.copy());
            }
        }
        DV_CODED_TEXT dV_CODED_TEXT = dst.lifecycle_state = this.lifecycle_state == null ? null : this.lifecycle_state.copy();
        if (this.attestationsList != null) {
            dst.attestationsList = new ArrayList<ATTESTATION>();
            for (ATTESTATION aTTESTATION : this.attestationsList) {
                dst.attestationsList.add(aTTESTATION.copy());
            }
        }
        dst.data = this.data == null ? null : this.data.copy();
    }

    protected ORIGINAL_VERSION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ORIGINAL_VERSION)) {
            return false;
        }
        ORIGINAL_VERSION o = (ORIGINAL_VERSION)other_;
        return ORIGINAL_VERSION.compareDeep(this.uid, o.uid, true) && ORIGINAL_VERSION.compareDeep(this.preceding_version_uid, o.preceding_version_uid, true) && ORIGINAL_VERSION.compareDeep(this.other_input_version_uidsList, o.other_input_version_uidsList, true) && ORIGINAL_VERSION.compareDeep(this.lifecycle_state, o.lifecycle_state, true) && ORIGINAL_VERSION.compareDeep(this.attestationsList, o.attestationsList, true) && ORIGINAL_VERSION.compareDeep(this.data, o.data, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ORIGINAL_VERSION)) {
            return false;
        }
        ORIGINAL_VERSION o = (ORIGINAL_VERSION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uid, this.preceding_version_uid, this.other_input_version_uidsList, this.lifecycle_state, this.attestationsList, this.data});
    }
}

