/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CONTACT;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.LOCATABLE;
import org.hl7.fhir.r5.openehr.LOCATABLE_REF;
import org.hl7.fhir.r5.openehr.PARTY_IDENTITY;
import org.hl7.fhir.r5.openehr.PARTY_RELATIONSHIP;

@DatatypeDef(name="PARTY")
public abstract class PARTY
extends LOCATABLE
implements ICompositeType {
    @Child(name="identities", type={PARTY_IDENTITY.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Identities used by the party to identify itself, such as legal name, stage names, aliases, nicknames and so on", formalDefinition="Identities used by the party to identify itself, such as legal name, stage names, aliases, nicknames and so on.")
    protected List<PARTY_IDENTITY> identitiesList;
    @Child(name="contacts", type={CONTACT.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Contacts for this party", formalDefinition="Contacts for this party.")
    protected CONTACT contacts;
    @Child(name="details", type={ITEM_STRUCTURE.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="All other details for this Party", formalDefinition="All other details for this Party.")
    protected ITEM_STRUCTURE details;
    @Child(name="reverse_relationships", type={LOCATABLE_REF.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="References to relationships in which this Party takes part as target", formalDefinition="References to relationships in which this Party takes part as target.")
    protected List<LOCATABLE_REF> reverse_relationshipsList;
    @Child(name="relationships", type={PARTY_RELATIONSHIP.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Relationships in which this Party takes part as source", formalDefinition="Relationships in which this Party takes part as source.")
    protected List<PARTY_RELATIONSHIP> relationshipsList;
    private static final long serialVersionUID = 1369417704L;

    public List<PARTY_IDENTITY> getIdentitiesList() {
        if (this.identitiesList == null) {
            this.identitiesList = new ArrayList<PARTY_IDENTITY>();
        }
        return this.identitiesList;
    }

    public PARTY setIdentitiesList(List<PARTY_IDENTITY> theIdentities) {
        this.identitiesList = theIdentities;
        return this;
    }

    public boolean hasIdentities() {
        if (this.identitiesList == null) {
            return false;
        }
        for (PARTY_IDENTITY item : this.identitiesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PARTY_IDENTITY addIdentities() {
        PARTY_IDENTITY t = new PARTY_IDENTITY();
        if (this.identitiesList == null) {
            this.identitiesList = new ArrayList<PARTY_IDENTITY>();
        }
        this.identitiesList.add(t);
        return t;
    }

    public PARTY addIdentities(PARTY_IDENTITY t) {
        if (t == null) {
            return this;
        }
        if (this.identitiesList == null) {
            this.identitiesList = new ArrayList<PARTY_IDENTITY>();
        }
        this.identitiesList.add(t);
        return this;
    }

    public PARTY_IDENTITY getIdentitiesFirstRep() {
        if (this.getIdentitiesList().isEmpty()) {
            this.addIdentities();
        }
        return this.getIdentitiesList().get(0);
    }

    public CONTACT getContacts() {
        if (this.contacts == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTY.contacts");
            }
            if (Configuration.doAutoCreate()) {
                this.contacts = new CONTACT();
            }
        }
        return this.contacts;
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public PARTY setContacts(CONTACT value) {
        this.contacts = value;
        return this;
    }

    public ITEM_STRUCTURE getDetails() {
        return this.details;
    }

    public boolean hasDetails() {
        return this.details != null && !this.details.isEmpty();
    }

    public PARTY setDetails(ITEM_STRUCTURE value) {
        this.details = value;
        return this;
    }

    public List<LOCATABLE_REF> getReverse_relationshipsList() {
        if (this.reverse_relationshipsList == null) {
            this.reverse_relationshipsList = new ArrayList<LOCATABLE_REF>();
        }
        return this.reverse_relationshipsList;
    }

    public PARTY setReverse_relationshipsList(List<LOCATABLE_REF> theReverse_relationships) {
        this.reverse_relationshipsList = theReverse_relationships;
        return this;
    }

    public boolean hasReverse_relationships() {
        if (this.reverse_relationshipsList == null) {
            return false;
        }
        for (LOCATABLE_REF item : this.reverse_relationshipsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LOCATABLE_REF addReverse_relationships() {
        LOCATABLE_REF t = new LOCATABLE_REF();
        if (this.reverse_relationshipsList == null) {
            this.reverse_relationshipsList = new ArrayList<LOCATABLE_REF>();
        }
        this.reverse_relationshipsList.add(t);
        return t;
    }

    public PARTY addReverse_relationships(LOCATABLE_REF t) {
        if (t == null) {
            return this;
        }
        if (this.reverse_relationshipsList == null) {
            this.reverse_relationshipsList = new ArrayList<LOCATABLE_REF>();
        }
        this.reverse_relationshipsList.add(t);
        return this;
    }

    public LOCATABLE_REF getReverse_relationshipsFirstRep() {
        if (this.getReverse_relationshipsList().isEmpty()) {
            this.addReverse_relationships();
        }
        return this.getReverse_relationshipsList().get(0);
    }

    public List<PARTY_RELATIONSHIP> getRelationshipsList() {
        if (this.relationshipsList == null) {
            this.relationshipsList = new ArrayList<PARTY_RELATIONSHIP>();
        }
        return this.relationshipsList;
    }

    public PARTY setRelationshipsList(List<PARTY_RELATIONSHIP> theRelationships) {
        this.relationshipsList = theRelationships;
        return this;
    }

    public boolean hasRelationships() {
        if (this.relationshipsList == null) {
            return false;
        }
        for (PARTY_RELATIONSHIP item : this.relationshipsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PARTY_RELATIONSHIP addRelationships() {
        PARTY_RELATIONSHIP t = new PARTY_RELATIONSHIP();
        if (this.relationshipsList == null) {
            this.relationshipsList = new ArrayList<PARTY_RELATIONSHIP>();
        }
        this.relationshipsList.add(t);
        return t;
    }

    public PARTY addRelationships(PARTY_RELATIONSHIP t) {
        if (t == null) {
            return this;
        }
        if (this.relationshipsList == null) {
            this.relationshipsList = new ArrayList<PARTY_RELATIONSHIP>();
        }
        this.relationshipsList.add(t);
        return this;
    }

    public PARTY_RELATIONSHIP getRelationshipsFirstRep() {
        if (this.getRelationshipsList().isEmpty()) {
            this.addRelationships();
        }
        return this.getRelationshipsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identities", "http://openehr.org/fhir/StructureDefinition/PARTY-IDENTITY", "Identities used by the party to identify itself, such as legal name, stage names, aliases, nicknames and so on.", 0, Integer.MAX_VALUE, this.identitiesList));
        children.add(new Property("contacts", "http://openehr.org/fhir/StructureDefinition/CONTACT", "Contacts for this party.", 0, 1, this.contacts));
        children.add(new Property("details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "All other details for this Party.", 0, 1, this.details));
        children.add(new Property("reverse_relationships", "http://openehr.org/fhir/StructureDefinition/LOCATABLE-REF", "References to relationships in which this Party takes part as target.", 0, Integer.MAX_VALUE, this.reverse_relationshipsList));
        children.add(new Property("relationships", "http://openehr.org/fhir/StructureDefinition/PARTY-RELATIONSHIP", "Relationships in which this Party takes part as source.", 0, Integer.MAX_VALUE, this.relationshipsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618015780: {
                return new Property("identities", "http://openehr.org/fhir/StructureDefinition/PARTY-IDENTITY", "Identities used by the party to identify itself, such as legal name, stage names, aliases, nicknames and so on.", 0, Integer.MAX_VALUE, this.identitiesList);
            }
            case -567451565: {
                return new Property("contacts", "http://openehr.org/fhir/StructureDefinition/CONTACT", "Contacts for this party.", 0, 1, this.contacts);
            }
            case 1557721666: {
                return new Property("details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "All other details for this Party.", 0, 1, this.details);
            }
            case -96288098: {
                return new Property("reverse_relationships", "http://openehr.org/fhir/StructureDefinition/LOCATABLE-REF", "References to relationships in which this Party takes part as target.", 0, Integer.MAX_VALUE, this.reverse_relationshipsList);
            }
            case 472535355: {
                return new Property("relationships", "http://openehr.org/fhir/StructureDefinition/PARTY-RELATIONSHIP", "Relationships in which this Party takes part as source.", 0, Integer.MAX_VALUE, this.relationshipsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618015780: {
                return this.identitiesList == null ? new Base[]{} : this.identitiesList.toArray(new Base[this.identitiesList.size()]);
            }
            case -567451565: {
                Base[] baseArray;
                if (this.contacts == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.contacts;
                }
                return baseArray;
            }
            case 1557721666: {
                Base[] baseArray;
                if (this.details == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.details;
                }
                return baseArray;
            }
            case -96288098: {
                return this.reverse_relationshipsList == null ? new Base[]{} : this.reverse_relationshipsList.toArray(new Base[this.reverse_relationshipsList.size()]);
            }
            case 472535355: {
                return this.relationshipsList == null ? new Base[]{} : this.relationshipsList.toArray(new Base[this.relationshipsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618015780: {
                this.getIdentitiesList().add((PARTY_IDENTITY)value);
                return value;
            }
            case -567451565: {
                this.contacts = (CONTACT)value;
                return value;
            }
            case 1557721666: {
                this.details = (ITEM_STRUCTURE)value;
                return value;
            }
            case -96288098: {
                this.getReverse_relationshipsList().add((LOCATABLE_REF)value);
                return value;
            }
            case 472535355: {
                this.getRelationshipsList().add((PARTY_RELATIONSHIP)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identities")) {
            this.getIdentitiesList().add((PARTY_IDENTITY)value);
        } else if (name.equals("contacts")) {
            this.contacts = (CONTACT)value;
        } else if (name.equals("details")) {
            this.details = (ITEM_STRUCTURE)value;
        } else if (name.equals("reverse_relationships")) {
            this.getReverse_relationshipsList().add((LOCATABLE_REF)value);
        } else if (name.equals("relationships")) {
            this.getRelationshipsList().add((PARTY_RELATIONSHIP)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618015780: {
                return this.addIdentities();
            }
            case -567451565: {
                return this.getContacts();
            }
            case 1557721666: {
                throw new Error("Unable to make an instance of the abstract property 'details'");
            }
            case -96288098: {
                return this.addReverse_relationships();
            }
            case 472535355: {
                return this.addRelationships();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618015780: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-IDENTITY"};
            }
            case -567451565: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CONTACT"};
            }
            case 1557721666: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
            case -96288098: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/LOCATABLE-REF"};
            }
            case 472535355: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-RELATIONSHIP"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identities")) {
            return this.addIdentities();
        }
        if (name.equals("contacts")) {
            this.contacts = new CONTACT();
            return this.contacts;
        }
        if (name.equals("details")) {
            throw new FHIRException("Cannot call addChild on an abstract type PARTY.details");
        }
        if (name.equals("reverse_relationships")) {
            return this.addReverse_relationships();
        }
        if (name.equals("relationships")) {
            return this.addRelationships();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PARTY";
    }

    @Override
    public abstract PARTY copy();

    public void copyValues(PARTY dst) {
        super.copyValues(dst);
        if (this.identitiesList != null) {
            dst.identitiesList = new ArrayList<PARTY_IDENTITY>();
            for (PARTY_IDENTITY pARTY_IDENTITY : this.identitiesList) {
                dst.identitiesList.add(pARTY_IDENTITY.copy());
            }
        }
        dst.contacts = this.contacts == null ? null : this.contacts.copy();
        ITEM_STRUCTURE iTEM_STRUCTURE = dst.details = this.details == null ? null : this.details.copy();
        if (this.reverse_relationshipsList != null) {
            dst.reverse_relationshipsList = new ArrayList<LOCATABLE_REF>();
            for (LOCATABLE_REF lOCATABLE_REF : this.reverse_relationshipsList) {
                dst.reverse_relationshipsList.add(lOCATABLE_REF.copy());
            }
        }
        if (this.relationshipsList != null) {
            dst.relationshipsList = new ArrayList<PARTY_RELATIONSHIP>();
            for (PARTY_RELATIONSHIP pARTY_RELATIONSHIP : this.relationshipsList) {
                dst.relationshipsList.add(pARTY_RELATIONSHIP.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY)) {
            return false;
        }
        PARTY o = (PARTY)other_;
        return PARTY.compareDeep(this.identitiesList, o.identitiesList, true) && PARTY.compareDeep(this.contacts, o.contacts, true) && PARTY.compareDeep(this.details, o.details, true) && PARTY.compareDeep(this.reverse_relationshipsList, o.reverse_relationshipsList, true) && PARTY.compareDeep(this.relationshipsList, o.relationshipsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY)) {
            return false;
        }
        PARTY o = (PARTY)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identitiesList, this.contacts, this.details, this.reverse_relationshipsList, this.relationshipsList});
    }
}

