/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.PARTY_REF;

@DatatypeDef(name="PARTY_PROXY")
public abstract class PARTY_PROXY
extends LogicalBase
implements ICompositeType {
    @Child(name="external_ref", type={PARTY_REF.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to more detailed demographic or identification information for this party", formalDefinition="Optional reference to more detailed demographic or identification information for this party, in an external system.")
    protected PARTY_REF external_ref;
    private static final long serialVersionUID = 1726641665L;

    public PARTY_REF getExternal_ref() {
        if (this.external_ref == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTY_PROXY.external_ref");
            }
            if (Configuration.doAutoCreate()) {
                this.external_ref = new PARTY_REF();
            }
        }
        return this.external_ref;
    }

    public boolean hasExternal_ref() {
        return this.external_ref != null && !this.external_ref.isEmpty();
    }

    public PARTY_PROXY setExternal_ref(PARTY_REF value) {
        this.external_ref = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("external_ref", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.external_ref));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1385599457: {
                return new Property("external_ref", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Optional reference to more detailed demographic or identification information for this party, in an external system.", 0, 1, this.external_ref);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1385599457: {
                Base[] baseArray;
                if (this.external_ref == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.external_ref;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1385599457: {
                this.external_ref = (PARTY_REF)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("external_ref")) {
            return super.setProperty(name, value);
        }
        this.external_ref = (PARTY_REF)value;
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1385599457: {
                return this.getExternal_ref();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1385599457: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-REF"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("external_ref")) {
            this.external_ref = new PARTY_REF();
            return this.external_ref;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PARTY_PROXY";
    }

    @Override
    public abstract PARTY_PROXY copy();

    public void copyValues(PARTY_PROXY dst) {
        super.copyValues(dst);
        dst.external_ref = this.external_ref == null ? null : this.external_ref.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY_PROXY)) {
            return false;
        }
        PARTY_PROXY o = (PARTY_PROXY)other_;
        return PARTY_PROXY.compareDeep(this.external_ref, o.external_ref, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY_PROXY)) {
            return false;
        }
        PARTY_PROXY o = (PARTY_PROXY)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.external_ref});
    }
}

