/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_INTERVAL;
import org.hl7.fhir.r5.openehr.DV_TEXT;

@DatatypeDef(name="REFERENCE_RANGE")
public class REFERENCE_RANGE
extends LogicalBase
implements ICompositeType {
    @Child(name="meaning", type={DV_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Term whose value indicates the meaning of this range, e.g. normal, critical, therapeutic etc", formalDefinition="Term whose value indicates the meaning of this range, e.g. normal, critical, therapeutic etc.")
    protected DV_TEXT meaning;
    @Child(name="range", type={DV_INTERVAL.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The data range for this meaning, e.g. critical etc", formalDefinition="The data range for this meaning, e.g. critical etc.")
    protected DV_INTERVAL range;
    private static final long serialVersionUID = 610983054L;

    public REFERENCE_RANGE() {
    }

    public REFERENCE_RANGE(DV_TEXT meaning, DV_INTERVAL range) {
        this.setMeaning(meaning);
        this.setRange(range);
    }

    public DV_TEXT getMeaning() {
        if (this.meaning == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create REFERENCE_RANGE.meaning");
            }
            if (Configuration.doAutoCreate()) {
                this.meaning = new DV_TEXT();
            }
        }
        return this.meaning;
    }

    public boolean hasMeaning() {
        return this.meaning != null && !this.meaning.isEmpty();
    }

    public REFERENCE_RANGE setMeaning(DV_TEXT value) {
        this.meaning = value;
        return this;
    }

    public DV_INTERVAL getRange() {
        if (this.range == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create REFERENCE_RANGE.range");
            }
            if (Configuration.doAutoCreate()) {
                this.range = new DV_INTERVAL();
            }
        }
        return this.range;
    }

    public boolean hasRange() {
        return this.range != null && !this.range.isEmpty();
    }

    public REFERENCE_RANGE setRange(DV_INTERVAL value) {
        this.range = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("meaning", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Term whose value indicates the meaning of this range, e.g. normal, critical, therapeutic etc.", 0, 1, this.meaning));
        children.add(new Property("range", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "The data range for this meaning, e.g. critical etc.", 0, 1, this.range));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 938160637: {
                return new Property("meaning", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Term whose value indicates the meaning of this range, e.g. normal, critical, therapeutic etc.", 0, 1, this.meaning);
            }
            case 108280125: {
                return new Property("range", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "The data range for this meaning, e.g. critical etc.", 0, 1, this.range);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 938160637: {
                Base[] baseArray;
                if (this.meaning == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.meaning;
                }
                return baseArray;
            }
            case 108280125: {
                Base[] baseArray;
                if (this.range == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.range;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 938160637: {
                this.meaning = (DV_TEXT)value;
                return value;
            }
            case 108280125: {
                this.range = (DV_INTERVAL)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("meaning")) {
            this.meaning = (DV_TEXT)value;
        } else if (name.equals("range")) {
            this.range = (DV_INTERVAL)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 938160637: {
                return this.getMeaning();
            }
            case 108280125: {
                return this.getRange();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 938160637: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
            case 108280125: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-INTERVAL"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("meaning")) {
            this.meaning = new DV_TEXT();
            return this.meaning;
        }
        if (name.equals("range")) {
            this.range = new DV_INTERVAL();
            return this.range;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "REFERENCE_RANGE";
    }

    @Override
    public REFERENCE_RANGE copy() {
        REFERENCE_RANGE dst = new REFERENCE_RANGE();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(REFERENCE_RANGE dst) {
        super.copyValues(dst);
        dst.meaning = this.meaning == null ? null : this.meaning.copy();
        dst.range = this.range == null ? null : this.range.copy();
    }

    protected REFERENCE_RANGE typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof REFERENCE_RANGE)) {
            return false;
        }
        REFERENCE_RANGE o = (REFERENCE_RANGE)other_;
        return REFERENCE_RANGE.compareDeep(this.meaning, o.meaning, true) && REFERENCE_RANGE.compareDeep(this.range, o.range, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof REFERENCE_RANGE)) {
            return false;
        }
        REFERENCE_RANGE o = (REFERENCE_RANGE)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.meaning, this.range});
    }
}

