/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.AUTHORED_RESOURCE;
import org.hl7.fhir.r5.openehr.OBJECT_REF;
import org.hl7.fhir.r5.openehr.RESOURCE_DESCRIPTION_ITEM;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="RESOURCE_DESCRIPTION")
public class RESOURCE_DESCRIPTION
extends LogicalBase
implements ICompositeType {
    @Child(name="original_author", type={StringType.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Original author of this resource, with all relevant details, including organisation", formalDefinition="Original author of this resource, with all relevant details, including organisation.")
    protected List<StringType> original_authorList;
    @Child(name="other_contributors", type={StringType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Other contributors to the resource, probably listed in 'name <email>' form", formalDefinition="Other contributors to the resource, probably listed in 'name <email>' form.")
    protected List<StringType> other_contributorsList;
    @Child(name="lifecycle_state", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. initial | submitted | experimental | awaiting_approval | approved | superseded | obsolete", formalDefinition="Lifecycle state of the resource, typically including states such as: initial | submitted | experimental | awaiting_approval | approved | superseded | obsolete.")
    protected StringType lifecycle_state;
    @Child(name="resource_package_uri", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="URI of package to which this resource belongs", formalDefinition="URI of package to which this resource belongs..")
    protected StringType resource_package_uri;
    @Child(name="other_details", type={OBJECT_REF.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional non language-senstive resource meta-data, as a list of name/value pairs", formalDefinition="Additional non language-senstive resource meta-data, as a list of name/value pairs.")
    protected List<OBJECT_REF> other_detailsList;
    @Child(name="parent_resource", type={AUTHORED_RESOURCE.class}, order=5, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to owning resource", formalDefinition="Reference to owning resource.")
    protected AUTHORED_RESOURCE parent_resource;
    @Child(name="details", type={RESOURCE_DESCRIPTION_ITEM.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details of all parts of resource description that are natural language-dependent, keyed by language code", formalDefinition="Details of all parts of resource description that are natural language-dependent, keyed by language code.")
    protected List<RESOURCE_DESCRIPTION_ITEM> detailsList;
    private static final long serialVersionUID = 1426214531L;

    public RESOURCE_DESCRIPTION() {
    }

    public RESOURCE_DESCRIPTION(String lifecycle_state, AUTHORED_RESOURCE parent_resource) {
        this.setLifecycle_state(lifecycle_state);
        this.setParent_resource(parent_resource);
    }

    public List<StringType> getOriginal_authorList() {
        if (this.original_authorList == null) {
            this.original_authorList = new ArrayList<StringType>();
        }
        return this.original_authorList;
    }

    public RESOURCE_DESCRIPTION setOriginal_authorList(List<StringType> theOriginal_author) {
        this.original_authorList = theOriginal_author;
        return this;
    }

    public boolean hasOriginal_author() {
        if (this.original_authorList == null) {
            return false;
        }
        for (StringType item : this.original_authorList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addOriginal_authorElement() {
        StringType t = new StringType();
        if (this.original_authorList == null) {
            this.original_authorList = new ArrayList<StringType>();
        }
        this.original_authorList.add(t);
        return t;
    }

    public RESOURCE_DESCRIPTION addOriginal_author(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.original_authorList == null) {
            this.original_authorList = new ArrayList<StringType>();
        }
        this.original_authorList.add(t);
        return this;
    }

    public boolean hasOriginal_author(String value) {
        if (this.original_authorList == null) {
            return false;
        }
        for (StringType v : this.original_authorList) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getOther_contributorsList() {
        if (this.other_contributorsList == null) {
            this.other_contributorsList = new ArrayList<StringType>();
        }
        return this.other_contributorsList;
    }

    public RESOURCE_DESCRIPTION setOther_contributorsList(List<StringType> theOther_contributors) {
        this.other_contributorsList = theOther_contributors;
        return this;
    }

    public boolean hasOther_contributors() {
        if (this.other_contributorsList == null) {
            return false;
        }
        for (StringType item : this.other_contributorsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addOther_contributorsElement() {
        StringType t = new StringType();
        if (this.other_contributorsList == null) {
            this.other_contributorsList = new ArrayList<StringType>();
        }
        this.other_contributorsList.add(t);
        return t;
    }

    public RESOURCE_DESCRIPTION addOther_contributors(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.other_contributorsList == null) {
            this.other_contributorsList = new ArrayList<StringType>();
        }
        this.other_contributorsList.add(t);
        return this;
    }

    public boolean hasOther_contributors(String value) {
        if (this.other_contributorsList == null) {
            return false;
        }
        for (StringType v : this.other_contributorsList) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public StringType getLifecycle_stateElement() {
        if (this.lifecycle_state == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RESOURCE_DESCRIPTION.lifecycle_state");
            }
            if (Configuration.doAutoCreate()) {
                this.lifecycle_state = new StringType();
            }
        }
        return this.lifecycle_state;
    }

    public boolean hasLifecycle_stateElement() {
        return this.lifecycle_state != null && !this.lifecycle_state.isEmpty();
    }

    public boolean hasLifecycle_state() {
        return this.lifecycle_state != null && !this.lifecycle_state.isEmpty();
    }

    public RESOURCE_DESCRIPTION setLifecycle_stateElement(StringType value) {
        this.lifecycle_state = value;
        return this;
    }

    public String getLifecycle_state() {
        return this.lifecycle_state == null ? null : (String)this.lifecycle_state.getValue();
    }

    public RESOURCE_DESCRIPTION setLifecycle_state(String value) {
        if (this.lifecycle_state == null) {
            this.lifecycle_state = new StringType();
        }
        this.lifecycle_state.setValue(value);
        return this;
    }

    public StringType getResource_package_uriElement() {
        if (this.resource_package_uri == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RESOURCE_DESCRIPTION.resource_package_uri");
            }
            if (Configuration.doAutoCreate()) {
                this.resource_package_uri = new StringType();
            }
        }
        return this.resource_package_uri;
    }

    public boolean hasResource_package_uriElement() {
        return this.resource_package_uri != null && !this.resource_package_uri.isEmpty();
    }

    public boolean hasResource_package_uri() {
        return this.resource_package_uri != null && !this.resource_package_uri.isEmpty();
    }

    public RESOURCE_DESCRIPTION setResource_package_uriElement(StringType value) {
        this.resource_package_uri = value;
        return this;
    }

    public String getResource_package_uri() {
        return this.resource_package_uri == null ? null : (String)this.resource_package_uri.getValue();
    }

    public RESOURCE_DESCRIPTION setResource_package_uri(String value) {
        if (Utilities.noString((String)value)) {
            this.resource_package_uri = null;
        } else {
            if (this.resource_package_uri == null) {
                this.resource_package_uri = new StringType();
            }
            this.resource_package_uri.setValue(value);
        }
        return this;
    }

    public List<OBJECT_REF> getOther_detailsList() {
        if (this.other_detailsList == null) {
            this.other_detailsList = new ArrayList<OBJECT_REF>();
        }
        return this.other_detailsList;
    }

    public RESOURCE_DESCRIPTION setOther_detailsList(List<OBJECT_REF> theOther_details) {
        this.other_detailsList = theOther_details;
        return this;
    }

    public boolean hasOther_details() {
        if (this.other_detailsList == null) {
            return false;
        }
        for (OBJECT_REF item : this.other_detailsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OBJECT_REF addOther_details() {
        OBJECT_REF t = new OBJECT_REF();
        if (this.other_detailsList == null) {
            this.other_detailsList = new ArrayList<OBJECT_REF>();
        }
        this.other_detailsList.add(t);
        return t;
    }

    public RESOURCE_DESCRIPTION addOther_details(OBJECT_REF t) {
        if (t == null) {
            return this;
        }
        if (this.other_detailsList == null) {
            this.other_detailsList = new ArrayList<OBJECT_REF>();
        }
        this.other_detailsList.add(t);
        return this;
    }

    public OBJECT_REF getOther_detailsFirstRep() {
        if (this.getOther_detailsList().isEmpty()) {
            this.addOther_details();
        }
        return this.getOther_detailsList().get(0);
    }

    public AUTHORED_RESOURCE getParent_resource() {
        return this.parent_resource;
    }

    public boolean hasParent_resource() {
        return this.parent_resource != null && !this.parent_resource.isEmpty();
    }

    public RESOURCE_DESCRIPTION setParent_resource(AUTHORED_RESOURCE value) {
        this.parent_resource = value;
        return this;
    }

    public List<RESOURCE_DESCRIPTION_ITEM> getDetailsList() {
        if (this.detailsList == null) {
            this.detailsList = new ArrayList<RESOURCE_DESCRIPTION_ITEM>();
        }
        return this.detailsList;
    }

    public RESOURCE_DESCRIPTION setDetailsList(List<RESOURCE_DESCRIPTION_ITEM> theDetails) {
        this.detailsList = theDetails;
        return this;
    }

    public boolean hasDetails() {
        if (this.detailsList == null) {
            return false;
        }
        for (RESOURCE_DESCRIPTION_ITEM item : this.detailsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RESOURCE_DESCRIPTION_ITEM addDetails() {
        RESOURCE_DESCRIPTION_ITEM t = new RESOURCE_DESCRIPTION_ITEM();
        if (this.detailsList == null) {
            this.detailsList = new ArrayList<RESOURCE_DESCRIPTION_ITEM>();
        }
        this.detailsList.add(t);
        return t;
    }

    public RESOURCE_DESCRIPTION addDetails(RESOURCE_DESCRIPTION_ITEM t) {
        if (t == null) {
            return this;
        }
        if (this.detailsList == null) {
            this.detailsList = new ArrayList<RESOURCE_DESCRIPTION_ITEM>();
        }
        this.detailsList.add(t);
        return this;
    }

    public RESOURCE_DESCRIPTION_ITEM getDetailsFirstRep() {
        if (this.getDetailsList().isEmpty()) {
            this.addDetails();
        }
        return this.getDetailsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("original_author", "string", "Original author of this resource, with all relevant details, including organisation.", 0, Integer.MAX_VALUE, this.original_authorList));
        children.add(new Property("other_contributors", "string", "Other contributors to the resource, probably listed in 'name <email>' form.", 0, Integer.MAX_VALUE, this.other_contributorsList));
        children.add(new Property("lifecycle_state", "string", "Lifecycle state of the resource, typically including states such as: initial | submitted | experimental | awaiting_approval | approved | superseded | obsolete.", 0, 1, this.lifecycle_state));
        children.add(new Property("resource_package_uri", "string", "URI of package to which this resource belongs..", 0, 1, this.resource_package_uri));
        children.add(new Property("other_details", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Additional non language-senstive resource meta-data, as a list of name/value pairs.", 0, Integer.MAX_VALUE, this.other_detailsList));
        children.add(new Property("parent_resource", "http://openehr.org/fhir/StructureDefinition/AUTHORED-RESOURCE", "Reference to owning resource.", 0, 1, this.parent_resource));
        children.add(new Property("details", "http://openehr.org/fhir/StructureDefinition/RESOURCE-DESCRIPTION-ITEM", "Details of all parts of resource description that are natural language-dependent, keyed by language code.", 0, Integer.MAX_VALUE, this.detailsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -821815367: {
                return new Property("original_author", "string", "Original author of this resource, with all relevant details, including organisation.", 0, Integer.MAX_VALUE, this.original_authorList);
            }
            case 1215537095: {
                return new Property("other_contributors", "string", "Other contributors to the resource, probably listed in 'name <email>' form.", 0, Integer.MAX_VALUE, this.other_contributorsList);
            }
            case 1508726652: {
                return new Property("lifecycle_state", "string", "Lifecycle state of the resource, typically including states such as: initial | submitted | experimental | awaiting_approval | approved | superseded | obsolete.", 0, 1, this.lifecycle_state);
            }
            case 812585794: {
                return new Property("resource_package_uri", "string", "URI of package to which this resource belongs..", 0, 1, this.resource_package_uri);
            }
            case -1257043949: {
                return new Property("other_details", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Additional non language-senstive resource meta-data, as a list of name/value pairs.", 0, Integer.MAX_VALUE, this.other_detailsList);
            }
            case -1055650813: {
                return new Property("parent_resource", "http://openehr.org/fhir/StructureDefinition/AUTHORED-RESOURCE", "Reference to owning resource.", 0, 1, this.parent_resource);
            }
            case 1557721666: {
                return new Property("details", "http://openehr.org/fhir/StructureDefinition/RESOURCE-DESCRIPTION-ITEM", "Details of all parts of resource description that are natural language-dependent, keyed by language code.", 0, Integer.MAX_VALUE, this.detailsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -821815367: {
                return this.original_authorList == null ? new Base[]{} : this.original_authorList.toArray(new Base[this.original_authorList.size()]);
            }
            case 1215537095: {
                return this.other_contributorsList == null ? new Base[]{} : this.other_contributorsList.toArray(new Base[this.other_contributorsList.size()]);
            }
            case 1508726652: {
                Base[] baseArray;
                if (this.lifecycle_state == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.lifecycle_state;
                }
                return baseArray;
            }
            case 812585794: {
                Base[] baseArray;
                if (this.resource_package_uri == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.resource_package_uri;
                }
                return baseArray;
            }
            case -1257043949: {
                return this.other_detailsList == null ? new Base[]{} : this.other_detailsList.toArray(new Base[this.other_detailsList.size()]);
            }
            case -1055650813: {
                Base[] baseArray;
                if (this.parent_resource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.parent_resource;
                }
                return baseArray;
            }
            case 1557721666: {
                return this.detailsList == null ? new Base[]{} : this.detailsList.toArray(new Base[this.detailsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -821815367: {
                this.getOriginal_authorList().add(TypeConvertor.castToString(value));
                return value;
            }
            case 1215537095: {
                this.getOther_contributorsList().add(TypeConvertor.castToString(value));
                return value;
            }
            case 1508726652: {
                this.lifecycle_state = TypeConvertor.castToString(value);
                return value;
            }
            case 812585794: {
                this.resource_package_uri = TypeConvertor.castToString(value);
                return value;
            }
            case -1257043949: {
                this.getOther_detailsList().add((OBJECT_REF)value);
                return value;
            }
            case -1055650813: {
                this.parent_resource = (AUTHORED_RESOURCE)value;
                return value;
            }
            case 1557721666: {
                this.getDetailsList().add((RESOURCE_DESCRIPTION_ITEM)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("original_author")) {
            this.getOriginal_authorList().add(TypeConvertor.castToString(value));
        } else if (name.equals("other_contributors")) {
            this.getOther_contributorsList().add(TypeConvertor.castToString(value));
        } else if (name.equals("lifecycle_state")) {
            this.lifecycle_state = TypeConvertor.castToString(value);
        } else if (name.equals("resource_package_uri")) {
            this.resource_package_uri = TypeConvertor.castToString(value);
        } else if (name.equals("other_details")) {
            this.getOther_detailsList().add((OBJECT_REF)value);
        } else if (name.equals("parent_resource")) {
            this.parent_resource = (AUTHORED_RESOURCE)value;
        } else if (name.equals("details")) {
            this.getDetailsList().add((RESOURCE_DESCRIPTION_ITEM)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -821815367: {
                return this.addOriginal_authorElement();
            }
            case 1215537095: {
                return this.addOther_contributorsElement();
            }
            case 1508726652: {
                return this.getLifecycle_stateElement();
            }
            case 812585794: {
                return this.getResource_package_uriElement();
            }
            case -1257043949: {
                return this.addOther_details();
            }
            case -1055650813: {
                throw new Error("Unable to make an instance of the abstract property 'parent_resource'");
            }
            case 1557721666: {
                return this.addDetails();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -821815367: {
                return new String[]{"string"};
            }
            case 1215537095: {
                return new String[]{"string"};
            }
            case 1508726652: {
                return new String[]{"string"};
            }
            case 812585794: {
                return new String[]{"string"};
            }
            case -1257043949: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case -1055650813: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/AUTHORED-RESOURCE"};
            }
            case 1557721666: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/RESOURCE-DESCRIPTION-ITEM"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("original_author")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION.original_author");
        }
        if (name.equals("other_contributors")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION.other_contributors");
        }
        if (name.equals("lifecycle_state")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION.lifecycle_state");
        }
        if (name.equals("resource_package_uri")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION.resource_package_uri");
        }
        if (name.equals("other_details")) {
            return this.addOther_details();
        }
        if (name.equals("parent_resource")) {
            throw new FHIRException("Cannot call addChild on an abstract type RESOURCE_DESCRIPTION.parent_resource");
        }
        if (name.equals("details")) {
            return this.addDetails();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RESOURCE_DESCRIPTION";
    }

    @Override
    public RESOURCE_DESCRIPTION copy() {
        RESOURCE_DESCRIPTION dst = new RESOURCE_DESCRIPTION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(RESOURCE_DESCRIPTION dst) {
        super.copyValues(dst);
        if (this.original_authorList != null) {
            dst.original_authorList = new ArrayList<StringType>();
            for (StringType stringType : this.original_authorList) {
                dst.original_authorList.add(stringType.copy());
            }
        }
        if (this.other_contributorsList != null) {
            dst.other_contributorsList = new ArrayList<StringType>();
            for (StringType stringType : this.other_contributorsList) {
                dst.other_contributorsList.add(stringType.copy());
            }
        }
        dst.lifecycle_state = this.lifecycle_state == null ? null : this.lifecycle_state.copy();
        StringType stringType = dst.resource_package_uri = this.resource_package_uri == null ? null : this.resource_package_uri.copy();
        if (this.other_detailsList != null) {
            dst.other_detailsList = new ArrayList<OBJECT_REF>();
            for (OBJECT_REF oBJECT_REF : this.other_detailsList) {
                dst.other_detailsList.add(oBJECT_REF.copy());
            }
        }
        AUTHORED_RESOURCE aUTHORED_RESOURCE = dst.parent_resource = this.parent_resource == null ? null : this.parent_resource.copy();
        if (this.detailsList != null) {
            dst.detailsList = new ArrayList<RESOURCE_DESCRIPTION_ITEM>();
            for (RESOURCE_DESCRIPTION_ITEM rESOURCE_DESCRIPTION_ITEM : this.detailsList) {
                dst.detailsList.add(rESOURCE_DESCRIPTION_ITEM.copy());
            }
        }
    }

    protected RESOURCE_DESCRIPTION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RESOURCE_DESCRIPTION)) {
            return false;
        }
        RESOURCE_DESCRIPTION o = (RESOURCE_DESCRIPTION)other_;
        return RESOURCE_DESCRIPTION.compareDeep(this.original_authorList, o.original_authorList, true) && RESOURCE_DESCRIPTION.compareDeep(this.other_contributorsList, o.other_contributorsList, true) && RESOURCE_DESCRIPTION.compareDeep(this.lifecycle_state, o.lifecycle_state, true) && RESOURCE_DESCRIPTION.compareDeep(this.resource_package_uri, o.resource_package_uri, true) && RESOURCE_DESCRIPTION.compareDeep(this.other_detailsList, o.other_detailsList, true) && RESOURCE_DESCRIPTION.compareDeep(this.parent_resource, o.parent_resource, true) && RESOURCE_DESCRIPTION.compareDeep(this.detailsList, o.detailsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RESOURCE_DESCRIPTION)) {
            return false;
        }
        RESOURCE_DESCRIPTION o = (RESOURCE_DESCRIPTION)other_;
        return RESOURCE_DESCRIPTION.compareValues(this.original_authorList, o.original_authorList, true) && RESOURCE_DESCRIPTION.compareValues(this.other_contributorsList, o.other_contributorsList, true) && RESOURCE_DESCRIPTION.compareValues(this.lifecycle_state, o.lifecycle_state, true) && RESOURCE_DESCRIPTION.compareValues(this.resource_package_uri, o.resource_package_uri, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.original_authorList, this.other_contributorsList, this.lifecycle_state, this.resource_package_uri, this.other_detailsList, this.parent_resource, this.detailsList});
    }
}

