/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.AUDIT_DETAILS;
import org.hl7.fhir.r5.openehr.OBJECT_VERSION_ID;

@DatatypeDef(name="REVISION_HISTORY_ITEM")
public class REVISION_HISTORY_ITEM
extends LogicalBase
implements ICompositeType {
    @Child(name="version_id", type={OBJECT_VERSION_ID.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Version identifier for this revision", formalDefinition="Version identifier for this revision.")
    protected OBJECT_VERSION_ID version_id;
    @Child(name="audits", type={AUDIT_DETAILS.class}, order=1, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The audits for this revision (at least one)", formalDefinition="The audits for this revision; there will always be at least one commit audit (which may itself be an ATTESTATION), there may also be further attestations.")
    protected List<AUDIT_DETAILS> auditsList;
    private static final long serialVersionUID = -444855928L;

    public REVISION_HISTORY_ITEM() {
    }

    public REVISION_HISTORY_ITEM(OBJECT_VERSION_ID version_id, AUDIT_DETAILS audits) {
        this.setVersion_id(version_id);
        this.addAudits(audits);
    }

    public OBJECT_VERSION_ID getVersion_id() {
        if (this.version_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create REVISION_HISTORY_ITEM.version_id");
            }
            if (Configuration.doAutoCreate()) {
                this.version_id = new OBJECT_VERSION_ID();
            }
        }
        return this.version_id;
    }

    public boolean hasVersion_id() {
        return this.version_id != null && !this.version_id.isEmpty();
    }

    public REVISION_HISTORY_ITEM setVersion_id(OBJECT_VERSION_ID value) {
        this.version_id = value;
        return this;
    }

    public List<AUDIT_DETAILS> getAuditsList() {
        if (this.auditsList == null) {
            this.auditsList = new ArrayList<AUDIT_DETAILS>();
        }
        return this.auditsList;
    }

    public REVISION_HISTORY_ITEM setAuditsList(List<AUDIT_DETAILS> theAudits) {
        this.auditsList = theAudits;
        return this;
    }

    public boolean hasAudits() {
        if (this.auditsList == null) {
            return false;
        }
        for (AUDIT_DETAILS item : this.auditsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AUDIT_DETAILS addAudits() {
        AUDIT_DETAILS t = new AUDIT_DETAILS();
        if (this.auditsList == null) {
            this.auditsList = new ArrayList<AUDIT_DETAILS>();
        }
        this.auditsList.add(t);
        return t;
    }

    public REVISION_HISTORY_ITEM addAudits(AUDIT_DETAILS t) {
        if (t == null) {
            return this;
        }
        if (this.auditsList == null) {
            this.auditsList = new ArrayList<AUDIT_DETAILS>();
        }
        this.auditsList.add(t);
        return this;
    }

    public AUDIT_DETAILS getAuditsFirstRep() {
        if (this.getAuditsList().isEmpty()) {
            this.addAudits();
        }
        return this.getAuditsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("version_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID", "Version identifier for this revision.", 0, 1, this.version_id));
        children.add(new Property("audits", "http://openehr.org/fhir/StructureDefinition/AUDIT-DETAILS", "The audits for this revision; there will always be at least one commit audit (which may itself be an ATTESTATION), there may also be further attestations.", 0, Integer.MAX_VALUE, this.auditsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -670497310: {
                return new Property("version_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID", "Version identifier for this revision.", 0, 1, this.version_id);
            }
            case -1406803976: {
                return new Property("audits", "http://openehr.org/fhir/StructureDefinition/AUDIT-DETAILS", "The audits for this revision; there will always be at least one commit audit (which may itself be an ATTESTATION), there may also be further attestations.", 0, Integer.MAX_VALUE, this.auditsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -670497310: {
                Base[] baseArray;
                if (this.version_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.version_id;
                }
                return baseArray;
            }
            case -1406803976: {
                return this.auditsList == null ? new Base[]{} : this.auditsList.toArray(new Base[this.auditsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -670497310: {
                this.version_id = (OBJECT_VERSION_ID)value;
                return value;
            }
            case -1406803976: {
                this.getAuditsList().add((AUDIT_DETAILS)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("version_id")) {
            this.version_id = (OBJECT_VERSION_ID)value;
        } else if (name.equals("audits")) {
            this.getAuditsList().add((AUDIT_DETAILS)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -670497310: {
                return this.getVersion_id();
            }
            case -1406803976: {
                return this.addAudits();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -670497310: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-VERSION-ID"};
            }
            case -1406803976: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/AUDIT-DETAILS"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("version_id")) {
            this.version_id = new OBJECT_VERSION_ID();
            return this.version_id;
        }
        if (name.equals("audits")) {
            return this.addAudits();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "REVISION_HISTORY_ITEM";
    }

    @Override
    public REVISION_HISTORY_ITEM copy() {
        REVISION_HISTORY_ITEM dst = new REVISION_HISTORY_ITEM();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(REVISION_HISTORY_ITEM dst) {
        super.copyValues(dst);
        OBJECT_VERSION_ID oBJECT_VERSION_ID = dst.version_id = this.version_id == null ? null : this.version_id.copy();
        if (this.auditsList != null) {
            dst.auditsList = new ArrayList<AUDIT_DETAILS>();
            for (AUDIT_DETAILS i : this.auditsList) {
                dst.auditsList.add(i.copy());
            }
        }
    }

    protected REVISION_HISTORY_ITEM typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof REVISION_HISTORY_ITEM)) {
            return false;
        }
        REVISION_HISTORY_ITEM o = (REVISION_HISTORY_ITEM)other_;
        return REVISION_HISTORY_ITEM.compareDeep(this.version_id, o.version_id, true) && REVISION_HISTORY_ITEM.compareDeep(this.auditsList, o.auditsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof REVISION_HISTORY_ITEM)) {
            return false;
        }
        REVISION_HISTORY_ITEM o = (REVISION_HISTORY_ITEM)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.version_id, this.auditsList});
    }
}

