/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CONTENT_ITEM;

@DatatypeDef(name="SECTION")
public class SECTION
extends CONTENT_ITEM
implements ICompositeType {
    @Child(name="items", type={CONTENT_ITEM.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Ordered list of content items under this section, which may include more SECTIONs or ENTRYs", formalDefinition="Ordered list of content items under this section, which may include: more SECTIONs; ENTRYs.")
    protected List<CONTENT_ITEM> itemsList;
    private static final long serialVersionUID = -150066367L;

    public List<CONTENT_ITEM> getItemsList() {
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<CONTENT_ITEM>();
        }
        return this.itemsList;
    }

    public SECTION setItemsList(List<CONTENT_ITEM> theItems) {
        this.itemsList = theItems;
        return this;
    }

    public boolean hasItems() {
        if (this.itemsList == null) {
            return false;
        }
        for (CONTENT_ITEM item : this.itemsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SECTION addItems(CONTENT_ITEM t) {
        if (t == null) {
            return this;
        }
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<CONTENT_ITEM>();
        }
        this.itemsList.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("items", "http://openehr.org/fhir/StructureDefinition/CONTENT-ITEM", "Ordered list of content items under this section, which may include: more SECTIONs; ENTRYs.", 0, Integer.MAX_VALUE, this.itemsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 100526016: {
                return new Property("items", "http://openehr.org/fhir/StructureDefinition/CONTENT-ITEM", "Ordered list of content items under this section, which may include: more SECTIONs; ENTRYs.", 0, Integer.MAX_VALUE, this.itemsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return this.itemsList == null ? new Base[]{} : this.itemsList.toArray(new Base[this.itemsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 100526016: {
                this.getItemsList().add((CONTENT_ITEM)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("items")) {
            return super.setProperty(name, value);
        }
        this.getItemsList().add((CONTENT_ITEM)value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                throw new Error("Unable to make an instance of the abstract property 'items'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CONTENT-ITEM"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("items")) {
            throw new FHIRException("Cannot call addChild on an abstract type SECTION.items");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SECTION";
    }

    @Override
    public SECTION copy() {
        SECTION dst = new SECTION();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SECTION dst) {
        super.copyValues(dst);
        if (this.itemsList != null) {
            dst.itemsList = new ArrayList<CONTENT_ITEM>();
            for (CONTENT_ITEM i : this.itemsList) {
                dst.itemsList.add(i.copy());
            }
        }
    }

    protected SECTION typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SECTION)) {
            return false;
        }
        SECTION o = (SECTION)other_;
        return SECTION.compareDeep(this.itemsList, o.itemsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SECTION)) {
            return false;
        }
        SECTION o = (SECTION)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.itemsList);
    }
}

