/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.WebTemplateInputListItem;
import org.hl7.fhir.r5.openehr.WebTemplateInputValidation;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="WebTemplateInput")
public class WebTemplateInput
extends LogicalBase
implements ICompositeType {
    @Child(name="suffix", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType suffix;
    @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-input-type")
    protected CodeType type;
    @Child(name="defaultValue", type={StringType.class, IntegerType.class, DecimalType.class, BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected DataType defaultValue;
    @Child(name="terminology", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected CodeType terminology;
    @Child(name="validation", type={WebTemplateInputValidation.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected WebTemplateInputValidation validation;
    @Child(name="list", type={WebTemplateInputListItem.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected List<WebTemplateInputListItem> listList;
    @Child(name="listOpen", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected BooleanType listOpen;
    private static final long serialVersionUID = 1893964326L;

    public WebTemplateInput() {
    }

    public WebTemplateInput(String type, DataType defaultValue) {
        this.setType(type);
        this.setDefaultValue(defaultValue);
    }

    public StringType getSuffixElement() {
        if (this.suffix == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInput.suffix");
            }
            if (Configuration.doAutoCreate()) {
                this.suffix = new StringType();
            }
        }
        return this.suffix;
    }

    public boolean hasSuffixElement() {
        return this.suffix != null && !this.suffix.isEmpty();
    }

    public boolean hasSuffix() {
        return this.suffix != null && !this.suffix.isEmpty();
    }

    public WebTemplateInput setSuffixElement(StringType value) {
        this.suffix = value;
        return this;
    }

    public String getSuffix() {
        return this.suffix == null ? null : (String)this.suffix.getValue();
    }

    public WebTemplateInput setSuffix(String value) {
        if (Utilities.noString((String)value)) {
            this.suffix = null;
        } else {
            if (this.suffix == null) {
                this.suffix = new StringType();
            }
            this.suffix.setValue(value);
        }
        return this;
    }

    public CodeType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInput.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public WebTemplateInput setTypeElement(CodeType value) {
        this.type = value;
        return this;
    }

    public String getType() {
        return this.type == null ? null : (String)this.type.getValue();
    }

    public WebTemplateInput setType(String value) {
        if (this.type == null) {
            this.type = new CodeType();
        }
        this.type.setValue(value);
        return this;
    }

    public DataType getDefaultValue() {
        return this.defaultValue;
    }

    public StringType getDefaultValueStringType() throws FHIRException {
        if (this.defaultValue == null) {
            this.defaultValue = new StringType();
        }
        if (!(this.defaultValue instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.defaultValue.getClass().getName() + " was encountered");
        }
        return (StringType)this.defaultValue;
    }

    public boolean hasDefaultValueStringType() {
        return this.defaultValue instanceof StringType;
    }

    public IntegerType getDefaultValueIntegerType() throws FHIRException {
        if (this.defaultValue == null) {
            this.defaultValue = new IntegerType();
        }
        if (!(this.defaultValue instanceof IntegerType)) {
            throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.defaultValue.getClass().getName() + " was encountered");
        }
        return (IntegerType)this.defaultValue;
    }

    public boolean hasDefaultValueIntegerType() {
        return this.defaultValue instanceof IntegerType;
    }

    public DecimalType getDefaultValueDecimalType() throws FHIRException {
        if (this.defaultValue == null) {
            this.defaultValue = new DecimalType();
        }
        if (!(this.defaultValue instanceof DecimalType)) {
            throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.defaultValue.getClass().getName() + " was encountered");
        }
        return (DecimalType)this.defaultValue;
    }

    public boolean hasDefaultValueDecimalType() {
        return this.defaultValue instanceof DecimalType;
    }

    public BooleanType getDefaultValueBooleanType() throws FHIRException {
        if (this.defaultValue == null) {
            this.defaultValue = new BooleanType();
        }
        if (!(this.defaultValue instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.defaultValue.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.defaultValue;
    }

    public boolean hasDefaultValueBooleanType() {
        return this.defaultValue instanceof BooleanType;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null && !this.defaultValue.isEmpty();
    }

    public WebTemplateInput setDefaultValue(DataType value) {
        if (!(value == null || value instanceof StringType || value instanceof IntegerType || value instanceof DecimalType || value instanceof BooleanType)) {
            throw new FHIRException("Not the right type for WebTemplateInput.defaultValue: " + value.fhirType());
        }
        this.defaultValue = value;
        return this;
    }

    public CodeType getTerminologyElement() {
        if (this.terminology == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInput.terminology");
            }
            if (Configuration.doAutoCreate()) {
                this.terminology = new CodeType();
            }
        }
        return this.terminology;
    }

    public boolean hasTerminologyElement() {
        return this.terminology != null && !this.terminology.isEmpty();
    }

    public boolean hasTerminology() {
        return this.terminology != null && !this.terminology.isEmpty();
    }

    public WebTemplateInput setTerminologyElement(CodeType value) {
        this.terminology = value;
        return this;
    }

    public String getTerminology() {
        return this.terminology == null ? null : (String)this.terminology.getValue();
    }

    public WebTemplateInput setTerminology(String value) {
        if (Utilities.noString((String)value)) {
            this.terminology = null;
        } else {
            if (this.terminology == null) {
                this.terminology = new CodeType();
            }
            this.terminology.setValue(value);
        }
        return this;
    }

    public WebTemplateInputValidation getValidation() {
        if (this.validation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInput.validation");
            }
            if (Configuration.doAutoCreate()) {
                this.validation = new WebTemplateInputValidation();
            }
        }
        return this.validation;
    }

    public boolean hasValidation() {
        return this.validation != null && !this.validation.isEmpty();
    }

    public WebTemplateInput setValidation(WebTemplateInputValidation value) {
        this.validation = value;
        return this;
    }

    public List<WebTemplateInputListItem> getListList() {
        if (this.listList == null) {
            this.listList = new ArrayList<WebTemplateInputListItem>();
        }
        return this.listList;
    }

    public WebTemplateInput setListList(List<WebTemplateInputListItem> theList) {
        this.listList = theList;
        return this;
    }

    public boolean hasList() {
        if (this.listList == null) {
            return false;
        }
        for (WebTemplateInputListItem item : this.listList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public WebTemplateInputListItem addList() {
        WebTemplateInputListItem t = new WebTemplateInputListItem();
        if (this.listList == null) {
            this.listList = new ArrayList<WebTemplateInputListItem>();
        }
        this.listList.add(t);
        return t;
    }

    public WebTemplateInput addList(WebTemplateInputListItem t) {
        if (t == null) {
            return this;
        }
        if (this.listList == null) {
            this.listList = new ArrayList<WebTemplateInputListItem>();
        }
        this.listList.add(t);
        return this;
    }

    public WebTemplateInputListItem getListFirstRep() {
        if (this.getListList().isEmpty()) {
            this.addList();
        }
        return this.getListList().get(0);
    }

    public BooleanType getListOpenElement() {
        if (this.listOpen == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInput.listOpen");
            }
            if (Configuration.doAutoCreate()) {
                this.listOpen = new BooleanType();
            }
        }
        return this.listOpen;
    }

    public boolean hasListOpenElement() {
        return this.listOpen != null && !this.listOpen.isEmpty();
    }

    public boolean hasListOpen() {
        return this.listOpen != null && !this.listOpen.isEmpty();
    }

    public WebTemplateInput setListOpenElement(BooleanType value) {
        this.listOpen = value;
        return this;
    }

    public boolean getListOpen() {
        return this.listOpen == null || this.listOpen.isEmpty() ? false : (Boolean)this.listOpen.getValue();
    }

    public WebTemplateInput setListOpen(boolean value) {
        if (this.listOpen == null) {
            this.listOpen = new BooleanType();
        }
        this.listOpen.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("suffix", "string", "", 0, 1, this.suffix));
        children.add(new Property("type", "code", "", 0, 1, this.type));
        children.add(new Property("defaultValue", "string|integer|decimal|boolean", "", 0, 1, this.defaultValue));
        children.add(new Property("terminology", "code", "", 0, 1, this.terminology));
        children.add(new Property("validation", "http://openehr.org/fhir/StructureDefinition/WebTemplateInputValidation", "", 0, 1, this.validation));
        children.add(new Property("list", "http://openehr.org/fhir/StructureDefinition/WebTemplateInputListItem", "", 0, Integer.MAX_VALUE, this.listList));
        children.add(new Property("listOpen", "boolean", "", 0, 1, this.listOpen));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -891422895: {
                return new Property("suffix", "string", "", 0, 1, this.suffix);
            }
            case 3575610: {
                return new Property("type", "code", "", 0, 1, this.type);
            }
            case -659125328: {
                return new Property("defaultValue", "string|integer|decimal|boolean", "", 0, 1, this.defaultValue);
            }
            case -1905884493: {
                return new Property("terminology", "code", "", 0, 1, this.terminology);
            }
            case -43562887: {
                return new Property("validation", "http://openehr.org/fhir/StructureDefinition/WebTemplateInputValidation", "", 0, 1, this.validation);
            }
            case 3322014: {
                return new Property("list", "http://openehr.org/fhir/StructureDefinition/WebTemplateInputListItem", "", 0, Integer.MAX_VALUE, this.listList);
            }
            case 1345506312: {
                return new Property("listOpen", "boolean", "", 0, 1, this.listOpen);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -891422895: {
                Base[] baseArray;
                if (this.suffix == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.suffix;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -659125328: {
                Base[] baseArray;
                if (this.defaultValue == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.defaultValue;
                }
                return baseArray;
            }
            case -1905884493: {
                Base[] baseArray;
                if (this.terminology == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.terminology;
                }
                return baseArray;
            }
            case -43562887: {
                Base[] baseArray;
                if (this.validation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.validation;
                }
                return baseArray;
            }
            case 3322014: {
                return this.listList == null ? new Base[]{} : this.listList.toArray(new Base[this.listList.size()]);
            }
            case 1345506312: {
                Base[] baseArray;
                if (this.listOpen == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.listOpen;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -891422895: {
                this.suffix = TypeConvertor.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCode(value);
                return value;
            }
            case -659125328: {
                this.defaultValue = TypeConvertor.castToType(value);
                return value;
            }
            case -1905884493: {
                this.terminology = TypeConvertor.castToCode(value);
                return value;
            }
            case -43562887: {
                this.validation = (WebTemplateInputValidation)value;
                return value;
            }
            case 3322014: {
                this.getListList().add((WebTemplateInputListItem)value);
                return value;
            }
            case 1345506312: {
                this.listOpen = TypeConvertor.castToBoolean(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("suffix")) {
            this.suffix = TypeConvertor.castToString(value);
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCode(value);
        } else if (name.equals("defaultValue")) {
            this.defaultValue = TypeConvertor.castToType(value);
        } else if (name.equals("terminology")) {
            this.terminology = TypeConvertor.castToCode(value);
        } else if (name.equals("validation")) {
            this.validation = (WebTemplateInputValidation)value;
        } else if (name.equals("list")) {
            this.getListList().add((WebTemplateInputListItem)value);
        } else if (name.equals("listOpen")) {
            this.listOpen = TypeConvertor.castToBoolean(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -891422895: {
                return this.getSuffixElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -659125328: {
                return this.getDefaultValue();
            }
            case -1905884493: {
                return this.getTerminologyElement();
            }
            case -43562887: {
                return this.getValidation();
            }
            case 3322014: {
                return this.addList();
            }
            case 1345506312: {
                return this.getListOpenElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -891422895: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case -659125328: {
                return new String[]{"string", "integer", "decimal", "boolean"};
            }
            case -1905884493: {
                return new String[]{"code"};
            }
            case -43562887: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/WebTemplateInputValidation"};
            }
            case 3322014: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/WebTemplateInputListItem"};
            }
            case 1345506312: {
                return new String[]{"boolean"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("suffix")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInput.suffix");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInput.type");
        }
        if (name.equals("defaultValue")) {
            this.defaultValue = new StringType();
            return this.defaultValue;
        }
        if (name.equals("defaultValue")) {
            this.defaultValue = new IntegerType();
            return this.defaultValue;
        }
        if (name.equals("defaultValue")) {
            this.defaultValue = new DecimalType();
            return this.defaultValue;
        }
        if (name.equals("defaultValue")) {
            this.defaultValue = new BooleanType();
            return this.defaultValue;
        }
        if (name.equals("terminology")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInput.terminology");
        }
        if (name.equals("validation")) {
            this.validation = new WebTemplateInputValidation();
            return this.validation;
        }
        if (name.equals("list")) {
            return this.addList();
        }
        if (name.equals("listOpen")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInput.listOpen");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "WebTemplateInput";
    }

    @Override
    public WebTemplateInput copy() {
        WebTemplateInput dst = new WebTemplateInput();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(WebTemplateInput dst) {
        super.copyValues(dst);
        dst.suffix = this.suffix == null ? null : this.suffix.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.defaultValue = this.defaultValue == null ? null : this.defaultValue.copy();
        dst.terminology = this.terminology == null ? null : this.terminology.copy();
        WebTemplateInputValidation webTemplateInputValidation = dst.validation = this.validation == null ? null : this.validation.copy();
        if (this.listList != null) {
            dst.listList = new ArrayList<WebTemplateInputListItem>();
            for (WebTemplateInputListItem i : this.listList) {
                dst.listList.add(i.copy());
            }
        }
        dst.listOpen = this.listOpen == null ? null : this.listOpen.copy();
    }

    protected WebTemplateInput typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateInput)) {
            return false;
        }
        WebTemplateInput o = (WebTemplateInput)other_;
        return WebTemplateInput.compareDeep(this.suffix, o.suffix, true) && WebTemplateInput.compareDeep(this.type, o.type, true) && WebTemplateInput.compareDeep(this.defaultValue, o.defaultValue, true) && WebTemplateInput.compareDeep(this.terminology, o.terminology, true) && WebTemplateInput.compareDeep(this.validation, o.validation, true) && WebTemplateInput.compareDeep(this.listList, o.listList, true) && WebTemplateInput.compareDeep(this.listOpen, o.listOpen, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateInput)) {
            return false;
        }
        WebTemplateInput o = (WebTemplateInput)other_;
        return WebTemplateInput.compareValues(this.suffix, o.suffix, true) && WebTemplateInput.compareValues(this.type, o.type, true) && WebTemplateInput.compareValues(this.terminology, o.terminology, true) && WebTemplateInput.compareValues(this.listOpen, o.listOpen, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.suffix, this.type, this.defaultValue, this.terminology, this.validation, this.listList, this.listOpen});
    }
}

