/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="WebTemplateInputValidationRange")
public class WebTemplateInputValidationRange
extends LogicalBase
implements ICompositeType {
    @Child(name="minOp", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-range-minop")
    protected CodeType minOp;
    @Child(name="min", type={DecimalType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected DecimalType min;
    @Child(name="maxOp", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-range-maxop")
    protected CodeType maxOp;
    @Child(name="max", type={DecimalType.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected DecimalType max;
    private static final long serialVersionUID = 42305724L;

    public WebTemplateInputValidationRange() {
    }

    public WebTemplateInputValidationRange(String minOp, BigDecimal min, String maxOp, BigDecimal max) {
        this.setMinOp(minOp);
        this.setMin(min);
        this.setMaxOp(maxOp);
        this.setMax(max);
    }

    public CodeType getMinOpElement() {
        if (this.minOp == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputValidationRange.minOp");
            }
            if (Configuration.doAutoCreate()) {
                this.minOp = new CodeType();
            }
        }
        return this.minOp;
    }

    public boolean hasMinOpElement() {
        return this.minOp != null && !this.minOp.isEmpty();
    }

    public boolean hasMinOp() {
        return this.minOp != null && !this.minOp.isEmpty();
    }

    public WebTemplateInputValidationRange setMinOpElement(CodeType value) {
        this.minOp = value;
        return this;
    }

    public String getMinOp() {
        return this.minOp == null ? null : (String)this.minOp.getValue();
    }

    public WebTemplateInputValidationRange setMinOp(String value) {
        if (this.minOp == null) {
            this.minOp = new CodeType();
        }
        this.minOp.setValue(value);
        return this;
    }

    public DecimalType getMinElement() {
        if (this.min == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputValidationRange.min");
            }
            if (Configuration.doAutoCreate()) {
                this.min = new DecimalType();
            }
        }
        return this.min;
    }

    public boolean hasMinElement() {
        return this.min != null && !this.min.isEmpty();
    }

    public boolean hasMin() {
        return this.min != null && !this.min.isEmpty();
    }

    public WebTemplateInputValidationRange setMinElement(DecimalType value) {
        this.min = value;
        return this;
    }

    public BigDecimal getMin() {
        return this.min == null ? null : (BigDecimal)this.min.getValue();
    }

    public WebTemplateInputValidationRange setMin(BigDecimal value) {
        if (this.min == null) {
            this.min = new DecimalType();
        }
        this.min.setValue(value);
        return this;
    }

    public WebTemplateInputValidationRange setMin(long value) {
        this.min = new DecimalType();
        this.min.setValue(value);
        return this;
    }

    public WebTemplateInputValidationRange setMin(double value) {
        this.min = new DecimalType();
        this.min.setValue(value);
        return this;
    }

    public CodeType getMaxOpElement() {
        if (this.maxOp == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputValidationRange.maxOp");
            }
            if (Configuration.doAutoCreate()) {
                this.maxOp = new CodeType();
            }
        }
        return this.maxOp;
    }

    public boolean hasMaxOpElement() {
        return this.maxOp != null && !this.maxOp.isEmpty();
    }

    public boolean hasMaxOp() {
        return this.maxOp != null && !this.maxOp.isEmpty();
    }

    public WebTemplateInputValidationRange setMaxOpElement(CodeType value) {
        this.maxOp = value;
        return this;
    }

    public String getMaxOp() {
        return this.maxOp == null ? null : (String)this.maxOp.getValue();
    }

    public WebTemplateInputValidationRange setMaxOp(String value) {
        if (this.maxOp == null) {
            this.maxOp = new CodeType();
        }
        this.maxOp.setValue(value);
        return this;
    }

    public DecimalType getMaxElement() {
        if (this.max == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputValidationRange.max");
            }
            if (Configuration.doAutoCreate()) {
                this.max = new DecimalType();
            }
        }
        return this.max;
    }

    public boolean hasMaxElement() {
        return this.max != null && !this.max.isEmpty();
    }

    public boolean hasMax() {
        return this.max != null && !this.max.isEmpty();
    }

    public WebTemplateInputValidationRange setMaxElement(DecimalType value) {
        this.max = value;
        return this;
    }

    public BigDecimal getMax() {
        return this.max == null ? null : (BigDecimal)this.max.getValue();
    }

    public WebTemplateInputValidationRange setMax(BigDecimal value) {
        if (this.max == null) {
            this.max = new DecimalType();
        }
        this.max.setValue(value);
        return this;
    }

    public WebTemplateInputValidationRange setMax(long value) {
        this.max = new DecimalType();
        this.max.setValue(value);
        return this;
    }

    public WebTemplateInputValidationRange setMax(double value) {
        this.max = new DecimalType();
        this.max.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("minOp", "code", "", 0, 1, this.minOp));
        children.add(new Property("min", "decimal", "", 0, 1, this.min));
        children.add(new Property("maxOp", "code", "", 0, 1, this.maxOp));
        children.add(new Property("max", "decimal", "", 0, 1, this.max));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 103900115: {
                return new Property("minOp", "code", "", 0, 1, this.minOp);
            }
            case 108114: {
                return new Property("min", "decimal", "", 0, 1, this.min);
            }
            case 103671397: {
                return new Property("maxOp", "code", "", 0, 1, this.maxOp);
            }
            case 107876: {
                return new Property("max", "decimal", "", 0, 1, this.max);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 103900115: {
                Base[] baseArray;
                if (this.minOp == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.minOp;
                }
                return baseArray;
            }
            case 108114: {
                Base[] baseArray;
                if (this.min == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.min;
                }
                return baseArray;
            }
            case 103671397: {
                Base[] baseArray;
                if (this.maxOp == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.maxOp;
                }
                return baseArray;
            }
            case 107876: {
                Base[] baseArray;
                if (this.max == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.max;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 103900115: {
                this.minOp = TypeConvertor.castToCode(value);
                return value;
            }
            case 108114: {
                this.min = TypeConvertor.castToDecimal(value);
                return value;
            }
            case 103671397: {
                this.maxOp = TypeConvertor.castToCode(value);
                return value;
            }
            case 107876: {
                this.max = TypeConvertor.castToDecimal(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("minOp")) {
            this.minOp = TypeConvertor.castToCode(value);
        } else if (name.equals("min")) {
            this.min = TypeConvertor.castToDecimal(value);
        } else if (name.equals("maxOp")) {
            this.maxOp = TypeConvertor.castToCode(value);
        } else if (name.equals("max")) {
            this.max = TypeConvertor.castToDecimal(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 103900115: {
                return this.getMinOpElement();
            }
            case 108114: {
                return this.getMinElement();
            }
            case 103671397: {
                return this.getMaxOpElement();
            }
            case 107876: {
                return this.getMaxElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 103900115: {
                return new String[]{"code"};
            }
            case 108114: {
                return new String[]{"decimal"};
            }
            case 103671397: {
                return new String[]{"code"};
            }
            case 107876: {
                return new String[]{"decimal"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("minOp")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputValidationRange.minOp");
        }
        if (name.equals("min")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputValidationRange.min");
        }
        if (name.equals("maxOp")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputValidationRange.maxOp");
        }
        if (name.equals("max")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputValidationRange.max");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "WebTemplateInputValidationRange";
    }

    @Override
    public WebTemplateInputValidationRange copy() {
        WebTemplateInputValidationRange dst = new WebTemplateInputValidationRange();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(WebTemplateInputValidationRange dst) {
        super.copyValues(dst);
        dst.minOp = this.minOp == null ? null : this.minOp.copy();
        dst.min = this.min == null ? null : this.min.copy();
        dst.maxOp = this.maxOp == null ? null : this.maxOp.copy();
        dst.max = this.max == null ? null : this.max.copy();
    }

    protected WebTemplateInputValidationRange typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateInputValidationRange)) {
            return false;
        }
        WebTemplateInputValidationRange o = (WebTemplateInputValidationRange)other_;
        return WebTemplateInputValidationRange.compareDeep(this.minOp, o.minOp, true) && WebTemplateInputValidationRange.compareDeep(this.min, o.min, true) && WebTemplateInputValidationRange.compareDeep(this.maxOp, o.maxOp, true) && WebTemplateInputValidationRange.compareDeep(this.max, o.max, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateInputValidationRange)) {
            return false;
        }
        WebTemplateInputValidationRange o = (WebTemplateInputValidationRange)other_;
        return WebTemplateInputValidationRange.compareValues(this.minOp, o.minOp, true) && WebTemplateInputValidationRange.compareValues(this.min, o.min, true) && WebTemplateInputValidationRange.compareValues(this.maxOp, o.maxOp, true) && WebTemplateInputValidationRange.compareValues(this.max, o.max, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.minOp, this.min, this.maxOp, this.max});
    }
}

