/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.CodeResolver;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.terminologies.JurisdictionUtilities;
import org.hl7.fhir.r5.terminologies.utilities.SnomedUtilities;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

@MarkedToMoveToAdjunctPackage
public class DataRenderer
extends Renderer
implements CodeResolver {
    public DataRenderer(RenderingContext context) {
        super(context);
    }

    public DataRenderer(IWorkerContext worker) {
        super(worker);
    }

    public static String processRelativeUrls(String markdown, String path) {
        if (markdown == null) {
            return "";
        }
        if (!Utilities.isAbsoluteUrl((String)path)) {
            return markdown;
        }
        String basePath = path.contains("/") ? path.substring(0, path.lastIndexOf("/") + 1) : path + "/";
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < markdown.length(); ++i) {
            if (i < markdown.length() - 3 && markdown.substring(i, i + 2).equals("](")) {
                int j;
                for (j = i + 2; j < markdown.length() && markdown.charAt(j) != ')'; ++j) {
                }
                if (j < markdown.length()) {
                    String url = markdown.substring(i + 2, j);
                    if (!Utilities.isAbsoluteUrl((String)url) && !url.startsWith("..")) {
                        b.append("](");
                        b.append(basePath);
                    } else {
                        b.append("](");
                    }
                    ++i;
                    continue;
                }
                b.append(markdown.charAt(i));
                continue;
            }
            b.append(markdown.charAt(i));
        }
        return b.toString();
    }

    protected void addMarkdown(XhtmlNode x, String text, String path) throws FHIRFormatError, IOException, DefinitionException {
        this.addMarkdown(x, DataRenderer.processRelativeUrls(text, path));
    }

    protected void addMarkdown(XhtmlNode x, String text) throws FHIRFormatError, IOException, DefinitionException {
        if (text != null) {
            XhtmlDocument m;
            while (((String)text).contains("[[[")) {
                StructureDefinition p;
                String left = ((String)text).substring(0, ((String)text).indexOf("[[["));
                String link = ((String)text).substring(((String)text).indexOf("[[[") + 3, ((String)text).indexOf("]]]"));
                String right = ((String)text).substring(((String)text).indexOf("]]]") + 3);
                String path = null;
                String url = link;
                String[] parts = link.split("\\#");
                if (parts[0].contains(".")) {
                    path = parts[0];
                    parts[0] = parts[0].substring(0, parts[0].indexOf("."));
                }
                if ((p = this.getContext().getWorker().fetchResource(StructureDefinition.class, parts[0])) == null) {
                    p = this.getContext().getWorker().fetchTypeDefinition(parts[0]);
                }
                if (this.context.getTypeMap().containsKey(parts[0])) {
                    p = this.getContext().getWorker().fetchTypeDefinition(this.context.getTypeMap().get(parts[0]));
                }
                if (p == null) {
                    p = this.getContext().getWorker().fetchResource(StructureDefinition.class, link);
                }
                if (p != null) {
                    if ("Extension".equals(p.getType())) {
                        path = null;
                    } else if (p.hasSnapshot()) {
                        path = p.getSnapshot().getElementFirstRep().getPath();
                    } else if (Utilities.isAbsoluteUrl((String)path)) {
                        path = null;
                    }
                    url = p.getWebPath();
                    if (url == null) {
                        url = p.getUserString("filename");
                    }
                } else {
                    throw new DefinitionException(this.context.formatPhrase("DATA_REND_MKDWN_LNK", new Object[]{link}) + " ");
                }
                text = left + "[" + link + "](" + url + (String)(path == null ? "" : "#" + path) + ")" + right;
            }
            String s = this.getContext().getMarkdown().process((String)text, "narrative generator");
            XhtmlParser p = new XhtmlParser();
            try {
                m = p.parse("<div>" + s + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), (Throwable)e);
            }
            x.addChildNodes((List)m.getChildNodes());
        }
    }

    private static String snMonth(String m) {
        switch (m) {
            case "1": {
                return "Jan";
            }
            case "2": {
                return "Feb";
            }
            case "3": {
                return "Mar";
            }
            case "4": {
                return "Apr";
            }
            case "5": {
                return "May";
            }
            case "6": {
                return "Jun";
            }
            case "7": {
                return "Jul";
            }
            case "8": {
                return "Aug";
            }
            case "9": {
                return "Sep";
            }
            case "10": {
                return "Oct";
            }
            case "11": {
                return "Nov";
            }
            case "12": {
                return "Dec";
            }
        }
        return null;
    }

    public static String describeVersion(String version) {
        if (version.startsWith("http://snomed.info/sct")) {
            String[] p = version.split("\\/");
            String ed = null;
            Object dt = "";
            if (p[p.length - 2].equals("version")) {
                ed = p[p.length - 3];
                String y = p[p.length - 3].substring(4, 8);
                String m = p[p.length - 3].substring(2, 4);
                dt = " rel. " + DataRenderer.snMonth(m) + " " + y;
            } else {
                ed = p[p.length - 1];
            }
            switch (ed) {
                case "900000000000207008": {
                    return "Intl" + (String)dt;
                }
                case "731000124108": {
                    return "US" + (String)dt;
                }
                case "32506021000036107": {
                    return "AU" + (String)dt;
                }
                case "449081005": {
                    return "ES/Intl" + (String)dt;
                }
                case "554471000005108": {
                    return "DK" + (String)dt;
                }
                case "11000146104": {
                    return "NL" + (String)dt;
                }
                case "45991000052106": {
                    return "SE" + (String)dt;
                }
                case "83821000000107": {
                    return "UK" + (String)dt;
                }
                case "11000172109": {
                    return "BE" + (String)dt;
                }
                case "11000221109": {
                    return "AR" + (String)dt;
                }
                case "11000234105": {
                    return "AT" + (String)dt;
                }
                case "20621000087109": {
                    return "CA-EN" + (String)dt;
                }
                case "20611000087101": {
                    return "CA" + (String)dt;
                }
                case "11000181102 ": {
                    return "EE" + (String)dt;
                }
                case "11000229106": {
                    return "FI" + (String)dt;
                }
                case "11000274103": {
                    return "DE" + (String)dt;
                }
                case "1121000189102": {
                    return "IN" + (String)dt;
                }
                case "11000220105": {
                    return "IE" + (String)dt;
                }
                case "21000210109": {
                    return "NZ" + (String)dt;
                }
                case "51000202101 ": {
                    return "NO" + (String)dt;
                }
                case "11000267109": {
                    return "KR" + (String)dt;
                }
                case "900000001000122104": {
                    return "ES-ES" + (String)dt;
                }
                case "2011000195101": {
                    return "CH" + (String)dt;
                }
                case "999000021000000109": {
                    return "UK+Clinical" + (String)dt;
                }
                case "5631000179106": {
                    return "UY" + (String)dt;
                }
                case "5991000124107": {
                    return "US+ICD10CM" + (String)dt;
                }
                case "21000325107": {
                    return "CH" + (String)dt;
                }
                case "11000279109": {
                    return "CZ" + (String)dt;
                }
                case "11000181102": {
                    return "ES" + (String)dt;
                }
                case "51000202101": {
                    return "NO" + (String)dt;
                }
                case "827022005": {
                    return "IPS" + (String)dt;
                }
            }
            return "??" + (String)dt;
        }
        return version;
    }

    public String displaySystem(String system) {
        if (system == null) {
            return this.context.formatPhrase("DATA_REND_NOT_STAT", new Object[0]);
        }
        if (system.equals("http://loinc.org")) {
            return this.context.formatPhrase("DATA_REND_LOINC", new Object[0]);
        }
        if (system.startsWith("http://snomed.info")) {
            return this.context.formatPhrase("DATA_REND_SNOMED", new Object[0]);
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return this.context.formatPhrase("DATA_REND_RXNORM", new Object[0]);
        }
        if (system.equals("http://hl7.org/fhir/sid/icd-9")) {
            return this.context.formatPhrase("DATA_REND_ICD", new Object[0]);
        }
        if (system.equals("http://dicom.nema.org/resources/ontology/DCM")) {
            return this.context.formatPhrase("DATA_REND_DICOM", new Object[0]);
        }
        if (system.equals("http://unitsofmeasure.org")) {
            return this.context.formatPhrase("GENERAL_UCUM", new Object[0]);
        }
        if (system.equals("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl")) {
            return this.context.formatPhrase("GENERAL_NCI_THES", new Object[0]);
        }
        CodeSystem cs = this.context.getContext().fetchCodeSystem(system);
        if (cs != null) {
            return this.crPresent(cs);
        }
        return this.tails(system);
    }

    private String crPresent(CanonicalResource cr) {
        if (cr.hasUserData("presentation")) {
            return cr.getUserString("presentation");
        }
        if (cr.hasTitle()) {
            return this.context.getTranslated(cr.getTitleElement());
        }
        if (cr.hasName()) {
            return this.context.getTranslated(cr.getNameElement());
        }
        return cr.toString();
    }

    private String tails(String system) {
        if (system.contains("/")) {
            return system.substring(system.lastIndexOf("/") + 1);
        }
        return this.context.formatPhrase("DATA_REND_UNKNWN", new Object[0]);
    }

    protected String makeAnchor(String codeSystem, String code) {
        String s = codeSystem + "-" + code;
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (Utilities.isValidHtmlAnchorChar((char)c)) {
                b.append(c);
                continue;
            }
            b.append("|" + Integer.toHexString(c));
        }
        return b.toString();
    }

    public String lookupCode(String system, String version, String code) {
        if (JurisdictionUtilities.isJurisdiction(system)) {
            return JurisdictionUtilities.displayJurisdiction(system + "#" + code);
        }
        ValidationResult t = this.getContext().getWorker().validateCode(this.getContext().getTerminologyServiceOptions().withLanguage(this.context.getLocale().toLanguageTag()).withVersionFlexible(true), system, version, code, null);
        if (t != null && t.getDisplay() != null) {
            return t.getDisplay();
        }
        return code;
    }

    protected String describeLang(String lang) {
        if ("fr-CA".equals(lang)) {
            return "French (Canadian)";
        }
        ValueSet v = this.getContext().getWorker().findTxResource(ValueSet.class, "http://hl7.org/fhir/ValueSet/languages");
        if (v != null) {
            ValueSet.ConceptReferenceComponent l = null;
            for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                if (!cc.getCode().equals(lang)) continue;
                l = cc;
            }
            if (l == null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                    if (!cc.getCode().equals(lang)) continue;
                    l = cc;
                    break;
                }
                if (l == null) {
                    for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                        if (!cc.getCode().startsWith(lang + "-")) continue;
                        l = cc;
                        break;
                    }
                }
            }
            if (l != null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                String en = l.getDisplay();
                String nativelang = null;
                for (ValueSet.ConceptReferenceDesignationComponent cd : l.getDesignation()) {
                    if (!cd.getLanguage().equals(lang)) continue;
                    nativelang = cd.getValue();
                }
                if (nativelang == null) {
                    return en + " (" + lang + ")";
                }
                return nativelang + " (" + en + ", " + lang + ")";
            }
        }
        return lang;
    }

    private boolean isCanonical(String path) {
        if (!path.endsWith(".url")) {
            return false;
        }
        String t = path.substring(0, path.length() - 4);
        StructureDefinition sd = this.getContext().getWorker().fetchTypeDefinition(t);
        if (sd == null) {
            return false;
        }
        if (VersionUtilities.getCanonicalResourceNames((String)this.getContext().getWorker().getVersion()).contains(t)) {
            return true;
        }
        return Utilities.existsInList((String)t, (String[])new String[]{"ActivityDefinition", "CapabilityStatement", "ChargeItemDefinition", "Citation", "CodeSystem", "CompartmentDefinition", "ConceptMap", "ConditionDefinition", "EventDefinition", "Evidence", "EvidenceReport", "EvidenceVariable", "ExampleScenario", "GraphDefinition", "ImplementationGuide", "Library", "Measure", "MessageDefinition", "NamingSystem", "PlanDefinition"});
    }

    public String gt(PrimitiveType value) {
        return this.context.getTranslated(value);
    }

    public String gt(ResourceWrapper value) {
        return this.context.getTranslated(value);
    }

    public boolean hasRenderableExtensions(DataType element) {
        for (Extension ext : element.getExtension()) {
            if (!this.canRender(ext)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRenderableExtensions(BackboneType element) {
        for (Extension ext : element.getExtension()) {
            if (!this.canRender(ext)) continue;
            return true;
        }
        return element.hasModifierExtension();
    }

    public boolean hasRenderableExtensions(ResourceWrapper element) {
        for (ResourceWrapper ext : element.extensions()) {
            if (!this.canRender(ext)) continue;
            return true;
        }
        return false;
    }

    private String getExtensionLabel(Extension ext) {
        StructureDefinition sd = this.context.getWorker().fetchResource(StructureDefinition.class, ext.getUrl());
        if (sd != null && ext.hasValue() && ext.getValue().isPrimitive() && sd.hasSnapshot()) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!Utilities.existsInList((String)ed.getPath(), (String[])new String[]{"Extension", "Extension.value[x]"}) || !ed.hasLabel()) continue;
                return this.context.getTranslated(ed.getLabelElement());
            }
        }
        return null;
    }

    private String getExtensionLabel(ResourceWrapper ext) {
        StructureDefinition sd = this.context.getWorker().fetchResource(StructureDefinition.class, ext.primitiveValue("url"));
        if (sd != null && ext.has("value") && ext.child("value").isPrimitive() && sd.hasSnapshot()) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!Utilities.existsInList((String)ed.getPath(), (String[])new String[]{"Extension", "Extension.value[x]"}) || !ed.hasLabel()) continue;
                return this.context.getTranslated(ed.getLabelElement());
            }
        }
        return null;
    }

    private boolean canRender(Extension ext) {
        return this.getExtensionLabel(ext) != null;
    }

    private boolean canRender(ResourceWrapper ext) {
        StructureDefinition sd = this.context.getWorker().fetchResource(StructureDefinition.class, ext.primitiveValue("url"));
        if (sd != null && ext.has("value") && ext.isPrimitive("value") && sd.hasSnapshot()) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!Utilities.existsInList((String)ed.getPath(), (String[])new String[]{"Extension", "Extension.value[x]"}) || !ed.hasLabel()) continue;
                return true;
            }
        }
        return false;
    }

    public void renderExtensionsInList(Renderer.RenderingStatus status, XhtmlNode ul, ResourceWrapper element) throws FHIRFormatError, DefinitionException, IOException {
        for (ResourceWrapper ext : element.extensions()) {
            if (!this.canRender(ext)) continue;
            String lbl = this.getExtensionLabel(ext);
            XhtmlNode li = ul.li();
            li.tx(lbl);
            li.tx(": ");
            this.renderDataType(status, li, ext.child("value"));
        }
    }

    public void renderExtensionsInText(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper element, String sep) throws FHIRFormatError, DefinitionException, IOException {
        boolean first = true;
        for (ResourceWrapper ext : element.extensions()) {
            if (!this.canRender(ext)) continue;
            status.setExtensions(true);
            if (first) {
                first = false;
            } else {
                x.tx(sep);
                x.tx(" ");
            }
            String lbl = this.getExtensionLabel(ext);
            x.tx(lbl);
            x.tx(": ");
            this.renderDataType(status, x, ext.child("value"));
        }
    }

    protected void checkRenderExtensions(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper element) throws FHIRFormatError, DefinitionException, IOException {
        if (element.has("extension")) {
            boolean someCanRender = false;
            for (ResourceWrapper ext : element.children("extension")) {
                ResourceWrapper value = ext.child("value");
                if (!this.canRender(ext) || !value.isPrimitive()) continue;
                someCanRender = true;
            }
            if (someCanRender) {
                status.setExtensions(true);
                x.tx(" (");
                this.renderExtensionsInText(status, x, element, ", ");
                x.tx(")");
            }
        }
    }

    public static String display(IWorkerContext context, DataType type) {
        return new DataRenderer(new RenderingContext(context, null, null, "http://hl7.org/fhir/R4", "", context.getLocale(), RenderingContext.ResourceRendererMode.END_USER, RenderingContext.GenerationRules.VALID_RESOURCE)).displayDataType(type);
    }

    public String displayBase(Base b) {
        if (b instanceof DataType) {
            return this.displayDataType((DataType)b);
        }
        return this.context.formatPhrase("DATA_REND_NO_DISP", new Object[]{b.fhirType()}) + " ";
    }

    public String displayDataType(DataType type) {
        if (type == null) {
            return "";
        }
        return this.displayDataType(this.wrapNC(type));
    }

    public String displayDataType(ResourceWrapper type) {
        if (type == null || type.isEmpty()) {
            return "";
        }
        switch (type.fhirType()) {
            case "Coding": {
                return this.displayCoding(type);
            }
            case "CodeableConcept": {
                return this.displayCodeableConcept(type);
            }
            case "CodeableReference": {
                return this.displayCodeableReference(type);
            }
            case "Identifier": {
                return this.displayIdentifier(type);
            }
            case "HumanName": {
                return DataRenderer.displayHumanName(type);
            }
            case "Address": {
                return this.displayAddress(type);
            }
            case "ContactPoint": {
                return this.displayContactPoint(type);
            }
            case "Quantity": {
                return this.displayQuantity(type);
            }
            case "Range": {
                return this.displayRange(type);
            }
            case "Period": {
                return this.displayPeriod(type);
            }
            case "Timing": {
                return this.displayTiming(type);
            }
            case "SampledData": {
                return this.displaySampledData(type);
            }
            case "ContactDetail": {
                return this.displayContactDetail(type);
            }
            case "Annotation": {
                return this.displayAnnotation(type);
            }
            case "Ratio": {
                return this.displayRatio(type);
            }
            case "Reference": {
                return this.displayReference(type);
            }
            case "Money": {
                return this.displayMoney(type);
            }
            case "dateTime": 
            case "date": 
            case "instant": {
                return this.displayDateTime(type);
            }
        }
        if (type.isPrimitive()) {
            return this.context.getTranslated(type);
        }
        if (Utilities.existsInList((String)type.fhirType(), (String[])new String[]{"Meta", "Dosage", "Signature", "UsageContext", "RelatedArtifact", "ElementDefinition", "Base64BinaryType", "Attachment"})) {
            return "";
        }
        if ("Extension".equals(type.fhirType())) {
            return this.displayDataType(type.child("value"));
        }
        return this.context.formatPhrase("DATA_REND_NO_DISP", new Object[]{type.fhirType()}) + " ";
    }

    private String displayMoney(ResourceWrapper type) {
        String currency = type.primitiveValue("currency");
        String value = type.primitiveValue("value");
        return this.context.formatPhrase("DATA_REND_CURRENCY", new Object[]{currency, value});
    }

    private String displayAnnotation(ResourceWrapper type) {
        return type.primitiveValue("text");
    }

    private String displayCodeableReference(ResourceWrapper type) {
        if (type.has("reference")) {
            return this.displayReference(type.child("reference"));
        }
        return this.displayCodeableConcept(type.child("concept"));
    }

    protected String displayReference(ResourceWrapper type) {
        if (type.has("display")) {
            return type.primitiveValue("display");
        }
        if (type.has("reference")) {
            return "?ngen-3";
        }
        return "?ngen-4?";
    }

    private String displayRatio(ResourceWrapper type) {
        return this.displayQuantity(type.child("numerator")) + " / " + this.displayQuantity(type.child("denominator"));
    }

    protected String displayDateTime(ResourceWrapper type) {
        if (!type.hasPrimitiveValue()) {
            return "";
        }
        DateTimeType t = new DateTimeType(type.primitiveValue());
        if (this.isOnlyDate(t.getPrecision())) {
            DateTimeFormatter fmt = this.getDateFormatForPrecision(t);
            LocalDate date = LocalDate.of((int)t.getYear(), t.getMonth() + 1, (int)t.getDay());
            return fmt.format(date);
        }
        DateTimeFormatter fmt = this.context.getDateTimeFormat();
        if (fmt == null) {
            fmt = this.context.isTechnicalMode() ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(this.context.getLocale());
        }
        ZonedDateTime zdt = ZonedDateTime.parse(t.primitiveValue());
        ZoneId zone = this.context.getTimeZoneId();
        if (zone != null) {
            zdt = zdt.withZoneSameInstant(zone);
        }
        return fmt.format(zdt);
    }

    private DateTimeFormatter getDateFormatForPrecision(BaseDateTimeType type) {
        DateTimeFormatter fmt = this.getContextDateFormat(type);
        if (fmt != null) {
            return fmt;
        }
        if (this.context.isTechnicalMode()) {
            switch (type.getPrecision()) {
                case YEAR: {
                    return new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter();
                }
                case MONTH: {
                    return new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();
                }
            }
            return DateTimeFormatter.ISO_DATE;
        }
        switch (type.getPrecision()) {
            case YEAR: {
                return DateTimeFormatter.ofPattern("uuuu");
            }
            case MONTH: {
                return DateTimeFormatter.ofPattern("MMM uuuu");
            }
        }
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(this.context.getLocale());
    }

    private DateTimeFormatter getContextDateFormat(BaseDateTimeType type) {
        switch (type.getPrecision()) {
            case YEAR: {
                return this.context.getDateYearFormat();
            }
            case MONTH: {
                return this.context.getDateYearMonthFormat();
            }
        }
        return this.context.getDateFormat();
    }

    private boolean isOnlyDate(TemporalPrecisionEnum temporalPrecisionEnum) {
        return temporalPrecisionEnum == TemporalPrecisionEnum.YEAR || temporalPrecisionEnum == TemporalPrecisionEnum.MONTH || temporalPrecisionEnum == TemporalPrecisionEnum.DAY;
    }

    public void renderBase(Renderer.RenderingStatus status, XhtmlNode x, Base b) throws FHIRFormatError, DefinitionException, IOException {
        if (b instanceof DataType) {
            this.renderDataType(status, x, this.wrapNC((DataType)b));
        } else {
            x.tx(this.context.formatPhrase("DATA_REND_NO_DISP", new Object[]{b.fhirType()}) + " ");
        }
    }

    public boolean canRenderDataType(String type) {
        return this.context.getContextUtilities().isPrimitiveType(type) || Utilities.existsInList((String)type, (String[])new String[]{"Annotation", "Coding", "CodeableConcept", "Identifier", "HumanName", "Address", "Dosage", "Expression", "Money", "ContactPoint", "Quantity", "Range", "Period", "Timing", "SampledData", "Reference", "UsageContext", "ContactDetail", "Ratio", "Attachment", "CodeableReference"});
    }

    public boolean renderDataType(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper type) throws FHIRFormatError, DefinitionException, IOException {
        return this.renderDataType(status, x, x, type);
    }

    public boolean renderDataType(Renderer.RenderingStatus status, XhtmlNode parent, XhtmlNode x, ResourceWrapper type) throws FHIRFormatError, DefinitionException, IOException {
        if (type == null) {
            return false;
        }
        switch (type.fhirType()) {
            case "dateTime": 
            case "date": 
            case "instant": {
                this.renderDateTime(status, x, type);
                break;
            }
            case "uri": 
            case "url": {
                this.renderUri(status, x, type);
                break;
            }
            case "canonical": {
                this.renderCanonical(status, x, type);
                break;
            }
            case "Annotation": {
                this.renderAnnotation(status, parent, x, type);
                break;
            }
            case "Coding": {
                this.renderCodingWithDetails(status, x, type);
                break;
            }
            case "CodeableConcept": {
                this.renderCodeableConcept(status, x, type);
                break;
            }
            case "Identifier": {
                this.renderIdentifier(status, x, type);
                break;
            }
            case "HumanName": {
                this.renderHumanName(status, x, type);
                break;
            }
            case "Address": {
                this.renderAddress(status, x, type);
                break;
            }
            case "Expression": {
                this.renderExpression(status, x, type);
                break;
            }
            case "Money": {
                this.renderMoney(status, x, type);
                break;
            }
            case "ContactPoint": {
                this.renderContactPoint(status, x, type);
                break;
            }
            case "Quantity": 
            case "Age": {
                this.renderQuantity(status, x, type);
                break;
            }
            case "Range": {
                this.renderRange(status, x, type);
                break;
            }
            case "Period": {
                this.renderPeriod(status, x, type);
                break;
            }
            case "Timing": {
                this.renderTiming(status, x, type);
                break;
            }
            case "SampledData": {
                this.renderSampledData(status, x, type);
                break;
            }
            case "Reference": {
                this.renderReference(status, x, type);
                break;
            }
            case "UsageContext": {
                this.renderUsageContext(status, x, type);
                break;
            }
            case "ContactDetail": {
                this.renderContactDetail(status, x, type);
                break;
            }
            case "Ratio": {
                this.renderRatio(status, x, type);
                break;
            }
            case "Attachment": {
                this.renderAttachment(status, x, type);
                break;
            }
            case "CodeableReference": {
                if (type.has("concept")) {
                    this.renderCodeableConcept(status, x, type.child("concept"));
                    break;
                }
                this.renderReference(status, x, type.child("reference"));
                break;
            }
            case "code": {
                x.tx(this.getTranslatedCode(type));
                break;
            }
            case "markdown": {
                this.addMarkdown(parent == null ? x : parent, this.context.getTranslated(type));
                break;
            }
            case "base64Binary": {
                int length = type.primitiveValue().length();
                if (length >= this.context.getBase64Limit()) {
                    x.tx(this.context.formatPhrase("DATA_REND_BASE64", new Object[]{length}));
                    break;
                }
                x.code(type.primitiveValue());
                break;
            }
            default: {
                if (type.isPrimitive()) {
                    if (this.renderPrimitiveWithNoValue(status, x, type)) break;
                    x.tx(this.context.getTranslated(type));
                    break;
                }
                x.tx(this.context.formatPhrase("DATA_REND_NO_DISP", new Object[]{type.fhirType()}) + " ");
                return false;
            }
        }
        return true;
    }

    protected void renderCanonical(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper type) throws FHIRFormatError, DefinitionException, IOException {
        this.renderUri(status, x, type);
    }

    private void renderRatio(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper type) throws FHIRFormatError, DefinitionException, IOException {
        this.renderQuantity(status, x, type.child("numerator"));
        x.tx("/");
        this.renderQuantity(status, x, type.child("denominator"));
        this.checkRenderExtensions(status, x, type);
    }

    private void renderAttachment(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper att) {
        String ct = att.primitiveValue("contentType");
        if (att.has("url")) {
            x.tx(this.context.formatMessage("DATA_REND_ATT_URL", new Object[]{ct, att.primitiveValue("url")}));
        } else if (att.has("data")) {
            x.tx(this.context.formatMessage("DATA_REND_ATT_DATA", new Object[]{ct, this.displayDataType(att.child("data"))}));
        }
    }

    private void renderContactDetail(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper cd) {
        if (cd.has("name")) {
            x.tx(cd.primitiveValue("name") + ": ");
        }
        boolean first = true;
        for (ResourceWrapper c : cd.children("telecom")) {
            if (first) {
                first = false;
            } else {
                x.tx(",");
            }
            this.renderContactPoint(status, x, c);
        }
    }

    private void renderDateTime(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper type) throws FHIRFormatError, DefinitionException, IOException {
        if (!this.renderPrimitiveWithNoValue(status, x, type)) {
            x.tx(this.displayDateTime(type));
            this.checkRenderExtensions(status, x, type);
        }
    }

    protected void renderReference(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper ref) throws FHIRFormatError, DefinitionException, IOException {
        if (ref.has("display")) {
            x.tx(this.context.getTranslated(ref.child("display")));
        } else if (ref.has("reference")) {
            x.tx(ref.primitiveValue("reference"));
        } else {
            x.tx("??");
        }
    }

    protected boolean renderPrimitiveWithNoValue(Renderer.RenderingStatus status, XhtmlNode x, PrimitiveType<?> prim) throws FHIRFormatError, DefinitionException, IOException {
        if (prim.hasPrimitiveValue()) {
            return false;
        }
        boolean first = true;
        for (Extension ext : prim.getExtension()) {
            if (first) {
                first = false;
            } else {
                x.tx(", ");
            }
            String url = ext.getUrl();
            if (url.equals("http://hl7.org/fhir/StructureDefinition/data-absent-reason")) {
                x.tx("Absent because : ");
                this.displayCode(x, this.wrapNC(ext.getValue()));
                continue;
            }
            if (url.equals("http://hl7.org/fhir/StructureDefinition/iso21090-nullFlavor")) {
                x.tx("Null because: ");
                this.displayCode(x, this.wrapNC(ext.getValue()));
                continue;
            }
            if (url.equals("http://hl7.org/fhir/StructureDefinition/originalText")) {
                x.code().tx("Text: ");
                this.displayCode(x, this.wrapNC(ext.getValue()));
                continue;
            }
            if (url.equals("http://hl7.org/fhir/StructureDefinition/cqf-expression")) {
                x.code().tx("Value calculated by: ");
                this.renderExpression(status, x, this.wrapNC(ext.getValue()));
                continue;
            }
            StructureDefinition def = this.context.getContext().fetchResource(StructureDefinition.class, url);
            if (def == null) {
                x.code().tx(this.tail(url) + ": ");
            } else {
                x.code().tx(def.present() + ": ");
            }
            this.renderDataType(status, x, this.wrapNC(ext.getValue()));
        }
        status.setExtensions(true);
        return true;
    }

    protected boolean renderPrimitiveWithNoValue(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper prim) throws FHIRFormatError, DefinitionException, IOException {
        if (prim.hasPrimitiveValue()) {
            return false;
        }
        boolean first = true;
        for (ResourceWrapper ext : prim.extensions()) {
            if (first) {
                first = false;
            } else {
                x.tx(", ");
            }
            String url = ext.primitiveValue("url");
            if (url.equals("http://hl7.org/fhir/StructureDefinition/data-absent-reason")) {
                x.tx("Absent because : ");
                this.displayCode(x, ext.child("value"));
                continue;
            }
            if (url.equals("http://hl7.org/fhir/StructureDefinition/iso21090-nullFlavor")) {
                x.tx("Null because: ");
                this.displayCode(x, ext.child("value"));
                continue;
            }
            if (url.equals("http://hl7.org/fhir/StructureDefinition/originalText")) {
                x.code().tx("Text: ");
                this.displayCode(x, ext.child("value"));
                continue;
            }
            if (url.equals("http://hl7.org/fhir/StructureDefinition/cqf-expression")) {
                x.code().tx("Value calculated by: ");
                this.renderExpression(status, x, ext.child("value"));
                continue;
            }
            StructureDefinition def = this.context.getContext().fetchResource(StructureDefinition.class, url);
            if (def == null) {
                x.code().tx(this.tail(url) + ": ");
            } else {
                x.code().tx(def.present() + ": ");
            }
            this.renderDataType(status, x, ext.child("value"));
        }
        status.setExtensions(true);
        return true;
    }

    protected String tail(String url) {
        return url.substring(url.lastIndexOf(".") + 1);
    }

    protected String utail(String url) {
        return url.contains("/") ? url.substring(url.lastIndexOf("/") + 1) : url;
    }

    private void displayCode(XhtmlNode x, ResourceWrapper code) {
        x.tx(code.primitiveValue());
    }

    protected void renderUri(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper uri) throws FHIRFormatError, DefinitionException, IOException {
        Object v;
        if (!this.renderPrimitiveWithNoValue(status, x, uri) && (v = uri.primitiveValue()) != null) {
            if (this.context.getContextUtilities().isResource((String)v)) {
                v = "http://hl7.org/fhir/" + (String)v;
            }
            if (((String)v).startsWith("mailto:")) {
                x.ah((String)v).addText(((String)v).substring(7));
            } else {
                Resource r = this.context.getContext().fetchResource(Resource.class, (String)v);
                if (r != null && r.getWebPath() != null) {
                    if (r instanceof CanonicalResource) {
                        x.ah(this.context.prefixLocalHref(r.getWebPath())).addText(this.crPresent((CanonicalResource)r));
                    } else {
                        x.ah(this.context.prefixLocalHref(r.getWebPath())).addText((String)v);
                    }
                } else {
                    String url;
                    String string = url = this.context.getResolver() != null ? this.context.getResolver().resolveUri(this.context, (String)v) : null;
                    if (url != null) {
                        x.ah(this.context.prefixLocalHref(url)).addText((String)v);
                    } else if (Utilities.isAbsoluteUrlLinkable((String)v) && !uri.fhirType().equals("id")) {
                        x.ah(this.context.prefixLocalHref((String)v)).addText((String)v);
                    } else {
                        x.addText((String)v);
                    }
                }
            }
        }
        this.checkRenderExtensions(status, x, uri);
    }

    protected void renderAnnotation(Renderer.RenderingStatus status, XhtmlNode parent, XhtmlNode x, ResourceWrapper a) throws FHIRException, IOException {
        if (a.has("text")) {
            this.addMarkdown(parent.blockquote(), this.context.getTranslated(a.child("text")));
        }
        if (a.has("author")) {
            x.tx(this.context.formatPhrase("DATA_REND_BY", new Object[0]) + " ");
            ResourceWrapper auth = a.child("author");
            if (auth.fhirType().equals("Reference")) {
                x.tx(auth.primitiveValue("reference"));
            } else if (auth.fhirType().equals("string")) {
                x.tx(this.context.getTranslated(auth));
            }
        }
        if (a.has("time")) {
            if (a.has("author")) {
                x.tx(" ");
            }
            x.tx("@");
            x.tx(this.displayDateTime(a.child("time")));
        }
    }

    public String displayCoding(ResourceWrapper c) {
        Object s = "";
        if (this.context.isTechnicalMode()) {
            s = this.context.getTranslated(c.child("display"));
            if (Utilities.noString((String)s)) {
                s = this.lookupCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"));
            }
            if (Utilities.noString((String)s)) {
                s = this.displayCodeTriple(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"));
            } else if (c.has("system")) {
                s = (String)s + " (" + this.displayCodeTriple(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code")) + ")";
            } else if (c.has("code")) {
                s = (String)s + " (" + c.primitiveValue("code") + ")";
            }
        } else {
            if (c.has("display")) {
                return this.context.getTranslated(c.child("display"));
            }
            if (Utilities.noString((String)s)) {
                s = this.lookupCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"));
            }
            if (Utilities.noString((String)s)) {
                s = c.primitiveValue("code");
            }
        }
        return s;
    }

    public String displayCodeSource(String system, String version) {
        Object s = this.displaySystem(system);
        if (version != null) {
            s = (String)s + "[" + DataRenderer.describeVersion(version) + "]";
        }
        return s;
    }

    private String displayCodeTriple(String system, String version, String code) {
        if (system == null) {
            if (code == null) {
                return "";
            }
            return "#" + code;
        }
        Object s = this.displayCodeSource(system, version);
        if (code != null) {
            s = (String)s + "#" + code;
        }
        return s;
    }

    public String displayCoding(List<Coding> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Coding c : list) {
            b.append(this.displayCoding(this.wrapNC(c)));
        }
        return b.toString();
    }

    protected void renderCoding(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Piece> pieces, Coding c) {
        if (c.isEmpty()) {
            return;
        }
        String url = this.getLinkForSystem(c.getSystem(), c.getVersion());
        String name = this.displayCodeSource(c.getSystem(), c.getVersion());
        if (!Utilities.noString((String)url)) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url, name, c.getSystem() + (String)(c.hasVersion() ? "#" + c.getVersion() : "")));
        } else {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, name, c.getSystem() + (String)(c.hasVersion() ? "#" + c.getVersion() : "")));
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "#" + c.getCode(), null));
        String s = this.context.getTranslated(c.getDisplayElement());
        if (Utilities.noString((String)s)) {
            s = this.lookupCode(c.getSystem(), c.getVersion(), c.getCode());
        }
        if (!Utilities.noString((String)s)) {
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, " \"" + s + "\"", null));
        }
    }

    protected void renderCoding(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Piece> pieces, ResourceWrapper c) {
        if (c.isEmpty()) {
            return;
        }
        String url = this.getLinkForSystem(c.primitiveValue("system"), c.primitiveValue("version"));
        String name = this.displayCodeSource(c.primitiveValue("system"), c.primitiveValue("version"));
        if (!Utilities.noString((String)url)) {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, url, name, c.primitiveValue("system") + (String)(c.has("version") ? "#" + c.primitiveValue("version") : "")));
        } else {
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, name, c.primitiveValue("system") + (String)(c.has("version") ? "#" + c.primitiveValue("version") : "")));
        }
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, "#" + c.primitiveValue("code"), null));
        String s = this.context.getTranslated(c.child("display"));
        if (Utilities.noString((String)s)) {
            s = this.lookupCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"));
        }
        if (!Utilities.noString((String)s)) {
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, " \"" + s + "\"", null));
        }
    }

    public String getLinkForSystem(String system, String version) {
        CodeSystem cs;
        if ("http://snomed.info/sct".equals(system)) {
            return "https://browser.ihtsdotools.org/";
        }
        if ("http://loinc.org".equals(system)) {
            return "https://loinc.org/";
        }
        if ("http://unitsofmeasure.org".equals(system)) {
            return "http://ucum.org";
        }
        if ("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl".equals(system)) {
            return "https://ncit.nci.nih.gov/ncitbrowser/pages/home.jsf";
        }
        Object url = system;
        if (version != null) {
            url = (String)url + "|" + version;
        }
        if ((cs = this.context.getWorker().fetchCodeSystem((String)url)) != null && cs.hasWebPath()) {
            return cs.getWebPath();
        }
        return null;
    }

    public String getLinkForCode(String system, String version, String code) {
        if ("http://snomed.info/sct".equals(system)) {
            return SnomedUtilities.getSctLink(version, code, this.context.getContext().getExpansionParameters());
        }
        if ("http://loinc.org".equals(system)) {
            if (!Utilities.noString((String)code)) {
                return "https://loinc.org/" + code;
            }
            return "https://loinc.org/";
        }
        if ("http://www.nlm.nih.gov/research/umls/rxnorm".equals(system)) {
            if (!Utilities.noString((String)code)) {
                return "https://mor.nlm.nih.gov/RxNav/search?searchBy=RXCUI&searchTerm=" + code;
            }
            return "https://www.nlm.nih.gov/research/umls/rxnorm/index.html";
        }
        if ("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl".equals(system)) {
            if (!Utilities.noString((String)code)) {
                return "https://ncit.nci.nih.gov/ncitbrowser/ConceptReport.jsp?code=" + code;
            }
            return "https://ncit.nci.nih.gov/ncitbrowser/pages/home.jsf";
        }
        if ("urn:iso:std:iso:3166".equals(system)) {
            if (!Utilities.noString((String)code)) {
                return "https://en.wikipedia.org/wiki/ISO_3166-2:" + code;
            }
            return "https://en.wikipedia.org/wiki/ISO_3166-2";
        }
        CodeSystem cs = this.context.getWorker().fetchCodeSystem(system, version);
        if (cs != null && cs.hasWebPath()) {
            if (!Utilities.noString((String)code)) {
                return cs.getWebPath() + "#" + cs.getId() + "-" + Utilities.nmtokenize((String)code);
            }
            return cs.getWebPath();
        }
        return null;
    }

    @Override
    public CodeResolver.CodeResolution resolveCode(String system, String code) {
        return this.resolveCode(new Coding().setSystem(system).setCode(code));
    }

    public CodeResolver.CodeResolution resolveCode(ResourceWrapper c) {
        CodeSystem cs;
        String display = null;
        if (c.has("display")) {
            display = this.context.getTranslated(c.child("display"));
        }
        if (Utilities.noString(display)) {
            display = this.lookupCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"));
        }
        if (Utilities.noString(display)) {
            display = c.primitiveValue("code");
        }
        String systemLink = (cs = this.context.getWorker().fetchCodeSystem(c.primitiveValue("system"))) != null ? cs.getWebPath() : null;
        String systemName = cs != null ? this.crPresent(cs) : this.displaySystem(c.primitiveValue("system"));
        String link = this.getLinkForCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"));
        String hint = systemName + ": " + display + (String)(c.has("version") ? " " + this.context.formatPhrase("DATA_REND_VERSION", new Object[]{c.primitiveValue("version"), ")"}) : "");
        return new CodeResolver.CodeResolution(systemName, systemLink, link, display, hint);
    }

    @Override
    public CodeResolver.CodeResolution resolveCode(Coding code) {
        return this.resolveCode(this.wrapNC(code));
    }

    @Override
    public CodeResolver.CodeResolution resolveCode(CodeableConcept code) {
        if (code.hasCoding()) {
            return this.resolveCode(code.getCodingFirstRep());
        }
        return new CodeResolver.CodeResolution(null, null, null, code.getText(), code.getText());
    }

    protected void renderCodingWithDetails(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper c) throws FHIRFormatError, DefinitionException, IOException {
        String s = "";
        if (c.has("display")) {
            s = this.context.getTranslated(c.child("display"));
        }
        if (Utilities.noString((String)s)) {
            s = this.lookupCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"));
        }
        String sn = this.displaySystem(c.primitiveValue("system"));
        String link = this.getLinkForCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"));
        XhtmlNode xi = link != null ? x.ah(this.context.prefixLocalHref(link)) : x;
        xi.tx(sn);
        xi.tx(" ");
        xi.tx(c.primitiveValue("code"));
        if (!Utilities.noString((String)s)) {
            x.tx(": ");
            x.tx(s);
        }
        if (c.has("version")) {
            x.tx(" " + this.context.formatPhrase("DATA_REND_VERSION", new Object[]{c.primitiveValue("version"), ")"}));
        }
        this.checkRenderExtensions(status, x, c);
    }

    protected void renderCoding(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper c) {
        this.renderCoding(status, x, c, true);
    }

    protected void renderCoding(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper c, boolean details) {
        String s = "";
        if (c.has("display")) {
            s = this.context.getTranslated(c.child("display"));
        }
        if (Utilities.noString((String)s)) {
            s = this.lookupCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"));
        }
        if (Utilities.noString((String)s)) {
            s = c.primitiveValue("code");
        }
        if (this.context.isTechnicalMode() && details) {
            String d = c.primitiveValue("display") == null ? this.lookupCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code")) : c.primitiveValue("display");
            d = this.context.formatPhrase(d == null || d.equals(c.primitiveValue("code")) ? "DATA_REND_DETAILS_STATED_ND" : "DATA_REND_DETAILS_STATED", new Object[]{this.displaySystem(c.primitiveValue("system")), c.primitiveValue("code"), d});
            x.addText(s + " " + d);
        } else {
            x.span(null, "{" + c.primitiveValue("system") + " " + c.primitiveValue("code") + "}").addText(s);
        }
    }

    public String displayCodeableConcept(ResourceWrapper cc) {
        String s = this.context.getTranslated(cc.child("Text"));
        if (Utilities.noString((String)s)) {
            for (ResourceWrapper c : cc.children("coding")) {
                if (!c.has("display")) continue;
                s = this.context.getTranslated(c.child("display"));
                break;
            }
        }
        if (Utilities.noString((String)s)) {
            for (ResourceWrapper c : cc.children("coding")) {
                if (c.has("code") && c.has("system") && !Utilities.noString((String)(s = this.lookupCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"))))) break;
            }
        }
        if (Utilities.noString((String)s)) {
            s = !cc.has("coding") ? "" : cc.children("coding").get(0).primitiveValue("code");
        }
        return s;
    }

    protected void renderCodeableReference(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper e) throws FHIRFormatError, DefinitionException, IOException {
        if (e.has("concept")) {
            this.renderCodeableConcept(status, x, e.child("concept"));
        }
        if (e.has("reference")) {
            this.renderReference(status, x, e.child("reference"));
        }
    }

    protected void renderCodeableConcept(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper cc) throws FHIRFormatError, DefinitionException, IOException {
        if (cc.isEmpty()) {
            return;
        }
        String s = this.context.getTranslated(cc.child("text"));
        if (Utilities.noString((String)s)) {
            for (ResourceWrapper c : cc.children("coding")) {
                if (!c.has("display")) continue;
                s = this.context.getTranslated(c.child("display"));
                break;
            }
        }
        if (Utilities.noString((String)s)) {
            for (ResourceWrapper c : cc.children("coding")) {
                if (c.has("code") && c.has("system") && !Utilities.noString((String)(s = this.lookupCode(c.primitiveValue("system"), c.primitiveValue("version"), c.primitiveValue("code"))))) break;
            }
        }
        if (Utilities.noString((String)s)) {
            s = !cc.has("coding") ? "" : cc.children("coding").get(0).primitiveValue("code");
        }
        if (status.isShowCodeDetails()) {
            x.addTextWithLineBreaks(s + " ");
            XhtmlNode sp = x.span("background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki", null);
            sp.tx(" (");
            boolean first = true;
            for (ResourceWrapper c : cc.children("coding")) {
                if (first) {
                    first = false;
                } else {
                    sp.tx("; ");
                }
                String url = this.getLinkForSystem(c.primitiveValue("system"), c.primitiveValue("version"));
                if (url != null) {
                    sp.ah(this.context.prefixLocalHref(url)).tx(this.displayCodeSource(c.primitiveValue("system"), c.primitiveValue("version")));
                } else {
                    sp.tx(this.displayCodeSource(c.primitiveValue("system"), c.primitiveValue("version")));
                }
                if (c.has("code")) {
                    sp.tx("#" + c.primitiveValue("code"));
                }
                if (!c.has("display") || s.equals(c.primitiveValue("display"))) continue;
                sp.tx(" \"" + this.context.getTranslated(c.child("display")) + "\"");
            }
            if (this.hasRenderableExtensions(cc)) {
                if (!first) {
                    sp.tx("; ");
                }
                this.renderExtensionsInText(status, sp, cc, ";");
            }
            sp.tx(")");
        } else {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (ResourceWrapper c : cc.children("coding")) {
                if (!c.has("code") || !c.has("system")) continue;
                b.append("{" + c.primitiveValue("system") + " " + c.primitiveValue("code") + "}");
            }
            x.span(null, this.context.formatPhrase("DATA_REND_CODES", new Object[0]) + b.toString()).addTextWithLineBreaks(s);
        }
        this.checkRenderExtensions(status, x, cc);
    }

    protected String displayIdentifier(ResourceWrapper ii) {
        Object s;
        Object object = s = Utilities.noString((String)ii.primitiveValue("value")) ? "?ngen-9?" : ii.primitiveValue("value");
        if ("urn:ietf:rfc:3986".equals(ii.primitiveValue("system")) && ((String)s).startsWith("urn:oid:")) {
            s = "OID:" + ((String)s).substring(8);
        } else if ("urn:ietf:rfc:3986".equals(ii.primitiveValue("system")) && ((String)s).startsWith("urn:uuid:")) {
            s = "UUID:" + ((String)s).substring(9);
        } else {
            NamingSystem ns = this.context.getContext().getNSUrlMap().get(ii.primitiveValue("system"));
            if (ns != null) {
                s = this.crPresent(ns) + "#" + (String)s;
            }
            if (ii.has("type")) {
                ResourceWrapper type = ii.child("type");
                if (type.has("text")) {
                    s = this.context.getTranslated(type.child("text")) + ":\u00a0" + (String)s;
                } else if (type.has("coding") && type.children("coding").get(0).has("display")) {
                    s = this.context.getTranslated(type.children("coding").get(0).child("display")) + ": " + (String)s;
                } else if (type.has("coding") && type.children("coding").get(0).has("code")) {
                    s = this.lookupCode(type.children("coding").get(0).primitiveValue("system"), type.children("coding").get(0).primitiveValue("version"), type.children("coding").get(0).primitiveValue("code"));
                }
            } else if (ii.has("system")) {
                s = ii.primitiveValue("system") + "#" + (String)s;
            }
        }
        if (ii.has("use") || ii.has("period")) {
            s = (String)s + "\u00a0(";
            if (ii.has("use")) {
                s = (String)s + "use:\u00a0" + ii.primitiveValue("use");
            }
            if (ii.has("use") || ii.has("period")) {
                s = (String)s + ",\u00a0";
            }
            if (ii.has("period")) {
                s = (String)s + "period:\u00a0" + this.displayPeriod(ii.child("period"));
            }
            s = (String)s + ")";
        }
        return s;
    }

    protected void renderIdentifier(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper ii) throws FHIRFormatError, DefinitionException, IOException {
        if (ii.has("type")) {
            ResourceWrapper type = ii.child("type");
            if (type.has("text")) {
                x.tx(this.context.getTranslated(type.child("text")));
            } else if (type.has("coding") && type.children("coding").get(0).has("display")) {
                x.tx(this.context.getTranslated(type.children("coding").get(0).child("display")));
            } else if (type.has("coding") && type.children("coding").get(0).has("code")) {
                x.tx(this.lookupCode(type.children("coding").get(0).primitiveValue("system"), type.children("coding").get(0).primitiveValue("version"), type.children("coding").get(0).primitiveValue("code")));
            }
            x.tx("/");
        } else if (ii.has("system")) {
            NamingSystem ns = this.context.getContext().getNSUrlMap().get(ii.primitiveValue("system"));
            if (ns != null) {
                if (ns.hasWebPath()) {
                    x.ah(this.context.prefixLocalHref(ns.getWebPath()), ns.getDescription()).tx(this.crPresent(ns));
                } else {
                    x.tx(this.crPresent(ns));
                }
            } else {
                switch (ii.primitiveValue("system")) {
                    case "urn:oid:2.51.1.3": {
                        x.ah("https://www.gs1.org/standards/id-keys/gln", this.context.formatPhrase("DATA_REND_GLN", new Object[0])).tx("GLN");
                        break;
                    }
                    default: {
                        x.code(ii.primitiveValue("system"));
                    }
                }
            }
            x.tx("/");
        }
        x.tx(Utilities.noString((String)ii.primitiveValue("value")) ? "?ngen-9?" : ii.primitiveValue("value"));
        if (ii.has("use") || ii.has("period")) {
            x.nbsp();
            x.tx("(");
            if (ii.has("use")) {
                x.tx(this.context.formatPhrase("DATA_REND_USE", new Object[0]));
                x.nbsp();
                x.tx(ii.primitiveValue("use"));
            }
            if (ii.has("use") || ii.has("period")) {
                x.tx(",");
                x.nbsp();
            }
            if (ii.has("period")) {
                x.tx(this.context.formatPhrase("DATA_REND_PERIOD", new Object[0]));
                x.nbsp();
                x.tx(this.displayPeriod(ii.child("period")));
            }
            x.tx(")");
        }
        this.checkRenderExtensions(status, x, ii);
    }

    public static String displayHumanName(ResourceWrapper name) {
        StringBuilder s = new StringBuilder();
        if (name.has("text")) {
            s.append(name.primitiveValue("text"));
        } else {
            for (ResourceWrapper p : name.children("given")) {
                s.append(p.primitiveValue());
                s.append(" ");
            }
            if (name.has("family")) {
                s.append(name.primitiveValue("family"));
                s.append(" ");
            }
        }
        if (name.has("use") && !"usual".equals(name.primitiveValue("use"))) {
            s.append("(" + name.primitiveValue("use") + ")");
        }
        return s.toString();
    }

    protected void renderHumanName(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper name) throws FHIRFormatError, DefinitionException, IOException {
        StringBuilder s = new StringBuilder();
        if (name.has("text")) {
            s.append(this.context.getTranslated(name.child("text")));
        } else {
            for (ResourceWrapper p : name.children("given")) {
                s.append(this.context.getTranslated(p));
                s.append(" ");
            }
            if (name.has("family")) {
                s.append(this.context.getTranslated(name.child("family")));
                s.append(" ");
            }
        }
        if (name.has("use") && !"usual".equals(name.primitiveValue("use"))) {
            s.append("(" + this.context.getTranslatedCode(name.primitiveValue("use"), "http://hl7.org/fhir/name-use") + ")");
        }
        x.addTextWithLineBreaks(s.toString());
        this.checkRenderExtensions(status, x, name);
    }

    private String displayAddress(ResourceWrapper address) {
        StringBuilder s = new StringBuilder();
        if (address.has("text")) {
            s.append(this.context.getTranslated(address.child("text")));
        } else {
            for (ResourceWrapper p : address.children("line")) {
                s.append(this.context.getTranslated(p));
                s.append(" ");
            }
            if (address.has("city")) {
                s.append(this.context.getTranslated(address.child("city")));
                s.append(" ");
            }
            if (address.has("state")) {
                s.append(this.context.getTranslated(address.child("state")));
                s.append(" ");
            }
            if (address.has("postalCode")) {
                s.append(this.context.getTranslated(address.child("postalCode")));
                s.append(" ");
            }
            if (address.has("country")) {
                s.append(this.context.getTranslated(address.child("country")));
                s.append(" ");
            }
        }
        if (address.has("use")) {
            s.append("(" + address.primitiveValue("use") + ")");
        }
        return s.toString();
    }

    protected void renderAddress(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper address) throws FHIRFormatError, DefinitionException, IOException {
        x.addTextWithLineBreaks(this.displayAddress(address));
        this.checkRenderExtensions(status, x, address);
    }

    public String displayContactPoint(ResourceWrapper contact) {
        StringBuilder s = new StringBuilder();
        s.append(DataRenderer.describeSystem(contact.primitiveValue("system")));
        if (Utilities.noString((String)contact.primitiveValue("value"))) {
            s.append("-unknown-");
        } else {
            s.append(contact.primitiveValue("value"));
        }
        if (contact.has("use")) {
            s.append("(" + this.getTranslatedCode(contact.child("use")) + ")");
        }
        return s.toString();
    }

    public String displayContactDetail(ResourceWrapper contact) {
        CommaSeparatedStringBuilder s = new CommaSeparatedStringBuilder();
        for (ResourceWrapper cp : contact.children("telecom")) {
            s.append(this.displayContactPoint(cp));
        }
        return contact.primitiveValue("name") + (String)(s.length() == 0 ? "" : " (" + s.toString() + ")");
    }

    protected String getLocalizedBigDecimalValue(BigDecimal input, Currency c) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(this.context.getLocale());
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(c.getDefaultFractionDigits());
        numberFormat.setMinimumFractionDigits(c.getDefaultFractionDigits());
        return numberFormat.format(input);
    }

    protected void renderMoney(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper money) {
        Currency c;
        if (x.getName().equals("blockquote")) {
            x = x.para();
        }
        Currency currency = c = money.has("currency") ? Currency.getInstance(money.primitiveValue("currency")) : null;
        if (c != null) {
            XhtmlNode s = x.span(null, c.getDisplayName());
            s.tx(c.getSymbol(this.context.getLocale()));
            s.tx(this.getLocalizedBigDecimalValue(new BigDecimal(money.primitiveValue("value")), c));
            x.tx(" (" + c.getCurrencyCode() + ")");
        } else {
            if (money.has("currency")) {
                x.tx(money.primitiveValue("currency"));
            }
            x.tx(money.primitiveValue("value"));
        }
    }

    protected void renderExpression(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper expr) {
        XhtmlNode p = x;
        if (p.getName().equals("blockquote")) {
            p = p.para();
        }
        if (expr.has("expression")) {
            if (expr.has("reference")) {
                p = x.ah(this.context.prefixLocalHref(expr.primitiveValue("reference")));
            }
            XhtmlNode c = p;
            if (expr.has("language")) {
                c = c.span(null, expr.primitiveValue("language"));
            }
            c.code().tx(expr.primitiveValue("expression"));
        } else if (expr.has("reference")) {
            p.ah(this.context.prefixLocalHref(expr.primitiveValue("reference"))).tx(this.context.formatPhrase("DATA_REND_SOURCE", new Object[0]));
        }
        if (expr.has("name") || expr.has("description")) {
            p.tx("(");
            if (expr.has("name")) {
                p.b().tx(expr.primitiveValue("name"));
            }
            if (expr.has("description")) {
                p.tx("\"");
                p.tx(this.context.getTranslated(expr.child("description")));
                p.tx("\"");
            }
            p.tx(")");
        }
    }

    protected void renderContactPoint(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper contact) {
        if (contact != null) {
            if (!contact.has("system")) {
                x.addText(this.displayContactPoint(contact));
            } else {
                String v = contact.primitiveValue("value");
                switch (contact.primitiveValue("system")) {
                    case "email": {
                        x.ah("mailto:" + v).tx(v);
                        break;
                    }
                    case "fax": {
                        x.addText(this.displayContactPoint(contact));
                        break;
                    }
                    case "other": {
                        x.addText(this.displayContactPoint(contact));
                        break;
                    }
                    case "pager": {
                        x.addText(this.displayContactPoint(contact));
                        break;
                    }
                    case "phone": {
                        if (contact.has("value") && v != null && v.startsWith("+")) {
                            x.ah("tel:" + v.replace(" ", "")).tx(v);
                            break;
                        }
                        x.addText(this.displayContactPoint(contact));
                        break;
                    }
                    case "sms": {
                        x.addText(this.displayContactPoint(contact));
                        break;
                    }
                    case "url": {
                        x.ah(this.context.prefixLocalHref(v)).tx(v);
                        break;
                    }
                }
            }
        }
    }

    protected void displayContactPoint(XhtmlNode p, ContactPoint c) {
        if (c != null) {
            if (c.getSystem() == ContactPoint.ContactPointSystem.PHONE) {
                p.tx(this.context.formatPhrase("DATA_REND_PHONE", new Object[]{c.getValue()}) + " ");
            } else if (c.getSystem() == ContactPoint.ContactPointSystem.FAX) {
                p.tx(this.context.formatPhrase("DATA_REND_FAX", new Object[]{c.getValue()}) + " ");
            } else if (c.getSystem() == ContactPoint.ContactPointSystem.EMAIL) {
                p.tx(c.getValue());
            } else if (c.getSystem() == ContactPoint.ContactPointSystem.URL) {
                if (c.getValue().length() > 30) {
                    p.addText(c.getValue().substring(0, 30) + "...");
                } else {
                    p.addText(c.getValue());
                }
            }
        }
    }

    protected void addTelecom(XhtmlNode p, ResourceWrapper c) {
        String sys = c.primitiveValue("system");
        String value = c.primitiveValue("value");
        if (sys.equals("phone")) {
            p.tx(this.context.formatPhrase("DATA_REND_PHONE", new Object[]{value}) + " ");
        } else if (sys.equals("fax")) {
            p.tx(this.context.formatPhrase("DATA_REND_FAX", new Object[]{value}) + " ");
        } else if (sys.equals("email")) {
            p.ah("mailto:" + value).addText(value);
        } else if (sys.equals("url")) {
            if (value.length() > 30) {
                p.ah(this.context.prefixLocalHref(value)).addText(value.substring(0, 30) + "...");
            } else {
                p.ah(this.context.prefixLocalHref(value)).addText(value);
            }
        }
    }

    private static String describeSystem(String system) {
        if (system == null) {
            return "";
        }
        switch (system) {
            case "phone": {
                return "ph: ";
            }
            case "fax": {
                return "fax: ";
            }
        }
        return "";
    }

    protected String displayQuantity(ResourceWrapper q) {
        if (q == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append(q.has("value") ? q.primitiveValue("value") : "?");
        if (q.has("unit")) {
            s.append(" ").append(q.primitiveValue("unit"));
        } else if (q.has("code")) {
            s.append(" ").append(q.primitiveValue("code"));
        }
        return s.toString();
    }

    protected void renderQuantity(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q) throws FHIRFormatError, DefinitionException, IOException {
        if (q.has("comparator")) {
            x.addText(q.primitiveValue("comparator"));
        }
        if (q.has("value")) {
            x.addText(this.context.getTranslated(q.child("value")));
        }
        if (q.has("unit")) {
            x.tx(" " + this.context.getTranslated(q.child("unit")));
        } else if (q.has("code") && q.has("system")) {
            if (q.has("system") && q.primitiveValue("system").equals("http://unitsofmeasure.org")) {
                x.tx(" " + q.primitiveValue("code"));
            } else {
                x.tx("(unit " + q.primitiveValue("code") + " from " + q.primitiveValue("system") + ")");
            }
        }
        if (this.context.isTechnicalMode() && q.has("code")) {
            x.span("background: LightGoldenRodYellow", null).tx(" " + this.context.formatPhrase("DATA_REND_DETAILS", new Object[]{this.displaySystem(q.primitiveValue("system"))}) + q.primitiveValue("code") + " = '" + this.lookupCode(q.primitiveValue("system"), null, q.primitiveValue("code")) + "')");
        }
        this.checkRenderExtensions(status, x, q);
    }

    protected void renderQuantity(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Piece> pieces, ResourceWrapper q, boolean showCodeDetails) {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.displayQuantity(q), null));
    }

    protected void renderQuantity(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Piece> pieces, Quantity q, boolean showCodeDetails) {
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        pieces.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, this.displayQuantity(this.wrapNC(q)), null));
    }

    public String displayRange(ResourceWrapper q) {
        String high;
        if (!q.has("low") && !q.has("high")) {
            return "?";
        }
        StringBuilder b = new StringBuilder();
        ResourceWrapper lowC = q.child("low");
        ResourceWrapper highC = q.child("high");
        boolean sameUnits = lowC != null && highC != null && (lowC.has("unit") && highC.has("unit") && lowC.child("unit").matches(highC.child("unit")) || lowC.has("code") && highC.has("code") && lowC.child("code").matches(highC.child("code")));
        String low = "?";
        if (q.has("low") && lowC.has("value")) {
            String string = low = sameUnits ? lowC.primitiveValue("value").toString() : this.displayQuantity(lowC);
        }
        if ((high = this.displayQuantity(highC)).isEmpty()) {
            high = "?";
        }
        b.append(low).append("\u00a0to\u00a0").append(high);
        return b.toString();
    }

    protected void renderRange(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper q) {
        if (q.has("low")) {
            x.addText(q.child("low").primitiveValue("value").toString());
        } else {
            x.tx("?");
        }
        x.tx("-");
        if (q.has("high")) {
            x.addText(q.child("high").primitiveValue("value").toString());
        } else {
            x.tx("?");
        }
        if (q.has("low") && q.child("low").has("unit")) {
            x.tx(" " + q.child("low").primitiveValue("unit"));
        }
    }

    public String displayPeriod(ResourceWrapper p) {
        Object s = !p.has("start") ? "(?)" : this.displayDateTime(p.child("start"));
        s = (String)s + " --> ";
        return (String)s + (!p.has("end") ? this.context.formatPhrase("DATA_REND_ONGOING", new Object[0]) : this.displayDateTime(p.child("end")));
    }

    public void renderPeriod(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper p) {
        x.addText(!p.has("start") ? "??" : this.displayDateTime(p.child("start")));
        x.tx(" --> ");
        x.addText(!p.has("end") ? this.context.formatPhrase("DATA_REND_ONGOING", new Object[0]) : this.displayDateTime(p.child("end")));
    }

    public void renderUsageContext(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper u) throws FHIRFormatError, DefinitionException, IOException {
        this.renderCoding(status, x, u.child("code"), false);
        x.tx(" = ");
        this.renderDataType(status, x, u.child("value"));
    }

    public void renderTriggerDefinition(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper td) throws FHIRFormatError, DefinitionException, IOException {
        if (x.isPara()) {
            x.b().tx(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
            x.tx(": ");
            x.tx(td.child("type").primitiveValue("display"));
            if (td.has("name")) {
                x.tx(", ");
                x.b().tx(this.context.formatPhrase("GENERAL_NAME", new Object[0]));
                x.tx(": ");
                x.tx(this.context.getTranslated(td.child("name")));
            }
            if (td.has("code")) {
                x.tx(", ");
                x.b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
                x.tx(": ");
                this.renderCodeableConcept(status, x, td.child("code"));
            }
            if (td.has("timing")) {
                x.tx(", ");
                x.b().tx(this.context.formatPhrase("DATA_REND_TIMING", new Object[0]));
                x.tx(": ");
                this.renderDataType(status, x, td.child("timing"));
            }
            if (td.has("condition")) {
                x.tx(", ");
                x.b().tx(this.context.formatPhrase("DATA_REND_COND", new Object[0]));
                x.tx(": ");
                this.renderExpression(status, x, td.child("condition"));
            }
        } else {
            XhtmlNode tbl = x.table("grid", false);
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
            tr.td().tx(td.child("type").primitiveValue("display"));
            if (td.has("name")) {
                tr = tbl.tr();
                tr.td().b().tx(this.context.formatPhrase("GENERAL_NAME", new Object[0]));
                tr.td().tx(this.context.getTranslated(td.child("name")));
            }
            if (td.has("code")) {
                tr = tbl.tr();
                tr.td().b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
                this.renderCodeableConcept(status, tr.td(), td.child("code"));
            }
            if (td.has("timing")) {
                tr = tbl.tr();
                tr.td().b().tx(this.context.formatPhrase("DATA_REND_TIMING", new Object[0]));
                this.renderDataType(status, tr.td(), td.child("timing"));
            }
            if (td.has("condition")) {
                tr = tbl.tr();
                tr.td().b().tx(this.context.formatPhrase("DATA_REND_COND", new Object[0]));
                this.renderExpression(status, tr.td(), td.child("condition"));
            }
        }
    }

    public void renderDataRequirement(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper dr) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode tbl = x.table("grid", false);
        XhtmlNode tr = tbl.tr();
        XhtmlNode td = tr.td().colspan("2");
        td.b().tx(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        td.tx(": ");
        StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(dr.primitiveValue("type"));
        if (sd != null && sd.hasWebPath()) {
            td.ah(this.context.prefixLocalHref(sd.getWebPath())).tx(dr.primitiveValue("type"));
        } else {
            td.tx(dr.primitiveValue("type"));
        }
        if (dr.has("profile")) {
            td.tx(" (");
            boolean first = true;
            for (ResourceWrapper p : dr.children("profile")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(" | ");
                }
                sd = this.context.getWorker().fetchResource(StructureDefinition.class, p.primitiveValue());
                if (sd != null && sd.hasWebPath()) {
                    td.ah(this.context.prefixLocalHref(sd.getWebPath())).tx(this.crPresent(sd));
                    continue;
                }
                td.tx(p.primitiveValue());
            }
            td.tx(")");
        }
        if (dr.has("subject")) {
            tr = tbl.tr();
            td = tr.td().colspan("2");
            td.b().tx(this.context.formatPhrase("GENERAL_SUBJ", new Object[0]));
            ResourceWrapper subj = dr.child("subject");
            if (subj.fhirType().equals("reference")) {
                this.renderReference(status, td, subj);
            } else {
                this.renderCodeableConcept(status, td, subj);
            }
        }
        if (dr.has("codeFilter") || dr.has("dateFilter")) {
            tr = tbl.tr().backgroundColor("#efefef");
            tr.td().tx(this.context.formatPhrase("GENERAL_FILTER", new Object[0]));
            tr.td().tx(this.context.formatPhrase("GENERAL_VALUE", new Object[0]));
        }
        for (ResourceWrapper cf : dr.children("codeFilter")) {
            tr = tbl.tr();
            if (cf.has("path")) {
                tr.td().tx(cf.primitiveValue("path"));
            } else {
                tr.td().tx(this.context.formatPhrase("DATA_REND_SEARCH", new Object[]{cf.primitiveValue("searchParam")}) + " ");
            }
            if (cf.has("valueSet")) {
                td = tr.td();
                td.tx(this.context.formatPhrase("DATA_REND_VALUESET", new Object[0]) + " ");
                this.renderDataType(status, td, cf.child("valueSet"));
                continue;
            }
            boolean first = true;
            td = tr.td();
            td.tx(this.context.formatPhrase("DATA_REND_THESE_CODES", new Object[0]) + " ");
            for (ResourceWrapper c : cf.children("code")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                this.renderDataType(status, td, c);
            }
        }
        for (ResourceWrapper cf : dr.children("dateFilter")) {
            tr = tbl.tr();
            if (cf.has("path")) {
                tr.td().tx(cf.primitiveValue("path"));
            } else {
                tr.td().tx(this.context.formatPhrase("DATA_REND_SEARCH", new Object[]{cf.primitiveValue("searchParam")}) + " ");
            }
            this.renderDataType(status, tr.td(), cf.child("value"));
        }
        if (dr.has("sort") || dr.has("limit")) {
            tr = tbl.tr();
            td = tr.td().colspan("2");
            if (dr.has("limit")) {
                td.b().tx(this.context.formatPhrase("DATA_REND_LIMIT", new Object[0]));
                td.tx(": ");
                td.tx(dr.primitiveValue("limit"));
                if (dr.has("sort")) {
                    td.tx(", ");
                }
            }
            if (dr.has("sort")) {
                td.b().tx(this.context.formatPhrase("DATA_REND_SORT", new Object[0]));
                td.tx(": ");
                boolean first = true;
                for (ResourceWrapper p : dr.children("sort")) {
                    if (first) {
                        first = false;
                    } else {
                        td.tx(" | ");
                    }
                    td.tx(p.primitiveValue("direction").equals("ascending") ? "+" : "-");
                    td.tx(p.primitiveValue("path"));
                }
            }
        }
    }

    private String displayTiming(ResourceWrapper s) throws FHIRException {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s.has("code")) {
            b.append(this.context.formatPhrase("GENERAL_CODE", new Object[]{this.displayCodeableConcept(s.child("code"))}) + " ");
        }
        if (s.has("event")) {
            CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
            for (ResourceWrapper p : s.children("event")) {
                if (p.hasPrimitiveValue()) {
                    c.append(this.displayDateTime(p));
                    continue;
                }
                if (this.renderExpression(c, p)) continue;
                c.append("??");
            }
            b.append(this.context.formatPhrase("DATA_REND_EVENTS", new Object[]{c.toString()}) + " ");
        }
        if (s.has("repeat")) {
            ResourceWrapper rep = s.child("repeat");
            if (rep.has("boundsPeriod") && rep.child("boundsPeriod").has("start")) {
                b.append(this.context.formatPhrase("DATA_REND_STARTING", new Object[]{this.displayDateTime(rep.child("boundsPeriod").child("start"))}) + " ");
            }
            if (rep.has("count")) {
                b.append(this.context.formatPhrase("DATA_REND_COUNT", new Object[]{rep.primitiveValue("count")}) + "  times");
            }
            if (rep.has("duration")) {
                b.append(this.context.formatPhrase("DATA_REND_DURATION", new Object[]{rep.primitiveValue("duration") + this.displayTimeUnits(rep.primitiveValue("periodUnit"), "1".equals(rep.primitiveValue("duration")))}) + " ");
            }
            Object st = "";
            if (rep.has("offset")) {
                st = rep.primitiveValue("offset") + "min ";
            }
            if (!Utilities.noString((String)st)) {
                b.append((String)st);
            }
            for (ResourceWrapper wh : rep.children("when")) {
                b.append(this.displayEventCode(wh.primitiveValue()));
            }
            st = "";
            if (!rep.has("frequency") || !rep.has("frequencyMax") && rep.primitiveValue("frequency").equals("1")) {
                st = this.context.formatPhrase("DATA_REND_ONCE", new Object[0]);
            } else {
                st = rep.primitiveValue("frequency");
                if (rep.has("frequencyMax")) {
                    st = (String)st + "-" + rep.primitiveValue("frequencyMax");
                }
            }
            if (rep.has("period")) {
                st = (String)st + " " + this.context.formatPhrase("DATA_REND_PER", new Object[0]) + " " + rep.primitiveValue("period");
                if (rep.has("periodMax")) {
                    st = (String)st + "-" + rep.primitiveValue("periodMax");
                }
                st = (String)st + " " + this.displayTimeUnits(rep.primitiveValue("periodUnit"), "1".equals(rep.primitiveValue("period")));
            }
            if (!Utilities.noString((String)st)) {
                b.append((String)st);
            }
            if (rep.has("boundsPeriod") && rep.child("boundsPeriod").has("end")) {
                b.append(this.context.formatPhrase("DATA_REND_UNTIL", new Object[]{this.displayDateTime(rep.child("boundsPeriod").child("end"))}) + " ");
            }
        }
        return b.toString();
    }

    private boolean renderExpression(CommaSeparatedStringBuilder c, ResourceWrapper p) {
        ResourceWrapper exp = p.extensionValue("http://hl7.org/fhir/StructureDefinition/cqf-expression");
        if (exp == null || !exp.has("value")) {
            return false;
        }
        c.append(exp.child("value").primitiveValue("expression"));
        return true;
    }

    private String displayEventCode(String when) {
        if (when == null) {
            return "??";
        }
        switch (when.toLowerCase()) {
            case "c": {
                return this.context.formatPhrase("DATA_REND_MEALS", new Object[0]);
            }
            case "cd": {
                return this.context.formatPhrase("DATA_REND_ATLUNCH", new Object[0]);
            }
            case "cm": {
                return this.context.formatPhrase("DATA_REND_ATBKFST", new Object[0]);
            }
            case "cv": {
                return this.context.formatPhrase("DATA_REND_ATDINR", new Object[0]);
            }
            case "ac": {
                return this.context.formatPhrase("DATA_REND_BFMEALS", new Object[0]);
            }
            case "acd": {
                return this.context.formatPhrase("DATA_REND_BFLUNCH", new Object[0]);
            }
            case "acm": {
                return this.context.formatPhrase("DATA_REND_BFBKFST", new Object[0]);
            }
            case "acv": {
                return this.context.formatPhrase("DATA_REND_BFDINR", new Object[0]);
            }
            case "hs": {
                return this.context.formatPhrase("DATA_REND_BFSLEEP", new Object[0]);
            }
            case "pc": {
                return this.context.formatPhrase("DATA_REND_AFTRMEALS", new Object[0]);
            }
            case "pcd": {
                return this.context.formatPhrase("DATA_REND_AFTRLUNCH", new Object[0]);
            }
            case "pcm": {
                return this.context.formatPhrase("DATA_REND_AFTRBKFST", new Object[0]);
            }
            case "pcv": {
                return this.context.formatPhrase("DATA_REND_AFTRDINR", new Object[0]);
            }
            case "wake": {
                return this.context.formatPhrase("DATA_REND_AFTRWKNG", new Object[0]);
            }
            case "morn": {
                return this.context.formatPhrase("DATA_REND_MORNING", new Object[0]);
            }
            case "morn.early": {
                return this.context.formatPhrase("DATA_REND_MORNING_EARLY", new Object[0]);
            }
            case "morn.late": {
                return this.context.formatPhrase("DATA_REND_MORNING_LATE", new Object[0]);
            }
            case "noon": {
                return this.context.formatPhrase("DATA_REND_NOON", new Object[0]);
            }
            case "aft": {
                return this.context.formatPhrase("DATA_REND_AFTERNOON", new Object[0]);
            }
            case "aft.early": {
                return this.context.formatPhrase("DATA_REND_AFTERNOON_EARLY", new Object[0]);
            }
            case "aft.late": {
                return this.context.formatPhrase("DATA_REND_AFTERNOON_LATE", new Object[0]);
            }
            case "eve": {
                return this.context.formatPhrase("DATA_REND_EVENING", new Object[0]);
            }
            case "eve.early": {
                return this.context.formatPhrase("DATA_REND_EVENING_EARLY", new Object[0]);
            }
            case "eve.late": {
                return this.context.formatPhrase("DATA_REND_EVENING_LATE", new Object[0]);
            }
            case "night": {
                return this.context.formatPhrase("DATA_REND_NIGHT", new Object[0]);
            }
            case "phs": {
                return this.context.formatPhrase("DATA_REND_AFTER_SLEEP", new Object[0]);
            }
            case "imd": {
                return this.context.formatPhrase("DATA_REND_IMMEDIATE", new Object[0]);
            }
        }
        return "?" + when + "?";
    }

    private String displayTimeUnits(String units, boolean singular) {
        if (units == null) {
            return "??";
        }
        switch (units) {
            case "a": {
                return singular ? "year" : "years";
            }
            case "d": {
                return singular ? "day" : "days";
            }
            case "h": {
                return singular ? "hour" : "hours";
            }
            case "min": {
                return singular ? "minute" : "minutes";
            }
            case "mo": {
                return singular ? "month" : "months";
            }
            case "s": {
                return singular ? "second" : "seconds";
            }
            case "wk": {
                return singular ? "week" : "weeks";
            }
        }
        return "?" + units + "?";
    }

    protected void renderTiming(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper s) throws FHIRException {
        x.addText(this.displayTiming(s));
    }

    private String displaySampledData(ResourceWrapper s) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s.has("origin")) {
            b.append(this.context.formatPhrase("DATA_REND_ORIGIN", new Object[]{this.displayQuantity(s.child("origin"))}) + " ");
        }
        if (s.has("interval")) {
            b.append(this.context.formatPhrase("DATA_REND_INT", new Object[]{s.primitiveValue("interval")}) + " ");
            if (s.has("intervalUnit")) {
                b.append(s.primitiveValue("intervalUnit"));
            }
        }
        if (s.has("factor")) {
            b.append(this.context.formatPhrase("DATA_REND_FACT", new Object[]{s.primitiveValue("factor")}) + " ");
        }
        if (s.has("lowerLimit")) {
            b.append(this.context.formatPhrase("DATA_REND_LOWER", new Object[]{s.primitiveValue("lowerLimit")}) + " ");
        }
        if (s.has("upperLimit")) {
            b.append(this.context.formatPhrase("DATA_REND_UP", new Object[]{s.primitiveValue("upperLimit")}) + " ");
        }
        if (s.has("dimensions")) {
            b.append(this.context.formatPhrase("DATA_REND_DIM", new Object[]{s.primitiveValue("dimensions")}) + " ");
        }
        if (s.has("data")) {
            b.append(this.context.formatPhrase("DATA_REND_DATA", new Object[]{s.primitiveValue("data")}) + " ");
        }
        return b.toString();
    }

    protected void renderSampledData(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper sampledData) {
        x.addText(this.displaySampledData(sampledData));
    }

    public RenderingContext getContext() {
        return this.context;
    }

    public XhtmlNode makeExceptionXhtml(Exception e, String function) {
        XhtmlNode xn = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode p = xn.para();
        p.b().tx(this.context.formatPhrase("DATA_REND_EXCEPTION", new Object[0]) + function + ": " + e.getMessage());
        p.addComment(this.getStackTrace(e));
        return xn;
    }

    private String getStackTrace(Exception e) {
        StringBuilder b = new StringBuilder();
        b.append("\r\n");
        for (StackTraceElement t : e.getStackTrace()) {
            b.append(t.getClassName() + "." + t.getMethodName() + " (" + t.getFileName() + ":" + t.getLineNumber());
            b.append("\r\n");
        }
        return b.toString();
    }

    protected String systemFromCanonical(String system) {
        if (system == null) {
            return null;
        }
        if (system.contains("|")) {
            return system.substring(0, system.indexOf("|"));
        }
        return null;
    }

    protected String versionFromCanonical(String system) {
        if (system == null) {
            return null;
        }
        if (system.contains("|")) {
            return system.substring(system.indexOf("|") + 1);
        }
        return system;
    }

    protected boolean isInKnownUrlSpace(String url) {
        return Utilities.startsWithInList((String)url, (String[])new String[]{"http://hl7.org/fhir", "http://fhir.org/guides", "http://ihe.net/fhir", "http://terminology.hl7.org", "https://hl7.org/fhir", "https://fhir.org/guides", "https://ihe.net/fhir", "https://terminology.hl7.org", "http://www.hl7.org/fhir", "http://www.fhir.org/guides", "http://www.ihe.net/fhir", "https://www.hl7.org/fhir", "https://www.fhir.org/guides", "https://www.ihe.net/fhir"});
    }
}

