/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class ExampleScenarioRenderer
extends TerminologyRenderer {
    private Set<String> stepPrefixes = new HashSet<String>();

    public ExampleScenarioRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (r.isDirect()) {
            this.renderResourceTechDetails(r, x);
            this.genSummaryTable(status, x, (ExampleScenario)r.getBase());
            this.render(status, x, (ExampleScenario)r.getBase(), r);
        } else {
            x.para().tx("ExampleScenarioRenderer only renders native resources directly");
        }
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, ExampleScenario scen, ResourceWrapper res) throws FHIRException {
        HashMap<Element, String> prefixes = new HashMap<Element, String>();
        this.assignProcessPrefixes(prefixes, scen.getProcess(), 1);
        try {
            if (this.context.getScenarioMode() == null) {
                this.renderActors(status, res, x, scen);
            } else {
                switch (this.context.getScenarioMode()) {
                    case ACTORS: {
                        this.renderActors(status, res, x, scen);
                        break;
                    }
                    case INSTANCES: {
                        this.renderInstances(status, res, x, scen);
                        break;
                    }
                    case PROCESSES: {
                        this.renderProcesses(prefixes, status, x, scen);
                        break;
                    }
                    default: {
                        throw new FHIRException(this.context.formatPhrase("EX_SCEN_UN", new Object[]{this.context.getScenarioMode()}) + " ");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FHIRException(this.context.formatPhrase("EX_SCEN_ERR_REN", new Object[]{scen.getUrl(), e}) + " ");
        }
    }

    public String renderDiagram(Renderer.RenderingStatus status, ResourceWrapper res, ExampleScenario scen) throws IOException {
        HashMap<Element, String> prefixes = new HashMap<Element, String>();
        this.assignProcessPrefixes(prefixes, scen.getProcess(), 1);
        try {
            String plantUml = this.toPlantUml(prefixes, status, res, scen);
            SourceStringReader reader = new SourceStringReader(plantUml);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
            os.close();
            String svg = new String(os.toByteArray(), Charset.forName("UTF-8"));
            return svg;
        }
        catch (Exception e) {
            return "<p style=\"color: maroon\"><b>" + Utilities.escapeXml((String)e.getMessage()) + "</b></p>";
        }
    }

    protected String toPlantUml(Map<Element, String> prefixes, Renderer.RenderingStatus status, ResourceWrapper res, ExampleScenario scen) throws IOException {
        Object plantUml = "@startuml\r\n";
        plantUml = (String)plantUml + "Title " + (scen.hasTitle() ? scen.getTitle() : scen.getName()) + "\r\n\r\n";
        HashMap<String, String> actorKeys = new HashMap<String, String>();
        for (ExampleScenario.ExampleScenarioActorComponent actor : scen.getActor()) {
            String actorType = actor.getType().equals((Object)Enumerations.ExampleScenarioActorType.PERSON) ? "actor" : "participant";
            actorKeys.put(actor.getKey(), this.escapeKey(actor.getKey()));
            plantUml = (String)plantUml + actorType + " \"" + this.creolLink(actor.getTitle(), "#a_" + actor.getKey(), actor.getDescription()) + "\" as " + (String)actorKeys.get(actor.getKey()) + "\r\n";
        }
        plantUml = (String)plantUml + "\r\n";
        for (ExampleScenario.ExampleScenarioProcessComponent process : scen.getProcess()) {
            plantUml = (String)plantUml + this.toPlantUml(prefixes, status, res, process, scen, actorKeys);
        }
        plantUml = (String)plantUml + "@enduml";
        return plantUml;
    }

    private String escapeKey(String origKey) {
        char[] chars = origKey.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '@' || c == '.') continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    protected String toPlantUml(Map<Element, String> prefixes, Renderer.RenderingStatus status, ResourceWrapper res, ExampleScenario.ExampleScenarioProcessComponent process, ExampleScenario scen, Map<String, String> actorKeys) throws IOException {
        String plantUml = "group " + process.getTitle() + " " + this.creolLink("details", prefixes.get(process), process.getDescription()) + "\r\n";
        HashMap<String, Boolean> actorsActive = new HashMap<String, Boolean>();
        for (ExampleScenario.ExampleScenarioActorComponent actor : scen.getActor()) {
            actorsActive.put(actor.getKey(), Boolean.FALSE);
        }
        for (ExampleScenario.ExampleScenarioProcessStepComponent step : process.getStep()) {
            plantUml = plantUml + this.toPlantUml(prefixes, status, res, step, scen, actorsActive, actorKeys);
            if (!step.getPause()) continue;
            plantUml = plantUml + this.context.formatPhrase("EX_SCEN_TIME", new Object[0]) + "\n";
        }
        plantUml = plantUml + "end\r\n\r\n";
        return plantUml;
    }

    protected String toPlantUml(Map<Element, String> prefixes, Renderer.RenderingStatus status, ResourceWrapper res, ExampleScenario.ExampleScenarioProcessStepComponent step, ExampleScenario scen, Map<String, Boolean> actorsActive, Map<String, String> actorKeys) throws IOException {
        Object plantUml = "";
        if (step.hasWorkflow()) {
            XhtmlDocument n = new XhtmlDocument();
            this.renderCanonical(status, res, (XhtmlNode)n, Resource.class, step.getWorkflowElement());
            XhtmlNode ref = n.getChildNodes().get(0);
            plantUml = (String)plantUml + this.noteOver(scen.getActor(), this.context.formatPhrase("EXAMPLE_SCEN_STEP_SCEN", new Object[]{this.creolLink(ref.getContent(), ref.getAttribute("href"))}));
        } else {
            plantUml = step.hasProcess() ? (String)plantUml + this.toPlantUml(prefixes, status, res, step.getProcess(), scen, actorKeys) : (String)plantUml + this.toPlantUml(prefixes, step.getOperation(), scen, actorsActive, actorKeys);
        }
        return plantUml;
    }

    protected String toPlantUml(Map<Element, String> prefixes, ExampleScenario.ExampleScenarioProcessStepOperationComponent op, ExampleScenario scen, Map<String, Boolean> actorsActive, Map<String, String> actorKeys) {
        StringBuilder plantUml = new StringBuilder();
        plantUml.append(this.handleActivation(op.getInitiator(), op.getInitiatorActive(), actorsActive, actorKeys));
        plantUml.append(this.handleActivation(op.getReceiver(), op.getReceiverActive(), actorsActive, actorKeys));
        plantUml.append(actorKeys.get(op.getInitiator()) + " -> " + actorKeys.get(op.getReceiver()) + ": ");
        plantUml.append(this.creolLink(op.getTitle(), prefixes.get(op), op.getDescription()));
        if (op.hasRequest()) {
            plantUml.append(" (" + this.creolLink("payload", this.linkForInstance(op.getRequest())) + ")\r\n");
        }
        if (op.hasResponse()) {
            plantUml.append("activate " + actorKeys.get(op.getReceiver()) + "\r\n");
            plantUml.append(actorKeys.get(op.getReceiver()) + " --> " + actorKeys.get(op.getInitiator()) + ": ");
            plantUml.append(this.creolLink("response", prefixes.get(op), op.getDescription()));
            plantUml.append(" (" + this.creolLink("payload", this.linkForInstance(op.getResponse())) + ")\r\n");
            plantUml.append("deactivate " + actorKeys.get(op.getReceiver()) + "\r\n");
        }
        plantUml.append(this.handleDeactivation(op.getInitiator(), op.getInitiatorActive(), actorsActive, actorKeys));
        plantUml.append(this.handleDeactivation(op.getReceiver(), op.getReceiverActive(), actorsActive, actorKeys));
        return plantUml.toString();
    }

    private String handleActivation(String actorId, boolean active, Map<String, Boolean> actorsActive, Map<String, String> actorKeys) {
        Object plantUml = "";
        Boolean actorWasActive = actorsActive.get(actorId);
        if (active && !actorWasActive.booleanValue()) {
            plantUml = (String)plantUml + "activate " + actorKeys.get(actorId) + "\r\n";
        }
        return plantUml;
    }

    private String handleDeactivation(String actorId, boolean active, Map<String, Boolean> actorsActive, Map<String, String> actorKeys) {
        Object plantUml = "";
        Boolean actorWasActive = actorsActive.get(actorId);
        if (actorWasActive != null) {
            if (!active && actorWasActive.booleanValue()) {
                plantUml = (String)plantUml + "deactivate " + actorKeys.get(actorId) + "\r\n";
            }
            if (active != actorWasActive) {
                actorsActive.remove(actorId);
                actorsActive.put(actorId, active);
            }
        }
        return plantUml;
    }

    private String linkForInstance(ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent ref) {
        String plantUml = "#i_" + ref.getInstanceReference();
        if (ref.hasVersionReference()) {
            plantUml = plantUml + "v_" + ref.getVersionReference();
        }
        return plantUml;
    }

    private String noteOver(List<ExampleScenario.ExampleScenarioActorComponent> actors, String text) {
        Object plantUml = "Note over ";
        ArrayList<String> actorKeys = new ArrayList<String>();
        for (ExampleScenario.ExampleScenarioActorComponent actor : actors) {
            actorKeys.add(actor.getKey());
        }
        plantUml = (String)plantUml + String.join((CharSequence)", ", actorKeys);
        plantUml = (String)plantUml + " " + text;
        return plantUml;
    }

    private String creolLink(String text, String url) {
        return this.creolLink(text, url, null);
    }

    private String creolLink(String text, String url, String flyover) {
        String s = "[[" + url;
        if (flyover != null) {
            s = s + "{" + flyover + "}";
        }
        s = s + " " + text + "]]";
        return s;
    }

    public boolean renderActors(Renderer.RenderingStatus status, ResourceWrapper res, XhtmlNode x, ExampleScenario scen) throws IOException {
        XhtmlNode tbl = x.table("table-striped table-bordered", false);
        XhtmlNode thead = tbl.tr();
        thead.th().addText(this.context.formatPhrase("GENERAL_NAME", new Object[0]));
        thead.th().addText(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        thead.th().addText(this.context.formatPhrase("GENERAL_DESC", new Object[0]));
        for (ExampleScenario.ExampleScenarioActorComponent actor : scen.getActor()) {
            XhtmlNode tr = tbl.tr();
            XhtmlNode nameCell = tr.td();
            nameCell.an(this.context.prefixAnchor("a_" + actor.getKey()));
            nameCell.tx(actor.getTitle());
            tr.td().tx(actor.getType().getDisplay());
            this.addMarkdown(tr.td().style("overflow-wrap:break-word"), actor.getDescription());
        }
        return true;
    }

    public boolean renderInstances(Renderer.RenderingStatus status, ResourceWrapper res, XhtmlNode x, ExampleScenario scen) throws IOException {
        XhtmlNode tbl = x.table("table-striped table-bordered", false);
        XhtmlNode thead = tbl.tr();
        thead.th().addText(this.context.formatPhrase("GENERAL_NAME", new Object[0]));
        thead.th().addText(this.context.formatPhrase("GENERAL_TYPE", new Object[0]));
        thead.th().addText(this.context.formatPhrase("GENERAL_CONTENT", new Object[0]));
        thead.th().addText(this.context.formatPhrase("GENERAL_DESC", new Object[0]));
        HashMap<CallSite, String> instanceNames = new HashMap<CallSite, String>();
        for (ExampleScenario.ExampleScenarioInstanceComponent instance : scen.getInstance()) {
            instanceNames.put((CallSite)((Object)("i_" + instance.getKey())), instance.getTitle());
            if (!instance.hasVersion()) continue;
            for (ExampleScenario.ExampleScenarioInstanceVersionComponent version : instance.getVersion()) {
                instanceNames.put((CallSite)((Object)("i_" + instance.getKey() + "v_" + version.getKey())), version.getTitle());
            }
        }
        for (ExampleScenario.ExampleScenarioInstanceComponent instance : scen.getInstance()) {
            XhtmlNode row = tbl.tr();
            XhtmlNode nameCell = row.td();
            nameCell.an(this.context.prefixAnchor("i_" + instance.getKey()));
            nameCell.tx(instance.getTitle());
            XhtmlNode typeCell = row.td();
            if (instance.hasVersion()) {
                typeCell.attribute("rowSpan", Integer.toString(instance.getVersion().size() + 1));
            }
            if (!instance.hasStructureVersion() || instance.getStructureType().getSystem().equals("")) {
                if (instance.hasStructureVersion()) {
                    typeCell.tx(this.context.formatPhrase("EX_SCEN_FVER", new Object[]{instance.getStructureVersion()}) + "  ");
                }
                if (instance.hasStructureProfileCanonicalType()) {
                    this.renderCanonical(status, res, typeCell, StructureDefinition.class, instance.getStructureProfileCanonicalType());
                } else if (instance.hasStructureProfileUriType()) {
                    this.renderBase(status, typeCell, instance.getStructureProfileUriType());
                } else {
                    CanonicalType ct = new CanonicalType("http://hl7.org/fhir/StructureDefinition/" + instance.getStructureType().getCode());
                    this.renderCanonical(status, res, typeCell, StructureDefinition.class, ct);
                }
            } else {
                this.renderDataType(status, typeCell, this.wrapWC(res, instance.getStructureVersionElement()));
                typeCell.tx(" " + this.context.formatPhrase("GENERAL_VER_LOW", new Object[]{instance.getStructureVersion()}) + " ");
                if (instance.hasStructureProfile()) {
                    typeCell.tx(" ");
                    if (instance.hasStructureProfileCanonicalType()) {
                        this.renderCanonical(status, res, typeCell, StructureDefinition.class, instance.getStructureProfileCanonicalType());
                    }
                }
            }
            if (instance.hasContent() && instance.getContent().hasReference()) {
                RenderingContext.ResourceRendererMode mode = this.context.getMode();
                this.context.setMode(RenderingContext.ResourceRendererMode.END_USER);
                this.renderReference(status, row.td(), this.wrapWC(res, instance.getContent().copy().setDisplay("here")));
                this.context.setMode(mode);
            } else {
                row.td();
            }
            XhtmlNode descCell = row.td();
            this.addMarkdown(descCell, instance.getDescription());
            if (instance.hasContainedInstance()) {
                descCell.b().tx(this.context.formatPhrase("EX_SCEN_CONTA", new Object[0]) + " ");
                boolean first = true;
                for (ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent contained : instance.getContainedInstance()) {
                    String description;
                    if (first) {
                        first = false;
                    } else {
                        descCell.tx(", ");
                    }
                    String key = "i_" + contained.getInstanceReference();
                    if (contained.hasVersionReference()) {
                        key = key + "v_" + contained.getVersionReference();
                    }
                    if ((description = (String)instanceNames.get(key)) == null) {
                        throw new FHIRException("Unable to find contained instance " + key + " under " + instance.getKey());
                    }
                    descCell.ah(this.context.prefixLocalHref("#" + key)).tx(description);
                }
            }
            for (ExampleScenario.ExampleScenarioInstanceVersionComponent version : instance.getVersion()) {
                row = tbl.tr();
                nameCell = row.td().style("padding-left: 10px;");
                nameCell.an("i_" + instance.getKey() + "v_" + version.getKey());
                XhtmlNode nameItem = nameCell.ul().li();
                nameItem.tx(version.getTitle());
                if (version.hasContent() && version.getContent().hasReference()) {
                    RenderingContext.ResourceRendererMode mode = this.context.getMode();
                    this.context.setMode(RenderingContext.ResourceRendererMode.END_USER);
                    this.renderReference(status, row.td(), this.wrapWC(res, version.getContent().copy().setDisplay("here")));
                    this.context.setMode(mode);
                } else {
                    row.td();
                }
                descCell = row.td();
                this.addMarkdown(descCell, instance.getDescription());
            }
        }
        return true;
    }

    public boolean renderProcesses(Map<Element, String> prefixes, Renderer.RenderingStatus status, XhtmlNode x, ExampleScenario scen) throws IOException {
        HashMap<String, ExampleScenario.ExampleScenarioActorComponent> actors = new HashMap<String, ExampleScenario.ExampleScenarioActorComponent>();
        for (ExampleScenario.ExampleScenarioActorComponent actor : scen.getActor()) {
            actors.put(actor.getKey(), actor);
        }
        HashMap<String, ExampleScenario.ExampleScenarioInstanceComponent> instances = new HashMap<String, ExampleScenario.ExampleScenarioInstanceComponent>();
        for (ExampleScenario.ExampleScenarioInstanceComponent instance : scen.getInstance()) {
            instances.put(instance.getKey(), instance);
        }
        for (ExampleScenario.ExampleScenarioProcessComponent process : scen.getProcess()) {
            this.renderProcess(prefixes, status, x, process, actors, instances);
        }
        return true;
    }

    private int assignProcessPrefixes(Map<Element, String> prefixes, List<ExampleScenario.ExampleScenarioProcessComponent> processes, int i) {
        for (ExampleScenario.ExampleScenarioProcessComponent process : processes) {
            prefixes.put(process, "node" + i);
            ++i;
        }
        for (ExampleScenario.ExampleScenarioProcessComponent process : processes) {
            i = this.assignStepPrefixes(prefixes, process.getStep(), i);
        }
        return i;
    }

    private int assignStepPrefixes(Map<Element, String> prefixes, List<ExampleScenario.ExampleScenarioProcessStepComponent> steps, int i) {
        for (ExampleScenario.ExampleScenarioProcessStepComponent step : steps) {
            prefixes.put(step, "node" + i);
            ++i;
        }
        for (ExampleScenario.ExampleScenarioProcessStepComponent step : steps) {
            if (step.hasProcess()) {
                prefixes.put(step.getProcess(), "node" + i);
                ++i;
                i = this.assignStepPrefixes(prefixes, step.getProcess().getStep(), i);
            }
            i = this.assignAlternativePrefixes(prefixes, step.getAlternative(), i);
            if (!step.hasOperation()) continue;
            prefixes.put(step.getOperation(), "node" + i);
            ++i;
        }
        return i;
    }

    private int assignAlternativePrefixes(Map<Element, String> prefixes, List<ExampleScenario.ExampleScenarioProcessStepAlternativeComponent> list, int i) {
        for (ExampleScenario.ExampleScenarioProcessStepAlternativeComponent alt : list) {
            prefixes.put(alt, "node" + i);
            ++i;
        }
        for (ExampleScenario.ExampleScenarioProcessStepAlternativeComponent alt : list) {
            i = this.assignStepPrefixes(prefixes, alt.getStep(), i);
        }
        return i;
    }

    public void renderProcess(Map<Element, String> prefixes, Renderer.RenderingStatus status, XhtmlNode x, ExampleScenario.ExampleScenarioProcessComponent process, Map<String, ExampleScenario.ExampleScenarioActorComponent> actors, Map<String, ExampleScenario.ExampleScenarioInstanceComponent> instances) throws IOException {
        XhtmlNode div = x.div();
        div.an(this.context.prefixAnchor(prefixes.get(process)));
        div.b().tx(this.context.formatPhrase("EX_SCEN_PROC", new Object[]{process.getTitle()}) + " ");
        if (process.hasDescription()) {
            this.addMarkdown(div, process.getDescription());
        }
        if (process.hasPreConditions()) {
            div.para().b().i().tx(this.context.formatPhrase("EX_SCEN_PRECON", new Object[0]));
            this.addMarkdown(div, process.getPreConditions());
        }
        if (process.hasPostConditions()) {
            div.para().b().i().tx(this.context.formatPhrase("EX_SCEN_POSTCON", new Object[0]));
            this.addMarkdown(div, process.getPostConditions());
        }
        XhtmlNode tbl = div.table("table-striped table-bordered", false).style("width:100%");
        XhtmlNode thead = tbl.tr();
        thead.th().addText(this.context.formatPhrase("EX_SCEN_STEP", new Object[0]));
        thead.th().addText(this.context.formatPhrase("GENERAL_NAME", new Object[0]));
        thead.th().addText(this.context.formatPhrase("GENERAL_DESC", new Object[0]));
        thead.th().addText(this.context.formatPhrase("EX_SCEN_IN", new Object[0]));
        thead.th().addText(this.context.formatPhrase("EX_SCEN_REC", new Object[0]));
        thead.th().addText(this.context.formatPhrase("GENERAL_REQUEST", new Object[0]));
        thead.th().addText(this.context.formatPhrase("EX_SCEN_RES", new Object[0]));
        int stepCount = 1;
        for (ExampleScenario.ExampleScenarioProcessStepComponent step : process.getStep()) {
            this.renderStep(prefixes, status, tbl, step, actors, instances);
            ++stepCount;
        }
        stepCount = 1;
        for (ExampleScenario.ExampleScenarioProcessStepComponent step : process.getStep()) {
            this.stepSubProcesses(prefixes, status, tbl, step, actors, instances);
            ++stepCount;
        }
    }

    private void stepSubProcesses(Map<Element, String> prefixes, Renderer.RenderingStatus status, XhtmlNode x, ExampleScenario.ExampleScenarioProcessStepComponent step, Map<String, ExampleScenario.ExampleScenarioActorComponent> actors, Map<String, ExampleScenario.ExampleScenarioInstanceComponent> instances) throws IOException {
        if (step.hasProcess()) {
            this.renderProcess(prefixes, status, x, step.getProcess(), actors, instances);
        }
        if (step.hasAlternative()) {
            int altNum = 1;
            for (ExampleScenario.ExampleScenarioProcessStepAlternativeComponent alt : step.getAlternative()) {
                int stepCount = 1;
                for (ExampleScenario.ExampleScenarioProcessStepComponent altStep : alt.getStep()) {
                    this.stepSubProcesses(prefixes, status, x, altStep, actors, instances);
                    ++stepCount;
                }
                ++altNum;
            }
        }
    }

    private boolean renderStep(Map<Element, String> prefixes, Renderer.RenderingStatus status, XhtmlNode tbl, ExampleScenario.ExampleScenarioProcessStepComponent step, Map<String, ExampleScenario.ExampleScenarioActorComponent> actors, Map<String, ExampleScenario.ExampleScenarioInstanceComponent> instances) throws IOException {
        XhtmlNode row = tbl.tr();
        if (step.getPause()) {
            XhtmlNode td = row.td().colspan(7);
            td.style("opacity: 0.7");
            td.an(this.context.prefixAnchor(prefixes.get(step)));
            td.tx("Pause");
        } else {
            XhtmlNode prefixCell = row.td();
            prefixCell.an(this.context.prefixAnchor(prefixes.get(step)));
            prefixCell.tx(step.getNumber());
            if (step.hasProcess()) {
                n = row.td().colspan(6);
                n.tx(this.context.formatPhrase("EX_SCEN_SEE", new Object[0]));
                n.ah(this.context.prefixLocalHref("#" + this.context.prefixAnchor(prefixes.get(step)))).tx(step.getProcess().getTitle());
                n.tx(" " + this.context.formatPhrase("EX_SCEN_BEL", new Object[0]));
            } else if (step.hasWorkflow()) {
                n = row.td().colspan(6);
                n.an(this.context.prefixAnchor(prefixes.get(step)));
                n.tx(this.context.formatPhrase("EX_SCEN_OTH", new Object[0]));
                String link = new ContextUtilities(this.context.getWorker()).getLinkForUrl(this.context.getLink(RenderingContext.KnownLinkType.SPEC, true), step.getWorkflow());
                String title = "Unknown title";
                if (step.getWorkflowElement().hasExtension("http://hl7.org/fhir/StructureDefinition/display")) {
                    title = step.getWorkflowElement().getExtensionString("http://hl7.org/fhir/StructureDefinition/display");
                } else {
                    Resolver.ResourceWithReference rres = this.context.getResolver().resolve(this.context, step.getWorkflow(), null);
                    if (rres != null && rres.getResource() != null && rres.getResource().has("title")) {
                        title = rres.getResource().primitiveValue("title");
                    }
                }
                if (link != null) {
                    n.ah(this.context.prefixLocalHref(link)).tx(title);
                } else {
                    n.addText(title);
                }
            } else {
                ExampleScenario.ExampleScenarioProcessStepOperationComponent op = step.getOperation();
                XhtmlNode name = row.td();
                name.tx(op.getTitle());
                if (op.hasType()) {
                    name.tx(" - ");
                    this.renderCoding(status, name, this.wrapNC(op.getType()));
                }
                XhtmlNode descCell = row.td();
                this.addMarkdown(descCell, op.getDescription());
                this.addActor(row, op.getInitiator(), actors);
                this.addActor(row, op.getReceiver(), actors);
                this.addInstance(row, op.getRequest(), instances);
                this.addInstance(row, op.getResponse(), instances);
            }
            int altNum = 1;
            for (ExampleScenario.ExampleScenarioProcessStepAlternativeComponent alt : step.getAlternative()) {
                XhtmlNode altHeading = tbl.tr().colspan(7).td();
                altHeading.para().i().tx(this.context.formatPhrase("EX_SCEN_ALT", new Object[]{alt.getTitle()}) + " ");
                if (alt.hasDescription()) {
                    this.addMarkdown(altHeading, alt.getDescription());
                }
                int stepCount = 1;
                for (ExampleScenario.ExampleScenarioProcessStepComponent subStep : alt.getStep()) {
                    this.renderStep(prefixes, status, tbl, subStep, actors, instances);
                    ++stepCount;
                }
                ++altNum;
            }
        }
        return true;
    }

    private void addActor(XhtmlNode row, String actorId, Map<String, ExampleScenario.ExampleScenarioActorComponent> actors) throws FHIRException {
        XhtmlNode actorCell = row.td();
        if (actorId == null) {
            return;
        }
        ExampleScenario.ExampleScenarioActorComponent actor = actors.get(actorId);
        if (actor == null) {
            throw new FHIRException(this.context.formatPhrase("EX_SCEN_UN_ACT", new Object[]{actorId}) + " ");
        }
        actorCell.ah("#a_" + actor.getKey(), actor.getDescription()).tx(actor.getTitle());
    }

    private void addInstance(XhtmlNode row, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent instanceRef, Map<String, ExampleScenario.ExampleScenarioInstanceComponent> instances) {
        XhtmlNode instanceCell = row.td();
        if (instanceRef == null || instanceRef.getInstanceReference() == null) {
            return;
        }
        ExampleScenario.ExampleScenarioInstanceComponent instance = instances.get(instanceRef.getInstanceReference());
        if (instance == null) {
            instanceCell.b().tx("Bad reference: " + instanceRef.getInstanceReference());
        } else if (instanceRef.hasVersionReference()) {
            ExampleScenario.ExampleScenarioInstanceVersionComponent theVersion = null;
            for (ExampleScenario.ExampleScenarioInstanceVersionComponent version : instance.getVersion()) {
                if (!version.getKey().equals(instanceRef.getVersionReference())) continue;
                theVersion = version;
                break;
            }
            if (theVersion == null) {
                throw new FHIRException("Unable to find referenced version " + instanceRef.getVersionReference() + " within instance " + instanceRef.getInstanceReference());
            }
            instanceCell.ah(this.context.prefixLocalHref("#i_" + instance.getKey() + "v_" + theVersion.getKey()), theVersion.getDescription()).tx(theVersion.getTitle());
        } else {
            instanceCell.ah(this.context.prefixLocalHref("#i_" + instance.getKey()), instance.getDescription()).tx(instance.getTitle());
        }
    }
}

