/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.xver.XVerExtensionManager;
import org.hl7.fhir.r5.utils.xver.XVerExtensionManagerFactory;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public class ProfileDrivenRenderer
extends ResourceRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileDrivenRenderer.class);
    private Set<String> containedIds = new HashSet<String>();

    public ProfileDrivenRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException {
        this.renderResourceTechDetails(r, x);
        try {
            StructureDefinition sd = this.context.getContext().fetchTypeDefinition(r.fhirType());
            if (sd == null) {
                throw new FHIRException(this.context.formatPhrase("PROF_DRIV_FEXCP", new Object[]{r.fhirType()}) + " ");
            }
            ElementDefinition ed = sd.getSnapshot().getElement().get(0);
            this.containedIds.clear();
            this.generateByProfile(status, r, sd, r, ed, this.context.getProfileUtilities().getChildList(sd, ed), x, r.fhirType(), this.context.isTechnicalMode(), 0);
        }
        catch (Exception e) {
            log.debug(this.context.formatPhrase("PROF_DRIV_ERR_GEN_NARR", new Object[0]) + r.fhirType() + "/" + r.getId() + ": " + e.getMessage(), (Throwable)e);
            x.para().b().style("color: maroon").tx(this.context.formatPhrase("PROF_DRIV_EXCP", new Object[]{e.getMessage()}) + " ");
        }
    }

    @Override
    public String buildSummary(ResourceWrapper res) throws UnsupportedEncodingException, IOException {
        StructureDefinition profile = this.getContext().getWorker().fetchTypeDefinition(res.fhirType());
        if (profile == null) {
            return "unknown resource type " + res.fhirType();
        }
        List<ResourceWrapper> children = res.children();
        ContextUtilities cu = res.getContextUtilities();
        for (ResourceWrapper p : children) {
            if (!p.name().equals("title") || !cu.isDatatype(p.fhirType()) || p.isEmpty()) continue;
            return res.fhirType() + " " + this.displayDataType(p);
        }
        for (ResourceWrapper p : children) {
            if (!p.name().equals("name") || !cu.isDatatype(p.fhirType()) || p.isEmpty()) continue;
            return res.fhirType() + " " + this.displayDataType(p);
        }
        for (ResourceWrapper p : children) {
            if (!p.name().equals("code") || !cu.isDatatype(p.fhirType()) || p.isEmpty()) continue;
            return res.fhirType() + " " + this.displayDataType(p);
        }
        switch (res.fhirType()) {
            case "Binary": {
                return res.fhirType() + ": " + res.primitiveValue("contentType") + " (" + res.primitiveValue("data").length() + " bytes base64)";
            }
        }
        return this.generateResourceSummary(res, profile, profile.getSnapshot().getElementFirstRep(), false, false);
    }

    public String generateResourceSummary(ResourceWrapper res, StructureDefinition sd, ElementDefinition ed, boolean showCodeDetails, boolean canLink) throws FHIRException, UnsupportedEncodingException, IOException {
        if (sd == null) {
            return "unknown resource " + res.fhirType();
        }
        ProfileUtilities.SourcedChildDefinitions childDefs = this.context.getProfileUtilities().getChildMap(sd, ed, true);
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("; ");
        for (ResourceWrapper.NamedResourceWrapperList p : res.childrenInGroups()) {
            ElementDefinition pDefn = this.getElementDefinition(childDefs, p);
            if (pDefn == null || this.ignoreProperty(p) || pDefn.getBase().getPath().startsWith("Resource.") || p.getValues().size() <= 0 || p.getValues().get(0) == null || pDefn == null || !this.isSimple(pDefn) || !this.includeInSummary(pDefn, p)) continue;
            CommaSeparatedStringBuilder b2 = new CommaSeparatedStringBuilder(",");
            for (ResourceWrapper v : p.getValues()) {
                b2.append(this.displayDataType(v));
            }
            b.append(this.formatPhrase("PROF_DRIV_SUMM_PROP", this.labelForElement(pDefn), b2.toString()));
        }
        if (b.length() == 0) {
            return this.formatPhrase("PROF_DRIV_SUMM_NONE", res.fhirType());
        }
        return this.formatPhrase("PROF_DRIV_SUMM", res.fhirType(), b.toString());
    }

    private String labelForElement(ElementDefinition pDefn) {
        return pDefn.getName();
    }

    private ElementDefinition getElementDefinition(ProfileUtilities.SourcedChildDefinitions childDefs, ResourceWrapper.NamedResourceWrapperList p) {
        for (ElementDefinition ed : childDefs.getList()) {
            if (!ed.getName().equals(p.getName())) continue;
            return ed;
        }
        return null;
    }

    private boolean ignoreProperty(ResourceWrapper.NamedResourceWrapperList p) {
        return Utilities.existsInList((String)p.getName(), (String[])new String[]{"contained"});
    }

    private boolean includeInSummary(ElementDefinition child, ResourceWrapper.NamedResourceWrapperList list) throws UnsupportedEncodingException, FHIRException, IOException {
        String t;
        if (child.getName().endsWith("active") && list != null && list.getValues().size() > 0 && "true".equals(list.getValues().get(0).primitiveValue())) {
            return false;
        }
        if (child.getIsModifier()) {
            return true;
        }
        if (child.getMustSupport()) {
            return true;
        }
        return child.getType().size() != 1 || !(t = child.getType().get(0).getWorkingCode()).equals("Address") && !t.equals("Contact") && !t.equals("Reference") && !t.equals("Uri") && !t.equals("Url") && !t.equals("Canonical");
    }

    private ElementDefinition getElementDefinition(List<ElementDefinition> elements, String path) {
        for (ElementDefinition element : elements) {
            if (!element.getPath().equals(path)) continue;
            return element;
        }
        return null;
    }

    private void renderLeaf(Renderer.RenderingStatus status, ResourceWrapper res, ResourceWrapper ew, StructureDefinition sd, ElementDefinition defn, XhtmlNode parent, XhtmlNode x, boolean title, boolean showCodeDetails, Map<String, String> displayHints, int indent) throws FHIRException, UnsupportedEncodingException, IOException, EOperationOutcome {
        if (ew == null) {
            return;
        }
        if (this.context.isShowComments()) {
            x = this.renderCommentsSpan(x, ew);
        }
        if (Utilities.existsInList((String)ew.fhirType(), (String[])new String[]{"Extension"}) || ew.isResource()) {
            return;
        }
        if (ew.fhirType().equals("ElementDefinition")) {
            x.tx("todo-bundle");
        } else if (!this.renderDataType(status, parent, x, ew)) {
            boolean first = true;
            x.tx(" (");
            for (ResourceWrapper child : ew.children()) {
                if (child == null || "Extension".equals(child.fhirType()) || !this.canRenderDataType(child.fhirType())) continue;
                if (first) {
                    first = false;
                } else {
                    x.tx("; ");
                }
                x.tx(this.context.formatMessage("GENERAL_DATA_DISPLAY_PROPERTY", new Object[]{child.name(), this.displayDataType(child)}));
            }
            x.tx(")");
        }
    }

    private XhtmlNode renderCommentsSpan(XhtmlNode x, ResourceWrapper e) {
        if (e.hasFormatComment()) {
            return x.span(null, CommaSeparatedStringBuilder.join((String)"&#10;", e.getFormatCommentsPre()));
        }
        return x;
    }

    private boolean isSimple(ElementDefinition e) {
        if (e.getType().isEmpty()) {
            return false;
        }
        if (e.getType().size() == 1 && this.isBase(e.getType().get(0).getWorkingCode())) {
            return false;
        }
        if (e.getType().size() > 1) {
            return true;
        }
        StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(e.getTypeFirstRep().getCode());
        if (sd != null) {
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                return true;
            }
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE && Utilities.existsInList((String)e.getTypeFirstRep().getCode(), (String[])new String[]{"Extension", "CodeableConcept", "Coding", "Annotation", "Identifier", "HumanName", "SampledData", "Address", "ContactPoint", "ContactDetail", "Timing", "Range", "Quantity", "Ratio", "Period", "Reference"})) {
                return true;
            }
        }
        return false;
    }

    private boolean isBase(String code) {
        return code != null && (code.equals("Element") || code.equals("BackboneElement"));
    }

    private ProfileUtilities.SourcedChildDefinitions getChildrenForPath(StructureDefinition profile, String path) throws DefinitionException {
        List<ElementDefinition> elements = profile.getSnapshot().getElement();
        for (ElementDefinition e : elements) {
            if (!e.getPath().equals(path) || !e.hasContentReference()) continue;
            String ref = e.getContentReference();
            ElementDefinition t = null;
            for (ElementDefinition e1 : elements) {
                if (!ref.equals("#" + e1.getId())) continue;
                t = e1;
            }
            if (t == null) {
                throw new DefinitionException("Unable to resolve content reference " + (String)ref + " trying to resolve " + path);
            }
            path = t.getPath();
            break;
        }
        ElementDefinition t = null;
        ArrayList<ElementDefinition> results = new ArrayList<ElementDefinition>();
        for (ElementDefinition e : elements) {
            if (e.getPath().equals(path)) {
                t = e;
            }
            if (!e.getPath().startsWith(path + ".") || e.getPath().substring(path.length() + 1).contains(".")) continue;
            results.add(e);
        }
        if (results.isEmpty() && t != null && t.getType().size() == 1) {
            StructureDefinition tsd = this.context.getWorker().fetchTypeDefinition(t.getTypeFirstRep().getWorkingCode());
            return this.getChildrenForPath(tsd, tsd.getType());
        }
        return new ProfileUtilities.SourcedChildDefinitions(profile, results, path);
    }

    private void generateByProfile(Renderer.RenderingStatus status, ResourceWrapper res, StructureDefinition profile, ResourceWrapper e, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails, int indent) throws FHIRException, UnsupportedEncodingException, IOException, EOperationOutcome {
        if (children.isEmpty()) {
            StructureDefinition sdt = this.context.getWorker().fetchTypeDefinition(e.fhirType());
            if (sdt != null && (sdt.getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE || sdt.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE)) {
                this.renderLeaf(status, res, e, profile, defn, x, x, false, showCodeDetails, this.readDisplayHints(defn), indent);
            }
        } else {
            List<ResourceWrapper.NamedResourceWrapperList> pl = this.splitExtensions(profile, e.childrenInGroups());
            for (ResourceWrapper.NamedResourceWrapperList p : pl) {
                this.generateForProperty(status, res, profile, children, x, path, showCodeDetails, indent, false, p);
            }
            for (ResourceWrapper.NamedResourceWrapperList p : pl) {
                this.generateForProperty(status, res, profile, children, x, path, showCodeDetails, indent, true, p);
            }
        }
    }

    private void generateForProperty(Renderer.RenderingStatus status, ResourceWrapper res, StructureDefinition profile, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails, int indent, boolean round2, ResourceWrapper.NamedResourceWrapperList p) throws UnsupportedEncodingException, IOException, EOperationOutcome {
        ElementDefinition child;
        if (!(p.getValues().isEmpty() || (child = this.getElementDefinition(children, path + "." + p.getName())) == null || child.getBase().hasPath() && child.getBase().getPath().startsWith("Resource."))) {
            this.generateElementByProfile(status, res, profile, x, path, showCodeDetails, indent, p, child, round2);
        }
    }

    public void generateElementByProfile(Renderer.RenderingStatus status, ResourceWrapper res, StructureDefinition profile, XhtmlNode x, String path, boolean showCodeDetails, int indent, ResourceWrapper.NamedResourceWrapperList p, ElementDefinition child, boolean round2) throws UnsupportedEncodingException, IOException, EOperationOutcome {
        block20: {
            ProfileUtilities.SourcedChildDefinitions grandChildren;
            boolean isExt;
            Map<String, String> displayHints;
            block22: {
                block21: {
                    XhtmlNode para;
                    block19: {
                        displayHints = this.readDisplayHints(child);
                        if (!"DomainResource.contained".equals(child.getBase().getPath())) break block19;
                        if (!round2) break block20;
                        for (ResourceWrapper v : p.getValues()) {
                            RenderingContext ctxt = this.context.forContained();
                            if (v.getResourceWrapper() == null || RendererFactory.hasSpecificRenderer(v.fhirType())) continue;
                            x.hr();
                            ResourceRenderer rnd = RendererFactory.factory(v.fhirType(), ctxt);
                            rnd.buildNarrative(status, x.blockquote(), v);
                        }
                        break block20;
                    }
                    if (round2 || this.exemptFromRendering(child)) break block20;
                    isExt = this.isExtension(p);
                    if (isExt) {
                        status.setExtensions(true);
                    }
                    grandChildren = this.getChildrenForPath(profile, path + "." + p.getName());
                    this.filterGrandChildren(grandChildren.getList(), path + "." + p.getName(), p);
                    if (p.getValues().size() <= 0) break block20;
                    if (!this.isSimple(child) || isExt) break block21;
                    para = x.isPara() ? (para = x) : x.para();
                    String name = p.getName();
                    if (name.endsWith("[x]")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    if (!showCodeDetails && this.isDefaultValue(displayHints, p.getValues())) break block20;
                    this.markBoilerplate(para.b()).addText(name);
                    para.tx(": ");
                    if (this.renderAsList(child) && p.getValues().size() > 1) {
                        XhtmlNode list = x.ul();
                        for (ResourceWrapper v : p.getValues()) {
                            this.renderLeaf(status, res, v, profile, child, x, this.xlinkNarrative(list.li(), v), false, showCodeDetails, displayHints, indent);
                        }
                    } else {
                        boolean first = true;
                        for (ResourceWrapper v : p.getValues()) {
                            if (first) {
                                first = false;
                            } else {
                                para.tx(", ");
                            }
                            this.renderLeaf(status, res, v, profile, child, x, this.spanIfTracking(para, v), false, showCodeDetails, displayHints, indent);
                        }
                    }
                    break block20;
                }
                if (!this.canDoTable(path, p, grandChildren.getList(), x)) break block22;
                XhtmlNode xn = new XhtmlNode(NodeType.Element, this.getHeader());
                xn.addText(Utilities.capitalize((String)Utilities.camelCase((String)Utilities.pluralizeMe((String)p.getName()))));
                XhtmlNode tbl = new XhtmlNode(NodeType.Element, "table");
                tbl.setAttribute("class", "grid");
                XhtmlNode tr = tbl.tr();
                tr.td().style("display: none").tx("-");
                boolean add = this.addColumnHeadings(tr, grandChildren.getList());
                for (ResourceWrapper v : p.getValues()) {
                    if (v == null) continue;
                    tr = tbl.tr();
                    tr.td().style("display: none").tx("*");
                    add = this.addColumnValues(status, res, tr, profile, grandChildren.getList(), v, showCodeDetails, displayHints, indent) || add;
                }
                if (!add) break block20;
                x.add(xn);
                x.add(tbl);
                break block20;
            }
            if (this.isExtension(p)) {
                StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, p.getUrl());
                for (ResourceWrapper v : p.getValues()) {
                    if (v == null) continue;
                    ResourceWrapper vp = v.child("value");
                    List<ResourceWrapper> ev = v.children("extension");
                    if (vp != null) {
                        XhtmlNode para = x.para();
                        para.b().addText(this.labelforExtension(sd, p.getUrl()));
                        para.tx(": ");
                        this.renderLeaf(status, res, vp, profile, child, x, para, false, showCodeDetails, displayHints, indent);
                        continue;
                    }
                    if (ev.isEmpty()) continue;
                    XhtmlNode bq = x.addTag("blockquote");
                    bq.para().b().addText(this.labelforExtension(sd, p.getUrl()));
                    boolean allSimple = true;
                    for (ResourceWrapper resourceWrapper : ev) {
                        if (resourceWrapper.has("value")) continue;
                        allSimple = false;
                    }
                    if (allSimple) {
                        XhtmlNode ul = bq.ul();
                        for (ResourceWrapper vv2 : ev) {
                            XhtmlNode li = ul.li();
                            li.tx(this.labelForSubExtension(vv2.primitiveValue("url"), sd));
                            li.tx(": ");
                            this.renderLeaf(status, res, vv2.child("value"), sd, child, x, li, isExt, showCodeDetails, displayHints, indent);
                        }
                        continue;
                    }
                    for (ResourceWrapper resourceWrapper : ev) {
                        StructureDefinition ex = this.context.getWorker().fetchTypeDefinition("Extension");
                        ProfileUtilities.SourcedChildDefinitions children = this.getChildrenForPath(ex, "Extension");
                        this.generateByProfile(status, res, ex, resourceWrapper, child, children.getList(), bq, "Extension", showCodeDetails, indent + 1);
                    }
                }
            } else {
                for (ResourceWrapper v : p.getValues()) {
                    if (v == null) continue;
                    XhtmlNode bq = x.addTag("blockquote");
                    bq.para().b().addText(p.getName());
                    this.generateByProfile(status, res, grandChildren.getSource(), v, child, grandChildren.getList(), bq, grandChildren.getPath(), showCodeDetails, indent + 1);
                }
            }
        }
    }

    private String labelForSubExtension(String url, StructureDefinition sd) {
        return url;
    }

    private String labelforExtension(StructureDefinition sd, String url) {
        if (sd == null) {
            return this.tail(url);
        }
        return sd.present();
    }

    private String getHeader() {
        int i;
        for (i = 3; i <= this.context.getHeaderLevelContext(); ++i) {
        }
        if (i > 6) {
            i = 6;
        }
        return "h" + Integer.toString(i);
    }

    private List<ResourceWrapper> getValues(String path, ResourceWrapper.NamedResourceWrapperList p, ElementDefinition e) {
        ArrayList<ResourceWrapper> res = new ArrayList<ResourceWrapper>();
        for (ResourceWrapper v : p.getValues()) {
            for (ResourceWrapper g : v.children()) {
                if (!(path + "." + p.getName() + "." + g.name()).equals(e.getPath())) continue;
                res.add(v);
            }
        }
        return res;
    }

    private boolean canDoTable(String path, ResourceWrapper.NamedResourceWrapperList p, List<ElementDefinition> grandChildren, XhtmlNode x) {
        if (this.isExtension(p)) {
            return false;
        }
        if (x.getName().equals("p")) {
            return false;
        }
        if (grandChildren.size() == 0) {
            return false;
        }
        for (ElementDefinition e : grandChildren) {
            List<ResourceWrapper> values = this.getValues(path, p, e);
            if (values.size() <= 1 && this.isSimple(e) && this.canCollapse(e)) continue;
            return false;
        }
        return true;
    }

    public boolean isExtension(ResourceWrapper.NamedResourceWrapperList p) {
        return p.getUrl() != null;
    }

    private boolean canCollapse(ElementDefinition e) {
        return !e.getType().isEmpty();
    }

    private boolean exemptFromRendering(ElementDefinition child) {
        if (child == null) {
            return false;
        }
        if ("DomainResource.text".equals(child.getBase().getPath())) {
            return true;
        }
        if ("Composition.subject".equals(child.getPath())) {
            return true;
        }
        return "Composition.section".equals(child.getPath());
    }

    private boolean renderAsList(ElementDefinition child) {
        String t;
        return child.getType().size() == 1 && ((t = child.getType().get(0).getWorkingCode()).equals("Address") || t.equals("Reference"));
    }

    private boolean addColumnHeadings(XhtmlNode tr, List<ElementDefinition> grandChildren) {
        boolean b = false;
        for (ElementDefinition e : grandChildren) {
            b = true;
            tr.td().b().addText(Utilities.capitalize((String)this.tail(e.getPath())));
        }
        return b;
    }

    private boolean addColumnValues(Renderer.RenderingStatus status, ResourceWrapper res, XhtmlNode tr, StructureDefinition profile, List<ElementDefinition> grandChildren, ResourceWrapper v, boolean showCodeDetails, Map<String, String> displayHints, int indent) throws FHIRException, UnsupportedEncodingException, IOException, EOperationOutcome {
        boolean b = false;
        for (ElementDefinition e : grandChildren) {
            List<ResourceWrapper> p = v.children(e.getPath().substring(e.getPath().lastIndexOf(".") + 1));
            XhtmlNode td = tr.td();
            if (p == null || p.size() == 0) {
                b = true;
                td.tx(" ");
                continue;
            }
            for (ResourceWrapper vv : p) {
                b = true;
                td.sep(", ");
                this.renderLeaf(status, res, vv, profile, e, td, td, false, showCodeDetails, displayHints, indent);
            }
        }
        return b;
    }

    private void filterGrandChildren(List<ElementDefinition> grandChildren, String string, ResourceWrapper.NamedResourceWrapperList prop) {
        ArrayList<ElementDefinition> toRemove = new ArrayList<ElementDefinition>();
        toRemove.addAll(grandChildren);
        for (ResourceWrapper b : prop.getValues()) {
            ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
            for (ElementDefinition ed : toRemove) {
                List<ResourceWrapper> p = b.children(this.tail(ed.getPath()));
                if (p == null || p.isEmpty()) continue;
                list.add(ed);
            }
            toRemove.removeAll(list);
        }
        grandChildren.removeAll(toRemove);
    }

    private List<ResourceWrapper.NamedResourceWrapperList> splitExtensions(StructureDefinition profile, List<ResourceWrapper.NamedResourceWrapperList> children) throws UnsupportedEncodingException, IOException, FHIRException {
        ArrayList<ResourceWrapper.NamedResourceWrapperList> results = new ArrayList<ResourceWrapper.NamedResourceWrapperList>();
        for (ResourceWrapper.NamedResourceWrapperList p : children) {
            if (p.getName().equals("extension") || p.getName().equals("modifierExtension")) {
                for (ResourceWrapper v : p.getValues()) {
                    String url = v.primitiveValue("url");
                    if (url == null) continue;
                    StructureDefinition ed = this.getContext().getWorker().fetchResource(StructureDefinition.class, url);
                    if (ed == null) {
                        if (this.xverManager == null) {
                            this.xverManager = XVerExtensionManagerFactory.createExtensionManager(this.context.getWorker());
                        }
                        if (this.xverManager.matchingUrl(url) && this.xverManager.status(url) == XVerExtensionManager.XVerExtensionStatus.Valid) {
                            ed = this.xverManager.getDefinition(url);
                            new ContextUtilities(this.getContext().getWorker()).generateSnapshot(ed);
                            this.getContext().getWorker().cacheResource(ed);
                        }
                    }
                    if (p.getName().equals("modifierExtension") && ed == null) {
                        throw new DefinitionException("Unknown modifier extension " + url);
                    }
                    ResourceWrapper.NamedResourceWrapperList nl = null;
                    for (ResourceWrapper.NamedResourceWrapperList t : results) {
                        if (t.getUrl() == null || !t.getUrl().equals(url)) continue;
                        nl = t;
                    }
                    if (nl == null) {
                        nl = new ResourceWrapper.NamedResourceWrapperList(p.getName(), url);
                        results.add(nl);
                    }
                    nl.getValues().add(v);
                }
                continue;
            }
            results.add(p);
        }
        return results;
    }

    private Map<String, String> readDisplayHints(ElementDefinition defn) throws DefinitionException {
        String displayHint;
        HashMap<String, String> hints = new HashMap<String, String>();
        if (defn != null && !Utilities.noString((String)(displayHint = ExtensionUtilities.getDisplayHint(defn)))) {
            String[] list;
            for (String item : list = displayHint.split(";")) {
                String[] parts = item.split(":");
                if (parts.length == 1) {
                    hints.put("value", parts[0].trim());
                    continue;
                }
                if (parts.length != 2) {
                    throw new DefinitionException("error reading display hint: '" + displayHint + "'");
                }
                hints.put(parts[0].trim(), parts[1].trim());
            }
        }
        return hints;
    }

    private boolean isDefaultValue(Map<String, String> displayHints, List<ResourceWrapper> list) throws UnsupportedEncodingException, IOException, FHIRException {
        if (list.size() != 1) {
            return false;
        }
        if (list.get(0).isPrimitive()) {
            return this.isDefault(displayHints, list.get(0));
        }
        return false;
    }

    private boolean isDefault(Map<String, String> displayHints, ResourceWrapper primitiveType) {
        String v = primitiveType.primitiveValue();
        return !Utilities.noString((String)v) && displayHints.containsKey("default") && v.equals(displayHints.get("default"));
    }

    @Override
    protected String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    @Override
    protected String utail(String path) {
        return path.contains("/") ? path.substring(path.lastIndexOf("/") + 1) : path;
    }

    @Override
    public boolean canRender(Resource resource) {
        return this.context.getWorker().getResourceNames().contains(resource.fhirType());
    }

    @Override
    public ResourceRenderer.RendererType getRendererType() {
        return ResourceRenderer.RendererType.PROFILE;
    }
}

