/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.util.Date;
import org.hl7.fhir.r5.comparison.VersionComparisonAnnotation;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class Renderer {
    protected RenderingContext context;

    public Renderer(RenderingContext context) {
        this.context = context;
    }

    public Renderer(IWorkerContext worker) {
        this.context = new RenderingContext(worker, new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK), ValidationOptions.defaults(), "http://hl7.org/fhir/R5", "", worker.getLocale(), RenderingContext.ResourceRendererMode.END_USER, RenderingContext.GenerationRules.IG_PUBLISHER);
    }

    protected String formatPhrase(String theMessage, Object ... theMessageArguments) {
        return this.context.formatPhrase(theMessage, theMessageArguments);
    }

    public void genStandardsStatus(XhtmlNode td, StandardsStatus ss) {
        if (ss != null) {
            td.tx(" ");
            XhtmlNode a = td.ah(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC, true), "versions.html#std-process"}), this.context.formatPhrase("REND_STANDARDS", new Object[]{ss.toDisplay()}));
            a.style("padding-left: 3px; padding-right: 3px; border: 1px grey solid; font-weight: bold; color: black; background-color: " + ss.getColor());
            a.tx(ss.getAbbrev());
        }
    }

    protected XhtmlNode renderStatus(Base b, XhtmlNode x) {
        if (b == null || this.context.getChangeVersion() == null) {
            return x;
        }
        VersionComparisonAnnotation vca = (VersionComparisonAnnotation)b.getUserData("version-annotation");
        if (vca == null) {
            return x;
        }
        switch (vca.getType()) {
            case Added: {
                XhtmlNode spanOuter = x.span("border: solid 1px #dddddd; margin: 2px; padding: 2px", null);
                XhtmlNode spanInner = spanOuter.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", this.context.formatPhrase("REND_SINCE_ADDED", new Object[]{this.context.getChangeVersion()}));
                spanInner.img("icon-change-add.png", "icon");
                spanInner.tx(" " + this.context.formatPhrase("REND_ADDED", new Object[0]));
                return spanOuter;
            }
            case Changed: {
                XhtmlNode spanOuter = x.span("border: solid 1px #dddddd; margin: 2px; padding: 2px", null);
                String s = this.context.formatPhrase("REND_SINCE_CHANGED", new Object[]{this.context.getChangeVersion()});
                XhtmlNode spanInner = spanOuter.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", vca.getOriginal() == null ? s : this.context.formatPhrase("REND_SINCE_CHANGED_WAS", new Object[]{this.context.getChangeVersion(), vca.getOriginal()}));
                spanInner.img("icon-change-edit.png", "icon");
                spanInner.tx(" " + this.context.formatPhrase("REND_CHANGED", new Object[0]));
                return spanOuter;
            }
            case Deleted: {
                XhtmlNode spanOuter = x.span("border: solid 1px #dddddd; margin: 2px; padding: 2px", null);
                XhtmlNode spanInner = spanOuter.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", this.context.formatPhrase("GENERAL_REMOVED_SINCE", new Object[]{this.context.getChangeVersion()}));
                spanInner.img("icon-change-remove.png", "icon");
                spanInner.tx(" " + this.context.formatPhrase("REND_REMOVED", new Object[0]));
                return spanOuter.strikethrough();
            }
        }
        return x;
    }

    protected XhtmlNode renderStatusDiv(Base b, XhtmlNode x) {
        if (b == null || this.context.getChangeVersion() == null) {
            return x;
        }
        VersionComparisonAnnotation vca = (VersionComparisonAnnotation)b.getUserData("version-annotation");
        if (vca == null) {
            return x;
        }
        switch (vca.getType()) {
            case Added: {
                XhtmlNode divOuter = x.div("border: solid 1px #dddddd; margin: 2px; padding: 2px");
                XhtmlNode spanInner = divOuter.para().style("margin: 0").span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", this.context.formatPhrase("REND_SINCE_ADDED", new Object[]{this.context.getChangeVersion()}));
                spanInner.img("icon-change-add.png", "icon");
                spanInner.tx(" " + this.context.formatPhrase("REND_ADDED", new Object[0]));
                return divOuter;
            }
            case Changed: {
                XhtmlNode divOuter = x.div("border: solid 1px #dddddd; margin: 2px; padding: 2px");
                String s = this.context.formatPhrase("REND_SINCE_CHANGED", new Object[]{this.context.getChangeVersion()});
                XhtmlNode spanInner = divOuter.para().style("margin: 0").span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", vca.getOriginal() == null ? s : this.context.formatPhrase("REND_SINCE_CHANGED_WAS", new Object[]{this.context.getChangeVersion(), vca.getOriginal()}));
                spanInner.img("icon-change-edit.png", "icon");
                spanInner.tx(" " + this.context.formatPhrase("REND_CHANGED", new Object[0]));
                return divOuter;
            }
            case Deleted: {
                XhtmlNode divOuter = x.div("border: solid 1px #dddddd; margin: 2px; padding: 2px");
                XhtmlNode spanInner = divOuter.para().style("margin: 0").span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", this.context.formatPhrase("GENERAL_REMOVED_SINCE", new Object[]{this.context.getChangeVersion()}));
                spanInner.img("icon-change-remove.png", "icon");
                spanInner.tx(" " + this.context.formatPhrase("REND_REMOVED", new Object[0]));
                return divOuter.strikethrough();
            }
        }
        return x;
    }

    protected XhtmlNode renderStatusRow(Base b, XhtmlNode tbl, XhtmlNode tr) {
        if (b == null || this.context.getChangeVersion() == null) {
            return tr.td();
        }
        VersionComparisonAnnotation vca = (VersionComparisonAnnotation)b.getUserData("version-annotation");
        if (vca == null) {
            return tr.td();
        }
        switch (vca.getType()) {
            case Added: {
                if (tbl.isClass("grid")) {
                    tr.style("border: solid 1px #dddddd; margin: 2px; padding: 2px");
                }
                XhtmlNode td = tr.td();
                XhtmlNode span = td.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", this.context.formatPhrase("REND_ROW_SINCE", new Object[]{this.context.getChangeVersion()}));
                span.img("icon-change-add.png", "icon");
                span.tx(" " + this.context.formatPhrase("REND_ADDED", new Object[0]));
                XhtmlNode x = new XhtmlNode(NodeType.Element, "holder");
                x.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", this.context.formatPhrase("REND_ROW_SINCE", new Object[]{this.context.getChangeVersion()})).tx(" ");
                tr.styleCells(x);
                return td;
            }
            case Changed: {
                XhtmlNode td = tr.td();
                XhtmlNode span = td.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", this.context.formatPhrase("REND_ROW_CHANGED_SINCE_WAS", new Object[]{this.context.getChangeVersion(), vca.getOriginal()}));
                span.img("icon-change-edit.png", "icon");
                span.tx(" " + this.context.formatPhrase("REND_CHANGED", new Object[0]));
                return td;
            }
            case Deleted: {
                tr.style("text-decoration: line-through");
                XhtmlNode td = tr.td();
                XhtmlNode span = td.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", this.context.formatPhrase("GENERAL_REMOVED_SINCE", new Object[]{this.context.getChangeVersion()}));
                span.img("icon-change-remove.png", "icon");
                span.tx(" " + this.context.formatPhrase("REND_REMOVED", new Object[0]));
                XhtmlNode x = new XhtmlNode(NodeType.Element, "holder");
                x.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px; text-decoration: none", this.context.formatPhrase("REND_ROW_SINCE", new Object[]{this.context.getChangeVersion()})).tx(" ");
                tr.styleCells(x);
                return td;
            }
        }
        return tr.td();
    }

    public static boolean renderStatusSummary(RenderingContext context, Base base, XhtmlNode x, String version, String ... metadataFields) {
        if (base.hasUserData("version-annotation")) {
            VersionComparisonAnnotation self = (VersionComparisonAnnotation)base.getUserData("version-annotation");
            switch (self.getType()) {
                case Added: {
                    XhtmlNode spanInner = x.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", context.formatPhrase("REND_SINCE_ADDED", new Object[]{version}));
                    spanInner.img("icon-change-add.png", "icon");
                    spanInner.tx(" " + context.formatPhrase("REND_ADDED", new Object[0]));
                    return true;
                }
                case Changed: {
                    if (self.getComp().noChangeOtherThanMetadata(metadataFields)) {
                        x.span("color: #eeeeee").tx("n/c");
                        return false;
                    }
                    XhtmlNode spanInner = x.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", self.getOriginal() != null ? context.formatPhrase("REND_SINCE_CHANGED_WAS", new Object[]{version, self.getOriginal()}) : context.formatPhrase("REND_SINCE_CHANGED", new Object[]{version}));
                    spanInner.img("icon-change-edit.png", "icon");
                    spanInner.tx(" " + context.formatPhrase("REND_CHANGED", new Object[0]));
                    return true;
                }
                case Deleted: {
                    XhtmlNode spanInner = x.span("background-color: #fff2ff; border-left: solid 3px #ffa0ff; margin: 2px; padding: 2px", context.formatPhrase("GENERAL_REMOVED_SINCE", new Object[]{version}));
                    spanInner.img("icon-change-remove.png", "icon");
                    spanInner.tx(" " + context.formatPhrase("REND_REMOVED", new Object[0]));
                    return true;
                }
            }
            x.span("color: #eeeeee").tx("n/c");
            return false;
        }
        x.span("color: #eeeeee").tx("--");
        return false;
    }

    public String egt(Enumeration<? extends Enum> value) {
        if (value == null || !value.hasPrimitiveValue()) {
            return null;
        }
        return value == null || !value.hasPrimitiveValue() ? null : value.asStringValue();
    }

    public String toStr(int value) {
        return Integer.toString(value);
    }

    public String toStr(Date value) {
        return value.toString();
    }

    protected ResourceWrapper wrapNC(DataType type) {
        return ResourceWrapper.forType(this.context.getContextUtilities(), type);
    }

    protected ResourceWrapper wrap(Resource resource) {
        return ResourceWrapper.forResource(this.context.getContextUtilities(), resource);
    }

    protected ResourceWrapper wrapWC(ResourceWrapper resource, DataType type) {
        return ResourceWrapper.forType(this.context.getContextUtilities(), resource, type);
    }

    protected String getTranslatedCode(ResourceWrapper child) {
        return this.context.getTranslatedCode(child.primitiveValue(), child.getCodeSystemUri());
    }

    public XhtmlNode xlinkNarrative(XhtmlNode x, ResourceWrapper type) {
        if (this.context.isTrackNarrativeSource() && !x.hasUserData("narrative.linked") && type != null) {
            if (type.hasId()) {
                x.id(type.getId());
            } else {
                String id = this.context.nextXNKey();
                x.id(id);
                type.setId(id);
            }
            x.clss("generated");
            x.setUserData("narrative.linked", (Object)true);
        }
        return x;
    }

    public XhtmlNode markBoilerplate(XhtmlNode x) {
        if (this.context.isTrackNarrativeSource()) {
            x.clss("boilerplate");
        }
        return x;
    }

    public XhtmlNode markGenerated(XhtmlNode x) {
        if (this.context.isTrackNarrativeSource()) {
            x.clss("generated");
        }
        return x;
    }

    public XhtmlNode spanIfTracking(XhtmlNode x, ResourceWrapper v) {
        if (this.context.isTrackNarrativeSource()) {
            XhtmlNode span = x.span();
            this.xlinkNarrative(span, v);
            return span;
        }
        return x;
    }

    public static class RenderingStatus {
        private boolean extensions;

        public void setExtensions(boolean b) {
            this.extensions = b;
        }

        public boolean getExtensions() {
            return this.extensions;
        }

        public boolean isShowCodeDetails() {
            return false;
        }
    }
}

