/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class SearchParameterRenderer
extends TerminologyRenderer {
    public SearchParameterRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (r.isDirect()) {
            this.renderResourceTechDetails(r, x);
            this.genSummaryTable(status, x, (SearchParameter)r.getBase());
            this.render(status, x, (SearchParameter)r.getBase());
        } else {
            x.para().tx("SearchParameterRenderer only renders native resources directly");
        }
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, SearchParameter spd) throws IOException, FHIRException, EOperationOutcome {
        XhtmlNode h2 = x.h2();
        h2.addText(spd.getName());
        StandardsStatus ss = ExtensionUtilities.getStandardsStatus(spd);
        if (ss != this.context.getDefaultStandardsStatus()) {
            this.genStandardsStatus(h2, ss);
        }
        XhtmlNode p = x.para();
        p.tx(this.context.formatPhrase("GENERAL_PAR", new Object[0]) + " ");
        p.code().tx(spd.getCode());
        p.tx(":");
        p.code().tx(spd.getType().toCode());
        this.addMarkdown(x, spd.getDescription());
        XhtmlNode tbl = x.table("grid", false);
        XhtmlNode tr = tbl.tr();
        tr.td().tx(Utilities.pluralize((String)this.context.formatPhrase("GENERAL_RESOURCE", new Object[0]), (int)spd.getBase().size()));
        XhtmlNode td = tr.td();
        for (Enumeration<Enumerations.VersionIndependentResourceTypesAll> t : spd.getBase()) {
            StructureDefinition structureDefinition = this.context.getWorker().fetchTypeDefinition(t.getCode());
            if (structureDefinition != null && structureDefinition.hasWebPath()) {
                td.sep(", ");
                td.ah(this.context.prefixLocalHref(this.context.prefixLocalHref(structureDefinition.getWebPath()))).tx(t.getCode());
                continue;
            }
            td.sep(", ");
            td.tx(t.getCode());
        }
        tr = tbl.tr();
        tr.td().tx(this.context.formatPhrase("SEARCH_PAR_EXP", new Object[0]));
        if (spd.hasExpression()) {
            tr.td().code().tx(spd.getExpression());
        } else {
            tr.td().tx(this.context.formatPhrase("SEARCH_PAR_NONE", new Object[0]));
        }
        if (spd.hasProcessingMode()) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("SEARCH_PAR_PROC", new Object[0]));
            tr.td().tx(spd.getProcessingMode().getDisplay());
        }
        if (spd.hasTarget()) {
            tr = tbl.tr();
            tr.td().tx(Utilities.pluralize((String)this.context.formatPhrase("SEARCH_PAR_REND_TARGET", new Object[0]), (int)spd.getTarget().size()));
            td = tr.td();
            if (this.isAllConcreteResources(spd.getTarget())) {
                td.ah(this.context.prefixLocalHref(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC, true), "resourcelist.html"}))).tx(this.context.formatPhrase("SEARCH_PAR_RES", new Object[0]));
            } else {
                for (Enumeration<Enumerations.VersionIndependentResourceTypesAll> t : spd.getTarget()) {
                    StructureDefinition structureDefinition = this.context.getWorker().fetchTypeDefinition(t.getCode());
                    if (structureDefinition != null && structureDefinition.hasWebPath()) {
                        td.sep(", ");
                        td.ah(this.context.prefixLocalHref(structureDefinition.getWebPath())).tx(t.getCode());
                        continue;
                    }
                    td.sep(", ");
                    td.tx(t.getCode());
                }
            }
        }
        tr = tbl.tr();
        tr.td().tx(this.context.formatPhrase("SEARCH_PAR_MULTIPLES", new Object[0]));
        XhtmlNode ul = tr.td().ul();
        if (!spd.hasMultipleAnd()) {
            ul.li().tx(this.context.formatPhrase("SEARCH_PAR_MULTIPLE_AND_SERVER", new Object[0]));
        } else if (spd.getMultipleAnd()) {
            ul.li().tx(this.context.formatPhrase("SEARCH_PAR_MULTIPLE_AND_REPEAT", new Object[0]));
        } else {
            ul.li().tx(this.context.formatPhrase("SEARCH_PAR_MULTIPLE_AND_APPEAR", new Object[0]));
        }
        if (!spd.hasMultipleOr()) {
            ul.li().tx(this.context.formatPhrase("SEARCH_PAR_MULTIPLE_OR_SERVER", new Object[0]));
        } else if (spd.getMultipleOr()) {
            ul.li().tx(this.context.formatPhrase("SEARCH_PAR_MULTIPLE_OR_MULTIPLE", new Object[0]));
        } else {
            ul.li().tx(this.context.formatPhrase("SEARCH_PAR_MULTIPLE_OR_ONE", new Object[0]));
        }
        if (spd.hasComparator()) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("GENERAL_COMPARATORS", new Object[0]));
            td = tr.td();
            td.tx(this.context.formatPhrase("SEARCH_PAR_ALLOWED", new Object[0]) + " ");
            for (Enumeration enumeration : spd.getComparator()) {
                td.sep(", ");
                td.tx(enumeration.asStringValue());
            }
        }
        if (spd.hasModifier()) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("GENERAL_MODIFIERS", new Object[0]));
            td = tr.td();
            td.tx(this.context.formatPhrase("SEARCH_PAR_ALLOWED", new Object[0]) + " ");
            for (Enumeration enumeration : spd.getModifier()) {
                td.sep(", ");
                td.tx(enumeration.asStringValue());
            }
        }
        if (spd.hasChain()) {
            tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("SEARCH_PAR_CHAIN", new Object[0]));
            td = tr.td();
            td.tx(this.context.formatPhrase("SEARCH_PAR_ALLOWED", new Object[0]) + " ");
            for (StringType stringType : spd.getChain()) {
                td.sep(", ");
                td.tx(stringType.asStringValue());
            }
        }
        if (spd.hasComponent()) {
            x.para().b().tx(this.context.formatPhrase("GENERAL_COMPARATORS", new Object[0]));
            tbl = x.table("grid", false);
            for (SearchParameter.SearchParameterComponentComponent searchParameterComponentComponent : spd.getComponent()) {
                tr = tbl.tr();
                SearchParameter tsp = this.context.getWorker().fetchResource(SearchParameter.class, searchParameterComponentComponent.getDefinition(), spd);
                if (tsp != null && tsp.hasWebPath()) {
                    tr.td().ah(this.context.prefixLocalHref(tsp.getWebPath())).tx(tsp.present());
                } else {
                    tr.td().tx(searchParameterComponentComponent.getDefinition());
                }
                tr.td().code().tx(searchParameterComponentComponent.getExpression());
            }
        }
    }

    private boolean isAllConcreteResources(List<Enumeration<Enumerations.VersionIndependentResourceTypesAll>> list) {
        for (String s : this.context.getWorker().getResourceNames()) {
            StructureDefinition sd = this.context.getWorker().fetchTypeDefinition(s);
            if (sd.getAbstract() || Utilities.existsInList((String)sd.getType(), (String[])new String[]{this.context.formatPhrase("GENERAL_PAR", new Object[0])})) continue;
            boolean found = false;
            for (Enumeration<Enumerations.VersionIndependentResourceTypesAll> c : list) {
                found = found || sd.getName().equals(c.getCode());
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void describe(XhtmlNode x, OperationDefinition opd) {
        x.tx(this.display(opd));
    }

    public String display(OperationDefinition opd) {
        return opd.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((SearchParameter)r).present();
    }
}

