/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.CanonicalPair;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public abstract class TerminologyRenderer
extends ResourceRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerminologyRenderer.class);

    public TerminologyRenderer(RenderingContext context) {
        super(context);
    }

    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((CanonicalResource)r).present();
    }

    protected XhtmlNode addMapHeaders(XhtmlNode tr, List<UsedConceptMap> maps) throws FHIRFormatError, DefinitionException, IOException {
        for (UsedConceptMap m : maps) {
            XhtmlNode td = tr.td();
            XhtmlNode b = td.b();
            String link = m.getLink();
            XhtmlNode a = b.ah(this.context.prefixLocalHref(link));
            a.addText(m.getDetails().getName());
            if (!m.getDetails().isDoDescription() || !m.getMap().hasDescription()) continue;
            this.addMarkdown(td, m.getMap().getDescription());
        }
        return tr;
    }

    protected String getHeader() {
        int i;
        for (i = 3; i <= this.getContext().getHeaderLevelContext(); ++i) {
        }
        if (i > 6) {
            i = 6;
        }
        return "h" + Integer.toString(i);
    }

    protected List<TargetElementComponentWrapper> findMappingsForCode(String code, ConceptMap map) {
        ArrayList<TargetElementComponentWrapper> mappings = new ArrayList<TargetElementComponentWrapper>();
        for (ConceptMap.ConceptMapGroupComponent g : map.getGroup()) {
            for (ConceptMap.SourceElementComponent c : g.getElement()) {
                if (!c.getCode().equals(code)) continue;
                for (ConceptMap.TargetElementComponent cc : c.getTarget()) {
                    mappings.add(new TargetElementComponentWrapper(g, cc));
                }
            }
        }
        return mappings;
    }

    protected String getCharForRelationship(ConceptMap.TargetElementComponent mapping) {
        if (!mapping.hasRelationship()) {
            return "";
        }
        switch (mapping.getRelationship()) {
            case EQUIVALENT: {
                return "~";
            }
            case SOURCEISNARROWERTHANTARGET: {
                return "<";
            }
            case SOURCEISBROADERTHANTARGET: {
                return ">";
            }
            case NOTRELATEDTO: {
                return "!=";
            }
        }
        return "?";
    }

    protected <T extends Resource> void addCsRef(ValueSet.ConceptSetComponent inc, XhtmlNode li, T cs) {
        String spec;
        Object ref = null;
        boolean addHtml = true;
        if (cs != null) {
            ref = (String)cs.getUserData("External.Link");
            if (Utilities.noString((String)ref)) {
                ref = (String)cs.getUserData("filename");
            } else {
                addHtml = false;
            }
            if (Utilities.noString((String)ref) && (ref = cs.getWebPath()) != null) {
                addHtml = false;
            }
        }
        if ((spec = this.getSpecialReference(inc.getSystem())) != null) {
            XhtmlNode a = li.ah(this.context.prefixLocalHref(spec));
            a.code(inc.getSystem());
        } else if (cs != null && ref != null) {
            if (addHtml && !((String)ref).contains(".html")) {
                ref = (String)ref + ".html";
            }
            ref = this.context.fixReference((String)ref);
            XhtmlNode a = li.ah(this.context.prefixLocalHref(((String)ref).replace("\\", "/")));
            a.code(inc.getSystem());
        } else {
            li.code(inc.getSystem());
        }
    }

    private String getSpecialReference(String system) {
        if ("http://snomed.info/sct".equals(system)) {
            return "http://www.snomed.org/";
        }
        if (Utilities.existsInList((String)system, (String[])new String[]{"http://loinc.org", "http://unitsofmeasure.org", "http://www.nlm.nih.gov/research/umls/rxnorm", "http://ncimeta.nci.nih.gov", "http://fdasis.nlm.nih.gov", "http://www.radlex.org", "http://www.whocc.no/atc", "http://dicom.nema.org/resources/ontology/DCM", "http://www.genenames.org", "http://www.ensembl.org", "http://www.ncbi.nlm.nih.gov/nuccore", "http://www.ncbi.nlm.nih.gov/clinvar", "http://sequenceontology.org", "http://www.hgvs.org/mutnomen", "http://www.ncbi.nlm.nih.gov/projects/SNP", "http://cancer.sanger.ac.uk/cancergenome/projects/cosmic", "http://www.lrg-sequence.org", "http://www.omim.org", "http://www.ncbi.nlm.nih.gov/pubmed", "http://www.pharmgkb.org", "http://clinicaltrials.gov", "http://www.ebi.ac.uk/ipd/imgt/hla/"})) {
            return system;
        }
        return null;
    }

    protected XhtmlNode addTableHeaderRowStandard(XhtmlNode t, boolean hasHierarchy, boolean hasDisplay, boolean definitions, boolean comments, boolean version, boolean deprecated, List<CodeSystem.PropertyComponent> properties, List<String> langs, Map<String, String> designations, boolean doDesignations) {
        XhtmlNode tr = t.tr();
        if (hasHierarchy) {
            tr.td().b().tx(this.context.formatPhrase("TERMINOLOGY_LVL", new Object[0]));
        }
        tr.td().attribute("style", "white-space:nowrap").b().tx(this.formatPhrase("GENERAL_CODE", new Object[0]));
        if (hasDisplay) {
            tr.td().b().tx(this.formatPhrase("TX_DISPLAY", new Object[0]));
        }
        if (definitions) {
            tr.td().b().tx(this.formatPhrase("GENERAL_DEFINITION", new Object[0]));
        }
        if (deprecated) {
            tr.td().b().tx(this.formatPhrase("CODESYSTEM_DEPRECATED", new Object[0]));
        }
        if (comments) {
            tr.td().b().tx(this.formatPhrase("GENERAL_COMMENTS", new Object[0]));
        }
        if (version) {
            tr.td().b().tx(this.formatPhrase("GENERAL_VER", new Object[0]));
        }
        if (properties != null) {
            for (CodeSystem.PropertyComponent pc : properties) {
                String display = this.getDisplayForProperty(pc);
                tr.td().b().tx(display);
            }
        }
        if (doDesignations) {
            if (designations != null) {
                for (String url : designations.keySet()) {
                    tr.td().b().addText(designations.get(url));
                }
            }
            if (langs != null) {
                for (String lang : langs) {
                    tr.td().b().addText(this.describeLang(lang));
                }
            }
        }
        return tr;
    }

    protected String getDisplayForProperty(CodeSystem.PropertyComponent pc) {
        String display = ExtensionUtilities.getPresentation(pc, pc.getCodeElement());
        if ((display == null || display.equals(pc.getCode()) && pc.hasUri()) && (display = this.getDisplayForProperty(pc.getUri())) == null) {
            display = pc.getCode();
        }
        return display;
    }

    protected String getDisplayForProperty(String uri) {
        CodeSystem cs;
        if (Utilities.noString((String)uri)) {
            return null;
        }
        String code = null;
        if (uri.contains("#")) {
            code = uri.substring(uri.indexOf("#") + 1);
            uri = uri.substring(0, uri.indexOf("#"));
        }
        if ((cs = this.getContext().getWorker().fetchCodeSystem(uri)) == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent cc = code == null ? null : CodeSystemUtilities.getCode(cs, code);
        return cc == null ? null : cc.getDisplay();
    }

    protected void AddVsRef(String value, XhtmlNode li, Resource source) {
        Object res = null;
        if (res != null && !(res instanceof CanonicalResource)) {
            li.addText(value);
            return;
        }
        CanonicalResource vs = res;
        if (vs == null) {
            vs = this.getContext().getWorker().findTxResource(ValueSet.class, value, source);
        }
        if (vs == null) {
            vs = this.getContext().getWorker().fetchResource(StructureDefinition.class, value, source);
        }
        if (vs == null) {
            vs = this.getContext().getWorker().fetchResource(Questionnaire.class, value, source);
        }
        if (vs != null) {
            String ref = vs.getWebPath();
            if (ref == null) {
                li.tx(vs.present());
            } else {
                ref = this.context.fixReference(ref);
                XhtmlNode a = li.ah(this.context.prefixLocalHref(ref.replace("\\", "/")));
                a.addText(vs.present());
            }
        } else {
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(value);
            if (cs != null) {
                String ref = cs.getWebPath();
                XhtmlNode a = li.ah(this.context.prefixLocalHref((ref = this.context.fixReference(ref)) == null ? "?ngen-12?" : ref.replace("\\", "/")));
                a.addText(value);
            } else if (value.equals("http://snomed.info/sct") || value.equals("http://snomed.info/id")) {
                XhtmlNode a = li.ah(this.context.prefixLocalHref(value));
                a.tx(this.context.formatPhrase("STRUC_DEF_SNOMED", new Object[0]));
            } else {
                if (value.startsWith("http://hl7.org") && !Utilities.existsInList((String)value, (String[])new String[]{"http://hl7.org/fhir/sid/icd-10-us"})) {
                    log.debug("Unable to resolve value set " + value);
                }
                li.addText(value);
            }
        }
    }

    protected String getDisplayForConcept(String canonical, String value) {
        CanonicalPair split = CanonicalPair.of((String)canonical);
        return this.getDisplayForConcept(split.getUrl(), split.getVersion(), value);
    }

    protected String getDisplayForConcept(String system, String version, String value) {
        if (value == null || system == null) {
            return null;
        }
        ValidationResult cl = this.getContext().getWorker().validateCode(this.getContext().getTerminologyServiceOptions().withVersionFlexible(true), system, version, value, null);
        return cl == null ? null : cl.getDisplay();
    }

    protected void clipboard(XhtmlNode x, String img, String title, String source) {
        XhtmlNode span = x.span("cursor: pointer", this.formatPhrase("TERM_REND_COPY", title));
        span.attribute("onClick", "navigator.clipboard.writeText('" + Utilities.escapeJson((String)source) + "');");
        span.img(img, "btn").setAttribute("width", "24px").setAttribute("height", "16px");
    }

    public class UsedConceptMap {
        private ConceptMapRenderInstructions details;
        private String link;
        private ConceptMap map;

        public UsedConceptMap(ConceptMapRenderInstructions details, String link, ConceptMap map) {
            this.details = details;
            this.link = link;
            this.map = map;
        }

        public ConceptMapRenderInstructions getDetails() {
            return this.details;
        }

        public ConceptMap getMap() {
            return this.map;
        }

        public String getLink() {
            return this.link;
        }
    }

    public class ConceptMapRenderInstructions {
        private String name;
        private String url;
        private boolean doDescription;

        public ConceptMapRenderInstructions(String name, String url, boolean doDescription) {
            this.name = name;
            this.url = url;
            this.doDescription = doDescription;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDoDescription() {
            return this.doDescription;
        }
    }

    protected class TargetElementComponentWrapper {
        protected ConceptMap.ConceptMapGroupComponent group;
        protected ConceptMap.TargetElementComponent comp;

        protected TargetElementComponentWrapper(ConceptMap.ConceptMapGroupComponent group, ConceptMap.TargetElementComponent comp) {
            this.group = group;
            this.comp = comp;
        }
    }
}

