/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.comparison.VersionComparisonAnnotation;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.TerminologyRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.terminologies.utilities.SnomedUtilities;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.LoincLinker;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class ValueSetRenderer
extends TerminologyRenderer {
    private static final int MAX_DESIGNATIONS_IN_LINE = 5;
    private static final int MAX_BATCH_VALIDATION_SIZE = 1000;
    private List<TerminologyRenderer.ConceptMapRenderInstructions> renderingMaps = new ArrayList<TerminologyRenderer.ConceptMapRenderInstructions>();
    private Map<String, String> oidMap;

    public ValueSetRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        if (!r.isDirect()) {
            x.para().tx("ValueSetRenderer only renders native resources directly");
        } else {
            this.renderResourceTechDetails(r, x);
            ValueSet vs = (ValueSet)r.getBase();
            this.genSummaryTable(status, x, vs);
            List<TerminologyRenderer.UsedConceptMap> maps = this.findReleventMaps(vs);
            if (this.context.isShowSummaryTable()) {
                XhtmlNode h = x.h2();
                h.addText(vs.hasTitle() ? vs.getTitle() : vs.getName());
                this.addMarkdown(x, vs.getDescription());
                if (vs.hasCopyright()) {
                    this.generateCopyright(x, r);
                }
            }
            if (vs.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-supplement")) {
                List<Extension> exts = vs.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-supplement");
                XhtmlNode p = x.para();
                p.tx(this.context.formatPhrasePlural(exts.size(), "VALUE_SET_NEEDS_SUPPL", new Object[0]));
                p.tx(" ");
                for (int i = 0; i < exts.size(); ++i) {
                    if (i > 0) {
                        if (i == exts.size() - 1) {
                            p.tx(" and ");
                        } else {
                            p.tx(", ");
                        }
                    }
                    String u = exts.get(i).getValue().primitiveValue();
                    CodeSystem cs = this.context.getContext().fetchResource(CodeSystem.class, u);
                    if (cs == null) {
                        p.code().tx(u);
                        continue;
                    }
                    if (!cs.hasWebPath()) {
                        p.ah(u).tx(cs.present());
                        continue;
                    }
                    p.ah(cs.getWebPath()).tx(cs.present());
                }
                p.tx(".");
            }
            if (vs.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/valueset-parameter")) {
                x.para().b().tx("This ValueSet has parameters");
                XhtmlNode tbl = x.table("grid");
                XhtmlNode tr = tbl.tr();
                tr.th().tx("Name");
                tr.th().tx("Documentation");
                for (Extension ext : vs.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/valueset-parameter")) {
                    tr = tbl.tr();
                    tr.td().tx(ext.getExtensionString("name"));
                    tr.td().markdown(ext.getExtensionString("documentation"), "parameter.documentation");
                }
            }
            if (vs.hasExpansion()) {
                this.generateExpansion(status, r, x, vs, false, maps);
            } else {
                this.generateComposition(status, r, x, vs, false, maps);
            }
        }
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, ValueSet vs, boolean header) throws FHIRFormatError, DefinitionException, IOException {
    }

    public void describe(XhtmlNode x, ValueSet vs) {
        x.tx(this.display(vs));
    }

    public String display(ValueSet vs) {
        return vs.present();
    }

    private List<TerminologyRenderer.UsedConceptMap> findReleventMaps(ValueSet vs) throws FHIRException {
        ArrayList<TerminologyRenderer.UsedConceptMap> res = new ArrayList<TerminologyRenderer.UsedConceptMap>();
        for (ConceptMap cm : this.getContext().getWorker().fetchResourcesByType(ConceptMap.class)) {
            if (!this.isSource(vs, cm.getSourceScope())) continue;
            TerminologyRenderer.ConceptMapRenderInstructions re = this.findByTarget(cm.getTargetScope());
            if (re == null) {
                re = new TerminologyRenderer.ConceptMapRenderInstructions(cm.present(), cm.getUrl(), false);
            }
            if (re == null) continue;
            Resource vst = cm.hasTargetScope() ? this.getContext().getWorker().findTxResource(ValueSet.class, cm.hasTargetScopeCanonicalType() ? (String)cm.getTargetScopeCanonicalType().getValue() : cm.getTargetScopeUriType().asStringValue(), cm) : null;
            res.add(new TerminologyRenderer.UsedConceptMap(re, vst == null ? cm.getWebPath() : vst.getWebPath(), cm));
        }
        return res;
    }

    private boolean isSource(ValueSet vs, DataType source) {
        return vs.hasUrl() && source != null && vs.getUrl().equals(source.primitiveValue());
    }

    private void generateExpansion(Renderer.RenderingStatus status, ResourceWrapper res, XhtmlNode x, ValueSet vs, boolean header, List<TerminologyRenderer.UsedConceptMap> maps) throws FHIRFormatError, DefinitionException, IOException {
        ArrayList<String> langs = new ArrayList<String>();
        HashMap<String, String> designations = new HashMap<String, String>();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (header) {
            XhtmlNode h = x.addTag(this.getHeader());
            h.tx(this.context.formatPhrase("VALUE_SET_CONT", new Object[0]));
            if (this.IsNotFixedExpansion(vs)) {
                this.addMarkdown(x, vs.getDescription());
            }
            if (vs.hasCopyright()) {
                this.generateCopyright(x, res);
            }
        }
        boolean hasFragment = this.generateContentModeNotices(x, vs.getExpansion(), vs);
        this.generateVersionNotice(x, vs.getExpansion(), vs);
        if (ExtensionUtilities.hasExtension(vs.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) {
            String msg = null;
            msg = vs.getExpansion().getContains().isEmpty() ? this.context.formatPhrase("VALUE_SET_TOO_COSTLY", new Object[0]) : this.context.formatPhrase("VALUE_SET_CODE_SELEC", new Object[]{this.countMembership(vs)});
            x.para().style("border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(msg);
        } else {
            int count = ValueSetUtilities.countExpansion(vs);
            if (vs.getExpansion().hasTotal()) {
                if (count != vs.getExpansion().getTotal()) {
                    x.para().style("border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(this.context.formatPhrase(hasFragment ? "VALUE_SET_HAS_AT_LEAST" : "VALUE_SET_HAS", new Object[]{vs.getExpansion().getTotal(), count}));
                } else {
                    x.para().tx(this.context.formatPhrase(hasFragment ? "VALUE_SET_CONTAINS_AT_LEAST" : "VALUE_SET_CONTAINS", new Object[]{vs.getExpansion().getTotal()}));
                }
            } else if (count == 1000) {
                String msg = this.context.formatPhrase("VALUE_SET_SEL", new Object[0]);
                x.para().style("border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(msg);
            } else {
                x.para().tx(this.context.formatPhrase("VALUE_SET_NUMBER_CONCEPTS", new Object[]{count}));
            }
        }
        boolean doLevel = false;
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            if (!cc.hasContains()) continue;
            doLevel = true;
            break;
        }
        boolean doInactive = this.checkDoInactive(vs.getExpansion().getContains());
        boolean doDefinition = this.checkDoDefinition(vs.getExpansion().getContains());
        XhtmlNode t = x.table("codes", false);
        XhtmlNode tr = t.tr();
        if (doLevel) {
            tr.td().b().tx(this.context.formatPhrase("VALUE_SET_LEVEL", new Object[0]));
        }
        tr.td().attribute("style", "white-space:nowrap").b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
        tr.td().b().tx(this.context.formatPhrase("VALUE_SET_SYSTEM", new Object[0]));
        XhtmlNode tdDisp = tr.td();
        String displang = vs.getLanguage();
        if (displang == null) {
            displang = this.findParamValue(vs.getExpansion().getParameter(), "displayLanguage");
        }
        if (displang == null) {
            tdDisp.b().tx(this.context.formatPhrase("TX_DISPLAY", new Object[0]));
        } else {
            tdDisp.b().tx(this.context.formatPhrase("TX_DISPLAY_LANG", new Object[]{displang}));
        }
        boolean doDesignations = false;
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.scanForDesignations(vs, c, langs, designations);
        }
        this.scanForProperties(vs.getExpansion(), langs, properties);
        if (doInactive) {
            tr.td().b().tx(this.context.formatPhrase("VALUE_SET_INACTIVE", new Object[0]));
        }
        if (doDefinition) {
            tr.td().b().tx(this.context.formatPhrase("GENERAL_DEFINITION", new Object[0]));
            doDesignations = false;
            for (String n : Utilities.sorted(properties.keySet())) {
                tr.td().b().ah(this.context.prefixLocalHref((String)properties.get(n))).addText(n);
            }
        } else {
            for (String n : Utilities.sorted(properties.keySet())) {
                tr.td().b().ah(this.context.prefixLocalHref((String)properties.get(n))).addText(n);
            }
            boolean bl = doDesignations = langs.size() + properties.size() + designations.size() < 5;
            if (doDesignations) {
                if (vs.hasLanguage()) {
                    tdDisp.tx(" - " + this.describeLang(vs.getLanguage()));
                }
                for (String url : designations.keySet()) {
                    tr.td().b().addText((String)designations.get(url));
                }
                for (String lang : langs) {
                    tr.td().b().addText(this.describeVSLang(lang, displang));
                }
            }
        }
        this.addMapHeaders(tr, maps);
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.addExpansionRowToTable(t, vs, c, 1, doLevel, doDefinition, doInactive, maps, langs, designations, doDesignations, properties, res);
        }
        if (!doDesignations && langs.size() + designations.size() > 0) {
            Collections.sort(langs);
            if (designations.size() == 0) {
                x.para().b().tx(this.context.formatPhrase("GENERAL_ADD_LANG", new Object[0]));
            } else if (langs.size() == 0) {
                x.para().b().tx(this.context.formatPhrase("VALUE_SET_DESIG", new Object[0]));
            } else {
                x.para().b().tx(this.context.formatPhrase("VALUE_SET_ADD_DESIG", new Object[0]));
            }
            t = x.table("codes", false);
            tr = t.tr();
            tr.td().b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
            for (String url : designations.keySet()) {
                tr.td().b().addText((String)designations.get(url));
            }
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
                this.addDesignationRow(c, t, langs, designations);
            }
        }
    }

    protected String describeVSLang(String lang, String displang) {
        if ("fr-CA".equals(lang)) {
            return "French (Canadian)";
        }
        ValueSet v = this.getContext().getWorker().findTxResource(ValueSet.class, "http://hl7.org/fhir/ValueSet/languages");
        if (v != null) {
            ValueSet.ConceptReferenceComponent l = null;
            for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                if (!cc.getCode().equals(lang)) continue;
                l = cc;
            }
            if (l == null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                    if (!cc.getCode().equals(lang)) continue;
                    l = cc;
                    break;
                }
                if (l == null) {
                    for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                        if (!cc.getCode().startsWith(lang + "-")) continue;
                        l = cc;
                        break;
                    }
                }
            }
            if (l != null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                String en = l.getDisplay();
                String nativelang = null;
                for (ValueSet.ConceptReferenceDesignationComponent cd : l.getDesignation()) {
                    if (!cd.getLanguage().equals(lang)) continue;
                    nativelang = cd.getValue();
                }
                return this.context.formatPhrase(this.langsMatch(lang, displang) ? "VALUE_SET_OTHER_DISPLAY" : "TX_DISPLAY_LANG", new Object[]{nativelang == null ? en : nativelang});
            }
        }
        return lang;
    }

    private boolean langsMatch(String lang, String displang) {
        if (lang == null) {
            return displang == null;
        }
        if (lang.equals(displang)) {
            return true;
        }
        if (displang == null) {
            return false;
        }
        String l1 = lang.contains("-") ? lang.substring(0, lang.indexOf("-")) : lang;
        String l2 = displang.contains("-") ? displang.substring(0, displang.indexOf("-")) : displang;
        return l1.equals(l2);
    }

    private void scanForProperties(ValueSet.ValueSetExpansionComponent exp, List<String> langs, Map<String, String> properties) {
        properties.clear();
        for (ValueSet.ValueSetExpansionPropertyComponent pp : exp.getProperty()) {
            if (!pp.hasCode() || !pp.hasUri() || !this.anyActualproperties(exp.getContains(), pp.getCode())) continue;
            properties.put(pp.getCode(), pp.getUri());
        }
    }

    private boolean anyActualproperties(List<ValueSet.ValueSetExpansionContainsComponent> contains, String pp) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            for (ValueSet.ConceptPropertyComponent cp : c.getProperty()) {
                if (!pp.equals(cp.getCode())) continue;
                return true;
            }
            if (!this.anyActualproperties(c.getContains(), pp)) continue;
            return true;
        }
        return false;
    }

    private boolean generateContentModeNotices(XhtmlNode x, ValueSet.ValueSetExpansionComponent expansion, Resource vs) {
        this.generateContentModeNotice(x, expansion, "example", this.context.formatPhrase("VALUE_SET_EXP", new Object[0]), vs);
        return this.generateContentModeNotice(x, expansion, "fragment", this.context.formatPhrase("VALUE_SET_EXP_FRAG", new Object[0]), vs);
    }

    private boolean generateContentModeNotice(XhtmlNode x, ValueSet.ValueSetExpansionComponent expansion, String mode, String text, Resource vs) {
        boolean res = false;
        HashMultimap versions = HashMultimap.create();
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            String[] parts;
            if (!p.getName().equals(mode) || (parts = ((PrimitiveType)p.getValue()).asStringValue().split("\\|")).length != 2 || Utilities.noString((String)parts[0])) continue;
            versions.put((Object)parts[0], (Object)parts[1]);
        }
        if (versions.size() > 0) {
            XhtmlNode div = null;
            XhtmlNode ul = null;
            boolean first = true;
            for (String s : versions.keySet()) {
                if (versions.size() == 1 && versions.get((Object)s).size() == 1) {
                    for (String v : versions.get((Object)s)) {
                        XhtmlNode p = x.para().style("border: black 1px dotted; background-color: #ffcccc; padding: 8px; margin-bottom: 8px");
                        p.tx(text + " ");
                        this.expRef(p, s, v, vs);
                        res = true;
                    }
                    continue;
                }
                for (String v : versions.get((Object)s)) {
                    if (first) {
                        div = x.div().style("border: black 1px dotted; background-color: #EEEEEE; padding: 8px; margin-bottom: 8px");
                        div.para().tx(text + "s: ");
                        ul = div.ul();
                        first = false;
                        res = true;
                    }
                    this.expRef(ul.li(), s, v, vs);
                }
            }
        }
        return res;
    }

    private boolean checkDoSystem(ValueSet vs, ValueSet src) {
        if (src != null) {
            vs = src;
        }
        return vs.hasCompose();
    }

    private boolean IsNotFixedExpansion(ValueSet vs) {
        if (vs.hasCompose()) {
            return false;
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            if (cc.hasValueSet()) {
                return true;
            }
            if (cc.hasVersion()) continue;
            return true;
        }
        return false;
    }

    private TerminologyRenderer.ConceptMapRenderInstructions findByTarget(DataType source) {
        if (source == null) {
            return null;
        }
        String src = source.primitiveValue();
        if (src == null) {
            return null;
        }
        for (TerminologyRenderer.ConceptMapRenderInstructions t : this.renderingMaps) {
            if (!src.equals(t.getUrl())) continue;
            return t;
        }
        return null;
    }

    private Integer countMembership(ValueSet vs) {
        int count = 0;
        if (vs.hasExpansion()) {
            count += ValueSetUtilities.countExpansion(vs);
        } else if (vs.hasCompose()) {
            if (vs.getCompose().hasExclude()) {
                try {
                    ValueSetExpansionOutcome vse = this.getContext().getWorker().expandVS(vs, true, false);
                    count = 0;
                    return count += ValueSetUtilities.countExpansion(vse.getValueset());
                }
                catch (Exception e) {
                    return null;
                }
            }
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                if (inc.hasFilter()) {
                    return null;
                }
                if (!inc.hasConcept()) {
                    return null;
                }
                count += inc.getConcept().size();
            }
        }
        return count;
    }

    private void addCSRef(XhtmlNode x, String url) {
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(url);
        if (cs == null) {
            x.code(url);
        } else if (cs.hasWebPath()) {
            x.ah(this.context.prefixLocalHref(cs.getWebPath())).tx(cs.present());
        } else {
            x.code(url);
            x.tx(" (" + cs.present() + ")");
        }
    }

    private void generateVersionNotice(XhtmlNode x, ValueSet.ValueSetExpansionComponent expansion, Resource vs) {
        HashMultimap versions = HashMultimap.create();
        HashSet<String> vlist = new HashSet<String>();
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            if (!p.getName().startsWith("used-") && !p.getName().equals("version") || vlist.contains(p.getValue().primitiveValue())) continue;
            String name = p.getName().equals("version") ? "system" : p.getName().substring(5);
            vlist.add(p.getValue().primitiveValue());
            String[] parts = ((PrimitiveType)p.getValue()).asStringValue().split("\\|");
            if (parts.length != 2 || Utilities.noString((String)parts[0])) continue;
            versions.put((Object)(name + "|" + parts[0]), (Object)parts[1]);
        }
        if (versions.size() > 0) {
            XhtmlNode div = null;
            XhtmlNode ul = null;
            boolean first = true;
            for (String s : Utilities.sorted((Collection)versions.keySet())) {
                if (versions.size() == 1 && versions.get((Object)s).size() == 1) {
                    for (String v : versions.get((Object)s)) {
                        XhtmlNode p = x.para().style("border: black 1px dotted; background-color: #EEEEEE; padding: 8px; margin-bottom: 8px");
                        if (!vs.hasUserData("VS_EXPANSION_SOURCE")) {
                            p.tx(this.context.formatPhrase("VALUE_SET_EXPANSION", new Object[0]) + " ");
                        } else if ("internal".equals(vs.getUserString("VS_EXPANSION_SOURCE"))) {
                            p.tx(this.context.formatPhrase("VALUE_SET_EXPANSION_INTERNAL", new Object[0]) + " ");
                        } else {
                            p.tx(this.context.formatPhrase("VALUE_SET_EXPANSION_SRVR", new Object[]{vs.getUserString("VS_EXPANSION_SOURCE")}) + " ");
                        }
                        this.expRef(p, s, v, vs);
                    }
                    continue;
                }
                for (String v : versions.get((Object)s)) {
                    if (first) {
                        div = x.div().style("border: black 1px dotted; background-color: #EEEEEE; padding: 8px; margin-bottom: 8px");
                        if (!vs.hasUserData("VS_EXPANSION_SOURCE")) {
                            div.para().tx(this.context.formatPhrase("VALUE_SET_EXPANSIONS", new Object[0]));
                        } else if ("internal".equals(vs.getUserString("VS_EXPANSION_SOURCE"))) {
                            div.para().tx(this.context.formatPhrase("VALUE_SET_EXPANSIONS_INTERNAL", new Object[0]));
                        } else {
                            div.para().tx(this.context.formatPhrase("VALUE_SET_EXPANSIONS_SRVR", new Object[]{vs.getUserString("VS_EXPANSION_SOURCE")}));
                        }
                        ul = div.ul();
                        first = false;
                    }
                    this.expRef(ul.li(), s, v, vs);
                }
            }
        }
    }

    private String findParamValue(List<ValueSet.ValueSetExpansionParameterComponent> list, String name) {
        for (ValueSet.ValueSetExpansionParameterComponent p : list) {
            if (!name.equals(p.getName())) continue;
            return p.getValue().primitiveValue();
        }
        return null;
    }

    private void expRef(XhtmlNode x, String u, String v, Resource source) {
        String t = u.contains("|") ? u.substring(0, u.indexOf("|")) : u;
        if ((u = u.substring(u.indexOf("|") + 1)).equals("http://snomed.info/sct")) {
            String[] parts = v.split("\\/");
            if (parts.length >= 5) {
                String m = this.describeModule(parts[4]);
                if (parts.length == 7) {
                    x.tx(this.context.formatPhrase("VALUE_SET_SNOMED_ADD", new Object[]{m, this.formatSCTDate(parts[6])}));
                } else {
                    x.tx(this.context.formatPhrase("VALUE_SET_SNOMED", new Object[]{m}));
                }
            } else {
                x.tx(this.displaySystem(u) + " " + this.context.formatPhrase("GENERAL_VER_LOW", new Object[0]) + " " + v);
            }
        } else if (u.equals("http://loinc.org")) {
            String vd = this.describeLoincVer(v);
            if (vd != null) {
                x.tx(this.context.formatPhrase("VALUE_SET_LOINCV", new Object[0]) + v + " (" + vd + ")");
            } else {
                x.tx(this.context.formatPhrase("VALUE_SET_LOINCV", new Object[0]) + v);
            }
        } else if (Utilities.noString((String)v)) {
            CanonicalResource cr = (CanonicalResource)this.getContext().getWorker().fetchResource(Resource.class, u, source);
            if (cr != null) {
                if (cr.hasWebPath()) {
                    x.ah(this.context.prefixLocalHref(cr.getWebPath())).tx(t + " " + cr.present() + " " + this.context.formatPhrase("VALUE_SET_NO_VERSION", new Object[0]) + cr.fhirType() + ")");
                } else {
                    x.tx(t + " " + this.displaySystem(u) + " " + this.context.formatPhrase("VALUE_SET_NO_VERSION", new Object[0]) + cr.fhirType() + ")");
                }
            } else {
                x.tx(t + " " + this.displaySystem(u) + " " + this.context.formatPhrase("VALUE_SET_NO_VER", new Object[0]));
            }
        } else {
            CanonicalResource cr = (CanonicalResource)this.getContext().getWorker().fetchResource(Resource.class, u + "|" + v, source);
            if (cr != null) {
                if (cr.hasWebPath()) {
                    x.ah(this.context.prefixLocalHref(cr.getWebPath())).tx(t + " " + cr.present() + " v" + v + " (" + cr.fhirType() + ")");
                } else {
                    x.tx(t + " " + this.displaySystem(u) + " v" + v + " (" + cr.fhirType() + ")");
                }
            } else {
                x.tx(t + " " + this.displaySystem(u) + " " + this.context.formatPhrase("GENERAL_VER_LOW", new Object[0]) + v);
            }
        }
    }

    private String describeLoincVer(String v) {
        if ("2.67".equals(v)) {
            return "Dec 2019";
        }
        if ("2.66".equals(v)) {
            return "Jun 2019";
        }
        if ("2.65".equals(v)) {
            return "Dec 2018";
        }
        if ("2.64".equals(v)) {
            return "Jun 2018";
        }
        if ("2.63".equals(v)) {
            return "Dec 2017";
        }
        if ("2.61".equals(v)) {
            return "Jun 2017";
        }
        if ("2.59".equals(v)) {
            return "Feb 2017";
        }
        if ("2.58".equals(v)) {
            return "Dec 2016";
        }
        if ("2.56".equals(v)) {
            return "Jun 2016";
        }
        if ("2.54".equals(v)) {
            return "Dec 2015";
        }
        if ("2.52".equals(v)) {
            return "Jun 2015";
        }
        if ("2.50".equals(v)) {
            return "Dec 2014";
        }
        if ("2.48".equals(v)) {
            return "Jun 2014";
        }
        if ("2.46".equals(v)) {
            return "Dec 2013";
        }
        if ("2.44".equals(v)) {
            return "Jun 2013";
        }
        if ("2.42".equals(v)) {
            return "Dec 2012";
        }
        if ("2.40".equals(v)) {
            return "Jun 2012";
        }
        if ("2.38".equals(v)) {
            return "Dec 2011";
        }
        if ("2.36".equals(v)) {
            return "Jun 2011";
        }
        if ("2.34".equals(v)) {
            return "Dec 2010";
        }
        if ("2.32".equals(v)) {
            return "Jun 2010";
        }
        if ("2.30".equals(v)) {
            return "Feb 2010";
        }
        if ("2.29".equals(v)) {
            return "Dec 2009";
        }
        if ("2.27".equals(v)) {
            return "Jul 2009";
        }
        if ("2.26".equals(v)) {
            return "Jan 2009";
        }
        if ("2.24".equals(v)) {
            return "Jul 2008";
        }
        if ("2.22".equals(v)) {
            return "Dec 2007";
        }
        if ("2.21".equals(v)) {
            return "Jun 2007";
        }
        if ("2.19".equals(v)) {
            return "Dec 2006";
        }
        if ("2.17".equals(v)) {
            return "Jun 2006";
        }
        if ("2.16".equals(v)) {
            return "Dec 2005";
        }
        if ("2.15".equals(v)) {
            return "Jun 2005";
        }
        if ("2.14".equals(v)) {
            return "Dec 2004";
        }
        if ("2.13".equals(v)) {
            return "Aug 2004";
        }
        if ("2.12".equals(v)) {
            return "Feb 2004";
        }
        if ("2.10".equals(v)) {
            return "Oct 2003";
        }
        if ("2.09".equals(v)) {
            return "May 2003";
        }
        if ("2.08 ".equals(v)) {
            return "Sep 2002";
        }
        if ("2.07".equals(v)) {
            return "Aug 2002";
        }
        if ("2.05".equals(v)) {
            return "Feb 2002";
        }
        if ("2.04".equals(v)) {
            return "Jan 2002";
        }
        if ("2.03".equals(v)) {
            return "Jul 2001";
        }
        if ("2.02".equals(v)) {
            return "May 2001";
        }
        if ("2.01".equals(v)) {
            return "Jan 2001";
        }
        if ("2.00".equals(v)) {
            return "Jan 2001";
        }
        if ("1.0n".equals(v)) {
            return "Feb 2000";
        }
        if ("1.0ma".equals(v)) {
            return "Aug 1999";
        }
        if ("1.0m".equals(v)) {
            return "Jul 1999";
        }
        if ("1.0l".equals(v)) {
            return "Jan 1998";
        }
        if ("1.0ja".equals(v)) {
            return "Oct 1997";
        }
        return null;
    }

    private String formatSCTDate(String ds) {
        Date date;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            date = format.parse(ds);
        }
        catch (ParseException e) {
            return ds;
        }
        return new SimpleDateFormat("dd-MMM yyyy").format(date);
    }

    private String describeModule(String module) {
        switch (module) {
            case "900000000000207008": {
                return this.context.formatPhrase("VALUE_SET_INT", new Object[0]);
            }
            case "449081005": {
                return this.context.formatPhrase("VALUE_SET_SPAN", new Object[0]);
            }
            case "11000221109": {
                return this.context.formatPhrase("VALUE_SET_AR", new Object[0]);
            }
            case "32506021000036107": {
                return this.context.formatPhrase("VALUE_SET_AUS", new Object[0]);
            }
            case "11000234105": {
                return this.context.formatPhrase("VALUE_SET_AT", new Object[0]);
            }
            case "11000172109": {
                return this.context.formatPhrase("VALUE_SET_BE", new Object[0]);
            }
            case "20621000087109": {
                return this.context.formatPhrase("VALUE_SET_CA_EN", new Object[0]);
            }
            case "20611000087101": {
                return this.context.formatPhrase("VALUE_SET_CA", new Object[0]);
            }
            case "554471000005108": {
                return this.context.formatPhrase("VALUE_SET_DANISH", new Object[0]);
            }
            case "11000181102 ": {
                return this.context.formatPhrase("VALUE_SET_EE", new Object[0]);
            }
            case "11000229106": {
                return this.context.formatPhrase("VALUE_SET_FI", new Object[0]);
            }
            case "11000274103": {
                return this.context.formatPhrase("VALUE_SET_DE", new Object[0]);
            }
            case "1121000189102": {
                return this.context.formatPhrase("VALUE_SET_IN", new Object[0]);
            }
            case "11000220105": {
                return this.context.formatPhrase("VALUE_SET_IE", new Object[0]);
            }
            case "11000146104": {
                return this.context.formatPhrase("VALUE_SET_DUTCH", new Object[0]);
            }
            case "21000210109": {
                return this.context.formatPhrase("VALUE_SET_NZ", new Object[0]);
            }
            case "51000202101 ": {
                return this.context.formatPhrase("VALUE_SET_NO", new Object[0]);
            }
            case "11000267109": {
                return this.context.formatPhrase("VALUE_SET_KR", new Object[0]);
            }
            case "900000001000122104": {
                return this.context.formatPhrase("VALUE_ES_ES", new Object[0]);
            }
            case "45991000052106": {
                return this.context.formatPhrase("VALUE_SET_SWEDISH", new Object[0]);
            }
            case "2011000195101": {
                return this.context.formatPhrase("VALUE_SET_CH", new Object[0]);
            }
            case "83821000000107": {
                return this.context.formatPhrase("VALUE_SET_UK", new Object[0]);
            }
            case "999000021000000109": {
                return this.context.formatPhrase("VALUE_SET_UK_CLIN", new Object[0]);
            }
            case "5631000179106": {
                return this.context.formatPhrase("VALUE_SET_UY", new Object[0]);
            }
            case "731000124108": {
                return this.context.formatPhrase("VALUE_SET_US", new Object[0]);
            }
            case "5991000124107": {
                return this.context.formatPhrase("VALUE_SET_US_ICD10CM", new Object[0]);
            }
        }
        return module;
    }

    private boolean hasVersionParameter(ValueSet.ValueSetExpansionComponent expansion) {
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            if (!p.getName().equals("version")) continue;
            return true;
        }
        return false;
    }

    private void addDesignationRow(ValueSet.ValueSetExpansionContainsComponent c, XhtmlNode t, List<String> langs, Map<String, String> designations) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        this.addDesignationsToRow(c, designations, tr);
        this.addLangaugesToRow(c, langs, tr);
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addDesignationRow(cc, t, langs, designations);
        }
    }

    public void addDesignationsToRow(ValueSet.ValueSetExpansionContainsComponent c, Map<String, String> designations, XhtmlNode tr) {
        for (String url : designations.keySet()) {
            String d = null;
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    if (!url.equals(this.getUrlForDesignation(dd))) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    public void addLangaugesToRow(ValueSet.ValueSetExpansionContainsComponent c, List<String> langs, XhtmlNode tr) {
        for (String lang : langs) {
            String l;
            String d = null;
            for (Extension ext : c.getExtension()) {
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || !lang.equals(l = ExtensionUtilities.readStringExtension((Element)ext, "lang"))) continue;
                d = ExtensionUtilities.readStringExtension((Element)ext, "content");
            }
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    l = dd.getLanguage();
                    if (!lang.equals(l)) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    private boolean checkDoDefinition(List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            CodeSystem.ConceptDefinitionComponent cd;
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(c.getSystem());
            if (cs != null && (cd = CodeSystemUtilities.getCode(cs, c.getCode())) != null && cd.hasDefinition()) {
                return true;
            }
            if (!this.checkDoDefinition(c.getContains())) continue;
            return true;
        }
        return false;
    }

    private boolean checkDoInactive(List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            if (c.hasInactive()) {
                return true;
            }
            if (!this.checkDoInactive(c.getContains())) continue;
            return true;
        }
        return false;
    }

    private boolean allFromOneSystem(ValueSet vs) {
        if (vs.getExpansion().getContains().isEmpty()) {
            return false;
        }
        String system = vs.getExpansion().getContains().get(0).getSystem();
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            if (this.checkSystemMatches(system, cc)) continue;
            return false;
        }
        return true;
    }

    private String getCsRef(String system) {
        CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(system);
        return this.getCsRef(cs);
    }

    private <T extends Resource> String getCsRef(T cs) {
        if (cs == null) {
            return "?cs-n?";
        }
        String ref = cs.getWebPath();
        if (ref == null) {
            ref = cs.getUserString("filename");
        }
        return ref == null ? null : ref.replace("\\", "/");
    }

    private void scanForDesignations(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent c, List<String> langs, Map<String, String> designations) {
        String lang;
        for (Extension ext : c.getExtension()) {
            if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || Utilities.noString((String)(lang = ExtensionUtilities.readStringExtension((Element)ext, "lang"))) || langs.contains(lang) || this.isBaseLang(vs, lang)) continue;
            langs.add(lang);
        }
        if (this.context.getDesignationMode() != RenderingContext.DesignationMode.NONE) {
            for (ValueSet.ConceptReferenceDesignationComponent d : c.getDesignation()) {
                lang = d.getLanguage();
                if (!Utilities.noString((String)lang)) {
                    if (langs.contains(lang)) continue;
                    langs.add(lang);
                    continue;
                }
                if (this.context.getDesignationMode() != RenderingContext.DesignationMode.ALL) continue;
                String disp = this.getDisplayForDesignation(d);
                String url = this.getUrlForDesignation(d);
                if (disp == null) {
                    disp = this.getDisplayForUrl(url);
                }
                if (disp == null || designations.containsKey(url) || url == null) continue;
                designations.put(url, disp);
            }
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.scanForDesignations(vs, cc, langs, designations);
        }
    }

    private boolean isBaseLang(ValueSet vs, String lang) {
        return this.isDefLang(lang) && this.isDefLang(vs.getLanguage()) || this.langsMatch(lang, vs.getLanguage());
    }

    private boolean isDefLang(String lang) {
        return lang == null || "en".equals(lang) || "en-US".equals(lang);
    }

    private void scanForLangs(ValueSet.ValueSetExpansionContainsComponent c, List<String> langs) {
        String lang;
        for (Extension ext : c.getExtension()) {
            if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || Utilities.noString((String)(lang = ExtensionUtilities.readStringExtension((Element)ext, "lang"))) || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (ValueSet.ConceptReferenceDesignationComponent d : c.getDesignation()) {
            lang = d.getLanguage();
            if (Utilities.noString((String)lang) || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.scanForLangs(cc, langs);
        }
    }

    private void addExpansionRowToTable(XhtmlNode t, ValueSet vs, ValueSet.ValueSetExpansionContainsComponent c, int i, boolean doLevel, boolean doDefinition, boolean doInactive, List<TerminologyRenderer.UsedConceptMap> maps, List<String> langs, Map<String, String> designations, boolean doDesignations, Map<String, String> properties, ResourceWrapper res) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode tr = t.tr();
        if (ValueSetUtilities.isDeprecated(vs, c)) {
            tr.setAttribute("style", "background-color: #ffeeee");
        }
        XhtmlNode td = tr.td();
        String tgt = this.makeAnchor(c.getSystem(), c.getCode());
        String pfx = res.getScopedId();
        td.an(this.context.prefixAnchor((String)(pfx == null ? "" : pfx + "-")) + tgt);
        if (doLevel) {
            td.addText(Integer.toString(i));
            td = tr.td();
        }
        String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)(i * 2));
        td.attribute("style", "white-space:nowrap").addText(s);
        this.addCodeToTable(c.getAbstract(), c.getSystem(), c.getVersion(), c.getCode(), c.getDisplay(), td);
        td = tr.td();
        if (this.context.isOids()) {
            td.addText(this.getOid(c.getSystem()));
        } else {
            td.addText(c.getSystem());
        }
        td = tr.td();
        if (c.hasDisplayElement()) {
            td.addText(c.getDisplay());
        }
        if (doInactive) {
            td = tr.td();
            if (c.getInactive()) {
                td.tx(this.context.formatPhrase("VALUE_SET_INACT", new Object[0]));
            }
        }
        if (doDefinition) {
            td = tr.td();
            CodeSystem cs = this.getContext().getWorker().fetchCodeSystem(c.getSystem());
            if (cs != null) {
                String defn = CodeSystemUtilities.getCodeDefinition(cs, c.getCode());
                if (this.hasMarkdownInDefinitions(cs)) {
                    this.addMarkdown(td, defn, cs.getWebPath());
                } else {
                    td.tx(defn);
                }
            }
        }
        for (String n : Utilities.sorted(properties.keySet())) {
            td = tr.td();
            String ps = this.getPropertyValue(c, n);
            if (Utilities.noString((String)ps)) continue;
            td.addText(ps);
        }
        for (TerminologyRenderer.UsedConceptMap m : maps) {
            td = tr.td();
            List<TerminologyRenderer.TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), m.getMap());
            boolean first = true;
            for (TerminologyRenderer.TargetElementComponentWrapper mapping : mappings) {
                if (!first) {
                    td.br();
                }
                first = false;
                XhtmlNode span = td.span(null, mapping.comp.getRelationship().toString());
                span.addText(this.getCharForRelationship(mapping.comp));
                this.addRefToCode(td, mapping.group.getTarget(), null, m.getLink(), mapping.comp.getCode());
                if (Utilities.noString((String)mapping.comp.getComment())) continue;
                td.i().tx("(" + mapping.comp.getComment() + ")");
            }
        }
        if (doDesignations) {
            this.addDesignationsToRow(c, designations, tr);
            this.addLangaugesToRow(c, langs, tr);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addExpansionRowToTable(t, vs, cc, i + 1, doLevel, doDefinition, doInactive, maps, langs, designations, doDesignations, properties, res);
        }
    }

    private boolean hasMarkdownInDefinitions(CodeSystem cs) {
        if (!cs.hasUserData("CS_MARKDOWN_FLAG")) {
            if (cs.hasExtension("http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown")) {
                cs.setUserData("CS_MARKDOWN_FLAG", ExtensionUtilities.readBoolExtension((DomainResource)cs, "http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown"));
            } else {
                cs.setUserData("CS_MARKDOWN_FLAG", CodeSystemUtilities.hasMarkdownInDefinitions(cs, this.context.getMarkdown()));
            }
        }
        return (Boolean)cs.getUserData("CS_MARKDOWN_FLAG");
    }

    private String getOid(String system) {
        String oid;
        if (this.oidMap == null) {
            this.oidMap = new HashMap<String, String>();
        }
        if ((oid = this.oidMap.get(system)) == null) {
            CodeSystem cs = this.context.getContext().fetchCodeSystem(system);
            if (cs != null) {
                oid = CodeSystemUtilities.getOID(cs);
            }
            if (oid == null) {
                oid = system;
            }
            this.oidMap.put(system, oid);
        }
        return oid;
    }

    private String getPropertyValue(ValueSet.ValueSetExpansionContainsComponent c, String n) {
        for (ValueSet.ConceptPropertyComponent cp : c.getProperty()) {
            if (!n.equals(cp.getCode())) continue;
            return cp.getValue().primitiveValue();
        }
        return null;
    }

    private boolean checkSystemMatches(String system, ValueSet.ValueSetExpansionContainsComponent cc) {
        if (!system.equals(cc.getSystem())) {
            return false;
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : cc.getContains()) {
            if (this.checkSystemMatches(system, cc1)) continue;
            return false;
        }
        return true;
    }

    private void addCodeToTable(boolean isAbstract, String system, String version, String code, String display, XhtmlNode td) {
        CodeSystem e = this.getContext().getWorker().fetchCodeSystem(system);
        if (e == null || e.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && e.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT) {
            if (isAbstract) {
                td.i().setAttribute("title", this.context.formatPhrase("VS_ABSTRACT_CODE_HINT", new Object[0])).addText(code);
            } else if ("http://snomed.info/sct".equals(system)) {
                td.ah(this.context.prefixLocalHref(SnomedUtilities.getSctLink(version, code, this.context.getContext().getExpansionParameters()))).addText(code);
            } else if ("http://loinc.org".equals(system)) {
                td.ah(this.context.prefixLocalHref(LoincLinker.getLinkForCode((String)code))).addText(code);
            } else {
                td.addText(code);
            }
        } else {
            Object href = this.context.fixReference(this.getCsRef(e));
            if (href == null) {
                td.code().tx(code);
            } else {
                href = ((String)href).contains("#") ? (String)href + "-" + Utilities.nmtokenize((String)code) : (String)href + "#" + e.getId() + "-" + Utilities.nmtokenize((String)code);
                if (isAbstract) {
                    td.ah(this.context.prefixLocalHref((String)href)).setAttribute("title", this.context.formatPhrase("VS_ABSTRACT_CODE_HINT", new Object[0])).i().addText(code);
                } else {
                    td.ah(this.context.prefixLocalHref((String)href)).addText(code);
                }
            }
        }
    }

    private void addRefToCode(XhtmlNode td, String target, String vslink, String code, String version) {
        this.addCodeToTable(false, target, version, code, null, td);
    }

    private void generateComposition(Renderer.RenderingStatus status, ResourceWrapper res, XhtmlNode x, ValueSet vs, boolean header, List<TerminologyRenderer.UsedConceptMap> maps) throws FHIRException, IOException {
        boolean doDesignations;
        ArrayList<String> langs = new ArrayList<String>();
        HashMap<String, String> designations = new HashMap<String, String>();
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.scanDesignations(inc, langs, designations);
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            this.scanDesignations(inc, langs, designations);
        }
        boolean bl = doDesignations = langs.size() + designations.size() < 5;
        if (header) {
            XhtmlNode h = x.h2();
            h.addText(vs.present());
            this.addMarkdown(x, vs.getDescription());
            if (vs.hasCopyrightElement()) {
                this.generateCopyright(x, res);
            }
        }
        int index = 0;
        if (vs.getCompose().getInclude().size() == 1 && vs.getCompose().getExclude().size() == 0 && !VersionComparisonAnnotation.hasDeleted(vs.getCompose(), "include", "exclude")) {
            this.genInclude(status, x.ul(), vs.getCompose().getInclude().get(0), "Include", langs, doDesignations, maps, designations, index, vs);
        } else {
            XhtmlNode p = x.para();
            p.tx(this.context.formatPhrase("VALUE_SET_RULES_INC", new Object[0]));
            XhtmlNode ul = x.ul();
            for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getInclude()) {
                this.genInclude(status, ul, conceptSetComponent, this.context.formatPhrase("VALUE_SET_INC", new Object[0]), langs, doDesignations, maps, designations, index, vs);
                ++index;
            }
            for (Base base : VersionComparisonAnnotation.getDeleted(vs.getCompose(), "include")) {
                this.genInclude(status, ul, (ValueSet.ConceptSetComponent)base, this.context.formatPhrase("VALUE_SET_INC", new Object[0]), langs, doDesignations, maps, designations, index, vs);
                ++index;
            }
            if (vs.getCompose().hasExclude() || VersionComparisonAnnotation.hasDeleted(vs.getCompose(), "exclude")) {
                p = x.para();
                p.tx(this.context.formatPhrase("VALUE_SET_RULES_EXC", new Object[0]));
                ul = x.ul();
                for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getExclude()) {
                    this.genInclude(status, ul, conceptSetComponent, this.context.formatPhrase("VALUE_SET_EXCL", new Object[0]), langs, doDesignations, maps, designations, index, vs);
                    ++index;
                }
                for (Base base : VersionComparisonAnnotation.getDeleted(vs.getCompose(), "exclude")) {
                    this.genInclude(status, ul, (ValueSet.ConceptSetComponent)base, this.context.formatPhrase("VALUE_SET_EXCL", new Object[0]), langs, doDesignations, maps, designations, index, vs);
                    ++index;
                }
            }
        }
        if (!doDesignations && langs.size() + designations.size() > 0) {
            Collections.sort(langs);
            if (designations.size() == 0) {
                x.para().b().tx(this.context.formatPhrase("GENERAL_ADD_LANG", new Object[0]));
            } else if (langs.size() == 0) {
                x.para().b().tx(this.context.formatPhrase("VALUE_SET_DESIG", new Object[0]));
            } else {
                x.para().b().tx(this.context.formatPhrase("VALUE_SET_ADD_DESIG", new Object[0]));
            }
            XhtmlNode t = x.table("codes", false);
            XhtmlNode tr = t.tr();
            tr.td().b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
            for (String string : designations.keySet()) {
                tr.td().b().addText((String)designations.get(string));
            }
            for (String string : langs) {
                tr.td().b().addText(this.describeLang(string));
            }
            for (ValueSet.ConceptSetComponent conceptSetComponent : vs.getCompose().getInclude()) {
                for (ValueSet.ConceptReferenceComponent cc : conceptSetComponent.getConcept()) {
                    this.addDesignationRow(cc, t, langs, designations);
                }
            }
        }
    }

    private void renderExpansionRules(XhtmlNode x, ValueSet.ConceptSetComponent inc, int index, Map<String, CodeSystem.ConceptDefinitionComponent> definitions) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        String rule;
        String s = this.context.formatPhrase("VALUE_SET_NOT_DEF", new Object[0]);
        if (inc.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-expand-rules") && (rule = inc.getExtensionString("http://hl7.org/fhir/StructureDefinition/valueset-expand-rules")) != null) {
            switch (rule) {
                case "all-codes": {
                    s = this.context.formatPhrase("VALUE_SET_ALL_CODE", new Object[0]);
                }
                case "ungrouped": {
                    s = this.context.formatPhrase("VALUE_SET_NOT_FOUND", new Object[0]);
                }
                case "groups-only": {
                    s = this.context.formatPhrase("VALUE_SET_CONT_STRUC", new Object[0]);
                }
            }
        }
        x.br();
        x.tx(s);
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator((RenderingI18nContext)this.context, this.context.getDestDir(), this.context.isInlineGraphics(), true, "exp");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "exp.h=" + index, this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER);
        model.setAlternating(true);
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), this.context.formatPhrase("GENERAL_CODE", new Object[0]), this.context.formatPhrase("VALUE_SET_CODE_ITEM", new Object[0]), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), this.context.formatPhrase("TX_DISPLAY", new Object[0]), this.context.formatPhrase("VALUE_SET_DISPLAY_ITEM", new Object[0]), null, 0));
        for (Extension ext : inc.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-expand-group")) {
            this.renderExpandGroup(gen, model, ext, inc, definitions);
        }
        x.br();
        x.tx("table");
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.addChildNode(xn);
    }

    private void renderExpandGroup(HierarchicalTableGenerator gen, HierarchicalTableGenerator.TableModel model, Extension ext, ValueSet.ConceptSetComponent inc, Map<String, CodeSystem.ConceptDefinitionComponent> definitions) {
        HierarchicalTableGenerator.Row row = new HierarchicalTableGenerator.Row(gen);
        model.getRows().add(row);
        row.setIcon("icon_entry_blue.png", "entry");
        String code = ext.getExtensionString("code");
        if (code != null) {
            List list = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, code, null, null));
            List list2 = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, this.getDisplayForCode(inc, code, definitions), null, null));
        } else if (ext.hasId()) {
            List list = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "(#" + ext.getId() + ")", null, null));
            List list3 = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, ext.getExtensionString("display"), null, null));
        } else {
            List list = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, null, null, null));
            List list4 = row.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, ext.getExtensionString("display"), null, null));
        }
        for (Extension member : ext.getExtensionsByUrl("member")) {
            HierarchicalTableGenerator.Row subRow = new HierarchicalTableGenerator.Row(gen);
            row.getSubRows().add(subRow);
            subRow.setIcon("icon_entry_blue.png", "entry");
            String mc = member.getValue().primitiveValue();
            if (mc.startsWith("#")) {
                List list = subRow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "(" + mc + ")", null, null));
                List list5 = subRow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator5);
                list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, "group reference by id", null, null));
                continue;
            }
            Extension tgt = this.findTargetByCode(inc, mc);
            if (tgt != null) {
                List list = subRow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator = gen;
                Objects.requireNonNull(hierarchicalTableGenerator);
                list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, mc, null, null));
                List list6 = subRow.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, "group reference by code", null, null));
                continue;
            }
            List list = subRow.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, mc, null, null));
            List list7 = subRow.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator7);
            list7.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator7, null, null, this.getDisplayForCode(inc, mc, definitions), null, null));
        }
    }

    private Extension findTargetByCode(ValueSet.ConceptSetComponent inc, String mc) {
        for (Extension ext : inc.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-expand-group")) {
            String code = ext.getExtensionString("code");
            if (!mc.equals(code)) continue;
            return ext;
        }
        return null;
    }

    private String getDisplayForCode(ValueSet.ConceptSetComponent inc, String code, Map<String, CodeSystem.ConceptDefinitionComponent> definitions) {
        for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
            if (!code.equals(cc.getCode()) || !cc.hasDisplay()) continue;
            return cc.getDisplay();
        }
        if (definitions.containsKey(code)) {
            return definitions.get(code).getDisplay();
        }
        return null;
    }

    private void scanDesignations(ValueSet.ConceptSetComponent inc, List<String> langs, Map<String, String> designations) {
        for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
            String lang;
            for (Extension ext : cc.getExtension()) {
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || Utilities.noString((String)(lang = ExtensionUtilities.readStringExtension((Element)ext, "lang"))) || langs.contains(lang)) continue;
                langs.add(lang);
            }
            for (ValueSet.ConceptReferenceDesignationComponent d : cc.getDesignation()) {
                lang = d.getLanguage();
                if (!Utilities.noString((String)lang) && !langs.contains(lang)) {
                    langs.add(lang);
                    continue;
                }
                String disp = this.getDisplayForDesignation(d);
                String url = this.getUrlForDesignation(d);
                if (disp == null) {
                    disp = this.getDisplayForUrl(url);
                }
                if (disp == null || designations.containsKey(url)) continue;
                designations.put(url, disp);
            }
        }
    }

    private String getDisplayForUrl(String url) {
        if (url == null) {
            return null;
        }
        switch (url) {
            case "http://snomed.info/sct#900000000000003001": {
                return this.context.formatPhrase("VALUE_SET_SPEC_NAME", new Object[0]);
            }
            case "http://snomed.info/sct#900000000000013009": {
                return this.context.formatPhrase("VALUE_SET_SYNONYM", new Object[0]);
            }
            case "http://terminology.hl7.org/CodeSystem/designation-usage#display": {
                return this.context.formatPhrase("VALUE_SET_OTHER_DISPLAY", new Object[0]);
            }
            case "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra#preferredForLanguage": {
                return this.context.formatPhrase("VALUE_SET_OTHER_DISPLAY", new Object[0]);
            }
        }
        return url;
    }

    private String getUrlForDesignation(ValueSet.ConceptReferenceDesignationComponent d) {
        if (d.hasUse() && d.getUse().hasSystem() && d.getUse().hasCode()) {
            return d.getUse().getSystem() + "#" + d.getUse().getCode();
        }
        return null;
    }

    private String getDisplayForDesignation(ValueSet.ConceptReferenceDesignationComponent d) {
        if (d.hasUse() && d.getUse().hasDisplay()) {
            return d.getUse().getDisplay();
        }
        return null;
    }

    private void genInclude(Renderer.RenderingStatus status, XhtmlNode ul, ValueSet.ConceptSetComponent inc, String type, List<String> langs, boolean doDesignations, List<TerminologyRenderer.UsedConceptMap> maps, Map<String, String> designations, int index, ValueSet vsRes) throws FHIRException, IOException {
        block36: {
            XhtmlNode li;
            block35: {
                li = ul.li();
                li = this.renderStatus(inc, li);
                Map<String, CodeSystem.ConceptDefinitionComponent> definitions = new HashMap<String, CodeSystem.ConceptDefinitionComponent>();
                if (!inc.hasSystem()) break block35;
                CodeSystem e = this.getContext().getWorker().fetchCodeSystem(inc.getSystem());
                if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
                    li.addText(type + " " + this.context.formatPhrase("VALUE_SET_ALL_CODES_DEF", new Object[0]) + " ");
                    this.addCsRef(inc, li, e);
                } else {
                    if (inc.getConcept().size() > 0) {
                        boolean bl;
                        boolean bl2;
                        li.addText(type + " " + this.context.formatPhrase("VALUE_SET_THESE_CODES_DEF", new Object[0]) + " ");
                        this.addCsRef(inc, li, e);
                        if (inc.hasVersion()) {
                            li.addText(" " + this.context.formatPhrase("GENERAL_VER_LOW", new Object[0]) + " ");
                            li.code(inc.getVersion());
                        }
                        definitions = this.getConceptsForCodes(e, inc, vsRes, index);
                        XhtmlNode t = li.table("none", false);
                        boolean bl3 = false;
                        boolean bl4 = false;
                        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                            bl2 = bl2 || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments");
                            CodeSystem.ConceptDefinitionComponent cc = definitions == null ? null : definitions.get(c.getCode());
                            bl = bl || cc != null && cc.hasDefinition() || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition");
                        }
                        if (bl2 || bl) {
                            status.setExtensions(true);
                        }
                        this.addMapHeaders(this.addTableHeaderRowStandard(t, false, true, bl, bl2, false, false, null, langs, designations, doDesignations), maps);
                        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                            this.renderConcept(inc, langs, doDesignations, maps, designations, definitions, t, bl2, bl, c, inc.getVersion());
                        }
                        for (Base b : VersionComparisonAnnotation.getDeleted(inc, "concept")) {
                            this.renderConcept(inc, langs, doDesignations, maps, designations, definitions, t, bl2, bl, (ValueSet.ConceptReferenceComponent)b, inc.getVersion());
                        }
                    }
                    if (inc.getFilter().size() > 0) {
                        li.addText(type + " " + this.context.formatPhrase("VALUE_SET_CODES_FROM", new Object[0]));
                        this.addCsRef(inc, li, e);
                        li.tx(" " + this.context.formatPhrase("VALUE_SET_WHERE", new Object[0]) + " ");
                        for (int i = 0; i < inc.getFilter().size(); ++i) {
                            ValueSet.ConceptSetFilterComponent conceptSetFilterComponent = inc.getFilter().get(i);
                            if (i > 0) {
                                if (i == inc.getFilter().size() - 1) {
                                    li.tx(" " + this.context.formatPhrase("VALUE_SET_AND", new Object[0]) + " ");
                                } else {
                                    li.tx(this.context.formatPhrase("VALUE_SET_COMMA", new Object[0]) + " ");
                                }
                            }
                            XhtmlNode xhtmlNode = this.renderStatus(conceptSetFilterComponent, li);
                            if (conceptSetFilterComponent.getOp() == Enumerations.FilterOperator.EXISTS) {
                                if (conceptSetFilterComponent.getValue().equals("true")) {
                                    xhtmlNode.tx(conceptSetFilterComponent.getProperty() + " " + this.context.formatPhrase("VALUE_SET_EXISTS", new Object[0]));
                                    continue;
                                }
                                xhtmlNode.tx(conceptSetFilterComponent.getProperty() + " " + this.context.formatPhrase("VALUE_SET_DOESNT_EXIST", new Object[0]));
                                continue;
                            }
                            xhtmlNode.tx(conceptSetFilterComponent.getProperty() + " " + this.describe(conceptSetFilterComponent.getOp()) + " ");
                            if (conceptSetFilterComponent.getValueElement().hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-expression")) {
                                Extension expE = conceptSetFilterComponent.getValueElement().getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-expression");
                                Expression exp = expE.getValueExpression();
                                xhtmlNode.addText("(as calculated by ");
                                xhtmlNode.code().tx(exp.getExpression());
                                xhtmlNode.addText(")");
                            } else if (e != null && this.codeExistsInValueSet(e, conceptSetFilterComponent.getValue())) {
                                Object href = this.getContext().fixReference(this.getCsRef(e));
                                if (href == null) {
                                    xhtmlNode.code().tx(conceptSetFilterComponent.getValue());
                                } else {
                                    href = ((String)href).contains("#") ? (String)href + "-" + Utilities.nmtokenize((String)conceptSetFilterComponent.getValue()) : (String)href + "#" + e.getId() + "-" + Utilities.nmtokenize((String)conceptSetFilterComponent.getValue());
                                    xhtmlNode.ah(this.context.prefixLocalHref((String)href)).addText(conceptSetFilterComponent.getValue());
                                }
                            } else if (inc.hasSystem()) {
                                xhtmlNode.addText(conceptSetFilterComponent.getValue());
                                ValidationResult vr = this.getContext().getWorker().validateCode(this.getContext().getTerminologyServiceOptions(), inc.getSystem(), inc.getVersion(), conceptSetFilterComponent.getValue(), null);
                                if (vr.isOk() && vr.getDisplay() != null) {
                                    xhtmlNode.tx(" (" + vr.getDisplay() + ")");
                                }
                            } else {
                                xhtmlNode.addText(conceptSetFilterComponent.getValue());
                            }
                            String disp = ExtensionUtilities.getDisplayHint(conceptSetFilterComponent);
                            if (disp == null) continue;
                            xhtmlNode.tx(" (" + disp + ")");
                        }
                    }
                }
                if (inc.hasValueSet()) {
                    li.tx(this.context.formatPhrase("VALUE_SET_WHERE_CODES", new Object[0]) + " ");
                    boolean first = true;
                    for (UriType uriType : inc.getValueSet()) {
                        if (first) {
                            first = false;
                        } else {
                            li.tx(", ");
                        }
                        XhtmlNode wli = this.renderStatus(uriType, li);
                        this.AddVsRef(uriType.asStringValue(), wli, vsRes);
                    }
                }
                if (!inc.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-expand-rules") && !inc.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-expand-group")) break block36;
                status.setExtensions(true);
                this.renderExpansionRules(li, inc, index, definitions);
                break block36;
            }
            li.tx(this.context.formatMessagePlural(inc.getValueSet().size(), "VALUE_SET_IMPORT", new Object[0]) + " ");
            if (inc.getValueSet().size() <= 2) {
                int i = 0;
                for (UriType uriType : inc.getValueSet()) {
                    if (i > 0) {
                        if (i < inc.getValueSet().size() - 1) {
                            li.tx(", ");
                        } else {
                            li.tx(" and ");
                        }
                    }
                    ++i;
                    XhtmlNode xhtmlNode = this.renderStatus(uriType, li);
                    this.AddVsRef(uriType.asStringValue(), xhtmlNode, vsRes);
                }
            } else {
                XhtmlNode xul = li.ul();
                for (UriType uriType : inc.getValueSet()) {
                    XhtmlNode xhtmlNode = this.renderStatus(uriType, xul.li());
                    this.AddVsRef(uriType.asStringValue(), xhtmlNode, vsRes);
                }
            }
        }
    }

    private void renderConcept(ValueSet.ConceptSetComponent inc, List<String> langs, boolean doDesignations, List<TerminologyRenderer.UsedConceptMap> maps, Map<String, String> designations, Map<String, CodeSystem.ConceptDefinitionComponent> definitions, XhtmlNode t, boolean hasComments, boolean hasDefinition, ValueSet.ConceptReferenceComponent c, String version) {
        XhtmlNode tr = t.tr();
        XhtmlNode td = this.renderStatusRow(c, t, tr);
        CodeSystem.ConceptDefinitionComponent cc = definitions == null ? null : definitions.get(c.getCode());
        this.addCodeToTable(false, inc.getSystem(), version, c.getCode(), c.hasDisplay() ? c.getDisplay() : (cc != null ? cc.getDisplay() : ""), td);
        td = tr.td();
        if (!Utilities.noString((String)c.getDisplay())) {
            this.renderStatus(c.getDisplayElement(), td).addText(c.getDisplay());
        } else if (VersionComparisonAnnotation.hasDeleted(c, "display")) {
            StringType d = (StringType)VersionComparisonAnnotation.getDeletedItem(c, "display");
            this.renderStatus(d, td).addText(d.primitiveValue());
        } else if (cc != null && !Utilities.noString((String)cc.getDisplay())) {
            td.style("color: #cccccc").addText(cc.getDisplay());
        }
        if (hasDefinition) {
            td = tr.td();
            if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition")) {
                td.addTextWithLineBreaks(ExtensionUtilities.readStringExtension((Element)c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition"));
            } else if (cc != null && !Utilities.noString((String)cc.getDefinition())) {
                td.addTextWithLineBreaks(cc.getDefinition());
            }
        }
        if (hasComments) {
            td = tr.td();
            if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments")) {
                td.addTextWithLineBreaks(this.context.formatPhrase("VALUE_SET_NOTE", new Object[]{ExtensionUtilities.readStringExtension((Element)c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments") + " "}));
            }
        }
        if (doDesignations) {
            this.addDesignationsToRow(c, designations, tr);
            this.addLangaugesToRow(c, langs, tr);
        }
        for (TerminologyRenderer.UsedConceptMap m : maps) {
            td = tr.td();
            List<TerminologyRenderer.TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), m.getMap());
            boolean first = true;
            for (TerminologyRenderer.TargetElementComponentWrapper mapping : mappings) {
                if (!first) {
                    td.br();
                }
                first = false;
                XhtmlNode span = td.span(null, mapping.comp.getRelationship().toString());
                span.addText(this.getCharForRelationship(mapping.comp));
                this.addRefToCode(td, mapping.group.getTarget(), m.getLink(), mapping.comp.getCode(), version);
                if (Utilities.noString((String)mapping.comp.getComment())) continue;
                td.i().tx("(" + mapping.comp.getComment() + ")");
            }
        }
    }

    public void addDesignationsToRow(ValueSet.ConceptReferenceComponent c, Map<String, String> designations, XhtmlNode tr) {
        for (String url : designations.keySet()) {
            String d = null;
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    if (!url.equals(this.getUrlForDesignation(dd))) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    public void addLangaugesToRow(ValueSet.ConceptReferenceComponent c, List<String> langs, XhtmlNode tr) {
        for (String lang : langs) {
            String l;
            String d = null;
            for (Extension ext : c.getExtension()) {
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || !lang.equals(l = ExtensionUtilities.readStringExtension((Element)ext, "lang"))) continue;
                d = ExtensionUtilities.readStringExtension((Element)ext, "content");
            }
            if (d == null) {
                for (ValueSet.ConceptReferenceDesignationComponent dd : c.getDesignation()) {
                    l = dd.getLanguage();
                    if (!lang.equals(l)) continue;
                    d = dd.getValue();
                }
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    private Map<String, CodeSystem.ConceptDefinitionComponent> getConceptsForCodes(CodeSystem e, ValueSet.ConceptSetComponent inc, ValueSet source, int index) {
        if (e == null) {
            e = this.getContext().getWorker().fetchCodeSystem(inc.getSystem());
        }
        ValueSet.ValueSetExpansionComponent vse = null;
        if (!this.context.isNoSlowLookup()) {
            try {
                ValueSet vs = new ValueSet();
                vs.setUrl(source.getUrl() + "-inc-" + index);
                vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
                vs.setCompose(new ValueSet.ValueSetComposeComponent());
                vs.getCompose().setInactive(false);
                vs.getCompose().getInclude().add(inc);
                ValueSetExpansionOutcome vso = this.getContext().getWorker().expandVS(vs, true, false);
                ValueSet valueset = vso.getValueset();
                if (valueset == null) {
                    throw new TerminologyServiceException(this.context.formatPhrase("VALUE_SET_ERROR", new Object[]{vso.getError() + " "}));
                }
                vse = valueset.getExpansion();
            }
            catch (Exception e1) {
                return null;
            }
        }
        HashMap<String, CodeSystem.ConceptDefinitionComponent> results = new HashMap<String, CodeSystem.ConceptDefinitionComponent>();
        ArrayList<CodingValidationRequest> serverList = new ArrayList<CodingValidationRequest>();
        for (ValueSet.ConceptReferenceComponent cc : inc.getConcept()) {
            String code = cc.getCode();
            CodeSystem.ConceptDefinitionComponent v = null;
            if (e != null && code != null) {
                v = this.getConceptForCode(e.getConcept(), code);
            }
            if (v == null && vse != null) {
                v = this.getConceptForCodeFromExpansion(vse.getContains(), code);
            }
            if (v != null) {
                results.put(code, v);
                continue;
            }
            serverList.add(new CodingValidationRequest(new Coding(inc.getSystem(), code, null)));
        }
        if (!this.context.isNoSlowLookup() && !serverList.isEmpty()) {
            try {
                int i = 0;
                while (serverList.size() > i) {
                    int len = Integer.min(serverList.size(), 1000);
                    List list = serverList.subList(i, i + len);
                    i += len;
                    this.getContext().getWorker().validateCodeBatch(this.getContext().getTerminologyServiceOptions(), list, null, true);
                    for (CodingValidationRequest vr : list) {
                        CodeSystem.ConceptDefinitionComponent v = vr.getResult().asConceptDefinition();
                        if (v == null) continue;
                        results.put(vr.getCoding().getCode(), v);
                    }
                }
            }
            catch (Exception e1) {
                return null;
            }
        }
        return results;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCodeFromExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (code.equals(c.getCode())) {
                CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
                res.setCode(c.getCode());
                res.setDisplay(c.getDisplay());
                return res;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCodeFromExpansion(c.getContains(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private boolean codeExistsInValueSet(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            if (!this.inConcept(code, c)) continue;
            return true;
        }
        return false;
    }

    private void addDesignationRow(ValueSet.ConceptReferenceComponent c, XhtmlNode t, List<String> langs, Map<String, String> designations) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        this.addDesignationsToRow(c, designations, tr);
        this.addLangaugesToRow(c, langs, tr);
    }

    private String describe(Enumerations.FilterOperator op) {
        if (op == null) {
            return " " + this.context.formatPhrase("VALUE_SET_NULL", new Object[0]);
        }
        switch (op) {
            case EQUAL: {
                return " " + this.context.formatPhrase("VALUE_SET_EQUAL", new Object[0]);
            }
            case ISA: {
                return " " + this.context.formatPhrase("VALUE_SET_ISA", new Object[0]);
            }
            case ISNOTA: {
                return " " + this.context.formatPhrase("VALUE_SET_ISNOTA", new Object[0]);
            }
            case REGEX: {
                return " " + this.context.formatPhrase("VALUE_SET_REGEX", new Object[0]);
            }
            case NULL: {
                return " " + this.context.formatPhrase("VALUE_SET_NULLS", new Object[0]);
            }
            case IN: {
                return " " + this.context.formatPhrase("VALUE_SET_IN", new Object[0]);
            }
            case NOTIN: {
                return " " + this.context.formatPhrase("VALUE_SET_NOTIN", new Object[0]);
            }
            case DESCENDENTOF: {
                return " " + this.context.formatPhrase("VALUE_SET_DESCENDENTOF", new Object[0]);
            }
            case EXISTS: {
                return " " + this.context.formatPhrase("VALUE_SET_EXISTS", new Object[0]);
            }
            case GENERALIZES: {
                return " " + this.context.formatPhrase("VALUE_SET_GENERALIZES", new Object[0]);
            }
        }
        return null;
    }

    private boolean inConcept(String code, CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasCodeElement() && c.getCode().equals(code)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.inConcept(code, g)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void genSummaryTableContent(Renderer.RenderingStatus status, XhtmlNode tbl, CanonicalResource cr) throws IOException {
        super.genSummaryTableContent(status, tbl, cr);
        ValueSet vs = (ValueSet)cr;
        if (CodeSystemUtilities.hasOID(vs)) {
            XhtmlNode tr = tbl.tr();
            tr.td().tx(this.context.formatPhrase("GENERAL_OID", new Object[0]) + ":");
            tr.td().tx(this.context.formatPhrase("CODE_SYS_FOR_OID", new Object[]{CodeSystemUtilities.getOID(vs)}));
        }
    }
}

