/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public class WebTemplateRenderer
extends ResourceRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebTemplateRenderer.class);

    public WebTemplateRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean renderingUsesValidation() {
        return true;
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper wt) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        HierarchicalTableGenerator gen;
        this.renderResourceTechDetails(wt, x);
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator((RenderingI18nContext)this.context, this.context.getDestDir(), this.context.isInlineGraphics(), true, "");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "wt=" + wt.getId(), this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER);
        model.setAlternating(true);
        if (this.context.getRules() == RenderingContext.GenerationRules.VALID_RESOURCE || this.context.isInlineGraphics()) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC, true), "help16.png"}));
        }
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), "Name", this.context.formatPhrase("QUEST_LINK", new Object[0]), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), "Card.", this.context.formatPhrase("QUEST_TEXTFOR", new Object[0]), null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), "Definition", this.context.formatPhrase("QUEST_TIMES", new Object[0]), null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), "Type", this.context.formatPhrase("QUEST_TIMES", new Object[0]), null, 0));
        List list5 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator6);
        list5.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator6, null, model.getDocoRef(), "Inputs", this.context.formatPhrase("QUEST_TYPE_ITEM", new Object[0]), null, 0));
        HierarchicalTableGenerator.Row row = this.addItem(gen, model.getRows(), wt.child("tree"));
        XhtmlNode xn = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.addChildNode(xn);
    }

    private HierarchicalTableGenerator.Row addItem(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper item) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_vd_view.png", this.context.formatPhrase("QUEST_ROOT", new Object[0]));
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, item.primitiveValue("name"), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, item.primitiveValue("min") + ".." + ("-1".equals(item.primitiveValue("max")) ? "*" : item.primitiveValue("max")), null, null));
        String def = (String)(item.primitiveValue("archetype_id") != null ? item.primitiveValue("archetype_id") + "/" : "") + (item.primitiveValue("nodeId") != null ? item.primitiveValue("nodeId") : "");
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, (String)(Utilities.noString((String)def) ? "--" : def), item.primitiveValue("aqlPath"), null);
        r.getCells().add(cell);
        this.addTermBindings(gen, cell, item);
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, this.linkForType(item.primitiveValue("rmType")), item.primitiveValue("rmType"), null, null));
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, null, null, null);
        r.getCells().add(cell);
        boolean first = true;
        for (ResourceWrapper input : item.children("inputs")) {
            if (first) {
                first = false;
            } else {
                List list4 = cell.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator6);
                list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, "br"));
            }
            this.addInput(gen, cell, input);
        }
        for (ResourceWrapper child : item.children("children")) {
            this.addItem(gen, r.getSubRows(), child);
        }
        return r;
    }

    private void addInput(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell cell, ResourceWrapper input) {
        if (input.has("suffix")) {
            List list = cell.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, input.primitiveValue("suffix"), null));
            List list2 = cell.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, " ", null));
        }
        List list = cell.getPieces();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, input.primitiveValue("type"), null).addStyle("font-weight: bold"));
        if (input.has("defaultValue")) {
            List list3 = cell.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "(=", null));
            List list4 = cell.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator4);
            list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, input.primitiveValue("defaultValue"), null));
            List list5 = cell.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list5.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, null, ")", null));
        }
        if (input.has("validation")) {
            this.addValidation(gen, cell, input.child("validation"));
        }
        if (input.has("list")) {
            this.addList(gen, cell, input.children("list"));
        }
    }

    private void addValidation(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell cell, ResourceWrapper validation) {
        List list = cell.getPieces();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, ": ", null));
        if (validation.has("range") && !validation.has("precision")) {
            this.addRange(gen, cell, validation.child("range"));
        } else {
            boolean first = true;
            if (validation.has("range")) {
                List list2 = cell.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, "range: ", null));
                this.addRange(gen, cell, validation.child("range"));
                first = false;
            }
            if (validation.has("precision")) {
                if (!first) {
                    List list3 = cell.getPieces();
                    HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                    Objects.requireNonNull(hierarchicalTableGenerator3);
                    list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, "; ", null));
                }
                List list4 = cell.getPieces();
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator4, null, "precision: ", null));
                this.addRange(gen, cell, validation.child("precision"));
            }
        }
    }

    private void addRange(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell cell, ResourceWrapper range) {
        Object summ;
        String min = range.primitiveValue("min");
        String minOp = range.primitiveValue("minOp");
        String max = range.primitiveValue("max");
        String maxOp = range.primitiveValue("maxOp");
        if ("0".equals(min) && "0".equals(max)) {
            summ = "0";
        } else {
            summ = minOp + min;
            if (!Utilities.noString((String)max)) {
                summ = (String)summ + "," + maxOp + max;
            }
        }
        List list = cell.getPieces();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, (String)summ, null));
    }

    private void addList(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell cell, List<ResourceWrapper> list) {
        for (ResourceWrapper item : list) {
            List list2 = cell.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            list2.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, "br"));
            List list3 = cell.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            list3.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, null, "\u2022 ", null));
            List list4 = cell.getPieces();
            HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator3);
            list4.add(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator3, null, item.primitiveValue("label"), item.primitiveValue("value")));
        }
    }

    private void addTermBindings(HierarchicalTableGenerator gen, HierarchicalTableGenerator.Cell cell, ResourceWrapper item) {
        for (ResourceWrapper tb : item.children("termBindings")) {
            String code = tb.primitiveValue("code");
            ResourceWrapper v = tb.child("value");
            String value = v.primitiveValue("value");
            if (value.contains("::")) {
                value = value.substring(value.indexOf("::") + 2).replace("]", "");
            }
            String tid = v.primitiveValue("terminologyId");
            String pfx = "";
            String link = null;
            String hint = null;
            switch (code) {
                case "SNOMED-CT": {
                    pfx = "SCT:";
                    link = this.getLinkForCode("http://snomed.info/sct", null, value);
                    ValidationResult vr = this.context.getContext().validateCode(this.context.getTerminologyServiceOptions(), "http://snomed.info/sct", null, value, null);
                    if (!vr.isOk()) break;
                    hint = "SNOMED CT " + value + ": " + vr.getDisplay();
                    break;
                }
                case "LOINC": {
                    pfx = "LN:";
                    link = this.getLinkForCode("http://loinc.org", null, value);
                    ValidationResult vr = this.context.getContext().validateCode(this.context.getTerminologyServiceOptions(), "http://loinc.org", null, value, null);
                    if (!vr.isOk()) break;
                    hint = "LOINC " + value + ": " + vr.getDisplay();
                    break;
                }
                case "LNC205": {
                    break;
                }
                default: {
                    log.warn("?");
                }
            }
            HierarchicalTableGenerator hierarchicalTableGenerator = gen;
            Objects.requireNonNull(hierarchicalTableGenerator);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator, null, " ", null));
            HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator2);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator2, link, pfx + value, hint));
        }
    }

    private String linkForType(String t) {
        if (t == null) {
            return null;
        }
        StructureDefinition sd = this.context.getContext().fetchResource(StructureDefinition.class, "http://openehr.org/fhir/StructureDefinition/" + t);
        if (sd == null) {
            sd = this.context.getContext().fetchTypeDefinition(t);
        }
        if (sd != null) {
            return sd.getWebPath();
        }
        return null;
    }

    @Override
    protected XhtmlNode renderResourceTechDetails(ResourceWrapper r, XhtmlNode x) throws UnsupportedEncodingException, FHIRException, IOException {
        return this.renderResourceTechDetails(r, x, (String)(this.context.isContained() && r.getId() != null ? "#" + r.getId() : r.getId()));
    }

    @Override
    protected XhtmlNode renderResourceTechDetails(ResourceWrapper r, XhtmlNode x, String desc) throws UnsupportedEncodingException, FHIRException, IOException {
        String sid;
        XhtmlNode p = x.para().attribute("class", "res-header-id");
        if (desc == null) {
            p.b().tx(this.context.formatPhrase(this.context.isTechnicalMode() && !this.isInner() ? "PROF_DRIV_GEN_NARR_TECH" : "PROF_DRIV_GEN_NARR", new Object[]{"WebTemplate", ""}));
        } else {
            p.b().tx(this.context.formatPhrase(this.context.isTechnicalMode() && !this.isInner() ? "PROF_DRIV_GEN_NARR_TECH" : "PROF_DRIV_GEN_NARR", new Object[]{"WebTemplate", desc}));
        }
        String tid = r.primitiveValue("templateId");
        if (!Utilities.noString((String)tid) && !this.context.hasAnchor(sid = "hc" + tid)) {
            this.context.addAnchor(sid);
            x.an(this.context.prefixAnchor(sid));
        }
        if (this.context.isTechnicalMode()) {
            Renderer.RenderingStatus status = new Renderer.RenderingStatus();
            String lang = r.primitiveValue("defaultLanguage");
            ResourceWrapper versionId = r.child("semver");
            if (lang != null || versionId != null) {
                XhtmlNode div = x.div().style("display: inline-block").style("background-color: #d9e0e7").style("padding: 6px").style("margin: 4px").style("border: 1px solid #8da1b4").style("border-radius: 5px").style("line-height: 60%");
                boolean sfirst = true;
                p = this.plateStyle(div.para());
                if (tid != null) {
                    p.tx(this.context.formatPhrase("RES_REND_TEMPLATE_ID", new Object[]{tid}));
                    sfirst = false;
                }
                if (versionId != null) {
                    p.tx(this.context.formatPhrase("RES_REND_VER", new Object[]{versionId.primitiveValue()}));
                    sfirst = false;
                }
                if (lang != null) {
                    if (!sfirst) {
                        p.tx("; ");
                    }
                    p.tx(this.context.formatPhrase("RES_REND_LANGUAGE", new Object[]{lang}));
                    sfirst = false;
                }
            }
        }
        return null;
    }
}

