/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.mappings;

import java.util.ArrayList;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.renderers.StructureDefinitionRenderer;
import org.hl7.fhir.r5.renderers.mappings.ModelMappingProvider;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class StructureDefinitionMappingProvider
extends ModelMappingProvider {
    private StructureDefinition sd;
    private StructureDefinition.StructureDefinitionMappingComponent map;
    private FHIRPathEngine fpe;

    public StructureDefinitionMappingProvider(RenderingContext context, StructureDefinition dest, boolean reverse, StructureDefinition sd, StructureDefinition.StructureDefinitionMappingComponent map, FHIRPathEngine fpe) {
        super(context, dest, reverse);
        this.sd = sd;
        this.map = map;
        this.fpe = fpe;
    }

    @Override
    public StructureDefinitionRenderer.Column makeColumn(String id) {
        return new StructureDefinitionRenderer.Column(id, this.map.getName(), this.dest == null ? "??" : this.dest.present(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void render(ElementDefinition element, XhtmlNode div) {
        if (this.reverse) {
            ArrayList<ElementDefinition> sources = new ArrayList<ElementDefinition>();
            for (ElementDefinition elementDefinition : this.dest.getSnapshot().getElement()) {
                String[] maps;
                void var6_12;
                Object var6_13 = null;
                for (ElementDefinition.ElementDefinitionMappingComponent t : elementDefinition.getMapping()) {
                    if (!t.hasIdentity() || !t.getIdentity().equals(this.map.getIdentity())) continue;
                    ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent = t;
                }
                if (var6_12 == null) continue;
                for (String s : maps = (var6_12.getMap() == null ? "" : var6_12.getMap()).split("\\,")) {
                    String tgt = this.processMap(s);
                    if ((tgt == null || !tgt.equals(element.getId())) && !tgt.equals(element.getPath())) continue;
                    sources.add(elementDefinition);
                }
            }
            if (sources.size() == 1) {
                this.renderElementLink(div, (ElementDefinition)sources.get(0));
            } else {
                XhtmlNode ul = div.ul();
                for (ElementDefinition elementDefinition : sources) {
                    this.renderElementLink(ul.li(), elementDefinition);
                }
            }
        } else {
            ElementDefinition.ElementDefinitionMappingComponent m = null;
            for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : element.getMapping()) {
                if (!elementDefinitionMappingComponent.hasIdentity() || !elementDefinitionMappingComponent.getIdentity().equals(this.map.getIdentity())) continue;
                m = elementDefinitionMappingComponent;
            }
            boolean complex = false;
            if (m != null) {
                String[] stringArray = (m.getMap() == null ? "" : m.getMap()).split("\\,");
                if (stringArray.length == 1) {
                    this.renderMap(div, stringArray[0]);
                } else {
                    complex = true;
                    XhtmlNode xhtmlNode = div.ul();
                    for (String s : stringArray) {
                        this.renderMap(xhtmlNode.li(), s);
                    }
                }
                if (m.hasComment()) {
                    if (!complex) {
                        div.br();
                    }
                    div.i().tx(m.getComment());
                }
            }
        }
    }

    private String processMap(String s) {
        if (s.contains(":")) {
            String l = s.substring(0, s.indexOf(":"));
            return l;
        }
        try {
            ExpressionNode exp = this.fpe.parse(s);
            this.stripFunctions(exp);
            return exp.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void renderElementLink(XhtmlNode div, ElementDefinition ed) {
        div.ah(this.ref() + "#" + ed.getId()).tx(ed.getPath());
    }

    private void renderMap(XhtmlNode x, String s) {
        if (s.contains(":")) {
            String l = s.substring(0, s.indexOf(":"));
            String r = s.substring(s.indexOf(":") + 1);
            if (this.dest != null && this.dest.getSnapshot().getElementById(l) != null) {
                x.ah(this.ref() + "#" + l, l).tx(r);
            } else {
                x.tx(r);
            }
        } else {
            try {
                ExpressionNode exp = this.fpe.parse(s);
                this.stripFunctions(exp);
                String p = exp.toString();
                if (this.dest.getSnapshot().getElementById(p) != null) {
                    x.ah(this.ref() + "#" + p, p).tx(s);
                } else {
                    x.tx(s);
                }
            }
            catch (Exception e) {
                x.tx(s);
            }
        }
    }

    private void stripFunctions(ExpressionNode exp) {
        while (exp.getInner() != null && exp.getInner().getKind() == ExpressionNode.Kind.Function) {
            exp.setInner(exp.getInner().getInner());
        }
        if (exp.getInner() != null) {
            this.stripFunctions(exp.getInner());
        }
    }
}

