/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.terminologies.TerminologyUtilities;
import org.hl7.fhir.r5.terminologies.providers.SpecialCodeSystem;
import org.hl7.fhir.r5.utils.CanonicalResourceUtilities;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeSystemUtilities
extends TerminologyUtilities {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeSystemUtilities.class);
    public static final String USER_DATA_CROSS_LINK = "cs.utils.cross.link";

    public static boolean isNotSelectable(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent def) {
        String pd = CodeSystemUtilities.getPropertyByUrl(cs, "http://hl7.org/fhir/concept-properties#notSelectable");
        if (pd == null) {
            pd = "notSelectable";
        }
        for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
            if (!pd.equals(p.getCode()) || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
            return (Boolean)((BooleanType)p.getValue()).getValue();
        }
        return false;
    }

    public static boolean isNotSelectable(@Nonnull CodeSystem cs, @Nonnull String code) {
        CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.findCode(cs.getConcept(), code);
        return cd == null ? false : CodeSystemUtilities.isNotSelectable(cs, cd);
    }

    public static void setNotSelectable(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent concept) throws FHIRFormatError {
        CodeSystemUtilities.defineNotSelectableProperty(cs);
        CodeSystem.ConceptPropertyComponent p = CodeSystemUtilities.getProperty(concept, "notSelectable");
        if (p != null) {
            p.setValue(new BooleanType(true));
        } else {
            concept.addProperty().setCode("notSelectable").setValue(new BooleanType(true));
        }
    }

    public static void setProperty(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent concept, @Nonnull String code, @Nonnull DataType value) throws FHIRFormatError {
        CodeSystemUtilities.defineProperty(cs, code, CodeSystemUtilities.propertyTypeForValue(value));
        CodeSystem.ConceptPropertyComponent p = CodeSystemUtilities.getProperty(concept, code);
        if (p != null) {
            p.setValue(value);
        } else {
            concept.addProperty().setCode(code).setValue(value);
        }
    }

    public static void setProperty(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent concept, @Nonnull String url, @Nonnull String code, @Nonnull DataType value) throws FHIRFormatError {
        CodeSystemUtilities.defineProperty(cs, code, CodeSystemUtilities.propertyTypeForValue(value), url);
        CodeSystem.ConceptPropertyComponent p = CodeSystemUtilities.getProperty(concept, code);
        if (p != null) {
            p.setValue(value);
        } else {
            concept.addProperty().setCode(code).setValue(value);
        }
    }

    private static CodeSystem.PropertyType propertyTypeForValue(DataType value) {
        if (value instanceof BooleanType) {
            return CodeSystem.PropertyType.BOOLEAN;
        }
        if (value instanceof CodeType) {
            return CodeSystem.PropertyType.CODE;
        }
        if (value instanceof Coding) {
            return CodeSystem.PropertyType.CODING;
        }
        if (value instanceof DateTimeType) {
            return CodeSystem.PropertyType.DATETIME;
        }
        if (value instanceof DecimalType) {
            return CodeSystem.PropertyType.DECIMAL;
        }
        if (value instanceof IntegerType) {
            return CodeSystem.PropertyType.INTEGER;
        }
        if (value instanceof StringType) {
            return CodeSystem.PropertyType.STRING;
        }
        throw new Error("Unknown property type " + value.getClass().getName());
    }

    private static String defineProperty(CodeSystem cs, String code, CodeSystem.PropertyType pt) {
        String url = "http://hl7.org/fhir/concept-properties#" + code;
        return CodeSystemUtilities.defineProperty(cs, code, pt, url);
    }

    private static String defineProperty(CodeSystem cs, String code, CodeSystem.PropertyType pt, String url) {
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!p.hasCode() || !p.getCode().equals(code)) continue;
            if (!p.getUri().equals(url)) {
                throw new Error("URI mismatch for code " + code + " url = " + p.getUri() + " vs " + url);
            }
            if (!p.getType().equals((Object)pt)) {
                throw new Error("Type mismatch for code " + code + " type = " + String.valueOf((Object)p.getType()) + " vs " + String.valueOf((Object)pt));
            }
            return code;
        }
        cs.addProperty().setCode(code).setUri(url).setType(pt).setUri(url);
        return code;
    }

    public static void defineNotSelectableProperty(@Nonnull CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "notSelectable", "Indicates that the code is abstract - only intended to be used as a selector for other concepts", CodeSystem.PropertyType.BOOLEAN);
    }

    public static void setStatus(@Nonnull CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept, ConceptStatus status) throws FHIRFormatError {
        CodeSystemUtilities.defineStatusProperty(cs);
        CodeSystem.ConceptPropertyComponent p = CodeSystemUtilities.getProperty(concept, "status");
        if (p != null) {
            p.setValue(new CodeType(status.toCode()));
        } else {
            concept.addProperty().setCode("status").setValue(new CodeType(status.toCode()));
        }
    }

    public static void defineStatusProperty(@Nonnull CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "status", "A property that indicates the status of the concept. One of active, experimental, deprecated, retired", CodeSystem.PropertyType.CODE);
    }

    private static void defineDeprecatedProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "deprecationDate", "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged", CodeSystem.PropertyType.DATETIME);
    }

    public static void defineParentProperty(@Nonnull CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "parent", "The concept identified in this property is a parent of the concept on which it is a property. The property type will be 'code'. The meaning of parent/child relationships is defined by the hierarchyMeaning attribute", CodeSystem.PropertyType.CODE);
    }

    public static void defineChildProperty(@Nonnull CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "child", "The concept identified in this property is a child of the concept on which it is a property. The property type will be 'code'. The meaning of parent/child relationships is defined by the hierarchyMeaning attribute", CodeSystem.PropertyType.CODE);
    }

    public static boolean isDeprecated(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent def, boolean ignoreStatus) {
        try {
            for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
                if (!ignoreStatus && "status".equals(p.getCode()) && p.hasValue() && p.hasValueCodeType() && "deprecated".equals(p.getValueCodeType().getCode())) {
                    return true;
                }
                if ("deprecationDate".equals(p.getCode()) && p.hasValue() && p.getValue() instanceof DateTimeType) {
                    return ((DateTimeType)p.getValue()).before(new DateTimeType(Calendar.getInstance()));
                }
                if (!"deprecated".equals(p.getCode()) || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
                return (Boolean)((BooleanType)p.getValue()).getValue();
            }
            StandardsStatus ss = ExtensionUtilities.getStandardsStatus(def);
            return ss == StandardsStatus.DEPRECATED;
        }
        catch (FHIRException e) {
            return false;
        }
    }

    public static boolean isInactive(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent def, boolean ignoreStatus) {
        try {
            for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
                if (!ignoreStatus && "status".equals(p.getCode()) && p.hasValue() && p.hasValueCodeType() && "inactive".equals(p.getValueCodeType().getCode())) {
                    return true;
                }
                if (!"inactive".equals(p.getCode()) || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
                return (Boolean)((BooleanType)p.getValue()).getValue();
            }
            return false;
        }
        catch (FHIRException e) {
            return false;
        }
    }

    public static void setDeprecated(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent concept, @Nonnull DateTimeType date) throws FHIRFormatError {
        CodeSystemUtilities.setStatus(cs, concept, ConceptStatus.Deprecated);
        CodeSystemUtilities.defineDeprecatedProperty(cs);
        concept.addProperty().setCode("deprecationDate").setValue(date);
    }

    public static void setDeprecated(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent concept) throws FHIRFormatError {
        CodeSystemUtilities.setStatus(cs, concept, ConceptStatus.Deprecated);
    }

    public static boolean isInactive(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent def) throws FHIRException {
        StandardsStatus ss = ExtensionUtilities.getStandardsStatus(def);
        if (ss == StandardsStatus.DEPRECATED || ss == StandardsStatus.WITHDRAWN) {
            return true;
        }
        for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
            if ("status".equals(p.getCode()) && p.hasValueStringType()) {
                return "inactive".equals(p.getValueStringType().primitiveValue()) || "retired".equals(p.getValueStringType().primitiveValue()) || "deprecated".equals(p.getValueStringType().primitiveValue());
            }
            if ("inactive".equals(p.getCode()) && p.hasValueBooleanType()) {
                return (Boolean)p.getValueBooleanType().getValue();
            }
            if (!"inactive".equals(p.getCode()) || !p.hasValueCodeType()) continue;
            String code = p.getValueCodeType().primitiveValue();
            return "true".equals(code);
        }
        return false;
    }

    public static boolean isInactive(@Nonnull CodeSystem cs, @Nonnull String code) throws FHIRException {
        if (cs.hasUserData("tx.cs.special")) {
            SpecialCodeSystem scs = (SpecialCodeSystem)cs.getUserData("tx.cs.special");
            return scs.inactive(code);
        }
        CodeSystem.ConceptDefinitionComponent def = CodeSystemUtilities.findCode(cs.getConcept(), code);
        if (def == null) {
            return true;
        }
        return CodeSystemUtilities.isInactive(cs, def);
    }

    public static void defineCodeSystemProperty(@Nonnull CodeSystem cs, @Nonnull String code, @Nonnull String description, @Nonnull CodeSystem.PropertyType type) {
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!p.hasCode() || !p.getCode().equals(code)) continue;
            return;
        }
        cs.addProperty().setCode(code).setDescription(description).setType(type).setUri("http://hl7.org/fhir/concept-properties#" + code);
    }

    public static String getCodeDefinition(@Nonnull CodeSystem cs, @Nonnull String code) {
        return CodeSystemUtilities.getCodeDefinition(cs.getConcept(), code);
    }

    private static String getCodeDefinition(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.hasCode() && c.getCode().equals(code)) {
                return c.getDefinition();
            }
            String s = CodeSystemUtilities.getCodeDefinition(c.getConcept(), code);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public static CodeSystem makeShareable(@Nonnull CodeSystem cs) {
        if (!cs.hasExperimental()) {
            cs.setExperimental(false);
        }
        if (!cs.hasMeta()) {
            cs.setMeta(new Meta());
        }
        for (UriType uriType : cs.getMeta().getProfile()) {
            if (!"http://hl7.org/fhir/StructureDefinition/shareablecodesystem".equals(uriType.getValue())) continue;
            return cs;
        }
        cs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablecodesystem"));
        return cs;
    }

    public static boolean checkMakeShareable(@Nonnull CodeSystem cs) {
        boolean changed = false;
        if (!cs.hasExperimental()) {
            cs.setExperimental(false);
            changed = true;
        }
        if (!cs.hasMeta()) {
            cs.setMeta(new Meta());
        }
        for (UriType uriType : cs.getMeta().getProfile()) {
            if (!"http://hl7.org/fhir/StructureDefinition/shareablecodesystem".equals(uriType.getValue())) continue;
            return changed;
        }
        cs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablecodesystem"));
        return true;
    }

    public static void setOID(@Nonnull CodeSystem cs, @Nonnull String oid) {
        if (!((String)oid).startsWith("urn:oid:")) {
            oid = "urn:oid:" + (String)oid;
        }
        if (!cs.hasIdentifier()) {
            cs.addIdentifier(new Identifier().setSystem("urn:ietf:rfc:3986").setValue((String)oid));
        } else if ("urn:ietf:rfc:3986".equals(cs.getIdentifierFirstRep().getSystem()) && cs.getIdentifierFirstRep().hasValue() && cs.getIdentifierFirstRep().getValue().startsWith("urn:oid:")) {
            cs.getIdentifierFirstRep().setValue((String)oid);
        } else {
            throw new Error("unable to set OID on code system");
        }
    }

    public static boolean hasOID(@Nonnull CanonicalResource cs) {
        return CodeSystemUtilities.getOID(cs) != null;
    }

    public static String getOID(@Nonnull CanonicalResource cs) {
        if (cs != null && cs.hasIdentifier() && "urn:ietf:rfc:3986".equals(cs.getIdentifierFirstRep().getSystem()) && cs.getIdentifierFirstRep().hasValue() && cs.getIdentifierFirstRep().getValue().startsWith("urn:oid:")) {
            return cs.getIdentifierFirstRep().getValue().substring(8);
        }
        return null;
    }

    public static CodeSystem.ConceptDefinitionComponent findCode(@Nonnull List<CodeSystem.ConceptDefinitionComponent> list, @Nonnull String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.hasCode() && c.getCode().equals(code)) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent s = CodeSystemUtilities.findCode(c.getConcept(), code);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public static List<CodeSystem.ConceptDefinitionComponent> findCodeWithParents(@Nonnull List<CodeSystem.ConceptDefinitionComponent> parents, @Nonnull List<CodeSystem.ConceptDefinitionComponent> list, @Nonnull String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.hasCode() && c.getCode().equals(code)) {
                return CodeSystemUtilities.addToList(parents, c);
            }
            List<CodeSystem.ConceptDefinitionComponent> s = CodeSystemUtilities.findCodeWithParents(CodeSystemUtilities.addToList(parents, c), c.getConcept(), code);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    private static List<CodeSystem.ConceptDefinitionComponent> addToList(List<CodeSystem.ConceptDefinitionComponent> parents, CodeSystem.ConceptDefinitionComponent c) {
        ArrayList<CodeSystem.ConceptDefinitionComponent> res = new ArrayList<CodeSystem.ConceptDefinitionComponent>();
        if (parents != null) {
            res.addAll(parents);
        }
        res.add(c);
        return res;
    }

    public static CodeSystem.ConceptDefinitionComponent findCodeOrAltCode(@Nonnull List<CodeSystem.ConceptDefinitionComponent> list, @Nonnull String code, @Nonnull String use) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.hasCode() && c.getCode().equals(code)) {
                return c;
            }
            for (CodeSystem.ConceptPropertyComponent p : c.getProperty()) {
                if (!"alternateCode".equals(p.getCode()) || use != null && !CodeSystemUtilities.hasUse(p, use) || !p.hasValue() || !p.getValue().isPrimitive() || !code.equals(p.getValue().primitiveValue())) continue;
                return c;
            }
            CodeSystem.ConceptDefinitionComponent s = CodeSystemUtilities.findCodeOrAltCode(c.getConcept(), code, use);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    private static boolean hasUse(CodeSystem.ConceptPropertyComponent p, String use) {
        for (Extension ext : p.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/alternate-code-use")) {
            if (!ext.hasValueCoding() || !use.equals(ext.getValueCoding().getCode())) continue;
            return true;
        }
        return false;
    }

    public static void markStatus(@Nonnull CodeSystem cs, String wg, StandardsStatus status, String pckage, String fmm, String normativeVersion) throws FHIRException {
        String sfmm;
        if (wg != null && (!ExtensionUtilities.hasExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg") || Utilities.existsInList((String)ExtensionUtilities.readStringExtension((DomainResource)cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"), (String[])new String[]{"fhir", "vocab"}) && !Utilities.existsInList((String)wg, (String[])new String[]{"fhir", "vocab"}))) {
            CanonicalResourceUtilities.setHl7WG(cs, wg);
        }
        if (status != null) {
            StandardsStatus ss = ExtensionUtilities.getStandardsStatus(cs);
            if (ss == null || ss.isLowerThan(status)) {
                ExtensionUtilities.setStandardsStatus(cs, status, normativeVersion);
            }
            if (pckage != null) {
                if (!cs.hasUserData("ballot.package")) {
                    cs.setUserData("ballot.package", pckage);
                } else if (!pckage.equals(cs.getUserString("ballot.package")) && !"infrastructure".equals(cs.getUserString("ballot.package"))) {
                    log.warn("Code System " + cs.getUrl() + ": ownership clash " + pckage + " vs " + cs.getUserString("ballot.package"));
                }
            }
            if (status == StandardsStatus.NORMATIVE) {
                cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            }
        }
        if (fmm != null && (Utilities.noString((String)(sfmm = ExtensionUtilities.readStringExtension((DomainResource)cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"))) || Integer.parseInt(sfmm) < Integer.parseInt(fmm))) {
            ExtensionUtilities.setIntegerExtension(cs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm", Integer.parseInt(fmm));
        }
    }

    public static DataType readProperty(@Nonnull CodeSystem.ConceptDefinitionComponent concept, @Nonnull String code) {
        for (CodeSystem.ConceptPropertyComponent p : concept.getProperty()) {
            if (!p.hasCode() || !p.getCode().equals(code)) continue;
            return p.getValue();
        }
        return null;
    }

    public static CodeSystem.ConceptPropertyComponent getProperty(@Nonnull CodeSystem.ConceptDefinitionComponent concept, @Nonnull String code) {
        for (CodeSystem.ConceptPropertyComponent p : concept.getProperty()) {
            if (!p.hasCode() || !p.getCode().equals(code)) continue;
            return p;
        }
        return null;
    }

    public static List<CodeSystem.ConceptPropertyComponent> getPropertyValues(@Nonnull CodeSystem.ConceptDefinitionComponent concept, @Nonnull String code) {
        ArrayList<CodeSystem.ConceptPropertyComponent> res = new ArrayList<CodeSystem.ConceptPropertyComponent>();
        if (code != null) {
            for (CodeSystem.ConceptPropertyComponent p : concept.getProperty()) {
                if (!code.equals(p.getCode())) continue;
                res.add(p);
            }
        }
        return res;
    }

    public static List<String> getOtherChildren(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent c) {
        ArrayList<String> res = new ArrayList<String>();
        for (CodeSystem.ConceptPropertyComponent p : c.getProperty()) {
            if (!"parent".equals(p.getCode())) continue;
            res.add(p.getValue().primitiveValue());
        }
        return res;
    }

    public static void addOtherChild(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent owner, @Nonnull String code) {
        CodeSystemUtilities.defineChildProperty(cs);
        owner.addProperty().setCode("child").setValue(new CodeType(code));
    }

    public static boolean hasProperty(@Nonnull CodeSystem.ConceptDefinitionComponent c, @Nonnull String code) {
        for (CodeSystem.ConceptPropertyComponent cp : c.getProperty()) {
            if (!code.equals(cp.getCode())) continue;
            return true;
        }
        return false;
    }

    public static String getProperty(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent c, @Nonnull String uri, @Nonnull String code) {
        for (CodeSystem.ConceptPropertyComponent cp : c.getProperty()) {
            if (!code.equals(cp.getCode())) continue;
            return cp.getValue().primitiveValue();
        }
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            CodeSystem.ConceptPropertyComponent t;
            if (!uri.equals(p.getUri()) || (t = CodeSystemUtilities.getProperty(c, p.getCode())) == null) continue;
            return t.primitiveValue();
        }
        return null;
    }

    public static boolean hasProperty(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent c, @Nonnull String uri, @Nonnull String code) {
        for (CodeSystem.ConceptPropertyComponent cp : c.getProperty()) {
            if (!code.equals(cp.getCode())) continue;
            return true;
        }
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!uri.equals(p.getUri())) continue;
            return CodeSystemUtilities.hasProperty(c, p.getCode());
        }
        return false;
    }

    public static boolean hasCode(@Nonnull CodeSystem cs, @Nonnull String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
            if (!CodeSystemUtilities.hasCode(cc, code)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCode(@Nonnull CodeSystem.ConceptDefinitionComponent cc, @Nonnull String code) {
        if (code.equals(cc.getCode())) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent c : cc.getConcept()) {
            if (!CodeSystemUtilities.hasCode(c, code)) continue;
            return true;
        }
        return false;
    }

    public static CodeSystem.ConceptDefinitionComponent getCode(@Nonnull CodeSystem cs, @Nonnull String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : cs.getConcept()) {
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.getCode(cc, code);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    private static CodeSystem.ConceptDefinitionComponent getCode(@Nonnull CodeSystem.ConceptDefinitionComponent cc, @Nonnull String code) {
        if (code.equals(cc.getCode())) {
            return cc;
        }
        for (CodeSystem.ConceptDefinitionComponent c : cc.getConcept()) {
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.getCode(c, code);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    public static void crossLinkCodeSystem(@Nonnull CodeSystem cs) {
        String parent = CodeSystemUtilities.getPropertyByUrl(cs, "http://hl7.org/fhir/concept-properties#parent");
        if (parent != null) {
            CodeSystemUtilities.crossLinkConcepts(cs.getConcept(), cs.getConcept(), parent);
        }
    }

    private static String getPropertyByUrl(@Nonnull CodeSystem cs, String url) {
        for (CodeSystem.PropertyComponent pc : cs.getProperty()) {
            if (!url.equals(pc.getUri())) continue;
            return pc.getCode();
        }
        return null;
    }

    private static void crossLinkConcepts(List<CodeSystem.ConceptDefinitionComponent> root, List<CodeSystem.ConceptDefinitionComponent> focus, String parent) {
        for (CodeSystem.ConceptDefinitionComponent def : focus) {
            List<CodeSystem.ConceptPropertyComponent> pcl = CodeSystemUtilities.getPropertyValues(def, parent);
            for (CodeSystem.ConceptPropertyComponent pc : pcl) {
                String code = pc.getValue().primitiveValue();
                CodeSystem.ConceptDefinitionComponent tgt = CodeSystemUtilities.findCode(root, code);
                if (!tgt.hasUserData(USER_DATA_CROSS_LINK)) {
                    tgt.setUserData(USER_DATA_CROSS_LINK, new ArrayList());
                }
                List children = (List)tgt.getUserData(USER_DATA_CROSS_LINK);
                children.add(def);
            }
            if (!def.hasConcept()) continue;
            CodeSystemUtilities.crossLinkConcepts(root, def.getConcept(), parent);
        }
    }

    public static boolean hasHierarchy(@Nonnull CodeSystem cs) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            if (!c.hasConcept()) continue;
            return true;
        }
        return false;
    }

    public static void sortAllCodes(@Nonnull CodeSystem cs) {
        CodeSystemUtilities.sortAllCodes(cs.getConcept());
    }

    private static void sortAllCodes(List<CodeSystem.ConceptDefinitionComponent> list) {
        Collections.sort(list, new ConceptDefinitionComponentSorter());
        for (CodeSystem.ConceptDefinitionComponent cd : list) {
            if (!cd.hasConcept()) continue;
            CodeSystemUtilities.sortAllCodes(cd.getConcept());
        }
    }

    public static Coding readCoding(String jurisdiction) {
        return jurisdiction == null || !jurisdiction.contains("#") ? null : new Coding().setCode(jurisdiction.substring(jurisdiction.indexOf("#") + 1)).setSystem(jurisdiction.substring(0, jurisdiction.indexOf("#")));
    }

    public static SystemReference getSystemReference(String system, IWorkerContext ctxt) {
        if (system == null) {
            return null;
        }
        if ("http://snomed.info/sct".equals(system)) {
            return new SystemReference("SNOMED CT", "https://browser.ihtsdotools.org/");
        }
        if ("http://loinc.org".equals(system)) {
            return new SystemReference("LOINC", "https://loinc.org/");
        }
        if ("http://unitsofmeasure.org".equals(system)) {
            return new SystemReference("UCUM", "http://ucum.org");
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return new SystemReference("RxNorm", "http://www.nlm.nih.gov/research/umls/rxnorm");
        }
        if (ctxt != null) {
            CodeSystem cs = ctxt.fetchCodeSystem(system);
            if (cs != null && cs.hasWebPath()) {
                return new SystemReference(cs.present(), cs.getWebPath(), Utilities.isAbsoluteUrl((String)cs.getWebPath()));
            }
            if (cs != null) {
                return new SystemReference(cs.present(), null);
            }
        }
        return null;
    }

    public static boolean isNotCurrent(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent c) {
        return CodeSystemUtilities.isInactive(cs, c) || CodeSystemUtilities.isDeprecated(cs, c, false);
    }

    public static List<String> getDisplays(@Nonnull CodeSystem srcCS, @Nonnull CodeSystem.ConceptDefinitionComponent cd) {
        ArrayList<String> list = new ArrayList<String>();
        if (cd.hasDisplay()) {
            list.add(cd.getDisplay());
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent d : cd.getDesignation()) {
            if (list.contains(d.getValue())) continue;
            list.add(d.getValue());
        }
        return list;
    }

    public static boolean checkDisplay(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent cd, @Nonnull String display) {
        List<String> displays = CodeSystemUtilities.getDisplays(cs, cd);
        for (String s : displays) {
            if (!s.equalsIgnoreCase(display)) continue;
            return true;
        }
        return false;
    }

    public static int countCodes(@Nonnull CodeSystem cs) {
        return CodeSystemUtilities.countCodes(cs.getConcept());
    }

    private static int countCodes(List<CodeSystem.ConceptDefinitionComponent> concept) {
        int t = concept.size();
        for (CodeSystem.ConceptDefinitionComponent cd : concept) {
            t += cd.hasConcept() ? CodeSystemUtilities.countCodes(cd.getConcept()) : 0;
        }
        return t;
    }

    public static CodeSystem mergeSupplements(@Nonnull CodeSystem cs, @Nonnull List<CodeSystem> supplements) {
        CodeSystem ret = cs.copy();
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (CodeSystem sup : supplements) {
            b.append(sup.getVersionedUrl());
        }
        ret.setUserData("supplements.installed", b.toString());
        for (CodeSystem.ConceptDefinitionComponent t : ret.getConcept()) {
            CodeSystemUtilities.mergeSupplements(ret, t, supplements);
        }
        return ret;
    }

    private static void mergeSupplements(CodeSystem ret, CodeSystem.ConceptDefinitionComponent fdef, List<CodeSystem> supplements) {
        for (CodeSystem cs : supplements) {
            CodeSystem.ConceptDefinitionComponent def = CodeSystemUtilities.findCode(cs.getConcept(), fdef.getCode());
            if (def != null) {
                for (Extension ext : def.getExtension()) {
                    fdef.addExtension(ext.copy());
                }
                for (CodeSystem.ConceptDefinitionDesignationComponent d : def.getDesignation()) {
                    fdef.addDesignation(d.copy());
                }
                for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
                    CodeSystem.PropertyComponent pd = CodeSystemUtilities.getPropertyDefinition(cs, p);
                    String code = pd != null ? CodeSystemUtilities.defineProperty(ret, pd, CodeSystemUtilities.propertyTypeForType(p.getValue())) : CodeSystemUtilities.defineProperty(ret, p.getCode(), CodeSystemUtilities.propertyTypeForType(p.getValue()));
                    fdef.addProperty().setCode(code).setValue(p.getValue()).copyExtensions(p, "http://hl7.org/fhir/StructureDefinition/alternate-code-use", "http://hl7.org/fhir/StructureDefinition/alternate-code-status");
                }
            }
            for (CodeSystem.ConceptDefinitionComponent t : fdef.getConcept()) {
                CodeSystemUtilities.mergeSupplements(ret, t, supplements);
            }
        }
    }

    private static CodeSystem.PropertyType propertyTypeForType(DataType value) {
        if (value == null) {
            return CodeSystem.PropertyType.NULL;
        }
        if (value instanceof CodeType) {
            return CodeSystem.PropertyType.CODE;
        }
        if (value instanceof CodeType) {
            return CodeSystem.PropertyType.CODING;
        }
        if (value instanceof CodeType) {
            return CodeSystem.PropertyType.STRING;
        }
        if (value instanceof CodeType) {
            return CodeSystem.PropertyType.INTEGER;
        }
        if (value instanceof CodeType) {
            return CodeSystem.PropertyType.BOOLEAN;
        }
        if (value instanceof CodeType) {
            return CodeSystem.PropertyType.DATETIME;
        }
        if (value instanceof CodeType) {
            return CodeSystem.PropertyType.DECIMAL;
        }
        throw new FHIRException("Unsupported property value for a CodeSystem Property: " + value.fhirType());
    }

    private static String defineProperty(CodeSystem cs, CodeSystem.PropertyComponent pd, CodeSystem.PropertyType pt) {
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!p.hasCode() || !p.getCode().equals(pd.getCode())) continue;
            if (!p.getUri().equals(pd.getUri())) {
                throw new Error("URI mismatch for code " + pd.getCode() + " url = " + p.getUri() + " vs " + pd.getUri());
            }
            if (!p.getType().equals((Object)pt)) {
                throw new Error("Type mismatch for code " + pd.getCode() + " type = " + p.getType().toCode() + " vs " + pt.toCode());
            }
            return pd.getCode();
        }
        cs.addProperty().setCode(pd.getCode()).setUri(pd.getUri()).setType(pt);
        return pd.getCode();
    }

    private static CodeSystem.PropertyComponent getPropertyDefinition(CodeSystem cs, CodeSystem.ConceptPropertyComponent p) {
        for (CodeSystem.PropertyComponent t : cs.getProperty()) {
            if (!t.hasCode() || !t.getCode().equals(p.getCode())) continue;
            return t;
        }
        return null;
    }

    public static boolean hasProperties(@Nonnull CodeSystem cs) {
        return CodeSystemUtilities.hasProperties(cs.getConcept());
    }

    private static boolean hasProperties(List<CodeSystem.ConceptDefinitionComponent> list) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (!c.hasProperty() && !CodeSystemUtilities.hasProperties(c.getConcept())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDesignations(@Nonnull CodeSystem cs) {
        return CodeSystemUtilities.hasDesignations(cs.getConcept());
    }

    private static boolean hasDesignations(List<CodeSystem.ConceptDefinitionComponent> list) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (!c.hasDesignation() && !CodeSystemUtilities.hasDesignations(c.getConcept())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPropertyDef(@Nonnull CodeSystem cs, @Nonnull String property) {
        for (CodeSystem.PropertyComponent pd : cs.getProperty()) {
            if (!pd.hasCode() || !pd.getCode().equals(property)) continue;
            return true;
        }
        return false;
    }

    public static DataType getProperty(@Nonnull CodeSystem cs, @Nonnull String code, @Nonnull String property) {
        CodeSystem.ConceptDefinitionComponent def = CodeSystemUtilities.getCode(cs, code);
        return CodeSystemUtilities.getProperty(cs, def, property);
    }

    public static DataType getProperty(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent def, @Nonnull String property) {
        CodeSystem.ConceptPropertyComponent cp;
        CodeSystem.PropertyComponent defn = CodeSystemUtilities.getPropertyDefinition(cs, property);
        if (defn != null) {
            property = defn.getCode();
        }
        return (cp = CodeSystemUtilities.getProperty(def, property)) == null ? null : cp.getValue();
    }

    public static boolean hasMarkdownInDefinitions(@Nonnull CodeSystem cs, @Nonnull MarkDownProcessor md) {
        return CodeSystemUtilities.hasMarkdownInDefinitions(cs.getConcept(), md);
    }

    private static boolean hasMarkdownInDefinitions(List<CodeSystem.ConceptDefinitionComponent> concepts, MarkDownProcessor md) {
        for (CodeSystem.ConceptDefinitionComponent c : concepts) {
            if (c.hasDefinition() && md.isProbablyMarkdown(c.getDefinition(), true)) {
                return true;
            }
            if (!c.hasConcept() || !CodeSystemUtilities.hasMarkdownInDefinitions(c.getConcept(), md)) continue;
            return true;
        }
        return false;
    }

    public static String getStatus(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent cc) {
        StandardsStatus ss = ExtensionUtilities.getStandardsStatus(cc);
        if (ss == StandardsStatus.DEPRECATED || ss == StandardsStatus.WITHDRAWN) {
            return ss.toCode();
        }
        DataType v = CodeSystemUtilities.getProperty(cs, cc, "status");
        if (v == null || !v.isPrimitive()) {
            return null;
        }
        return v.primitiveValue();
    }

    public static Boolean subsumes(@Nonnull CodeSystem cs, @Nonnull String pc, @Nonnull String cc) {
        if (pc.equals(cc)) {
            return true;
        }
        List<CodeSystem.ConceptDefinitionComponent> child = CodeSystemUtilities.findCodeWithParents(null, cs.getConcept(), cc);
        for (CodeSystem.ConceptDefinitionComponent item : child) {
            if (!pc.equals(item.getCode())) continue;
            return true;
        }
        return false;
    }

    public static Set<String> codes(@Nonnull CodeSystem cs) {
        HashSet<String> res = new HashSet<String>();
        CodeSystemUtilities.addCodes(res, cs.getConcept());
        return res;
    }

    private static void addCodes(Set<String> res, List<CodeSystem.ConceptDefinitionComponent> list) {
        for (CodeSystem.ConceptDefinitionComponent cd : list) {
            if (cd.hasCode()) {
                res.add(cd.getCode());
            }
            if (!cd.hasConcept()) continue;
            CodeSystemUtilities.addCodes(res, cd.getConcept());
        }
    }

    public static CodeSystem.PropertyComponent getPropertyDefinition(@Nonnull CodeSystem cs, @Nonnull String property) {
        String uri = CodeSystemUtilities.getStandardPropertyUri(property);
        if (uri != null) {
            for (CodeSystem.PropertyComponent cp : cs.getProperty()) {
                if (!uri.equals(cp.getUri())) continue;
                return cp;
            }
        }
        for (CodeSystem.PropertyComponent cp : cs.getProperty()) {
            if (!cp.getCode().equals(property)) continue;
            return cp;
        }
        return null;
    }

    public static boolean isDefinedProperty(@Nonnull CodeSystem cs, @Nonnull String property) {
        String uri = CodeSystemUtilities.getStandardPropertyUri(property);
        if (uri != null) {
            for (CodeSystem.PropertyComponent cp : cs.getProperty()) {
                if (!uri.equals(cp.getUri())) continue;
                return true;
            }
        }
        for (CodeSystem.PropertyComponent cp : cs.getProperty()) {
            if (!cp.getCode().equals(property) || uri != null && cp.hasUri()) continue;
            return true;
        }
        return false;
    }

    private static String getStandardPropertyUri(String property) {
        switch (property) {
            case "status": {
                return "http://hl7.org/fhir/concept-properties#status";
            }
            case "inactive": {
                return "http://hl7.org/fhir/concept-properties#inactive";
            }
            case "effectiveDate": {
                return "http://hl7.org/fhir/concept-properties#effectiveDate";
            }
            case "deprecationDate": {
                return "http://hl7.org/fhir/concept-properties#deprecationDate";
            }
            case "retirementDate": {
                return "http://hl7.org/fhir/concept-properties#retirementDate";
            }
            case "notSelectable": {
                return "http://hl7.org/fhir/concept-properties#notSelectable";
            }
            case "parent": {
                return "http://hl7.org/fhir/concept-properties#parent";
            }
            case "child": {
                return "http://hl7.org/fhir/concept-properties#child";
            }
            case "partOf": {
                return "http://hl7.org/fhir/concept-properties#partOf";
            }
            case "synonym": {
                return "http://hl7.org/fhir/concept-properties#synonym";
            }
            case "comment": {
                return "http://hl7.org/fhir/concept-properties#comment";
            }
            case "itemWeight": {
                return "http://hl7.org/fhir/concept-properties#itemWeight";
            }
        }
        return null;
    }

    public static boolean isExemptFromMultipleVersionChecking(String url) {
        return Utilities.existsInList((String)url, (String[])new String[]{"http://snomed.info/sct", "http://loinc.org"});
    }

    public static CodeSystem.PropertyComponent getPropertyByUri(@Nonnull CodeSystem cs, @Nonnull String uri) {
        for (CodeSystem.PropertyComponent t : cs.getProperty()) {
            if (!uri.equals(t.getUri())) continue;
            return t;
        }
        return null;
    }

    public static CodeSystem convertSD(@Nonnull StructureDefinition sd) {
        CodeSystem cs = new CodeSystem();
        cs.setId(sd.getId());
        cs.setUrl(sd.getUrl());
        cs.setVersion(sd.getVersion());
        cs.setStatus(sd.getStatus());
        cs.setContent(Enumerations.CodeSystemContentMode.COMPLETE);
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            CodeSystem.ConceptDefinitionComponent cd = cs.addConcept();
            cd.setCode(ed.getId());
            cd.setDisplay(ed.getId());
            ed.setDefinition(ed.getDefinition());
        }
        return cs;
    }

    public static boolean hasCSComments(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent c) {
        return CodeSystemUtilities.hasProperty(cs, c, "http://hl7.org/fhir/concept-properties#comments", "comments");
    }

    public static String getCSComments(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent c) {
        return CodeSystemUtilities.getProperty(cs, c, "http://hl7.org/fhir/concept-properties#comments", "comments");
    }

    public static void addCSComments(@Nonnull CodeSystem cs, @Nonnull CodeSystem.ConceptDefinitionComponent cc, @Nonnull String comments) {
        String code = "comments";
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!"http://hl7.org/fhir/concept-properties#comments".equals(p.getUri())) continue;
            code = p.getCode();
        }
        CodeSystemUtilities.setProperty(cs, cc, code, new StringType(comments));
    }

    public static enum ConceptStatus {
        Active,
        Experimental,
        Deprecated,
        Retired;


        public String toCode() {
            switch (this) {
                case Active: {
                    return "active";
                }
                case Experimental: {
                    return "experimental";
                }
                case Deprecated: {
                    return "deprecated";
                }
                case Retired: {
                    return "retired";
                }
            }
            return null;
        }
    }

    public static class ConceptDefinitionComponentSorter
    implements Comparator<CodeSystem.ConceptDefinitionComponent> {
        @Override
        public int compare(CodeSystem.ConceptDefinitionComponent o1, CodeSystem.ConceptDefinitionComponent o2) {
            return o1.hasCode() ? o1.getCode().compareToIgnoreCase(o2.getCode()) : 0;
        }
    }

    public static class SystemReference {
        private String link;
        private String text;
        private boolean local;

        public SystemReference(String text, String link) {
            this.link = link;
            this.text = text;
        }

        public SystemReference(String text, String link, boolean local) {
            this.link = link;
            this.text = text;
            this.local = local;
        }

        public String getLink() {
            return this.link;
        }

        public String getText() {
            return this.text;
        }

        public boolean isLocal() {
            return this.local;
        }
    }

    public static class CodeSystemNavigator {
        private CodeSystem cs;
        private boolean restructure;
        private Set<String> processed = new HashSet<String>();

        public CodeSystemNavigator(CodeSystem cs) {
            this.cs = cs;
            this.restructure = this.hasExtraRelationships(cs.getConcept());
        }

        public boolean isRestructure() {
            return this.restructure;
        }

        private boolean hasExtraRelationships(List<CodeSystem.ConceptDefinitionComponent> concept) {
            for (CodeSystem.ConceptDefinitionComponent cd : concept) {
                if (!this.getSubsumedBy(cd).isEmpty()) {
                    return true;
                }
                for (CodeSystem.ConceptDefinitionComponent cdc : cd.getConcept()) {
                    if (!this.hasExtraRelationships(cdc.getConcept())) continue;
                    return true;
                }
            }
            return false;
        }

        public List<CodeSystem.ConceptDefinitionComponent> getConcepts(@Nonnull CodeSystem.ConceptDefinitionComponent context) {
            if (context == null) {
                if (this.restructure) {
                    ArrayList<CodeSystem.ConceptDefinitionComponent> res = new ArrayList<CodeSystem.ConceptDefinitionComponent>();
                    for (CodeSystem.ConceptDefinitionComponent cd : this.cs.getConcept()) {
                        if (!this.getSubsumedBy(cd).isEmpty()) continue;
                        res.add(cd);
                        this.processed.add(cd.getCode());
                    }
                    return res;
                }
                return this.cs.getConcept();
            }
            if (this.restructure) {
                ArrayList<CodeSystem.ConceptDefinitionComponent> res = new ArrayList<CodeSystem.ConceptDefinitionComponent>();
                for (CodeSystem.ConceptDefinitionComponent cd : context.getConcept()) {
                    res.add(cd);
                    this.processed.add(cd.getCode());
                }
                for (CodeSystem.ConceptDefinitionComponent cd : this.cs.getConcept()) {
                    if (!this.getSubsumedBy(cd).contains(context.getCode()) || this.processed.contains(cd.getCode())) continue;
                    res.add(cd);
                    this.processed.add(cd.getCode());
                }
                return res;
            }
            return context.getConcept();
        }

        private List<String> getSubsumedBy(CodeSystem.ConceptDefinitionComponent cd) {
            ArrayList<String> codes = new ArrayList<String>();
            for (CodeSystem.ConceptPropertyComponent cp : cd.getProperty()) {
                if (!"subsumedBy".equals(cp.getCode())) continue;
                codes.add(cp.getValue().primitiveValue());
            }
            return codes;
        }

        public List<CodeSystem.ConceptDefinitionComponent> getOtherChildren(@Nonnull CodeSystem.ConceptDefinitionComponent context) {
            ArrayList<CodeSystem.ConceptDefinitionComponent> res = new ArrayList<CodeSystem.ConceptDefinitionComponent>();
            for (CodeSystem.ConceptDefinitionComponent cd : this.cs.getConcept()) {
                if (!this.getSubsumedBy(cd).contains(context.getCode()) || !this.processed.contains(cd.getCode())) continue;
                res.add(cd);
            }
            return res;
        }
    }

    public static class CodeSystemSorter
    implements Comparator<CodeSystem> {
        @Override
        public int compare(CodeSystem o1, CodeSystem o2) {
            String ver2;
            String ver1;
            String url2;
            String url1 = o1.getUrl();
            int c = this.compareString(url1, url2 = o2.getUrl());
            if (c == 0 && (c = VersionUtilities.compareVersions((String)(ver1 = o1.getVersion()), (String)(ver2 = o2.getVersion()))) == 0) {
                String d1 = o1.getDateElement().asStringValue();
                String d2 = o2.getDateElement().asStringValue();
                c = this.compareString(url1, url2);
            }
            return c;
        }

        private int compareString(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : 1;
            }
            return s1.compareTo(s2);
        }
    }
}

