/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

public class ConceptMapUtilities {
    public static boolean hasOID(ConceptMap cm) {
        return ConceptMapUtilities.getOID(cm) != null;
    }

    public static String getOID(ConceptMap cm) {
        for (Identifier id : cm.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            return id.getValue().substring(8);
        }
        return null;
    }

    public static void setOID(ConceptMap cm, String oid) {
        if (!((String)oid).startsWith("urn:oid:")) {
            oid = "urn:oid:" + (String)oid;
        }
        for (Identifier id : cm.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            id.setValue((String)oid);
            return;
        }
        cm.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue((String)oid);
    }

    public static boolean hasMappingForSource(ConceptMap cm, Coding code) {
        return ConceptMapUtilities.hasMappingForSource(cm, code.getSystem(), code.getVersion(), code.getCode());
    }

    public static boolean hasMappingForSource(ConceptMap cm, String system, String version, String code) {
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            if (!system.equals(grp.getSource())) continue;
            for (ConceptMap.SourceElementComponent e : grp.getElement()) {
                if (!code.equals(e.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasMappingForTarget(ConceptMap cm, Coding code) {
        return ConceptMapUtilities.hasMappingForTarget(cm, code.getSystem(), code.getVersion(), code.getCode());
    }

    public static boolean hasMappingForTarget(ConceptMap cm, String system, String version, String code) {
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            if (!system.equals(grp.getTarget())) continue;
            for (ConceptMap.SourceElementComponent e : grp.getElement()) {
                for (ConceptMap.TargetElementComponent t : e.getTarget()) {
                    if (!code.equals(t.getCode())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<Coding> listTargets(ConceptMap cm, List<String> systems) {
        ArrayList<Coding> list = new ArrayList<Coding>();
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            if (!systems.isEmpty() && !systems.contains(grp.getSource())) continue;
            for (ConceptMap.SourceElementComponent e : grp.getElement()) {
                for (ConceptMap.TargetElementComponent t : e.getTarget()) {
                    if (!t.hasCode()) continue;
                    list.add(new Coding(grp.getTarget(), t.getCode(), t.getDisplay()));
                }
            }
        }
        return list;
    }

    public static ConceptMap makeShareable(ConceptMap cm) {
        if (!cm.hasExperimental()) {
            cm.setExperimental(false);
        }
        if (!cm.hasMeta()) {
            cm.setMeta(new Meta());
        }
        for (UriType uriType : cm.getMeta().getProfile()) {
            if (!"http://hl7.org/fhir/StructureDefinition/shareableconceptmap".equals(uriType.getValue())) continue;
            return cm;
        }
        cm.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareableconceptmap"));
        return cm;
    }

    public static ConceptMap invert(ConceptMap src, String id, String url, String name, boolean collate) {
        ConceptMap dst = src.copy();
        dst.setId(id);
        dst.setUrl(url);
        dst.setName(name);
        dst.getGroup().clear();
        dst.setSourceScope(src.getTargetScope());
        dst.setTargetScope(src.getSourceScope());
        for (ConceptMap.ConceptMapGroupComponent gs : src.getGroup()) {
            ConceptMap.ConceptMapGroupComponent gd = dst.addGroup();
            gd.setTargetElement(gs.getSourceElement());
            gd.setSourceElement(gs.getTargetElement());
            HashMap<String, ConceptMap.SourceElementComponent> dstMap = new HashMap<String, ConceptMap.SourceElementComponent>();
            for (ConceptMap.SourceElementComponent es : gs.getElement()) {
                for (ConceptMap.TargetElementComponent ts : es.getTarget()) {
                    ConceptMap.SourceElementComponent ed;
                    ConceptMap.SourceElementComponent sourceElementComponent = ed = collate ? (ConceptMap.SourceElementComponent)dstMap.get(ts.getCode()) : null;
                    if (ed == null) {
                        ed = gd.addElement();
                        ed.setCodeElement(ts.getCodeElement());
                        if (collate) {
                            dstMap.put(ed.getCode(), ed);
                        }
                    }
                    ConceptMap.TargetElementComponent td = ed.addTarget();
                    td.setCode(es.getCode());
                    td.setComment(ts.getComment());
                    td.setRelationship(ConceptMapUtilities.invertRelationship(ts.getRelationship()));
                }
            }
        }
        return dst;
    }

    private static Enumerations.ConceptMapRelationship invertRelationship(Enumerations.ConceptMapRelationship relationship) {
        if (relationship == null) {
            return null;
        }
        switch (relationship) {
            case EQUIVALENT: {
                return Enumerations.ConceptMapRelationship.EQUIVALENT;
            }
            case NOTRELATEDTO: {
                return Enumerations.ConceptMapRelationship.NOTRELATEDTO;
            }
            case NULL: {
                return Enumerations.ConceptMapRelationship.NULL;
            }
            case RELATEDTO: {
                return Enumerations.ConceptMapRelationship.RELATEDTO;
            }
            case SOURCEISBROADERTHANTARGET: {
                return Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET;
            }
            case SOURCEISNARROWERTHANTARGET: {
                return Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET;
            }
        }
        return null;
    }

    public static ConceptMap collapse(String id, String url, boolean cumulative, ConceptMap src, ConceptMap ... sequence) {
        ConceptMap res = src.copy();
        res.setId(id);
        res.setUrl(url);
        for (ConceptMap cm : sequence) {
            if (res.hasTargetScope() && cm.hasTargetScope()) {
                if (!cm.getSourceScope().primitiveValue().equals(res.getTargetScope().primitiveValue())) {
                    throw new Error("Mismatch between sequential concept maps: target was " + String.valueOf(res.getTargetScope()) + " and source is " + String.valueOf(cm.getSourceScope()));
                }
                res.setTargetScope(cm.getTargetScope());
                continue;
            }
            res.setTargetScope(null);
        }
        for (ConceptMap.ConceptMapGroupComponent gd : res.getGroup()) {
            for (ConceptMap cm : sequence) {
                for (ConceptMap.ConceptMapGroupComponent gt : cm.getGroup()) {
                    if (gt.getSource().equals(gd.getTarget())) {
                        gd.setTarget(gt.getTarget());
                        ArrayList<ConceptMap.SourceElementComponent> processed = new ArrayList<ConceptMap.SourceElementComponent>();
                        for (ConceptMap.SourceElementComponent ed : gd.getElement()) {
                            ArrayList<ConceptMap.TargetElementComponent> list = new ArrayList<ConceptMap.TargetElementComponent>();
                            list.addAll(ed.getTarget());
                            ed.getTarget().clear();
                            for (ConceptMap.TargetElementComponent ts : list) {
                                for (ConceptMap.SourceElementComponent et : gt.getElement()) {
                                    if (!et.getCode().equals(ed.getCode())) continue;
                                    processed.add(et);
                                    for (ConceptMap.TargetElementComponent tt : et.getTarget()) {
                                        ed.addTarget().setCode(tt.getCode()).setRelationship(ConceptMapUtilities.combineRelationships(ts.getRelationship(), tt.getRelationship()));
                                    }
                                }
                            }
                            if (!ed.getTarget().isEmpty()) continue;
                            if (cumulative) {
                                ed.getTarget().addAll(list);
                                continue;
                            }
                            ed.setNoMap(true);
                        }
                        if (cumulative) {
                            for (ConceptMap.SourceElementComponent et : gt.getElement()) {
                                if (processed.contains(et)) continue;
                                gd.addElement(et.copy());
                            }
                        }
                    }
                    Collections.sort(gt.getElement(), new ConceptMapElementSorter());
                    for (ConceptMap.SourceElementComponent e : gt.getElement()) {
                        Collections.sort(e.getTarget(), new ConceptMapTargetElementSorter());
                    }
                }
            }
        }
        return res;
    }

    public static Enumerations.ConceptMapRelationship combineRelationships(Enumerations.ConceptMapRelationship rel1, Enumerations.ConceptMapRelationship rel2) {
        switch (rel1) {
            case EQUIVALENT: {
                return rel2;
            }
            case NOTRELATEDTO: {
                return Enumerations.ConceptMapRelationship.NOTRELATEDTO;
            }
            case NULL: {
                return null;
            }
            case RELATEDTO: {
                return rel2;
            }
            case SOURCEISBROADERTHANTARGET: {
                switch (rel2) {
                    case EQUIVALENT: {
                        return Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET;
                    }
                    case NOTRELATEDTO: {
                        return Enumerations.ConceptMapRelationship.NOTRELATEDTO;
                    }
                    case NULL: {
                        return null;
                    }
                    case RELATEDTO: {
                        return Enumerations.ConceptMapRelationship.RELATEDTO;
                    }
                    case SOURCEISBROADERTHANTARGET: {
                        return Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET;
                    }
                    case SOURCEISNARROWERTHANTARGET: {
                        return Enumerations.ConceptMapRelationship.RELATEDTO;
                    }
                }
            }
            case SOURCEISNARROWERTHANTARGET: {
                switch (rel2) {
                    case EQUIVALENT: {
                        return Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET;
                    }
                    case NOTRELATEDTO: {
                        return Enumerations.ConceptMapRelationship.NOTRELATEDTO;
                    }
                    case NULL: {
                        return null;
                    }
                    case RELATEDTO: {
                        return Enumerations.ConceptMapRelationship.RELATEDTO;
                    }
                    case SOURCEISBROADERTHANTARGET: {
                        return Enumerations.ConceptMapRelationship.RELATEDTO;
                    }
                    case SOURCEISNARROWERTHANTARGET: {
                        return Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET;
                    }
                }
            }
        }
        return null;
    }

    public static boolean checkReciprocal(ConceptMap left, ConceptMap right, List<String> issues, boolean makeChanges) {
        List<ElementMappingPair> pairs;
        boolean changed = false;
        if (!Base.compareDeep(left.getTargetScope(), right.getSourceScope(), true)) {
            issues.add("scopes are not reciprocal: " + String.valueOf(left.getTargetScope()) + " vs " + String.valueOf(right.getSourceScope()));
        }
        if (!Base.compareDeep(left.getSourceScope(), right.getTargetScope(), true)) {
            issues.add("scopes are not reciprocal: " + String.valueOf(left.getSourceScope()) + " vs " + String.valueOf(right.getTargetScope()));
        }
        for (ConceptMap.ConceptMapGroupComponent gl : left.getGroup()) {
            ConceptMap.ConceptMapGroupComponent gr = ConceptMapUtilities.findMatchingGroup(right.getGroup(), gl.getTarget(), gl.getSource());
            if (gr == null) {
                for (ConceptMap.SourceElementComponent e : gl.getElement()) {
                    for (ConceptMap.TargetElementComponent t : e.getTarget()) {
                        if (t.getRelationship() == Enumerations.ConceptMapRelationship.NOTRELATEDTO) continue;
                        if (makeChanges) {
                            changed = true;
                            right.forceGroup(gl.getTarget(), gl.getSource()).getOrAddElement(t.getCode()).addTarget(e.getCode(), ConceptMapUtilities.inverse(t.getRelationship()));
                            continue;
                        }
                        issues.add("left maps from " + gl.getSource() + "#" + e.getCode() + " to " + gl.getTarget() + "#" + t.getCode() + " but right has no matching reverse map");
                    }
                }
                continue;
            }
            for (ConceptMap.SourceElementComponent srcL : gl.getElement()) {
                if (!srcL.getNoMap()) {
                    block18: for (ConceptMap.TargetElementComponent tgtL : srcL.getTarget()) {
                        pairs = ConceptMapUtilities.getMappings(gr, tgtL.getCode(), srcL.getCode());
                        if (tgtL.getRelationship() == null) {
                            issues.add("Left map has relationship " + srcL.getCode() + " with no relationship");
                            continue;
                        }
                        switch (tgtL.getRelationship()) {
                            case EQUIVALENT: {
                                if (pairs.isEmpty()) {
                                    if (makeChanges) {
                                        changed = true;
                                        gr.getOrAddElement(tgtL.getCode()).addTarget(srcL.getCode(), Enumerations.ConceptMapRelationship.EQUIVALENT);
                                        break;
                                    }
                                    issues.add("Left map says that " + srcL.getCode() + " is equivalent to " + tgtL.getCode() + " but there's no reverse relationship");
                                    break;
                                }
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.EQUIVALENT) continue;
                                    issues.add("Left map says that " + srcL.getCode() + " is equivalent to " + tgtL.getCode() + " but the reverse relationship has type " + pair.tgt.getRelationship().toCode());
                                }
                                continue block18;
                            }
                            case RELATEDTO: {
                                if (pairs.isEmpty()) {
                                    issues.add("Left map says that " + srcL.getCode() + " is related to " + tgtL.getCode() + " but there's no reverse relationship");
                                    break;
                                }
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.EQUIVALENT || pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.RELATEDTO) continue;
                                    issues.add("Left map says that " + srcL.getCode() + " is related to " + tgtL.getCode() + " but the reverse relationship has type " + pair.tgt.getRelationship().toCode());
                                }
                                continue block18;
                            }
                            case SOURCEISBROADERTHANTARGET: {
                                if (pairs.isEmpty()) {
                                    issues.add("Left map says that " + srcL.getCode() + " is broader than " + tgtL.getCode() + " but there's no reverse relationship");
                                    break;
                                }
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET) continue;
                                    issues.add("Left map says that " + srcL.getCode() + " is broader than " + tgtL.getCode() + " but the reverse relationship has type " + pair.tgt.getRelationship().toCode());
                                }
                                continue block18;
                            }
                            case SOURCEISNARROWERTHANTARGET: {
                                if (pairs.isEmpty()) {
                                    issues.add("Left map says that " + srcL.getCode() + " is narrower than " + tgtL.getCode() + " but there's no reverse relationship");
                                    break;
                                }
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET) continue;
                                    issues.add("Left map says that " + srcL.getCode() + " is narrower than " + tgtL.getCode() + " but the reverse relationship has type " + pair.tgt.getRelationship().toCode());
                                }
                                continue block18;
                            }
                            case NOTRELATEDTO: {
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.NOTRELATEDTO) continue;
                                    issues.add("Left map says that " + srcL.getCode() + " is not related to " + tgtL.getCode() + " but a reverse relationship exists with type " + pair.tgt.getRelationship().toCode());
                                }
                                break;
                            }
                        }
                    }
                    continue;
                }
                for (ConceptMap.SourceElementComponent srcR : gr.getElement()) {
                    for (ConceptMap.TargetElementComponent targetElementComponent : srcR.getTarget()) {
                        if (!srcL.getCode().equals(targetElementComponent.getCode())) continue;
                        issues.add("Left map says that there is no relationship for " + srcL.getCode() + " but right map has a " + targetElementComponent.getRelationship().toCode() + " mapping to it from " + srcR.getCode());
                    }
                }
            }
        }
        for (ConceptMap.ConceptMapGroupComponent gr : right.getGroup()) {
            ConceptMap.ConceptMapGroupComponent gl = ConceptMapUtilities.findMatchingGroup(left.getGroup(), gr.getTarget(), gr.getSource());
            if (gl == null) {
                for (ConceptMap.SourceElementComponent e : gr.getElement()) {
                    for (ConceptMap.TargetElementComponent t : e.getTarget()) {
                        if (t.getRelationship() == Enumerations.ConceptMapRelationship.NOTRELATEDTO) continue;
                        if (makeChanges) {
                            changed = true;
                            left.forceGroup(gr.getTarget(), gr.getSource()).getOrAddElement(t.getCode()).addTarget(e.getCode(), ConceptMapUtilities.inverse(t.getRelationship()));
                            continue;
                        }
                        issues.add("left maps from " + gr.getSource() + "#" + e.getCode() + " to " + gr.getTarget() + "#" + t.getCode() + " but right has no matching reverse map");
                    }
                }
                continue;
            }
            for (ConceptMap.SourceElementComponent srcR : gr.getElement()) {
                if ("CHECK!".equals(srcR.getCode())) continue;
                if (!srcR.getNoMap()) {
                    block30: for (ConceptMap.TargetElementComponent tgtR : srcR.getTarget()) {
                        pairs = ConceptMapUtilities.getMappings(gl, tgtR.getCode(), srcR.getCode());
                        if (tgtR.getRelationship() == null) {
                            issues.add("Right map has relationship " + srcR.getCode() + " with no relationship");
                            continue;
                        }
                        switch (tgtR.getRelationship()) {
                            case EQUIVALENT: {
                                if (pairs.isEmpty()) {
                                    if (makeChanges) {
                                        changed = true;
                                        gl.getOrAddElement(tgtR.getCode()).addTarget(srcR.getCode(), Enumerations.ConceptMapRelationship.EQUIVALENT);
                                        break;
                                    }
                                    issues.add("Right map says that " + srcR.getCode() + " is equivalent to " + tgtR.getCode() + " but there's no reverse relationship");
                                    break;
                                }
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.EQUIVALENT) continue;
                                    issues.add("Right map says that " + srcR.getCode() + " is equivalent to " + tgtR.getCode() + " but the reverse relationship has type " + pair.tgt.getRelationship().toCode());
                                }
                                continue block30;
                            }
                            case RELATEDTO: {
                                if (pairs.isEmpty()) {
                                    issues.add("Right map says that " + srcR.getCode() + " is related to " + tgtR.getCode() + " but there's no reverse relationship");
                                    break;
                                }
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.EQUIVALENT || pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.RELATEDTO) continue;
                                    issues.add("Right map says that " + srcR.getCode() + " is equivalent to " + tgtR.getCode() + " but the reverse relationship has type " + pair.tgt.getRelationship().toCode());
                                }
                                continue block30;
                            }
                            case SOURCEISBROADERTHANTARGET: {
                                if (pairs.isEmpty()) {
                                    issues.add("Right map says that " + srcR.getCode() + " is broader than " + tgtR.getCode() + " but there's no reverse relationship");
                                    break;
                                }
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET) continue;
                                    issues.add("Right map says that " + srcR.getCode() + " is broader than " + tgtR.getCode() + " but the reverse relationship has type " + pair.tgt.getRelationship().toCode());
                                }
                                continue block30;
                            }
                            case SOURCEISNARROWERTHANTARGET: {
                                if (pairs.isEmpty()) {
                                    issues.add("Right map says that " + srcR.getCode() + " is narrower than " + tgtR.getCode() + " but there's no reverse relationship");
                                    break;
                                }
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET) continue;
                                    issues.add("Right map says that " + srcR.getCode() + " is narrower than " + tgtR.getCode() + " but the reverse relationship has type " + pair.tgt.getRelationship().toCode());
                                }
                                continue block30;
                            }
                            case NOTRELATEDTO: {
                                for (ElementMappingPair pair : pairs) {
                                    if (pair.tgt.getRelationship() == Enumerations.ConceptMapRelationship.NOTRELATEDTO) continue;
                                    issues.add("Right map says that " + srcR.getCode() + " is not related to " + tgtR.getCode() + " but a reverse relationship exists with type " + pair.tgt.getRelationship().toCode());
                                }
                                break;
                            }
                        }
                    }
                    continue;
                }
                for (ConceptMap.SourceElementComponent srcL : gr.getElement()) {
                    for (ConceptMap.TargetElementComponent targetElementComponent : srcL.getTarget()) {
                        if (!srcR.getCode().equals(targetElementComponent.getCode())) continue;
                        issues.add("Right map says that there is no relationship for " + srcR.getCode() + " but right map has a " + targetElementComponent.getRelationship().toCode() + " mapping to it from " + srcL.getCode());
                    }
                }
            }
        }
        return changed;
    }

    private static Enumerations.ConceptMapRelationship inverse(Enumerations.ConceptMapRelationship relationship) {
        switch (relationship) {
            case EQUIVALENT: {
                return Enumerations.ConceptMapRelationship.EQUIVALENT;
            }
            case RELATEDTO: {
                return Enumerations.ConceptMapRelationship.RELATEDTO;
            }
            case SOURCEISBROADERTHANTARGET: {
                return Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET;
            }
            case SOURCEISNARROWERTHANTARGET: {
                return Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET;
            }
        }
        return null;
    }

    private static boolean hasActualMappings(ConceptMap.ConceptMapGroupComponent gr) {
        for (ConceptMap.SourceElementComponent e : gr.getElement()) {
            for (ConceptMap.TargetElementComponent tgt : e.getTarget()) {
                if (tgt.getRelationship() == Enumerations.ConceptMapRelationship.NOTRELATEDTO) continue;
                return true;
            }
        }
        return false;
    }

    private static List<ElementMappingPair> getMappings(ConceptMap.ConceptMapGroupComponent g, String source, String target) {
        ArrayList<ElementMappingPair> res = new ArrayList<ElementMappingPair>();
        for (ConceptMap.SourceElementComponent src : g.getElement()) {
            for (ConceptMap.TargetElementComponent tgt : src.getTarget()) {
                if (!source.equals(src.getCode()) || !target.equals(tgt.getCode())) continue;
                res.add(new ElementMappingPair(src, tgt));
            }
        }
        return res;
    }

    private static ConceptMap.ConceptMapGroupComponent findMatchingGroup(List<ConceptMap.ConceptMapGroupComponent> groups, String source, String target) {
        for (ConceptMap.ConceptMapGroupComponent g : groups) {
            if (!source.equals(g.getSource()) || !target.equals(g.getTarget())) continue;
            return g;
        }
        return null;
    }

    public static boolean isUnityMap(ConceptMap cm) {
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent src : grp.getElement()) {
                if (src.hasNoMap()) {
                    return false;
                }
                if (src.getTarget().size() != 1) {
                    return false;
                }
                if (src.getTargetFirstRep().getRelationship() != Enumerations.ConceptMapRelationship.EQUIVALENT && src.getTargetFirstRep().getRelationship() != Enumerations.ConceptMapRelationship.RELATEDTO) {
                    return false;
                }
                if (src.getCode().equals(src.getTargetFirstRep().getCode())) continue;
                return false;
            }
        }
        return true;
    }

    public static int mapCount(ConceptMap cm) {
        int i = 0;
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent src : grp.getElement()) {
                i += src.getTarget().size();
            }
        }
        return i;
    }

    public static Set<Coding> listCodesWithNoMappings(Set<Coding> codes, ConceptMap map) {
        HashSet<Coding> res = new HashSet<Coding>();
        for (Coding c : codes) {
            if (c == null || !c.hasCode()) continue;
            boolean found = false;
            for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
                if (!ConceptMapUtilities.matchesCoding(grp, c)) continue;
                for (ConceptMap.SourceElementComponent src : grp.getElement()) {
                    if (!c.getCode().equals(src.getCode())) continue;
                    for (ConceptMap.TargetElementComponent tgt : src.getTarget()) {
                        if (tgt.getRelationship() != Enumerations.ConceptMapRelationship.RELATEDTO && tgt.getRelationship() != Enumerations.ConceptMapRelationship.EQUIVALENT && tgt.getRelationship() != Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET) continue;
                        found = true;
                    }
                }
            }
            if (found) continue;
            res.add(c);
        }
        return res;
    }

    private static boolean matchesCoding(ConceptMap.ConceptMapGroupComponent grp, Coding code) {
        return code.getSystem().equals(grp.getSource()) || (code.getSystem() + "|" + code.getVersion()).equals(grp.getSource());
    }

    public static List<String> translateCode(String name, String defaultValue, ConceptMap ... cmList) {
        List<String> res = ConceptMapUtilities.translateCode(name, cmList);
        if (res.isEmpty()) {
            res.add(defaultValue);
        }
        return res;
    }

    public static List<String> translateCode(String name, ConceptMap ... cmList) {
        List<String> res = new ArrayList<String>();
        res.add(name);
        for (ConceptMap cm : cmList) {
            res = ConceptMapUtilities.translateCodes(res, cm);
        }
        return res;
    }

    private static List<String> translateCodes(List<String> codes, ConceptMap cm) {
        ArrayList<String> res = new ArrayList<String>();
        for (ConceptMap.ConceptMapGroupComponent g : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent e : g.getElement()) {
                if (!Utilities.existsInList((String)e.getCode(), codes)) continue;
                for (ConceptMap.TargetElementComponent t : e.getTarget()) {
                    if (t.getRelationship() != Enumerations.ConceptMapRelationship.EQUIVALENT && t.getRelationship() != Enumerations.ConceptMapRelationship.RELATEDTO && t.getRelationship() != Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET && t.getRelationship() != Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET) continue;
                    res.add(t.getCode());
                }
            }
        }
        return res;
    }

    public static List<Coding> translateCoding(Coding code, ConceptMap ... cmList) {
        List<Coding> res = new ArrayList<Coding>();
        for (ConceptMap cm : cmList) {
            res = ConceptMapUtilities.translateCodings(res, cm);
        }
        return res;
    }

    private static List<Coding> translateCodings(List<Coding> codes, ConceptMap cm) {
        ArrayList<Coding> res = new ArrayList<Coding>();
        for (ConceptMap.ConceptMapGroupComponent g : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent e : g.getElement()) {
                if (!ConceptMapUtilities.hasCode(g.getSource(), e.getCode(), codes)) continue;
                for (ConceptMap.TargetElementComponent t : e.getTarget()) {
                    if (t.getRelationship() != Enumerations.ConceptMapRelationship.EQUIVALENT && t.getRelationship() != Enumerations.ConceptMapRelationship.RELATEDTO && t.getRelationship() != Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET && t.getRelationship() != Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET) continue;
                    res.add(new Coding().setSystem(g.getTarget()).setCode(t.getCode()));
                }
            }
        }
        return res;
    }

    private static boolean hasCode(String system, String code, List<Coding> codes) {
        for (Coding c : codes) {
            if (!system.equals(c.getSystem()) || !code.equals(c.getCode())) continue;
            return true;
        }
        return false;
    }

    public static List<MappingTriple> getBySource(ConceptMap map, Coding c) {
        ArrayList<MappingTriple> list = new ArrayList<MappingTriple>();
        for (ConceptMap.ConceptMapGroupComponent g : map.getGroup()) {
            if (!CanonicalType.matches(g.getSource(), c.getSystem(), c.getVersion())) continue;
            for (ConceptMap.SourceElementComponent e : g.getElement()) {
                if (!e.getCode().equals(c.getCode())) continue;
                if (e.getNoMap()) {
                    list.add(new MappingTriple(g, e, null));
                    continue;
                }
                for (ConceptMap.TargetElementComponent t : e.getTarget()) {
                    list.add(new MappingTriple(g, e, t));
                }
            }
        }
        return list;
    }

    public static List<MappingTriple> getByTarget(ConceptMap map, Coding c) {
        ArrayList<MappingTriple> list = new ArrayList<MappingTriple>();
        for (ConceptMap.ConceptMapGroupComponent g : map.getGroup()) {
            if (!CanonicalType.matches(g.getTarget(), c.getSystem(), c.getVersion())) continue;
            for (ConceptMap.SourceElementComponent e : g.getElement()) {
                for (ConceptMap.TargetElementComponent t : e.getTarget()) {
                    if (!t.getCode().equals(c.getCode())) continue;
                    list.add(new MappingTriple(g, e, t));
                }
            }
        }
        return list;
    }

    public static class ConceptMapElementSorter
    implements Comparator<ConceptMap.SourceElementComponent> {
        @Override
        public int compare(ConceptMap.SourceElementComponent o1, ConceptMap.SourceElementComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class ConceptMapTargetElementSorter
    implements Comparator<ConceptMap.TargetElementComponent> {
        @Override
        public int compare(ConceptMap.TargetElementComponent o1, ConceptMap.TargetElementComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class ElementMappingPair {
        private ConceptMap.SourceElementComponent src;
        private ConceptMap.TargetElementComponent tgt;

        public ElementMappingPair(ConceptMap.SourceElementComponent src, ConceptMap.TargetElementComponent tgt) {
            this.src = src;
            this.tgt = tgt;
        }
    }

    public static class MappingTriple {
        private ConceptMap.ConceptMapGroupComponent grp;
        private ConceptMap.SourceElementComponent src;
        private ConceptMap.TargetElementComponent tgt;

        public MappingTriple(ConceptMap.ConceptMapGroupComponent grp, ConceptMap.SourceElementComponent src, ConceptMap.TargetElementComponent tgt) {
            this.grp = grp;
            this.src = src;
            this.tgt = tgt;
        }

        public ConceptMap.ConceptMapGroupComponent getGrp() {
            return this.grp;
        }

        public ConceptMap.SourceElementComponent getSrc() {
            return this.src;
        }

        public ConceptMap.TargetElementComponent getTgt() {
            return this.tgt;
        }
    }

    public static class TranslatedCode {
        private String code;
        private Enumerations.ConceptMapRelationship relationship;

        public TranslatedCode(String code, Enumerations.ConceptMapRelationship relationship) {
            this.code = code;
            this.relationship = relationship;
        }

        public String getCode() {
            return this.code;
        }

        public Enumerations.ConceptMapRelationship getRelationship() {
            return this.relationship;
        }
    }

    public static class ElementSorter
    implements Comparator<ConceptMap.SourceElementComponent> {
        @Override
        public int compare(ConceptMap.SourceElementComponent o1, ConceptMap.SourceElementComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class TargetSorter
    implements Comparator<ConceptMap.TargetElementComponent> {
        @Override
        public int compare(ConceptMap.TargetElementComponent o1, ConceptMap.TargetElementComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }
}

