/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class ImplicitValueSets {
    private Parameters expParameters;

    public ImplicitValueSets(Parameters expParameters) {
        this.expParameters = expParameters;
    }

    public ValueSet generateImplicitValueSet(String url) {
        if (Utilities.noString((String)url)) {
            return null;
        }
        if (url.startsWith("http://snomed.info/sct")) {
            return this.generateImplicitSnomedValueSet(url, this.defaultVersion("http://snomed.info/sct"));
        }
        if (url.startsWith("http://loinc.org/vs")) {
            return this.generateImplicitLoincValueSet(url, this.defaultVersion("http://loinc.org"));
        }
        if (url.equals("http://unitsofmeasure.org/vs")) {
            return this.allUcumValueSet();
        }
        if (url.equals("http://hl7.org/fhir/ValueSet/mimetypes")) {
            return this.generateImplicitMimetypesValueSet(url);
        }
        return null;
    }

    private String defaultVersion(String url) {
        for (Parameters.ParametersParameterComponent p : this.expParameters.getParameter()) {
            String u;
            if (!"default-version".equals(p.getName()) || !(u = p.getValue().primitiveValue()).startsWith(url + "|")) continue;
            return u.substring(u.indexOf(1) + 1);
        }
        return null;
    }

    public ValueSet generateImplicitValueSet(String url, String version) {
        if (Utilities.noString((String)url)) {
            return null;
        }
        if (Utilities.noString((String)version)) {
            return this.generateImplicitValueSet(url);
        }
        if (url.startsWith("http://snomed.info/sct")) {
            return this.generateImplicitSnomedValueSet(url, version);
        }
        if (url.startsWith("http://loinc.org/vs")) {
            return this.generateImplicitLoincValueSet(url, version);
        }
        return null;
    }

    public boolean isImplicitValueSet(String url) {
        return this.isImplicitSCTValueSet(url) || this.isImplicitLoincValueSet(url) || this.isImplicitUcumValueSet(url) || this.isImplicitMimeTypesValueSet(url);
    }

    public boolean isImplicitSCTValueSet(String url) {
        return url.startsWith("http://snomed.info/sct") && url.contains("?fhir_vs");
    }

    private ValueSet generateImplicitSnomedValueSet(String url, String version) {
        String query = url.substring(url.indexOf("?") + 1);
        if ("fhir_vs".equals(query)) {
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setVersion(version);
            vs.setName("SCTValueSetAll");
            vs.setTitle("All Codes SCT ValueSet");
            vs.setDescription("Value Set for All SNOMED CT Concepts");
            vs.setCopyright("This value set includes content from SNOMED CT, which is copyright \u00a9 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement");
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.getCompose().addInclude().setSystem("http://snomed.info/sct");
            return vs;
        }
        if (query.startsWith("fhir_vs=isa/")) {
            String sct = query.substring(12);
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setVersion(version);
            vs.setName("SCTValueSetFor" + sct);
            vs.setTitle("SCT ValueSet for " + sct);
            vs.setDescription("SNOMED CT Concepts that is-a " + sct);
            vs.setCopyright("This value set includes content from SNOMED CT, which is copyright \u00a9 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement");
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.getCompose().addInclude().setSystem("http://snomed.info/sct").addFilter().setProperty("concept").setOp(Enumerations.FilterOperator.ISA).setValue(sct);
            vs.setWebPath("https://browser.ihtsdotools.org/?perspective=full&conceptId1=" + sct);
            return vs;
        }
        if (query.equals("fhir_vs=refset")) {
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setVersion(version);
            vs.setName("SCTReferenceSetList");
            vs.setTitle("SCT Reference Set List");
            vs.setDescription("SNOMED CT Reference Sets");
            vs.setCopyright("This value set includes content from SNOMED CT, which is copyright \u00a9 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement");
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.getCompose().addInclude().setSystem("http://snomed.info/sct").addFilter().setProperty("concept").setOp(Enumerations.FilterOperator.ISA).setValue("refset-base");
            return vs;
        }
        if (query.startsWith("fhir_vs=refset/")) {
            String srt = query.substring(15);
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setVersion(version);
            vs.setName("SCTRefSet" + srt);
            vs.setTitle("SCT Reference Set " + srt);
            vs.setDescription("SNOMED CT Reference Set " + srt);
            vs.setCopyright("This value set includes content from SNOMED CT, which is copyright \u00a9 2002+ International Health Terminology Standards Development Organisation (SNOMED International), and distributed by agreement between SNOMED International and HL7. Implementer use of SNOMED CT is not covered by this agreement");
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.getCompose().addInclude().setSystem("http://snomed.info/sct").addFilter().setProperty("concept").setOp(Enumerations.FilterOperator.IN).setValue(srt);
            vs.setWebPath("https://browser.ihtsdotools.org/?perspective=full&conceptId1=" + srt);
            return vs;
        }
        return null;
    }

    public boolean isImplicitLoincValueSet(String url) {
        return url.startsWith("http://loinc.org/vs");
    }

    private ValueSet generateImplicitLoincValueSet(String url, String version) {
        if (url.startsWith("http://loinc.org/vs/LL")) {
            String c = url.substring(20);
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setVersion(version);
            vs.setName("LOINCAnswers" + c);
            vs.setTitle("LOINC Answer Codes for " + c);
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setCopyright("This content LOINC\u00ae is copyright \u00a9 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use");
            vs.getCompose().addInclude().setSystem("http://loinc.org").addFilter().setProperty("LIST").setOp(Enumerations.FilterOperator.EQUAL).setValue(c);
            return vs;
        }
        if (url.startsWith("http://loinc.org/vs/LP")) {
            String c = url.substring("http://loinc.org/vs/".length());
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setVersion(version);
            vs.setName("LOINCPartList" + c);
            vs.setTitle("LOINC Codes for Part " + c);
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setCopyright("This content LOINC\u00ae is copyright \u00a9 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use");
            vs.getCompose().addInclude().setSystem("http://loinc.org").addFilter().setProperty("ancestor").setOp(Enumerations.FilterOperator.EQUAL).setValue(c);
            return vs;
        }
        if (url.equals("http://loinc.org/vs")) {
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setVersion(version);
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setName("LOINCCodes");
            vs.setTitle("All LOINC codes");
            vs.setCopyright("This content LOINC\u00ae is copyright \u00a9 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use");
            vs.getCompose().addInclude().setSystem("http://loinc.org");
            return vs;
        }
        if ("http://loinc.org/vs/valid-hl7-attachment-requests".equals(url)) {
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setVersion(version);
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setName("HL7AttachmentRequests");
            vs.setTitle("HL7 Attachment Requests");
            vs.setCopyright("This content LOINC\u00ae is copyright \u00a9 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use");
            vs.getCompose().addInclude().setSystem("http://loinc.org").addFilter().setProperty("ValidHL7AttachmentRequest").setOp(Enumerations.FilterOperator.EQUAL).setValue("Y");
            vs.setWebPath("https://loinc.org/attachments/");
            return vs;
        }
        return null;
    }

    private boolean isImplicitUcumValueSet(String url) {
        return "http://unitsofmeasure.org/vs".equals(url);
    }

    private ValueSet allUcumValueSet() {
        ValueSet vs = new ValueSet();
        vs.setUrl("http://unitsofmeasure.org/vs");
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.setName("AllUcumCodes");
        vs.setTitle("All Ucum Codes");
        vs.getCompose().addInclude().setSystem("http://unitsofmeasure.org");
        return vs;
    }

    private boolean isImplicitMimeTypesValueSet(String url) {
        return "http://hl7.org/fhir/ValueSet/mimetypes".equals(url);
    }

    private ValueSet generateImplicitMimetypesValueSet(String theUri) {
        ValueSet valueSet = new ValueSet();
        valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
        valueSet.setUrl(theUri);
        valueSet.setDescription("This value set includes all possible codes from BCP-13 (http://tools.ietf.org/html/bcp13)");
        valueSet.getCompose().addInclude().setSystem("urn:ietf:bcp:13");
        return valueSet;
    }
}

